import typing

import typing_extensions
@typing.type_check_only
class BuildBazelRemoteExecutionV2Action(typing_extensions.TypedDict, total=False):
    commandDigest: BuildBazelRemoteExecutionV2Digest
    doNotCache: bool
    inputRootDigest: BuildBazelRemoteExecutionV2Digest
    outputNodeProperties: typing.List[str]
    timeout: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2ActionResult(typing_extensions.TypedDict, total=False):
    executionMetadata: BuildBazelRemoteExecutionV2ExecutedActionMetadata
    exitCode: int
    outputDirectories: typing.List[BuildBazelRemoteExecutionV2OutputDirectory]
    outputDirectorySymlinks: typing.List[BuildBazelRemoteExecutionV2OutputSymlink]
    outputFileSymlinks: typing.List[BuildBazelRemoteExecutionV2OutputSymlink]
    outputFiles: typing.List[BuildBazelRemoteExecutionV2OutputFile]
    outputSymlinks: typing.List[BuildBazelRemoteExecutionV2OutputSymlink]
    stderrDigest: BuildBazelRemoteExecutionV2Digest
    stderrRaw: str
    stdoutDigest: BuildBazelRemoteExecutionV2Digest
    stdoutRaw: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2Command(typing_extensions.TypedDict, total=False):
    arguments: typing.List[str]
    environmentVariables: typing.List[
        BuildBazelRemoteExecutionV2CommandEnvironmentVariable
    ]
    outputDirectories: typing.List[str]
    outputFiles: typing.List[str]
    outputPaths: typing.List[str]
    platform: BuildBazelRemoteExecutionV2Platform
    workingDirectory: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2CommandEnvironmentVariable(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2Digest(typing_extensions.TypedDict, total=False):
    hash: str
    sizeBytes: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2Directory(typing_extensions.TypedDict, total=False):
    directories: typing.List[BuildBazelRemoteExecutionV2DirectoryNode]
    files: typing.List[BuildBazelRemoteExecutionV2FileNode]
    nodeProperties: typing.List[BuildBazelRemoteExecutionV2NodeProperty]
    symlinks: typing.List[BuildBazelRemoteExecutionV2SymlinkNode]

@typing.type_check_only
class BuildBazelRemoteExecutionV2DirectoryNode(
    typing_extensions.TypedDict, total=False
):
    digest: BuildBazelRemoteExecutionV2Digest
    name: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2ExecuteOperationMetadata(
    typing_extensions.TypedDict, total=False
):
    actionDigest: BuildBazelRemoteExecutionV2Digest
    stage: typing_extensions.Literal[
        "UNKNOWN", "CACHE_CHECK", "QUEUED", "EXECUTING", "COMPLETED"
    ]
    stderrStreamName: str
    stdoutStreamName: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2ExecuteResponse(
    typing_extensions.TypedDict, total=False
):
    cachedResult: bool
    message: str
    result: BuildBazelRemoteExecutionV2ActionResult
    serverLogs: typing.Dict[str, typing.Any]
    status: GoogleRpcStatus

@typing.type_check_only
class BuildBazelRemoteExecutionV2ExecutedActionMetadata(
    typing_extensions.TypedDict, total=False
):
    executionCompletedTimestamp: str
    executionStartTimestamp: str
    inputFetchCompletedTimestamp: str
    inputFetchStartTimestamp: str
    outputUploadCompletedTimestamp: str
    outputUploadStartTimestamp: str
    queuedTimestamp: str
    worker: str
    workerCompletedTimestamp: str
    workerStartTimestamp: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2FileNode(typing_extensions.TypedDict, total=False):
    digest: BuildBazelRemoteExecutionV2Digest
    isExecutable: bool
    name: str
    nodeProperties: typing.List[BuildBazelRemoteExecutionV2NodeProperty]

@typing.type_check_only
class BuildBazelRemoteExecutionV2LogFile(typing_extensions.TypedDict, total=False):
    digest: BuildBazelRemoteExecutionV2Digest
    humanReadable: bool

@typing.type_check_only
class BuildBazelRemoteExecutionV2NodeProperty(typing_extensions.TypedDict, total=False):
    name: str
    value: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2OutputDirectory(
    typing_extensions.TypedDict, total=False
):
    path: str
    treeDigest: BuildBazelRemoteExecutionV2Digest

@typing.type_check_only
class BuildBazelRemoteExecutionV2OutputFile(typing_extensions.TypedDict, total=False):
    contents: str
    digest: BuildBazelRemoteExecutionV2Digest
    isExecutable: bool
    nodeProperties: typing.List[BuildBazelRemoteExecutionV2NodeProperty]
    path: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2OutputSymlink(
    typing_extensions.TypedDict, total=False
):
    nodeProperties: typing.List[BuildBazelRemoteExecutionV2NodeProperty]
    path: str
    target: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2Platform(typing_extensions.TypedDict, total=False):
    properties: typing.List[BuildBazelRemoteExecutionV2PlatformProperty]

@typing.type_check_only
class BuildBazelRemoteExecutionV2PlatformProperty(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2RequestMetadata(
    typing_extensions.TypedDict, total=False
):
    actionId: str
    correlatedInvocationsId: str
    toolDetails: BuildBazelRemoteExecutionV2ToolDetails
    toolInvocationId: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2SymlinkNode(typing_extensions.TypedDict, total=False):
    name: str
    nodeProperties: typing.List[BuildBazelRemoteExecutionV2NodeProperty]
    target: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2ToolDetails(typing_extensions.TypedDict, total=False):
    toolName: str
    toolVersion: str

@typing.type_check_only
class BuildBazelRemoteExecutionV2Tree(typing_extensions.TypedDict, total=False):
    children: typing.List[BuildBazelRemoteExecutionV2Directory]
    root: BuildBazelRemoteExecutionV2Directory

@typing.type_check_only
class GoogleDevtoolsRemotebuildbotCommandDurations(
    typing_extensions.TypedDict, total=False
):
    dockerPrep: str
    dockerPrepStartTime: str
    download: str
    downloadStartTime: str
    execStartTime: str
    execution: str
    isoPrepDone: str
    overall: str
    stdout: str
    upload: str
    uploadStartTime: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildbotCommandEvents(
    typing_extensions.TypedDict, total=False
):
    dockerCacheHit: bool
    dockerImageName: str
    inputCacheMiss: float
    numErrors: str
    numWarnings: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildbotCommandStatus(
    typing_extensions.TypedDict, total=False
):
    code: typing_extensions.Literal[
        "OK",
        "INVALID_ARGUMENT",
        "DEADLINE_EXCEEDED",
        "NOT_FOUND",
        "PERMISSION_DENIED",
        "INTERNAL",
        "ABORTED",
        "FAILED_PRECONDITION",
        "CLEANUP_ERROR",
        "DOWNLOAD_INPUTS_ERROR",
        "UNKNOWN",
        "UPLOAD_OUTPUTS_ERROR",
        "UPLOAD_OUTPUTS_BYTES_LIMIT_EXCEEDED",
        "DOCKER_LOGIN_ERROR",
        "DOCKER_IMAGE_PULL_ERROR",
        "DOCKER_IMAGE_EXIST_ERROR",
        "DUPLICATE_INPUTS",
        "DOCKER_IMAGE_PERMISSION_DENIED",
        "DOCKER_IMAGE_NOT_FOUND",
        "WORKING_DIR_NOT_FOUND",
        "WORKING_DIR_NOT_IN_BASE_DIR",
        "DOCKER_UNAVAILABLE",
        "NO_CUDA_CAPABLE_DEVICE",
        "REMOTE_CAS_DOWNLOAD_ERROR",
        "REMOTE_CAS_UPLOAD_ERROR",
        "LOCAL_CASPROXY_NOT_RUNNING",
        "DOCKER_CREATE_CONTAINER_ERROR",
        "DOCKER_INVALID_ULIMIT",
        "DOCKER_UNKNOWN_RUNTIME",
        "DOCKER_UNKNOWN_CAPABILITY",
        "DOCKER_UNKNOWN_ERROR",
        "DOCKER_CREATE_COMPUTE_SYSTEM_ERROR",
        "DOCKER_PREPARELAYER_ERROR",
        "DOCKER_INCOMPATIBLE_OS_ERROR",
        "DOCKER_CREATE_RUNTIME_FILE_NOT_FOUND",
        "DOCKER_CREATE_RUNTIME_PERMISSION_DENIED",
        "DOCKER_CREATE_PROCESS_FILE_NOT_FOUND",
        "DOCKER_CREATE_COMPUTE_SYSTEM_INCORRECT_PARAMETER_ERROR",
    ]
    message: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildbotResourceUsage(
    typing_extensions.TypedDict, total=False
):
    cpuUsedPercent: float
    diskUsage: GoogleDevtoolsRemotebuildbotResourceUsageStat
    memoryUsage: GoogleDevtoolsRemotebuildbotResourceUsageStat

@typing.type_check_only
class GoogleDevtoolsRemotebuildbotResourceUsageStat(
    typing_extensions.TypedDict, total=False
):
    total: str
    used: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaAcceleratorConfig(
    typing_extensions.TypedDict, total=False
):
    acceleratorCount: str
    acceleratorType: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaAutoscale(
    typing_extensions.TypedDict, total=False
):
    maxSize: str
    minSize: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaCreateInstanceRequest(
    typing_extensions.TypedDict, total=False
):
    instance: GoogleDevtoolsRemotebuildexecutionAdminV1alphaInstance
    instanceId: str
    parent: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaCreateWorkerPoolRequest(
    typing_extensions.TypedDict, total=False
):
    parent: str
    poolId: str
    workerPool: GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerPool

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaDeleteInstanceRequest(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaDeleteWorkerPoolRequest(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicy(
    typing_extensions.TypedDict, total=False
):
    containerImageSources: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerAddCapabilities: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerChrootPath: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerNetwork: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerPrivileged: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerRunAsRoot: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerRuntime: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    dockerSiblingContainers: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature
    linuxIsolation: typing_extensions.Literal[
        "LINUX_ISOLATION_UNSPECIFIED", "GVISOR", "OFF"
    ]

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicyFeature(
    typing_extensions.TypedDict, total=False
):
    allowedValues: typing.List[str]
    policy: typing_extensions.Literal[
        "POLICY_UNSPECIFIED", "ALLOWED", "FORBIDDEN", "RESTRICTED"
    ]

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaGetInstanceRequest(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaGetWorkerPoolRequest(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaInstance(
    typing_extensions.TypedDict, total=False
):
    featurePolicy: GoogleDevtoolsRemotebuildexecutionAdminV1alphaFeaturePolicy
    location: str
    loggingEnabled: bool
    name: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED", "CREATING", "RUNNING", "INACTIVE"
    ]

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaListInstancesRequest(
    typing_extensions.TypedDict, total=False
):
    parent: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaListInstancesResponse(
    typing_extensions.TypedDict, total=False
):
    instances: typing.List[GoogleDevtoolsRemotebuildexecutionAdminV1alphaInstance]

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaListWorkerPoolsRequest(
    typing_extensions.TypedDict, total=False
):
    filter: str
    parent: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaListWorkerPoolsResponse(
    typing_extensions.TypedDict, total=False
):
    workerPools: typing.List[GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerPool]

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaSoleTenancyConfig(
    typing_extensions.TypedDict, total=False
):
    nodeType: str
    nodesZone: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaUpdateInstanceRequest(
    typing_extensions.TypedDict, total=False
):
    instance: GoogleDevtoolsRemotebuildexecutionAdminV1alphaInstance
    loggingEnabled: bool
    name: str
    updateMask: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaUpdateWorkerPoolRequest(
    typing_extensions.TypedDict, total=False
):
    updateMask: str
    workerPool: GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerPool

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerConfig(
    typing_extensions.TypedDict, total=False
):
    accelerator: GoogleDevtoolsRemotebuildexecutionAdminV1alphaAcceleratorConfig
    diskSizeGb: str
    diskType: str
    labels: typing.Dict[str, typing.Any]
    machineType: str
    maxConcurrentActions: str
    minCpuPlatform: str
    networkAccess: str
    reserved: bool
    soleTenancy: GoogleDevtoolsRemotebuildexecutionAdminV1alphaSoleTenancyConfig
    vmImage: str

@typing.type_check_only
class GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerPool(
    typing_extensions.TypedDict, total=False
):
    autoscale: GoogleDevtoolsRemotebuildexecutionAdminV1alphaAutoscale
    channel: str
    name: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED", "CREATING", "RUNNING", "UPDATING", "DELETING", "INACTIVE"
    ]
    workerConfig: GoogleDevtoolsRemotebuildexecutionAdminV1alphaWorkerConfig
    workerCount: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2AdminTemp(
    typing_extensions.TypedDict, total=False
):
    arg: str
    command: typing_extensions.Literal[
        "UNSPECIFIED", "BOT_UPDATE", "BOT_RESTART", "BOT_TERMINATE", "HOST_RESTART"
    ]

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2Blob(typing_extensions.TypedDict, total=False):
    contents: str
    digest: GoogleDevtoolsRemoteworkersV1test2Digest

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandOutputs(
    typing_extensions.TypedDict, total=False
):
    exitCode: int
    outputs: GoogleDevtoolsRemoteworkersV1test2Digest

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandOverhead(
    typing_extensions.TypedDict, total=False
):
    duration: str
    overhead: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandResult(
    typing_extensions.TypedDict, total=False
):
    duration: str
    exitCode: int
    metadata: typing.List[typing.Dict[str, typing.Any]]
    outputs: GoogleDevtoolsRemoteworkersV1test2Digest
    overhead: str
    status: GoogleRpcStatus

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandTask(
    typing_extensions.TypedDict, total=False
):
    expectedOutputs: GoogleDevtoolsRemoteworkersV1test2CommandTaskOutputs
    inputs: GoogleDevtoolsRemoteworkersV1test2CommandTaskInputs
    timeouts: GoogleDevtoolsRemoteworkersV1test2CommandTaskTimeouts

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandTaskInputs(
    typing_extensions.TypedDict, total=False
):
    arguments: typing.List[str]
    environmentVariables: typing.List[
        GoogleDevtoolsRemoteworkersV1test2CommandTaskInputsEnvironmentVariable
    ]
    files: typing.List[GoogleDevtoolsRemoteworkersV1test2Digest]
    inlineBlobs: typing.List[GoogleDevtoolsRemoteworkersV1test2Blob]
    workingDirectory: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandTaskInputsEnvironmentVariable(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandTaskOutputs(
    typing_extensions.TypedDict, total=False
):
    directories: typing.List[str]
    files: typing.List[str]
    stderrDestination: str
    stdoutDestination: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2CommandTaskTimeouts(
    typing_extensions.TypedDict, total=False
):
    execution: str
    idle: str
    shutdown: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2Digest(
    typing_extensions.TypedDict, total=False
):
    hash: str
    sizeBytes: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2Directory(
    typing_extensions.TypedDict, total=False
):
    directories: typing.List[GoogleDevtoolsRemoteworkersV1test2DirectoryMetadata]
    files: typing.List[GoogleDevtoolsRemoteworkersV1test2FileMetadata]

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2DirectoryMetadata(
    typing_extensions.TypedDict, total=False
):
    digest: GoogleDevtoolsRemoteworkersV1test2Digest
    path: str

@typing.type_check_only
class GoogleDevtoolsRemoteworkersV1test2FileMetadata(
    typing_extensions.TypedDict, total=False
):
    contents: str
    digest: GoogleDevtoolsRemoteworkersV1test2Digest
    isExecutable: bool
    path: str

@typing.type_check_only
class GoogleLongrunningOperation(typing_extensions.TypedDict, total=False):
    done: bool
    error: GoogleRpcStatus
    metadata: typing.Dict[str, typing.Any]
    name: str
    response: typing.Dict[str, typing.Any]

@typing.type_check_only
class GoogleRpcStatus(typing_extensions.TypedDict, total=False):
    code: int
    details: typing.List[typing.Dict[str, typing.Any]]
    message: str
