import typing

import typing_extensions

_list = list

@typing.type_check_only
class GoogleIamV1Binding(typing_extensions.TypedDict, total=False):
    condition: GoogleTypeExpr
    members: _list[str]
    role: str

@typing.type_check_only
class GoogleIdentityStsV1AccessBoundary(typing_extensions.TypedDict, total=False):
    accessBoundaryRules: _list[GoogleIdentityStsV1AccessBoundaryRule]

@typing.type_check_only
class GoogleIdentityStsV1AccessBoundaryRule(typing_extensions.TypedDict, total=False):
    availabilityCondition: GoogleTypeExpr
    availablePermissions: _list[str]
    availableResource: str

@typing.type_check_only
class GoogleIdentityStsV1ExchangeOauthTokenRequest(
    typing_extensions.TypedDict, total=False
):
    clientId: str
    code: str
    codeVerifier: str
    grantType: str
    redirectUri: str
    refreshToken: str
    scope: str

@typing.type_check_only
class GoogleIdentityStsV1ExchangeOauthTokenResponse(
    typing_extensions.TypedDict, total=False
):
    access_token: str
    expires_in: int
    refresh_token: str
    scope: str
    token_type: str

@typing.type_check_only
class GoogleIdentityStsV1ExchangeTokenRequest(typing_extensions.TypedDict, total=False):
    audience: str
    grantType: str
    options: str
    requestedTokenType: str
    scope: str
    subjectToken: str
    subjectTokenType: str

@typing.type_check_only
class GoogleIdentityStsV1ExchangeTokenResponse(
    typing_extensions.TypedDict, total=False
):
    access_token: str
    expires_in: int
    issued_token_type: str
    token_type: str

@typing.type_check_only
class GoogleIdentityStsV1IntrospectTokenRequest(
    typing_extensions.TypedDict, total=False
):
    token: str
    tokenTypeHint: str

@typing.type_check_only
class GoogleIdentityStsV1IntrospectTokenResponse(
    typing_extensions.TypedDict, total=False
):
    active: bool
    client_id: str
    exp: str
    iat: str
    iss: str
    scope: str
    sub: str
    username: str

@typing.type_check_only
class GoogleIdentityStsV1Options(typing_extensions.TypedDict, total=False):
    accessBoundary: GoogleIdentityStsV1AccessBoundary
    audiences: _list[str]
    userProject: str

@typing.type_check_only
class GoogleIdentityStsV1betaAccessBoundary(typing_extensions.TypedDict, total=False):
    accessBoundaryRules: _list[GoogleIdentityStsV1betaAccessBoundaryRule]

@typing.type_check_only
class GoogleIdentityStsV1betaAccessBoundaryRule(
    typing_extensions.TypedDict, total=False
):
    availabilityCondition: GoogleTypeExpr
    availablePermissions: _list[str]
    availableResource: str

@typing.type_check_only
class GoogleIdentityStsV1betaOptions(typing_extensions.TypedDict, total=False):
    accessBoundary: GoogleIdentityStsV1betaAccessBoundary
    audiences: _list[str]
    userProject: str

@typing.type_check_only
class GoogleTypeExpr(typing_extensions.TypedDict, total=False):
    description: str
    expression: str
    location: str
    title: str
