from _typeshed import Incomplete

from googleapiclient.errors import (
    BatchError as BatchError,
    HttpError as HttpError,
    InvalidChunkSizeError as InvalidChunkSizeError,
    ResumableUploadError as ResumableUploadError,
    UnexpectedBodyError as UnexpectedBodyError,
    UnexpectedMethodError as UnexpectedMethodError,
)
from googleapiclient.model import JsonModel as JsonModel

LOGGER: Incomplete
DEFAULT_CHUNK_SIZE: Incomplete
MAX_URI_LENGTH: int
MAX_BATCH_LIMIT: int
DEFAULT_HTTP_TIMEOUT_SEC: int

class MediaUploadProgress:
    resumable_progress: Incomplete
    total_size: Incomplete
    def __init__(self, resumable_progress, total_size) -> None: ...
    def progress(self): ...

class MediaDownloadProgress:
    resumable_progress: Incomplete
    total_size: Incomplete
    def __init__(self, resumable_progress, total_size) -> None: ...
    def progress(self): ...

class MediaUpload:
    def chunksize(self) -> None: ...
    def mimetype(self): ...
    def size(self) -> None: ...
    def resumable(self): ...
    def getbytes(self, begin, end) -> None: ...
    def has_stream(self): ...
    def stream(self) -> None: ...
    def to_json(self): ...
    @classmethod
    def new_from_json(cls, s): ...

class MediaIoBaseUpload(MediaUpload):
    def __init__(self, fd, mimetype, chunksize=..., resumable: bool = ...) -> None: ...
    def chunksize(self): ...
    def mimetype(self): ...
    def size(self): ...
    def resumable(self): ...
    def getbytes(self, begin, length): ...
    def has_stream(self): ...
    def stream(self): ...
    def to_json(self) -> None: ...

class MediaFileUpload(MediaIoBaseUpload):
    def __init__(
        self,
        filename,
        mimetype: Incomplete | None = ...,
        chunksize=...,
        resumable: bool = ...,
    ) -> None: ...
    def __del__(self) -> None: ...
    def to_json(self): ...
    @staticmethod
    def from_json(s): ...

class MediaInMemoryUpload(MediaIoBaseUpload):
    def __init__(
        self, body, mimetype: str = ..., chunksize=..., resumable: bool = ...
    ) -> None: ...

class MediaIoBaseDownload:
    def __init__(self, fd, request, chunksize=...) -> None: ...
    def next_chunk(self, num_retries: int = ...): ...

class _StreamSlice:
    def __init__(self, stream, begin, chunksize) -> None: ...
    def read(self, n: int = ...): ...

class HttpRequest:
    uri: Incomplete
    method: Incomplete
    body: Incomplete
    headers: Incomplete
    methodId: Incomplete
    http: Incomplete
    postproc: Incomplete
    resumable: Incomplete
    response_callbacks: Incomplete
    body_size: Incomplete
    resumable_uri: Incomplete
    resumable_progress: int
    def __init__(
        self,
        http,
        postproc,
        uri,
        method: str = ...,
        body: Incomplete | None = ...,
        headers: Incomplete | None = ...,
        methodId: Incomplete | None = ...,
        resumable: Incomplete | None = ...,
    ) -> None: ...
    def execute(self, http: Incomplete | None = ..., num_retries: int = ...): ...
    def add_response_callback(self, cb) -> None: ...
    def next_chunk(self, http: Incomplete | None = ..., num_retries: int = ...): ...
    def to_json(self): ...
    @staticmethod
    def from_json(s, http, postproc): ...
    @staticmethod
    def null_postproc(resp, contents): ...

class BatchHttpRequest:
    def __init__(
        self, callback: Incomplete | None = ..., batch_uri: Incomplete | None = ...
    ) -> None: ...
    def add(
        self,
        request,
        callback: Incomplete | None = ...,
        request_id: Incomplete | None = ...,
    ) -> None: ...
    def execute(self, http: Incomplete | None = ...) -> None: ...

class HttpRequestMock:
    resp: Incomplete
    content: Incomplete
    postproc: Incomplete
    def __init__(self, resp, content, postproc) -> None: ...
    def execute(self, http: Incomplete | None = ...): ...

class RequestMockBuilder:
    responses: Incomplete
    check_unexpected: Incomplete
    def __init__(self, responses, check_unexpected: bool = ...) -> None: ...
    def __call__(
        self,
        http,
        postproc,
        uri,
        method: str = ...,
        body: Incomplete | None = ...,
        headers: Incomplete | None = ...,
        methodId: Incomplete | None = ...,
        resumable: Incomplete | None = ...,
    ): ...

class HttpMock:
    data: Incomplete
    response_headers: Incomplete
    headers: Incomplete
    uri: Incomplete
    method: Incomplete
    body: Incomplete
    def __init__(
        self, filename: Incomplete | None = ..., headers: Incomplete | None = ...
    ) -> None: ...
    def request(
        self,
        uri,
        method: str = ...,
        body: Incomplete | None = ...,
        headers: Incomplete | None = ...,
        redirections: int = ...,
        connection_type: Incomplete | None = ...,
    ): ...
    def close(self) -> None: ...

class HttpMockSequence:
    follow_redirects: bool
    request_sequence: Incomplete
    def __init__(self, iterable) -> None: ...
    def request(
        self,
        uri,
        method: str = ...,
        body: Incomplete | None = ...,
        headers: Incomplete | None = ...,
        redirections: int = ...,
        connection_type: Incomplete | None = ...,
    ): ...

def set_user_agent(http, user_agent): ...
def tunnel_patch(http): ...
def build_http(): ...
