from _typeshed import Incomplete

class Error(Exception): ...

class HttpError(Error):
    resp: Incomplete
    content: Incomplete
    uri: Incomplete
    error_details: str
    reason: Incomplete
    def __init__(self, resp, content, uri: Incomplete | None = None) -> None: ...
    @property
    def status_code(self): ...

class InvalidJsonError(Error): ...
class UnknownFileType(Error): ...
class UnknownLinkType(Error): ...
class UnknownApiNameOrVersion(Error): ...
class UnacceptableMimeTypeError(Error): ...
class MediaUploadSizeError(Error): ...
class ResumableUploadError(HttpError): ...
class InvalidChunkSizeError(Error): ...
class InvalidNotificationError(Error): ...

class BatchError(HttpError):
    resp: Incomplete
    content: Incomplete
    reason: Incomplete
    def __init__(
        self, reason, resp: Incomplete | None = None, content: Incomplete | None = None
    ) -> None: ...

class UnexpectedMethodError(Error):
    def __init__(self, methodId: Incomplete | None = None) -> None: ...

class UnexpectedBodyError(Error):
    def __init__(self, expected, provided) -> None: ...
