import typing

import typing_extensions

_list = list

@typing.type_check_only
class AuditConfig(typing_extensions.TypedDict, total=False):
    auditLogConfigs: _list[AuditLogConfig]
    service: str

@typing.type_check_only
class AuditLogConfig(typing_extensions.TypedDict, total=False):
    exemptedMembers: _list[str]
    logType: typing_extensions.Literal[
        "LOG_TYPE_UNSPECIFIED", "ADMIN_READ", "DATA_WRITE", "DATA_READ"
    ]

@typing.type_check_only
class Binding(typing_extensions.TypedDict, total=False):
    condition: Expr
    members: _list[str]
    role: str

@typing.type_check_only
class CancelOperationRequest(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class Empty(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class Expr(typing_extensions.TypedDict, total=False):
    description: str
    expression: str
    location: str
    title: str

@typing.type_check_only
class ListLocationsResponse(typing_extensions.TypedDict, total=False):
    locations: _list[Location]
    nextPageToken: str

@typing.type_check_only
class ListManagementServersResponse(typing_extensions.TypedDict, total=False):
    managementServers: _list[ManagementServer]
    nextPageToken: str
    unreachable: _list[str]

@typing.type_check_only
class ListOperationsResponse(typing_extensions.TypedDict, total=False):
    nextPageToken: str
    operations: _list[Operation]

@typing.type_check_only
class Location(typing_extensions.TypedDict, total=False):
    displayName: str
    labels: dict[str, typing.Any]
    locationId: str
    metadata: dict[str, typing.Any]
    name: str

@typing.type_check_only
class ManagementServer(typing_extensions.TypedDict, total=False):
    createTime: str
    description: str
    etag: str
    labels: dict[str, typing.Any]
    managementUri: ManagementURI
    name: str
    networks: _list[NetworkConfig]
    oauth2ClientId: str
    state: typing_extensions.Literal[
        "INSTANCE_STATE_UNSPECIFIED",
        "CREATING",
        "READY",
        "UPDATING",
        "DELETING",
        "REPAIRING",
        "MAINTENANCE",
        "ERROR",
    ]
    type: typing_extensions.Literal["INSTANCE_TYPE_UNSPECIFIED", "BACKUP_RESTORE"]
    updateTime: str
    workforceIdentityBasedManagementUri: WorkforceIdentityBasedManagementURI
    workforceIdentityBasedOauth2ClientId: WorkforceIdentityBasedOAuth2ClientID

@typing.type_check_only
class ManagementURI(typing_extensions.TypedDict, total=False):
    api: str
    webUi: str

@typing.type_check_only
class NetworkConfig(typing_extensions.TypedDict, total=False):
    network: str
    peeringMode: typing_extensions.Literal[
        "PEERING_MODE_UNSPECIFIED", "PRIVATE_SERVICE_ACCESS"
    ]

@typing.type_check_only
class Operation(typing_extensions.TypedDict, total=False):
    done: bool
    error: Status
    metadata: dict[str, typing.Any]
    name: str
    response: dict[str, typing.Any]

@typing.type_check_only
class OperationMetadata(typing_extensions.TypedDict, total=False):
    additionalInfo: dict[str, typing.Any]
    apiVersion: str
    createTime: str
    endTime: str
    requestedCancellation: bool
    statusMessage: str
    target: str
    verb: str

@typing.type_check_only
class Policy(typing_extensions.TypedDict, total=False):
    auditConfigs: _list[AuditConfig]
    bindings: _list[Binding]
    etag: str
    version: int

@typing.type_check_only
class SetIamPolicyRequest(typing_extensions.TypedDict, total=False):
    policy: Policy
    updateMask: str

@typing.type_check_only
class Status(typing_extensions.TypedDict, total=False):
    code: int
    details: _list[dict[str, typing.Any]]
    message: str

@typing.type_check_only
class TestIamPermissionsRequest(typing_extensions.TypedDict, total=False):
    permissions: _list[str]

@typing.type_check_only
class TestIamPermissionsResponse(typing_extensions.TypedDict, total=False):
    permissions: _list[str]

@typing.type_check_only
class WorkforceIdentityBasedManagementURI(typing_extensions.TypedDict, total=False):
    firstPartyManagementUri: str
    thirdPartyManagementUri: str

@typing.type_check_only
class WorkforceIdentityBasedOAuth2ClientID(typing_extensions.TypedDict, total=False):
    firstPartyOauth2ClientId: str
    thirdPartyOauth2ClientId: str
