import typing

import typing_extensions

_list = list

@typing.type_check_only
class AbuseiamAbuseType(typing_extensions.TypedDict, total=False):
    id: typing_extensions.Literal[
        "NONE",
        "OTHER_ABUSE",
        "CHILD_PORN",
        "PORNOGRAPHY",
        "SPAM",
        "PHISHING",
        "HATE",
        "TOS_OTHER",
        "MALWARE",
        "MALICIOUS_JAVASCRIPT",
        "NOT_FAMILY_SAFE",
        "IMPERSONATION",
        "PEDOPHILIA",
        "PERSONAL_INFO",
        "COPYRIGHT",
        "HIGH_RISK",
        "VIOLENCE",
        "UNSAFE_RACY",
        "UNSAFE_OTHER",
        "FAKE_USER",
        "NAME_VIOLATION",
        "PLUSONE_VIOLATION",
        "DEFAMATION",
        "TRADEMARK",
        "COURT_ORDER",
        "GOVERNMENT_ORDER",
        "LOCAL_LAWS",
        "PRIVACY",
        "ES_BLACKLIST",
        "ES_COMMENTS_BLACKLIST",
        "HARASSMENT",
        "COMPROMISED",
        "LOW_QUALITY",
        "API_VIOLATION",
        "REGULATED",
        "CAROUSEL_FRAME_BLACKLIST",
        "QUOTA_EXCEEDED",
        "FOUNTAIN_BLACKLIST",
        "COPPA_REGULATED",
        "DOXXING",
        "SOFT_HATE",
        "SOFT_HARASSMENT",
        "OBNOXIOUS",
        "UNWANTED",
        "NOT_UNICORN_SAFE",
        "FAKE_ENGAGEMENT",
        "COUNTERFEIT",
        "CTM",
    ]
    subtype: str

@typing.type_check_only
class AbuseiamAgeRestriction(typing_extensions.TypedDict, total=False):
    ageYears: int
    minAgeYears: int

@typing.type_check_only
class AbuseiamAndRestriction(typing_extensions.TypedDict, total=False):
    child: _list[AbuseiamUserRestriction]

@typing.type_check_only
class AbuseiamClient(typing_extensions.TypedDict, total=False):
    id: typing_extensions.Literal[
        "ABUSE_TEAM",
        "SQE",
        "SEARCH",
        "POSTINI",
        "BLOGGER",
        "ORKUT",
        "ZIPIT",
        "GROUPS",
        "RIPTIDE",
        "GADGETS",
        "SITES",
        "READER",
        "DOCS",
        "U2U",
        "YOUTUBE",
        "POPTART",
        "COSMO",
        "PROFILES",
        "KNOL",
        "SKETCHUP",
        "CALENDAR",
        "HOTSHOTS",
        "TRIKI",
        "MAPS",
        "COMMUNITY_TRANSLATION",
        "WRITELY",
        "SPREADSHEET_FORM",
        "SPREADSHEET",
        "EXPLORER",
        "FINANCE",
        "GMR",
        "LAIBA",
        "CONFUCIUS",
        "PRESENTATION",
        "CHROME_EXTENSION",
        "WENDA",
        "TACOTOWN",
        "KRAKEN",
        "URL_SHORTENER",
        "WAREHOUSE",
        "ANDROID_VM",
        "CODESITE",
        "FRIEND_CONNECT",
        "GEOWIKI",
        "GOOGLE_LABS",
        "HELP_CENTER",
        "SEARCHWIKI",
        "SIDEWIKI",
        "TOPIC_SEARCH",
        "VIDEO",
        "GOOGLEBASE",
        "FEEDBURNER",
        "PUBLISHER_QUALITY",
        "NOTEBOOK",
        "SMARTLISTS",
        "ENTERPRISE_MARKETPLACE",
        "BOOKS",
        "IGOOGLE",
        "USENET",
        "TRANSLATE",
        "PERFECT_STREAM",
        "PHOTOS",
        "AFMA",
        "LIKES",
        "QUESTIONS",
        "SKYJAM",
        "MIC",
        "ANDROID_MARKET",
        "CHROME_WEBSTORE",
        "FINSKY",
        "BARNOWL",
        "STREET_VIEW",
        "ADCONNECT",
        "ES",
        "HELLO",
        "TRADER",
        "SCHEMER",
        "ANDROID",
        "MINE",
        "GAIA",
        "GOGGLES",
        "SIGNUP",
        "BABEL",
        "CHECKOUT",
        "TASTEMAKER",
        "STRATUS",
        "DRAGONFLY",
        "APIARY",
        "CAROUSEL",
        "FOUNTAIN",
        "GEOPIX",
        "VILLAGE",
        "KIX",
        "AMARNA",
        "GINKGO",
        "TEE",
        "SHOPPING",
        "SLAM",
        "APPENGINE",
        "GUNS",
        "CULTURAL",
        "COMPUTEENGINE",
        "BIGSTORE",
        "COPACABANA",
        "ANALYTICS",
        "GRANDCENTRAL",
        "GMAIL",
        "GLASS",
        "CRISIS_RESPONSE",
        "GJOBS",
        "HAZMAT",
        "SAFE_BROWSING",
        "CLOUD",
        "PANTHEON",
        "CLUSTER",
        "KEEP",
        "APP_HISTORY",
        "COMMERCIAL_ENTITY",
        "ARES_DATA_PROVIDER",
        "ARES_DATA_WRITER",
        "BIZBUILDER",
        "RITZ",
        "POLLS",
        "APPINVITE",
    ]
    subservice: str

@typing.type_check_only
class AbuseiamClusterEvaluationContext(typing_extensions.TypedDict, total=False):
    clusterFamily: str
    clusterRowkey: str
    gaiaIdToEscalate: str

@typing.type_check_only
class AbuseiamConstantRestriction(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal["ALWAYS_TRUE", "ALWAYS_FALSE"]

@typing.type_check_only
class AbuseiamContentRestriction(typing_extensions.TypedDict, total=False):
    adminVerdict: _list[AbuseiamVerdict]
    userVerdict: _list[AbuseiamVerdict]

@typing.type_check_only
class AbuseiamEvaluation(typing_extensions.TypedDict, total=False):
    abuseType: AbuseiamAbuseType
    backend: typing_extensions.Literal[
        "UNKNOWN",
        "ADMIN",
        "GRADS",
        "OCELOT",
        "SPAMIAM",
        "MANUAL_REVIEW",
        "MAWLER",
        "SNEAKY_JS",
        "DOWNLOADER",
        "PORN_CLASSIFIER",
        "GIBBERISH_DETECTOR",
        "ANTIVIRUS",
        "GAUSS",
        "REALUSERS",
        "USERRANK",
        "GRADS_AGGRESSIVE",
        "BULK_ACTION",
        "BADWORD",
        "GAIA",
        "LINKS_COUNT",
        "RE_RULE",
        "SLAM",
        "AUTHORRANK",
        "USERRANK_BADNESS",
        "GAUSS_EXPLICIT",
        "GAUSS_IMPLICIT",
        "RETRIEVE_MESSAGE",
        "SPAM_REPORT",
        "SQUEAL",
        "BLOGGER_LOGS",
        "TRUSTRANK_PHISHING",
        "CATFOOD",
        "IMAGE_PORN_CLASSIFIER",
        "OCELOT_IMPORT",
        "FIFE_IMAGE_FETCHER",
        "FAST_RISING_FEATURES",
        "BOTGUARD",
        "NAME_CHECKER",
        "CHEETAH",
        "GALLIFREY",
        "OCELOT_DELETE",
        "RULE",
        "FOCUS",
        "VIDEO_THUMBNAILER",
        "PATTERNLIST",
        "METADATA",
        "METADATA_IMPORT",
        "NAME_DETECTOR",
        "SHINGLE_COMPUTER",
        "WIGGUM",
        "BINARY_EXPLORATION",
        "REVNET",
        "FURS",
        "YOUTUBE_CLASSIFIER",
        "IDV",
        "CLUSTERCAT",
        "CHEETAH_IMPORT",
        "CHEETAH_READ",
        "BOTGUARD_DECODE",
        "QUOTASERVER",
        "YOUTUBE",
        "BLOGGER",
        "SOCIAL_GRAPH",
        "WEB_SIGNALS",
        "TRAWLER",
        "NOTIFICATIONS",
        "CASES",
        "BADURLS",
        "LINK_IMPORT",
        "SHINGLE_DEDUPER",
        "DEV_CONSOLE",
        "METADATA_QUERY",
        "PLUS_PAGE",
        "YOUTUBE_VIDEO_INFO",
        "GOOGLE_ADMIN",
        "RESPAY",
        "COOKBOOK",
        "EASY_LEARN",
        "QUALITY_SAMPLER",
        "BLOBSTORE",
        "OWNER",
        "POLICY",
        "EXTERNAL",
        "ABUSEIAM_FEEDBACK",
        "BIGSTORE",
        "PHOTO_SERVICE",
        "GRADS_RELATED",
        "REAPER",
        "GATEKEEPER",
        "VIPER",
        "MSISDN",
        "VIDEO_REVIEW",
        "CSAI_MATCH",
        "REDQUEEN",
        "STREAMER_INDEXER",
        "DREMEL",
        "VISUAL_SEARCH_SERVICE_PORN",
        "VISUAL_SEARCH_SERVICE_OCR",
        "IMPLICIT_SOCIAL_GRAPH",
        "EASY_LEARN_BLEND",
        "USER_AURA",
        "GOOPS",
        "ANDROID_CHECKIN",
        "ARES_DATA_PROVIDER",
        "DROIDGUARD_VERDICT",
        "ARES_DATA_WRITER",
        "ADAPTIVE_QUOTA",
        "AIAPLX",
        "INFAME",
        "ARES",
        "VISUAL_SEARCH_SERVICE_ICA",
        "VISUAL_SEARCH_SERVICE_BUTTON_DETECTION",
        "VISUAL_SEARCH_SERVICE_LOGO_DETECTION",
    ]
    clusterEvaluationContext: AbuseiamClusterEvaluationContext
    comment: str
    feature: _list[AbuseiamFeature]
    manualReviewInfo: AbuseiamManualReviewEvaluationInfo
    miscData: _list[AbuseiamNameValuePair]
    processTimeMillisecs: str
    processedMicros: str
    region: _list[AbuseiamRegion]
    score: float
    status: typing_extensions.Literal["OK", "ERROR"]
    target: AbuseiamTarget
    timestampMicros: str
    userRestriction: AbuseiamUserRestriction
    version: str
    videoReviewData: AbuseiamVideoReviewData

@typing.type_check_only
class AbuseiamFeature(typing_extensions.TypedDict, total=False):
    booleanValue: bool
    doubleValue: float
    featureCount: str
    int64Value: str
    integerValue: int
    name: str
    stringValue: _list[str]
    timestampSequence: _list[str]

@typing.type_check_only
class AbuseiamGeoRestriction(typing_extensions.TypedDict, total=False):
    locale: _list[AbuseiamGeoRestrictionLocale]

@typing.type_check_only
class AbuseiamGeoRestrictionLocale(typing_extensions.TypedDict, total=False):
    location: str
    restriction: AbuseiamUserRestriction

@typing.type_check_only
class AbuseiamHash(typing_extensions.TypedDict, total=False):
    hash: str
    type: str

@typing.type_check_only
class AbuseiamManualReviewEvaluationInfo(typing_extensions.TypedDict, total=False):
    reviewer: AbuseiamManualReviewerInfo
    tool: AbuseiamManualReviewTool

@typing.type_check_only
class AbuseiamManualReviewTool(typing_extensions.TypedDict, total=False):
    experimentId: str
    name: typing_extensions.Literal["UNKNOWN", "NUFF", "GOOGLE_ADMIN", "YOUTUBE"]

@typing.type_check_only
class AbuseiamManualReviewerInfo(typing_extensions.TypedDict, total=False):
    credential: _list[
        typing_extensions.Literal[
            "UNKNOWN", "LEGAL", "POLICY", "ANALYST", "LEGAL_PANEL"
        ]
    ]
    username: str

@typing.type_check_only
class AbuseiamNameValuePair(typing_extensions.TypedDict, total=False):
    name: str
    nonUtf8Value: str
    value: str

@typing.type_check_only
class AbuseiamNotRestriction(typing_extensions.TypedDict, total=False):
    child: _list[AbuseiamUserRestriction]

@typing.type_check_only
class AbuseiamOrRestriction(typing_extensions.TypedDict, total=False):
    child: _list[AbuseiamUserRestriction]

@typing.type_check_only
class AbuseiamRegion(typing_extensions.TypedDict, total=False):
    region: str

@typing.type_check_only
class AbuseiamSpecialRestriction(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal["ALCOHOL"]

@typing.type_check_only
class AbuseiamTarget(typing_extensions.TypedDict, total=False):
    id: str
    type: typing_extensions.Literal[
        "MESSAGE_ID",
        "CHUNK_ID",
        "IMAGE_URL",
        "URL",
        "USER_ID",
        "IP",
        "SITE",
        "SITEDOMAIN",
        "ENTITY_ID",
        "PERFECT_STREAM_ID",
        "ACTIVITY_ID",
        "COMMENT_ID",
        "AD_ID",
        "TEXT",
        "TEXT_FRAGMENT",
        "CLUSTER_MEMBER_ID",
        "EMBED_ID",
        "ANDROID_ID",
    ]

@typing.type_check_only
class AbuseiamUserNotification(typing_extensions.TypedDict, total=False):
    channel: typing_extensions.Literal["UNKNOWN", "BUILT_IN", "EMAIL", "GAIA"]

@typing.type_check_only
class AbuseiamUserRestriction(typing_extensions.TypedDict, total=False):
    ageRestriction: AbuseiamAgeRestriction
    andRestriction: AbuseiamAndRestriction
    constantRestriction: AbuseiamConstantRestriction
    geoRestriction: AbuseiamGeoRestriction
    notRestriction: AbuseiamNotRestriction
    orRestriction: AbuseiamOrRestriction
    specialRestriction: AbuseiamSpecialRestriction

@typing.type_check_only
class AbuseiamVerdict(typing_extensions.TypedDict, total=False):
    client: AbuseiamClient
    comment: str
    decision: typing_extensions.Literal[
        "ERROR",
        "NO_ACTION",
        "GOOD",
        "DELETE",
        "INTERSTITIAL",
        "HIDE",
        "BLACK_LIST",
        "MARK_AS_SPAM",
        "REWRITE_LINKS",
        "HIDE_AND_NOTIFY",
        "FREEZE_SERVICE",
        "SUSPEND_SERVICE",
        "SMS_DISABLE",
        "NOTIFY",
    ]
    durationMins: int
    evaluation: _list[AbuseiamEvaluation]
    hashes: _list[AbuseiamHash]
    isLegalIssued: bool
    miscScores: _list[AbuseiamNameValuePair]
    reasonCode: str
    region: _list[AbuseiamRegion]
    restriction: _list[AbuseiamVerdictRestriction]
    strikeCategory: typing_extensions.Literal[
        "ES", "CP", "COPYRIGHT", "BLOGGER", "GRANDCENTRAL", "DRIVE", "CLOUD", "SITES"
    ]
    target: AbuseiamTarget
    targetTimestampMicros: str
    timestampMicros: str
    userNotification: _list[AbuseiamUserNotification]
    version: str

@typing.type_check_only
class AbuseiamVerdictRestriction(typing_extensions.TypedDict, total=False):
    context: _list[AbuseiamVerdictRestrictionContext]
    userRestriction: AbuseiamUserRestriction

@typing.type_check_only
class AbuseiamVerdictRestrictionContext(typing_extensions.TypedDict, total=False):
    id: str
    type: typing_extensions.Literal["UNKNOWN", "DESTINATION_STREAM"]

@typing.type_check_only
class AbuseiamVideoReviewData(typing_extensions.TypedDict, total=False):
    referenceFragment: _list[str]
    reviewer: AbuseiamVideoReviewer
    videoId: str

@typing.type_check_only
class AbuseiamVideoReviewer(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "UNKNOWN",
        "CRT",
        "TIERED_CRT",
        "POLICY",
        "ANALYSTS",
        "LEGAL",
        "LEGAL_CSAI",
        "LEGAL_REMOVALS",
        "HIJACKING_TEAM",
        "CRT_CSAI",
        "LEGAL_CSAI_LOW_PRIORITY",
    ]
    username: str

@typing.type_check_only
class AdsShoppingReportingOffersSerializedSoriId(
    typing_extensions.TypedDict, total=False
):
    highId: str
    lowId1: str
    lowId2: str

@typing.type_check_only
class Anchors(typing_extensions.TypedDict, total=False):
    anchor: _list[AnchorsAnchor]
    homepageAnchorsDropped: str
    indexTier: int
    localAnchorsDropped: str
    nonlocalAnchorsDropped: str
    redundantAnchorsDropped: str
    redundantanchorinfo: _list[AnchorsRedundantAnchorInfo]
    supplementalAnchorsDropped: str
    targetDocid: str
    targetSite: str
    targetUrl: str

@typing.type_check_only
class AnchorsAnchor(typing_extensions.TypedDict, total=False):
    bucket: int
    catfishTags: _list[int]
    compressedImageUrls: _list[str]
    compressedOriginalTargetUrl: str
    context: int
    context2: int
    creationDate: int
    deleted: bool
    deletionDate: int
    demotionreason: int
    encodedNewsAnchorData: int
    experimental: bool
    expired: bool
    firstseenDate: int
    firstseenNearCreation: bool
    fontsize: int
    forwardingTypes: int
    fragment: str
    fullLeftContext: _list[str]
    fullRightContext: _list[str]
    isLocal: bool
    lastUpdateTimestamp: int
    linkAdditionalInfo: Proto2BridgeMessageSet
    linkTags: _list[int]
    locality: int
    offset: int
    origText: str
    originalTargetDocid: str
    pagerankWeight: float
    parallelLinks: int
    possiblyOldFirstseenDate: bool
    setiPagerankWeight: float
    source: AnchorsAnchorSource
    sourceType: int
    targetUrlEncoding: int
    text: str
    timestamp: str
    type: int
    weight: int

@typing.type_check_only
class AnchorsAnchorSource(typing_extensions.TypedDict, total=False):
    additionalInfo: Proto2BridgeMessageSet
    cluster: int
    compressedUrl: str
    crawlTimestamp: str
    docid: str
    doclength: int
    homePageInfo: int
    indyrank: int
    ipaddr: int
    language: int
    linkhash: str
    localCountryCodes: _list[int]
    nsr: int
    outdegree: int
    outsites: int
    packedIpaddress: str
    pageTags: _list[int]
    pagerank: int
    pagerankNs: int
    seglanguage: int
    site: str
    spamrank: int
    spamscore1: int
    spamscore2: int
    webtableKey: str

@typing.type_check_only
class AnchorsRedundantAnchorInfo(typing_extensions.TypedDict, total=False):
    anchorsDropped: str
    domain: str
    text: str

@typing.type_check_only
class AppsDynamiteCustomerId(typing_extensions.TypedDict, total=False):
    customerId: str

@typing.type_check_only
class AppsDynamiteSharedOrganizationInfo(typing_extensions.TypedDict, total=False):
    consumerInfo: AppsDynamiteSharedOrganizationInfoConsumerInfo
    customerInfo: AppsDynamiteSharedOrganizationInfoCustomerInfo

@typing.type_check_only
class AppsDynamiteSharedOrganizationInfoConsumerInfo(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AppsDynamiteSharedOrganizationInfoCustomerInfo(
    typing_extensions.TypedDict, total=False
):
    customerId: AppsDynamiteCustomerId

@typing.type_check_only
class AppsDynamiteSharedSegmentedMembershipCount(
    typing_extensions.TypedDict, total=False
):
    memberType: typing_extensions.Literal[
        "MEMBER_TYPE_UNSPECIFIED", "HUMAN_USER", "ROSTER_MEMBER"
    ]
    membershipCount: int
    membershipState: typing_extensions.Literal[
        "MEMBER_UNKNOWN",
        "MEMBER_INVITED",
        "MEMBER_JOINED",
        "MEMBER_NOT_A_MEMBER",
        "MEMBER_FAILED",
    ]

@typing.type_check_only
class AppsDynamiteSharedSegmentedMembershipCounts(
    typing_extensions.TypedDict, total=False
):
    value: _list[AppsDynamiteSharedSegmentedMembershipCount]

@typing.type_check_only
class AppsPeopleActivityBackendDestinationStream(
    typing_extensions.TypedDict, total=False
):
    id: _list[str]
    namespace: typing_extensions.Literal[
        "UNKNOWN_DESTINATION_NAMESPACE",
        "SQUARES",
        "FOUNTAIN",
        "PROFILE",
        "COLLEXIONS",
        "TEST",
        "HIGHLIGHT",
        "SOCIETY",
        "MEMEGEN",
        "PHOTOS",
        "SUPPLY_CHAIN_CENTRAL",
        "PAISA",
        "SOCIETY_CHAT",
        "PLUS_ENTERPRISE_LOG",
        "SEARCH_UGC",
        "LOUPE",
        "MINDSEARCH",
        "SOS_LIVE_COMMENTS",
        "SBE_LOADTEST",
        "SYSTEM1",
        "G_PLUS",
        "YOUTUBE",
        "EVENTS",
        "DEPRECATED_COLLECTIONS",
        "REVIEWS",
        "BACKSTAGE",
        "SPACES",
    ]

@typing.type_check_only
class AppsPeopleActivityStreamqualityDistillerEngagements(
    typing_extensions.TypedDict, total=False
):
    reportCompromised: str
    reportHarassment: str
    reportHate: str
    reportPorn: str
    reportSpam: str
    serveCount: str
    timeSec: str
    ytThumbsDown: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAbout(
    typing_extensions.TypedDict, total=False
):
    contentType: typing_extensions.Literal["TEXT_PLAIN", "TEXT_HTML"]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    safeHtmlValue: WebutilHtmlTypesSafeHtmlProto
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData(
    typing_extensions.TypedDict, total=False
):
    nameDisplayOptions: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions
    photosCompareData: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData
    profileEditability: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability
    profileNameModificationHistory: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataNameDisplayOptions(
    typing_extensions.TypedDict, total=False
):
    nicknameOption: typing_extensions.Literal[
        "UNKNOWN_NICKNAME_OPTION", "QUOTED_NICKNAME", "PAREN_NICKNAME"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareData(
    typing_extensions.TypedDict, total=False
):
    diffData: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData
    highResUrl: str
    inconsistentPhoto: bool
    lowResData: str
    lowResUrl: str
    monogramUrl: str
    privateLowResAcl: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataPhotosCompareDataDiffData(
    typing_extensions.TypedDict, total=False
):
    blueDiff: float
    greenDiff: float
    redDiff: float

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileEditability(
    typing_extensions.TypedDict, total=False
):
    lockedField: _list[str]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedDataProfileNameModificationHistory(
    typing_extensions.TypedDict, total=False
):
    computedNameChangesRemaining: int
    computedNicknameChangesRemaining: int
    nameChangesRemaining: int
    nameLastModified: str
    nicknameChangesRemaining: int
    nicknameLastModified: str
    quotaEnforcementStatus: typing_extensions.Literal[
        "UNKNOWN_QUOTA_ENFORCEMENT_STATUS", "ENFORCED", "NOT_ENFORCED", "NOT_APPLICABLE"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAccountEmail(
    typing_extensions.TypedDict, total=False
):
    email: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo(
    typing_extensions.TypedDict, total=False
):
    rawDeviceContactInfo: _list[AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAddress(
    typing_extensions.TypedDict, total=False
):
    country: str
    countryCode: str
    encodedPlaceId: str
    extendedAddress: str
    formatted: str
    formattedType: str
    locality: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    poBox: str
    pointSpec: AppsPeopleOzExternalMergedpeopleapiPointSpec
    postalCode: str
    region: str
    streetAddress: str
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAffinity(
    typing_extensions.TypedDict, total=False
):
    affinityMetadata: SocialGraphWireProtoPeopleapiAffinityMetadata
    affinityType: typing_extensions.Literal[
        "AFFINITY_TYPE_UNKNOWN",
        "EMAIL_AUTOCOMPLETE",
        "CONTACTS_PLUS_FREQUENTLY_CONTACTED",
        "CHAT_AUTOCOMPLETE",
        "GPLUS_AUTOCOMPLETE",
        "GLASS_AFFINITY",
        "PEOPLE_AUTOCOMPLETE_SOCIAL",
        "FIELD_AUTOCOMPLETE_SOCIAL",
        "CONTACTS_PLUS_EMAIL",
        "PHOTOS_PEOPLE_TO_SHARE_WITH_SUGGESTIONS",
        "PHOTOS_FIELDS_TO_SHARE_WITH_SUGGESTIONS",
        "INBOX_AFFINITY",
        "DYNAMITE_AFFINITY",
        "PHOTOS_SUGGESTIONS_AFFINITY",
        "PHOTOS_SUGGESTED_TARGETS",
        "PHOTOS_ASSISTANT_SUGGESTIONS_AFFINITY",
        "DRIVE_AUTOCOMPLETE",
        "WALLET_PEOPLE_TO_PAY_SUGGESTIONS",
        "CONTACTS_PLUS_CONTACT_CENTRIC",
        "POMEROY_AFFINITY",
        "CALENDAR_AFFINITY",
        "SPACES_APP_PEOPLE_AFFINITY",
        "HOMEROOM_AFFINITY",
        "PEOPLE_PLAYGROUND_AFFINITY",
        "FAMILY_AFFINITY",
        "CONTACTS_ASSISTANT_SUGGESTED_CONTACTS",
        "TRIPS_AFFINITY",
        "GOOGLE_VOICE_AFFINITY",
        "PHOTOS_FACE_AFFINITY",
        "G3DOC_AUTOCOMPLETE",
        "LOUPE_SUGGESTIONS_AFFINITY",
        "MAPS_SHARING_AFFINITY",
        "CLOUD_SEARCH_AFFINITY",
        "YOUTUBE_UNPLUGGED",
        "JAM_AFFINITY",
        "ITEM_SUGGEST_AFFINITY",
        "ISSUE_TRACKER_AFFINITY",
        "APPS_ASSISTANT_AFFINITY",
        "APDL_CONTACT_CENTRIC_DEFAULT_AFFINITY",
        "APDL_PROFILE_CENTRIC_DEFAULT_AFFINITY",
        "SOCIAL_RECOVERY",
        "TEZ_AFFINITY",
        "NEWS_AFFINITY",
        "ALLO_AFFINITY",
        "GPLUS_PEOPLE_RECOMMENDATIONS",
        "GPLUS_PEOPLE_RECOMMENDATIONS_SAME_DOMAIN",
        "DRIVE_AFFINITY",
        "PODIUM_AFFINITY",
        "ZOOM_SIGHTS_EMAIL_AFFINITY",
        "AIRDROME_AFFINITY",
        "HANGOUTS_MEET_AFFINITY",
        "GALLERY_AFFINITY",
        "AGSA_AFFINITY",
        "PAY_AFFINITY",
        "SAVES_AFFINITY",
        "JASPER_AFFINITY",
        "GOOGLE_HOME_APP_AFFINITY",
        "TOPAZ_TEAMS_AFFINITY",
        "DYNAMITE_OUT_OF_DOMAIN_AFFINITY",
        "GOOGLE_VOICE_SIRI_EXTENSION_AFFINITY",
        "COURSE_KIT_AFFINITY",
        "FORMS_AFFINITY",
        "NOVITAS_AFFINITY",
        "GTI_PEER_INTERACTIONS_AFFINITY",
        "ANDROID_EMERGENCY_AFFINITY",
        "DATA_STUDIO_AFFINITY",
        "SPUR_AFFINITY",
        "PLAY_GAMES_SERVICES_AFFINITY",
        "GROUPS_ADD_MEMBER_AFFINITY",
        "DUO_AFFINITY",
        "MY_BUSINESS_AFFINITY",
        "GMAIL_COMPOSE",
        "NON_GPLUS_AFFINITY",
        "ABUSE_AFFINITY",
        "ABUSE_AFFINITY_LITE",
        "CALENDAR_PEEK_AFFINITY",
        "HUB_CALL_AFFINITY",
        "GSUITE_WORKFLOW_AFFINITY",
        "VR_POLY_PRO_AFFINITY",
        "TASKS_AFFINITY",
        "GOOGLE_ONE_AFFINITY",
        "TRAVEL_AFFINITY",
        "GEO_DISCOVERY_FOLLOW_AFFINITY",
        "GMAIL_WEB_AFFINITY",
        "ASSISTANT_SETTINGS_WEB_UI_AFFINITY",
        "ARTIFEX_AFFINITY",
        "CONTACT_STORE_DEFAULT_AFFINITY",
        "CONTACT_STORE_SELF_EXCLUSIVE",
        "PHOTOS_FACE_STALE_AFFINITY",
        "LANDSPEEDER_AFFINITY",
        "GOOGLE_FI_AFFINITY",
        "CONTACTS_PLUS_DOMAIN_ONLY",
        "PHOTOS_SUGGESTED_TARGETS_IN_APP_ONLY",
        "SOCIETY_AFFINITY",
        "NANDHI_TEST_SCHEDULER_AFFINITY",
        "HIJACKING_HIGH_RISK_AFFINITY",
        "TRUECOLOURS_AFFINITY",
        "ESPRESSO_AFFINITY",
        "TAG_AFFINITY",
        "CORPBOT_AFFINITY",
        "SHOPPING_LIST_AFFINITY",
        "INTEGRATION_PLATFORM_AFFINITY",
        "HOT_ORDERS_UI_AFFINITY",
        "TELLY_MOBILE_APP_AFFINITY",
        "NGA_SUGGESTION_RESOLUTION_AFFINITY",
        "DUC_COMPANION_AFFINITY",
        "TOG_AFFINITY",
        "ANDROID_SYSTEM_INTELLIGENCE_AFFINITY",
        "EARTH_AFFINITY",
        "SHORTCUT_AFFINITY",
        "CHROME_OS_SCALING_AFFINITY",
        "SHOWTIME_AFFINITY",
        "PLAY_GAMES_SERVICES_EXPERIMENTAL",
        "GUPPEEPS_AFFINITY",
        "NEST_AFFINITY",
        "BLOGGER_AFFINITY",
        "INDIVIDUAL_OUTGOING_INTERACTIONS_RECENCY_RANK",
        "ASSISTANT_TOOLCHAIN_AFFINITY",
        "CHAT_CONSERVER_FAVORITE_CONTACTS_AFFINITY",
        "CHAT_CONSERVER_INVITEE_AFFINITY",
        "GANTRY_AFFINITY",
        "KINTARO_AFFINITY",
        "KEEP_AFFINITY",
        "INCIDENTFLOW_AFFINITY",
        "DRIVE_MENTION_AFFINITY",
        "DRIVE_LOOKUP_AFFINITY",
        "PODCASTS_MANAGER_AFFINITY",
        "EMAIL_AUTOCOMPLETE_GG",
        "ONE_REVIEWER_TOOL_AFFINITY",
        "ASSISTANT_FAMILY_VERTICAL_AFFINITY",
        "STADIA_AFFINITY",
        "ATLAS_AFFINITY",
        "CONSTELLATION_AFFINITY",
        "CORONADO_AFFINITY",
        "WALLET_GOLDEN_GATE_AFFINITY",
        "PUMICE_AFFINITY",
        "DEMO_AFFINITY_DEFAULT_ALGO",
        "DEMO_AFFINITY_DEFAULT_ALGO_DOMAIN_ONLY",
        "DEMO_AFFINITY_EMAIL_ALGO",
        "DEMO_AFFINITY_EMAIL_ALGO_DOMAIN_ONLY",
        "BACKLIGHT_AFFINITY",
        "DYNAMITE_GROUPS_AFFINITY",
        "DYNAMITE_OUT_OF_DOMAIN_GROUPS_AFFINITY",
        "GLOSSARY_MANAGER_AFFINITY",
        "ONEDEV_WORKFLOW_AFFINITY",
        "GSUITE_HUB_CALL_AFFINITY",
        "AVALANCHE_AFFINITY",
        "SANDTROUT_DEVICE_CONTACTS_AFFINITY",
        "DYNAMITE_ROOM_AFFINITY",
        "DESKBOOKING_AFFINITY",
        "TEZ_EXTENDED_AFFINITY",
        "DRIVE_PROFILE_ONLY_AFFINITY",
        "OFFSEC_AFFINITY",
        "GOOGLE_HOME_FAMILY_AFFINITY",
        "ONEMARKET_CALENDAR_AFFINITY",
        "GPAY_MERCHANT_CONSOLE_AFFINITY",
        "WORDFLOW_AFFINITY",
        "YOUTUBE_CREATOR_STUDIO_AFFINITY",
        "BRICKS_AFFINITY",
        "BUG_OBSERVER_AFFINITY",
        "ALPHASCHEDULE_AFFINITY",
        "BURROW_AFFINITY",
        "TEAMSPACES_AFFINITY",
        "GMAIL_SMARTADDRESS_REPLACE_AFFINITY",
        "GMAIL_SMARTADDRESS_EXPAND_AFFINITY",
        "ASSISTANT_OPA_AFFINITY",
        "POLYGLOT_AFFINITY",
        "TRANSLATION_MEMORY_MANAGER_AFFINITY",
        "THREADIT_AFFINITY",
        "RESOURCE_SYMPHONY_AFFINITY",
        "HOUSEHOLD_CONTACTS_PICKER_AFFINITY",
        "L10N_INFRA_SHARED_AFFINITY",
        "WORK_TRACKER_AFFINITY",
        "ARIANE_AFFINITY",
        "DRIVE_ROOM_AFFINITY",
        "MOMA_SEARCH_AFFINITY",
        "COLAB_INTERNAL_AFFINITY",
        "COLAB_EXTERNAL_AFFINITY",
        "TALENT_GROW_AFFINITY",
        "SOCIAL_CONNECTION_CHECKER_AFFINITY",
        "GMS_PEOPLE_AFFINITY",
        "ROCKET_LABS_AFFINITY",
        "DYNAMITE_ROOM_AND_INDIVIDUAL_ONLY_AFFINITY",
        "TEZ_PHONE_SEARCH_AFFINITY",
        "MY_GOOGLE_FAMILIES_AFFINITY",
        "DYNAMITE_UNIFIED_AFFINITY",
        "SHORTCUT_SERVER_AFFINITY",
        "LEGAL_CONTRACTS_AFFINITY",
        "CALENDAR_WEB_AFFINITY",
        "DATA_CATALOG_AFFINITY",
        "BRIEF_API_AFFINITY",
        "HARDWARE_MFG_DATA_VENUS_AFFINITY",
        "BETTERBUG_AFFINITY",
        "DCMS_AFFINITY",
        "PLAY_BOOKS_PUBENG_AFFINITY",
        "YAQS_AFFINITY",
        "RESPONSIBLE_FEATURE_ACCESS_AFFINITY",
        "PROSPER_AFFINITY",
        "PEOPLE_TO_ADD_BIRTHDAY_FOR_AFFINITY",
        "FLOURISH_AFFINITY",
        "CAMPAIGN_MANAGEMENT_TOOL_AFFINITY",
        "RECORDER_AFFINITY",
        "PERSONAL_SUGGEST_FIRST_HOP_SOCIAL_VICINITY",
        "PERSONAL_SUGGEST_EMAIL_AUTOCOMPLETE_SCORE",
        "CLASSROOM_SEARCH_AFFINITY",
        "HIRING_AFFINITY",
        "DATACENTER_SOFTWARE_AFFINITY",
        "PHOTOS_INVITE_AFFINITY",
        "PHOTOS_PARTNER_SHARING_AFFINITY",
        "MARKETING_WORKFLOWS_AFFINITY",
        "INTROSPECT_AFFINITY",
        "YOUTUBE_PARENT_TOOLS_AFFINITY",
        "RELIABILITY_INSIGHTS_PST_AFFINITY",
        "GMAIL_ANDROID_AFFINITY",
        "CUSTOMER_CARE_PORTAL_AFFINITY",
        "MOMAHOME_3C_AFFINITY",
        "DIGITAL_CAR_KEY_AFFINITY",
        "PLAY_BOOKS_DISTRIBUTION_AFFINITY",
        "GOOGLE_ASSIGNMENTS_AFFINITY",
        "TEST_FUSION_AFFINITY",
        "PRODUCTION2020_UIE_AFFINITY",
        "SPEAKEASY_AFFINITY",
        "DOCS_TASKS_AFFINITY",
        "DYNAMITE_SEARCH_AFFINITY",
        "GPAY_RELEASE_OPS_AFFINITY",
        "VOICE_PBX_AFFINITY",
        "VOICE_WEB_AFFINITY",
        "SKILLSSTACK_AFFINITY",
        "WHOSTORY_AFFINITY",
        "PHOTOS_PARTNER_SHARING_EMAIL_ONLY",
        "MEMORIZE_AFFINITY",
        "BETTANY_AFFINITY",
        "BASECAMP_AFFINITY",
        "DRIVE_SEARCH_FILTER_AFFINITY",
        "CULTURE_EVENTS_CALENDAR_AFFINITY",
        "DATABRIDGE_CONSOLE_AFFINITY",
        "COMMSTAR_AFFINITY",
        "CDDB_AFFINITY",
        "DATA_STUDIO_SPACES_AFFINITY",
        "SOJI_AFFINITY",
        "PLAY_MOVIES_ANDROID_AFFINITY",
        "DATA_STUDIO_DOMAIN_ONLY_AFFINITY",
        "MONOSPACE_AFFINITY",
        "MY_ACCOUNT_AFFINITY",
        "NUDGEIT_CAMPAIGN_MANAGER_AFFINITY",
        "LEGAL_CONTRACTS_EXTERNAL_AFFINITY",
        "CONTACTS_TO_STAR_AFFINITY",
        "DECS_AFFINITY",
        "GSOX_MOCHI_AFFINITY",
        "MEET_AFFINITY",
        "PMW_TI_AFFINITY",
        "DRIVE_SEARCH_FILTER_PERSON_ONLY",
        "ACCESSIBILITY_TRACKER_AFFINITY",
        "PLX_DATASOURCE_AFFINITY",
        "DUCKIEWEB_AFFINITY",
        "MEET_CALLING_AFFINITY",
        "MATTERSPACE_AFFINITY",
        "TRUSTED_CONTACTS_OOBE_AFFINITY",
        "REFERRALS_AFFINITY",
        "WAYMO_TRIAGE_TOOLING_AFFINITY",
        "DATA_STUDIO_GAIA_ONLY_AFFINITY",
        "TWENTYPERCENT_JOBPOSTINGS_AFFINITY",
        "ENGAGEMENTS_AFFINITY",
        "TRUSTED_CONTACTS_FL_AFFINITY",
        "CALENDAR_WEB_TEAM_MEMBERS_AFFINITY",
        "CLOUDCONNECT_AFFINITY",
        "PERSONAL_AGENT_AFFINITY",
        "MOBILE_HARNESS_AFFINITY",
        "LOOKER_STUDIO_PRO_AFFINITY",
        "SUPPORT_CLASSIFICATION_UI_AFFINITY",
        "NOTEBOOKLM_AFFINITY",
        "PLAYSPACE_LABS_AFFINITY",
        "ZOMBIE_CLOUD_AFFINITY",
        "RELATIONSHIPS_AFFINITY",
        "APPS_WORKFLOW_AFFINITY",
    ]
    containerId: str
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    loggingId: str
    value: float

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAgeRangeType(
    typing_extensions.TypedDict, total=False
):
    ageInYears: int
    ageOfConsentStatus: typing_extensions.Literal[
        "AOC_STATUS_UNKNOWN", "UNDER_AOC", "AT_OR_ABOVE_AOC"
    ]
    ageRange: typing_extensions.Literal[
        "UNKNOWN", "LESS_THAN_EIGHTEEN", "TWENTY_ONE_OR_OLDER", "EIGHTEEN_TO_TWENTY"
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo(
    typing_extensions.TypedDict, total=False
):
    appUniqueId: str
    contactInfoSource: typing_extensions.Literal["SOURCE_UNKNOWN", "APP_SEARCH"]
    displayAppUniqueId: str
    label: str
    mimetype: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiBestDisplayName(
    typing_extensions.TypedDict, total=False
):
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    displayName: str
    displayNameLastFirst: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiBirthday(
    typing_extensions.TypedDict, total=False
):
    ageDisableGracePeriod: AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod
    birthdayDecoration: SocialGraphApiProtoBirthdayDecoration
    birthdayResolution: typing_extensions.Literal[
        "FULL", "MONTH_AND_APPROXIMATED_YEAR", "APPROXIMATED_YEAR"
    ]
    calendarDay: GoogleTypeDate
    dateMs: str
    dateMsAsNumber: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    prompt: SocialGraphApiProtoPrompt
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriod(
    typing_extensions.TypedDict, total=False
):
    calendarDay: GoogleTypeDate
    gracePeriodEnd: str
    gracePeriodStart: str
    gracePeriodType: typing_extensions.Literal[
        "UNKNOWN", "USER_SPECIFIED_BIRTHDAY", "UNDERAGE_SUSPECTED"
    ]
    manualGracePeriodInfo: AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiBirthdayAgeDisableGracePeriodManualGracePeriodInfo(
    typing_extensions.TypedDict, total=False
):
    escalateTo: str
    executedBy: str
    reason: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiBraggingRights(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCalendar(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str
    url: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData(
    typing_extensions.TypedDict, total=False
):
    callerIdSource: AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedDataCallerIdSource(
    typing_extensions.TypedDict, total=False
):
    sourceType: typing_extensions.Literal[
        "UNKNOWN_SOURCE_TYPE",
        "PLACE",
        "SCOOBY_MANUAL",
        "SCOOBY_GOOGLE_VOICE",
        "SCOOBY_CSA",
        "SCOOBY_KNOWLEDGE_GRAPH",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore(
    typing_extensions.TypedDict, total=False
):
    bornBefore: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiChannelData(
    typing_extensions.TypedDict, total=False
):
    channelId: str
    commentCount: str
    description: str
    playlistCount: str
    profilePictureUrl: str
    profileUrl: str
    subscriberCount: str
    title: str
    usesYoutubeNames: bool
    videoCount: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCircleMembership(
    typing_extensions.TypedDict, total=False
):
    circleId: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiClientData(
    typing_extensions.TypedDict, total=False
):
    key: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    namespace: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCommunicationEmail(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiConnectionReminder(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    prompt: _list[SocialGraphApiProtoPrompt]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo(
    typing_extensions.TypedDict, total=False
):
    contactCreateContext: SocialGraphApiProtoContactCreateContext
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo(
    typing_extensions.TypedDict, total=False
):
    contactEditContext: SocialGraphApiProtoContactEditContext
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiContactGroupMembership(
    typing_extensions.TypedDict, total=False
):
    contactGroupId: str
    delegatedGroupInfo: AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    systemContactGroupId: typing_extensions.Literal[
        "UNKNOWN", "MY_CONTACTS", "STARRED", "FRIENDS", "FAMILY", "COWORKERS"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo(
    typing_extensions.TypedDict, total=False
):
    contactPromptSettings: SocialGraphApiProtoContactPromptSettings
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiContactStateInfo(
    typing_extensions.TypedDict, total=False
):
    contactState: SocialGraphApiProtoContactState
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCoverPhoto(
    typing_extensions.TypedDict, total=False
):
    imageHeight: int
    imageId: str
    imageUrl: str
    imageWidth: int
    isAnimated: bool
    isDefault: bool
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCustomSchemaField(
    typing_extensions.TypedDict, total=False
):
    fieldDisplayName: str
    fieldId: str
    fieldType: typing_extensions.Literal[
        "CUSTOM_FIELD_TYPE_UNKNOWN",
        "STRING",
        "INT64",
        "BOOL",
        "DOUBLE",
        "EMAIL",
        "PHONE",
        "DATE",
    ]
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    multiValued: bool
    schemaDisplayName: str
    schemaId: str
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiCustomerInfo(
    typing_extensions.TypedDict, total=False
):
    customerId: str
    customerName: str
    obfuscatedCustomerId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo(
    typing_extensions.TypedDict, total=False
):
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    id: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiDelegatedGroupInfo(
    typing_extensions.TypedDict, total=False
):
    delegatedGroupId: SocialGraphApiProtoDelegatedGroupId

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata(
    typing_extensions.TypedDict, total=False
):
    attributes: _list[typing_extensions.Literal["ATTRIBUTE_UNKNOWN", "STARRED"]]
    usageInfo: _list[SocialGraphApiProtoUsageInfo]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiDeviceContactId(
    typing_extensions.TypedDict, total=False
):
    contactId: str
    deviceId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo(
    typing_extensions.TypedDict, total=False
):
    deviceContactMetadata: AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata
    hasCrossDeviceData: bool
    id: AppsPeopleOzExternalMergedpeopleapiDeviceContactId
    lastClientUpdateTime: str
    lookupKey: str
    rawContactInfo: _list[AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo(
    typing_extensions.TypedDict, total=False
):
    containerId: str
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    extendedData: AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData
    materialized: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfoExtensionData(
    typing_extensions.TypedDict, total=False
):
    gdataCompatibilityExtensionId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmail(
    typing_extensions.TypedDict, total=False
):
    certificate: _list[AppsPeopleOzExternalMergedpeopleapiEmailCertificate]
    classification: typing_extensions.Literal[
        "EMAIL_CLASSIFICATION_UNKNOWN", "SIGNUP_EMAIL"
    ]
    contactGroupPreference: _list[
        AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference
    ]
    displayName: str
    extendedData: AppsPeopleOzExternalMergedpeopleapiEmailExtendedData
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    signupEmailMetadata: AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmailCertificate(
    typing_extensions.TypedDict, total=False
):
    configurationName: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    status: AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmailCertificateCertificateStatus(
    typing_extensions.TypedDict, total=False
):
    notAfterSec: str
    statusCode: typing_extensions.Literal[
        "UNKNOWN",
        "CERTIFICATE_VALID",
        "CERTIFICATE_MISSING",
        "CERTIFICATE_EXPIRED",
        "CERTIFICATE_REVOKED",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmailContactGroupPreference(
    typing_extensions.TypedDict, total=False
):
    contactGroupId: str
    isSynthetic: bool
    type: typing_extensions.Literal["UNKNOWN", "GMAIL"]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmailExtendedData(
    typing_extensions.TypedDict, total=False
):
    internalExternal: PeoplestackFlexorgsProtoInternalExternal
    isPlaceholder: bool
    smtpServerSupportsTls: bool
    usesConfusingCharacters: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmailSignupEmailMetadata(
    typing_extensions.TypedDict, total=False
):
    primary: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEmergencyInfo(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    pomeroyId: str
    trustLevel: typing_extensions.Literal[
        "TRUST_LEVEL_UNSPECIFIED", "TRUST_LEVEL_EMERGENCY_CONTACT"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiEvent(
    typing_extensions.TypedDict, total=False
):
    calendarDay: GoogleTypeDate
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    prompt: SocialGraphApiProtoPrompt
    timestampMillis: str
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiExternalId(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAcl(
    typing_extensions.TypedDict, total=False
):
    aclEntry: _list[AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry]
    authorizedViewers: _list[
        typing_extensions.Literal[
            "AUTHORIZED_VIEWER_UNSPECIFIED",
            "IDENTITY_ACL_ESTABLISHED",
            "SAME_ORGANIZATION",
            "SAME_UNICORN_FAMILY",
            "ALL_USERS",
        ]
    ]
    predefinedAclEntry: _list[
        typing_extensions.Literal[
            "UNKNOWN",
            "OWNER",
            "PUBLIC_READ",
            "DOMAIN_READ",
            "YOUR_CIRCLES_READ",
            "EXTENDED_CIRCLES_READ",
            "PRIVATE_READ",
        ]
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntry(
    typing_extensions.TypedDict, total=False
):
    role: typing_extensions.Literal["UNKNOWN", "READER", "WRITER", "OWNER"]
    scope: AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScope(
    typing_extensions.TypedDict, total=False
):
    allUsers: bool
    domainUsers: bool
    membership: AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl
    person: AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAcl(
    typing_extensions.TypedDict, total=False
):
    circle: AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl
    contactGroup: AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclCircleAcl(
    typing_extensions.TypedDict, total=False
):
    circleId: str
    circleSet: typing_extensions.Literal["UNKNOWN", "YOUR_CIRCLES", "EXTENDED_CIRCLES"]
    displayName: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopeMembershipAclContactGroupAcl(
    typing_extensions.TypedDict, total=False
):
    contactGroupId: str
    displayName: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldAclAclEntryScopePersonAcl(
    typing_extensions.TypedDict, total=False
):
    displayName: str
    personId: str
    photoUrl: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo(
    typing_extensions.TypedDict, total=False
):
    emergencyLevel: typing_extensions.Literal[
        "EMERGENCY_LEVEL_UNSPECIFIED", "EMERGENCY_LEVEL_PRIMARY"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiFileAs(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiGPayExtendedData(
    typing_extensions.TypedDict, total=False
):
    failure: AppsPeopleOzExternalMergedpeopleapiProductProfileFailure
    internationalNumber: str
    maskedNumber: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiGender(
    typing_extensions.TypedDict, total=False
):
    addressMeAs: str
    customType: str
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiGplusExtendedData(
    typing_extensions.TypedDict, total=False
):
    contentRestriction: typing_extensions.Literal[
        "UNKNOWN", "PUBLIC", "DISCOVERY", "WALLED_GARDEN"
    ]
    isEnterpriseUser: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData(
    typing_extensions.TypedDict, total=False
):
    hadPastHangoutState: typing_extensions.Literal[
        "UNKNOWN_PAST_HANGOUT_STATE", "HAD_PAST_HANGOUT", "NO_PAST_HANGOUT"
    ]
    invitationStatus: typing_extensions.Literal[
        "UNKNOWN_INVITATION_STATUS",
        "PENDING_INVITATION",
        "ACCEPTED_INVITATION",
        "INVITATION_NEEDED",
    ]
    isBot: bool
    isDismissed: bool
    isFavorite: bool
    isPinned: bool
    userType: typing_extensions.Literal[
        "UNKNOWN_USER_TYPE",
        "INVALID",
        "GAIA",
        "OFF_NETWORK_PHONE",
        "MALFORMED_PHONE_NUMBER",
        "UNKNOWN_PHONE_NUMBER",
        "ANONYMOUS_PHONE_NUMBER",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiIdentityInfo(
    typing_extensions.TypedDict, total=False
):
    originalLookupToken: _list[str]
    previousPersonId: _list[str]
    sourceIds: _list[AppsPeopleOzExternalMergedpeopleapiSourceIdentity]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiIm(typing_extensions.TypedDict, total=False):
    formattedProtocol: str
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    protocol: str
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget(
    typing_extensions.TypedDict, total=False
):
    app: _list[
        typing_extensions.Literal[
            "UNKNOWN",
            "BABEL",
            "YOUTUBE",
            "WHOS_DOWN",
            "YOUTUBE_MANGO",
            "PHOTOS",
            "GOOGLE_ASSISTANT",
            "KABOO",
            "COMMERCE_PLATFORM",
            "SPACES",
            "MAPS",
            "LOUPE_UNUSED",
            "POMEROY",
            "LOUPE",
            "PEOPLE_PLAYGROUND",
            "NEWS_360",
            "DUO",
            "MEET",
        ]
    ]
    clientData: _list[
        AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    originatingField: _list[
        AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField
    ]
    type: typing_extensions.Literal[
        "UNKNOWN_KEY_TYPE", "PHONE", "OBFUSCATED_GAIA_ID", "EMAIL"
    ]
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetClientData(
    typing_extensions.TypedDict, total=False
):
    app: typing_extensions.Literal[
        "UNKNOWN",
        "BABEL",
        "YOUTUBE",
        "WHOS_DOWN",
        "YOUTUBE_MANGO",
        "PHOTOS",
        "GOOGLE_ASSISTANT",
        "KABOO",
        "COMMERCE_PLATFORM",
        "SPACES",
        "MAPS",
        "LOUPE_UNUSED",
        "POMEROY",
        "LOUPE",
        "PEOPLE_PLAYGROUND",
        "NEWS_360",
        "DUO",
        "MEET",
    ]
    byteValue: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInAppNotificationTargetOriginatingField(
    typing_extensions.TypedDict, total=False
):
    fieldIndex: int
    fieldType: typing_extensions.Literal["UNKNOWN_FIELD_TYPE", "PHONE", "EMAIL"]
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInAppReachability(
    typing_extensions.TypedDict, total=False
):
    appType: typing_extensions.Literal[
        "UNKNOWN",
        "BABEL",
        "YOUTUBE",
        "WHOS_DOWN",
        "YOUTUBE_MANGO",
        "PHOTOS",
        "KABOO",
        "COMMERCE_PLATFORM",
        "SPACES",
        "GOOGLE_ASSISTANT",
        "PEOPLE_PLAYGROUND",
        "MAPS",
        "LOUPE_UNUSED",
        "POMEROY",
        "LOUPE",
        "NEWS_360",
        "DUO",
        "MEET",
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    reachabilityKey: AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey
    status: typing_extensions.Literal[
        "UNKNOWN_REACHABLE_STATUS", "REACHABLE", "NOT_REACHABLE"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInAppReachabilityReachabilityKey(
    typing_extensions.TypedDict, total=False
):
    keyType: typing_extensions.Literal[
        "UNKNOWN_KEY_TYPE", "PHONE", "OBFUSCATED_GAIA_ID"
    ]
    keyValue: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInteractionSettings(
    typing_extensions.TypedDict, total=False
):
    allowed: bool
    interaction: typing_extensions.Literal[
        "UNKNOWN",
        "INCOMING_CIRCLE_MEMBERSHIP",
        "INCOMING_SOCIAL_EDGE",
        "INVITE_TO_EMAIL",
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiInterest(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiLanguage(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiLatLng(
    typing_extensions.TypedDict, total=False
):
    lat: float
    lng: float

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiLegacyFields(
    typing_extensions.TypedDict, total=False
):
    mobileOwnerId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField(
    typing_extensions.TypedDict, total=False
):
    limitedProfileSettings: SocialGraphApiProtoLimitedProfileSettings
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiLocation(
    typing_extensions.TypedDict, total=False
):
    buildingId: str
    buildingName: str
    current: bool
    deskCode: str
    floorName: str
    floorSection: str
    lastUpdateTime: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    source: typing_extensions.Literal["UNKNOWN", "EXPLICIT", "INFERRED"]
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiManagementUpchain(
    typing_extensions.TypedDict, total=False
):
    indirectManager: _list[
        AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    status: typing_extensions.Literal["UNKNOWN", "OK", "PARTIAL", "LOOP"]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiManagementUpchainIndirectManager(
    typing_extensions.TypedDict, total=False
):
    email: str
    personId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMapsExtendedData(
    typing_extensions.TypedDict, total=False
):
    failure: AppsPeopleOzExternalMergedpeopleapiProductProfileFailure
    followeeCount: str
    followerCount: int
    numContributions: str
    profilePhotoUrl: str
    tagline: str
    topicExpertise: _list[str]
    userCaption: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMapsProfile(
    typing_extensions.TypedDict, total=False
):
    fieldRestriction: _list[
        AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    tagline: str
    websiteLink: AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMapsProfileFieldRestriction(
    typing_extensions.TypedDict, total=False
):
    clientData: str
    type: typing_extensions.Literal["TYPE_UNSPECIFIED", "HIDE_TAGLINE"]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMapsProfileUrlLink(
    typing_extensions.TypedDict, total=False
):
    anchorText: str
    url: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMatchInfo(
    typing_extensions.TypedDict, total=False
):
    match: _list[AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch]
    query: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMatchInfoLookupTokenMatch(
    typing_extensions.TypedDict, total=False
):
    endIndex: int
    startIndex: int

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMembership(
    typing_extensions.TypedDict, total=False
):
    circleId: str
    contactGroupId: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    systemContactGroupId: typing_extensions.Literal[
        "UNKNOWN", "MY_CONTACTS", "STARRED", "FRIENDS", "FAMILY", "COWORKERS"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiMission(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiName(typing_extensions.TypedDict, total=False):
    displayName: str
    displayNameLastFirst: str
    displayNameSource: SocialGraphApiProtoDisplayNameSource
    familyName: str
    formattedName: str
    givenName: str
    honorificPrefix: str
    honorificSuffix: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    middleName: str
    pronunciations: SocialGraphApiProtoPronunciations
    shortDisplayName: str
    unstructuredName: str
    yomiFamilyName: str
    yomiFullName: str
    yomiGivenName: str
    yomiHonorificPrefix: str
    yomiHonorificSuffix: str
    yomiMiddleName: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    namePronunciationAudioMetadata: SocialGraphApiProtoNamePronunciationAudioMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiNickname(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: typing_extensions.Literal[
        "NICKNAME_UNKNOWN",
        "DEFAULT",
        "OTHER_NAME",
        "MAIDEN_NAME",
        "SHORT_NAME",
        "INITIALS",
        "ALTERNATE_NAME",
    ]
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOccupation(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOpeningHours(
    typing_extensions.TypedDict, total=False
):
    openNow: bool
    periods: _list[AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod]
    weekdayTexts: _list[str]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint(
    typing_extensions.TypedDict, total=False
):
    day: int
    time: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOpeningHoursPeriod(
    typing_extensions.TypedDict, total=False
):
    close: AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint
    open: AppsPeopleOzExternalMergedpeopleapiOpeningHoursEndpoint

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOrganization(
    typing_extensions.TypedDict, total=False
):
    assignment: _list[AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment]
    certification: str
    costCenter: str
    current: bool
    department: str
    description: str
    domain: str
    endCalendarDay: GoogleTypeDate
    endMs: str
    endMsAsNumber: str
    formattedStringType: str
    fteMilliPercent: int
    importance: float
    location: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    name: str
    project: _list[AppsPeopleOzExternalMergedpeopleapiOrganizationProject]
    startCalendarDay: GoogleTypeDate
    startMs: str
    startMsAsNumber: str
    stringType: str
    symbol: str
    title: str
    type: typing_extensions.Literal["UNKNOWN", "WORK", "SCHOOL", "DOMAIN_ONLY"]
    yomiName: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOrganizationAssignment(
    typing_extensions.TypedDict, total=False
):
    name: str
    url: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOrganizationProject(
    typing_extensions.TypedDict, total=False
):
    description: str
    name: str
    role: str
    type: str
    url: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiOtherKeyword(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    source: typing_extensions.Literal["SOURCE_UNKNOWN", "OUTLOOK", "CUSTOM"]
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPerson(
    typing_extensions.TypedDict, total=False
):
    about: _list[AppsPeopleOzExternalMergedpeopleapiAbout]
    address: _list[AppsPeopleOzExternalMergedpeopleapiAddress]
    ageRange: typing_extensions.Literal[
        "UNKNOWN", "LESS_THAN_EIGHTEEN", "TWENTY_ONE_OR_OLDER", "EIGHTEEN_TO_TWENTY"
    ]
    ageRangeRepeated: _list[AppsPeopleOzExternalMergedpeopleapiAgeRangeType]
    birthday: _list[AppsPeopleOzExternalMergedpeopleapiBirthday]
    braggingRights: _list[AppsPeopleOzExternalMergedpeopleapiBraggingRights]
    calendar: _list[AppsPeopleOzExternalMergedpeopleapiCalendar]
    certifiedBornBefore: _list[AppsPeopleOzExternalMergedpeopleapiCertifiedBornBefore]
    circleMembership: _list[AppsPeopleOzExternalMergedpeopleapiCircleMembership]
    clientData: _list[AppsPeopleOzExternalMergedpeopleapiClientData]
    communicationEmail: _list[AppsPeopleOzExternalMergedpeopleapiCommunicationEmail]
    connectionReminder: _list[AppsPeopleOzExternalMergedpeopleapiConnectionReminder]
    contactCreateContextInfo: _list[
        AppsPeopleOzExternalMergedpeopleapiContactCreateContextInfo
    ]
    contactEditContextInfo: _list[
        AppsPeopleOzExternalMergedpeopleapiContactEditContextInfo
    ]
    contactGroupMembership: _list[
        AppsPeopleOzExternalMergedpeopleapiContactGroupMembership
    ]
    contactPromptSettingsInfo: _list[
        AppsPeopleOzExternalMergedpeopleapiContactPromptSettingsInfo
    ]
    contactStateInfo: _list[AppsPeopleOzExternalMergedpeopleapiContactStateInfo]
    coverPhoto: _list[AppsPeopleOzExternalMergedpeopleapiCoverPhoto]
    customSchemaField: _list[AppsPeopleOzExternalMergedpeopleapiCustomSchemaField]
    email: _list[AppsPeopleOzExternalMergedpeopleapiEmail]
    emergencyInfo: _list[AppsPeopleOzExternalMergedpeopleapiEmergencyInfo]
    event: _list[AppsPeopleOzExternalMergedpeopleapiEvent]
    extendedData: AppsPeopleOzExternalMergedpeopleapiPersonExtendedData
    externalId: _list[AppsPeopleOzExternalMergedpeopleapiExternalId]
    fileAs: _list[AppsPeopleOzExternalMergedpeopleapiFileAs]
    fingerprint: str
    gender: _list[AppsPeopleOzExternalMergedpeopleapiGender]
    im: _list[AppsPeopleOzExternalMergedpeopleapiIm]
    inAppNotificationTarget: _list[
        AppsPeopleOzExternalMergedpeopleapiInAppNotificationTarget
    ]
    inAppReachability: _list[AppsPeopleOzExternalMergedpeopleapiInAppReachability]
    interactionSettings: _list[AppsPeopleOzExternalMergedpeopleapiInteractionSettings]
    interest: _list[AppsPeopleOzExternalMergedpeopleapiInterest]
    language: _list[AppsPeopleOzExternalMergedpeopleapiLanguage]
    legacyFields: AppsPeopleOzExternalMergedpeopleapiLegacyFields
    limitedProfileSettings: _list[
        AppsPeopleOzExternalMergedpeopleapiLimitedProfileSettingsField
    ]
    linkedPerson: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    location: _list[AppsPeopleOzExternalMergedpeopleapiLocation]
    managementUpchain: _list[AppsPeopleOzExternalMergedpeopleapiManagementUpchain]
    mapsProfile: _list[AppsPeopleOzExternalMergedpeopleapiMapsProfile]
    membership: _list[AppsPeopleOzExternalMergedpeopleapiMembership]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonMetadata
    mission: _list[AppsPeopleOzExternalMergedpeopleapiMission]
    name: _list[AppsPeopleOzExternalMergedpeopleapiName]
    namePronunciationAudioMetadataInfo: _list[
        AppsPeopleOzExternalMergedpeopleapiNamePronunciationAudioMetadataInfo
    ]
    nickname: _list[AppsPeopleOzExternalMergedpeopleapiNickname]
    occupation: _list[AppsPeopleOzExternalMergedpeopleapiOccupation]
    organization: _list[AppsPeopleOzExternalMergedpeopleapiOrganization]
    otherKeyword: _list[AppsPeopleOzExternalMergedpeopleapiOtherKeyword]
    peopleInCommon: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    personAttribute: _list[AppsPeopleOzExternalMergedpeopleapiPersonAttribute]
    personId: str
    phone: _list[AppsPeopleOzExternalMergedpeopleapiPhone]
    photo: _list[AppsPeopleOzExternalMergedpeopleapiPhoto]
    placeDetails: _list[AppsPeopleOzExternalMergedpeopleapiPlaceDetails]
    plusPageInfo: _list[AppsPeopleOzExternalMergedpeopleapiPlusPageInfo]
    posixAccount: _list[AppsPeopleOzExternalMergedpeopleapiPosixAccount]
    profileUrl: str
    profileUrlRepeated: _list[AppsPeopleOzExternalMergedpeopleapiProfileUrl]
    pronoun: _list[AppsPeopleOzExternalMergedpeopleapiPronoun]
    readOnlyProfileInfo: _list[AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo]
    relation: _list[AppsPeopleOzExternalMergedpeopleapiRelation]
    relationshipInterest: _list[AppsPeopleOzExternalMergedpeopleapiRelationshipInterest]
    relationshipStatus: _list[AppsPeopleOzExternalMergedpeopleapiRelationshipStatus]
    rightOfPublicityState: _list[
        AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState
    ]
    rosterDetails: _list[AppsPeopleOzExternalMergedpeopleapiRosterDetails]
    searchProfile: _list[AppsPeopleOzExternalMergedpeopleapiSearchProfile]
    sipAddress: _list[AppsPeopleOzExternalMergedpeopleapiSipAddress]
    skills: _list[AppsPeopleOzExternalMergedpeopleapiSkills]
    socialConnection: _list[AppsPeopleOzExternalMergedpeopleapiSocialConnection]
    sortKeys: AppsPeopleOzExternalMergedpeopleapiSortKeys
    sshPublicKey: _list[AppsPeopleOzExternalMergedpeopleapiSshPublicKey]
    tagline: _list[AppsPeopleOzExternalMergedpeopleapiTagline]
    teamsExtendedData: AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData
    userDefined: _list[AppsPeopleOzExternalMergedpeopleapiUserDefined]
    visibleToGuests: _list[AppsPeopleOzExternalMergedpeopleapiVisibleToGuests]
    website: _list[AppsPeopleOzExternalMergedpeopleapiWebsite]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonAttribute(
    typing_extensions.TypedDict, total=False
):
    attributeKey: typing_extensions.Literal[
        "PERSON_ATTRIBUTE_UNKNOWN", "REJECTED_CLEANUP_CARD_SUGGESTIONS"
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonExtendedData(
    typing_extensions.TypedDict, total=False
):
    aboutMeExtendedData: AppsPeopleOzExternalMergedpeopleapiAboutMeExtendedData
    appsWaldoExtendedData: SocialGraphWireProtoPeopleapiExtensionAppsWaldoExtendedData
    callerIdExtendedData: AppsPeopleOzExternalMergedpeopleapiCallerIdExtendedData
    contactsExtendedData: AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData
    domainName: _list[str]
    dynamiteExtendedData: SocialGraphWireProtoPeopleapiExtensionDynamiteExtendedData
    gpayExtendedData: AppsPeopleOzExternalMergedpeopleapiGPayExtendedData
    gplusExtendedData: AppsPeopleOzExternalMergedpeopleapiGplusExtendedData
    hangoutsExtendedData: AppsPeopleOzExternalMergedpeopleapiHangoutsExtendedData
    isPlaceholder: bool
    mapsExtendedData: AppsPeopleOzExternalMergedpeopleapiMapsExtendedData
    paisaExtendedData: SocialGraphWireProtoPeopleapiExtensionPaisaExtendedData
    peopleStackExtendedData: SocialGraphWireProtoPeopleapiExtensionPeopleStackExtendedData
    peopleStackPersonExtendedData: SocialGraphWireProtoPeopleapiExtensionPeopleStackPersonExtendedData
    playGamesExtendedData: AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData
    tlsIsPlaceholder: bool
    youtubeExtendedData: AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata(
    typing_extensions.TypedDict, total=False
):
    aclChoices: _list[AppsPeopleOzExternalMergedpeopleapiFieldAcl]
    additionalContainerInfo: AppsPeopleOzExternalMergedpeopleapiAdditionalContainerInfo
    affinity: _list[AppsPeopleOzExternalMergedpeopleapiAffinity]
    contactVisibility: _list[
        typing_extensions.Literal["CONTACT_VISIBILITY_UNSPECIFIED", "VISIBLE_TO_GUEST"]
    ]
    container: typing_extensions.Literal[
        "UNKNOWN",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    containerId: str
    containerPrimary: bool
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    crossDeviceAllowed: bool
    defaultAclChoice: AppsPeopleOzExternalMergedpeopleapiFieldAcl
    deprecatedContactContainerId: str
    edgeKey: bool
    edgeKeyInfo: _list[AppsPeopleOzExternalMergedpeopleapiEdgeKeyInfo]
    encodedContainerId: str
    fieldAcl: AppsPeopleOzExternalMergedpeopleapiFieldAcl
    lastUpdateTime: str
    matchingInfo: _list[AppsPeopleOzExternalMergedpeopleapiMatchInfo]
    otherDedupedContainers: _list[
        AppsPeopleOzExternalMergedpeopleapiDedupedContainerInfo
    ]
    primary: bool
    productMetadata: _list[AppsPeopleOzExternalMergedpeopleapiProductMetadata]
    verified: bool
    visibility: typing_extensions.Literal["VISIBILITY_UNKNOWN", "PUBLIC", "USER"]
    writeable: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber(
    typing_extensions.TypedDict, total=False
):
    people: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    totalNumber: int

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonMetadata(
    typing_extensions.TypedDict, total=False
):
    affinity: _list[AppsPeopleOzExternalMergedpeopleapiAffinity]
    attribution: _list[str]
    bestDisplayName: AppsPeopleOzExternalMergedpeopleapiBestDisplayName
    blockType: _list[
        typing_extensions.Literal["BLOCK_TYPE_UNKNOWN", "CIRCLE", "LEGACY"]
    ]
    circleId: _list[str]
    contactGroupId: _list[str]
    contactId: _list[str]
    customResponseMaskingType: typing_extensions.Literal["UNKNOWN", "NONE", "MENAGERIE"]
    deleted: bool
    deprecatedBlocked: bool
    deprecatedMembershipCircleId: _list[str]
    deprecatedMembershipContactGroupId: _list[str]
    deviceContactInfo: _list[AppsPeopleOzExternalMergedpeopleapiDeviceContactInfo]
    identityInfo: AppsPeopleOzExternalMergedpeopleapiIdentityInfo
    inViewerDomain: bool
    incomingBlockType: _list[
        typing_extensions.Literal["BLOCK_TYPE_UNKNOWN", "CIRCLE", "LEGACY"]
    ]
    lastUpdateTimeMicros: str
    model: typing_extensions.Literal[
        "PERSON_MODEL_UNKNOWN", "PROFILE_CENTRIC", "CONTACT_CENTRIC"
    ]
    objectType: typing_extensions.Literal["OBJECT_TYPE_UNKNOWN", "PERSON", "PAGE"]
    ownerId: str
    ownerUserType: _list[
        typing_extensions.Literal[
            "OWNER_USER_TYPE_UNKNOWN",
            "GOOGLE_USER",
            "GPLUS_USER",
            "GPLUS_DISABLED_BY_ADMIN",
            "GOOGLE_APPS_USER",
            "GOOGLE_APPS_SELF_MANAGED_USER",
            "GOOGLE_FAMILY_USER",
            "GOOGLE_FAMILY_CHILD_USER",
            "GOOGLE_APPS_ADMIN_DISABLED",
            "GOOGLE_ONE_USER",
            "GOOGLE_FAMILY_CONVERTED_CHILD_USER",
        ]
    ]
    plusPageType: typing_extensions.Literal[
        "PLUS_PAGE_TYPE_UNKNOWN",
        "LOCAL",
        "COMPANY",
        "BRAND",
        "CELEBRITY",
        "CAUSE",
        "ENTERTAINMENT",
        "OTHER",
        "OBSOLETE_PRIVATE",
    ]
    previousPersonId: _list[str]
    profileOwnerStats: AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats
    scoringInfo: AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo
    userVisibleStats: AppsPeopleOzExternalMergedpeopleapiUserVisibleStats

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfo(
    typing_extensions.TypedDict, total=False
):
    rawMatchQualityScore: float
    stExpressionResults: _list[
        AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPersonMetadataScoringInfoStExpressionResult(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPhone(
    typing_extensions.TypedDict, total=False
):
    canonicalizedForm: str
    emergencyInfo: AppsPeopleOzExternalMergedpeopleapiFieldEmergencyInfo
    extendedData: AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str
    uri: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPhoneExtendedData(
    typing_extensions.TypedDict, total=False
):
    structuredPhone: AppsPeopleOzExternalMergedpeopleapiStructuredPhone

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPhoto(
    typing_extensions.TypedDict, total=False
):
    decoration: _list[SocialGraphApiProtoDecorationOverlay]
    emojiAvatarUrl: str
    glyph: str
    htmlAttribution: _list[str]
    isDefault: bool
    isMonogram: bool
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    monogramBackground: str
    originalPhoto: SocialGraphApiProtoImageReference
    photoId: AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId
    photoToken: str
    url: str
    viewerUrl: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPhotoPhotoStorageId(
    typing_extensions.TypedDict, total=False
):
    mediaKey: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPlaceDetails(
    typing_extensions.TypedDict, total=False
):
    googleUrl: str
    latLng: AppsPeopleOzExternalMergedpeopleapiLatLng
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    openingHours: AppsPeopleOzExternalMergedpeopleapiOpeningHours
    primaryTypeName: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedData(
    typing_extensions.TypedDict, total=False
):
    achievements: _list[
        AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement
    ]
    avatarImageUrl: str
    failure: AppsPeopleOzExternalMergedpeopleapiProductProfileFailure
    gamerTag: str
    playerLevel: int
    profileVisibility: typing_extensions.Literal[
        "UNKNOWN_CLIENT_PLAYER_PROFILE_VISIBILITY",
        "PRIVATE_VISIBILITY",
        "PUBLIC_VISIBILITY",
        "FRIENDS_VISIBILITY",
    ]
    totalFriendsCount: str
    totalUnlockedAchievements: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPlayGamesExtendedDataAchievement(
    typing_extensions.TypedDict, total=False
):
    achievementName: str
    achievementUnlockedIconUrl: str
    rarityPercentage: float

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPlusPageInfo(
    typing_extensions.TypedDict, total=False
):
    applicationId: str
    entityType: typing_extensions.Literal[
        "ENTITY_TYPE_UNSPECIFIED",
        "LOCAL",
        "COMPANY",
        "BRAND",
        "CELEBRITY",
        "CAUSE",
        "ENTERTAINMENT",
        "OTHER",
        "OBSOLETE_PRIVATE",
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPointSpec(
    typing_extensions.TypedDict, total=False
):
    bounds: GeostoreRectProto
    point: GeostorePointProto
    pointSource: typing_extensions.Literal[
        "UNKNOWN_POINT_SOURCE",
        "POINT_SOURCE_UNSPECIFIED",
        "USER_PROVIDED",
        "SYSTEM_PROVIDED",
        "USER_CONFIRMED",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPosixAccount(
    typing_extensions.TypedDict, total=False
):
    accountId: str
    accountNamespace: typing_extensions.Literal[
        "LINUX_GSUITE", "LINUX_CONSUMER", "WINDOWS_GSUITE", "WINDOWS_CONSUMER"
    ]
    accountType: typing_extensions.Literal[
        "LINUX_USER_ACCOUNT",
        "LINUX_SERVICE_ACCOUNT",
        "LINUX_EXTERNAL_USER",
        "WINDOWS_USER_ACCOUNT",
        "WINDOWS_SERVICE_ACCOUNT",
        "WINDOWS_EXTERNAL_USER",
    ]
    customerKey: str
    fingerprint: str
    gecos: str
    gid: str
    homeDirectory: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    operatingSystemType: typing_extensions.Literal[
        "OPERATING_SYSTEM_TYPE_UNSPECIFIED", "LINUX", "WINDOWS"
    ]
    shell: str
    systemId: str
    uid: str
    username: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiProductMetadata(
    typing_extensions.TypedDict, total=False
):
    productSource: typing_extensions.Literal[
        "PRODUCT_SOURCE_UNKNOWN",
        "PRODUCT_SOURCE_DEFAULT",
        "PRODUCT_SOURCE_ASSISTANT",
        "PRODUCT_SOURCE_JANATA",
        "PRODUCT_SOURCE_SPEED_DIAL",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiProductProfileFailure(
    typing_extensions.TypedDict, total=False
):
    failureType: typing_extensions.Literal[
        "PRODUCT_PROFILE_FAILURE_TYPE_UNKNOWN", "RPC_FAILURE"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats(
    typing_extensions.TypedDict, total=False
):
    incomingAnyCircleCount: str
    viewCount: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiProfileUrl(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    url: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiPronoun(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    pronounData: SocialGraphApiProtoPronounData

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo(
    typing_extensions.TypedDict, total=False
):
    dataSet: str
    dirty: bool
    sourceIdExist: bool
    syncInfo: SocialGraphApiProtoSyncInfo

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRawDeviceContactInfo(
    typing_extensions.TypedDict, total=False
):
    accountName: str
    accountType: str
    appContactData: _list[SocialGraphApiAppContactData]
    appInfo: AppsPeopleOzExternalMergedpeopleapiAppUniqueInfo
    crossDeviceAllowed: bool
    deviceContactMetadata: AppsPeopleOzExternalMergedpeopleapiDeviceContactExtraMetadata
    googleContactId: str
    id: str
    photoType: typing_extensions.Literal[
        "PHOTO_TYPE_UNKNOWN", "NO_PHOTO", "THUMBNAIL", "FULL_SIZE_PHOTO"
    ]
    rawContactId: str
    rawDeviceContactAnalyticalInfo: AppsPeopleOzExternalMergedpeopleapiRawDeviceContactAnalyticalInfo

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfo(
    typing_extensions.TypedDict, total=False
):
    accountEmail: AppsPeopleOzExternalMergedpeopleapiAccountEmail
    blockType: _list[
        typing_extensions.Literal["BLOCK_TYPE_UNKNOWN", "CIRCLE", "LEGACY"]
    ]
    customerInfo: AppsPeopleOzExternalMergedpeopleapiCustomerInfo
    domainInfo: AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo
    inViewerDomain: bool
    incomingBlockType: _list[
        typing_extensions.Literal["BLOCK_TYPE_UNKNOWN", "CIRCLE", "LEGACY"]
    ]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    objectType: typing_extensions.Literal["OBJECT_TYPE_UNKNOWN", "PERSON", "PAGE"]
    ownerId: str
    ownerUserType: _list[
        typing_extensions.Literal[
            "OWNER_USER_TYPE_UNKNOWN",
            "GOOGLE_USER",
            "GPLUS_USER",
            "GPLUS_DISABLED_BY_ADMIN",
            "GOOGLE_APPS_USER",
            "GOOGLE_APPS_SELF_MANAGED_USER",
            "GOOGLE_FAMILY_USER",
            "GOOGLE_FAMILY_CHILD_USER",
            "GOOGLE_APPS_ADMIN_DISABLED",
            "GOOGLE_ONE_USER",
            "GOOGLE_FAMILY_CONVERTED_CHILD_USER",
        ]
    ]
    plusPageType: typing_extensions.Literal[
        "PLUS_PAGE_TYPE_UNKNOWN",
        "LOCAL",
        "COMPANY",
        "BRAND",
        "CELEBRITY",
        "CAUSE",
        "ENTERTAINMENT",
        "OTHER",
        "OBSOLETE_PRIVATE",
    ]
    profileOwnerStats: AppsPeopleOzExternalMergedpeopleapiProfileOwnerStats
    unjoinedEmailCertificates: _list[AppsPeopleOzExternalMergedpeopleapiEmail]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo(
    typing_extensions.TypedDict, total=False
):
    domainBadge: _list[str]
    domainName: _list[str]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRelation(
    typing_extensions.TypedDict, total=False
):
    canonicalValue: str
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    relationDetails: AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRelationRelationDetails(
    typing_extensions.TypedDict, total=False
):
    displayName: str
    jobTitle: str
    personId: str
    photoUrl: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRelationshipInterest(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRelationshipStatus(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRightOfPublicityState(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED",
        "NOT_OK_TO_DISPLAY",
        "OK_TO_DISPLAY",
        "OK_TO_DISPLAY_IN_NON_ADS_COMMERCIAL_CONTEXT",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRosterDetails(
    typing_extensions.TypedDict, total=False
):
    abridgedRosterMemberships: _list[AppsPeopleOzExternalMergedpeopleapiRosterMember]
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    rosterMemberCount: AppsPeopleOzExternalMergedpeopleapiRosterMemberCount

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRosterMember(
    typing_extensions.TypedDict, total=False
):
    memberType: typing_extensions.Literal[
        "ROSTER_MEMBER_TYPE_UNSPECIFIED", "PERSON", "ROSTER"
    ]
    personId: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiRosterMemberCount(
    typing_extensions.TypedDict, total=False
):
    directGroupCount: str
    directUserCount: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSearchProfile(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    searchProfileData: SocialGraphApiProtoSearchProfileData

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSipAddress(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSkills(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSocialConnection(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    type: _list[
        typing_extensions.Literal[
            "SOCIAL_CONNECTION_UNKNOWN",
            "NO_CONNECTION",
            "GPLUS_SECOND_HOP",
            "DIRECT_CONNECTION",
            "SELF",
        ]
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSortKeys(
    typing_extensions.TypedDict, total=False
):
    affinity: _list[AppsPeopleOzExternalMergedpeopleapiAffinity]
    interactionRank: str
    lastName: str
    lastNameRaw: str
    name: str
    nameRaw: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSourceIdentity(
    typing_extensions.TypedDict, total=False
):
    container: typing_extensions.Literal[
        "UNKNOWN",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    containerType: typing_extensions.Literal[
        "UNKNOWN_CONTAINER",
        "PROFILE",
        "CONTACT",
        "CIRCLE",
        "PLACE",
        "ACCOUNT",
        "EXTERNAL_ACCOUNT",
        "DOMAIN_PROFILE",
        "DOMAIN_CONTACT",
        "DEVICE_CONTACT",
        "GOOGLE_GROUP",
        "NAMED_CHAT_ROOM",
        "UNNAMED_CHAT_ROOM",
        "AFFINITY",
        "RAW_DEVICE_CONTACT",
        "CONTACT_ANNOTATION",
        "DELEGATED_CONTACT",
    ]
    deleted: bool
    id: str
    lastUpdated: str
    lastUpdatedMicros: str
    sourceEtag: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiSshPublicKey(
    typing_extensions.TypedDict, total=False
):
    expirationTime: str
    fingerprint: str
    key: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiStructuredPhone(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    phoneNumber: AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber
    shortCode: AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode
    type: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumber(
    typing_extensions.TypedDict, total=False
):
    e164: str
    i18nData: AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiStructuredPhonePhoneNumberI18nData(
    typing_extensions.TypedDict, total=False
):
    countryCode: int
    internationalNumber: str
    isValid: bool
    nationalNumber: str
    regionCode: str
    validationResult: typing_extensions.Literal[
        "UNKNOWN",
        "IS_POSSIBLE",
        "INVALID_COUNTRY_CODE",
        "TOO_SHORT",
        "TOO_LONG",
        "IS_POSSIBLE_LOCAL_ONLY",
        "INVALID_LENGTH",
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiStructuredPhoneShortCode(
    typing_extensions.TypedDict, total=False
):
    code: str
    countryCode: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiTagline(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiTeamsExtendedData(
    typing_extensions.TypedDict, total=False
):
    adminTo: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    admins: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    dottedLineManagers: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    dottedLineReports: AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber
    failures: _list[
        typing_extensions.Literal[
            "UNKNOWN_FAILURE",
            "MANAGEMENT_CHAIN",
            "REPORTS",
            "DOTTED_LINE_REPORTS",
            "DOTTED_LINE_MANAGERS",
            "ADMINS",
            "ADMIN_TO",
        ]
    ]
    managementChain: _list[AppsPeopleOzExternalMergedpeopleapiPerson]
    reports: AppsPeopleOzExternalMergedpeopleapiPersonListWithTotalNumber

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiUserDefined(
    typing_extensions.TypedDict, total=False
):
    key: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiUserVisibleStats(
    typing_extensions.TypedDict, total=False
):
    incomingAnyCircleCount: str
    viewCount: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiVisibleToGuests(
    typing_extensions.TypedDict, total=False
):
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiWebContactsExtendedData(
    typing_extensions.TypedDict, total=False
):
    isIncomplete: bool

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiWebsite(
    typing_extensions.TypedDict, total=False
):
    formattedType: str
    metadata: AppsPeopleOzExternalMergedpeopleapiPersonFieldMetadata
    rel: _list[AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo]
    type: str
    value: str

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiWebsiteRelationshipInfo(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal[
        "UNKNOWN", "ME", "NOT_ME", "CONTRIBUTOR_TO", "PAST_CONTRIBUTOR_TO"
    ]

@typing.type_check_only
class AppsPeopleOzExternalMergedpeopleapiYoutubeExtendedData(
    typing_extensions.TypedDict, total=False
):
    channelData: _list[AppsPeopleOzExternalMergedpeopleapiChannelData]
    failure: AppsPeopleOzExternalMergedpeopleapiProductProfileFailure

@typing.type_check_only
class AssistantApiActionV2SupportedFeatures(typing_extensions.TypedDict, total=False):
    expressUrlInSettingsResponseSupported: bool
    reconnectClientInputSupported: bool
    simpleActionV2PuntSupported: bool
    supportedActionType: _list[str]
    takeScreenshotSupported: bool
    voiceDelightImmersiveUiSupported: bool
    voiceDelightStickersSupported: bool
    voiceDelightSuggestionsSupported: bool

@typing.type_check_only
class AssistantApiAndroidIntentCapabilities(typing_extensions.TypedDict, total=False):
    androidIntentCapability: _list[
        AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability
    ]

@typing.type_check_only
class AssistantApiAndroidIntentCapabilitiesAndroidIntentCapability(
    typing_extensions.TypedDict, total=False
):
    intentActionName: str
    packageNames: _list[str]

@typing.type_check_only
class AssistantApiAppCapabilities(typing_extensions.TypedDict, total=False):
    allowlistedForMediaFulfillment: bool
    appIntegrationsSettings: AssistantApiAppIntegrationsSettings
    disabledSystemApp: bool
    provider: AssistantApiCoreTypesProvider
    routableToProviderCloud: bool
    searchableOnDevice: bool
    searchableOnServer: bool
    supports3pPodcastPlayback: bool
    supportsScreenlessInitiation: bool
    whitelistedForAnnotation: bool

@typing.type_check_only
class AssistantApiAppCapabilitiesDelta(typing_extensions.TypedDict, total=False):
    appIntegrationsSettings: AssistantApiAppIntegrationsSettings
    providerDelta: AssistantApiCoreTypesProviderDelta

@typing.type_check_only
class AssistantApiAppControlSupport(typing_extensions.TypedDict, total=False):
    enabled: typing_extensions.Literal[
        "DEFAULT_DISABLED", "ENABLED_WITH_SMART_DICTATION"
    ]
    sendMessageSuppressed: bool

@typing.type_check_only
class AssistantApiAppIntegrationsSettings(typing_extensions.TypedDict, total=False):
    handleRequestsWithPredictedApps: typing_extensions.Literal["UNSET", "FALSE", "TRUE"]

@typing.type_check_only
class AssistantApiAssistantContinuedPresenceSupport(
    typing_extensions.TypedDict, total=False
):
    plateSupport: typing_extensions.Literal["DEFAULT_NO_PLATE", "SEARCH_ONLY"]

@typing.type_check_only
class AssistantApiAudioInput(typing_extensions.TypedDict, total=False):
    environment: typing_extensions.Literal[
        "SURROUNDING_USERS", "AUTHENTICATED_USER_ONLY"
    ]
    quality: typing_extensions.Literal["VOICE_QUALITY", "MUSIC_QUALITY"]

@typing.type_check_only
class AssistantApiAudioOutput(typing_extensions.TypedDict, total=False):
    alwaysOnSpeaker: typing_extensions.Literal["UNKNOWN", "NOT_SUPPORTED", "SUPPORTED"]
    environment: typing_extensions.Literal[
        "SURROUNDING_USERS", "AUTHENTICATED_USER_ONLY"
    ]
    mediaTtsMixable: typing_extensions.Literal[
        "MEDIA_TTS_MIXABLE_UNKNOWN",
        "MEDIA_TTS_MIXABLE_NOT_SUPPORTED",
        "MEDIA_TTS_MIXABLE_SUPPORTED",
    ]
    quality: typing_extensions.Literal["VOICE_QUALITY", "MUSIC_QUALITY"]
    volumeProperties: AssistantApiVolumeProperties

@typing.type_check_only
class AssistantApiBluetoothCapabilities(typing_extensions.TypedDict, total=False):
    isBluetoothConnectedProfileRequired: bool

@typing.type_check_only
class AssistantApiCallCapabilities(typing_extensions.TypedDict, total=False):
    callFormats: _list[
        typing_extensions.Literal["UNSPECIFIED_FORMAT", "AUDIO", "VIDEO", "TEXT"]
    ]
    callMediums: _list[
        typing_extensions.Literal[
            "UNSPECIFIED_MEDIUM",
            "PSTN",
            "VOIP",
            "EMAIL",
            "ONLINE_CHAT",
            "TEXT_MESSAGING",
            "MESSAGE",
        ]
    ]
    callOptions: _list[
        typing_extensions.Literal[
            "UNSPECIFIED_CALL_OPTION", "SPEAKERPHONE", "BLUETOOTH", "HEADSET"
        ]
    ]
    fallbackToTetheredDeviceAppCapabilities: bool
    supportedRecipientTypes: _list[
        typing_extensions.Literal[
            "UNSPECIFIED_ENDPOINT",
            "PHONE_NUMBER",
            "EMAIL_ADDRESS",
            "APP_UNIQUE_ID",
            "EMERGENCY_PHONE_NUMBER",
            "VOICEMAIL",
        ]
    ]
    supportsDuoEmailEndpoint: bool

@typing.type_check_only
class AssistantApiCameraCapabilities(typing_extensions.TypedDict, total=False):
    faceMatchCapable: bool
    hasCamera: bool

@typing.type_check_only
class AssistantApiCameraReceiverCapabilities(typing_extensions.TypedDict, total=False):
    hasLimitedCameraStreamCapability: bool
    supportedCameraReceivers: _list[AssistantApiCoreTypesCastAppInfo]

@typing.type_check_only
class AssistantApiCarAssistantCapabilities(typing_extensions.TypedDict, total=False):
    shouldPuntMultiAssistantMode: bool

@typing.type_check_only
class AssistantApiCarSettingsCapabilities(typing_extensions.TypedDict, total=False):
    playWarmerWelcome: bool
    supportsAddingCars: bool

@typing.type_check_only
class AssistantApiCastAssistantSettingLinkingResult(
    typing_extensions.TypedDict, total=False
):
    castLinkingStatus: typing_extensions.Literal[
        "NOT_SET",
        "SUCCEED",
        "DEVICE_CONFLICT",
        "DEVICE_NAME_EMPTY",
        "CLIENT_ID_MISSING_TAG",
        "INVALID_DEVICE_ID",
        "DATA_SYNC_THROTTLED",
        "CREATE_ROBOT_ACCOUNT_FAILED",
        "UNAUTHORIZED_CLIENT",
        "OTHER_ERROR",
    ]
    truncatedErrorMsg: str

@typing.type_check_only
class AssistantApiCastCapabilities(typing_extensions.TypedDict, total=False):
    cameraReceiverCapabilities: AssistantApiCameraReceiverCapabilities
    cameraStreamSupportedProtocols: _list[str]
    canReceiveCast: bool
    deviceId: AssistantApiCoreTypesDeviceId
    dynamicGroupsSupported: bool
    groupType: typing_extensions.Literal[
        "NONE", "STATIC_GROUP", "DYNAMIC_GROUP", "STEREO_PAIR"
    ]
    overlayApplicationsSupported: bool
    yetiGamingSupported: bool

@typing.type_check_only
class AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty(
    typing_extensions.TypedDict, total=False
):
    skipAndroidAndGsaVersionCheck: bool
    supportedSettings: _list[
        typing_extensions.Literal[
            "UNSPECIFIED",
            "ABOUT_ME",
            "ACCESSIBILITY",
            "ACTIVE_EDGE",
            "ACTIVE_EDGE_SENSITIVITY",
            "ADAPTIVE_BATTERY",
            "ADAPTIVE_BRIGHTNESS",
            "ADAPTIVE_CHARGING",
            "ADAPTIVE_CONNECTIVITY",
            "ADAPTIVE_SOUND",
            "ADD_ACCOUNT",
            "ADD_BLUETOOTH_DEVICE",
            "ADD_DEVICE",
            "ADD_FINGERPRINT",
            "ADS_TRACKING",
            "AIRPLANE_MODE",
            "ALARM_VOLUME",
            "ALARM_SOUND",
            "ALLOW_MULTIPLE_USERS",
            "AMBIENT_DISPLAY_ALWAYS_ON",
            "AMBIENT_DISPLAY_NEW_NOTIFICATION",
            "ANDROID_AUTO",
            "ANDROID_VERSION",
            "APP_BATTERY_USAGE",
            "APP_DATA_USAGE",
            "APP_DETAILS",
            "APP_SHORTCUT",
            "APPS_NOTIFICATIONS",
            "APPS_STORAGE",
            "ASSISTANT_ACCOUNT",
            "ASSISTANT_FACE_MATCH",
            "ASSISTANT_LANGUAGE",
            "ASSISTANT_VOICE_MATCH",
            "AUTO_ROTATE",
            "AUTO_ROTATE_FACE_DETECTION",
            "BACKUP",
            "BATTERY_HEALTH",
            "BATTERY_LEVEL",
            "BATTERY_LOW",
            "BATTERY_PERCENTAGE",
            "BATTERY_PRESENT",
            "BATTERY_SAVER",
            "BATTERY_SAVER_SCHEDULE",
            "BATTERY_SHARE",
            "BATTERY_USAGE",
            "BIOMETRIC",
            "BLUETOOTH",
            "BLUETOOTH_NAME",
            "BLUETOOTH_ADDRESS",
            "BLUETOOTH_SETTINGS",
            "BRIGHTNESS_LEVEL",
            "BUBBLES",
            "CALL_VOLUME",
            "CAMERA_DOUBLE_TWIST",
            "CAST",
            "CAR_CRASH_DETECTION",
            "COLOR_INVERSION",
            "COLOR_CORRECTION",
            "CONVERSATIONS",
            "CHARGING_SOUNDS_AND_VIBRATION",
            "CHARGING_STATE",
            "CONNECTED_DEVICES",
            "CONTACTLESS_PAYMENTS",
            "DATA_ROAMING",
            "DATA_SAVER",
            "DATA_USAGE",
            "DATA_LIMIT",
            "DATA_LIMIT_LEVEL",
            "DATA_WARNING",
            "DATA_WARNING_LEVEL",
            "DEFAULT_ALARM_SOUND",
            "DEFAULT_NOTIFICATION_SOUND",
            "DEFAULT_APPS",
            "DEVELOPER_OPTIONS",
            "DEVICE_ASSISTANT_APP",
            "DEVICE_NAME",
            "DISPLAY_OVER_OTHER_APPS",
            "DISPLAY_SIZE",
            "DO_NOT_DISTURB",
            "DO_NOT_DISTURB_MESSAGES",
            "DO_NOT_DISTURB_CALLS",
            "DO_NOT_DISTURB_ALARMS",
            "DO_NOT_DISTURB_SCHEDULES",
            "DOUBLE_TAP_CHECK_PHONE",
            "DRIVING_MODE",
            "EARTHQUAKE_ALERTS",
            "EMERGENCY",
            "EMERGENCY_ALERTS",
            "EMERGENCY_CONTACTS",
            "EMERGENCY_INFORMATION",
            "ETHERNET_TETHERING",
            "EXTRA_DIM",
            "EXTREME_BATTERY_SAVER",
            "FACTORY_RESET",
            "FIND_MY_DEVICE",
            "FLASHLIGHT",
            "FOCUS_MODE",
            "FONT_SIZE",
            "FREE_UP_SPACE",
            "FINGERPRINT_MANAGER",
            "GESTURES",
            "HAPTIC_FEEDBACK_VIBRATION",
            "HARD_KEYBOARD",
            "HEADS_UP",
            "HIGH_REFRESH_RATE",
            "HOT_SPOT",
            "HOTSPOT_TETHERING",
            "HOT_WORD",
            "HUB_MODE",
            "IP_ADDRESS",
            "IMPROVE_LOCATION_ACCURACY",
            "JUMP_TO_CAMERA",
            "KEYBOARD_SHORTCUTS",
            "LIFT_CHECK_PHONE",
            "LIVE_TRANSLATE",
            "LOCATION",
            "LOCATION_HISTORY",
            "LOCATION_BLUETOOTH_SCANNING",
            "LOCATION_WIFI_SCANNING",
            "LOCK_SCREEN",
            "LOCK_SCREEN_DEVICE_CONTROLS",
            "LOCK_SCREEN_WALLET",
            "MAC_ADDRESS",
            "MAGNIFICATION",
            "MAGNIFY_BUTTON",
            "MAGNIFY_TRIPLE_TAP",
            "MANIFY_BUTTON",
            "MANIFY_TRIPLE_TAP",
            "MEDIA",
            "MEDIA_VOLUME",
            "MICROPHONE_ACCESS",
            "MOBILE",
            "MOBILE_DATA",
            "MUSIC",
            "MUTE_MODE",
            "NETWORK",
            "NETWORK_RESET",
            "NFC",
            "NIGHT_LIGHT_INTENSITY",
            "NIGHT_LIGHT_SWITCH",
            "NIGHT_MODE",
            "NOTIFICATION_BADGE",
            "NOTIFICATION_SOUND",
            "NOTIFICATION_ON_SCREEN",
            "NOTIFICATION_HISTORY",
            "NOTIFY_FOR_PUBLIC_NETWORKS",
            "ONEHANDED_MODE",
            "OS_VERSION",
            "PASSWORD",
            "PERMISSION_MANAGER",
            "PERMISSION_USAGE",
            "PERSONALIZATION",
            "PRINTING",
            "PHONE_NUMBER",
            "PICTURE_IN_PICTURE",
            "POINTER_SPEED",
            "POWER_MENU",
            "REMINDERS",
            "REQUIRE_DEVICE_UNLOCK_FOR_NFC",
            "RINGTONE",
            "RING_VOLUME",
            "NEARBY_DEVICES_SCANNING",
            "NEARBY_SHARE",
            "SCREEN_LOCKING_SOUND",
            "SCREEN_MAGNIFICATION",
            "SCREEN_TIMEOUT",
            "SCREEN_LOCK",
            "SCREEN_SAVER",
            "SELECT_TO_SPEAK",
            "SET_TIME_AUTOMATICALLY",
            "SET_TIME_ZONE_AUTOMATICALLY",
            "SETTINGS",
            "SIM",
            "SIM_MANAGER",
            "SPEECH_RATE",
            "STORAGE_USAGE",
            "SWIPE_FOR_NOTIFICATION",
            "SWITCH_ACCESS",
            "SYSTEM_UPDATE",
            "SYSTEM_UPDATES",
            "SYSTEM_NAVIGATION",
            "SYSTEM_NAVIGATION_GESTURES",
            "SYSTEM_NAVIGATION_BUTTONS",
            "TALKBACK_PASSWORDS",
            "TEXT_TO_SPEECH",
            "TIME_ZONE",
            "UNUSED_APPS",
            "USB",
            "USB_TETHERING",
            "VERBOSE_TTS",
            "VIBRATE",
            "VIBRATION",
            "VIBRATION_MODE",
            "VOICE",
            "VOLUME_LEVEL",
            "WAKE_SCREEN_FOR_NOTIFICATIONS",
            "WALLPAPERS",
            "WEBVIEW",
            "WIFI",
            "WIFI_ADD_NETWORK",
            "WIFI_ADD_NETWORK_QR_CODE",
            "WIFI_CALLING",
            "WIFI_HOTSPOT",
            "ACCESSIBILITY_SELECT_TO_SPEAK",
            "CRISIS_ALERTS",
            "REGULATORY_LABELS",
            "SEND_FEEDBACK",
            "OS_BUILD_NUMBER",
            "ACCESSIBILITY_SHORTCUTS",
            "ACCESSIBILITY_MENU",
            "ACCESSIBILITY_SOUND_AMPLIFIER",
            "ACCESSIBILITY_LIVE_TRANSCRIBE",
            "ACCESSIBILITY_SOUND_NOTIFICATIONS",
            "ACCESSIBILITY_TALKBACK",
            "ACCESSIBILITY_TIMEOUT",
            "CAMERA_SETTINGS",
            "BATTERY_SAVER_TOGGLE",
            "COVID_NOTIFICATIONS",
            "APP_LOCATION",
            "LOCATION_SERVICES",
            "PRIVATE_DNS",
            "UNRESTRICTED_DATA",
            "PREFERRED_NETWORK",
            "NETWORK_PREFERENCES",
            "PASSWORDS_AND_ACCOUNTS",
            "PRIVACY_DASHBOARD",
            "MORE_SECURITY",
            "APP_PINNING",
            "CONFIRM_SIM_DELETION",
            "ENCRYPT_PHONE",
            "FACE_UNLOCK",
            "INSTALL_UNKNOWN_APPS",
            "NOW_PLAYING",
            "STAY_AWAKE",
            "ASSISTANT_VOICE",
            "RESET_BLUETOOTH_WIFI",
            "DEFAULT_PHONE_APP",
            "GOOGLE_ACCOUNT",
            "ACCESSIBILITY_CAPTION_SIZE_AND_STYLE",
            "ACCESSIBILITY_CAPTION_STYLE",
            "ACCESSIBILITY_CAPTION_TEXT",
            "ACCESSIBILITY_CAPTION_PREFERENCES",
            "ACCESSIBILITY_COLOR_AND_MOTION",
            "ACCESSIBILITY_BOLD_TEXT",
            "LIVE_CAPTION",
            "POWER_BUTTON_ENDS_CALL",
            "TOUCH_AND_HOLD_DELAY",
            "ACCESSIBILITY_VOICE_ACCESS",
            "SMS_PERMISSIONS",
            "SPECIAL_APP_ACCESS",
            "DARK_THEME_SCHEDULE",
            "LOCK_SCREEN_TEXT",
            "NIGHT_LIGHT_SCHEDULE",
            "AUTOFILL",
            "USAGE_AND_DIAGNOSTICS",
            "SENSITIVE_NOTIFICATIONS",
            "ENCRYPTION_AND_CREDENTIALS",
            "SPACIAL_AUDIO",
            "RESET_OPTIONS",
            "QUICK_TAP",
            "TIPS_AND_SUPPORT",
            "SCREEN_ATTENTION",
            "BLUETOOTH_TETHERING",
            "ALL_APPS",
            "EXTEND_UNLOCK",
            "CLEAR_CALLING",
            "GOOGLE_SETTINGS",
            "APP_LANGUAGES",
            "SIM_STATUS",
            "MICROPHONE_PERMISSIONS",
            "GOOGLE_PLAY_UPDATE",
            "ADD_GOOGLE_ACCOUNT",
            "ASSISTANT_SPOKEN_NOTIFICATIONS",
            "ABOUT_PHONE",
            "ACCOUNTS",
            "APPLICATION",
            "ASSISTANT",
            "AUDIO",
            "BATTERY",
            "BELL_SCHEDULE",
            "CONTINUED_CONVERSATION",
            "DATE_TIME",
            "DARK_THEME",
            "DEVICE_INFO",
            "DICTIONARY",
            "DIGITAL_WELLBEING",
            "DISPLAY",
            "LANGUAGE",
            "NIGHT_LIGHT",
            "NOTIFICATION",
            "NOTIFICATION_VOLUME",
            "PHONE_RINGTONE",
            "PRIVACY",
            "ROAMING",
            "ROUTINES",
            "SEARCH",
            "SECURITY",
            "SOUND",
            "SPELL_CHECKER",
            "SYSTEM",
            "STORAGE",
            "VPN",
            "AUTOCLICK",
            "CARET_HIGHLIGHT",
            "CHROMEVOX",
            "CURSOR_HIGHLIGHT",
            "DOCKED_MAGNIFIER",
            "FOCUS_HIGHLIGHT",
            "FULLSCREEN_MAGNIFIER",
            "HIGH_CONTRAST_MODE",
            "LARGE_CURSOR",
            "MONO_AUDIO",
            "STICKY_KEYS",
            "TAP_DRAGGING",
            "VIRTUAL_KEYBOARD",
            "WEARABLE_AMBIENT",
            "WEARABLE_NOISE_CANCELLATION",
            "WEARABLE_TOUCH_CONTROLS",
            "RAISE_TO_TALK",
            "BEDTIME_MODE",
            "THEATER_MODE",
            "TOUCH_LOCK",
            "PRESS_AND_HOLD",
            "WATCH_FACE",
            "NOTIFICATION_ANNOUNCEMENT",
        ]
    ]
    supportsDoNotDisturbWithDuration: bool
    supportsMuteUnmute: bool

@typing.type_check_only
class AssistantApiClientOpPropertiesProviderOpenClientOpProperty(
    typing_extensions.TypedDict, total=False
):
    keepsConversationAliveAfterOpeningApp: bool

@typing.type_check_only
class AssistantApiClockCapabilities(typing_extensions.TypedDict, total=False):
    maxSupportedAlarms: int
    maxSupportedExtendedTimerDuration: AssistantApiDuration
    maxSupportedTimerDuration: AssistantApiDuration
    maxSupportedTimers: int
    preferredStopwatchProvider: AssistantApiCoreTypesProvider
    restrictAlarmsToNext24h: bool

@typing.type_check_only
class AssistantApiCommunicationUiCapabilities(typing_extensions.TypedDict, total=False):
    fluidActionsUiType: typing_extensions.Literal["DEFAULT", "SIMPLIFIED"]

@typing.type_check_only
class AssistantApiContactLookupCapabilities(typing_extensions.TypedDict, total=False):
    fallbackToTetheredDevice: bool

@typing.type_check_only
class AssistantApiCoreTypesAndroidAppInfo(typing_extensions.TypedDict, total=False):
    accountType: str
    activityInfo: AssistantApiCoreTypesAndroidAppInfoActivityInfo
    androidIntent: str
    appUniqueId: str
    appVersion: int
    dataMimetype: str
    isBroadcastIntent: bool
    isDefault: bool
    localizedAppName: str
    longVersionCode: str
    mimetype: str
    packageName: str
    providerType: typing_extensions.Literal[
        "UNKNOWN_OEM_PROVIDER_TYPE", "RADIO_PROVIDER_TYPE", "SXM_RADIO_PROVIDER_TYPE"
    ]
    shortcutId: str
    targetClass: str
    versionName: str

@typing.type_check_only
class AssistantApiCoreTypesAndroidAppInfoActivityInfo(
    typing_extensions.TypedDict, total=False
):
    activeLaunchableActivities: _list[
        AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity
    ]

@typing.type_check_only
class AssistantApiCoreTypesAndroidAppInfoActivityInfoActivity(
    typing_extensions.TypedDict, total=False
):
    localizedActivityName: str
    shortClassName: str

@typing.type_check_only
class AssistantApiCoreTypesAndroidAppInfoDelta(
    typing_extensions.TypedDict, total=False
):
    androidAppInfo: AssistantApiCoreTypesAndroidAppInfo
    lastUpdateTimestamp: str
    updateType: typing_extensions.Literal["UNKNOWN_TYPE", "IS_INSTALLED", "IS_DELETED"]

@typing.type_check_only
class AssistantApiCoreTypesCalendarEvent(typing_extensions.TypedDict, total=False):
    attendees: _list[AssistantApiCoreTypesCalendarEventAttendee]
    backgroundColor: int
    calendarId: str
    creator: AssistantApiCoreTypesCalendarEventAttendee
    description: str
    end: AssistantApiDateTime
    eventId: str
    flairName: str
    foregroundColor: int
    guestsCanInviteOthers: bool
    guestsCanModify: bool
    guestsCanSeeGuests: bool
    habitId: str
    habitStatus: typing_extensions.Literal[
        "UNKNOWN_STATUS", "ACTIVE", "DEFERRAL_REQUESTED", "COMPLETE", "UNDEFERRABLE"
    ]
    htmlLink: str
    location: str
    meetingContacts: _list[AssistantApiCoreTypesCalendarEventMeetingContact]
    organizer: AssistantApiCoreTypesCalendarEventAttendee
    otherAttendeesExcluded: bool
    participationResponse: typing_extensions.Literal[
        "RESPONSE_STATUS_UNSPECIFIED",
        "NEEDS_ACTION",
        "DECLINED",
        "TENTATIVE",
        "ACCEPTED",
    ]
    recurringEventId: str
    rooms: _list[AssistantApiCoreTypesCalendarEventRoom]
    start: AssistantApiDateTime
    summary: str
    visibility: typing_extensions.Literal[
        "DEFAULT", "PUBLIC", "PRIVATE", "CONFIDENTIAL", "SECRET", "SHADOW", "UNKNOWN"
    ]

@typing.type_check_only
class AssistantApiCoreTypesCalendarEventAttendee(
    typing_extensions.TypedDict, total=False
):
    displayName: str
    email: str
    givenName: str
    id: str
    organizer: bool
    responseStatus: typing_extensions.Literal[
        "RESPONSE_STATUS_UNSPECIFIED",
        "NEEDS_ACTION",
        "DECLINED",
        "TENTATIVE",
        "ACCEPTED",
    ]
    self: bool

@typing.type_check_only
class AssistantApiCoreTypesCalendarEventMeetingContact(
    typing_extensions.TypedDict, total=False
):
    conferenceId: str
    dialInNumberClasses: _list[
        typing_extensions.Literal[
            "NUMBER_CLASS_UNSPECIFIED", "LOW_COST", "HIGH_COST", "LEGACY"
        ]
    ]
    phoneNumberUri: str
    pinNumber: str
    provider: AssistantApiCoreTypesProvider
    regionCode: str
    source: typing_extensions.Literal[
        "SOURCE_UNSPECIFIED", "STRUCTURED_DATA", "UNSTRUCTURED_DATA"
    ]
    universalPinNumber: str
    url: str

@typing.type_check_only
class AssistantApiCoreTypesCalendarEventRoom(typing_extensions.TypedDict, total=False):
    email: str
    locationDetails: AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails
    name: str

@typing.type_check_only
class AssistantApiCoreTypesCalendarEventRoomRoomLocationDetails(
    typing_extensions.TypedDict, total=False
):
    building: str
    city: str
    floor: str
    latitude: float
    longitude: float
    section: str
    simpleName: str

@typing.type_check_only
class AssistantApiCoreTypesCalendarEventWrapper(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantApiCoreTypesCastAppInfo(typing_extensions.TypedDict, total=False):
    castAppId: str
    contentAppId: str

@typing.type_check_only
class AssistantApiCoreTypesChromeOsAppInfo(typing_extensions.TypedDict, total=False):
    localizedAppName: str
    packageName: str

@typing.type_check_only
class AssistantApiCoreTypesCloudProviderInfo(typing_extensions.TypedDict, total=False):
    agentStyle: AssistantApiCoreTypesCloudProviderInfoAgentStyle
    directoryUrl: str
    logoUrl: str
    name: str

@typing.type_check_only
class AssistantApiCoreTypesCloudProviderInfoAgentStyle(
    typing_extensions.TypedDict, total=False
):
    backgroundColor: AssistantApiCoreTypesGovernedColor
    headerTheme: typing_extensions.Literal["DEFAULT", "DARK", "LIGHT"]
    landscapeBackgroundImageUrl: str
    logoUrl: str
    maskColor: AssistantApiCoreTypesGovernedColor
    portraitBackgroundImageUrl: str
    primaryColor: AssistantApiCoreTypesGovernedColor

@typing.type_check_only
class AssistantApiCoreTypesDeviceConfig(typing_extensions.TypedDict, total=False):
    agentId: str
    deviceId: str

@typing.type_check_only
class AssistantApiCoreTypesDeviceId(typing_extensions.TypedDict, total=False):
    agsaClientInstanceId: str
    alloDeviceId: str
    canonicalDeviceId: str
    castDeviceId: str
    clientInstanceId: str
    connectedDockId: str
    deviceConfig: AssistantApiCoreTypesDeviceConfig
    deviceType: str
    homeGraphDeviceId: str
    libassistantDeviceId: str
    multiHotwordArbitrationDeviceId: str
    opaIosDeviceId: str
    quartzDeviceId: str

@typing.type_check_only
class AssistantApiCoreTypesDeviceUserIdentity(typing_extensions.TypedDict, total=False):
    deviceId: AssistantApiCoreTypesDeviceId
    gaiaId: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedColor(typing_extensions.TypedDict, total=False):
    alpha: float
    blue: float
    green: float
    red: float

@typing.type_check_only
class AssistantApiCoreTypesGovernedDeviceConfig(
    typing_extensions.TypedDict, total=False
):
    agentId: str
    deviceId: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedDeviceId(typing_extensions.TypedDict, total=False):
    agsaClientInstanceId: str
    alloDeviceId: str
    canonicalDeviceId: str
    castDeviceId: str
    clientInstanceId: str
    connectedDockId: str
    deviceConfig: AssistantApiCoreTypesGovernedDeviceConfig
    deviceType: str
    homeGraphDeviceId: str
    libassistantDeviceId: str
    multiHotwordArbitrationDeviceId: str
    opaIosDeviceId: str
    quartzDeviceId: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadata(
    typing_extensions.TypedDict, total=False
):
    category: typing_extensions.Literal[
        "UNKNOWN_CATEGORY",
        "ANIMAL",
        "CHARACTER",
        "EMOTION",
        "INSTRUMENT",
        "MEDIA",
        "SPORTS_EQUIPMENT",
        "VEHICLE",
        "ON_DEVICE",
        "FUNTIME",
    ]
    characterAlarmMetadata: AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata
    characterTag: str
    entityMid: str
    funtimeMetadata: AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata
    genMlAlarmMetadata: AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata
    gentleWakeInfo: AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo
    onDeviceAlarmMetadata: AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata
    onDeviceAlarmSound: typing_extensions.Literal[
        "DEFAULT",
        "MELLOW",
        "MODERN_TIMES",
        "BEAUTIFUL_MIND",
        "LITTLE_SUNSHINE",
        "TOUCH_OF_ZEN",
        "ABOUT_TIME",
        "RANDOM",
        "BOROBUDUR",
        "PEBBLES",
        "BRIGHT_MORNING",
        "ACROSS_THE_VALLEY",
        "MORNING_SONG",
        "KYOTO",
        "AWAKEN",
        "CUCKOO",
        "DIGITAL_BLAST",
        "ACOUSTIC_SUNLIGHT",
        "SUNRISE_BOSSA",
        "CALM_GLOW",
        "ANTIQUE_CLOCK",
        "JUST_BIRDS",
        "JUNGLE_AMBIENCE",
        "QUAINT_VILLAGE",
        "BUBBLY_BOSSA",
        "ACOUSTIC_JAM",
        "EUPHORIC",
    ]
    routineAlarmMetadata: AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataCharacterAlarmMetadata(
    typing_extensions.TypedDict, total=False
):
    agentIds: _list[str]
    characterTags: _list[str]
    iconUrls: _list[str]

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataFuntimeMetadata(
    typing_extensions.TypedDict, total=False
):
    agentIds: _list[str]
    animationBlob: str
    animationUrl: str
    timerHeroUrl: str
    ttsServiceRequestBytes: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataGenMlAlarmMetadata(
    typing_extensions.TypedDict, total=False
):
    isEnabled: bool
    ringtoneLabel: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataGentleWakeInfo(
    typing_extensions.TypedDict, total=False
):
    effectDurationMs: str
    isEnabled: bool
    startTimedeltaMs: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataOnDeviceAlarmMetadata(
    typing_extensions.TypedDict, total=False
):
    onDeviceAlarmSound: typing_extensions.Literal[
        "DEFAULT",
        "MELLOW",
        "MODERN_TIMES",
        "BEAUTIFUL_MIND",
        "LITTLE_SUNSHINE",
        "TOUCH_OF_ZEN",
        "ABOUT_TIME",
        "RANDOM",
        "BOROBUDUR",
        "PEBBLES",
        "BRIGHT_MORNING",
        "ACROSS_THE_VALLEY",
        "MORNING_SONG",
        "KYOTO",
        "AWAKEN",
        "CUCKOO",
        "DIGITAL_BLAST",
        "ACOUSTIC_SUNLIGHT",
        "SUNRISE_BOSSA",
        "CALM_GLOW",
        "ANTIQUE_CLOCK",
        "JUST_BIRDS",
        "JUNGLE_AMBIENCE",
        "QUAINT_VILLAGE",
        "BUBBLY_BOSSA",
        "ACOUSTIC_JAM",
        "EUPHORIC",
    ]
    onDeviceAlarmSoundLabel: str
    ttsServiceRequestBytes: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedRingtoneTaskMetadataRoutineAlarmMetadata(
    typing_extensions.TypedDict, total=False
):
    routineId: str

@typing.type_check_only
class AssistantApiCoreTypesGovernedSurfaceIdentity(
    typing_extensions.TypedDict, total=False
):
    deviceId: AssistantApiCoreTypesDeviceId
    legacySurfaceType: typing_extensions.Literal[
        "UNKNOWN",
        "ANDROID_ALLO",
        "ANDROID_AUTO",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_TV_KIDS",
        "ANDROID_WEAR",
        "AR_GLASSES",
        "ASSISTANT_SDK",
        "AUDIOWEAR",
        "BUBBLE_CHARACTERS_IOS",
        "CAPABILITY_BASED_SURFACE",
        "CHROMECAST_ASSISTANT",
        "CHROMECAST_MANHATTAN",
        "CHROMECAST_SEARCH",
        "CLOUD_DEVICE",
        "COMPANION_SCREEN",
        "DYNAMITE_WEB",
        "ENSEMBLE",
        "EYESFREE_AGSA",
        "EYESFREE_GMM",
        "GBOARD",
        "GLASS",
        "GOOGLE_HOME",
        "HANGOUTS_CHATBOT",
        "IOS_ALLO",
        "IOS_GSA",
        "IOS_WEAR",
        "LIBASSISTANT",
        "LINE_CHATBOT",
        "MULTIMODAL_AGSA",
        "NON_ASSISTANT_SURFACE",
        "OPA_AGSA",
        "OPA_AGSA_CHROME_OS",
        "OPA_ANDROID_AUTO",
        "OPA_ANDROID_LITE",
        "OPA_ANDROID_SCREENLESS",
        "OPA_ANDROID_SMART_DISPLAY",
        "OPA_ANDROID_TABLET",
        "OPA_CROS",
        "OPA_GACS",
        "OPA_IOS",
        "OPA_IOS_SCREENLESS",
        "OPA_KAIOS",
        "OPA_MOBILE_WEB",
        "RTOS_PHONE",
        "SMS_CHATBOT",
        "TELEGRAM_CHATBOT",
        "TELEPHONE_ASSISTANT",
        "VERILY_ONDUO",
        "YOUTUBE_APP",
        "AGSA_BISTO_FOR_EVAL",
        "COGSWORTH_FOR_EVAL",
        "LOCKHART_MIC_FOR_EVAL",
        "OPA_ANDROID_AUTO_EMBEDDED_FAKE",
        "SPARK",
        "WALLE",
        "UNIT_TESTING",
    ]
    surfaceType: typing_extensions.Literal[
        "UNKNOWN_TYPE",
        "ACCL",
        "AGSA",
        "ANDROID",
        "ANDROID_AUTO",
        "ANDROID_LITE",
        "ANDROID_PHONE",
        "ANDROID_SCREENLESS",
        "ANDROID_SMART_DISPLAY",
        "ANDROID_TABLET",
        "ANDROID_THINGS",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_WEAR",
        "ASSISTANT_KIT",
        "ASSISTANT_SDK",
        "AUTO",
        "CAST_OS",
        "CHROME_OS",
        "CHROMECAST_MANHATTAN",
        "CLOUD_DEVICE",
        "CROS",
        "FITBIT_OS_WATCH",
        "FITBIT_OS_WATCH_ANDROID",
        "FITBIT_OS_WATCH_IOS",
        "GOOGLE_HOME",
        "HEADPHONE",
        "HEADPHONE_ANDROID",
        "HEADPHONE_IOS",
        "IOPA",
        "IOS",
        "IOS_SCREENLESS",
        "IPAD",
        "IPHONE",
        "KAI_OS",
        "KAI_OS_AMA",
        "LIBASSISTANT",
        "PHONE",
        "PIXEL",
        "PIXEL5",
        "PIXEL6",
        "PIXEL7",
        "PIXEL8",
        "PIXEL_BUDS",
        "PIXEL_TABLET",
        "PIXEL_TABLET_HUB_MODE",
        "PIXEL_TABLET_PERSONAL_MODE",
        "PIXEL_WATCH",
        "SCREENLESS",
        "SMART_DISPLAY",
        "SPEAKER",
        "TABLET",
        "TELEPHONE",
        "THING",
        "WATCH",
        "WEAR_OS",
        "WEAR_OS_WATCH",
    ]
    surfaceVersion: AssistantApiCoreTypesGovernedSurfaceVersion

@typing.type_check_only
class AssistantApiCoreTypesGovernedSurfaceVersion(
    typing_extensions.TypedDict, total=False
):
    major: int
    minor: int

@typing.type_check_only
class AssistantApiCoreTypesHomeAppInfo(typing_extensions.TypedDict, total=False):
    localizedAppName: str
    packageName: str

@typing.type_check_only
class AssistantApiCoreTypesImage(typing_extensions.TypedDict, total=False):
    accessibilityText: str
    appIconIdentifier: str
    badgeImage: AssistantApiCoreTypesImage
    content: str
    height: int
    imageSource: typing_extensions.Literal[
        "UNKNOWN", "PLACEHOLDER", "VISUAL_DICT", "LAVD", "VISUAL_DICT_DEFAULT_LOCALE"
    ]
    jsonContent: str
    letterDrawableText: str
    providerUrl: str
    sourceUrl: str
    sourceUrlType: typing_extensions.Literal[
        "DEFAULT_URL_TYPE", "LOTTIE", "DUO_CLIENT", "CONTACT_ID", "GLIDE_CACHE_ID"
    ]
    width: int

@typing.type_check_only
class AssistantApiCoreTypesInternalProviderInfo(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal[
        "UNKNOWN_INTERNAL_PROVIDER_TYPE",
        "AUDIO_PLAYER",
        "AUDIO_PLAYER_V2",
        "MEDIA_PLAYER",
        "MEDIA_PLAYER_IOS",
        "AUDIO_ONLY_PLAYER",
        "NARRATED_WEB_MEDIA_PLAYER",
        "LIBASSISTANT_MEDIA_PLAYER",
        "LENS_PLAYER",
        "NEWS_PLAYER",
    ]

@typing.type_check_only
class AssistantApiCoreTypesIosAppInfo(typing_extensions.TypedDict, total=False):
    bundleIdentifier: str
    localizedAppName: str
    openAppUrl: str

@typing.type_check_only
class AssistantApiCoreTypesKaiOsAppInfo(typing_extensions.TypedDict, total=False):
    localizedAppName: str
    openAppUrl: str
    packageName: str

@typing.type_check_only
class AssistantApiCoreTypesLocationCoordinates(
    typing_extensions.TypedDict, total=False
):
    accuracyMeters: float
    latDegrees: float
    lngDegrees: float

@typing.type_check_only
class AssistantApiCoreTypesMessageNotification(
    typing_extensions.TypedDict, total=False
):
    appName: str
    bundleId: str
    dataUri: str
    groupName: str
    groupingKey: str
    index: int
    markAsReadActionAvailable: bool
    messageLength: int
    messageRecipientType: typing_extensions.Literal["UNKNOWN", "INDIVIDUAL", "GROUP"]
    messageWordCount: int
    mimeType: str
    notificationEntries: _list[
        AssistantApiCoreTypesMessageNotificationNotificationEntry
    ]
    notificationIconKey: str
    notificationKey: str
    opaqueToken: str
    packageName: str
    postTime: str
    replyActionAvailable: bool
    sender: AssistantApiCoreTypesMessageNotificationPerson
    senderName: str

@typing.type_check_only
class AssistantApiCoreTypesMessageNotificationNotificationEntry(
    typing_extensions.TypedDict, total=False
):
    charCount: int
    dataUri: str
    messageBody: str
    mimeType: str
    postTime: str
    sender: AssistantApiCoreTypesMessageNotificationPerson
    wordCount: int

@typing.type_check_only
class AssistantApiCoreTypesMessageNotificationPerson(
    typing_extensions.TypedDict, total=False
):
    isImportant: bool
    key: str
    name: str

@typing.type_check_only
class AssistantApiCoreTypesProvider(typing_extensions.TypedDict, total=False):
    androidAppInfo: AssistantApiCoreTypesAndroidAppInfo
    castAppInfo: AssistantApiCoreTypesCastAppInfo
    chromeosAppInfo: AssistantApiCoreTypesChromeOsAppInfo
    cloudProviderInfo: AssistantApiCoreTypesCloudProviderInfo
    fallbackUrl: str
    homeAppInfo: AssistantApiCoreTypesHomeAppInfo
    iconImageUrl: str
    internalProviderInfo: AssistantApiCoreTypesInternalProviderInfo
    iosAppInfo: AssistantApiCoreTypesIosAppInfo
    kaiosAppInfo: AssistantApiCoreTypesKaiOsAppInfo
    sipProviderInfo: AssistantApiCoreTypesSipProviderInfo
    webProviderInfo: AssistantApiCoreTypesWebProviderInfo

@typing.type_check_only
class AssistantApiCoreTypesProviderDelta(typing_extensions.TypedDict, total=False):
    androidAppInfoDelta: AssistantApiCoreTypesAndroidAppInfoDelta
    fallbackUrl: str
    iconImageUrl: str

@typing.type_check_only
class AssistantApiCoreTypesSipProviderInfo(typing_extensions.TypedDict, total=False):
    providerId: str
    realm: str
    useBirdsongTacl: bool

@typing.type_check_only
class AssistantApiCoreTypesSurfaceIdentity(typing_extensions.TypedDict, total=False):
    deviceId: AssistantApiCoreTypesDeviceId
    legacySurfaceType: typing_extensions.Literal[
        "UNKNOWN",
        "ANDROID_ALLO",
        "ANDROID_AUTO",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_TV_KIDS",
        "ANDROID_WEAR",
        "AR_GLASSES",
        "ASSISTANT_SDK",
        "AUDIOWEAR",
        "BUBBLE_CHARACTERS_IOS",
        "CAPABILITY_BASED_SURFACE",
        "CHROMECAST_ASSISTANT",
        "CHROMECAST_MANHATTAN",
        "CHROMECAST_SEARCH",
        "CLOUD_DEVICE",
        "COMPANION_SCREEN",
        "DYNAMITE_WEB",
        "ENSEMBLE",
        "EYESFREE_AGSA",
        "EYESFREE_GMM",
        "GBOARD",
        "GLASS",
        "GOOGLE_HOME",
        "HANGOUTS_CHATBOT",
        "IOS_ALLO",
        "IOS_GSA",
        "IOS_WEAR",
        "LIBASSISTANT",
        "LINE_CHATBOT",
        "MULTIMODAL_AGSA",
        "NON_ASSISTANT_SURFACE",
        "OPA_AGSA",
        "OPA_AGSA_CHROME_OS",
        "OPA_ANDROID_AUTO",
        "OPA_ANDROID_LITE",
        "OPA_ANDROID_SCREENLESS",
        "OPA_ANDROID_SMART_DISPLAY",
        "OPA_ANDROID_TABLET",
        "OPA_CROS",
        "OPA_GACS",
        "OPA_IOS",
        "OPA_IOS_SCREENLESS",
        "OPA_KAIOS",
        "OPA_MOBILE_WEB",
        "RTOS_PHONE",
        "SMS_CHATBOT",
        "TELEGRAM_CHATBOT",
        "TELEPHONE_ASSISTANT",
        "VERILY_ONDUO",
        "YOUTUBE_APP",
        "AGSA_BISTO_FOR_EVAL",
        "COGSWORTH_FOR_EVAL",
        "LOCKHART_MIC_FOR_EVAL",
        "OPA_ANDROID_AUTO_EMBEDDED_FAKE",
        "SPARK",
        "WALLE",
        "UNIT_TESTING",
    ]
    surfaceType: typing_extensions.Literal[
        "UNKNOWN_TYPE",
        "ACCL",
        "AGSA",
        "ANDROID",
        "ANDROID_AUTO",
        "ANDROID_LITE",
        "ANDROID_PHONE",
        "ANDROID_SCREENLESS",
        "ANDROID_SMART_DISPLAY",
        "ANDROID_TABLET",
        "ANDROID_THINGS",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_WEAR",
        "ASSISTANT_KIT",
        "ASSISTANT_SDK",
        "AUTO",
        "CAST_OS",
        "CHROME_OS",
        "CHROMECAST_MANHATTAN",
        "CLOUD_DEVICE",
        "CROS",
        "FITBIT_OS_WATCH",
        "FITBIT_OS_WATCH_ANDROID",
        "FITBIT_OS_WATCH_IOS",
        "GOOGLE_HOME",
        "HEADPHONE",
        "HEADPHONE_ANDROID",
        "HEADPHONE_IOS",
        "IOPA",
        "IOS",
        "IOS_SCREENLESS",
        "IPAD",
        "IPHONE",
        "KAI_OS",
        "KAI_OS_AMA",
        "LIBASSISTANT",
        "PHONE",
        "PIXEL",
        "PIXEL5",
        "PIXEL6",
        "PIXEL7",
        "PIXEL8",
        "PIXEL_BUDS",
        "PIXEL_TABLET",
        "PIXEL_TABLET_HUB_MODE",
        "PIXEL_TABLET_PERSONAL_MODE",
        "PIXEL_WATCH",
        "SCREENLESS",
        "SMART_DISPLAY",
        "SPEAKER",
        "TABLET",
        "TELEPHONE",
        "THING",
        "WATCH",
        "WEAR_OS",
        "WEAR_OS_WATCH",
    ]
    surfaceTypeString: str
    surfaceVersion: AssistantApiCoreTypesSurfaceVersion

@typing.type_check_only
class AssistantApiCoreTypesSurfaceType(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "UNKNOWN",
        "ANDROID_ALLO",
        "ANDROID_AUTO",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_TV_KIDS",
        "ANDROID_WEAR",
        "AR_GLASSES",
        "ASSISTANT_SDK",
        "AUDIOWEAR",
        "BUBBLE_CHARACTERS_IOS",
        "CAPABILITY_BASED_SURFACE",
        "CHROMECAST_ASSISTANT",
        "CHROMECAST_MANHATTAN",
        "CHROMECAST_SEARCH",
        "CLOUD_DEVICE",
        "COMPANION_SCREEN",
        "DYNAMITE_WEB",
        "ENSEMBLE",
        "EYESFREE_AGSA",
        "EYESFREE_GMM",
        "GBOARD",
        "GLASS",
        "GOOGLE_HOME",
        "HANGOUTS_CHATBOT",
        "IOS_ALLO",
        "IOS_GSA",
        "IOS_WEAR",
        "LIBASSISTANT",
        "LINE_CHATBOT",
        "MULTIMODAL_AGSA",
        "NON_ASSISTANT_SURFACE",
        "OPA_AGSA",
        "OPA_AGSA_CHROME_OS",
        "OPA_ANDROID_AUTO",
        "OPA_ANDROID_LITE",
        "OPA_ANDROID_SCREENLESS",
        "OPA_ANDROID_SMART_DISPLAY",
        "OPA_ANDROID_TABLET",
        "OPA_CROS",
        "OPA_GACS",
        "OPA_IOS",
        "OPA_IOS_SCREENLESS",
        "OPA_KAIOS",
        "OPA_MOBILE_WEB",
        "RTOS_PHONE",
        "SMS_CHATBOT",
        "TELEGRAM_CHATBOT",
        "TELEPHONE_ASSISTANT",
        "VERILY_ONDUO",
        "YOUTUBE_APP",
        "AGSA_BISTO_FOR_EVAL",
        "COGSWORTH_FOR_EVAL",
        "LOCKHART_MIC_FOR_EVAL",
        "OPA_ANDROID_AUTO_EMBEDDED_FAKE",
        "SPARK",
        "WALLE",
        "UNIT_TESTING",
    ]

@typing.type_check_only
class AssistantApiCoreTypesSurfaceVersion(typing_extensions.TypedDict, total=False):
    major: int
    minor: int

@typing.type_check_only
class AssistantApiCoreTypesWebProviderInfo(typing_extensions.TypedDict, total=False):
    homeStorage: str
    localizedAppName: str
    openAppUrl: str
    thirdPartyCustomNluInfo: AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo

@typing.type_check_only
class AssistantApiCoreTypesWebProviderInfoThirdPartyCustomNluInfo(
    typing_extensions.TypedDict, total=False
):
    locale: str
    nluAgentId: str
    nluAgentVersion: str

@typing.type_check_only
class AssistantApiCrossDeviceExecutionCapability(
    typing_extensions.TypedDict, total=False
):
    localConnectivityEnabled: bool
    remoteCastMediaEnabled: bool

@typing.type_check_only
class AssistantApiDataValidateCapabilities(typing_extensions.TypedDict, total=False):
    fallbackToTetheredDevice: bool

@typing.type_check_only
class AssistantApiDate(typing_extensions.TypedDict, total=False):
    day: int
    month: int
    year: int

@typing.type_check_only
class AssistantApiDateTime(typing_extensions.TypedDict, total=False):
    date: AssistantApiDate
    timeOfDay: AssistantApiTimeOfDay
    timeZone: AssistantApiTimeZone

@typing.type_check_only
class AssistantApiDateTimeRange(typing_extensions.TypedDict, total=False):
    endDate: AssistantApiDateTime
    startDate: AssistantApiDateTime

@typing.type_check_only
class AssistantApiDeviceCapabilities(typing_extensions.TypedDict, total=False):
    androidIntentCapabilities: AssistantApiAndroidIntentCapabilities
    assistantCapability: typing_extensions.Literal[
        "UNKNOWN", "SUPPORTED", "UNSUPPORTED"
    ]
    audioInput: AssistantApiAudioInput
    audioOutput: AssistantApiAudioOutput
    bluetoothCapabilities: AssistantApiBluetoothCapabilities
    callCapabilities: AssistantApiCallCapabilities
    camera: AssistantApiCameraCapabilities
    carUxRestrictions: _list[
        typing_extensions.Literal[
            "UX_RESTRICTIONS_UNSPECIFIED",
            "UX_RESTRICTIONS_BASELINE",
            "UX_RESTRICTIONS_FULLY_RESTRICTED",
            "UX_RESTRICTIONS_NO_KEYBOARD",
            "UX_RESTRICTIONS_NO_VIDEO",
        ]
    ]
    cast: AssistantApiCastCapabilities
    communicationUiCapabilities: AssistantApiCommunicationUiCapabilities
    contactLookupCapabilities: AssistantApiContactLookupCapabilities
    dataValidateCapabilities: AssistantApiDataValidateCapabilities
    deviceId: AssistantApiCoreTypesDeviceId
    deviceUxMode: typing_extensions.Literal[
        "DEVICE_UX_MODE_DEFAULT", "DEVICE_UX_MODE_SUPPORT_LIMITED_SHARED_LOCKSCREEN"
    ]
    hasVoiceTelephony: bool
    jwnCapabilities: AssistantApiJwnCapabilities
    lensPerceptionCapabilities: AssistantApiLensPerceptionCapabilities
    location: AssistantApiLocationCapabilities
    loggingOnlyData: AssistantApiLoggingOnlyData
    messageCapabilities: AssistantApiMessageCapabilities
    movement: AssistantApiMovementCapabilities
    notificationCapabilities: typing_extensions.Literal[
        "NO_NOTIFICATION_CAPABILITY", "NOTIFICATIONS_DISABLED", "NOTIFICATIONS_ENABLED"
    ]
    notificationOutputRestrictions: AssistantApiNotificationOutputRestrictions
    outputRestrictions: AssistantApiOutputRestrictions
    popOnLockscreenCapability: typing_extensions.Literal[
        "POP_ON_LOCKSCREEN_DEFAULT",
        "POP_ON_LOCKSCREEN_ENABLED",
        "POP_ON_LOCKSCREEN_DISABLED",
    ]
    safetyRestrictions: typing_extensions.Literal[
        "DEFAULT_NO_SAFETY_RESTRICTION", "DISTRACTION_SAFETY_RESTRICTION"
    ]
    screen: AssistantApiScreenCapabilities
    sodaCapabilities: AssistantApiSodaCapabilities
    software: AssistantApiSoftwareCapabilities
    speechCapabilities: AssistantApiSpeechCapabilities
    supportedLocale: _list[str]
    surfaceIdentity: AssistantApiCoreTypesSurfaceIdentity
    surfaceTypeString: str
    systemNotificationRestrictions: AssistantApiSystemNotificationRestrictions
    thirdPartyCapabilities: AssistantApiThirdPartyCapabilities

@typing.type_check_only
class AssistantApiDuration(typing_extensions.TypedDict, total=False):
    nanos: int
    seconds: str

@typing.type_check_only
class AssistantApiFeatureSpecificActionSupport(
    typing_extensions.TypedDict, total=False
):
    clarificationDataSupported: bool

@typing.type_check_only
class AssistantApiFitnessFeatureSupport(typing_extensions.TypedDict, total=False):
    supportedActivities: _list[
        typing_extensions.Literal[
            "TYPE_UNSPECIFIED",
            "WALK",
            "RUN",
            "ELLIPTICAL",
            "SWIM",
            "WEIGHTS",
            "TREADMILL",
            "BIKE",
            "YOGA",
            "WORKOUT",
            "BOOT_CAMP",
            "CIRCUIT_TRAINING",
            "GOLF",
            "HIKING",
            "INTERVAL_TRAINING",
            "KICKBOXING",
            "MARTIAL_ARTS",
            "PILATES",
            "SPINNING",
            "STAIR_CLIMBING",
            "TENNIS",
            "AEROBICS",
            "CORE_TRAINING",
            "DANCING",
            "HIGH_INTENSITY_INTERVAL_TRAINING",
            "KAYAKING",
            "ROWING",
            "SKIING",
            "STANDUP_PADDLEBOARDING",
            "STRENGTH_TRAINING",
            "SNOWBOARDING",
        ]
    ]

@typing.type_check_only
class AssistantApiFluidActionsSupport(typing_extensions.TypedDict, total=False):
    stateSyncMethod: typing_extensions.Literal[
        "STATE_SYNC_METHOD_UNSPECIFIED", "DIALOG_STATE_PARAMS"
    ]

@typing.type_check_only
class AssistantApiGacsCapabilities(typing_extensions.TypedDict, total=False):
    deviceId: AssistantApiCoreTypesDeviceId
    responseConfig: GoogleAssistantAccessoryV1ResponseConfig
    ttsEncoding: typing_extensions.Literal[
        "LINEAR_16BIT",
        "MULAW",
        "ALAW",
        "MP3",
        "MP3_64KBPS",
        "SPEEX",
        "SPEEX_WITH_HEADER_BYTE",
        "SPEEX_IN_OGG",
        "OPUS_IN_OGG",
        "OPUS_24KBPS_IN_OGG",
        "OPUS_16KBPS_IN_OGG",
        "OPUS_12KBPS_IN_OGG",
        "OPUS_16KBPS_CONTAINERLESS",
        "OPUS_24KBPS_CONTAINERLESS",
        "OPUS_32KBPS_CONTAINERLESS",
    ]

@typing.type_check_only
class AssistantApiGcmCapabilities(typing_extensions.TypedDict, total=False):
    gcmRegistrationId: str
    supportsAssistantGcm: bool
    supportsClientInputOverGcm: bool

@typing.type_check_only
class AssistantApiGestureCapabilities(typing_extensions.TypedDict, total=False):
    gestureSensing: bool
    omniswipeGestureCapable: bool
    tapGestureCapable: bool

@typing.type_check_only
class AssistantApiGuestAccessOutput(typing_extensions.TypedDict, total=False):
    guestAccessOnYoutube: typing_extensions.Literal[
        "UNKNOWN_GUEST_ACCESS", "USE_DEFAULT_ACCOUNT_FOR_GUEST", "DISABLED_FOR_GUEST"
    ]

@typing.type_check_only
class AssistantApiImmersiveCanvasSupport(typing_extensions.TypedDict, total=False):
    confirmationMessageSupported: bool
    pauseSignalSupported: bool

@typing.type_check_only
class AssistantApiJwnCapabilities(typing_extensions.TypedDict, total=False):
    librariesVersionMap: dict[str, typing.Any]
    supportedCompressionMode: _list[
        typing_extensions.Literal["NONE", "BROTLI", "FLATE"]
    ]
    supportsJwn: bool

@typing.type_check_only
class AssistantApiLensPerceptionCapabilities(typing_extensions.TypedDict, total=False):
    hasLensPerception: bool
    isLensDirectIntentAvailable: bool
    isLensLiveViewfinderAvailable: bool
    isLensPostCaptureAvailable: bool
    lensCapabilities: AssistantApiLensPerceptionCapabilitiesLensCapabilities

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilities(
    typing_extensions.TypedDict, total=False
):
    dining: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining
    education: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation
    outdoor: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor
    shopping: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping
    text: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText
    translate: AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesDining(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesEducation(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesOutdoor(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesShopping(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesText(
    typing_extensions.TypedDict, total=False
):
    isTextToSpeechSupported: bool

@typing.type_check_only
class AssistantApiLensPerceptionCapabilitiesLensCapabilitiesTranslate(
    typing_extensions.TypedDict, total=False
):
    supportedLanguageTags: _list[str]

@typing.type_check_only
class AssistantApiLiveTvChannelCapabilities(typing_extensions.TypedDict, total=False):
    channelsByProvider: _list[AssistantApiLiveTvChannelCapabilitiesChannelsByProvider]

@typing.type_check_only
class AssistantApiLiveTvChannelCapabilitiesChannelsByProvider(
    typing_extensions.TypedDict, total=False
):
    channels: _list[AssistantApiLiveTvChannelCapabilitiesLiveTvChannel]
    inputId: str
    providerType: typing_extensions.Literal[
        "UNKNOWN_PROVIDER_TYPE", "OTT_PROVIDER", "TUNER"
    ]

@typing.type_check_only
class AssistantApiLiveTvChannelCapabilitiesLiveTvChannel(
    typing_extensions.TypedDict, total=False
):
    channelId: str
    channelName: _list[str]
    channelNumber: str
    deeplink: str
    mid: str
    networkMid: str

@typing.type_check_only
class AssistantApiLiveTvProvider(typing_extensions.TypedDict, total=False):
    providerInfo: AssistantApiCoreTypesProvider
    providerKey: str
    providerType: typing_extensions.Literal[
        "UNKNOWN_PROVIDER_TYPE", "OTT_PROVIDER", "TUNER"
    ]

@typing.type_check_only
class AssistantApiLocationCapabilities(typing_extensions.TypedDict, total=False):
    gpsAvailable: bool

@typing.type_check_only
class AssistantApiLoggingOnlyData(typing_extensions.TypedDict, total=False):
    acpVersion: str
    androidId: str
    appVersion: str
    assistantSettingsSource: typing_extensions.Literal[
        "NOT_SET",
        "FIRST_SCREEN_DEVICE_OOBE",
        "FIRST_SCREEN_KATNISS_OOBE",
        "FIRST_SCREEN_DELEGATION_OOBE",
        "FIRST_SCREEN_FIXER_JOB",
        "FIRST_SCREEN_FCM_JOB",
        "FIRST_SCREEN_HOME_GRAPH_JOB",
        "FIRST_SCREEN_PERSONAL_BIT",
        "FIRST_SCREEN_VOICE_INPUT_BIT",
        "FIRST_SCREEN_OTHER",
        "SECOND_SCREEN_AGSA",
        "SECOND_SCREEN_GHA_IOS",
        "SECOND_SCREEN_GHA_ANDROID",
    ]
    boardName: str
    boardRevision: str
    castAssistantSettingLinkingResult: AssistantApiCastAssistantSettingLinkingResult
    deviceModel: str
    embedderBuildInfo: str
    initialAppVersion: str
    isPrimaryUser: bool
    mdnsDisplayName: str
    platformBuild: str
    virtualReleaseChannel: str

@typing.type_check_only
class AssistantApiMediaControlSupport(typing_extensions.TypedDict, total=False):
    skipConfirmationsWhilePlaying: bool

@typing.type_check_only
class AssistantApiMessageCapabilities(typing_extensions.TypedDict, total=False):
    fallbackToTetheredDeviceAppCapabilities: bool
    preferTargetingPrimaryDevice: bool
    supportedRecipientTypes: _list[
        typing_extensions.Literal[
            "UNSPECIFIED_ENDPOINT",
            "PHONE_NUMBER",
            "EMAIL_ADDRESS",
            "APP_UNIQUE_ID",
            "EMERGENCY_PHONE_NUMBER",
            "VOICEMAIL",
        ]
    ]

@typing.type_check_only
class AssistantApiMovementCapabilities(typing_extensions.TypedDict, total=False):
    mobility: typing_extensions.Literal[
        "UNSPECIFIED", "LOW", "MEDIUM", "HIGH", "VERY_HIGH"
    ]

@typing.type_check_only
class AssistantApiNotificationOutputRestrictions(
    typing_extensions.TypedDict, total=False
):
    optOutState: AssistantApiNotificationOutputRestrictionsOptOutState

@typing.type_check_only
class AssistantApiNotificationOutputRestrictionsOptOutState(
    typing_extensions.TypedDict, total=False
):
    categoryGroupState: _list[
        AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState
    ]
    categoryState: _list[
        AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState
    ]

@typing.type_check_only
class AssistantApiNotificationOutputRestrictionsOptOutStateCategoryGroupState(
    typing_extensions.TypedDict, total=False
):
    categoryGroup: typing_extensions.Literal[
        "UNSPECIFIED",
        "SYSTEM",
        "PROMOTIONAL",
        "SUBSCRIPTIONS",
        "PROACTIVE",
        "REMINDERS",
        "EXTENDED_ANSWERS",
        "FEEDBACK",
        "ACTIONS_ON_GOOGLE",
        "DUO_MISSED_CALLS",
        "HOME_AUTOMATION",
        "GETTING_AROUND",
        "UNIT_TESTING",
    ]
    state: typing_extensions.Literal["OPTED_IN", "OPTED_OUT"]

@typing.type_check_only
class AssistantApiNotificationOutputRestrictionsOptOutStateCategoryState(
    typing_extensions.TypedDict, total=False
):
    category: typing_extensions.Literal[
        "UNSPECIFIED",
        "SYSTEM_REQUIRED_LOW_PRIORITY",
        "SYSTEM_REQUIRED_HIGH_PRIORITY",
        "DISCOVERY",
        "REALTIME_PROMOTIONAL",
        "SUBSCRIPTIONS",
        "FLIGHT_UPDATES",
        "TRANSPORT_UPDATES",
        "BILL_UPDATES",
        "PACKAGE_DELIVERY_UPDATES",
        "EVENT_UPDATES",
        "DUE_DATE_UPDATES",
        "CELEBRATION_UPDATES",
        "ROUTINE_UPDATES",
        "TASK_SUGGESTIONS",
        "AT_A_PLACE",
        "APP_RECOMMENDATIONS",
        "TRAVEL_UPDATES",
        "REMINDER_DUE",
        "NEW_REMINDER_ASSIGNMENT",
        "ASSIGNED_REMINDER_DUE",
        "ROUTINE_SETTINGS_UPDATES",
        "MAPS_OR_DIRECTIONS",
        "MOVIE_SHOWTIMES",
        "SPORTS_UPDATES",
        "NEWS_UPDATES",
        "SONGS_AND_ARTISTS",
        "TRANSLATIONS",
        "ANSWERS_TO_QUESTIONS",
        "SETTINGS_LINKS",
        "RESERVATION_UPDATES",
        "DEPRECATED_FEEDBACK_REQUESTS",
        "FEEDBACK_REQUESTS",
        "ACTIONS_ON_GOOGLE",
        "DUO_MISSED_CALLS",
        "HOME_AUTOMATION",
        "TIME_TO_LEAVE",
        "COMMUTE",
        "OCCASIONALLY_REPEATED_ACTIONS",
        "FREQUENTLY_REPEATED_ACTIONS",
        "ASPIRE",
        "ASSISTANT_DRIVING_MODE",
        "DISCOVERY_DEFAULT_PRIORITY",
        "HOLIDAY_REMINDERS",
        "CROSS_DEVICE_TIMER",
        "LIVE_CARD",
        "ASYNC_ACTION",
        "UNIT_TESTING",
    ]
    state: typing_extensions.Literal["OPTED_IN", "OPTED_OUT"]

@typing.type_check_only
class AssistantApiOemCapabilities(typing_extensions.TypedDict, total=False):
    cloudCapability: AssistantDevicesPlatformProtoCloudCapability
    cloudDeviceCapabilities: dict[str, typing.Any]
    deviceModelId: str
    deviceModelRevisionId: str
    deviceSpecificData: str
    internalCapability: AssistantDevicesPlatformProtoInternalCapability
    thirdPartyActionConfig: AssistantApiThirdPartyActionConfig

@typing.type_check_only
class AssistantApiOnDeviceAssistantCapabilities(
    typing_extensions.TypedDict, total=False
):
    isLocalNetworkArbitrationSupported: bool
    isOnDeviceArbitrationSupported: bool
    isOnDeviceAssistantSupported: bool
    isOnDeviceUnderstandingSupported: bool

@typing.type_check_only
class AssistantApiOnDeviceSmartHomeCapabilities(
    typing_extensions.TypedDict, total=False
):
    isOnDeviceSmartHomeSupported: bool

@typing.type_check_only
class AssistantApiOnDeviceStorageCapabilities(typing_extensions.TypedDict, total=False):
    isSupported: bool

@typing.type_check_only
class AssistantApiOutputRestrictions(typing_extensions.TypedDict, total=False):
    googlePhotoContent: typing_extensions.Literal[
        "ALL_PHOTO_CONTENT", "NO_RESTRICTED_PHOTO_CONTENT"
    ]
    guestAccessOutput: AssistantApiGuestAccessOutput
    personalData: typing_extensions.Literal[
        "PERSONAL_DATA_OUTPUT_UNKNOWN",
        "ALL_PERSONAL_DATA_WITH_PROACTIVE",
        "ALL_PERSONAL_DATA",
        "NO_PERSONAL_DATA",
    ]
    proactiveNotificationOutput: typing_extensions.Literal[
        "UNKNOWN_PROACTIVE_NOTIFICATION",
        "NO_PROACTIVE_NOTIFICATION",
        "ALL_PROACTIVE_NOTIFICATIONS",
    ]
    proactiveOutput: AssistantApiProactiveOutput
    youtubeAutoplayRestriction: typing_extensions.Literal[
        "AUTOPLAY_RESTRICTION_UNSPECIFIED", "AUTOPLAY_ALLOWED", "AUTOPLAY_DISABLED"
    ]
    youtubeContent: typing_extensions.Literal[
        "ALL_YOUTUBE_CONTENT", "NO_RESTRICTED_CONTENT"
    ]
    youtubeTvContent: typing_extensions.Literal[
        "ALL_YOUTUBE_TV_CONTENT", "NO_RESTRICTED_YOUTUBE_TV_CONTENT"
    ]

@typing.type_check_only
class AssistantApiProactiveOutput(typing_extensions.TypedDict, total=False):
    allowAllPersonalData: bool
    androidTvAssistantSettingsSource: typing_extensions.Literal[
        "NOT_SET",
        "FIRST_SCREEN_DEVICE_OOBE",
        "FIRST_SCREEN_KATNISS_OOBE",
        "FIRST_SCREEN_DELEGATION_OOBE",
        "FIRST_SCREEN_FIXER_JOB",
        "FIRST_SCREEN_FCM_JOB",
        "FIRST_SCREEN_HOME_GRAPH_JOB",
        "FIRST_SCREEN_PERSONAL_BIT",
        "FIRST_SCREEN_VOICE_INPUT_BIT",
        "FIRST_SCREEN_OTHER",
        "SECOND_SCREEN_AGSA",
        "SECOND_SCREEN_GHA_IOS",
        "SECOND_SCREEN_GHA_ANDROID",
    ]
    healthAndFitnessProactive: typing_extensions.Literal[
        "NO_HEALTH_AND_FITNESS_PROACTIVE_OUTPUT",
        "ALL_HEALTH_AND_FITNESS_PROACTIVE_OUTPUT",
    ]
    photosProactive: typing_extensions.Literal[
        "UNKNOWN_PHOTOS_PROACTIVE_OUTPUT",
        "NO_PHOTOS_PROACTIVE_OUTPUT",
        "ALL_PHOTOS_PROACTIVE_OUTPUT",
    ]
    userMatchProactive: typing_extensions.Literal[
        "UNKNOWN_USER_MATCH_PROACTIVE",
        "NEVER_SHOW",
        "ONLY_SHOW_ON_USER_MATCH",
        "ALWAYS_SHOW",
    ]

@typing.type_check_only
class AssistantApiProtobuf(typing_extensions.TypedDict, total=False):
    protobufData: str
    protobufType: str

@typing.type_check_only
class AssistantApiRecurrence(typing_extensions.TypedDict, total=False):
    begin: AssistantApiDate
    blacklistedRanges: _list[AssistantApiDateTimeRange]
    dayOfMonth: _list[int]
    dayOfWeek: _list[int]
    end: AssistantApiDate
    every: int
    monthOfYear: _list[int]
    numOccurrences: int
    weekOfMonth: _list[int]

@typing.type_check_only
class AssistantApiScreenCapabilities(typing_extensions.TypedDict, total=False):
    fontScaleFactor: float
    inputType: _list[typing_extensions.Literal["TOUCHSCREEN"]]
    mask: AssistantApiScreenCapabilitiesMask
    protoLayoutTargetedSchema: AssistantApiScreenCapabilitiesProtoLayoutVersion
    resolution: AssistantApiScreenCapabilitiesResolution
    screenOff: bool
    screenStateDetection: typing_extensions.Literal[
        "UNKNOWN_SCREEN_STATE_DETECTION",
        "UNRELIABLE_SCREEN_STATE_DETECTION",
        "RELIABLE_SCREEN_STATE_DETECTION",
    ]
    supportedRenderingFormat: typing_extensions.Literal[
        "UNKNOWN_RENDERING_FORMAT", "CONCISE_TEXT", "PROTO_LAYOUT", "ELEMENTS"
    ]
    supportedScreenStates: _list[
        typing_extensions.Literal["UNKNOWN_SCREEN_STATE", "ON", "OFF"]
    ]
    visionHelpEnabled: bool

@typing.type_check_only
class AssistantApiScreenCapabilitiesMask(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal["UNKNOWN_MASK", "NO_MASK", "ROUND_MASK"]

@typing.type_check_only
class AssistantApiScreenCapabilitiesProtoLayoutVersion(
    typing_extensions.TypedDict, total=False
):
    major: int
    minor: int

@typing.type_check_only
class AssistantApiScreenCapabilitiesResolution(
    typing_extensions.TypedDict, total=False
):
    dpi: int
    heightPx: int
    mSize: int
    nengSize: int
    widthPx: int

@typing.type_check_only
class AssistantApiSelinaCapabilites(typing_extensions.TypedDict, total=False):
    gestureCapabilities: AssistantApiGestureCapabilities
    selinaSupported: bool
    sleepSensingSupported: bool

@typing.type_check_only
class AssistantApiSettingsAmbientSettings(typing_extensions.TypedDict, total=False):
    anyUserHasSetPersonalPhotos: bool
    recentHighlightsEnabled: bool
    showPersonalPhotoData: bool
    showPersonalPhotos: bool

@typing.type_check_only
class AssistantApiSettingsAppCapabilities(typing_extensions.TypedDict, total=False):
    carSettingsCapabilities: AssistantApiCarSettingsCapabilities
    reissueQueryAfterMusicSetup: bool
    supportsPaymentsSettingsUpdate: bool

@typing.type_check_only
class AssistantApiSettingsAutoFramingSettings(typing_extensions.TypedDict, total=False):
    isAutoFramingEnabled: bool

@typing.type_check_only
class AssistantApiSettingsCarrierCallDeviceSettings(
    typing_extensions.TypedDict, total=False
):
    allowIncomingCalls: bool

@typing.type_check_only
class AssistantApiSettingsCommunicationsFilter(
    typing_extensions.TypedDict, total=False
):
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL", "BLOCK_CALLS_AND_MESSAGES"
    ]

@typing.type_check_only
class AssistantApiSettingsDeviceDowntimeSettings(
    typing_extensions.TypedDict, total=False
):
    schedules: _list[AssistantApiSettingsLabeledDowntimeSchedule]
    targets: _list[
        typing_extensions.Literal[
            "UNKNOWN_DEVICE_SUPERVISION_TARGET", "EVERYONE", "KID_ACCOUNTS", "GUESTS"
        ]
    ]

@typing.type_check_only
class AssistantApiSettingsDeviceFeatureFilters(
    typing_extensions.TypedDict, total=False
):
    enabled: bool
    featureFilters: AssistantApiSettingsFeatureFilters
    targets: _list[
        typing_extensions.Literal[
            "UNKNOWN_DEVICE_SUPERVISION_TARGET", "EVERYONE", "KID_ACCOUNTS", "GUESTS"
        ]
    ]

@typing.type_check_only
class AssistantApiSettingsDeviceLogsOptIn(typing_extensions.TypedDict, total=False):
    optInEnabled: bool

@typing.type_check_only
class AssistantApiSettingsDeviceSettings(typing_extensions.TypedDict, total=False):
    ackStatus: typing_extensions.Literal["ACK_COMPLETED", "ACK_PENDING"]
    address: str
    aliasName: _list[str]
    allowIncomingCalls: bool
    ambientSettings: AssistantApiSettingsAmbientSettings
    ancillaryDeviceId: AssistantApiSettingsInternalAncillaryDeviceId
    autoFramingSettings: AssistantApiSettingsAutoFramingSettings
    blueSteelEnabled: bool
    capabilities: AssistantApiDeviceCapabilities
    city: str
    colocationStatus: typing_extensions.Literal[
        "COLOCATION_UNKNOWN",
        "COLOCATION_ESTABLISHED",
        "COLOCATION_NOT_ESTABLISHED",
        "COLOCATION_NOT_SUPPORTED",
    ]
    creationTimestampMs: str
    crossSurfaceAvailability: AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability
    defaultAudioDeviceId: AssistantApiCoreTypesDeviceId
    defaultVideoDeviceId: AssistantApiCoreTypesDeviceId
    deviceBrand: str
    deviceId: AssistantApiCoreTypesDeviceId
    deviceModelId: str
    deviceModelRevision: int
    dusi: str
    faceEnrollmentErrors: _list[
        typing_extensions.Literal[
            "UNKNOWN_FACE_ENROLLMENT_ERROR",
            "MISSING_FRONTAL_POSE",
            "FACE_NOT_DETECTED",
            "MULTIPLE_FACE_DETECTED",
            "FACE_WITHOUT_SIGNATURE",
            "FACE_DETECTION_LOW_CONFIDENCE",
            "FACE_LANDMARK_LOW_CONFIDENCE",
            "FACE_WITHOUT_CONFIDENCE",
            "FACE_TOO_SMALL",
            "FAILED_TO_READ_IMAGE",
            "FAILED_TO_DECODE_IMAGE",
            "FACE_DETECTION_ERROR",
            "FACE_WITHOUT_EMBEDDING_CONFIDENCE",
        ]
    ]
    faceEnrollmentStatus: typing_extensions.Literal[
        "UNKNOWN_STATUS", "SUCCESS", "FAILURE", "PENDING"
    ]
    faceMatchEnabled: bool
    gcmSettings: AssistantApiSettingsGcmSettings
    homeGraphData: AssistantApiSettingsHomeGraphData
    homeGraphId: str
    hospitalityModeStatus: AssistantApiSettingsHospitalityMode
    hotwordSensitivity: typing_extensions.Literal[
        "UNKNOWN_HOTWORD_SENSITIVITY",
        "HOTWORD_SENSITIVITY_LOW",
        "HOTWORD_SENSITIVITY_NORMAL",
        "HOTWORD_SENSITIVITY_HIGH",
        "HOTWORD_SENSITIVITY_LOW_2",
        "HOTWORD_SENSITIVITY_HIGH_2",
    ]
    hotwordThresholdAdjustmentFactor: AssistantApiSettingsHotwordThresholdAdjustmentFactor
    humanFriendlyName: str
    internalVersion: AssistantApiSettingsInternalVersion
    isCloudSyncDevice: bool
    isDeviceActivationCacheEnabled: bool
    kidsMode: AssistantApiSettingsKidsMode
    lastCastRegistrationTimestamp: str
    lastUsedCoarseTimestamp: str
    linkedDeviceId: _list[AssistantApiCoreTypesDeviceId]
    linkedUsers: _list[AssistantApiSettingsLinkedUser]
    locale: str
    locationCoordinates: AssistantApiCoreTypesLocationCoordinates
    locationFeature: GeostoreFeatureProto
    marketplaceDisclosure: AssistantApiSettingsMarketplaceDisclosure
    masqueradeMode: AssistantApiSettingsMasqueradeMode
    notificationProfile: AssistantApiSettingsNotificationProfile
    oauthClientId: str
    onDeviceAppSettings: AssistantApiSettingsOnDeviceAppSettings
    optInStatus: AssistantApiSettingsDeviceLogsOptIn
    paymentsEnabled: bool
    personalizationMetadata: AssistantApiSettingsPersonalizationMetadata
    politeMode: AssistantApiSettingsPoliteMode
    postalCode: str
    reauthTrustedDeviceSettings: AssistantApiSettingsReauthTrustedDeviceSettings
    shortenedAddress: str
    speakerIdEnabled: bool
    speechOutputSettings: AssistantApiSettingsSpeechOutputSettings
    speechSettings: AssistantApiSettingsSpeechSettings
    supervisionSettings: AssistantApiSettingsDeviceSupervisionSettings
    surfaceType: AssistantApiCoreTypesSurfaceType
    tetheredInfo: AssistantApiSettingsTetheredInfo
    timeZone: AssistantApiTimeZone
    truncatedLocalNetworkId: str
    type: typing_extensions.Literal[
        "UNKNOWN_DEVICE_TYPE",
        "ASSISTANT",
        "HOME_AUTOMATION",
        "CAST",
        "CAST_GROUP",
        "QUARTZ",
        "QUARTZ_IOS",
        "CLOUD_AUTO",
    ]
    verboseTtsForChromecastEnabled: bool
    vmLastUsedCoarseTimestamp: str
    voiceEnrollmentStatus: typing_extensions.Literal[
        "VOICE_ENROLLMENT_UNKNOWN_STATUS",
        "VOICE_ENROLLMENT_SUCCESS",
        "VOICE_ENROLLMENT_FAILURE",
        "VOICE_ENROLLMENT_PENDING",
    ]
    voiceInputEnabled: bool

@typing.type_check_only
class AssistantApiSettingsDeviceSettingsCrossSurfaceAvailability(
    typing_extensions.TypedDict, total=False
):
    lastKnownClientLocale: str
    lastParamsWriteTimestamp: str

@typing.type_check_only
class AssistantApiSettingsDeviceSupervisionSettings(
    typing_extensions.TypedDict, total=False
):
    downtimeSettings: AssistantApiSettingsDeviceDowntimeSettings
    featureFilters: AssistantApiSettingsDeviceFeatureFilters

@typing.type_check_only
class AssistantApiSettingsDowntimePeriod(typing_extensions.TypedDict, total=False):
    enabled: bool
    endTime: GoogleTypeTimeOfDay
    startDay: typing_extensions.Literal[
        "DAY_OF_WEEK_UNSPECIFIED",
        "MONDAY",
        "TUESDAY",
        "WEDNESDAY",
        "THURSDAY",
        "FRIDAY",
        "SATURDAY",
        "SUNDAY",
    ]
    startTime: GoogleTypeTimeOfDay

@typing.type_check_only
class AssistantApiSettingsDowntimeSchedule(typing_extensions.TypedDict, total=False):
    enabled: bool
    periods: _list[AssistantApiSettingsDowntimePeriod]

@typing.type_check_only
class AssistantApiSettingsDuoCallDeviceSettings(
    typing_extensions.TypedDict, total=False
):
    allowKnockKnock: bool
    shouldBeLinked: bool
    state: typing_extensions.Literal[
        "UNKNOWN_LINK_STATE", "NOT_LINKED", "LINKED", "LINKED_WAITING", "LINK_ERROR"
    ]
    talkbackEnabled: bool

@typing.type_check_only
class AssistantApiSettingsFeatureFilters(typing_extensions.TypedDict, total=False):
    communicationsFilter: AssistantApiSettingsCommunicationsFilter
    musicFilter: AssistantApiSettingsMusicFilter
    newsFilter: AssistantApiSettingsNewsFilter
    podcastFilter: AssistantApiSettingsPodcastFilter
    searchFilter: AssistantApiSettingsSearchFilter
    thirdPartyAppsFilter: AssistantApiSettingsThirdPartyAppsFilter
    videoFilter: AssistantApiSettingsVideoFilter
    webviewFilter: AssistantApiSettingsWebviewFilter

@typing.type_check_only
class AssistantApiSettingsGcmSettings(typing_extensions.TypedDict, total=False):
    gcmId: str
    gcmPackage: str

@typing.type_check_only
class AssistantApiSettingsHomeGraphData(typing_extensions.TypedDict, total=False):
    agentId: str
    attributes: dict[str, typing.Any]
    deviceId: str
    deviceType: str
    shouldWriteToHomeGraph: bool
    supportedTraits: _list[str]
    supportsDirectResponse: bool

@typing.type_check_only
class AssistantApiSettingsHospitalityCardSettings(
    typing_extensions.TypedDict, total=False
):
    cardConfig: _list[AssistantApiSettingsHospitalityCardSettingsCardConfig]
    showMediaTapGestureTutorial: bool
    showPhotoSwipeGestureTutorial: bool
    youtubeCardConfig: _list[
        AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig
    ]

@typing.type_check_only
class AssistantApiSettingsHospitalityCardSettingsCardConfig(
    typing_extensions.TypedDict, total=False
):
    activeActionRequired: bool
    dismissable: bool
    effectiveTime: AssistantApiTimestamp
    expiryTime: AssistantApiTimestamp
    imageUrl: str
    moduleId: typing_extensions.Literal[
        "UNKNOWN", "MID_STAY_SURVEY", "CHECK_OUT", "CHECK_IN", "RESET"
    ]
    payloadQuery: str
    title: str

@typing.type_check_only
class AssistantApiSettingsHospitalityCardSettingsYouTubeCardConfig(
    typing_extensions.TypedDict, total=False
):
    imageUrl: str
    playlistId: str
    text: str

@typing.type_check_only
class AssistantApiSettingsHospitalityMode(typing_extensions.TypedDict, total=False):
    aogContextId: _list[str]
    aogInvocationPhrase: str
    branding: AssistantApiSettingsHospitalityModeBranding
    cardSettings: AssistantApiSettingsHospitalityCardSettings
    deviceClearRequest: AssistantApiTimestamp
    dialogTtlOverrideMicros: str
    enterpriseId: str
    hospitalityModeEnabled: bool
    lastDeviceClear: AssistantApiTimestamp
    lastModifiedTimestamp: AssistantApiTimestamp
    lastWelcomed: AssistantApiTimestamp
    manualResetRequired: bool
    promotedLanguages: _list[str]
    type: typing_extensions.Literal[
        "UNKNOWN_TYPE", "HOTEL_ROOM", "INTERPRETER", "SENIOR_LIVING_ROOM", "RETAIL_DEMO"
    ]
    verbalResetSupported: bool
    welcomeRequest: AssistantApiTimestamp

@typing.type_check_only
class AssistantApiSettingsHospitalityModeBranding(
    typing_extensions.TypedDict, total=False
):
    displayName: str
    displayNameForLanguage: dict[str, typing.Any]
    largeLogoUrl: str
    smallLogoUrl: str

@typing.type_check_only
class AssistantApiSettingsHotwordThresholdAdjustmentFactor(
    typing_extensions.TypedDict, total=False
):
    isValid: bool
    value: int

@typing.type_check_only
class AssistantApiSettingsInternalAncillaryDeviceId(
    typing_extensions.TypedDict, total=False
):
    deviceId: AssistantApiCoreTypesDeviceId

@typing.type_check_only
class AssistantApiSettingsInternalVersion(typing_extensions.TypedDict, total=False):
    generationTime: str
    id: str

@typing.type_check_only
class AssistantApiSettingsKidsMode(typing_extensions.TypedDict, total=False):
    kidsModeEnabled: bool
    obfuscatedGaiaId: str

@typing.type_check_only
class AssistantApiSettingsLabeledDowntimeSchedule(
    typing_extensions.TypedDict, total=False
):
    displayName: str
    schedule: AssistantApiSettingsDowntimeSchedule

@typing.type_check_only
class AssistantApiSettingsLinkedUser(typing_extensions.TypedDict, total=False):
    castLinkingTime: str
    email: str
    gaiaId: str
    names: _list[AppsPeopleOzExternalMergedpeopleapiName]

@typing.type_check_only
class AssistantApiSettingsMarketplaceDisclosure(
    typing_extensions.TypedDict, total=False
):
    confirmed: bool
    timestampMs: str

@typing.type_check_only
class AssistantApiSettingsMasqueradeMode(typing_extensions.TypedDict, total=False):
    lastEnterGuestModeTimestamp: AssistantApiTimestamp
    lastExitGuestModeTimestamp: AssistantApiTimestamp
    masqueradeModeEnabled: bool

@typing.type_check_only
class AssistantApiSettingsMusicFilter(typing_extensions.TypedDict, total=False):
    availableProviders: _list[
        typing_extensions.Literal[
            "UNKNOWN_MUSIC_PROVIDER",
            "YOUTUBE_MUSIC",
            "GOOGLE_PLAY_MUSIC",
            "SPOTIFY",
            "APPLE_MUSIC",
            "PANDORA",
        ]
    ]
    providerFilterState: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL_PROVIDERS", "ALLOW_WHITELISTED_PROVIDERS"
    ]
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL", "BLOCK_EXPLICIT", "BLOCK_ALL"
    ]
    whitelistedProviders: _list[
        typing_extensions.Literal[
            "UNKNOWN_MUSIC_PROVIDER",
            "YOUTUBE_MUSIC",
            "GOOGLE_PLAY_MUSIC",
            "SPOTIFY",
            "APPLE_MUSIC",
            "PANDORA",
        ]
    ]

@typing.type_check_only
class AssistantApiSettingsNewsFilter(typing_extensions.TypedDict, total=False):
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL_NEWS", "BLOCK_ALL_NEWS"
    ]

@typing.type_check_only
class AssistantApiSettingsNotificationProfile(typing_extensions.TypedDict, total=False):
    alloNotificationProfile: AssistantApiSettingsNotificationProfileAlloNotificationProfile

@typing.type_check_only
class AssistantApiSettingsNotificationProfileAlloNotificationProfile(
    typing_extensions.TypedDict, total=False
):
    botSendToken: ChatBotPlatformBotSendToken
    id: ChatBotPlatformFireballId

@typing.type_check_only
class AssistantApiSettingsOnDeviceAppSettings(typing_extensions.TypedDict, total=False):
    carrierCallDeviceSettings: AssistantApiSettingsCarrierCallDeviceSettings
    duoCallDeviceSettings: AssistantApiSettingsDuoCallDeviceSettings

@typing.type_check_only
class AssistantApiSettingsPersonalizationMetadata(
    typing_extensions.TypedDict, total=False
):
    faceMatch: typing_extensions.Literal[
        "PERSONALIZATION_FLOW_UNKNOWN",
        "PERSONALIZATION_FLOW_DEVICE",
        "PERSONALIZATION_FLOW_TWOOBE",
        "PERSONALIZATION_FLOW_SLA",
        "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO",
    ]
    personalResults: typing_extensions.Literal[
        "PERSONALIZATION_FLOW_UNKNOWN",
        "PERSONALIZATION_FLOW_DEVICE",
        "PERSONALIZATION_FLOW_TWOOBE",
        "PERSONALIZATION_FLOW_SLA",
        "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO",
    ]
    voiceMatch: typing_extensions.Literal[
        "PERSONALIZATION_FLOW_UNKNOWN",
        "PERSONALIZATION_FLOW_DEVICE",
        "PERSONALIZATION_FLOW_TWOOBE",
        "PERSONALIZATION_FLOW_SLA",
        "PERSONALIZATION_FLOW_DEVICE_DELEGATED_CUSTODIO",
    ]

@typing.type_check_only
class AssistantApiSettingsPodcastFilter(typing_extensions.TypedDict, total=False):
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL_PODCASTS", "BLOCK_ALL_PODCASTS"
    ]

@typing.type_check_only
class AssistantApiSettingsPoliteMode(typing_extensions.TypedDict, total=False):
    politeModeEnabled: bool

@typing.type_check_only
class AssistantApiSettingsReauthTrustedDeviceSettings(
    typing_extensions.TypedDict, total=False
):
    trustSettingsForClient: dict[str, typing.Any]

@typing.type_check_only
class AssistantApiSettingsReauthTrustedDeviceSettingsTrustSettings(
    typing_extensions.TypedDict, total=False
):
    neverAskAgain: bool
    neverAskExpirationTimestamp: str
    trustDeviceExpirationTimestamp: str

@typing.type_check_only
class AssistantApiSettingsSearchFilter(typing_extensions.TypedDict, total=False):
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_SAFE_SEARCH", "BLOCK_SEARCH"
    ]

@typing.type_check_only
class AssistantApiSettingsSpeechOutputSettings(
    typing_extensions.TypedDict, total=False
):
    speechOutput: typing_extensions.Literal[
        "UNSPECIFIED", "VERBOSE", "MIN_VERBOSITY", "HANDS_FREE_ONLY"
    ]

@typing.type_check_only
class AssistantApiSettingsSpeechSettings(typing_extensions.TypedDict, total=False):
    continuedConversationEnabled: bool
    deviceModelType: str
    dspAvailable: bool
    hotwordInNavigationEnabled: typing_extensions.Literal[
        "UNAVAILABLE",
        "ENABLED",
        "DISABLED",
        "UNDECIDED",
        "OPA_DISABLED",
        "UNSUPPORTED_LOCALE",
        "INCOMPLETE",
        "ENABLED_WITHOUT_OPA_AVAILABILITY",
    ]
    hotwordSetting: typing_extensions.Literal[
        "UNAVAILABLE",
        "ENABLED",
        "DISABLED",
        "UNDECIDED",
        "OPA_DISABLED",
        "UNSUPPORTED_LOCALE",
        "INCOMPLETE",
        "ENABLED_WITHOUT_OPA_AVAILABILITY",
    ]
    lockscreenEnabled: bool
    opaEligibilityState: typing_extensions.Literal[
        "UNAVAILABLE",
        "ENABLED",
        "DISABLED",
        "UNDECIDED",
        "OPA_DISABLED",
        "UNSUPPORTED_LOCALE",
        "INCOMPLETE",
        "ENABLED_WITHOUT_OPA_AVAILABILITY",
    ]
    opaEligible: bool
    sdkVersion: int
    speakerIdModelPresent: bool
    speakerIdRecognitionEnabled: bool
    trustedVoiceEnabled: bool
    unlockWithHotwordAvailable: bool
    userMigratedToDeclined: bool
    voiceMatchSetting: typing_extensions.Literal[
        "UNAVAILABLE",
        "ENABLED",
        "DISABLED",
        "UNDECIDED",
        "OPA_DISABLED",
        "UNSUPPORTED_LOCALE",
        "INCOMPLETE",
        "ENABLED_WITHOUT_OPA_AVAILABILITY",
    ]

@typing.type_check_only
class AssistantApiSettingsTetheredInfo(typing_extensions.TypedDict, total=False):
    primaryHostDeviceId: str

@typing.type_check_only
class AssistantApiSettingsThirdPartyAppsFilter(
    typing_extensions.TypedDict, total=False
):
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL", "ALLOW_CERTIFIED_FOR_FAMILIES", "BLOCK_ALL"
    ]

@typing.type_check_only
class AssistantApiSettingsVideoFilter(typing_extensions.TypedDict, total=False):
    autoplayToggleState: typing_extensions.Literal[
        "UNKNOWN_STATE", "ENABLED", "DISABLED"
    ]
    availableProviders: _list[
        typing_extensions.Literal[
            "UNKNOWN_VIDEO_PROVIDER", "YOUTUBE", "YOUTUBE_TV", "YOUTUBE_KIDS"
        ]
    ]
    providerFilterState: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL_PROVIDERS", "ALLOW_WHITELISTED_PROVIDERS"
    ]
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL", "BLOCK_MATURE_CONTENT", "BLOCK_ALL"
    ]
    whitelistedProviders: _list[
        typing_extensions.Literal[
            "UNKNOWN_VIDEO_PROVIDER", "YOUTUBE", "YOUTUBE_TV", "YOUTUBE_KIDS"
        ]
    ]

@typing.type_check_only
class AssistantApiSettingsWebviewFilter(typing_extensions.TypedDict, total=False):
    jasperWebviewConsent: bool
    state: typing_extensions.Literal[
        "UNKNOWN_STATE", "ALLOW_ALL_WEBSITES", "BLOCK_ALL_WEBSITES"
    ]

@typing.type_check_only
class AssistantApiSignInMethod(typing_extensions.TypedDict, total=False):
    method: typing_extensions.Literal[
        "UNSPECIFIED", "NOT_ALLOWED", "PHONE_APP", "ON_DEVICE_MENU", "WEB_APP"
    ]
    signInRequired: bool

@typing.type_check_only
class AssistantApiSodaCapabilities(typing_extensions.TypedDict, total=False):
    supportsHotwordSensitivity: bool
    supportsSimpleStop: bool
    supportsSpeakerId: bool
    supportsWarmWords: bool

@typing.type_check_only
class AssistantApiSoftwareCapabilities(typing_extensions.TypedDict, total=False):
    appCapabilities: _list[AssistantApiAppCapabilities]
    appCapabilitiesDelta: _list[AssistantApiAppCapabilitiesDelta]
    appIntegrationsSettings: dict[str, typing.Any]
    carAssistantCapabilities: AssistantApiCarAssistantCapabilities
    clockCapabilities: AssistantApiClockCapabilities
    conversationVersion: AssistantApiSupportedConversationVersion
    crossDeviceExecutionCapabilities: AssistantApiCrossDeviceExecutionCapability
    gacsCapabilities: AssistantApiGacsCapabilities
    gcmCapabilities: AssistantApiGcmCapabilities
    liveTvChannelCapabilities: AssistantApiLiveTvChannelCapabilities
    oemCapabilities: AssistantApiOemCapabilities
    onDeviceAssistantCapabilities: AssistantApiOnDeviceAssistantCapabilities
    onDeviceSmartHomeCapabilities: AssistantApiOnDeviceSmartHomeCapabilities
    onDeviceStorageCapabilities: AssistantApiOnDeviceStorageCapabilities
    operatingSystem: typing_extensions.Literal[
        "OS_TYPE_UNKNOWN",
        "OS_TYPE_ANDROID",
        "OS_TYPE_CAST",
        "OS_TYPE_FUCHSIA",
        "OS_TYPE_LINUX",
    ]
    orderedLiveTvProviders: _list[AssistantApiLiveTvProvider]
    selinaCapabilities: AssistantApiSelinaCapabilites
    settingsAppCapabilities: AssistantApiSettingsAppCapabilities
    supportedClientOp: _list[AssistantApiSupportedClientOp]
    supportedFeatures: AssistantApiSupportedFeatures
    supportedMsgVersion: AssistantApiSupportedProtocolVersion
    supportedProviderTypes: AssistantApiSupportedProviderTypes
    surfaceProperties: AssistantApiSurfaceProperties

@typing.type_check_only
class AssistantApiSpeechCapabilities(typing_extensions.TypedDict, total=False):
    dspAvailable: bool
    unlockWithHotwordAvailable: bool

@typing.type_check_only
class AssistantApiSuggestionsSupport(typing_extensions.TypedDict, total=False):
    clickImpersonationSupported: bool
    debugDataSupported: bool
    drlHistoryChipSupported: bool
    escapeHatchSupported: typing_extensions.Literal["UNSUPPORTED", "NGA_ESCAPE_HATCH"]
    executedTextSupported: bool
    executionContextSupported: bool
    featureSpecificActionSupport: AssistantApiFeatureSpecificActionSupport
    featureSpecificAppActionsNotificationSupported: bool
    multiStepTrySayingSupported: bool
    ruleIdInExecutionContextSupported: bool
    showExecutedTextSupported: bool
    showTranslationSupported: bool
    supportedDisplayTargets: _list[AssistantApiSuggestionsSupportDisplayTargetSupport]
    widgetDataSupported: bool

@typing.type_check_only
class AssistantApiSuggestionsSupportDisplayTargetSupport(
    typing_extensions.TypedDict, total=False
):
    executedTextSupported: bool
    headerTextSupported: bool
    repressImpressionSupported: bool
    target: typing_extensions.Literal[
        "DEFAULT",
        "NGA_INPUT_PLATE",
        "CONVERSATION_STARTERS",
        "QUICK_ACTIONS",
        "TACTILE_ASSISTANT_SUGGESTS",
        "TACTILE_MY_ACTIONS",
        "TRY_SAYING",
        "RICH_SUGGESTIONS",
    ]

@typing.type_check_only
class AssistantApiSunriseFeaturesSupport(typing_extensions.TypedDict, total=False):
    sunriseSimulationSupported: bool

@typing.type_check_only
class AssistantApiSupportedClientOp(typing_extensions.TypedDict, total=False):
    clientOpName: str
    clientOpProperties: AssistantApiProtobuf
    supportedExecution: AssistantApiSupportedClientOpSupportedExecution
    version: int

@typing.type_check_only
class AssistantApiSupportedClientOpSupportedExecution(
    typing_extensions.TypedDict, total=False
):
    supportsPartialFulfillment: bool
    supportsSynchronousExecution: bool

@typing.type_check_only
class AssistantApiSupportedConversationVersion(
    typing_extensions.TypedDict, total=False
):
    supportsConversationProtocol: bool
    version: int

@typing.type_check_only
class AssistantApiSupportedFeatures(typing_extensions.TypedDict, total=False):
    aaeNotificationSourceSupported: bool
    acpSupport: AssistantApiAssistantContinuedPresenceSupport
    actionV2SupportedFeatures: AssistantApiActionV2SupportedFeatures
    alarmTimerManagerApiSupported: bool
    appControlSupport: AssistantApiAppControlSupport
    assistantExploreSupported: bool
    assistantForKidsSupported: bool
    bypassDiDcCheckForComms: bool
    bypassMsgNotificationDismissal: bool
    client1mProvidersSupported: bool
    clientOpResultBatchingSupported: bool
    confirmationBeforeReadingMultipleMessagesSupported: bool
    conversationalCareSupported: bool
    crossDeviceBroadcastSupported: bool
    crossDeviceBroadcastVersion: typing_extensions.Literal[
        "CROSS_DEVICE_BROADCAST_NOT_SUPPORTED", "CROSS_DEVICE_BROADCAST_V1"
    ]
    csatVisualOverlaySupported: bool
    duoClientApiFeatures: str
    duoGroupCallingSupported: bool
    fitnessFeatureSupport: AssistantApiFitnessFeatureSupport
    fluidActionsSupport: AssistantApiFluidActionsSupport
    funtimeSupported: bool
    gdiSupported: bool
    gearheadNotificationSourceSupported: bool
    hasPhysicalRadio: bool
    immersiveCanvasConfirmationMessageSupported: bool
    immersiveCanvasSupport: AssistantApiImmersiveCanvasSupport
    inDialogAccountLinkingSupported: bool
    isPairedPhoneContactUploadNeededForComms: bool
    isPairedPhoneNeededForComms: bool
    justInTimeSupported: bool
    launchKeyboardSupported: typing_extensions.Literal[
        "LAUNCH_KEYBOARD_UNSUPPORTED", "OPA_ANDROID_LAUNCH_KEYBOARD_URI"
    ]
    lensSupported: bool
    liveCardsSupported: bool
    lottieAnimationSupport: typing_extensions.Literal[
        "LOTTIE_ANIMATION_UNKNOWN",
        "LOTTIE_ANIMATION_NOT_SUPPORTED",
        "LOTTIE_ANIMATION_SUPPORTED",
    ]
    mapsDialogsSupported: bool
    masqueradeModeSupported: bool
    mediaControlSupport: AssistantApiMediaControlSupport
    mediaSessionDetection: typing_extensions.Literal[
        "UNKNOWN_MEDIA_SESSION_DETECTION",
        "RELIABLE_MEDIA_SESSION_DETECTION",
        "UNRELIABLE_MEDIA_SESSION_DETECTION",
        "NO_MEDIA_SESSION_DETECTION",
        "MEDIA_SESSION_DETECTION_DISABLED_SCREEN_CONTEXT",
    ]
    meetSupported: bool
    noInputResponseSupported: bool
    opaOnSearchSupported: bool
    parentalControlsSupported: bool
    persistentDisplaySupported: bool
    privacyAwareLockscreenSupported: bool
    readMessagesTtsTaperingSupported: bool
    readNotificationSummarizationSupported: bool
    remoteCloudCastingEnabled: bool
    serverGeneratedFeedbackChipsEnabled: bool
    shLockScreenSupported: bool
    signInMethod: AssistantApiSignInMethod
    sleepSensingSupported: bool
    smartspaceCrossDeviceTimerSupported: bool
    soliGestureDetectionSupported: bool
    suggestionsSupport: AssistantApiSuggestionsSupport
    sunriseFeaturesSupport: AssistantApiSunriseFeaturesSupport
    tapToReadOptimizationSupported: bool
    thirdPartyGuiSupported: bool
    transactionFeaturesSupport: AssistantApiTransactionFeaturesSupport
    transactionsVersion: typing_extensions.Literal[
        "NO_TRANSACTIONS",
        "TRANSACTIONS_INITIAL_LAUNCH",
        "TRANSACTIONS_V2",
        "TRANSACTIONS_V3",
    ]
    usesSeparateFullViewer: bool
    viewReminderHubPageNotSupported: bool
    warmWelcomeTutorialSupported: bool
    webBrowserSupported: bool
    whatsNextSupported: bool
    zoomSupported: bool

@typing.type_check_only
class AssistantApiSupportedProtocolVersion(typing_extensions.TypedDict, total=False):
    messageVersion: _list[AssistantApiSupportedProtocolVersionMessageVersionPair]

@typing.type_check_only
class AssistantApiSupportedProtocolVersionMessageVersionPair(
    typing_extensions.TypedDict, total=False
):
    messageName: str
    version: int

@typing.type_check_only
class AssistantApiSupportedProviderTypes(typing_extensions.TypedDict, total=False):
    supportedTypes: _list[
        typing_extensions.Literal[
            "PROVIDER_TYPE_UNSPECIFIED",
            "ANDROID_APP",
            "CAST_APP",
            "CLOUD_PROVIDER",
            "SIP_PROVIDER",
            "IOS_APP",
            "INTERNAL_PROVIDER",
            "WEB_PROVIDER",
            "KAIOS_APP",
            "HOME_APP",
            "CHROMEOS_APP",
        ]
    ]

@typing.type_check_only
class AssistantApiSurfaceProperties(typing_extensions.TypedDict, total=False):
    executionCapabilities: AssistantApiSurfacePropertiesExecutionCapabilities
    prefersGlanceableUi: bool
    responseDisplayFormat: typing_extensions.Literal[
        "SINGLE_ITEM", "MULTIPLE_ITEMS", "FULL_HISTORY"
    ]
    supportsMultiResponse: bool

@typing.type_check_only
class AssistantApiSurfacePropertiesExecutionCapabilities(
    typing_extensions.TypedDict, total=False
):
    supportsClientOpPreloading: bool
    supportsNonFinalizedResponses: bool
    supportsNonMaterializedInteractions: bool

@typing.type_check_only
class AssistantApiSystemNotificationRestrictions(
    typing_extensions.TypedDict, total=False
):
    categoryState: _list[
        AssistantApiSystemNotificationRestrictionsNotificationCategoryState
    ]
    channelState: _list[
        AssistantApiSystemNotificationRestrictionsNotificationChannelState
    ]
    notificationCapabilities: typing_extensions.Literal[
        "NO_NOTIFICATION_CAPABILITY", "NOTIFICATIONS_DISABLED", "NOTIFICATIONS_ENABLED"
    ]

@typing.type_check_only
class AssistantApiSystemNotificationRestrictionsNotificationCategoryState(
    typing_extensions.TypedDict, total=False
):
    categoryId: int
    disabled: bool
    disabledReason: typing_extensions.Literal[
        "NONE",
        "ASSISTANT_CATEGORY_SETTING",
        "ASSISTANT_OVERALL_SETTING",
        "OS_APP_DISABLED",
        "OS_CHANNEL_GROUP_DISABLED",
        "OS_CHANNEL_DISABLED",
    ]

@typing.type_check_only
class AssistantApiSystemNotificationRestrictionsNotificationChannelState(
    typing_extensions.TypedDict, total=False
):
    channelType: typing_extensions.Literal[
        "TYPE_UNKNOWN",
        "TYPE_OPA_PROACTIVE",
        "TYPE_OPA_HANDOFF",
        "TYPE_OPA_MISC",
        "TYPE_OPA_RECOMMENDATIONS",
        "TYPE_OPA_PRODUCT_UPDATES",
        "TYPE_OPA_THIRD_PARTY",
    ]
    enabled: bool

@typing.type_check_only
class AssistantApiThirdPartyActionConfig(typing_extensions.TypedDict, total=False):
    deviceActionCapability: AssistantDevicesPlatformProtoDeviceActionCapability
    projectConfigs: _list[AssistantApiThirdPartyActionConfigProjectConfig]

@typing.type_check_only
class AssistantApiThirdPartyActionConfigProjectConfig(
    typing_extensions.TypedDict, total=False
):
    projectId: str

@typing.type_check_only
class AssistantApiThirdPartyCapabilities(typing_extensions.TypedDict, total=False):
    dataSharingRestrictions: typing_extensions.Literal[
        "DEFAULT_NO_DATA_SHARING_RESTRICTION",
        "NO_SHARING_ALLOWED_WITH_THIRD_PARTY",
        "SHARING_STATUS_NOT_SET",
        "NO_SHARING_ALLOWED_WITH_THIRD_PARTY_FROM_OOBE",
    ]

@typing.type_check_only
class AssistantApiTimeOfDay(typing_extensions.TypedDict, total=False):
    hour: int
    minute: int
    nanosecond: int
    second: int

@typing.type_check_only
class AssistantApiTimeZone(typing_extensions.TypedDict, total=False):
    ianaId: str

@typing.type_check_only
class AssistantApiTimestamp(typing_extensions.TypedDict, total=False):
    nanos: int
    seconds: str

@typing.type_check_only
class AssistantApiTransactionFeaturesSupport(typing_extensions.TypedDict, total=False):
    voicePinSuppressed: bool

@typing.type_check_only
class AssistantApiVolumeProperties(typing_extensions.TypedDict, total=False):
    defaultVolumePercentage: int
    highVolumePercentage: int
    levelStepSize: float
    lowVolumePercentage: int
    maximumVolumeLevel: int
    mediumVolumePercentage: int
    veryHighVolumePercentage: int
    veryLowVolumePercentage: int

@typing.type_check_only
class AssistantContextAppProviderId(typing_extensions.TypedDict, total=False):
    activityClassName: str
    androidPackageName: str
    castAppId: str
    versionCode: int

@typing.type_check_only
class AssistantContextMediaProviderId(typing_extensions.TypedDict, total=False):
    androidPackageName: str
    castAppId: str
    chromeOsPackageName: str
    homeAppPackageName: str
    iosBundleIdentifier: str
    kaiOsPackageName: str
    kgProviderKey: str
    mid: str
    providerVariant: AssistantContextProviderVariant
    sipProviderId: str

@typing.type_check_only
class AssistantContextProviderId(typing_extensions.TypedDict, total=False):
    appProviderId: AssistantContextAppProviderId
    ecosystemType: typing_extensions.Literal[
        "ECOSYSTEM_TYPE_UNSPECIFIED", "NATIVE", "CAST"
    ]
    mediaProviderId: AssistantContextMediaProviderId
    mid: str
    providerCorpusId: str
    providerVariant: AssistantContextProviderVariant

@typing.type_check_only
class AssistantContextProviderSelectionPolicy(typing_extensions.TypedDict, total=False):
    policyAction: typing_extensions.Literal[
        "UNSET_ACTION", "BOOST_TO_WIN_ACTION", "SUPPRESS_TO_INVALIDATE_ACTION"
    ]
    policyName: typing_extensions.Literal[
        "UNSET_POLICY",
        "QUERY_RESTRICTED_SPOTIFY_POLICY",
        "QUERY_RESTRICTED_PANDORA_POLICY",
        "QUERY_RESTRICTED_NETFLIX_POLICY",
    ]

@typing.type_check_only
class AssistantContextProviderSelectionResult(typing_extensions.TypedDict, total=False):
    bucketedFinalScore: typing_extensions.Literal["DEFAULT_BUCKET"]
    finalScore: float
    policyApplied: _list[AssistantContextProviderSelectionPolicy]
    shouldPrune: bool

@typing.type_check_only
class AssistantContextProviderVariant(typing_extensions.TypedDict, total=False):
    emptyMidVariant: typing_extensions.Literal[
        "UNSPECIFIED_EMPTY_MID_VARIANT", "BACKDROP_CAST", "CAST_RECEIVER"
    ]
    spotifyVariant: typing_extensions.Literal[
        "UNSPECIFIED_SPOTIFY_VARIANT", "SPOTIFY_MAIN", "SPOTIFY_LITE"
    ]
    youtubeVariant: typing_extensions.Literal[
        "UNSPECIFIED_YOUTUBE_VARIANT", "YOUTUBE_MAIN", "YOUTUBE_MUSIC", "YOUTUBE_GO"
    ]

@typing.type_check_only
class AssistantDeviceTargetingDeviceTargetingError(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal[
        "UNKNOWN_ERROR",
        "NO_DEVICE_IN_SAME_STRUCTURE",
        "NO_DEVICE_IN_SAME_NETWORK_OR_LOCATION",
        "NO_DEVICE_IN_SAME_STRUCTURE_OR_NETWORK_OR_LOCATION",
        "NO_DEVICE_SATISFIES_SAME_STRUCTURE_OR_UNKNOWN_IF_OWNED",
        "NO_DEVICE_SATISFIES_CAPABILITIES_REQUIREMENT",
        "NO_DEVICE_MATCHED_DEVICE_ANNOTATION",
        "MULTI_TARGET_DEVICE_NOT_SUPPORTED",
        "NO_DEVICE_AFTER_LOCAL_DEVICE_EXCLUDED",
        "UNABLE_TO_TARGET_ONLY_LOCAL_DEVICE",
        "NO_DEVICE_MATCHED_REQUIRED_TRAITS",
        "NO_DEVICE_MATCHED_REQUIRED_ATTRIBUTES",
        "NO_DEVICE_MATCHED_REQUIRED_DEVICE_TYPE",
        "NO_DEVICE_IN_SAME_OR_MENTIONED_STRUCTURE",
        "NO_DEVICE_SATISFIES_PLAYBACK_REQUIREMENT",
        "STRUCT_DISAMBIG_NOT_SUPPORTED",
        "ROOM_DISAMBIG_NOT_SUPPORTED",
        "UNRECOGNIZED_DEVICE_NAME",
        "NO_LINKED_REMOTE_DEVICES",
        "NO_LINKED_REMOTE_VIDEO_DEVICES",
        "NO_SAFE_DEVICE_WITH_SCREEN",
        "ALL_QUALIFIED_DEVICES_OFFLINE",
        "CROSS_STRUCTURE_TARGETING_DISALLOWED",
        "NO_DEVICE_MEETS_PROVIDER_REQUIREMENT",
        "MISSING_LOCAL_DEVICE_SETTING",
        "NO_DEVICE_HAS_REQUIRED_APP",
        "HYBRID_DEVICE_NOT_QUALIFIED",
        "NO_NEARBY_DEVICES",
        "NO_MATCHING_LAST_USED_DEVICE",
    ]

@typing.type_check_only
class AssistantDevicesPlatformProtoAlarmCapability(
    typing_extensions.TypedDict, total=False
):
    maxSupportedAlarms: int
    restrictAlarmsToNextDay: bool
    supportsGenericMutations: bool
    supportsStopAction: bool

@typing.type_check_only
class AssistantDevicesPlatformProtoArgSpec(typing_extensions.TypedDict, total=False):
    intValueSpec: AssistantDevicesPlatformProtoIntValueSpec
    optionValueSpec: AssistantDevicesPlatformProtoOptionValueSpec
    type: typing_extensions.Literal["TYPE_UNSPECIFIED", "BOOL", "INTEGER", "OPTION"]

@typing.type_check_only
class AssistantDevicesPlatformProtoCallCallCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoClientReconnectCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoCloudCapability(
    typing_extensions.TypedDict, total=False
):
    cloudEndpoints: _list[AssistantDevicesPlatformProtoCloudEndpoint]

@typing.type_check_only
class AssistantDevicesPlatformProtoCloudEndpoint(
    typing_extensions.TypedDict, total=False
):
    name: str
    scopes: _list[str]
    url: str

@typing.type_check_only
class AssistantDevicesPlatformProtoCoreDismissAssistantCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoDeviceActionCapability(
    typing_extensions.TypedDict, total=False
):
    assistantDeviceInRoomOptOut: bool
    builtInIntentMode: typing_extensions.Literal[
        "INTENT_MODE_UNSPECIFIED",
        "ENABLE_ALL",
        "ENABLE_ALL_AUTO_ACTIONS",
        "ENABLE_CONFIGURED_INTENTS_ONLY",
        "PUNT_FOR_UNCONFIGURED_INTENTS",
    ]
    customIntentMode: typing_extensions.Literal[
        "INTENT_MODE_UNSPECIFIED",
        "ENABLE_ALL",
        "ENABLE_ALL_AUTO_ACTIONS",
        "ENABLE_CONFIGURED_INTENTS_ONLY",
        "PUNT_FOR_UNCONFIGURED_INTENTS",
    ]
    defaultExecutionConfig: AssistantDevicesPlatformProtoExecutionConfig
    inlinedActionCapability: AssistantDevicesPlatformProtoInlinedActionCapability
    intents: _list[AssistantDevicesPlatformProtoIntent]
    providedData: _list[AssistantDevicesPlatformProtoProvidedData]
    traits: _list[str]
    understandingConfig: AssistantDevicesPlatformProtoUnderstandingConfig

@typing.type_check_only
class AssistantDevicesPlatformProtoDeviceModifySettingCapability(
    typing_extensions.TypedDict, total=False
):
    clientOpProperty: AssistantApiClientOpPropertiesDeviceModifySettingClientOpProperty

@typing.type_check_only
class AssistantDevicesPlatformProtoDeviceTakePhotoCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoExecutionConfig(
    typing_extensions.TypedDict, total=False
):
    cloudEndpointName: str
    cloudIntentTranslationDisabled: bool
    intentCommandFormat: str
    localDisabled: bool
    localExecutionType: typing_extensions.Literal["DEFAULT", "CLOUD"]
    remoteDisabled: bool
    remoteExecutionType: typing_extensions.Literal["DEFAULT", "CLOUD"]

@typing.type_check_only
class AssistantDevicesPlatformProtoExecutionWaitCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoInlinedActionCapability(
    typing_extensions.TypedDict, total=False
):
    alarm: AssistantDevicesPlatformProtoAlarmCapability
    responseLimits: AssistantDevicesPlatformProtoResponseLimits
    supportSdkExecute: bool
    supportedDeviceOps: AssistantDevicesPlatformProtoSupportedDeviceOps
    supportsMultiResponse: bool
    timer: AssistantDevicesPlatformProtoTimerCapability
    ttsOutput: AssistantDevicesPlatformProtoTtsOutputCapability

@typing.type_check_only
class AssistantDevicesPlatformProtoIntValueSpec(
    typing_extensions.TypedDict, total=False
):
    maxValue: str
    minValue: str

@typing.type_check_only
class AssistantDevicesPlatformProtoIntent(typing_extensions.TypedDict, total=False):
    argSpecs: dict[str, typing.Any]
    executionConfig: AssistantDevicesPlatformProtoExecutionConfig
    name: str
    providedDataNames: _list[str]
    securityConfig: AssistantDevicesPlatformProtoSecurityConfig
    triggerConditions: _list[AssistantDevicesPlatformProtoTriggerCondition]

@typing.type_check_only
class AssistantDevicesPlatformProtoInternalCapability(
    typing_extensions.TypedDict, total=False
):
    allowedAssistantSdkAuthProjectIds: _list[str]
    appCapabilitiesFromDeviceInstallApps: bool
    cloudDeviceActionEndpoint: AssistantDevicesPlatformProtoCloudEndpoint
    deviceActionsEligibleForHighConfidence: bool
    forceSignIn: bool
    forceThirdPartyDeviceIdForDeviceLookup: bool
    forceTransactionsAuthentication: bool
    hasCustomSearchResultsRendering: bool
    overrideProjectIdForDeviceLookup: str
    stadiaAssistantConfig: AssistantDevicesPlatformProtoInternalCapabilityStadiaAssistantConfig
    telephoneAttribution: bool

@typing.type_check_only
class AssistantDevicesPlatformProtoInternalCapabilityStadiaAssistantConfig(
    typing_extensions.TypedDict, total=False
):
    stadiaPlatform: typing_extensions.Literal[
        "UNSPECIFIED", "CHROMECAST", "WEB_BROWSER"
    ]

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaNextCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaPauseCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaPlayMediaCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaPreviousCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaResumeCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaShowControlsCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoMediaStopCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoOptionValueSpec(
    typing_extensions.TypedDict, total=False
):
    values: _list[str]

@typing.type_check_only
class AssistantDevicesPlatformProtoProvidedData(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class AssistantDevicesPlatformProtoProviderFulfillCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoProviderOpenCapability(
    typing_extensions.TypedDict, total=False
):
    clientOpProperty: AssistantApiClientOpPropertiesProviderOpenClientOpProperty

@typing.type_check_only
class AssistantDevicesPlatformProtoResponseLimits(
    typing_extensions.TypedDict, total=False
):
    maxAssistResponseSizeBytes: int
    maxDisplayLinesBytes: int
    maxSuggestionChipBytes: int
    maxSuggestionChips: int

@typing.type_check_only
class AssistantDevicesPlatformProtoSecurityConfig(
    typing_extensions.TypedDict, total=False
):
    authMechanismForRemoteRequests: typing_extensions.Literal[
        "NONE", "ENABLED", "FINGERPRINT_OR_PASSWORD", "PIN"
    ]

@typing.type_check_only
class AssistantDevicesPlatformProtoSendChatMessageCapability(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AssistantDevicesPlatformProtoSupportedDeviceOps(
    typing_extensions.TypedDict, total=False
):
    callCall: AssistantDevicesPlatformProtoCallCallCapability
    clientReconnect: AssistantDevicesPlatformProtoClientReconnectCapability
    coreDismissAssistant: AssistantDevicesPlatformProtoCoreDismissAssistantCapability
    deviceModifySetting: AssistantDevicesPlatformProtoDeviceModifySettingCapability
    deviceTakePhoto: AssistantDevicesPlatformProtoDeviceTakePhotoCapability
    executionWait: AssistantDevicesPlatformProtoExecutionWaitCapability
    mediaNext: AssistantDevicesPlatformProtoMediaNextCapability
    mediaPause: AssistantDevicesPlatformProtoMediaPauseCapability
    mediaPlayMedia: AssistantDevicesPlatformProtoMediaPlayMediaCapability
    mediaPrevious: AssistantDevicesPlatformProtoMediaPreviousCapability
    mediaResume: AssistantDevicesPlatformProtoMediaResumeCapability
    mediaShowControls: AssistantDevicesPlatformProtoMediaShowControlsCapability
    mediaStop: AssistantDevicesPlatformProtoMediaStopCapability
    providerFulfill: AssistantDevicesPlatformProtoProviderFulfillCapability
    providerOpen: AssistantDevicesPlatformProtoProviderOpenCapability
    sendChatMessage: AssistantDevicesPlatformProtoSendChatMessageCapability

@typing.type_check_only
class AssistantDevicesPlatformProtoTimerCapability(
    typing_extensions.TypedDict, total=False
):
    maxSupportedExtendedTimerDuration: AssistantApiDuration
    maxSupportedTimerDuration: AssistantApiDuration
    maxSupportedTimers: int
    supportsMutateAction: bool

@typing.type_check_only
class AssistantDevicesPlatformProtoTriggerCondition(
    typing_extensions.TypedDict, total=False
):
    requiredStateValues: dict[str, typing.Any]
    simpleTts: str
    status: str

@typing.type_check_only
class AssistantDevicesPlatformProtoTtsOutputCapability(
    typing_extensions.TypedDict, total=False
):
    supportsStructuredTts: bool

@typing.type_check_only
class AssistantDevicesPlatformProtoUnderstandingConfig(
    typing_extensions.TypedDict, total=False
):
    nluLevel: typing_extensions.Literal["DEFAULT_SHALLOW_NLU", "NO_NLU", "DEEP_NLU"]

@typing.type_check_only
class AssistantGroundingProviderProviderSignalResult(
    typing_extensions.TypedDict, total=False
):
    isDefaultProvider: bool
    isForegroundProvider: bool
    isInAppProvider: bool
    isInstalled: bool
    isLastUsedProvider: bool
    isQueryRestrictedProvider: bool
    providerSelectionResult: AssistantContextProviderSelectionResult
    providerTypeSignal: typing_extensions.Literal[
        "UNKNOWN_TYPE",
        "ZEROTH_PARTY_TYPE",
        "ANDROID_SYSTEM_API_TYPE",
        "ANDROID_APP_TYPE",
    ]

@typing.type_check_only
class AssistantGroundingRankerAssistantInteractionFeatures(
    typing_extensions.TypedDict, total=False
):
    timeDecayed14dHalfLife: float
    timeDecayed1dHalfLife: float
    timeDecayed7dHalfLife: float
    timeDecayedAccepted14dHalfLife: float
    timeDecayedAuis14dHalfLife: float
    timeDecayedCanceled14dHalfLife: float
    timeDecayedDeclined14dHalfLife: float
    timeSinceLastButOneCanceledActionSecs: float
    timeSinceLastButOneCompletedActionSecs: float
    timeSinceLastButTwoCanceledActionSecs: float
    timeSinceLastButTwoCompletedActionSecs: float
    timeSinceLastCanceledActionSecs: float
    timeSinceLastCompletedActionSecs: float

@typing.type_check_only
class AssistantGroundingRankerContactGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    conceptId: str
    contactSource: typing_extensions.Literal[
        "FOCUS_CONTACT",
        "DEVICE_CONTACT",
        "GMAIL_INFERENCE",
        "S3_DECORATOR",
        "RELATIONSHIP",
        "VANITY",
        "SIGNED_OUT_DEVICE",
        "SHARED_CONTACT",
        "FAMILY_MEMBER",
        "SHARED_DEVICE_USER",
        "ON_DEVICE_CONTACT_LOOKUP",
        "APP_SEARCH_CONTACT",
    ]
    isRelationshipFromAnnotation: bool
    isRelationshipFromSource: bool
    isSingleCandidate: bool
    isStarred: bool
    matchedNameType: typing_extensions.Literal[
        "UNSPECIFIED",
        "GIVEN_NAME",
        "FAMILY_NAME",
        "FULL_NAME",
        "NICKNAME",
        "OTHER",
        "INITIAL_WITH_FAMILY_NAME",
        "EMAIL_USERNAME",
        "VANITY_NICKNAME",
        "GIVEN_NAME_ALIAS",
        "FULL_NAME_ALIAS",
        "HOMOPHONE_GIVEN_NAME",
        "HOMOPHONE_FAMILY_NAME",
        "HOMOPHONE_FULL_NAME",
        "HOMOPHONE_NICKNAME",
        "GIVEN_MIDDLE_NAME",
        "GIVEN_NAME_WITH_FAMILY_NAME_INITIAL",
        "EMAIL_OF_FAMILY_MEMBER",
    ]
    numAlternateNameFromFuzzyContactMatch: float
    numAlternateNamesFromS3: float
    numAlternativeNamesFromInterpretation: float
    numCandidates: float
    recognitionAlternateSource: typing_extensions.Literal[
        "NONE",
        "S3_HYPOTHESES",
        "GENIE_QUERY_ALTERNATIVES",
        "NAME_CORRECTION_LOG",
        "FUZZY_CONTACT_MATCH",
        "NEURAL_CONTACT_MATCH",
        "NEURAL_CONTACT_MATCH_DARK_LAUNCH",
        "PERSONALIZED_NAME_CORRECTION_LOG",
    ]

@typing.type_check_only
class AssistantGroundingRankerDeviceContactAffinityFeatures(
    typing_extensions.TypedDict, total=False
):
    aggregateAffinity: float
    callAffinity: float
    messageAffinity: float

@typing.type_check_only
class AssistantGroundingRankerDeviceGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    deviceId: AssistantApiCoreTypesGovernedDeviceId
    deviceTargetingFeatures: AssistantGroundingRankerDeviceTargetingFeatures
    deviceTargetingLabels: AssistantGroundingRankerDeviceTargetingLabels
    surfaceIdentity: AssistantApiCoreTypesGovernedSurfaceIdentity

@typing.type_check_only
class AssistantGroundingRankerDeviceTargetingFeatures(
    typing_extensions.TypedDict, total=False
):
    properties: AssistantGroundingRankerDeviceTargetingFeaturesProperties
    states: AssistantGroundingRankerDeviceTargetingFeaturesStates

@typing.type_check_only
class AssistantGroundingRankerDeviceTargetingFeaturesProperties(
    typing_extensions.TypedDict, total=False
):
    deviceModelId: str
    isOwnedBySpeaker: bool
    surfaceType: typing_extensions.Literal[
        "UNKNOWN_TYPE",
        "ACCL",
        "AGSA",
        "ANDROID",
        "ANDROID_AUTO",
        "ANDROID_LITE",
        "ANDROID_PHONE",
        "ANDROID_SCREENLESS",
        "ANDROID_SMART_DISPLAY",
        "ANDROID_TABLET",
        "ANDROID_THINGS",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_WEAR",
        "ASSISTANT_KIT",
        "ASSISTANT_SDK",
        "AUTO",
        "CAST_OS",
        "CHROME_OS",
        "CHROMECAST_MANHATTAN",
        "CLOUD_DEVICE",
        "CROS",
        "FITBIT_OS_WATCH",
        "FITBIT_OS_WATCH_ANDROID",
        "FITBIT_OS_WATCH_IOS",
        "GOOGLE_HOME",
        "HEADPHONE",
        "HEADPHONE_ANDROID",
        "HEADPHONE_IOS",
        "IOPA",
        "IOS",
        "IOS_SCREENLESS",
        "IPAD",
        "IPHONE",
        "KAI_OS",
        "KAI_OS_AMA",
        "LIBASSISTANT",
        "PHONE",
        "PIXEL",
        "PIXEL5",
        "PIXEL6",
        "PIXEL7",
        "PIXEL8",
        "PIXEL_BUDS",
        "PIXEL_TABLET",
        "PIXEL_TABLET_HUB_MODE",
        "PIXEL_TABLET_PERSONAL_MODE",
        "PIXEL_WATCH",
        "SCREENLESS",
        "SMART_DISPLAY",
        "SPEAKER",
        "TABLET",
        "TELEPHONE",
        "THING",
        "WATCH",
        "WEAR_OS",
        "WEAR_OS_WATCH",
    ]

@typing.type_check_only
class AssistantGroundingRankerDeviceTargetingFeaturesStates(
    typing_extensions.TypedDict, total=False
):
    distance: typing_extensions.Literal[
        "UNKNOWN_DISTANCE", "CLOSEST", "EQUALLY_CLOSE", "FURTHER"
    ]
    hasBufferingMediaSession: bool
    hasPausedMediaSession: bool
    hasPlayingMediaSession: bool
    inSameRoomAsHearingDevice: bool
    inSameRoomAsLocalDevice: bool
    inSameStructureAsHearingDevice: bool
    inSameStructureAsLocalDevice: bool
    isDocked: bool
    isLocal: bool
    isLocked: bool
    isTethered: bool
    mediaFocusStateFromHearingDevice: typing_extensions.Literal[
        "NO_FOCUS", "HARD_FOCUS", "SOFT_FOCUS"
    ]
    mediaFocusStateFromLocalDevice: typing_extensions.Literal[
        "NO_FOCUS", "HARD_FOCUS", "SOFT_FOCUS"
    ]

@typing.type_check_only
class AssistantGroundingRankerDeviceTargetingLabels(
    typing_extensions.TypedDict, total=False
):
    isSelectedByLumos: bool

@typing.type_check_only
class AssistantGroundingRankerEndpointGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    isUserConfirmed: bool

@typing.type_check_only
class AssistantGroundingRankerGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    contactGroundingProviderFeatures: AssistantGroundingRankerContactGroundingProviderFeatures
    deviceGroundingProviderFeatures: AssistantGroundingRankerDeviceGroundingProviderFeatures
    endpointGroundingProviderFeatures: AssistantGroundingRankerEndpointGroundingProviderFeatures
    mediaGroundingProviderFeatures: AssistantGroundingRankerMediaGroundingProviderFeatures
    podcastGroundingProviderFeatures: AssistantGroundingRankerPodcastGroundingProviderFeatures
    providerGroundingProviderFeatures: AssistantGroundingRankerProviderGroundingProviderFeatures

@typing.type_check_only
class AssistantGroundingRankerLaaFeature(typing_extensions.TypedDict, total=False):
    name: str
    value: float

@typing.type_check_only
class AssistantGroundingRankerLaaFeatures(typing_extensions.TypedDict, total=False):
    bindingSet: AssistantGroundingRankerLaaFeaturesBindingSet
    communicationEndpoint: AssistantGroundingRankerLaaFeaturesCommunicationEndpoint
    contact: AssistantGroundingRankerLaaFeaturesContact
    features: _list[AssistantGroundingRankerLaaFeature]
    provider: AssistantGroundingRankerLaaFeaturesProvider

@typing.type_check_only
class AssistantGroundingRankerLaaFeaturesBindingSet(
    typing_extensions.TypedDict, total=False
):
    assistantInteractionFeatures: AssistantGroundingRankerAssistantInteractionFeatures

@typing.type_check_only
class AssistantGroundingRankerLaaFeaturesCommunicationEndpoint(
    typing_extensions.TypedDict, total=False
):
    assistantInteractionFeatures: AssistantGroundingRankerAssistantInteractionFeatures

@typing.type_check_only
class AssistantGroundingRankerLaaFeaturesContact(
    typing_extensions.TypedDict, total=False
):
    assistantInteractionFeatures: AssistantGroundingRankerAssistantInteractionFeatures
    deviceContactAffinityFeatures: AssistantGroundingRankerDeviceContactAffinityFeatures

@typing.type_check_only
class AssistantGroundingRankerLaaFeaturesProvider(
    typing_extensions.TypedDict, total=False
):
    assistantInteractionFeatures: AssistantGroundingRankerAssistantInteractionFeatures

@typing.type_check_only
class AssistantGroundingRankerMediaGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    albumReleaseType: typing_extensions.Literal[
        "UNKNOWN", "ALBUM", "SINGLE", "EXTENDED_PLAY"
    ]
    ambiguityClassifier: typing_extensions.Literal[
        "UNKNOWN", "SONG_ALBUM_AMBIGUOUS", "NOT_AMBIGUOUS", "SINGLE_MEDIA_ITEM"
    ]
    entityMid: str
    hasCastVideoDeeplink: bool
    hasTypeSemanticEdge: bool
    isCastVideo: bool
    isExclusiveOriginalProvider: bool
    isMediaSearchQuerySubsetOfEntityNameAndArtist: bool
    isMostRecentSongAlbumAmbiguous: bool
    isSeedRadio: bool
    isSeedRadioRequest: bool
    isSelfReportedSvodProvider: bool
    isYoutubeMusicSeeking: bool
    mediaAccountType: typing_extensions.Literal[
        "ANONYMOUS_ACCOUNT",
        "BASIC_SUBSCRIPTION",
        "PREMIUM_SUBSCRIPTION",
        "FREE_CONTENT",
    ]
    mediaContentType: typing_extensions.Literal[
        "MEDIA_CONTENT_TYPE_UNSPECIFIED",
        "MUSIC_TRACK",
        "MUSIC_ARTIST",
        "MUSIC_ALBUM",
        "PUBLIC_PLAYLIST",
        "PERSONAL_PLAYLIST",
        "MUSIC_PERSONALIZED_MIX",
        "MUSIC_GENRE_MIX",
        "MUSIC_SEED_RADIO",
        "MUSIC_STATION",
        "RADIO_STATION",
        "RADIO_NETWORK",
        "PODCAST_SERIES",
        "PODCAST_GENERIC",
        "PODCAST_GENRE",
        "PODCAST_TOPIC",
        "PODCAST_RESUME",
        "PODCAST_EPISODE",
        "VIDEO",
        "MUSIC_VIDEO",
        "VIDEO_RECOMMENDED_PLAYLIST",
        "MUSIC_VIDEO_PERSONALIZED_PLAYLIST",
        "TV_SHOW",
        "TV_SHOW_SEASON",
        "TV_SHOW_EPISODE",
        "MOVIE",
        "YOUTUBE_CHANNEL",
        "TV_CHANNEL",
        "SPORTS_TEAM_GAME",
        "AUDIO_BOOK",
        "AUDIO_STORY",
        "YOUTUBE_VIDEO_PLAYLIST",
        "TV_ARTIST",
        "NEWS",
        "VIDEO_GAME",
        "DIRECTOR",
        "ACTOR",
        "MOVIE_SERIES",
        "APP",
    ]
    mscRate: float
    scubedPSaiMusic: float
    scubedPSaiTvm: float
    type: typing_extensions.Literal[
        "UNKNOWN",
        "TRACK",
        "ALBUM",
        "ARTIST",
        "PLAYLIST",
        "EPISODE",
        "MOVIE",
        "PHOTO",
        "TV_SHOW_EPISODE",
        "MUSIC_GENRE",
        "MUSIC_STATION",
        "AUDIO_BOOK",
        "CHAPTER",
        "RADIO_STATION",
        "MUSIC_MIX",
        "SPORTS_EVENT",
        "TV_CHANNEL",
        "VIDEO",
        "VIDEO_RECOMMENDED_PLAYLIST",
        "YOUTUBE_CHANNEL",
        "YOUTUBE_VIDEO_PLAYLIST",
        "TV_SHOW",
        "NEWS",
        "NARRATED_WEB",
        "NEWS_CALL_TO_ACTION",
        "NEWS_OVERVIEW",
        "AUDIO_STORY",
        "PODCAST_SERIES",
        "PODCAST_EPISODE",
    ]
    youtubeConfidenceScore: float

@typing.type_check_only
class AssistantGroundingRankerPodcastGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    isExclusive: bool
    podcastListenersCount: int
    popularityScore: float
    scubedNg3ModelScore: float
    scubedTstarScore: float
    youtubeConfidenceScore: float

@typing.type_check_only
class AssistantGroundingRankerProviderGroundingProviderFeatures(
    typing_extensions.TypedDict, total=False
):
    providerClusterIds: _list[str]
    providerId: AssistantContextProviderId
    providerSignalResult: AssistantGroundingProviderProviderSignalResult
    pslScore: float

@typing.type_check_only
class AssistantLogsAllMediaStreamLog(typing_extensions.TypedDict, total=False):
    streams: _list[AssistantLogsMediaStreamLog]
    targetStream: AssistantLogsMediaStreamLog

@typing.type_check_only
class AssistantLogsAmbiguousTargetDeviceLog(typing_extensions.TypedDict, total=False):
    ambiguousDeviceIndex: _list[int]
    devicesAfterPromoters: _list[AssistantLogsDeviceInfoLog]
    finalTargetDevice: AssistantLogsDeviceInfoLog
    playabilityFilteredDevicesIndex: _list[int]
    puntInfoLog: _list[AssistantLogsAmbiguousTargetDeviceLogPuntInfoLog]
    structureFilteredDeviceIndex: _list[int]

@typing.type_check_only
class AssistantLogsAmbiguousTargetDeviceLogPuntInfoLog(
    typing_extensions.TypedDict, total=False
):
    deviceIndex: _list[int]
    mediaExcuse: int
    providerMid: str

@typing.type_check_only
class AssistantLogsCommunicationDeviceContactInfoLog(
    typing_extensions.TypedDict, total=False
):
    rawContactInfo: _list[AssistantLogsCommunicationRawDeviceContactInfoLog]

@typing.type_check_only
class AssistantLogsCommunicationFuzzyNgramMatchLog(
    typing_extensions.TypedDict, total=False
):
    relativeCost: float
    type: typing_extensions.Literal[
        "NONE",
        "EDIT_DISTANCE",
        "GENIE_PLEXICON_DISTANCE",
        "GENIE_ALTERNATIVE_RECOGNITION",
        "JAPANESE_NAME_TRANSLITERATOR",
    ]

@typing.type_check_only
class AssistantLogsCommunicationGoogleAccountProvenance(
    typing_extensions.TypedDict, total=False
):
    email: str
    gaiaId: str
    isDasherAccount: bool

@typing.type_check_only
class AssistantLogsCommunicationPersonMetadataLog(
    typing_extensions.TypedDict, total=False
):
    deviceContactInfo: _list[AssistantLogsCommunicationDeviceContactInfoLog]

@typing.type_check_only
class AssistantLogsCommunicationPersonalContactDataLog(
    typing_extensions.TypedDict, total=False
):
    accountProvenance: AssistantLogsCommunicationGoogleAccountProvenance
    commonNameAliasConfidence: float
    conceptId: str
    deviceContactAttributes: _list[int]
    emailIdCount: int
    fuzzyNgramMatch: _list[AssistantLogsCommunicationFuzzyNgramMatchLog]
    gaiaId: str
    isContactFromSecondaryAccount: bool
    isShared: bool
    isTransliteratedMatch: bool
    isVanityContact: bool
    isVisibleToGuestsRelationship: bool
    matchedNameType: typing_extensions.Literal[
        "UNSPECIFIED",
        "GIVEN_NAME",
        "FAMILY_NAME",
        "FULL_NAME",
        "NICKNAME",
        "OTHER",
        "INITIAL_WITH_FAMILY_NAME",
        "EMAIL_USERNAME",
        "VANITY_NICKNAME",
        "GIVEN_NAME_ALIAS",
        "FULL_NAME_ALIAS",
        "HOMOPHONE_GIVEN_NAME",
        "HOMOPHONE_FAMILY_NAME",
        "HOMOPHONE_FULL_NAME",
        "HOMOPHONE_NICKNAME",
        "GIVEN_MIDDLE_NAME",
        "GIVEN_NAME_WITH_FAMILY_NAME_INITIAL",
        "EMAIL_OF_FAMILY_MEMBER",
    ]
    matchedRecognitionAlternateName: str
    matchedStarlightLookupName: _list[str]
    metadata: AssistantLogsCommunicationPersonMetadataLog
    nameMatchedContactIndex: _list[int]
    originalQueryName: str
    phone: _list[AssistantLogsCommunicationPhoneLog]
    phoneNumberCount: int
    pkgReferenceType: typing_extensions.Literal[
        "UNKNOWN_PKG_REFERENCE_TYPE", "PKG_NAME_REFERENCE", "PKG_RELATIONSHIP_REFERENCE"
    ]
    recognitionAlternateScore: float
    recognitionAlternateSource: typing_extensions.Literal[
        "NONE",
        "S3_HYPOTHESES",
        "GENIE_QUERY_ALTERNATIVES",
        "NAME_CORRECTION_LOG",
        "FUZZY_CONTACT_MATCH",
        "NEURAL_CONTACT_MATCH",
        "NEURAL_CONTACT_MATCH_DARK_LAUNCH",
        "PERSONALIZED_NAME_CORRECTION_LOG",
    ]
    relationshipMemoryCount: int
    selectedPhone: AssistantLogsCommunicationPhoneLog
    shortcutContactInfo: MajelContactInformationShortcutInformation
    source: typing_extensions.Literal[
        "UNKNOWN",
        "FOCUS_CONTACT",
        "DEVICE_CONTACT",
        "GMAIL_INFERENCE",
        "S3_DECORATOR",
        "RELATIONSHIP",
        "VANITY",
        "SIGNED_OUT_DEVICE",
        "SHARED_CONTACT",
        "FAMILY_MEMBER",
        "SHARED_DEVICE_USER",
        "ON_DEVICE_CONTACT_LOOKUP",
        "APP_SEARCH_CONTACT",
    ]
    systemContactGroupId: _list[int]
    whatsappPhoneNumberCount: int

@typing.type_check_only
class AssistantLogsCommunicationPhoneLog(typing_extensions.TypedDict, total=False):
    rawDeviceContactInfo: _list[AssistantLogsCommunicationRawDeviceContactInfoLog]
    type: str

@typing.type_check_only
class AssistantLogsCommunicationRawDeviceContactInfoLog(
    typing_extensions.TypedDict, total=False
):
    accountType: str

@typing.type_check_only
class AssistantLogsDefaultDeviceLog(typing_extensions.TypedDict, total=False):
    defaultSpeaker: AssistantLogsDeviceInfoLog
    defaultTv: AssistantLogsDeviceInfoLog
    sourceDeviceId: str

@typing.type_check_only
class AssistantLogsDefaultDevicesLog(typing_extensions.TypedDict, total=False):
    localDefaultDevices: AssistantLogsDefaultDeviceLog
    nearbyDefaultDevices: _list[AssistantLogsDefaultDeviceLog]

@typing.type_check_only
class AssistantLogsDeviceAnnotationLog(typing_extensions.TypedDict, total=False):
    rawTextFromQuery: str
    type: typing_extensions.Literal[
        "NO_DEVICE_ANNOTATION",
        "DEVICE_ID_ANNOTATION",
        "DEVICE_TYPE_ANNOTATION",
        "DEVICE_TEXT_ANNOTATION",
    ]
    userDefinedName: str

@typing.type_check_only
class AssistantLogsDeviceInfoLog(typing_extensions.TypedDict, total=False):
    arbitrationDeviceId: str
    connectivity: typing_extensions.Literal[
        "UNKNOWN_CONNECTIVITY", "ONLINE_STATE", "OFFLINE_STATE"
    ]
    deviceId: str
    deviceIdLog: AssistantLogsSettingsDeviceIdLog
    deviceIndex: int
    deviceModelId: str
    distance: typing_extensions.Literal[
        "UNKNOWN_DISTANCE", "CLOSEST", "EQUALLY_CLOSE", "FURTHER"
    ]
    eliminatingLumosProcessor: typing_extensions.Literal[
        "UNKNOWN_LUMOS_PROCESSOR",
        "CAPABILITIES_FILTER",
        "DEVICE_ANNOTATION_FILTER",
        "DEVICE_CONNECTIVITY_FILTER",
        "LOCAL_DEVICE_INCLUSIVENESS_FILTER",
        "LOCATION_FILTER",
        "MEDIA_PLAYBACK_FILTER",
        "SAFETY_FILTER",
        "TRAITS_FILTER",
        "DEVICE_TYPE_FILTER",
        "APP_FILTER",
        "HYBRID_DEVICE_PROPERTIES_FILTER",
        "NEARBY_DEVICE_FILTER",
        "DEVICE_ATTRIBUTES_FILTER",
        "LAST_USED_DEVICE_FILTER",
        "DEFAULT_MEDIA_OUTPUT_PROMOTER",
        "DEVICE_GROUP_PROMOTER",
        "LOCAL_DEVICE_PROMOTER",
        "LOCATION_PROMOTER",
        "MEDIA_FOCUS_PROMOTER",
        "MEDIA_PLAYBACK_PROMOTER",
        "SAME_NAME_DEVICE_PROMOTER",
        "PHONE_TARGETING_PROMOTER",
        "TRAITS_PROMOTER",
        "DEVICE_TYPE_PROMOTER",
        "FEATURE_EXTRACTOR",
        "LABELER",
    ]
    homeStructureId: str
    isRemote: bool
    isTethered: bool
    mediaCapabilities: AssistantLogsMediaCapabilities
    mediaDeviceType: typing_extensions.Literal[
        "UNKNOWN_DEVICE_TYPE",
        "ASSISTANT",
        "HOME_AUTOMATION",
        "CAST",
        "CAST_GROUP",
        "QUARTZ",
        "QUARTZ_IOS",
        "CLOUD_AUTO",
    ]
    name: str
    sessions: _list[AssistantLogsDeviceMediaSessionLog]
    surfaceType: typing_extensions.Literal[
        "UNKNOWN",
        "ANDROID_ALLO",
        "ANDROID_AUTO",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_TV_KIDS",
        "ANDROID_WEAR",
        "AR_GLASSES",
        "ASSISTANT_SDK",
        "AUDIOWEAR",
        "BUBBLE_CHARACTERS_IOS",
        "CAPABILITY_BASED_SURFACE",
        "CHROMECAST_ASSISTANT",
        "CHROMECAST_MANHATTAN",
        "CHROMECAST_SEARCH",
        "CLOUD_DEVICE",
        "COMPANION_SCREEN",
        "DYNAMITE_WEB",
        "ENSEMBLE",
        "EYESFREE_AGSA",
        "EYESFREE_GMM",
        "GBOARD",
        "GLASS",
        "GOOGLE_HOME",
        "HANGOUTS_CHATBOT",
        "IOS_ALLO",
        "IOS_GSA",
        "IOS_WEAR",
        "LIBASSISTANT",
        "LINE_CHATBOT",
        "MULTIMODAL_AGSA",
        "NON_ASSISTANT_SURFACE",
        "OPA_AGSA",
        "OPA_AGSA_CHROME_OS",
        "OPA_ANDROID_AUTO",
        "OPA_ANDROID_LITE",
        "OPA_ANDROID_SCREENLESS",
        "OPA_ANDROID_SMART_DISPLAY",
        "OPA_ANDROID_TABLET",
        "OPA_CROS",
        "OPA_GACS",
        "OPA_IOS",
        "OPA_IOS_SCREENLESS",
        "OPA_KAIOS",
        "OPA_MOBILE_WEB",
        "RTOS_PHONE",
        "SMS_CHATBOT",
        "TELEGRAM_CHATBOT",
        "TELEPHONE_ASSISTANT",
        "VERILY_ONDUO",
        "YOUTUBE_APP",
        "AGSA_BISTO_FOR_EVAL",
        "COGSWORTH_FOR_EVAL",
        "LOCKHART_MIC_FOR_EVAL",
        "OPA_ANDROID_AUTO_EMBEDDED_FAKE",
        "SPARK",
        "WALLE",
        "UNIT_TESTING",
    ]

@typing.type_check_only
class AssistantLogsDeviceMediaSessionLog(typing_extensions.TypedDict, total=False):
    deviceId: AssistantApiCoreTypesDeviceId
    mediaSessionType: typing_extensions.Literal[
        "UNKNOWN",
        "SINGLE_DEVICE_SESSION",
        "STATIC_GROUP_SESSION",
        "DYNAMIC_GROUP_SESSION",
    ]
    mediaType: typing_extensions.Literal[
        "UNKNOWN",
        "TRACK",
        "ALBUM",
        "ARTIST",
        "PLAYLIST",
        "EPISODE",
        "MOVIE",
        "PHOTO",
        "TV_SHOW_EPISODE",
        "MUSIC_GENRE",
        "MUSIC_STATION",
        "AUDIO_BOOK",
        "CHAPTER",
        "RADIO_STATION",
        "MUSIC_MIX",
        "SPORTS_EVENT",
        "TV_CHANNEL",
        "VIDEO",
        "VIDEO_RECOMMENDED_PLAYLIST",
        "YOUTUBE_CHANNEL",
        "YOUTUBE_VIDEO_PLAYLIST",
        "TV_SHOW",
        "NEWS",
        "NARRATED_WEB",
        "NEWS_CALL_TO_ACTION",
        "NEWS_OVERVIEW",
        "AUDIO_STORY",
        "PODCAST_SERIES",
        "PODCAST_EPISODE",
    ]
    playbackState: typing_extensions.Literal[
        "UNKNOWN_STATE",
        "STOPPED",
        "PAUSED",
        "PLAYING",
        "FAST_FORWARDING",
        "REWINDING",
        "BUFFERING",
        "ERROR",
        "CONNECTING",
        "SKIPPING_TO_PREVIOUS",
        "SKIPPING_TO_NEXT",
        "SKIPPING_TO_QUEUE_ITEM",
    ]
    providerMid: str
    supportedTransportControl: _list[
        typing_extensions.Literal[
            "UNKNOWN_COMMAND",
            "PLAY_FROM_SEARCH",
            "PLAY_FROM_URI",
            "SEND_CUSTOM_ACTION",
            "SKIP_TO_NEXT",
            "SKIP_TO_PREVIOUS",
            "PLAY",
            "PAUSE",
            "STOP",
            "SET_RATING",
            "SEEK_TO",
            "SHUFFLE",
            "REWIND",
            "FAST_FORWARD",
            "SKIP_TO_QUEUE_ITEM",
            "SET_REPEAT_MODE",
            "SET_CAPTIONING_ENABLED",
        ]
    ]

@typing.type_check_only
class AssistantLogsDeviceSelectionLog(typing_extensions.TypedDict, total=False):
    allDefaultDevices: _list[AssistantLogsDefaultDeviceLog]
    allMediaStreamLog: AssistantLogsAllMediaStreamLog
    counterfactualDeviceSelectionLog: AssistantLogsDeviceSelectionLog
    defaultDevices: AssistantLogsDefaultDeviceLog
    defaultDevicesLog: AssistantLogsDefaultDevicesLog
    devicesStr: _list[str]
    inputErrorLog: _list[AssistantLogsInputErrorLog]
    localDevice: AssistantLogsDeviceInfoLog
    logDataSource: typing_extensions.Literal[
        "UNKNOWN", "MEDIA_FOCUS_SELECTOR", "LUMOS_DEVICE_TARGETING_LIBRARY"
    ]
    mediaFocus: AssistantLogsMediaFocusInfoLog
    mediaFocusesLog: AssistantLogsMediaFocusesLog
    nearbyDevicesLog: AssistantLogsNearbyDevicesLog
    queryAnnotation: AssistantLogsQueryAnnotationLog
    selectionResult: AssistantLogsDeviceSelectionResultLog
    testCodes: _list[AssistantLogsDeviceTargetingTestCode]

@typing.type_check_only
class AssistantLogsDeviceSelectionResultLog(typing_extensions.TypedDict, total=False):
    ambiguousTargetDevices: AssistantLogsAmbiguousTargetDeviceLog
    deviceSelectionDecisionSummary: AssistantLogsMediaDeviceSelectionDecisionSummary
    deviceTargetingErrorType: typing_extensions.Literal[
        "UNKNOWN_ERROR",
        "NO_DEVICE_IN_SAME_STRUCTURE",
        "NO_DEVICE_IN_SAME_NETWORK_OR_LOCATION",
        "NO_DEVICE_IN_SAME_STRUCTURE_OR_NETWORK_OR_LOCATION",
        "NO_DEVICE_SATISFIES_SAME_STRUCTURE_OR_UNKNOWN_IF_OWNED",
        "NO_DEVICE_SATISFIES_CAPABILITIES_REQUIREMENT",
        "NO_DEVICE_MATCHED_DEVICE_ANNOTATION",
        "MULTI_TARGET_DEVICE_NOT_SUPPORTED",
        "NO_DEVICE_AFTER_LOCAL_DEVICE_EXCLUDED",
        "UNABLE_TO_TARGET_ONLY_LOCAL_DEVICE",
        "NO_DEVICE_MATCHED_REQUIRED_TRAITS",
        "NO_DEVICE_MATCHED_REQUIRED_ATTRIBUTES",
        "NO_DEVICE_MATCHED_REQUIRED_DEVICE_TYPE",
        "NO_DEVICE_IN_SAME_OR_MENTIONED_STRUCTURE",
        "NO_DEVICE_SATISFIES_PLAYBACK_REQUIREMENT",
        "STRUCT_DISAMBIG_NOT_SUPPORTED",
        "ROOM_DISAMBIG_NOT_SUPPORTED",
        "UNRECOGNIZED_DEVICE_NAME",
        "NO_LINKED_REMOTE_DEVICES",
        "NO_LINKED_REMOTE_VIDEO_DEVICES",
        "NO_SAFE_DEVICE_WITH_SCREEN",
        "ALL_QUALIFIED_DEVICES_OFFLINE",
        "CROSS_STRUCTURE_TARGETING_DISALLOWED",
        "NO_DEVICE_MEETS_PROVIDER_REQUIREMENT",
        "MISSING_LOCAL_DEVICE_SETTING",
        "NO_DEVICE_HAS_REQUIRED_APP",
        "HYBRID_DEVICE_NOT_QUALIFIED",
        "NO_NEARBY_DEVICES",
        "NO_MATCHING_LAST_USED_DEVICE",
    ]
    finalLumosStage: str
    lowConfidenceTargetDevice: AssistantLogsLowConfidenceTargetDeviceLog
    mediaFocusSelectionErrorType: typing_extensions.Literal[
        "UNKNOWN_ERROR",
        "FOUND_MULTIPLE_DEVICES",
        "REQUESTED_DEVICE_HAS_NO_SCREEN",
        "NO_LINKED_REMOTE_DEVICES",
        "NO_LINKED_REMOTE_VIDEO_DEVICES",
        "UNRECOGNIZED_DEVICE_NAME",
        "UNRECOGNIZED_VIDEO_DEVICE_NAME",
        "NO_DEVICE_MEETS_PROVIDER_REQUIREMENT",
        "MULTIPLE_DEVICES_MEET_PROVIDER_REQUIREMENT",
        "REMOTE_CLOUD_CASTING_NOT_ALLOWED",
        "NO_SAFE_DEVICE_WITH_SCREEN",
        "NO_DEVICE_MEETS_PLAYBACK_REQUIREMENT",
        "MULTIPLE_DEVICES_MEET_PLAYBACK_REQUIREMENT",
        "NO_VALID_DEVICE_IN_REQUESTED_ROOM",
        "NO_DEVICE_FOUND_IN_REQUESTED_ROOM",
        "MULTIPLE_DEVICES_FOUND_IN_REQUESTED_ROOM",
        "ALL_QUALIFIED_DEVICES_IN_DIFFERENT_STRUCTURE",
        "QUALIFIED_DEVICE_OFFLINE",
        "ALL_QUALIFIED_DEVICES_OFFLINE",
        "CROSS_STRUCTURE_TARGETING_DISALLOWED",
        "NO_DEVICE_MEETS_STADIA_GAMING_CAPABILITY",
        "MEDIA_STATES_MISSING",
        "NO_DEVICE_SATISFIES_CAPABILITIES_REQUIREMENT",
        "HYBRID_DEVICE_NOT_QUALIFIED",
    ]
    processorInfo: _list[AssistantLogsLumosProcessorInfo]
    qualifiedDevices: AssistantLogsAmbiguousTargetDeviceLog
    singleTargetDevice: AssistantLogsDeviceInfoLog
    targetDevice: AssistantLogsTargetDeviceLog

@typing.type_check_only
class AssistantLogsDeviceTargetingTestCode(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "UNKNOWN",
        "IGNORE_NESTED_DEVICE_MENTION_WITH_ID",
        "INCOMPLETE_LOCAL_AUTO_SETTINGS_FOUND",
        "FINAL_RESULT_RESOLVED_BY_NEARBY_DEVICE",
    ]

@typing.type_check_only
class AssistantLogsInputErrorLog(typing_extensions.TypedDict, total=False):
    errorCode: int
    errorType: typing_extensions.Literal[
        "ERROR_UNKNOWN",
        "ERROR_DEVICE_PROPERTIES",
        "ERROR_HOME_GRAPH",
        "ERROR_CAPABILITIES_ACROSS_DEVICES",
        "ERROR_SURFACE_IDENTITIES_ACROSS_DEVICES",
    ]

@typing.type_check_only
class AssistantLogsLowConfidenceTargetDeviceLog(
    typing_extensions.TypedDict, total=False
):
    fallbackDeviceLog: AssistantLogsDeviceInfoLog
    lowConfTargetDeviceLog: AssistantLogsDeviceInfoLog

@typing.type_check_only
class AssistantLogsLumosProcessorInfo(typing_extensions.TypedDict, total=False):
    devicesAfterRun: int
    devicesBeforeRun: int
    processorName: typing_extensions.Literal[
        "UNKNOWN_LUMOS_PROCESSOR",
        "CAPABILITIES_FILTER",
        "DEVICE_ANNOTATION_FILTER",
        "DEVICE_CONNECTIVITY_FILTER",
        "LOCAL_DEVICE_INCLUSIVENESS_FILTER",
        "LOCATION_FILTER",
        "MEDIA_PLAYBACK_FILTER",
        "SAFETY_FILTER",
        "TRAITS_FILTER",
        "DEVICE_TYPE_FILTER",
        "APP_FILTER",
        "HYBRID_DEVICE_PROPERTIES_FILTER",
        "NEARBY_DEVICE_FILTER",
        "DEVICE_ATTRIBUTES_FILTER",
        "LAST_USED_DEVICE_FILTER",
        "DEFAULT_MEDIA_OUTPUT_PROMOTER",
        "DEVICE_GROUP_PROMOTER",
        "LOCAL_DEVICE_PROMOTER",
        "LOCATION_PROMOTER",
        "MEDIA_FOCUS_PROMOTER",
        "MEDIA_PLAYBACK_PROMOTER",
        "SAME_NAME_DEVICE_PROMOTER",
        "PHONE_TARGETING_PROMOTER",
        "TRAITS_PROMOTER",
        "DEVICE_TYPE_PROMOTER",
        "FEATURE_EXTRACTOR",
        "LABELER",
    ]

@typing.type_check_only
class AssistantLogsMediaCapabilities(typing_extensions.TypedDict, total=False):
    canReceiveRemoteAction: bool
    hasScreen: bool

@typing.type_check_only
class AssistantLogsMediaDeviceSelectionDecisionSummary(
    typing_extensions.TypedDict, total=False
):
    deviceSelectionPreferenceUsed: typing_extensions.Literal[
        "UNKNOWN_PRIORITY",
        "SINGLE_QUALIFIED_SESSION_PREFERRED",
        "FOCUS_SESSION_PREFERRED",
        "FOCUS_DEVICE_SESSION_PREFERRED",
        "LOCAL_DEVICE_SESSION_PREFERRED",
        "PLAYING_DEVICE_STATE_PREFERRED",
        "BUFFERING_DEVICE_STATE_PREFERRED",
        "PAUSED_DEVICE_STATE_PREFERRED",
        "STOPPED_DEVICE_STATE_PREFERRED",
    ]
    deviceSelectionReason: typing_extensions.Literal[
        "UNKNOWN_REASON",
        "SYNDICATION_DEVICE_TARGETED",
        "AUTO_DEVICE_TARGETED",
        "QUERY_DEVICE_ANNOTATION_TARGETED",
        "SINGLE_QUALIFIED_DEVICE_TARGETED",
        "CAST_GROUP_TARGETED",
        "MEDIA_SESSION_TARGETED",
        "FOCUS_DEVICE_TARGETED",
        "DEFAULT_DEVICE_TARGETED",
        "LOCAL_DEVICE_TARGETED",
        "DEVICE_IN_SAME_ROOM_TARGETED",
        "AMBIGUOUS_DEVICES_TARGETED",
        "LOCAL_GROUP_RETARGETED",
        "FOCUS_OF_CLOSE_DEVICE_TARGETED",
        "DEFAULT_OF_CLOSE_DEVICE_TARGETED",
        "SINGLE_QUALIFIED_CLOSE_DEVICE_TARGETED",
        "DEVICE_IN_CLOSE_ROOM_TARGETED",
        "TETHERED_DEVICE_TARGETED",
    ]
    miscSelectionSignal: _list[
        typing_extensions.Literal[
            "NONE",
            "BETTER_MATCH_DEVICE_WITH_HUMAN_FRIENDLY_NAME_FOUND",
            "LOCAL_DEVICE_IMPLICITLY_MENTIONED",
            "USED_LOOSE_PLAYBACK_STATE_REQUIREMENTS",
            "QUERY_3P_DEVICE_ANNOTATION_IGNORED_REQUIREMENTS",
        ]
    ]

@typing.type_check_only
class AssistantLogsMediaFocusInfoLog(typing_extensions.TypedDict, total=False):
    currentFocusDurationSec: int
    dialogTriggered: bool
    focusDevice: AssistantLogsDeviceInfoLog
    mediaFocusState: typing_extensions.Literal[
        "NO_FOCUS", "RECENT_FOCUS", "STALE_FOCUS", "HARD_FOCUS", "SOFT_FOCUS"
    ]
    sourceDeviceId: str

@typing.type_check_only
class AssistantLogsMediaFocusesLog(typing_extensions.TypedDict, total=False):
    dialogTriggered: bool
    localMediaFocus: AssistantLogsMediaFocusInfoLog
    mediaFocuses: _list[AssistantLogsMediaFocusInfoLog]
    nearbyMediaFocuses: _list[AssistantLogsMediaFocusInfoLog]

@typing.type_check_only
class AssistantLogsMediaStreamLog(typing_extensions.TypedDict, total=False):
    deviceIndex: _list[int]
    session: AssistantLogsDeviceMediaSessionLog

@typing.type_check_only
class AssistantLogsNearbyDevicesLog(typing_extensions.TypedDict, total=False):
    deviceArbitrationCreationTimestampMs: str
    deviceTargetingInputCreationTimestampMs: str
    eliminatedByFurtherDistance: int
    eliminatedByLocalClosest: int
    eliminatedByUnknownDifferentRoom: int
    eliminatedByUnregisteredDevice: int
    localDevice: AssistantLogsDeviceInfoLog
    nearbyDevices: _list[AssistantLogsDeviceInfoLog]
    numClosestDevices: int
    numEquallyCloseDevices: int
    numFurtherDevices: int
    numHearingDevices: int
    numUnknownDistanceDevices: int

@typing.type_check_only
class AssistantLogsProviderAnnotationLog(typing_extensions.TypedDict, total=False):
    lang: str
    localizedNames: _list[str]
    packageNames: _list[str]

@typing.type_check_only
class AssistantLogsQueryAnnotationLog(typing_extensions.TypedDict, total=False):
    deviceAnnotation: AssistantLogsDeviceAnnotationLog
    deviceAnnotations: _list[AssistantLogsDeviceAnnotationLog]
    providerAnnotation: AssistantLogsProviderAnnotationLog
    roomAnnotation: AssistantLogsRoomAnnotationLog
    roomAnnotations: _list[AssistantLogsRoomAnnotationLog]
    structureAnnotations: _list[AssistantLogsStructureAnnotationLog]

@typing.type_check_only
class AssistantLogsReminderLog(typing_extensions.TypedDict, total=False):
    createdSecondsAgo: str
    retrievedRankingClass: int

@typing.type_check_only
class AssistantLogsRoomAnnotationLog(typing_extensions.TypedDict, total=False):
    rawTextFromQuery: str
    roomCount: int
    type: typing_extensions.Literal[
        "NO_ROOM_ANNOTATION",
        "ROOM_ID_ANNOTATION",
        "ROOM_TYPE_ANNOTATION",
        "ROOM_TEXT_ANNOTATION",
    ]
    userDefinedName: str

@typing.type_check_only
class AssistantLogsSettingsDeviceIdLog(typing_extensions.TypedDict, total=False):
    agsaClientInstanceId: str
    canonicalDeviceId: str
    castDeviceId: str
    clientInstanceId: str
    homeGraphDeviceId: str
    libassistantDeviceId: str

@typing.type_check_only
class AssistantLogsStructureAnnotationLog(typing_extensions.TypedDict, total=False):
    rawTextFromQuery: str
    type: typing_extensions.Literal[
        "NO_STRUCTURE_ANNOTATION",
        "STRUCTURE_ID_ANNOTATION",
        "STRUCTURE_TEXT_ANNOTATION",
    ]
    userDefinedName: str

@typing.type_check_only
class AssistantLogsTargetDeviceLog(typing_extensions.TypedDict, total=False):
    devices: _list[AssistantLogsDeviceInfoLog]
    lowConfidenceReason: typing_extensions.Literal[
        "UNKNOWN_REASON",
        "LOCAL_FALLBACK",
        "MANUAL_DEFINED_REASON",
        "SINGLE_NEARBY_DEVICE",
        "PERSONAL_RESPONSE_BIT_OPTOUT_ON_LOCKED_PHONE",
        "FURTHER_LOCAL_DEVICE",
        "RESULT_FROM_DEFAULT_MEDIA_OUTPUT_PROMOTER",
    ]
    resultConfidenceLevel: typing_extensions.Literal[
        "UNKNOWN", "LOW_CONFIDENCE", "HIGH_CONFIDENCE"
    ]

@typing.type_check_only
class AssistantPfrDeviceRdMetadata(typing_extensions.TypedDict, total=False):
    deviceName: str
    deviceTypes: _list[str]
    effectiveArgSpanLength: float
    hasAmbiguousResolutions: bool
    hasResolvedDeviceId: bool
    roomName: str

@typing.type_check_only
class AssistantPfrSmartHomeIntentMetadata(typing_extensions.TypedDict, total=False):
    deviceRdMetadata: _list[AssistantPfrDeviceRdMetadata]
    intentName: str
    isExactMatch: bool
    isGrounded: bool

@typing.type_check_only
class AssistantPfrTiebreakingMetadata(typing_extensions.TypedDict, total=False):
    fingerprint: str
    sortedNameString: str

@typing.type_check_only
class AssistantPrefulfillmentRankerPrefulfillmentSignals(
    typing_extensions.TypedDict, total=False
):
    bindingSetAuis: float
    bindingSetInvalidReason: typing_extensions.Literal[
        "BINDING_SET_INVALID_REASON_UNKNOWN",
        "BINDING_SET_INVALID_REASON_PROVIDER_INFEASIBLE_FOR_INTENT",
    ]
    bindingSetPauis: float
    bindingSetValidity: typing_extensions.Literal[
        "BINDING_SET_VALIDITY_UNKNOWN",
        "BINDING_SET_VALIDITY_VALID",
        "BINDING_SET_VALIDITY_INVALID_RESOLUTIONS",
        "BINDING_SET_VALIDITY_INFEASIBLE_JOINT_GROUNDING",
    ]
    calibratedParsingScore: float
    deepMediaDominant: bool
    dominant: bool
    effectiveArgSpanLength: float
    fulfillableDominantMedia: bool
    generatedByLegacyAquaDomain: bool
    groundabilityScore: float
    groundingProviderFeatures: AssistantGroundingRankerGroundingProviderFeatures
    hasAnswerGroup: bool
    inQueryMaxEffectiveArgSpanLength: float
    intentName: str
    intentNameAuisScore: float
    intentNameAuisScoreExp: float
    intentNamePauis: float
    intentType: typing_extensions.Literal[
        "UNKNOWN_INTENT_TYPE",
        "PLAY_MEDIA_MUSIC",
        "PLAY_MEDIA_PODCAST",
        "FIND_MEDIA_TV_FALLBACK",
        "PLAY_MEDIA_VIDEO",
        "ALARMS_AND_TIMERS",
        "HEALTH_AND_FITNESS",
        "PLAY_MEDIA_RADIO",
        "PLAY_TVM",
    ]
    isDummyIntent: bool
    isFeasible: bool
    isFullyGrounded: bool
    isHighConfidencePodcastIntent: bool
    isMediaControlIntent: bool
    isNspIntent: bool
    isPlayGenericMusic: bool
    isPodcastGenericIntent: bool
    isPodcastIntent: bool
    isSageDisabledIntent: bool
    isSageInNageIntent: bool
    isSageIntent: bool
    isScoreBasedIntent: bool
    isTvmIntent: bool
    isValidSmarthomeIntent: bool
    isVideoIntent: bool
    kscorerRank: int
    laaFeatures: AssistantGroundingRankerLaaFeatures
    maskCandidateLevelFeatures: bool
    maxHgrScoreAcrossBindingSets: float
    nspRank: int
    numAlternativeHypothesis: float
    numConstraints: float
    numConstraintsSatisfied: float
    numGroundableArgs: float
    numGroundedArgs: float
    numVariables: float
    numVariablesGrounded: float
    parsingScoreMse8BucketId: int
    phase: typing_extensions.Literal[
        "QU_PHASE_UNSPECIFIED",
        "QU_PHASE_REQUEST",
        "QU_PHASE_QREWRITE",
        "QU_PHASE_QBT",
        "QU_PHASE_PROBE_QUERY",
        "QU_PHASE_MULTI_ACCOUNT",
        "QU_PHASE_CQBT",
        "QU_PHASE_QBT_RESOLUTION",
        "QU_PHASE_HIGH_PRECISION",
        "QU_PHASE_COMBINED_RBT_RESOLUTION",
        "QU_PHASE_ANALYZER_INPUT",
        "QU_PHASE_NAGE",
    ]
    platinumSource: bool
    pq2tVsAssistantIbstCosine: float
    pq2tVsIbstCosine: float
    predictedIntentConfidence: float
    rankerName: typing_extensions.Literal[
        "RANKER_NAME_UNSPECIFIED",
        "RANKER_NAME_GROUNDING_RANKER",
        "RANKER_NAME_GROUNDING_RANKER_V4",
    ]
    searchDispatch: typing_extensions.Literal[
        "UNKNOWN",
        "NONE",
        "BRIDGE_API",
        "FULFILL_INTENT",
        "EMIT_ONLY",
        "COUNTERFACTUAL_LOG_ONLY",
        "CAPACITY_ACCOUNTING",
    ]
    smarthomeIntentMetadata: AssistantPfrSmartHomeIntentMetadata
    subIntentType: typing_extensions.Literal[
        "SUB_INTENT_TYPE_UNKNOWN",
        "SUB_INTENT_TYPE_TV_FALLBACK_SEARCH_INTENT",
        "SUB_INTENT_TYPE_PODCAST",
        "SUB_INTENT_TYPE_MUSIC_INITIATION_INTENT",
        "SUB_INTENT_TYPE_PLAY_RADIO_INTENT",
        "SUB_INTENT_TYPE_PLAY_TVM_INTENT",
        "SUB_INTENT_TYPE_PLAY_VIDEO_INTENT",
        "SUB_INTENT_TYPE_BROWSE_VIDEO_INTENT",
    ]
    tiebreakingMetadata: AssistantPfrTiebreakingMetadata
    topHypothesisConfidence: float
    usesGroundingBox: bool
    verticalConfidenceScore: float

@typing.type_check_only
class AssistantProductivityListItem(typing_extensions.TypedDict, total=False):
    name: str

@typing.type_check_only
class AssistantRemindersAttachment(typing_extensions.TypedDict, total=False):
    id: str
    link: AssistantRemindersAttachmentLink
    surfaceType: _list[typing_extensions.Literal["UNSPECIFIED", "ANDROID_PHONE"]]

@typing.type_check_only
class AssistantRemindersAttachmentLink(typing_extensions.TypedDict, total=False):
    linkUrl: str
    notificationText: AssistantRemindersNlgTemplateKey

@typing.type_check_only
class AssistantRemindersMemoryPayload(typing_extensions.TypedDict, total=False):
    hasReferencedEntityAtCreation: bool
    recordId: str

@typing.type_check_only
class AssistantRemindersNlgTemplateKey(typing_extensions.TypedDict, total=False):
    messageSet: str
    templateName: str

@typing.type_check_only
class AssistantTeleportTeleportNicknameSignals(
    typing_extensions.TypedDict, total=False
):
    hasLocationInterpretation: bool
    installInfo: typing_extensions.Literal[
        "INSTALLATION_INFORMATION_UNAVAILABLE",
        "IS_INSTALLED_APP",
        "IS_NOT_INSTALLED_APP",
    ]
    isGeneric: bool
    nicknameTier: typing_extensions.Literal[
        "UNKNOWN", "UNRESTRICTED", "INTENT_REQUIRED", "APP_PHRASE_REQUIRED"
    ]
    source: typing_extensions.Literal["DEFAULT", "GELLER", "DEVICE_CAPABILITIES"]

@typing.type_check_only
class AssistantVerticalsCommonContactMatchSignal(
    typing_extensions.TypedDict, total=False
):
    matchScore: float

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoActionProjectConfig(
    typing_extensions.TypedDict, total=False
):
    contextId: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoAgentDeviceId(
    typing_extensions.TypedDict, total=False
):
    agentId: str
    deviceId: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoAgentInformation(
    typing_extensions.TypedDict, total=False
):
    authType: typing_extensions.Literal["OPEN_AUTH_DEFAULT", "NEST_AUTH_PROXY"]
    deviceSource: typing_extensions.Literal[
        "UNKNOWN", "CLOUD_SYNC", "ASSISTANT_SETTING_OOBE", "LOCAL_SYNC", "CHIP_SYNC"
    ]
    executionPath: typing_extensions.Literal["HARPOON_DEFAULT", "STUBBY"]
    id: str
    key: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoAttribute(
    typing_extensions.TypedDict, total=False
):
    structureBasedRoutine: AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutine

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoAttributes(
    typing_extensions.TypedDict, total=False
):
    attributeProtos: _list[AssistantVerticalsHomeautomationProtoAttribute]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoCommonEventTrigger(
    typing_extensions.TypedDict, total=False
):
    enabled: bool
    eventTriggerPayload: dict[str, typing.Any]
    eventTriggerType: typing_extensions.Literal[
        "UNKNOWN", "SCHEDULED", "LOCATION", "DEVICE_CONTROL", "DEVICE_SENSES"
    ]
    triggerSource: int

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutine(
    typing_extensions.TypedDict, total=False
):
    enabled: bool
    googlePreconfigWorkflowId: str
    language: str
    payload: dict[str, typing.Any]
    securityLevel: typing_extensions.Literal[
        "UNKNOWN", "ALLOW_UNVERIFIED", "ALLOW_VERIFIED"
    ]
    shared: bool
    storagePayload: dict[str, typing.Any]
    structureId: str
    triggers: _list[
        AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutineTrigger
    ]
    type: typing_extensions.Literal["UNDEFINED", "CURATED", "ALARM", "CUSTOM"]
    uiPayload: dict[str, typing.Any]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoCommonStructureBasedRoutineTrigger(
    typing_extensions.TypedDict, total=False
):
    eventTrigger: AssistantVerticalsHomeautomationProtoCommonEventTrigger
    voiceTrigger: AssistantVerticalsHomeautomationProtoCommonVoiceTrigger

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoCommonVoiceTrigger(
    typing_extensions.TypedDict, total=False
):
    query: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoConciergeFeatures(
    typing_extensions.TypedDict, total=False
):
    conciergeProductFeatures: _list[
        typing_extensions.Literal["UNKNOWN_PRODUCT_FEATURE", "E911"]
    ]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoDeviceTargetingOutputQueryInfo(
    typing_extensions.TypedDict, total=False
):
    annotatedSpanDevice: str
    annotatedSpanRoom: str
    annotatedSpanStructure: str
    processedMentionedSpan: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoHomeAutomationDevice(
    typing_extensions.TypedDict, total=False
):
    deviceSelectionLog: AssistantLogsDeviceSelectionLog
    dtoError: AssistantDeviceTargetingDeviceTargetingError
    dtoQueryInfo: AssistantVerticalsHomeautomationProtoDeviceTargetingOutputQueryInfo
    homeautomationMetadata: AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData
    list: _list[AssistantVerticalsHomeautomationProtoHomeAutomationDeviceItem]
    matchedItemKey: str
    matchedItemRawvalue: str
    matchedItemValue: _list[str]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoHomeAutomationDeviceItem(
    typing_extensions.TypedDict, total=False
):
    homeautomationMetadata: AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData
    matchedItemKey: str
    matchedItemRawvalue: str
    matchedItemValue: _list[str]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoHomeAutomation_MetaData(
    typing_extensions.TypedDict, total=False
):
    actionProjectConfigs: _list[
        AssistantVerticalsHomeautomationProtoActionProjectConfig
    ]
    agentInformation: AssistantVerticalsHomeautomationProtoAgentInformation
    assistantDeviceId: str
    attributes: dict[str, typing.Any]
    creatorGaiaId: str
    derivedType: _list[str]
    deviceModelId: str
    gcmExecutionAddress: str
    groupIds: _list[str]
    hashValue: str
    lanscanOptedIn: bool
    matterUniqueId: AssistantVerticalsHomeautomationProtoMatterUniqueId
    modelName: str
    notificationEnabledByUser: bool
    notificationSupportedByAgent: bool
    opaqueCustomData: str
    operationalNodeId: str
    otherDeviceIds: _list[AssistantVerticalsHomeautomationProtoAgentDeviceId]
    otherDeviceSources: _list[
        typing_extensions.Literal[
            "UNKNOWN", "CLOUD_SYNC", "ASSISTANT_SETTING_OOBE", "LOCAL_SYNC", "CHIP_SYNC"
        ]
    ]
    parentNode: _list[str]
    parentType: _list[
        typing_extensions.Literal[
            "UNKNOWN_ITEM_TYPE",
            "DEVICE",
            "ROOM",
            "PLACE",
            "GROUP",
            "SCENE",
            "STRUCTURE",
        ]
    ]
    personalizedNicknames: _list[str]
    physicalLocation: AssistantVerticalsHomeautomationProtoPhysicalLocation
    plural: _list[str]
    primaryName: str
    reportStateStatus: typing_extensions.Literal[
        "RSS_UNSPECIFIED", "RSS_IN_SYNC", "RSS_OUT_OF_SYNC"
    ]
    roleInformation: AssistantVerticalsHomeautomationProtoRoleInformation
    routableViaGcm: bool
    saftDocument: NlpSaftDocument
    smartDeviceManagementData: AssistantVerticalsHomeautomationProtoSmartDeviceManagementData
    smartHomeFeatures: AssistantVerticalsHomeautomationProtoSmartHomeFeatures
    supportedStructureFeatures: AssistantVerticalsHomeautomationProtoSupportedStructureFeatures
    supportedTraitsByAgent: dict[str, typing.Any]
    supportsDirectResponse: bool
    targetDeviceSignalStrengths: dict[str, typing.Any]
    tdssUpdateTimestamp: str
    traitRoutingHints: _list[HomeGraphCommonTraitRoutingHints]
    traitRoutingTable: dict[str, typing.Any]
    traitToAttributeProtos: dict[str, typing.Any]
    type: str
    userDefinedDeviceType: str
    voiceMatchRequired: typing_extensions.Literal["ANY", "OWNER", "MEMBER"]
    willReportState: bool
    zoneNameSaftDocument: NlpSaftDocument

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoHomeAutomation_MetaDataSupportedTraits(
    typing_extensions.TypedDict, total=False
):
    traits: _list[str]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoMatterUniqueId(
    typing_extensions.TypedDict, total=False
):
    productId: int
    uniqueId: str
    vendorId: int

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoPhysicalLocation(
    typing_extensions.TypedDict, total=False
):
    address: str
    geoLocation: GoogleTypeLatLng

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoRoleInformation(
    typing_extensions.TypedDict, total=False
):
    iamCheckRequired: bool
    roleType: typing_extensions.Literal[
        "UNDEFINED", "ASSISTANT_ONLY", "CAST_LEGACY_LINKED", "MANAGER"
    ]

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoSmartDeviceManagementData(
    typing_extensions.TypedDict, total=False
):
    enterpriseId: str

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoSmartHomeFeatures(
    typing_extensions.TypedDict, total=False
):
    circadianLightingEnabled: bool
    energySavingsEnabled: bool
    gentleWakeupEnabled: bool
    homeAwayOverMatterEnabled: bool

@typing.type_check_only
class AssistantVerticalsHomeautomationProtoSupportedStructureFeatures(
    typing_extensions.TypedDict, total=False
):
    conciergeFeatures: AssistantVerticalsHomeautomationProtoConciergeFeatures

@typing.type_check_only
class AttentionalEntitiesMentionProperties(typing_extensions.TypedDict, total=False):
    deviceId: AssistantApiCoreTypesDeviceId
    eventId: EventIdMessage
    factoidScore: float
    listEntryInfo: AttentionalEntitiesMentionPropertiesListEntryInfo
    recency: typing_extensions.Literal["RECENCY_UNSPECIFIED", "MOST_RECENT_TURN"]
    role: AttentionalEntitiesSemanticRoleId
    salience: typing_extensions.Literal["UNKNOWN_SALIENCE", "PRIMARY", "METADATA"]
    source: AttentionalEntitiesMentionPropertiesSource
    spatialProperties: AttentionalEntitiesSpatialProperties
    surfaceForm: AttentionalEntitiesSurfaceForm
    timestamp: str

@typing.type_check_only
class AttentionalEntitiesMentionPropertiesListEntryInfo(
    typing_extensions.TypedDict, total=False
):
    index: str
    lexicalGroundingsId: str

@typing.type_check_only
class AttentionalEntitiesMentionPropertiesSource(
    typing_extensions.TypedDict, total=False
):
    client: AttentionalEntitiesMentionPropertiesSourceClient
    system: AttentionalEntitiesMentionPropertiesSourceSystem
    user: AttentionalEntitiesMentionPropertiesSourceUser

@typing.type_check_only
class AttentionalEntitiesMentionPropertiesSourceClient(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AttentionalEntitiesMentionPropertiesSourceSystem(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AttentionalEntitiesMentionPropertiesSourceUser(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class AttentionalEntitiesSemanticRoleId(typing_extensions.TypedDict, total=False):
    intentId: str
    roleId: str

@typing.type_check_only
class AttentionalEntitiesSpatialProperties(typing_extensions.TypedDict, total=False):
    visibility: typing_extensions.Literal["UNKNOWN_VISIBILITY", "VISIBLE", "HIDDEN"]

@typing.type_check_only
class AttentionalEntitiesSurfaceForm(typing_extensions.TypedDict, total=False):
    text: str

@typing.type_check_only
class BiasingPerDocData(typing_extensions.TypedDict, total=False):
    biasingfield: _list[BiasingPerDocDataBiasingField]

@typing.type_check_only
class BiasingPerDocData2(typing_extensions.TypedDict, total=False):
    biasingField: _list[BiasingPerDocData2BiasingField]

@typing.type_check_only
class BiasingPerDocData2BiasingField(typing_extensions.TypedDict, total=False):
    compressedName: int
    value: float
    valueFloat: int
    valueInt: int

@typing.type_check_only
class BiasingPerDocDataBiasingField(typing_extensions.TypedDict, total=False):
    Name: str
    Value: float

@typing.type_check_only
class BlobstoreBlobRef(typing_extensions.TypedDict, total=False):
    BlobID: str
    Options: str
    RefID: str
    ShardBin: int
    Size: str
    SourceV2BlobID: str
    V2ReadBlobToken: str

@typing.type_check_only
class BlogPerDocData(typing_extensions.TypedDict, total=False):
    blogurlFp: str
    clientSpamminess: int
    convTree: BlogsearchConversationTree
    copycatScore: int
    docQualityScore: int
    isSyntacticReshare: bool
    microblogQualityExptData: Proto2BridgeMessageSet
    numMentions: int
    outlinks: _list[BlogPerDocDataOutlinks]
    postContentFingerprint: int
    qualityScore: int
    spamScore: int
    universalWhitelisted: bool
    userQualityScore: int

@typing.type_check_only
class BlogPerDocDataOutlinks(typing_extensions.TypedDict, total=False):
    aggregationFp: str
    resolvedUrl: str
    siteSpamScore: int
    title: str

@typing.type_check_only
class BlogsearchConversationNode(typing_extensions.TypedDict, total=False):
    authorName: str
    children: _list[str]
    date: str
    docid: str
    parent: str

@typing.type_check_only
class BlogsearchConversationTree(typing_extensions.TypedDict, total=False):
    convId: str
    nodes: _list[BlogsearchConversationNode]

@typing.type_check_only
class BlueGingerClientVisibleProtoBlueGingerSupportedServices(
    typing_extensions.TypedDict, total=False
):
    modules: _list[
        BlueGingerClientVisibleProtoBlueGingerSupportedServicesBlueGingerModule
    ]

@typing.type_check_only
class BlueGingerClientVisibleProtoBlueGingerSupportedServicesBlueGingerModule(
    typing_extensions.TypedDict, total=False
):
    name: str
    services: _list[str]
    useCase: typing_extensions.Literal[
        "UNKNOWN_USE_CASE",
        "OPENING_HOURS",
        "ON_DEMAND_OPENING_HOURS",
        "GEO_DATA_EXTRACTION",
        "OPERATING_MODE_EXTRACTION",
        "RESTAURANT_RESERVATION",
        "MASSAGE_RESERVATION",
        "HAIRDRESSER_RESERVATION",
        "NAIL_SALON_RESERVATION",
        "RUNNING_LATE",
        "FOOD_ORDERING",
        "LOCAL_INVENTORY_CHECK",
        "ON_DEMAND_LOCAL_INVENTORY",
        "WAITLIST",
        "CHECK_WAIT",
        "CHEFBOT",
        "ADS_CALL_CENTER_AUTHENTICATION",
        "PLAYSTORE",
        "TAKING_RESTAURANT_RESERVATIONS",
        "CALL_CENTER_DEMO",
        "ASSISTED_CALL_DEMO",
        "BUSINESS_OPT_IN",
        "CALLJOY_PILOT",
        "ASSISTANT_REMINDERS_DEMO",
        "HAPPY_BIRTHDAY",
        "ASSISTED_IVR",
        "DUPLEX_FOR_BUSINESS_PILOT",
        "SAY_THE_SAME_THING",
        "COVID_FAQ",
        "VANCOUVER",
        "MEENAPLEX",
        "REMOVED_USE_CASE_6",
        "SEMI_DELEGATED_CALLING",
        "HARDWARE_SETUP",
        "DUMDA_BOT",
        "SMART_REPLY",
        "DUPLEX_ZERO",
        "SPAM_FILTER",
        "TEXT",
        "IVR_CRAWLING",
        "VOICEMAIL",
        "INBOUND_SMB",
        "CCAI_DEMO",
        "DIALOGFLOW_DELEGATION",
        "AD_LEAD_VERIFICATION",
        "GET_HUMAN",
        "CHECK_INSURANCE_ACCEPTANCE",
        "FREE_TEXT",
        "SMART_NOTES",
    ]

@typing.type_check_only
class BookCitationPerDocData(typing_extensions.TypedDict, total=False):
    bookId: str
    discretizedCitationScore: int
    previewable: bool
    secondBookId: str
    secondDiscretizedCitationScore: int

@typing.type_check_only
class BusinessHours(typing_extensions.TypedDict, total=False):
    dayopen: int
    interval: _list[BusinessHoursInterval]

@typing.type_check_only
class BusinessHoursInterval(typing_extensions.TypedDict, total=False):
    end: int
    start: int

@typing.type_check_only
class ChatBotPlatformBotSendToken(typing_extensions.TypedDict, total=False):
    expiryTimeMicros: str
    sendToken: str

@typing.type_check_only
class ChatBotPlatformFireballId(typing_extensions.TypedDict, total=False):
    id: GoogleInternalCommunicationsInstantmessagingV1Id

@typing.type_check_only
class ClassifierPornClassifierData(typing_extensions.TypedDict, total=False):
    classification: _list[ClassifierPornClassifierDataClassification]
    imageBasedDetectionDone: bool
    timestamp: str

@typing.type_check_only
class ClassifierPornClassifierDataClassification(
    typing_extensions.TypedDict, total=False
):
    label: str
    score: float

@typing.type_check_only
class ClassifierPornDocumentData(typing_extensions.TypedDict, total=False):
    classifierdata: ClassifierPornClassifierData
    sitedata: ClassifierPornSiteData

@typing.type_check_only
class ClassifierPornQueryClassifierOutput(typing_extensions.TypedDict, total=False):
    csaiClassification: typing_extensions.Literal[
        "NOT_PROTECTED", "PROTECTED", "STRONGLY_PROTECTED"
    ]
    debug: str
    isPositive: bool
    score: float

@typing.type_check_only
class ClassifierPornQueryMultiLabelClassifierOutput(
    typing_extensions.TypedDict, total=False
):
    csai: ClassifierPornQueryClassifierOutput
    fringe: ClassifierPornQueryClassifierOutput
    medical: ClassifierPornQueryClassifierOutput
    minor: ClassifierPornQueryClassifierOutput
    offensive: ClassifierPornQueryClassifierOutput
    porn: ClassifierPornQueryClassifierOutput
    spoof: ClassifierPornQueryClassifierOutput
    violence: ClassifierPornQueryClassifierOutput
    vulgar: ClassifierPornQueryClassifierOutput

@typing.type_check_only
class ClassifierPornQueryStats(typing_extensions.TypedDict, total=False):
    queryTextPornScore: float
    totalClicks: float

@typing.type_check_only
class ClassifierPornReferrerCounts(typing_extensions.TypedDict, total=False):
    adult: int
    porn: int
    total: int

@typing.type_check_only
class ClassifierPornSiteData(typing_extensions.TypedDict, total=False):
    avgPedoPageScore: float
    finalPedoSiteScore: float
    numberOfPages: str
    numberOfPedoPages: str
    site: str
    sitePornRatio: float
    siteSoftpornRatio: float
    versionedscore: _list[ClassifierPornSiteDataVersionedScore]
    violenceScore: float
    violenceStats: ClassifierPornSiteViolenceStats

@typing.type_check_only
class ClassifierPornSiteDataVersionedScore(typing_extensions.TypedDict, total=False):
    score: float
    siteRule: _list[
        typing_extensions.Literal[
            "HIGH_PORN_FRACTION_RULE",
            "DEPRECATED_USER_GENERATED_CONTENT_RULE",
            "DEPRECATED_SITES_WITH_IGNORED_SCORES_LIST",
        ]
    ]
    version: int
    verticals4Score: float

@typing.type_check_only
class ClassifierPornSiteViolenceStats(typing_extensions.TypedDict, total=False):
    meanFinalViolenceScore: float
    numberOfImages: str
    numberOfVideos: str
    videoViolenceScore: float

@typing.type_check_only
class CloudAiPlatformTenantresourceCloudSqlInstanceConfig(
    typing_extensions.TypedDict, total=False
):
    cloudSqlInstanceConnectionName: str
    cloudSqlInstanceName: str
    kmsKeyReference: str
    mdbRolesForCorpAccess: _list[str]
    slmInstanceName: str
    slmInstanceTemplate: str
    slmInstanceType: str

@typing.type_check_only
class CloudAiPlatformTenantresourceGcsBucketConfig(
    typing_extensions.TypedDict, total=False
):
    admins: _list[str]
    bucketName: str
    entityName: str
    kmsKeyReference: str
    ttlDays: int
    viewers: _list[str]

@typing.type_check_only
class CloudAiPlatformTenantresourceIamPolicyBinding(
    typing_extensions.TypedDict, total=False
):
    members: _list[str]
    resource: str
    resourceType: typing_extensions.Literal[
        "RESOURCE_TYPE_UNSPECIFIED",
        "PROJECT",
        "SERVICE_ACCOUNT",
        "GCS_BUCKET",
        "SERVICE_CONSUMER",
        "AR_REPO",
    ]
    role: str

@typing.type_check_only
class CloudAiPlatformTenantresourceInfraSpannerConfig(
    typing_extensions.TypedDict, total=False
):
    createDatabaseOptions: CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions
    kmsKeyReference: str
    sdlBundlePath: str
    spannerBorgServiceAccount: str
    spannerLocalNamePrefix: str
    spannerNamespace: str
    spannerUniverse: str

@typing.type_check_only
class CloudAiPlatformTenantresourceInfraSpannerConfigCreateDatabaseOptions(
    typing_extensions.TypedDict, total=False
):
    cmekCloudResourceName: str
    cmekCloudResourceType: str
    cmekServiceName: str

@typing.type_check_only
class CloudAiPlatformTenantresourceServiceAccountIdentity(
    typing_extensions.TypedDict, total=False
):
    serviceAccountEmail: str
    tag: str

@typing.type_check_only
class CloudAiPlatformTenantresourceTenantProjectConfig(
    typing_extensions.TypedDict, total=False
):
    billingConfig: GoogleApiServiceconsumermanagementV1BillingConfig
    folder: str
    policyBindings: _list[GoogleApiServiceconsumermanagementV1PolicyBinding]
    services: _list[str]

@typing.type_check_only
class CloudAiPlatformTenantresourceTenantProjectResource(
    typing_extensions.TypedDict, total=False
):
    cloudSqlInstances: _list[CloudAiPlatformTenantresourceCloudSqlInstanceConfig]
    gcsBuckets: _list[CloudAiPlatformTenantresourceGcsBucketConfig]
    iamPolicyBindings: _list[CloudAiPlatformTenantresourceIamPolicyBinding]
    infraSpannerConfigs: _list[CloudAiPlatformTenantresourceInfraSpannerConfig]
    tag: str
    tenantProjectConfig: CloudAiPlatformTenantresourceTenantProjectConfig
    tenantProjectId: str
    tenantProjectNumber: str
    tenantServiceAccounts: _list[
        CloudAiPlatformTenantresourceTenantServiceAccountIdentity
    ]

@typing.type_check_only
class CloudAiPlatformTenantresourceTenantResource(
    typing_extensions.TypedDict, total=False
):
    p4ServiceAccounts: _list[CloudAiPlatformTenantresourceServiceAccountIdentity]
    tenantProjectResources: _list[CloudAiPlatformTenantresourceTenantProjectResource]

@typing.type_check_only
class CloudAiPlatformTenantresourceTenantServiceAccountIdentity(
    typing_extensions.TypedDict, total=False
):
    serviceAccountEmail: str
    serviceName: str

@typing.type_check_only
class CommerceDatastoreDeepTag(typing_extensions.TypedDict, total=False):
    confidence: int
    tag: int

@typing.type_check_only
class CommerceDatastoreImageDeepTags(typing_extensions.TypedDict, total=False):
    modelOutputs: _list[CommerceDatastoreImageDeepTagsModelOutput]

@typing.type_check_only
class CommerceDatastoreImageDeepTagsModelOutput(
    typing_extensions.TypedDict, total=False
):
    backgroundType: CommerceDatastoreDeepTag
    collage: CommerceDatastoreDeepTag
    cropping: CommerceDatastoreDeepTag
    modelType: CommerceDatastoreDeepTag
    nfs: CommerceDatastoreDeepTag
    objectCount: CommerceDatastoreDeepTag
    overlay: CommerceDatastoreDeepTag
    selfie: CommerceDatastoreDeepTag
    textOverlay: _list[CommerceDatastoreDeepTag]
    version: int

@typing.type_check_only
class CompositeDoc(typing_extensions.TypedDict, total=False):
    ContentChecksum96: str
    accessRequirements: IndexingPrivacyAccessAccessRequirements
    additionalchecksums: CompositeDocAdditionalChecksums
    alternatename: _list[CompositeDocAlternateName]
    anchorStats: IndexingDocjoinerAnchorStatistics
    anchors: Anchors
    badSslCertificate: IndexingBadSSLCertificate
    cseId: _list[QualityProseCSEUrlInfo]
    csePagerankCutoff: int
    dataVersion: IndexingDocjoinerDataVersion
    doc: GDocumentBase
    docAttachments: Proto2BridgeMessageSet
    docImages: _list[ImageData]
    docVideos: _list[ImageRepositoryVideoProperties]
    docinfoPassthroughAttachments: Proto2BridgeMessageSet
    embeddedContentInfo: IndexingEmbeddedContentEmbeddedContentInfo
    extradup: _list[CompositeDocExtraDup]
    forwardingdup: _list[CompositeDocForwardingDup]
    includedcontent: _list[CompositeDocIncludedContent]
    indexingIntermediate: str
    indexinginfo: CompositeDocIndexingInfo
    labelData: QualityLabelsGoogleLabelData
    liveexperimentinfo: CompositeDocLiveExperimentInfo
    localinfo: LocalWWWInfo
    localizedAlternateName: _list[IndexingConverterLocalizedAlternateName]
    localizedvariations: CompositeDocLocalizedVariations
    partialUpdateInfo: CompositeDocPartialUpdateInfo
    perDocData: PerDocData
    porninfo: ClassifierPornDocumentData
    properties: DocProperties
    ptoken: PtokenPToken
    qualitysignals: CompositeDocQualitySignals
    registrationinfo: RegistrationInfo
    richcontentData: IndexingConverterRichContentData
    richsnippet: RichsnippetsPageMap
    robotsinfolist: CompositeDocRobotsInfoList
    scaledIndyRank: int
    sitemap: Sitemap
    storageRowTimestampMicros: str
    subindexid: _list[
        typing_extensions.Literal[
            "LTG_CANDIDATE",
            "NOSUBINDEX",
            "BASE",
            "CSEINDEX_EXTENDED",
            "DAILY",
            "TIMBIT_PROTECTED",
            "LANDFILL1",
            "LANDFILL2",
            "LANDFILL3",
            "LANDFILL_BLOGSEARCH",
            "LANDFILL_SOCIAL",
            "INSTANT",
            "UNIFIED_LANDFILL",
            "BLOGSEARCH_DYNAMIC_ASSIMILATED",
            "BLOGSEARCH_EXTENDED",
            "MOFFETT",
            "UNSELECTED_DOCUMENTS",
            "AQUARIUS",
            "WEBSEARCH_FRESH",
            "WEBSEARCH1",
            "WEBSEARCH2",
            "WEBSEARCH3",
            "UNIFIED_ZEPPELIN_HIGH_QUALITY",
            "ASIANREGIONAL",
            "EMEAREGIONAL",
            "CSEINDEX",
            "BASEREGIONAL",
            "BLACKHOLE",
            "XBASE",
            "FRESHBASE",
            "XASIANREGIONAL",
            "XEMEAREGIONAL",
            "XBASEREGIONAL",
            "BLIMPIE",
            "BLIMPIEPP",
            "GOODYEAR",
            "GOODYEARPP",
            "QUASAR",
            "ZEPPELIN1",
            "ZEPPELIN2",
            "ZEPPELIN3",
            "ZEPPELIN_STAGING",
            "PULSAR",
            "TIMBIT",
            "LANDFILL_CSE",
            "UNIFIED_ZEPPELIN",
        ]
    ]
    syntacticDate: QualityTimebasedSyntacticDate
    url: str
    urldate: str

@typing.type_check_only
class CompositeDocAdditionalChecksums(typing_extensions.TypedDict, total=False):
    NoTransientChecksum96: str
    SimHash: str
    SimHashIsTrusted: bool
    simhashV2: str
    simhashV2Significance: float

@typing.type_check_only
class CompositeDocAlternateName(typing_extensions.TypedDict, total=False):
    Url: str
    UrlEncoding: int
    ecnFp: str

@typing.type_check_only
class CompositeDocExtraDup(typing_extensions.TypedDict, total=False):
    ecnFp: str
    url: str

@typing.type_check_only
class CompositeDocForwardingDup(typing_extensions.TypedDict, total=False):
    ecn: str
    ecnFp: str
    purposes: int
    rawPagerank: int
    repid: str
    url: str
    urlencoding: int

@typing.type_check_only
class CompositeDocIncludedContent(typing_extensions.TypedDict, total=False):
    SourceTypeBitfield: str
    includedDoc: GDocumentBase
    linkUrl: str
    perDocData: PerDocData
    properties: DocProperties

@typing.type_check_only
class CompositeDocIndexingInfo(typing_extensions.TypedDict, total=False):
    cdocBuildInfo: IndexingDocjoinerCDocBuildInfo
    contentProtected: bool
    convertToRobotedReason: int
    crawlStatus: int
    demotionTags: _list[
        typing_extensions.Literal["DEMOTION_TYPE_NONE", "DEMOTION_TYPE_BADURLS_DEMOTE"]
    ]
    errorType: int
    freshdocsCorpora: _list[
        typing_extensions.Literal[
            "WEB",
            "REALTIME",
            "CSE",
            "CSE_PREMIUM",
            "BUSTER_IMAGES",
            "NEWS",
            "VIDEO",
            "YOUTUBE",
            "WEB_INSTANT",
            "WEB_DAILY",
            "CACHE_COLON",
        ]
    ]
    hostid: str
    ieIdentifier: str
    imageIndexingInfo: ImageSearchImageIndexingInfo
    indexingTs: str
    noLongerCanonicalTimestamp: str
    normalizedClickScore: float
    primaryVertical: str
    rawNavboost: int
    rowTimestamp: str
    selectionTierRank: float
    tracingId: _list[str]
    urlChangerate: CrawlerChangerateUrlChangerate
    urlHistory: CrawlerChangerateUrlHistory
    urlPatternSignals: IndexingSignalAggregatorUrlPatternSignals
    verticals: _list[str]
    videoIndexingInfo: ImageRepositoryVideoIndexingInfo

@typing.type_check_only
class CompositeDocLiveExperimentInfo(typing_extensions.TypedDict, total=False):
    perLiveExperimentInfo: _list[CompositeDocLiveExperimentInfoPerLiveExperimentInfo]

@typing.type_check_only
class CompositeDocLiveExperimentInfoPerLiveExperimentInfo(
    typing_extensions.TypedDict, total=False
):
    experimentId: str
    partialCdoc: CompositeDoc

@typing.type_check_only
class CompositeDocLocalizedVariations(typing_extensions.TypedDict, total=False):
    dupsComputedAlternateNames: _list[
        IndexingDupsComputedLocalizedAlternateNamesLocaleEntry
    ]
    webmasterAlternateNames: _list[IndexingConverterLocalizedAlternateName]

@typing.type_check_only
class CompositeDocPartialUpdateInfo(typing_extensions.TypedDict, total=False):
    goldmineAnnotatorNames: _list[str]
    imagesSignalNames: _list[str]
    lastFullIndexingInfo: _list[CompositeDocPartialUpdateInfoLastFullIndexingInfo]
    shouldLookupDocjoinsTier: int
    signalNames: _list[str]

@typing.type_check_only
class CompositeDocPartialUpdateInfoLastFullIndexingInfo(
    typing_extensions.TypedDict, total=False
):
    corpus: typing_extensions.Literal[
        "RAFFIA_WEBSEARCH",
        "RAFFIA_FASTPATH_DAILY",
        "RAFFIA_FASTPATH_INSTANT",
        "DOCJOINS",
    ]
    lastFullIndexingTsMicros: str

@typing.type_check_only
class CompositeDocQualitySignals(typing_extensions.TypedDict, total=False):
    lastSignificantUpdate: QualityTimebasedLastSignificantUpdate
    pagetype: QualityTimebasedPageType

@typing.type_check_only
class CompositeDocRobotsInfoList(typing_extensions.TypedDict, total=False):
    newsRobotsInfo: IndexingConverterRobotsInfo

@typing.type_check_only
class CompressedQualitySignals(typing_extensions.TypedDict, total=False):
    anchorMismatchDemotion: int
    authorityPromotion: int
    babyPandaDemotion: int
    babyPandaV2Demotion: int
    crapsAbsoluteHostSignals: int
    crapsNewHostSignals: str
    crapsNewPatternSignals: str
    crapsNewUrlSignals: str
    crapsUnscaledIpPriorBadFraction: int
    exactMatchDomainDemotion: int
    experimentalNsrTeamData: QualityNsrExperimentalNsrTeamData
    experimentalNsrTeamWsjData: _list[QualityNsrExperimentalNsrTeamWSJData]
    experimentalQstarDeltaSignal: float
    experimentalQstarSignal: float
    experimentalQstarSiteSignal: float
    lowQuality: int
    navDemotion: int
    nsrConfidence: int
    nsrOverrideBid: float
    nsrVersionedData: _list[NSRVersionedItem]
    pairwiseqScoringData: PairwiseQScoringData
    pairwiseqVersionedData: _list[PairwiseQVersionedItem]
    pandaDemotion: int
    pqData: int
    pqDataProto: QualityNsrPQData
    productReviewPDemotePage: int
    productReviewPDemoteSite: int
    productReviewPPromotePage: int
    productReviewPPromoteSite: int
    productReviewPReviewPage: int
    productReviewPUhqPage: int
    scamness: int
    serpDemotion: int
    siteAuthority: int
    topicEmbeddingsVersionedData: _list[QualityAuthorityTopicEmbeddingsVersionedItem]
    unauthoritativeScore: int
    vlqNsr: int

@typing.type_check_only
class ConceptsConceptId(typing_extensions.TypedDict, total=False):
    conceptId: str
    id: str

@typing.type_check_only
class ContentAttributions(typing_extensions.TypedDict, total=False):
    freshdocsOutgoing: _list[ContentAttributionsOutgoingAttribution]
    offlineOutgoing: _list[ContentAttributionsOutgoingAttribution]
    onlineOutgoing: _list[ContentAttributionsOutgoingAttribution]

@typing.type_check_only
class ContentAttributionsOutgoingAttribution(typing_extensions.TypedDict, total=False):
    bestEvidenceType: typing_extensions.Literal[
        "PAGE_LINK_TO",
        "SITE_LINK_TO",
        "SITE_OTHER_PAGE_LINK_TO",
        "ORG_OTHER_SITE_LINK_TO",
        "ORG_OTHER_PAGE_LINK_TO",
        "SITE_SCORE_BASED",
        "LOW_CONFIDENCE_LINK_TO",
        "ANCHOR_ATTRIBUTION_TO",
        "SITE_NAME_MENTION",
        "SITE_NAME_MENTION_KEYWORDED",
        "EVIDENCE_TYPE_END",
    ]
    docid: str
    properties: int
    usableForClustering: bool

@typing.type_check_only
class ContentAwareCropsIndexing(typing_extensions.TypedDict, total=False):
    mustangBytes: str
    mustangBytesVersion: int

@typing.type_check_only
class CopleyLexicalMetadata(typing_extensions.TypedDict, total=False):
    canonicalLexicalMid: str

@typing.type_check_only
class CopleyPersonalReference(typing_extensions.TypedDict, total=False):
    personalReferenceType: typing_extensions.Literal[
        "PERSONAL_UNKNOWN_REFERENCE",
        "PERSONAL_HOTEL_REFERENCE",
        "PERSONAL_HOTEL_BOOKING_AGENT_REFERENCE",
        "PERSONAL_RESTAURANT_REFERENCE",
        "PERSONAL_RESTAURANT_BOOKING_AGENT_REFERENCE",
        "PERSONAL_PARKING_REFERENCE",
        "PERSONAL_FLIGHT_REFERENCE",
        "PERSONAL_GENERIC_SOCIAL_EVENT_REFERENCE",
        "PERSONAL_CONCERT_REFERENCE",
        "PERSONAL_SPORTS_REFERENCE",
        "PERSONAL_MOVIE_REFERENCE",
        "PERSONAL_TOUR_REFERENCE",
        "PERSONAL_HOME_REFERENCE",
        "PERSONAL_WORK_REFERENCE",
        "PERSONAL_MAPS_ALIAS_REFERENCE",
        "PERSONAL_CONTACT_REFERENCE",
        "PERSONAL_CONTACT_PERSON_REFERENCE",
        "PERSONAL_CONTACT_LOCATION_REFERENCE",
        "PERSONAL_FAMILY_MEMBER_REFERENCE",
        "PERSONAL_CONTACT_BIRTHDAY_REFERENCE",
        "PERSONAL_CONTACT_ADDRESS_REFERENCE",
        "PERSONAL_RELATIONSHIP_REFERENCE",
        "PERSONAL_RELATIONSHIP_PERSON_REFERENCE",
        "PERSONAL_RELATIONSHIP_LOCATION_REFERENCE",
        "PERSONAL_MEMORABLE_DATE_REFERENCE",
        "PERSONAL_MEMORY_ANNIVERSARY_DATE_REFERENCE",
        "PERSONAL_MEMORY_PAYDAY_DATE_REFERENCE",
        "PERSONAL_MEMORY_WEDDING_DATE_REFERENCE",
        "PERSONAL_MEMORY_BIRTHDAY_DATE_REFERENCE",
        "PERSONAL_MEMORY_EXAM_DATE_REFERENCE",
        "PERSONAL_MEMORY_MATHEXAM_DATE_REFERENCE",
        "PERSONAL_MEMORY_OILCHANGE_DATE_REFERENCE",
        "PERSONAL_MEMORY_GRADUATION_DATE_REFERENCE",
    ]

@typing.type_check_only
class CopleyPersonalReferenceMetadata(typing_extensions.TypedDict, total=False):
    referenceScore: float
    references: _list[CopleyPersonalReference]
    subreferenceMetadata: CopleySubreferenceMetadata

@typing.type_check_only
class CopleySourceTypeList(typing_extensions.TypedDict, total=False):
    sourceTypeMetadata: _list[CopleySourceTypeMetadata]

@typing.type_check_only
class CopleySourceTypeMetadata(typing_extensions.TypedDict, total=False):
    contactAnnotationId: str
    displayableName: str
    emailIdentifier: str
    eventId: EventIdMessage
    localDiscoverySettingsMetadata: PersonalizationSettingsApiProtoLocalDiscoveryLocalDiscoverySettingsMetadata
    personalDataProvenance: typing_extensions.Literal[
        "PERSONAL_SOURCE_UNKNOWN",
        "PERSONAL_SOURCE_GMAIL",
        "PERSONAL_SOURCE_CALENDAR",
        "PERSONAL_SOURCE_MAPS_ALIAS",
        "PERSONAL_SOURCE_FOCUS",
        "PERSONAL_SOURCE_FOCUS_CONSISTENT",
        "PERSONAL_SOURCE_FOCUS_TOP_N_CONTACTS",
        "PERSONAL_SOURCE_ASSISTANT_CONTACT_AFFINITY",
        "PERSONAL_SOURCE_ASSISTANT_MEMORY",
        "PERSONAL_SOURCE_PWS",
        "PERSONAL_SOURCE_HOUSEHOLD",
        "PERSONAL_SOURCE_HULK_PLACES",
        "PERSONAL_SOURCE_FOCUS_OWNER",
        "PERSONAL_SOURCE_WHITEPAGES",
        "PERSONAL_SOURCE_ASSISTANT_DEVICES",
        "PERSONAL_SOURCE_TEACH_LEARN",
        "PERSONAL_SOURCE_GELLER_ANSWERS",
        "PERSONAL_SOURCE_LAMS_SETTINGS",
        "PERSONAL_SOURCE_GAIA",
        "PERSONAL_SOURCE_XTALK",
        "PERSONAL_SOURCE_MOVIE_DIALOG",
        "PERSONAL_SOURCE_MEDIA_HABITUAL_CACHE",
        "PERSONAL_SOURCE_PERSONAL_TOPICSERVER",
        "PERSONAL_SOURCE_PHOTO_LABELS",
        "PERSONAL_SOURCE_PEOPLE_API",
        "PERSONAL_SOURCE_CONTEXT_API",
        "PERSONAL_SOURCE_MUSIC_PREFERRED_PROVIDER",
        "PERSONAL_SOURCE_STASH",
        "PERSONAL_SOURCE_SMART_HOME_DEVICES",
        "PERSONAL_SOURCE_DEVICE_STATES",
        "PERSONAL_SOURCE_HANDBAG_PERSONALIZED_WEBREF_ENTITIES",
        "PERSONAL_GRAPH_PEOPLE_SIGNAL_POST_PROCESSING",
        "PERSONAL_SOURCE_PERSONALIZED_PRONUNCIATIONS",
        "PERSONAL_SOURCE_DEVICE_INSTALLED_APPS",
        "PERSONAL_SOURCE_CONTACT_AGGREGATED_DATA",
        "PERSONAL_SOURCE_DYNAMIC_ENTITY_INDEX",
        "PERSONAL_SOURCE_STADIA",
        "PERSONAL_SOURCE_COMMUNAL_GROUP",
        "PERSONAL_SOURCE_LOCATION_SHARING",
        "PERSONAL_SOURCE_MAPS_SEARCH",
        "PERSONAL_SOURCE_MEDIA_USER_CONTEXT_INFO",
        "PERSONAL_SOURCE_MEDIA_USER_ENTITIES",
        "PERSONAL_SOURCE_DEVICE_SIGNED_IN_ACCOUNTS",
        "PERSONAL_SOURCE_ASSISTANT_USER_PROFILES",
    ]
    personalDataType: typing_extensions.Literal[
        "PERSONAL_UNKNOWN",
        "PERSONAL_HOTEL",
        "PERSONAL_RESTAURANT",
        "PERSONAL_PARKING",
        "PERSONAL_FLIGHT",
        "PERSONAL_SOCIAL_EVENT",
        "PERSONAL_MAPS_ALIAS",
        "PERSONAL_CONTACT",
        "PERSONAL_PROFILE",
        "PERSONAL_BILL",
        "PERSONAL_CAR_RENTAL",
        "PERSONAL_GENERIC_EVENT",
        "PERSONAL_TRAIN",
        "PERSONAL_BUS",
        "PERSONAL_TAXI",
        "PERSONAL_FERRY",
        "PERSONAL_PHONE_NUMBER",
        "PERSONAL_DEVICE",
        "PERSONAL_PREFERENCE",
        "PERSONAL_DIETARY_RESTRICTION",
        "PERSONAL_MEDIA_HABITUAL_CACHE",
        "PERSONAL_NEWS_PREFERENCE",
        "PERSONAL_FAVORITE",
        "PERSONAL_GAMER_CONTACT",
    ]
    provenanceCategory: _list[
        typing_extensions.Literal["PROVENANCE_CATEGORY_UNKNOWN", "CORE_APPS_DATA"]
    ]
    sensitivity: KnowledgeAnswersSensitivitySensitivity

@typing.type_check_only
class CopleySubreferenceMetadata(typing_extensions.TypedDict, total=False):
    mostCompoundResolvedEntities: _list[CopleySubreferenceResolution]
    mostNestedUnresolvedReference: CopleySubreferenceReference

@typing.type_check_only
class CopleySubreferenceReference(typing_extensions.TypedDict, total=False):
    personalReferenceTypes: _list[
        typing_extensions.Literal[
            "PERSONAL_UNKNOWN_REFERENCE",
            "PERSONAL_HOTEL_REFERENCE",
            "PERSONAL_HOTEL_BOOKING_AGENT_REFERENCE",
            "PERSONAL_RESTAURANT_REFERENCE",
            "PERSONAL_RESTAURANT_BOOKING_AGENT_REFERENCE",
            "PERSONAL_PARKING_REFERENCE",
            "PERSONAL_FLIGHT_REFERENCE",
            "PERSONAL_GENERIC_SOCIAL_EVENT_REFERENCE",
            "PERSONAL_CONCERT_REFERENCE",
            "PERSONAL_SPORTS_REFERENCE",
            "PERSONAL_MOVIE_REFERENCE",
            "PERSONAL_TOUR_REFERENCE",
            "PERSONAL_HOME_REFERENCE",
            "PERSONAL_WORK_REFERENCE",
            "PERSONAL_MAPS_ALIAS_REFERENCE",
            "PERSONAL_CONTACT_REFERENCE",
            "PERSONAL_CONTACT_PERSON_REFERENCE",
            "PERSONAL_CONTACT_LOCATION_REFERENCE",
            "PERSONAL_FAMILY_MEMBER_REFERENCE",
            "PERSONAL_CONTACT_BIRTHDAY_REFERENCE",
            "PERSONAL_CONTACT_ADDRESS_REFERENCE",
            "PERSONAL_RELATIONSHIP_REFERENCE",
            "PERSONAL_RELATIONSHIP_PERSON_REFERENCE",
            "PERSONAL_RELATIONSHIP_LOCATION_REFERENCE",
            "PERSONAL_MEMORABLE_DATE_REFERENCE",
            "PERSONAL_MEMORY_ANNIVERSARY_DATE_REFERENCE",
            "PERSONAL_MEMORY_PAYDAY_DATE_REFERENCE",
            "PERSONAL_MEMORY_WEDDING_DATE_REFERENCE",
            "PERSONAL_MEMORY_BIRTHDAY_DATE_REFERENCE",
            "PERSONAL_MEMORY_EXAM_DATE_REFERENCE",
            "PERSONAL_MEMORY_MATHEXAM_DATE_REFERENCE",
            "PERSONAL_MEMORY_OILCHANGE_DATE_REFERENCE",
            "PERSONAL_MEMORY_GRADUATION_DATE_REFERENCE",
        ]
    ]
    referenceScore: float
    relationshipLexicalInfo: CopleyLexicalMetadata

@typing.type_check_only
class CopleySubreferenceResolution(typing_extensions.TypedDict, total=False):
    mid: str
    name: str
    resolutionScore: float

@typing.type_check_only
class CorpusSelectionInfo(typing_extensions.TypedDict, total=False):
    corpus: typing_extensions.Literal["UNKNOWN", "LENS"]
    corpusScore: float
    isSelectedForIndexing: bool
    referrerDocid: _list[str]
    referrerUrls: _list[str]

@typing.type_check_only
class CountryClickDistribution(typing_extensions.TypedDict, total=False):
    confidence: float
    item: _list[CountryClickDistributionItem]
    total: float

@typing.type_check_only
class CountryClickDistributionItem(typing_extensions.TypedDict, total=False):
    doubleValue: float
    name: str
    value: int

AlternativeCountryCountryAttachment = typing_extensions.TypedDict(
    "AlternativeCountryCountryAttachment",
    {
        "clickDistribution": CountryClickDistribution,
        "countryidFromUgc": bool,
        "debug": str,
        "debugSourceUrl": _list[str],
        "documentLocationSource": typing_extensions.Literal[
            "UNSPECIFIED", "DOCLOC", "BRAINLOC", "LOGLOC"
        ],
        "existNextLevel": bool,
        "fromLanguageFallback": bool,
        "fromRestricts": bool,
        "fromSgDomains": bool,
        "fromTld": bool,
        "fromUgc": bool,
        "fromUrlPattern": bool,
        "fromWmx": bool,
        "geoLocations": CountryGeoLocations,
        "global": bool,
        "isValidForCountryRestrict": bool,
        "localCountries": _list[str],
        "localCountryCodes": _list[int],
        "metroIdList": _list[CountryMetroNBFeature],
        "metroLocationId": _list[str],
        "metroNavboost": _list[CountryMetroNBFeature],
        "provinceGeotokenList": _list[CountryProvinceGeotoken],
        "relatedCountries": _list[str],
        "relatedCountryCodes": _list[int],
        "restrictCountries": _list[str],
        "salientCountries": _list[CountrySalientCountry],
        "salientCountrySet": QualitySalientCountriesSalientCountrySet,
        "sitename": str,
        "superGlobal": bool,
        "urlPatternBasedCountry": int,
        "urlPatternBasedLanguage": int,
        "userVisibleCountryFromLogs": str,
        "userVisibleLocalCountry": int,
        "weightAboveIdealForLocalness": float,
        "wmxCountry": str,
    },
    total=False,
)

@typing.type_check_only
class CountryCountryAttachment(AlternativeCountryCountryAttachment): ...

@typing.type_check_only
class CountryGeoLocation(typing_extensions.TypedDict, total=False):
    clickRadius50Percent: int
    confidence: float
    confidencePercent: int
    internalId: int
    locationInfo: CountryLocationInfo
    propagatedFromASubpage: bool

@typing.type_check_only
class CountryGeoLocations(typing_extensions.TypedDict, total=False):
    geoLocation: _list[CountryGeoLocation]
    isNonLocationSpecific: bool
    propagationDepthFromParent: int

@typing.type_check_only
class CountryLocationInfo(typing_extensions.TypedDict, total=False):
    center: GeostorePointProto
    city: str
    country: str
    county: str
    enclosingStateFeatureId: GeostoreFeatureIdProto
    featureId: GeostoreFeatureIdProto
    state: str
    stateIdFprint: int
    subLocality: str
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_TRANSPORTATION",
        "TYPE_ROUTE",
        "TYPE_DEPRECATED_HIGHWAY_DO_NOT_USE",
        "TYPE_HIGHWAY",
        "TYPE_HIGHWAY_1",
        "TYPE_HIGHWAY_2",
        "TYPE_HIGHWAY_3",
        "TYPE_HIGHWAY_4",
        "TYPE_HIGHWAY_5",
        "TYPE_HIGHWAY_6",
        "TYPE_HIGHWAY_7",
        "TYPE_HIGHWAY_8",
        "TYPE_HIGHWAY_9",
        "TYPE_BICYCLE_ROUTE",
        "TYPE_TRAIL",
        "TYPE_SEGMENT",
        "TYPE_ROAD",
        "TYPE_RAILWAY",
        "TYPE_STANDARD_TRACK",
        "TYPE_JR_TRACK",
        "TYPE_NARROW_TRACK",
        "TYPE_MONORAIL_TRACK",
        "TYPE_SUBWAY_TRACK",
        "TYPE_LIGHT_RAIL_TRACK",
        "TYPE_BROAD_TRACK",
        "TYPE_HIGH_SPEED_RAIL",
        "TYPE_TROLLEY_TRACK",
        "TYPE_FERRY",
        "TYPE_FERRY_BOAT",
        "TYPE_FERRY_TRAIN",
        "TYPE_VIRTUAL_SEGMENT",
        "TYPE_INTERSECTION",
        "TYPE_TRANSIT",
        "TYPE_TRANSIT_STATION",
        "TYPE_BUS_STATION",
        "TYPE_TRAMWAY_STATION",
        "TYPE_TRAIN_STATION",
        "TYPE_SUBWAY_STATION",
        "TYPE_FERRY_TERMINAL",
        "TYPE_AIRPORT",
        "TYPE_AIRPORT_CIVIL",
        "TYPE_AIRPORT_MILITARY",
        "TYPE_AIRPORT_MIXED",
        "TYPE_HELIPORT",
        "TYPE_SEAPLANE_BASE",
        "TYPE_AIRSTRIP",
        "TYPE_CABLE_CAR_STATION",
        "TYPE_GONDOLA_LIFT_STATION",
        "TYPE_FUNICULAR_STATION",
        "TYPE_SPECIAL_STATION",
        "TYPE_HORSE_CARRIAGE_STATION",
        "TYPE_MONORAIL_STATION",
        "TYPE_SEAPORT",
        "TYPE_TRANSIT_STOP",
        "TYPE_TRANSIT_TRIP",
        "TYPE_TRANSIT_DEPARTURE",
        "TYPE_TRANSIT_LEG",
        "TYPE_TRANSIT_LINE",
        "TYPE_TRANSIT_AGENCY_DEPRECATED_VALUE",
        "TYPE_TRANSIT_TRANSFER",
        "TYPE_SEGMENT_PATH",
        "TYPE_ROAD_SIGN",
        "TYPE_INTERSECTION_GROUP",
        "TYPE_PATHWAY",
        "TYPE_RESTRICTION_GROUP",
        "TYPE_TOLL_CLUSTER",
        "TYPE_POLITICAL",
        "TYPE_COUNTRY",
        "TYPE_ADMINISTRATIVE_AREA",
        "TYPE_ADMINISTRATIVE_AREA1",
        "TYPE_US_STATE",
        "TYPE_GB_COUNTRY",
        "TYPE_JP_TODOUFUKEN",
        "TYPE_ADMINISTRATIVE_AREA2",
        "TYPE_GB_FORMER_POSTAL_COUNTY",
        "TYPE_GB_TRADITIONAL_COUNTY",
        "TYPE_ADMINISTRATIVE_AREA3",
        "TYPE_ADMINISTRATIVE_AREA4",
        "TYPE_ADMINISTRATIVE_AREA5",
        "TYPE_ADMINISTRATIVE_AREA6",
        "TYPE_ADMINISTRATIVE_AREA7",
        "TYPE_ADMINISTRATIVE_AREA8",
        "TYPE_ADMINISTRATIVE_AREA9",
        "TYPE_COLLOQUIAL_AREA",
        "TYPE_RESERVATION",
        "TYPE_LOCALITY",
        "TYPE_GB_POST_TOWN",
        "TYPE_JP_GUN",
        "TYPE_JP_SHIKUCHOUSON",
        "TYPE_JP_SUB_SHIKUCHOUSON",
        "TYPE_COLLOQUIAL_CITY",
        "TYPE_SUBLOCALITY",
        "TYPE_US_BOROUGH",
        "TYPE_GB_DEPENDENT_LOCALITY",
        "TYPE_JP_OOAZA",
        "TYPE_JP_KOAZA",
        "TYPE_JP_GAIKU",
        "TYPE_GB_DOUBLE_DEPENDENT_LOCALITY",
        "TYPE_JP_CHIBAN",
        "TYPE_JP_EDABAN",
        "TYPE_SUBLOCALITY1",
        "TYPE_SUBLOCALITY2",
        "TYPE_SUBLOCALITY3",
        "TYPE_SUBLOCALITY4",
        "TYPE_SUBLOCALITY5",
        "TYPE_NEIGHBORHOOD",
        "TYPE_CONSTITUENCY",
        "TYPE_DESIGNATED_MARKET_AREA",
        "TYPE_SCHOOL_DISTRICT",
        "TYPE_LAND_PARCEL",
        "TYPE_DISPUTED_AREA",
        "TYPE_POLICE_JURISDICTION",
        "TYPE_STATISTICAL_AREA",
        "TYPE_CONSTITUENCY_FUTURE",
        "TYPE_PARK",
        "TYPE_GOLF_COURSE",
        "TYPE_LOCAL_PARK",
        "TYPE_NATIONAL_PARK",
        "TYPE_US_NATIONAL_PARK",
        "TYPE_US_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_FOREST",
        "TYPE_PROVINCIAL_PARK",
        "TYPE_PROVINCIAL_FOREST",
        "TYPE_CAMPGROUNDS",
        "TYPE_HIKING_AREA",
        "TYPE_BUSINESS",
        "TYPE_GOVERNMENT",
        "TYPE_BORDER_CROSSING",
        "TYPE_CITY_HALL",
        "TYPE_COURTHOUSE",
        "TYPE_EMBASSY",
        "TYPE_LIBRARY",
        "TYPE_SCHOOL",
        "TYPE_UNIVERSITY",
        "TYPE_EMERGENCY",
        "TYPE_HOSPITAL",
        "TYPE_PHARMACY",
        "TYPE_POLICE",
        "TYPE_FIRE",
        "TYPE_DOCTOR",
        "TYPE_DENTIST",
        "TYPE_VETERINARIAN",
        "TYPE_TRAVEL_SERVICE",
        "TYPE_LODGING",
        "TYPE_RESTAURANT",
        "TYPE_GAS_STATION",
        "TYPE_PARKING",
        "TYPE_POST_OFFICE",
        "TYPE_REST_AREA",
        "TYPE_CASH_MACHINE",
        "TYPE_CAR_RENTAL",
        "TYPE_CAR_REPAIR",
        "TYPE_SHOPPING",
        "TYPE_GROCERY",
        "TYPE_TOURIST_DESTINATION",
        "TYPE_ECO_TOURIST_DESTINATION",
        "TYPE_BIRD_WATCHING",
        "TYPE_FISHING",
        "TYPE_HUNTING",
        "TYPE_NATURE_RESERVE",
        "TYPE_TEMPLE",
        "TYPE_CHURCH",
        "TYPE_GURUDWARA",
        "TYPE_HINDU_TEMPLE",
        "TYPE_MOSQUE",
        "TYPE_SYNAGOGUE",
        "TYPE_STADIUM",
        "TYPE_BAR",
        "TYPE_MOVIE_RENTAL",
        "TYPE_COFFEE",
        "TYPE_GOLF",
        "TYPE_BANK",
        "TYPE_DOODLE",
        "TYPE_GROUNDS",
        "TYPE_AIRPORT_GROUNDS",
        "TYPE_BUILDING_GROUNDS",
        "TYPE_CEMETERY",
        "TYPE_HOSPITAL_GROUNDS",
        "TYPE_INDUSTRIAL",
        "TYPE_MILITARY",
        "TYPE_SHOPPING_CENTER",
        "TYPE_SPORTS_COMPLEX",
        "TYPE_UNIVERSITY_GROUNDS",
        "TYPE_DEPRECATED_TARMAC",
        "TYPE_ENCLOSED_TRAFFIC_AREA",
        "TYPE_PARKING_LOT",
        "TYPE_PARKING_GARAGE",
        "TYPE_OFF_ROAD_AREA",
        "TYPE_BORDER",
        "TYPE_BUILDING",
        "TYPE_GEOCODED_ADDRESS",
        "TYPE_NATURAL_FEATURE",
        "TYPE_TERRAIN",
        "TYPE_SAND",
        "TYPE_BEACH",
        "TYPE_DUNE",
        "TYPE_ROCKY",
        "TYPE_ICE",
        "TYPE_GLACIER",
        "TYPE_BUILT_UP_AREA",
        "TYPE_VEGETATION",
        "TYPE_SHRUBBERY",
        "TYPE_WOODS",
        "TYPE_AGRICULTURAL",
        "TYPE_GRASSLAND",
        "TYPE_TUNDRA",
        "TYPE_DESERT",
        "TYPE_SALT_FLAT",
        "TYPE_WATER",
        "TYPE_OCEAN",
        "TYPE_BAY",
        "TYPE_BIGHT",
        "TYPE_LAGOON",
        "TYPE_SEA",
        "TYPE_STRAIT",
        "TYPE_INLET",
        "TYPE_FJORD",
        "TYPE_LAKE",
        "TYPE_SEASONAL_LAKE",
        "TYPE_RESERVOIR",
        "TYPE_POND",
        "TYPE_RIVER",
        "TYPE_RAPIDS",
        "TYPE_DISTRIBUTARY",
        "TYPE_CONFLUENCE",
        "TYPE_WATERFALL",
        "TYPE_SPRING",
        "TYPE_GEYSER",
        "TYPE_HOT_SPRING",
        "TYPE_SEASONAL_RIVER",
        "TYPE_WADI",
        "TYPE_ESTUARY",
        "TYPE_WETLAND",
        "TYPE_WATER_NAVIGATION",
        "TYPE_FORD",
        "TYPE_CANAL",
        "TYPE_HARBOR",
        "TYPE_CHANNEL",
        "TYPE_REEF",
        "TYPE_REEF_FLAT",
        "TYPE_REEF_GROWTH",
        "TYPE_REEF_EXTENT",
        "TYPE_REEF_ROCK_SUBMERGED",
        "TYPE_IRRIGATION",
        "TYPE_DAM",
        "TYPE_DRINKING_WATER",
        "TYPE_CURRENT",
        "TYPE_WATERING_HOLE",
        "TYPE_TECTONIC",
        "TYPE_WATERING_HOLE_DEPRECATED",
        "TYPE_VOLCANO",
        "TYPE_LAVA_FIELD",
        "TYPE_FISSURE",
        "TYPE_FAULT",
        "TYPE_LAND_MASS",
        "TYPE_CONTINENT",
        "TYPE_ISLAND",
        "TYPE_ATOLL",
        "TYPE_OCEAN_ROCK_EXPOSED",
        "TYPE_CAY",
        "TYPE_PENINSULA",
        "TYPE_ISTHMUS",
        "TYPE_ELEVATED",
        "TYPE_PEAK",
        "TYPE_NUNATAK",
        "TYPE_SPUR",
        "TYPE_PASS",
        "TYPE_PLATEAU",
        "TYPE_RIDGE",
        "TYPE_RAVINE",
        "TYPE_CRATER",
        "TYPE_KARST",
        "TYPE_CLIFF",
        "TYPE_VISTA",
        "TYPE_DIGITAL_ELEVATION_MODEL",
        "TYPE_UPLAND",
        "TYPE_TERRACE",
        "TYPE_SLOPE",
        "TYPE_CONTOUR_LINE",
        "TYPE_PAN",
        "TYPE_UNSTABLE_HILLSIDE",
        "TYPE_MOUNTAIN_RANGE",
        "TYPE_UNDERSEA",
        "TYPE_SUBMARINE_SEAMOUNT",
        "TYPE_SUBMARINE_RIDGE",
        "TYPE_SUBMARINE_GAP",
        "TYPE_SUBMARINE_PLATEAU",
        "TYPE_SUBMARINE_DEEP",
        "TYPE_SUBMARINE_VALLEY",
        "TYPE_SUBMARINE_BASIN",
        "TYPE_SUBMARINE_SLOPE",
        "TYPE_SUBMARINE_CLIFF",
        "TYPE_SUBMARINE_PLAIN",
        "TYPE_SUBMARINE_FRACTURE_ZONE",
        "TYPE_CAVE",
        "TYPE_ROCK",
        "TYPE_ARCHIPELAGO",
        "TYPE_POSTAL",
        "TYPE_POSTAL_CODE",
        "TYPE_POSTAL_CODE_PREFIX",
        "TYPE_PREMISE",
        "TYPE_SUB_PREMISE",
        "TYPE_SUITE",
        "TYPE_POST_TOWN",
        "TYPE_POSTAL_ROUND",
        "TYPE_META_FEATURE",
        "TYPE_DATA_SOURCE",
        "TYPE_LOCALE",
        "TYPE_TIMEZONE",
        "TYPE_BUSINESS_CHAIN",
        "TYPE_PHONE_NUMBER_PREFIX",
        "TYPE_PHONE_NUMBER_AREA_CODE",
        "TYPE_BUSINESS_CORRIDOR",
        "TYPE_ADDRESS_TEMPLATE",
        "TYPE_TRANSIT_AGENCY",
        "TYPE_FUTURE_GEOMETRY",
        "TYPE_EVENT",
        "TYPE_EARTHQUAKE",
        "TYPE_HURRICANE",
        "TYPE_WEATHER_CONDITION",
        "TYPE_TRANSIENT",
        "TYPE_ENTRANCE",
        "TYPE_CARTOGRAPHIC",
        "TYPE_HIGH_TENSION",
        "TYPE_SKI_TRAIL",
        "TYPE_SKI_LIFT",
        "TYPE_SKI_BOUNDARY",
        "TYPE_WATERSHED_BOUNDARY",
        "TYPE_TARMAC",
        "TYPE_WALL",
        "TYPE_PICNIC_AREA",
        "TYPE_PLAY_GROUND",
        "TYPE_TRAIL_HEAD",
        "TYPE_GOLF_TEEING_GROUND",
        "TYPE_GOLF_PUTTING_GREEN",
        "TYPE_GOLF_ROUGH",
        "TYPE_GOLF_SAND_BUNKER",
        "TYPE_GOLF_FAIRWAY",
        "TYPE_GOLF_HOLE",
        "TYPE_DEPRECATED_GOLF_SHOP",
        "TYPE_CAMPING_SITE",
        "TYPE_DESIGNATED_BARBECUE_PIT",
        "TYPE_DESIGNATED_COOKING_AREA",
        "TYPE_CAMPFIRE_PIT",
        "TYPE_WATER_FOUNTAIN",
        "TYPE_LITTER_RECEPTACLE",
        "TYPE_LOCKER_AREA",
        "TYPE_ANIMAL_ENCLOSURE",
        "TYPE_CARTOGRAPHIC_LINE",
        "TYPE_ESTABLISHMENT",
        "TYPE_ESTABLISHMENT_GROUNDS",
        "TYPE_ESTABLISHMENT_BUILDING",
        "TYPE_ESTABLISHMENT_POI",
        "TYPE_ESTABLISHMENT_SERVICE",
        "TYPE_CELESTIAL",
        "TYPE_ROAD_MONITOR",
        "TYPE_PUBLIC_SPACES_AND_MONUMENTS",
        "TYPE_STATUE",
        "TYPE_TOWN_SQUARE",
        "TYPE_LEVEL",
        "TYPE_COMPOUND",
        "TYPE_COMPOUND_GROUNDS",
        "TYPE_COMPOUND_BUILDING",
        "TYPE_COMPOUND_SECTION",
        "TYPE_TERMINAL_POINT",
        "TYPE_REGULATED_AREA",
        "TYPE_LOGICAL_BORDER",
        "TYPE_DO_NOT_USE_RESERVED_TO_CATCH_GENERATED_FILES",
        "TYPE_UNKNOWN",
    ]

@typing.type_check_only
class CountryMetroNBFeature(typing_extensions.TypedDict, total=False):
    enclosingProvinceGeotoken: int
    id: int
    navboost: float

@typing.type_check_only
class CountryProvinceGeotoken(typing_extensions.TypedDict, total=False):
    geotoken: int

@typing.type_check_only
class CountrySalientCountry(typing_extensions.TypedDict, total=False):
    compressedSalience: int
    countryCode: int
    salience: float

@typing.type_check_only
class CrawlerChangerateMultipleComponentDistribution(
    typing_extensions.TypedDict, total=False
):
    components: _list[CrawlerChangerateSingleComponentDistribution]

@typing.type_check_only
class CrawlerChangerateSingleComponentDistribution(
    typing_extensions.TypedDict, total=False
):
    logScaling: float
    type: typing_extensions.Literal["LOG_GAMMA", "INV_GAMMA", "GAMMA", "LOG_NORMAL"]
    weight: float

@typing.type_check_only
class CrawlerChangerateUrlChange(typing_extensions.TypedDict, total=False):
    additionalChangesMerged: int
    fractionalTileChange: float
    interval: int
    offDomainLinksChange: bool
    offDomainLinksCount: int
    onDomainLinksCount: int
    onDomainLinksCountChange: bool
    shingleSimhash: IndexingConverterShingleFingerprint
    simhash: str
    simhashIsTrusted: bool
    simhashV2: str
    simhashV2IsTrusted: bool

@typing.type_check_only
class CrawlerChangerateUrlChangerate(typing_extensions.TypedDict, total=False):
    approximatedPosterior: CrawlerChangerateMultipleComponentDistribution
    averageChangeSignificance: float
    changeperiod: int
    confidence: float
    globalBasedChangePeriod: int
    globalBasedChangePeriodConfidence: float
    globalBasedPriorPeriod: float
    globalBasedPriorStrength: float
    lastChangeSignificance: float
    lastChanged: int
    lastFetched: int
    numIntervals: int
    patternBasedChangePeriod: int
    patternBasedChangePeriodConfidence: float
    patternBasedLowerChangePeriod: int
    patternBasedPriorPeriod: float
    patternBasedPriorStrength: float
    patternChangePeriodVersion: int
    type: int
    ugcChangePeriod: int
    ugcChangePeriodConfidence: float

@typing.type_check_only
class CrawlerChangerateUrlHistory(typing_extensions.TypedDict, total=False):
    change: _list[CrawlerChangerateUrlChange]
    latestVersion: CrawlerChangerateUrlVersion
    url: str

@typing.type_check_only
class CrawlerChangerateUrlVersion(typing_extensions.TypedDict, total=False):
    additionalChangesMerged: int
    contentType: int
    isImsNotModified: bool
    lastModified: int
    offDomainLinksChecksum: int
    offDomainLinksCount: int
    onDomainLinksCount: int
    shingleSimhash: IndexingConverterShingleFingerprint
    simhash: str
    simhashIsTrusted: bool
    simhashV2: str
    simhashV2IsTrusted: bool
    tile: _list[int]
    timestamp: int

@typing.type_check_only
class CrowdingPerDocData(typing_extensions.TypedDict, total=False):
    newscluster: _list[CrowdingPerDocDataNewsCluster]

@typing.type_check_only
class CrowdingPerDocDataNewsCluster(typing_extensions.TypedDict, total=False):
    ClusterId: str
    ClusterSize: int
    ClusterTimeStamp: int

@typing.type_check_only
class DeepCropIndexing(typing_extensions.TypedDict, total=False):
    cropBytes: str

@typing.type_check_only
class DeepCropPixels(typing_extensions.TypedDict, total=False):
    x0: int
    x1: int
    y0: int
    y1: int

@typing.type_check_only
class DocProperties(typing_extensions.TypedDict, total=False):
    avgTermWeight: int
    badTitle: bool
    badtitleinfo: _list[DocPropertiesBadTitleInfo]
    languages: _list[int]
    leadingtext: SnippetsLeadingtextLeadingTextInfo
    numPunctuations: int
    numTags: int
    numTokens: int
    proseRestrict: _list[str]
    restricts: _list[str]
    timestamp: str
    title: str

@typing.type_check_only
class DocPropertiesBadTitleInfo(typing_extensions.TypedDict, total=False):
    score: float
    type: typing_extensions.Literal[
        "NOT_BAD",
        "MISSING_OR_MEANINGLESS",
        "BOILERPLATE",
        "FOREIGN",
        "UNREADABLE",
        "NAKED",
        "NO_QUERY_SUPPORT",
        "NO_SITE_INFO",
    ]

@typing.type_check_only
class DrishtiCompressedFeature(typing_extensions.TypedDict, total=False):
    featureName: typing_extensions.Literal["UNKNOWN", "STARBURST_V4", "RESNETISH_V3"]
    inRangeBitstream: str
    outOfRangeBitstream: str

@typing.type_check_only
class DrishtiDenseFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    value: _list[float]

@typing.type_check_only
class DrishtiFeatureExtra(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class DrishtiFeatureSetData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    feature: _list[DrishtiFeatureSetDataFeatureSetElement]
    label: _list[DrishtiLabelSetElement]

@typing.type_check_only
class DrishtiFeatureSetDataFeatureSetElement(typing_extensions.TypedDict, total=False):
    compressed: DrishtiCompressedFeature
    dense: DrishtiDenseFeatureData
    indexed: DrishtiIndexedFeatureData
    name: str
    quantized: DrishtiQuantizedDenseFeatureData
    quantizedByteDense: DrishtiQuantizedByteDenseFeatureData
    quantizedByteIndexed: DrishtiQuantizedByteIndexedFeatureData
    sparse: DrishtiSparseFeatureData

@typing.type_check_only
class DrishtiFeatureSetDataSequence(typing_extensions.TypedDict, total=False):
    element: _list[DrishtiFeatureSetData]
    extra: _list[DrishtiFeatureExtra]
    label: _list[DrishtiLabelSetElement]
    timestamp: _list[str]

@typing.type_check_only
class DrishtiIndexedFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    index: _list[str]
    value: _list[float]

@typing.type_check_only
class DrishtiLabelSetData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    targetClass: _list[str]
    targetClassName: _list[str]
    targetValue: _list[float]
    targetWeight: _list[float]
    weight: float

@typing.type_check_only
class DrishtiLabelSetElement(typing_extensions.TypedDict, total=False):
    label: DrishtiLabelSetData
    name: str

@typing.type_check_only
class DrishtiQuantizedByteDenseFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    value: str

@typing.type_check_only
class DrishtiQuantizedByteIndexedFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    index: _list[str]
    value: str

@typing.type_check_only
class DrishtiQuantizedDenseFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    value: _list[str]

@typing.type_check_only
class DrishtiSparseFeatureData(typing_extensions.TypedDict, total=False):
    extra: _list[DrishtiFeatureExtra]
    generalExtra: DrishtiFeatureExtra
    label: _list[str]
    value: _list[float]

@typing.type_check_only
class DrishtiVesperEncodedThumbnail(typing_extensions.TypedDict, total=False):
    byteSize: str
    crc32c: int
    encodingQuality: int
    encodingType: typing_extensions.Literal["UNKNOWN", "JPEG", "WEBP", "PNG"]
    height: int
    imageBlobId: str
    imageBytes: str
    imageString: str
    width: int

@typing.type_check_only
class DrishtiVesperMovingThumbnail(typing_extensions.TypedDict, total=False):
    beginTimestampMs: int
    durationMs: int
    encodedGifAnimation: str
    encodedVideoString: str
    encodedWebpAnimation: str
    endTimestampMs: int
    height: int
    id: str
    movingThumbnailerVersion: typing_extensions.Literal[
        "V0",
        "V1",
        "DEPRECATED_V2",
        "DEPRECATED_V3",
        "V4",
        "V5",
        "V6",
        "SHORT_PREVIEW_V0",
        "LIVE_MOVING_THUMBNAILER",
        "MANUAL",
    ]
    name: typing_extensions.Literal[
        "UNKNOWN",
        "MQDEFAULT",
        "MQDEFAULT_6S",
        "LQDEFAULT_6S",
        "MQ220P_5S",
        "MQDEFAULT_6S_HIGHLIGHT",
        "MQDEFAULT_6S_PRE_HIGHLIGHT",
        "MQDEFAULT_6S_THIRD_HIGHLIGHT",
        "MQDEFAULT_6S_ZOOM_IN",
        "SD360P_6S_ZOOM_IN",
        "MQDEFAULT_3S",
        "MQDEFAULT_6S_480x270",
        "MQDEFAULT_1S",
        "MQ_SHORTS_PREVIEW",
        "HQ_SHORTS_PREVIEW",
    ]
    score: float
    scoreComponents: DrishtiVesperMovingThumbnailScoreComponents
    thumbnails: _list[DrishtiVesperThumbnail]
    type: typing_extensions.Literal[
        "TYPE_UNKNOWN", "AN_GIF", "AN_WEBP", "AN_MP4", "AN_WEBM"
    ]
    webpQualityLevel: float
    width: int

@typing.type_check_only
class DrishtiVesperMovingThumbnailScoreComponents(
    typing_extensions.TypedDict, total=False
):
    audienceRewindRatioScore: float
    iconicFaceScore: float
    matchingScore: float
    motionScore: float
    titleMatchingScore: float
    videoThumbQualityScore: float

@typing.type_check_only
class DrishtiVesperThumbnail(typing_extensions.TypedDict, total=False):
    denseFeatures: _list[float]
    encodedImageString: str
    encodedImageStringSmall: str
    encodedThumbnails: _list[DrishtiVesperEncodedThumbnail]
    id: str
    ocrText: str
    qualityScores: _list[DrishtiVesperThumbnailQualityScore]
    shouldUpdateDefaultThumbnail: bool
    thumbnailerModelVersion: typing_extensions.Literal[
        "VERSION_UNKNOWN",
        "VERSION_FIRST",
        "VERSION_RANDOM",
        "VERSION_4",
        "VERSION_5",
        "VERSION_6",
        "VERSION_7",
        "VERSION_8",
        "VERSION_SHORTS_4",
        "VERSION_SHORTS_5",
        "VERSION_SHORTS_6",
        "VERSION_STORY_4",
        "VERSION_STORY_5",
        "VERSION_MOVING_4",
        "VERSION_MOVING_5",
        "VERSION_MOVING_6",
        "VERSION_MOVING_SHORTS_0",
        "VERSION_MOVING_LIVE_0",
        "VERSION_MOVING_MANUAL_0",
        "VERSION_LITE_1",
        "VERSION_CUSTOM",
        "VERSION_REJECTED",
    ]
    timestampMs: int
    type: typing_extensions.Literal[
        "UNKNOWN",
        "MAIN_THUMB_CUSTOM",
        "MAIN_THUMB_NON_CUSTOM",
        "SHOT_THUMB",
        "NUMBERED_THUMB",
        "KEY_FRAME",
        "FRAME",
        "AUTO",
    ]
    userReportedThumbnail: DrishtiVesperUserReportUserReportedThumbnail
    userReportedThumbnails: _list[DrishtiVesperUserReportUserReportedThumbnail]
    version: int

@typing.type_check_only
class DrishtiVesperThumbnailQualityScore(typing_extensions.TypedDict, total=False):
    score: float
    type: typing_extensions.Literal[
        "UNKNOWN",
        "PHOTO_QUALITY",
        "PAMIR_IMAGE_QUALITY",
        "VIDEO_THUMB_QUALITY",
        "SALIENCY",
        "COMPLEXITY",
        "SHARPNESS",
        "CLOSE_UP",
        "BEEHIVE_QUALITY",
        "ICONIC_FACE",
        "DUMMY",
        "COLORFULNESS",
        "MOTION",
        "RETENTION_STATS",
        "FACIAL_EXPRESSION",
        "MATCHING",
        "LUCKYSHOT_SHARPNESS",
        "SINGLE_FACE_MODULE",
        "TITLE_MATCHING",
        "FACE_CLUSTERING",
        "FACE_MATCHING",
        "RACY_SCORE",
        "NON_RACY_SCORE",
        "SALIENCY_COVERAGE",
        "AUDIENCE_WATCH_DATA",
        "AUDIENCE_REWATCH_DATA",
        "AUDIENCE_REWIND_RATIO",
        "AUDIENCE_DROPOFF_RATIO",
        "HIGHLIGHT_SCORE",
        "JOY_FACE",
        "EYE_OPEN",
        "FACE_RATIO",
        "OCR_RACY_SCORE",
        "SHOT_BOUNDARY",
        "NIMA",
        "FOREGROUND_MOTION_SALIENCY",
        "PAGE_QUALITY",
        "GLOBAL_MOTION",
        "CHAPTER_TITLE_MATCHING",
        "DBSCAN_FRAME_CHAPTER_SIMILARITY",
        "EYES_NOT_VISIBLY_CLOSED",
        "ENGAGINESS",
        "MERGED",
    ]

@typing.type_check_only
class DrishtiVesperUserReportHumanLabel(typing_extensions.TypedDict, total=False):
    racyLevel: typing_extensions.Literal["UNKNOWN", "SAFE", "BORDERLINE", "SEXUAL"]

@typing.type_check_only
class DrishtiVesperUserReportModelScore(typing_extensions.TypedDict, total=False):
    modelName: str
    score: float

@typing.type_check_only
class DrishtiVesperUserReportUserReportedThumbnail(
    typing_extensions.TypedDict, total=False
):
    denseFeatures: _list[float]
    duration: int
    humanLabel: DrishtiVesperUserReportHumanLabel
    impressions: int
    needHumanLabel: bool
    rawHumanLabels: _list[DrishtiVesperUserReportHumanLabel]
    reportScore: DrishtiVesperUserReportModelScore
    reportType: typing_extensions.Literal["UNKNOWN", "RACY"]
    score: DrishtiVesperUserReportModelScore
    useCase: typing_extensions.Literal["UNKNOWN", "TRAIN", "EVAL"]
    volume: int

@typing.type_check_only
class DrishtiVesperVideoThumbnail(typing_extensions.TypedDict, total=False):
    id: str
    movingThumbnails: _list[DrishtiVesperMovingThumbnail]
    thumbnails: _list[DrishtiVesperThumbnail]

@typing.type_check_only
class EmbedsDeepLinkData(typing_extensions.TypedDict, total=False):
    appId: str
    client: _list[EmbedsPackagingServiceClient]
    deepLinkId: str
    url: str

@typing.type_check_only
class EmbedsEmbedClientItem(typing_extensions.TypedDict, total=False):
    canonicalId: str
    deepLinkData: EmbedsDeepLinkData
    id: str
    provenance: EmbedsProvenance
    renderId: str
    signature: str
    transientData: EmbedsTransientData
    type: _list[
        typing_extensions.Literal[
            "UNKNOWN",
            "ACTION_V2",
            "ADD_ACTION_V2",
            "AGGREGATE_RATING_V2",
            "ARTICLE_V2",
            "ASSESS_ACTION_V2",
            "AUDIO_OBJECT_V2",
            "BASIC_INTERACTION_V2",
            "BLOG_POSTING_V2",
            "BLOG_V2",
            "BOOK_V2",
            "BUY_ACTION_V2",
            "CHECK_IN_ACTION_V2",
            "CHECKIN_V2",
            "COLLEXION_V2",
            "COMMENT_ACTION_V2",
            "COMMENT_V2",
            "COMMUNICATE_ACTION_V2",
            "CONSUME_ACTION_V2",
            "CREATE_ACTION_V2",
            "CREATIVE_WORK_V2",
            "DISCOVER_ACTION_V2",
            "DOCUMENT_OBJECT_V2",
            "DRAWING_OBJECT_V2",
            "DRIVE_OBJECT_V2",
            "EMOTISHARE_V2",
            "ENTRY_POINT_V2",
            "EVENT_TIME_V2",
            "EVENT_V2",
            "FILE_OBJECT_V2",
            "FIND_ACTION_V2",
            "FINANCIAL_QUOTE_V2",
            "FORM_OBJECT_V2",
            "GEO_COORDINATES_V2",
            "GOOGLE_OFFER_V2",
            "HANGOUT_CHAT_MESSAGE",
            "HANGOUT_QUOTE",
            "HANGOUT_V2",
            "HOA_PLUS_EVENT_V2",
            "IMAGE_OBJECT_V2",
            "INTERACT_ACTION_V2",
            "INTERACTION_V2",
            "LISTEN_ACTION_V2",
            "LOCAL_BUSINESS_V2",
            "LOCAL_PLUS_PHOTO_ALBUM_V2",
            "MAGAZINE_V2",
            "MEDIA_OBJECT_V2",
            "MOBILE_APPLICATION_V2",
            "MOVIE_V2",
            "MUSIC_ALBUM_V2",
            "MUSIC_GROUP_V2",
            "MUSIC_PLAYLIST_V2",
            "MUSIC_RECORDING_V2",
            "NEWS_ARTICLE_V2",
            "OFFER_V2",
            "ORGANIZATION_V2",
            "ORGANIZE_ACTION_V2",
            "PERSON_V2",
            "PLACE_REVIEW_V2",
            "PLACE_V2",
            "PLAN_ACTION_V2",
            "PLAY_MUSIC_ALBUM_V2",
            "PLAY_MUSIC_TRACK_V2",
            "PLAY_OBJECT_V2",
            "PLUS_AUDIO_V2",
            "PLUS_EVENT_V2",
            "PLUS_MEDIA_COLLECTION_V2",
            "PLUS_MEDIA_OBJECT_V2",
            "PLUS_PAGE_V2",
            "PLUS_PHOTOS_ADDED_TO_COLLECTION_V2",
            "PLUS_PHOTO_ALBUM_V2",
            "PLUS_PHOTO_COLLECTION_V2",
            "PLUS_PHOTO_V2",
            "PLUS_POST_V2",
            "PLUS_RESHARE_V2",
            "PLUS_SOFTWARE_APPLICATION_V2",
            "POLL_OPTION_V2",
            "POLL_V2",
            "POSTAL_ADDRESS_V2",
            "PRESENTATION_OBJECT_V2",
            "PRODUCT_REVIEW_V2",
            "RATING_V2",
            "REACT_ACTION_V2",
            "RESERVATION_V2",
            "RESERVE_ACTION_V2",
            "REVIEW_V2",
            "REVIEW_ACTION_V2",
            "SOFTWARE_APPLICATION_V2",
            "SPREADSHEET_OBJECT_V2",
            "SQUARE_INVITE_V2",
            "SQUARE_V2",
            "STICKER_V2",
            "STORY_V2",
            "THING_V2",
            "TRADE_ACTION_V2",
            "DEPRECATED_TOUR_OBJECT_V2",
            "TV_EPISODE_V2",
            "TV_SERIES_V2",
            "UPDATE_ACTION_V2",
            "VIEW_ACTION_V2",
            "VIDEO_OBJECT_V2",
            "VIDEO_GALLERY_V2",
            "WANT_ACTION_V2",
            "WEB_PAGE_V2",
            "WRITE_ACTION_V2",
            "YOUTUBE_CHANNEL_V2",
            "GOOGLE_USER_PHOTO_V2",
            "GOOGLE_USER_PHOTO_ALBUM",
            "GOOGLE_PHOTO_RECIPE",
            "THING",
            "CREATIVE_WORK",
            "EVENT",
            "INTANGIBLE",
            "ORGANIZATION",
            "PERSON",
            "PLACE",
            "PRODUCT",
            "ARTICLE",
            "BLOG_POSTING",
            "NEWS_ARTICLE",
            "SCHOLARLY_ARTICLE",
            "BLOG",
            "BOOK",
            "COMMENT",
            "ITEM_LIST",
            "MAP",
            "MEDIA_OBJECT",
            "AUDIO_OBJECT",
            "IMAGE_OBJECT",
            "MUSIC_VIDEO_OBJECT",
            "VIDEO_OBJECT",
            "MOVIE",
            "MUSIC_PLAYLIST",
            "MUSIC_ALBUM",
            "MUSIC_RECORDING",
            "PAINTING",
            "PHOTOGRAPH",
            "RECIPE",
            "REVIEW",
            "SCULPTURE",
            "SOFTWARE_APPLICATION",
            "MOBILE_APPLICATION",
            "WEB_APPLICATION",
            "TV_EPISODE",
            "TV_SEASON",
            "TV_SERIES",
            "WEB_PAGE",
            "ABOUT_PAGE",
            "CHECKOUT_PAGE",
            "COLLECTION_PAGE",
            "IMAGE_GALLERY",
            "VIDEO_GALLERY",
            "CONTACT_PAGE",
            "ITEM_PAGE",
            "PROFILE_PAGE",
            "SEARCH_RESULTS_PAGE",
            "WEB_PAGE_ELEMENT",
            "SITE_NAVIGATION_ELEMENT",
            "TABLE",
            "WP_AD_BLOCK",
            "WP_FOOTER",
            "WP_HEADER",
            "WP_SIDEBAR",
            "APP_INVITE",
            "EMOTISHARE",
            "BUSINESS_EVENT",
            "CHILDRENS_EVENT",
            "COMEDY_EVENT",
            "DANCE_EVENT",
            "EDUCATION_EVENT",
            "FESTIVAL",
            "FOOD_EVENT",
            "LITERARY_EVENT",
            "MUSIC_EVENT",
            "SALE_EVENT",
            "SOCIAL_EVENT",
            "SPORTS_EVENT",
            "THEATER_EVENT",
            "VISUAL_ARTS_EVENT",
            "RESERVATION",
            "TRAVEL_EVENT",
            "CORPORATION",
            "EDUCATIONAL_ORGANIZATION",
            "COLLEGE_OR_UNIVERSITY",
            "ELEMENTARY_SCHOOL",
            "HIGH_SCHOOL",
            "MIDDLE_SCHOOL",
            "PRESCHOOL",
            "SCHOOL",
            "GOVERNMENT_ORGANIZATION",
            "LOCAL_BUSINESS",
            "ANIMAL_SHELTER",
            "AUTOMOTIVE_BUSINESS",
            "AUTO_BODY_SHOP",
            "AUTO_DEALER",
            "AUTO_PARTS_STORE",
            "AUTO_RENTAL",
            "AUTO_REPAIR",
            "AUTO_WASH",
            "GAS_STATION",
            "MOTORCYCLE_DEALER",
            "MOTORCYCLE_REPAIR",
            "CHILD_CARE",
            "DRY_CLEANING_OR_LAUNDRY",
            "EMERGENCY_SERVICE",
            "FIRE_STATION",
            "HOSPITAL",
            "POLICE_STATION",
            "EMPLOYMENT_AGENGY",
            "ENTERTAINMENT_BUSINESS",
            "ADULT_ENTERTAINMENT",
            "AMUSEMENT_PARK",
            "ART_GALLERY",
            "CASINO",
            "COMEDY_CLUB",
            "MOVIE_THEATER",
            "NIGHT_CLUB",
            "FINANCIAL_SERVICE",
            "ACCOUNTING_SERVICE",
            "AUTOMATED_TELLER",
            "BANK_OR_CREDIT_UNION",
            "INSURANCE_AGENCY",
            "FOOD_ESTABLISHMENT",
            "BAKERY",
            "BAR_OR_PUB",
            "BREWERY",
            "CAFE_OR_COFFEE_SHOP",
            "FAST_FOOD_RESTAURANT",
            "ICE_CREAM_SHOP",
            "RESTAURANT",
            "WINERY",
            "GOVERNMENT_OFFICE",
            "POST_OFFICE",
            "HEALTH_AND_BEAUTY_BUSINESS",
            "BEAUTY_SALON",
            "DAY_SPA",
            "HAIR_SALON",
            "HEALTH_CLUB",
            "NAIL_SALON",
            "TATTOO_PARLOR",
            "HOME_AND_CONSTRUCTION_BUSINESS",
            "ELECTRICIAN",
            "GENERAL_CONTRACTOR",
            "HVAC_BUSINESS",
            "HOUSE_PAINTER",
            "LOCKSMITH",
            "MOVING_COMPANY",
            "PLUMBER",
            "ROOFING_CONTRACTOR",
            "INTERNET_CAFE",
            "LIBRARY",
            "LODGING_BUSINESS",
            "BED_AND_BREAKFAST",
            "HOSTEL",
            "HOTEL",
            "MOTEL",
            "MEDICAL_ORGANIZATION",
            "DENTIST",
            "MEDICAL_CLINIC",
            "OPTICIAN",
            "PHARMACY",
            "PHYSICIAN",
            "VETERINARY_CARE",
            "PROFESSIONAL_SERVICE",
            "ATTORNEY",
            "NOTARY",
            "RADIO_STATION",
            "REAL_ESTATE_AGENT",
            "RECYCLING_CENTER",
            "SELF_STORAGE",
            "SHOPPING_CENTER",
            "SPORTS_ACTIVITY_LOCATION",
            "BOWLING_ALLEY",
            "EXERCISE_GYM",
            "GOLF_COURSE",
            "PUBLIC_SWIMMING_POOL",
            "SKI_RESORT",
            "SPORTS_CLUB",
            "STADIUM_OR_ARENA",
            "TENNIS_COMPLEX",
            "STORE",
            "BIKE_STORE",
            "BOOK_STORE",
            "CLOTHING_STORE",
            "COMPUTER_STORE",
            "CONVENIENCE_STORE",
            "DEPARTMENT_STORE",
            "ELECTRONICS_STORE",
            "FLORIST",
            "FURNITURE_STORE",
            "GARDEN_STORE",
            "GROCERY_STORE",
            "HARDWARE_STORE",
            "HOBBY_SHOP",
            "HOME_GOODS_STORE",
            "JEWELRY_STORE",
            "LIQUOR_STORE",
            "MENS_CLOTHING_STORE",
            "MOBILE_PHONE_STORE",
            "MOVIE_RENTAL_STORE",
            "MUSIC_STORE",
            "OFFICE_EQUIPMENT_STORE",
            "OUTLET_STORE",
            "PAWN_SHOP",
            "PET_STORE",
            "SHOE_STORE",
            "SPORTING_GOODS_STORE",
            "TIRE_SHOP",
            "TOY_STORE",
            "WHOLESALE_STORE",
            "TELEVISION_STATION",
            "TOURIST_INFORMATION_CENTER",
            "TRAVEL_AGENCY",
            "PERFORMING_GROUP",
            "MUSIC_GROUP",
            "ADMINISTRATIVE_AREA",
            "CITY",
            "COUNTRY",
            "STATE",
            "CIVIC_STRUCTURE",
            "AIRPORT",
            "AQUARIUM",
            "BEACH",
            "BUS_STATION",
            "BUS_STOP",
            "CAMPGROUND",
            "CEMETERY",
            "CREMATORIUM",
            "EVENT_VENUE",
            "GOVERNMENT_BUILDING",
            "CITY_HALL",
            "COURTHOUSE",
            "DEFENCE_ESTABLISHMENT",
            "EMBASSY",
            "LEGISLATIVE_BUILDING",
            "MUSEUM",
            "MUSIC_VENUE",
            "PARK",
            "PARKING_FACILITY",
            "PERFORMING_ARTS_THEATER",
            "PLACE_OF_WORSHIP",
            "BUDDHIST_TEMPLE",
            "CATHOLIC_CHURCH",
            "CHURCH",
            "HINDU_TEMPLE",
            "MOSQUE",
            "SYNAGOGUE",
            "PLAYGROUND",
            "R_V_PARK",
            "RESIDENCE",
            "APARTMENT_COMPLEX",
            "GATED_RESIDENCE_COMMUNITY",
            "SINGLE_FAMILY_RESIDENCE",
            "TOURIST_ATTRACTION",
            "SUBWAY_STATION",
            "TAXI_STAND",
            "TRAIN_STATION",
            "ZOO",
            "LANDFORM",
            "BODY_OF_WATER",
            "CANAL",
            "LAKE_BODY_OF_WATER",
            "OCEAN_BODY_OF_WATER",
            "POND",
            "RESERVOIR",
            "RIVER_BODY_OF_WATER",
            "SEA_BODY_OF_WATER",
            "WATERFALL",
            "CONTINENT",
            "MOUNTAIN",
            "VOLCANO",
            "LANDMARKS_OR_HISTORICAL_BUILDINGS",
            "USER_INTERACTION",
            "USER_PLUS_ONES",
            "ENUMERATION",
            "BOOK_FORMAT_TYPE",
            "ITEM_AVAILABILITY",
            "OFFER_ITEM_CONDITION",
            "JOB_POSTING",
            "LANGUAGE",
            "OFFER",
            "QUANTITY",
            "DISTANCE",
            "DURATION",
            "ENERGY",
            "MASS",
            "RATING",
            "AGGREGATE_RATING",
            "STRUCTURED_VALUE",
            "CONTACT_POINT",
            "POSTAL_ADDRESS",
            "GEO_COORDINATES",
            "GEO_SHAPE",
            "NUTRITION_INFORMATION",
            "PRESENTATION_OBJECT",
            "DOCUMENT_OBJECT",
            "SPREADSHEET_OBJECT",
            "FORM_OBJECT",
            "DRAWING_OBJECT",
            "PLACE_REVIEW",
            "FILE_OBJECT",
            "PLAY_MUSIC_TRACK",
            "PLAY_MUSIC_ALBUM",
            "MAGAZINE",
            "CAROUSEL_FRAME",
            "PLUS_EVENT",
            "HANGOUT",
            "HANGOUT_BROADCAST",
            "HANGOUT_CONSUMER",
            "CHECKIN",
            "EXAMPLE_OBJECT",
            "SQUARE",
            "SQUARE_INVITE",
            "PLUS_PHOTO",
            "PLUS_PHOTO_ALBUM",
            "LOCAL_PLUS_PHOTO_ALBUM",
            "PRODUCT_REVIEW",
            "FINANCIAL_QUOTE",
            "DEPRECATED_TOUR_OBJECT",
            "PLUS_PAGE",
            "GOOGLE_CHART",
            "PLUS_PHOTOS_ADDED_TO_COLLECTION",
            "RECOMMENDED_PEOPLE",
            "PLUS_POST",
            "DATE",
            "DRIVE_OBJECT_COLLECTION",
            "NEWS_MEDIA_ORGANIZATION",
            "DYNAMITE_ATTACHMENT_METADATA",
            "DYNAMITE_MESSAGE_METADATA",
        ]
    ]

@typing.type_check_only
class EmbedsPackagingServiceClient(typing_extensions.TypedDict, total=False):
    androidPackageName: str
    iosAppStoreId: str
    iosBundleId: str
    type: typing_extensions.Literal["ANDROID", "IOS"]

@typing.type_check_only
class EmbedsProvenance(typing_extensions.TypedDict, total=False):
    annotationBlob: str
    canonicalUrl: str
    inputUrl: str
    itemtype: _list[str]
    retrievedTimestampMsec: str
    retrievedUrl: str

@typing.type_check_only
class EmbedsTransientData(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class EventIdMessage(typing_extensions.TypedDict, total=False):
    processId: int
    serverIp: int
    timeUsec: str

@typing.type_check_only
class ExtraSnippetInfoResponse(typing_extensions.TypedDict, total=False):
    matchinfo: ExtraSnippetInfoResponseMatchInfo
    querysubitem: _list[ExtraSnippetInfoResponseQuerySubitem]
    tidbit: _list[ExtraSnippetInfoResponseTidbit]

@typing.type_check_only
class ExtraSnippetInfoResponseMatchInfo(typing_extensions.TypedDict, total=False):
    titleMatches: str
    urlMatches: str
    weightedItems: str

@typing.type_check_only
class ExtraSnippetInfoResponseQuerySubitem(typing_extensions.TypedDict, total=False):
    isHighlighted: bool
    isOptional: bool
    isOriginal: bool
    items: int
    text: str
    weight: int

@typing.type_check_only
class ExtraSnippetInfoResponseTidbit(typing_extensions.TypedDict, total=False):
    anchorinfo: ExtraSnippetInfoResponseTidbitAnchorInfo
    begin: int
    end: int
    items: str
    score: float
    text: str
    type: typing_extensions.Literal["TIDBIT", "BODY", "META", "GWD", "FULL", "ANCHOR"]

@typing.type_check_only
class ExtraSnippetInfoResponseTidbitAnchorInfo(
    typing_extensions.TypedDict, total=False
):
    offdomainCount: int
    ondomainCount: int

@typing.type_check_only
class FaceIndexing(typing_extensions.TypedDict, total=False):
    mustangBytes: str
    mustangBytesVersion: int

@typing.type_check_only
class FatcatCompactBinaryClassification(typing_extensions.TypedDict, total=False):
    binaryClassifier: typing_extensions.Literal[
        "BLOG",
        "FORUM",
        "LOGIN",
        "B2B_OK",
        "IMAGES",
        "SOCIAL",
        "PURCHASING_INTENT",
        "PORN",
        "ADULTISH",
        "VIOLENCE_GORE",
        "GOSSIP",
    ]
    binaryClassifierName: str
    discreteFraction: int

@typing.type_check_only
class FatcatCompactDocClassification(typing_extensions.TypedDict, total=False):
    binary: _list[FatcatCompactBinaryClassification]
    clusters: FatcatCompactRephilClusters
    epoch: str
    langCode: str
    rephilModelId: int
    taxonomic: _list[FatcatCompactTaxonomicClassification]
    url: str
    weight: str

@typing.type_check_only
class FatcatCompactRephilClusters(typing_extensions.TypedDict, total=False):
    cluster: _list[FatcatCompactRephilClustersCluster]

@typing.type_check_only
class FatcatCompactRephilClustersCluster(typing_extensions.TypedDict, total=False):
    discreteWeight: int
    id: int

@typing.type_check_only
class FatcatCompactTaxonomicClassification(typing_extensions.TypedDict, total=False):
    category: _list[FatcatCompactTaxonomicClassificationCategory]
    classifierVersion: str
    taxonomy: typing_extensions.Literal[
        "VERTICALS",
        "VERTICALS4",
        "VERTICALS4_GEO",
        "GEO",
        "PRODUCTS_SERVICES",
        "ICM_IM_AUDIENCES",
        "ICM_IM_AUDIENCES_DEV",
    ]
    taxonomyName: str

@typing.type_check_only
class FatcatCompactTaxonomicClassificationCategory(
    typing_extensions.TypedDict, total=False
):
    discreteWeight: int
    id: int

@typing.type_check_only
class FocusBackendContactDetailHash(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal["UNSPECIFIED", "PHONE", "EMAIL"]
    value: int

@typing.type_check_only
class FocusBackendContactPointer(typing_extensions.TypedDict, total=False):
    annotationId: str
    deviceRawContactId: FocusBackendDeviceRawContactId
    focusContactId: str
    otherContactId: FocusBackendOtherContactId
    secondaryId: FocusBackendSecondaryContactId

@typing.type_check_only
class FocusBackendDeviceContactId(typing_extensions.TypedDict, total=False):
    ContactId: str
    DeviceId: FocusBackendDeviceId

@typing.type_check_only
class FocusBackendDeviceId(typing_extensions.TypedDict, total=False):
    AndroidDeviceId: str
    Hash: str

@typing.type_check_only
class FocusBackendDeviceRawContactId(typing_extensions.TypedDict, total=False):
    DeviceId: FocusBackendDeviceId
    RawContactId: str

@typing.type_check_only
class FocusBackendOtherContactId(typing_extensions.TypedDict, total=False):
    deviceContactId: _list[FocusBackendDeviceContactId]

@typing.type_check_only
class FocusBackendSecondaryContactId(typing_extensions.TypedDict, total=False):
    contactDetailHash: _list[FocusBackendContactDetailHash]
    contactName: str
    contactNameHash: str

@typing.type_check_only
class FreebaseCitation(typing_extensions.TypedDict, total=False):
    dataset: str
    isAttributionRequired: bool
    project: str
    provider: str
    statement: str
    uri: str

@typing.type_check_only
class FreebaseId(typing_extensions.TypedDict, total=False):
    id: str
    mid: str

@typing.type_check_only
class FreebaseLatLong(typing_extensions.TypedDict, total=False):
    latDeg: float
    longDeg: float

@typing.type_check_only
class FreebaseMeasurement(typing_extensions.TypedDict, total=False):
    magnitude: float
    unit: _list[FreebaseMeasurementUnit]

@typing.type_check_only
class FreebaseMeasurementUnit(typing_extensions.TypedDict, total=False):
    power: int
    unit: FreebaseId
    unitMid: str

@typing.type_check_only
class FreebaseNestedStruct(typing_extensions.TypedDict, total=False):
    propertyValue: _list[FreebasePropertyValue]

@typing.type_check_only
class FreebasePropertyValue(typing_extensions.TypedDict, total=False):
    property: FreebaseId
    totalValueCount: str
    value: _list[FreebaseValue]
    valueStatus: typing_extensions.Literal["HAS_UNKNOWN_VALUE", "HAS_NO_VALUE"]

@typing.type_check_only
class FreebaseTopic(typing_extensions.TypedDict, total=False):
    id: FreebaseId
    propertyValue: _list[FreebasePropertyValue]

@typing.type_check_only
class FreebaseValue(typing_extensions.TypedDict, total=False):
    boolValue: bool
    citation: FreebaseCitation
    compoundValue: FreebaseTopic
    deletionProvenance: _list[StorageGraphBfgTripleProvenance]
    displayLang: str
    displayValue: str
    expectedProto: str
    floatValue: float
    idValue: FreebaseId
    index: str
    intValue: str
    lang: str
    latLongValue: FreebaseLatLong
    measurementValue: FreebaseMeasurement
    nestedStruct: FreebaseNestedStruct
    provenance: _list[StorageGraphBfgTripleProvenance]
    rawValue: str
    stringValue: str
    subgraphId: _list[str]
    timestamp: str
    timestampUsec: str
    type: typing_extensions.Literal[
        "TYPE_NULL",
        "TYPE_ID",
        "TYPE_TEXT",
        "TYPE_ENUM",
        "TYPE_KEY",
        "TYPE_URI",
        "TYPE_DATETIME",
        "TYPE_BOOL",
        "TYPE_INT",
        "TYPE_FLOAT",
        "TYPE_COMPOUND",
        "TYPE_PROTO",
        "TYPE_EXTENSION",
        "TYPE_NESTED_STRUCT",
        "TYPE_SEMANTIC_REFERENCE",
        "TYPE_LAT_LONG",
        "TYPE_MEASUREMENT",
        "TYPE_HAS_VALUE",
        "TYPE_HAS_NO_VALUE",
    ]

@typing.type_check_only
class GDocumentBase(typing_extensions.TypedDict, total=False):
    ContentExpiryTime: int
    DisplayUrl: str
    DocId: str
    ExternalFeedMetadata: str
    ExternalHttpMetadata: str
    FilterForSafeSearch: int
    IPAddr: str
    NoArchiveReason: int
    NoFollowReason: int
    NoImageIndexReason: int
    NoImageframeOverlayReason: int
    NoIndexReason: int
    NoPreviewReason: int
    NoSnippetReason: int
    NoTranslateReason: int
    Pagerank: int
    PagerankNS: int
    Repid: str
    ScienceMetadata: ScienceCitation
    URL: str
    URLAfterRedirects: str
    URLEncoding: int
    content: GDocumentBaseContent
    directory: _list[GDocumentBaseDirectory]
    ecnFp: str
    id: IndexingCrawlerIdServingDocumentIdentifier
    localsearchDocInfo: LocalsearchDocInfo
    oceanDocInfo: OceanDocInfo
    originalcontent: GDocumentBaseOriginalContent
    userAgentName: str

@typing.type_check_only
class GDocumentBaseContent(typing_extensions.TypedDict, total=False):
    AuthMethod: int
    ContentLength: int
    ContentType: int
    CrawlTime: str
    Encoding: int
    HasHttpHeader: bool
    Language: int
    OriginalEncoding: int
    Representation: str
    UncompressedLength: int
    VisualType: int
    crawledFileSize: int
    encodedGeometryAnnotations: str

@typing.type_check_only
class GDocumentBaseDirectory(typing_extensions.TypedDict, total=False):
    Category: str
    Description: str
    DescriptionScore: float
    Identifier: str
    Language: int
    Title: str
    TitleScore: float
    URL: str

@typing.type_check_only
class GDocumentBaseOriginalContent(typing_extensions.TypedDict, total=False):
    Representation: str
    UncompressedLength: int

@typing.type_check_only
class GenericSnippetResponse(typing_extensions.TypedDict, total=False):
    debugInfo: _list[str]
    info: Proto2BridgeMessageSet
    snippet: _list[str]
    title: str
    wwwSnippetResponse: WWWSnippetResponse

@typing.type_check_only
class GeoOndemandAssistantSupportedActions(typing_extensions.TypedDict, total=False):
    allowsGuestCheckout: bool
    isAsynchronousRestaurantReservation: bool
    restaurantReservationUrl: str

@typing.type_check_only
class GeostoreAccessPointProto(typing_extensions.TypedDict, total=False):
    canEnter: bool
    canExit: bool
    featureId: GeostoreFeatureIdProto
    featureType: int
    levelFeatureId: GeostoreFeatureIdProto
    metadata: GeostoreFieldMetadataProto
    point: GeostorePointProto
    pointOffSegment: GeostorePointProto
    pointOnSegment: GeostorePointProto
    priority: typing_extensions.Literal["TYPE_PRIMARY", "TYPE_SECONDARY"]
    segmentPosition: float
    unsuitableTravelMode: _list[
        typing_extensions.Literal[
            "TRAVEL_MODE_MOTOR_VEHICLE",
            "TRAVEL_MODE_AUTO",
            "TRAVEL_MODE_TWO_WHEELER",
            "TRAVEL_MODE_BICYCLE",
            "TRAVEL_MODE_PEDESTRIAN",
            "TRAVEL_MODE_PUBLIC_TRANSIT",
        ]
    ]

@typing.type_check_only
class GeostoreAddressComponentProto(typing_extensions.TypedDict, total=False):
    featureId: GeostoreFeatureIdProto
    featureType: int
    index: int
    parsedName: _list[GeostoreNameProto]
    range: GeostoreAddressRangeProto
    temporaryData: Proto2BridgeMessageSet
    textAffix: _list[GeostoreTextAffixProto]
    type: typing_extensions.Literal[
        "TYPE_FEATURE",
        "TYPE_POSTAL_CODE_SUFFIX",
        "TYPE_POST_BOX",
        "TYPE_STREET_NUMBER",
        "TYPE_FLOOR",
        "TYPE_ROOM",
        "TYPE_HOUSE_ID",
        "TYPE_DISTANCE_MARKER",
        "TYPE_LANDMARK",
        "TYPE_PLUS_CODE",
    ]

@typing.type_check_only
class GeostoreAddressLinesProto(typing_extensions.TypedDict, total=False):
    language: str
    line: _list[str]

@typing.type_check_only
class GeostoreAddressProto(typing_extensions.TypedDict, total=False):
    addressLines: _list[GeostoreAddressLinesProto]
    component: _list[GeostoreAddressComponentProto]
    crossStreet: _list[GeostoreAddressComponentProto]
    metadata: GeostoreFieldMetadataProto
    partialDenormalization: GeostoreAddressProto
    templateId: str
    temporaryData: Proto2BridgeMessageSet

@typing.type_check_only
class GeostoreAddressRangeProto(typing_extensions.TypedDict, total=False):
    number: _list[int]
    parameter: _list[float]
    prefix: str
    sameParity: bool
    suffix: str
    temporaryData: Proto2BridgeMessageSet

@typing.type_check_only
class GeostoreAnchoredGeometryProto(typing_extensions.TypedDict, total=False):
    geometryId: str

@typing.type_check_only
class GeostoreAppliedSpeedLimitProto(typing_extensions.TypedDict, total=False):
    speedLimit: GeostoreSpeedLimitProto
    trustLevel: typing_extensions.Literal[
        "SPEED_LIMIT_TRUST_LEVEL_UNKNOWN", "LOW_QUALITY", "HIGH_QUALITY", "EXACT"
    ]

@typing.type_check_only
class GeostoreAttachmentsAttachmentProto(typing_extensions.TypedDict, total=False):
    attachmentId: str
    clientNameSpace: str
    comment: str
    messages: Proto2BridgeMessageSet
    typeId: str

@typing.type_check_only
class GeostoreAttributeIdProto(typing_extensions.TypedDict, total=False):
    id: str
    providerId: str
    type: typing_extensions.Literal["ITEMCLASS", "ATTRIBUTE", "VALUESPACE", "DATASTORE"]

@typing.type_check_only
class GeostoreAttributeProto(typing_extensions.TypedDict, total=False):
    applicationData: Proto2BridgeMessageSet
    attributeDisplay: _list[GeostoreAttributeValueDisplayProto]
    booleanValue: bool
    canonicalAttributeId: GeostoreAttributeIdProto
    doubleValue: float
    enumIdValue: str
    floatValue: float
    int64Value: str
    integerValue: int
    itemClassId: GeostoreAttributeIdProto
    metadata: GeostoreFieldMetadataProto
    protoValue: Proto2BridgeMessageSet
    stringValue: str
    uint32Value: int
    valueDisplay: _list[GeostoreAttributeValueDisplayProto]
    valueSpaceId: GeostoreAttributeIdProto
    valueType: typing_extensions.Literal[
        "NONE",
        "STRING",
        "INTEGER",
        "DOUBLE",
        "BOOLEAN",
        "PROTO_VALUE",
        "INT64",
        "FLOAT",
        "DISPLAY_ONLY",
        "UINT32",
        "ENUM_ID",
    ]

@typing.type_check_only
class GeostoreAttributeValueDisplayProto(typing_extensions.TypedDict, total=False):
    language: str
    synonym: str

@typing.type_check_only
class GeostoreBarrierLogicalMaterialProto(typing_extensions.TypedDict, total=False):
    material: _list[
        typing_extensions.Literal[
            "UNKNOWN_LOGICAL_MATERIAL",
            "CONCRETE",
            "METAL",
            "PLASTIC",
            "STONE",
            "TIMBER",
        ]
    ]

@typing.type_check_only
class GeostoreBestLocaleProto(typing_extensions.TypedDict, total=False):
    locale: GeostoreFeatureIdProto
    localizationPolicyId: str
    metadata: GeostoreFieldMetadataProto

@typing.type_check_only
class GeostoreBizBuilderReferenceProto(typing_extensions.TypedDict, total=False):
    id: str

@typing.type_check_only
class GeostoreBorderProto(typing_extensions.TypedDict, total=False):
    featureIdLeft: GeostoreFeatureIdProto
    featureIdRight: GeostoreFeatureIdProto
    logicalBorder: _list[GeostoreFeatureIdProto]
    overrideStatus: _list[GeostoreOverrideBorderStatusProto]
    status: typing_extensions.Literal[
        "STATUS_NORMAL",
        "STATUS_DISPUTED",
        "STATUS_UNSURVEYED",
        "STATUS_INTERNATIONAL_WATER",
        "STATUS_NEVER_DISPLAY",
        "STATUS_TREATY",
        "STATUS_PROVISIONAL",
        "STATUS_NO_LABEL",
    ]
    type: int

@typing.type_check_only
class GeostoreBoundingMarkerProto(typing_extensions.TypedDict, total=False):
    boundingMarker: GeostoreFeatureIdProto
    boundingMarkerToken: str
    flowlineAdjacencyBeginFraction: float
    flowlineAdjacencyEndFraction: float
    markerAdjacencyBeginFraction: float
    markerAdjacencyEndFraction: float
    side: typing_extensions.Literal["UNKNOWN", "LEFT", "RIGHT"]

@typing.type_check_only
class GeostoreBuildingProto(typing_extensions.TypedDict, total=False):
    baseHeightMetersAgl: float
    defaultDisplayLevel: GeostoreFeatureIdProto
    floors: int
    floorsMetadata: GeostoreFieldMetadataProto
    heightMeters: float
    heightMetersMetadata: GeostoreFieldMetadataProto
    level: _list[GeostoreFeatureIdProto]
    structure: typing_extensions.Literal[
        "STRUCTURE_ANY",
        "STRUCTURE_TOWER",
        "STRUCTURE_DOME",
        "STRUCTURE_CASTLE",
        "STRUCTURE_SHRINE",
        "STRUCTURE_TEMPLE",
        "STRUCTURE_TANK",
    ]

@typing.type_check_only
class GeostoreBusinessChainProto(typing_extensions.TypedDict, total=False):
    canonicalGconcepts: _list[GeostoreCanonicalGConceptProto]

@typing.type_check_only
class GeostoreBusinessHoursProto(typing_extensions.TypedDict, total=False):
    data: BusinessHours
    metadata: GeostoreFieldMetadataProto

@typing.type_check_only
class GeostoreCallToActionProto(typing_extensions.TypedDict, total=False):
    ctaType: typing_extensions.Literal[
        "CTA_TYPE_UNSPECIFIED",
        "CTA_TYPE_BOOK",
        "CTA_TYPE_BUY",
        "CTA_TYPE_ORDER_ONLINE",
        "CTA_TYPE_LEARN_MORE",
        "CTA_TYPE_SIGN_UP",
        "CTA_TYPE_GET_OFFER",
    ]
    url: GeostoreUrlProto

@typing.type_check_only
class GeostoreCanonicalGConceptProto(typing_extensions.TypedDict, total=False):
    gconcept: GeostoreGConceptInstanceProto
    isRequired: bool

@typing.type_check_only
class GeostoreCellCoveringProto(typing_extensions.TypedDict, total=False):
    cellId: _list[str]

@typing.type_check_only
class GeostoreCityJsonProto(typing_extensions.TypedDict, total=False):
    cityObjects: _list[GeostoreCityJsonProtoCityObject]
    transform: GeostoreCityJsonProtoTransform
    vertexXyz: _list[int]

@typing.type_check_only
class GeostoreCityJsonProtoCityObject(typing_extensions.TypedDict, total=False):
    geometries: _list[GeostoreCityJsonProtoCityObjectGeometry]
    id: str
    type: typing_extensions.Literal[
        "TYPE_UNSPECIFIED", "BUILDING", "OTHER_CONSTRUCTION"
    ]

@typing.type_check_only
class GeostoreCityJsonProtoCityObjectGeometry(typing_extensions.TypedDict, total=False):
    lod: str
    multipoint: GeostoreCityJsonProtoCityObjectGeometryMultiPoint
    multisurface: GeostoreCityJsonProtoCityObjectGeometryMultiSurface
    solid: GeostoreCityJsonProtoCityObjectGeometrySolid

@typing.type_check_only
class GeostoreCityJsonProtoCityObjectGeometryMultiPoint(
    typing_extensions.TypedDict, total=False
):
    xIndices: _list[int]

@typing.type_check_only
class GeostoreCityJsonProtoCityObjectGeometryMultiSurface(
    typing_extensions.TypedDict, total=False
):
    surfaces: _list[GeostoreCityJsonProtoCityObjectGeometrySurface]

@typing.type_check_only
class GeostoreCityJsonProtoCityObjectGeometrySolid(
    typing_extensions.TypedDict, total=False
):
    shells: _list[GeostoreCityJsonProtoCityObjectGeometryMultiSurface]

@typing.type_check_only
class GeostoreCityJsonProtoCityObjectGeometrySurface(
    typing_extensions.TypedDict, total=False
):
    loops: _list[GeostoreCityJsonProtoCityObjectGeometryMultiPoint]

@typing.type_check_only
class GeostoreCityJsonProtoTransform(typing_extensions.TypedDict, total=False):
    scale: float
    translate: GeostoreCityJsonProtoTransformTranslate

@typing.type_check_only
class GeostoreCityJsonProtoTransformTranslate(typing_extensions.TypedDict, total=False):
    x: float
    y: float
    z: float

@typing.type_check_only
class GeostoreComposableItemProto(typing_extensions.TypedDict, total=False):
    callToAction: GeostoreCallToActionProto
    jobMetadata: GeostoreJobMetadata
    media: _list[GeostoreMediaItemProto]
    nameInfo: _list[GeostorePriceListNameInfoProto]
    offered: typing_extensions.Literal[
        "OFFERED_UNSPECIFIED", "OFFERED", "OFFERED_NOT", "OFFERED_ON_WEBSITE"
    ]
    price: GeostorePriceRangeProto
    priceFormat: typing_extensions.Literal[
        "PRICE_FORMAT_DEFAULT", "PRICE_FORMAT_VARIES"
    ]
    rankingHint: float

@typing.type_check_only
class GeostoreCountComparisonProto(typing_extensions.TypedDict, total=False):
    comparisonOperator: typing_extensions.Literal[
        "UNSPECIFIED",
        "EQUAL",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL",
    ]
    count: int

@typing.type_check_only
class GeostoreCrossingStripePatternProto(typing_extensions.TypedDict, total=False):
    borderLine: GeostorePhysicalLineProto
    borderPattern: typing_extensions.Literal[
        "UNKNOWN_BORDER_PATTERN", "NO_BORDER_PATTERN", "SOLID", "DASHED"
    ]
    color: _list[GeostorePaintedElementLogicalColorProto]
    stripePattern: typing_extensions.Literal[
        "UNKNOWN_STRIPE_PATTERN",
        "NO_STRIPE_PATTERN",
        "LONGITUDINAL_STRIPE",
        "DIAGONAL_STRIPE",
        "LATERAL_STRIPE",
        "SINGLE_CROSSING_LINE",
        "DOUBLE_CROSSING_LINE",
        "TRIANGLE_CROSSING_LINE_POINTING_LEFT",
        "TRIANGLE_CROSSING_LINE_POINTING_RIGHT",
        "STRUCTURED_CROSSING_LINE",
    ]

@typing.type_check_only
class GeostoreCurvatureProto(typing_extensions.TypedDict, total=False):
    pointCurvature: _list[GeostorePointCurvatureProto]

@typing.type_check_only
class GeostoreCurveConnectionProto(typing_extensions.TypedDict, total=False):
    bezierParams: GeostoreCurveConnectionProtoBezierParams
    circleParams: GeostoreCurveConnectionProtoCircleParams
    type: typing_extensions.Literal["UNSPECIFIED", "BEZIER", "CIRCLE", "STRAIGHT_EDGE"]

@typing.type_check_only
class GeostoreCurveConnectionProtoBezierParams(
    typing_extensions.TypedDict, total=False
):
    controlPoint: _list[GeostoreCurveConnectionProtoBezierParamsControlPoint]

@typing.type_check_only
class GeostoreCurveConnectionProtoBezierParamsControlPoint(
    typing_extensions.TypedDict, total=False
):
    angleDegrees: float
    distanceMultiplier: float

@typing.type_check_only
class GeostoreCurveConnectionProtoCircleParams(
    typing_extensions.TypedDict, total=False
):
    radius: float

@typing.type_check_only
class GeostoreDataSourceProto(typing_extensions.TypedDict, total=False):
    attributionUrl: _list[GeostoreUrlProto]
    copyrightOwner: str
    copyrightYear: int
    description: str
    importerBuildInfo: str
    importerBuildTarget: str
    importerClientInfo: str
    importerMpmVersion: str
    importerTimestamp: str
    provider: typing_extensions.Literal[
        "PROVIDER_ANY",
        "PROVIDER_UNKNOWN",
        "PROVIDER_NAVTEQ",
        "PROVIDER_TELE_ATLAS",
        "PROVIDER_TELE_ATLAS_MULTINET",
        "PROVIDER_TELE_ATLAS_CODEPOINT",
        "PROVIDER_TELE_ATLAS_GEOPOST",
        "PROVIDER_TELE_ATLAS_DATAGEO",
        "PROVIDER_TELE_ATLAS_ADDRESS_POINTS",
        "PROVIDER_TELCONTAR",
        "PROVIDER_EUROPA",
        "PROVIDER_ROYAL_MAIL",
        "PROVIDER_GOOGLE",
        "PROVIDER_GOOGLE_HAND_EDIT",
        "PROVIDER_GOOGLE_BORDERS",
        "PROVIDER_GOOGLE_SUBRANGE",
        "PROVIDER_GOOGLE_GT_FUSION",
        "PROVIDER_GOOGLE_ZAGAT_CMS",
        "PROVIDER_GOOGLE_PLACE_NAVBOOST",
        "PROVIDER_GOOGLE_FOOTPRINT",
        "PROVIDER_GOOGLE_PRODUCT_TERMS",
        "PROVIDER_GOOGLE_POINTCARDS",
        "PROVIDER_GOOGLE_BUSINESS_CHAINS",
        "PROVIDER_GOOGLE_LOCAL_SUMMARIZATION",
        "PROVIDER_GOOGLE_PRONUNCIATIONS",
        "PROVIDER_GOOGLE_DUMPLING",
        "PROVIDER_GOOGLE_DISTILLERY",
        "PROVIDER_GOOGLE_LOCAL_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_RELATION_MINER",
        "PROVIDER_GOOGLE_MAPSPAM",
        "PROVIDER_GOOGLE_ROSE",
        "PROVIDER_GOOGLE_LOCAL_PLACE_RATINGS",
        "PROVIDER_GOOGLE_WIPEOUT",
        "PROVIDER_GOOGLE_KNOWLEDGE_GRAPH",
        "PROVIDER_GOOGLE_BEEGEES",
        "PROVIDER_GOOGLE_REVIEW_SUMMARIZATION",
        "PROVIDER_GOOGLE_OFFLINE_NON_CORE_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_GEO_WORLDMAPS",
        "PROVIDER_GOOGLE_GEO_MODERATION",
        "PROVIDER_GOOGLE_OYSTER_AUTO_EDITS",
        "PROVIDER_GOOGLE_LOCAL_ALCHEMY",
        "PROVIDER_GOOGLE_KEROUAC",
        "PROVIDER_GOOGLE_MOBRANK",
        "PROVIDER_GOOGLE_RAPTURE",
        "PROVIDER_GOOGLE_CULTURAL_INSTITUTE",
        "PROVIDER_GOOGLE_GEOCODES_FROM_LOCAL_FEEDS",
        "PROVIDER_GOOGLE_ATTRIBUTES_FROM_CRAWLED_CHAINS",
        "PROVIDER_GOOGLE_TACTILE_MAPS",
        "PROVIDER_GOOGLE_MAPS_FOR_MOBILE",
        "PROVIDER_GOOGLE_GEO_REALTIME",
        "PROVIDER_GOOGLE_PROMINENT_PLACES",
        "PROVIDER_GOOGLE_PLACE_ACTIONS",
        "PROVIDER_GOOGLE_GT_AUTO_EDITS",
        "PROVIDER_GOOGLE_WAZE",
        "PROVIDER_GOOGLE_ONTHEGO",
        "PROVIDER_GOOGLE_GT_IMPORT",
        "PROVIDER_GOOGLE_STRUCTURED_DATA",
        "PROVIDER_GOOGLE_HELICOPTER",
        "PROVIDER_GOOGLE_ROLLBACK",
        "PROVIDER_GOOGLE_RIGHTS_REPAIR",
        "PROVIDER_GOOGLE_PERFUME",
        "PROVIDER_GOOGLE_MAPS_TRANSLATION",
        "PROVIDER_GOOGLE_CALL_ME_MAYBE",
        "PROVIDER_GOOGLE_LOCAL_UNIVERSAL",
        "PROVIDER_GOOGLE_CROUPIER",
        "PROVIDER_GOOGLE_SKYSMART",
        "PROVIDER_GOOGLE_RIDDLER",
        "PROVIDER_GOOGLE_ROADCLOSURES",
        "PROVIDER_GOOGLE_SPORE",
        "PROVIDER_GOOGLE_LOCALIZATION",
        "PROVIDER_GOOGLE_CATTERMS",
        "PROVIDER_GOOGLE_GT_FIELD_OPS",
        "PROVIDER_GOOGLE_MATCHMAKER",
        "PROVIDER_GOOGLE_ARBITRATION",
        "PROVIDER_GOOGLE_BIZBUILDER_OPS",
        "PROVIDER_GOOGLE_LOCAL_INVENTORY_ADS",
        "PROVIDER_GOOGLE_GT_DRAFTY",
        "PROVIDER_GOOGLE_HOTELADS_OPS",
        "PROVIDER_GOOGLE_MARKERS",
        "PROVIDER_GOOGLE_STATE_MACHINE",
        "PROVIDER_GOOGLE_ATTRIBUTES_INFERENCE",
        "PROVIDER_GOOGLE_BIKESHARE",
        "PROVIDER_GOOGLE_GHOSTWRITER",
        "PROVIDER_GOOGLE_EDIT_PLATFORM",
        "PROVIDER_GOOGLE_BLUE_GINGER",
        "PROVIDER_GOOGLE_GEO_TIGER",
        "PROVIDER_GOOGLE_HYADES",
        "PROVIDER_GOOGLE_WEBQUARRY",
        "PROVIDER_GOOGLE_GEO_MADDEN",
        "PROVIDER_GOOGLE_ANDROID_PAY",
        "PROVIDER_GOOGLE_OPENING_HOURS_TEAM",
        "PROVIDER_GOOGLE_LOCAL_DISCOVERY",
        "PROVIDER_GOOGLE_LOCAL_HEALTH",
        "PROVIDER_GOOGLE_UGC_MAPS",
        "PROVIDER_GOOGLE_FIBER",
        "PROVIDER_GOOGLE_REVGEO",
        "PROVIDER_GOOGLE_HOTELADS_PARTNER_FRONT_END",
        "PROVIDER_GOOGLE_GEO_UGC_TASKS",
        "PROVIDER_GOOGLE_GEOCODING",
        "PROVIDER_GOOGLE_SPYGLASS",
        "PROVIDER_GOOGLE_PLUS_CODES_AS_ADDRESSES",
        "PROVIDER_GOOGLE_GEO_CHANGES",
        "PROVIDER_GOOGLE_HUME",
        "PROVIDER_GOOGLE_MEGAMIND",
        "PROVIDER_GOOGLE_GT_ROADSYNTH",
        "PROVIDER_GOOGLE_FIREBOLT",
        "PROVIDER_GOOGLE_LOCAL_PLACE_OFFERINGS",
        "PROVIDER_GOOGLE_UGC_SERVICES",
        "PROVIDER_GOOGLE_GEOALIGN",
        "PROVIDER_GOOGLE_GT_COMPOUNDS",
        "PROVIDER_GOOGLE_FOOD_ORDERING",
        "PROVIDER_GOOGLE_HOTEL_KNOWLEDGE_OPS",
        "PROVIDER_GOOGLE_URAW",
        "PROVIDER_GOOGLE_FLYEYE",
        "PROVIDER_GOOGLE_YOUKE",
        "PROVIDER_GOOGLE_GT_ZEPHYR",
        "PROVIDER_GOOGLE_USER_SAFETY",
        "PROVIDER_GOOGLE_ADDRESS_MAKER",
        "PROVIDER_GOOGLE_UGC_PHOTOS",
        "PROVIDER_GOOGLE_GT_WINDCHIME",
        "PROVIDER_GOOGLE_SNAG_FIXER",
        "PROVIDER_GOOGLE_GEO_DEALS",
        "PROVIDER_GOOGLE_LOCAL_PLACE_TOPICS",
        "PROVIDER_GOOGLE_PROPERTY_INSIGHTS",
        "PROVIDER_GOOGLE_GEO_CONSUMER_MERCHANT_EXPERIMENTS",
        "PROVIDER_GOOGLE_GEO_PORTKEY",
        "PROVIDER_GOOGLE_ROAD_MAPPER",
        "PROVIDER_GOOGLE_LOCATION_PLATFORM",
        "PROVIDER_GOOGLE_POSTTRIP",
        "PROVIDER_GOOGLE_TRAVEL_DESTINATION",
        "PROVIDER_GOOGLE_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_BIZBUILDER_CLEANUP",
        "PROVIDER_GOOGLE_USER",
        "PROVIDER_GOOGLE_STATION",
        "PROVIDER_GOOGLE_GEO_FOOD",
        "PROVIDER_GOOGLE_GEO_AR",
        "PROVIDER_GOOGLE_GEO_TEMPORAL",
        "PROVIDER_GOOGLE_SERVICES_MARKETPLACE",
        "PROVIDER_GOOGLE_IMT_CLEANUP",
        "PROVIDER_GOOGLE_GEO_FOOD_MENU",
        "PROVIDER_GOOGLE_CARENAV",
        "PROVIDER_GOOGLE_DRIVING_FEEDS",
        "PROVIDER_GOOGLE_DRIVING_UGC",
        "PROVIDER_GOOGLE_POLAR",
        "PROVIDER_GOOGLE_TRIWILD",
        "PROVIDER_GOOGLE_CROWD_COMPUTE_OPS",
        "PROVIDER_GOOGLE_SA_FROM_WEB",
        "PROVIDER_GOOGLE_POI_ALIGNMENT",
        "PROVIDER_GOOGLE_SA_FROM_HULK",
        "PROVIDER_GOOGLE_SERVICES_INTERACTIONS",
        "PROVIDER_GOOGLE_ROADS_UGC_EDITOR",
        "PROVIDER_GOOGLE_SA_FROM_NG_INFERENCE",
        "PROVIDER_GOOGLE_GEO_DRIVING_VIZ",
        "PROVIDER_GOOGLE_GEO_TASKING",
        "PROVIDER_GOOGLE_CROWDTASK_DATACOMPUTE",
        "PROVIDER_GOOGLE_CROWDTASK_TASKADS",
        "PROVIDER_GOOGLE_CROWDTASK_TASKMATE",
        "PROVIDER_GOOGLE_CROWDTASK_FURBALL",
        "PROVIDER_GOOGLE_CROWDTASK_ADAP",
        "PROVIDER_GOOGLE_GPAY",
        "PROVIDER_GOOGLE_GEO_UGC_TRUSTED_USERS",
        "PROVIDER_GOOGLE_THIRD_PARTY_DATA_PRODUCTION",
        "PROVIDER_GOOGLE_GEOTRACKER",
        "PROVIDER_GOOGLE_LOCAL_LANDMARK_INFERENCE",
        "PROVIDER_GOOGLE_GEO_CLOSED_LOOP",
        "PROVIDER_GOOGLE_SA_FROM_MERCHANT_POSTS",
        "PROVIDER_GOOGLE_CORE_DATA_RIGHTS",
        "PROVIDER_GOOGLE_SA_FROM_USER_REVIEWS",
        "PROVIDER_GOOGLE_GEO_CONTENT_FIXER",
        "PROVIDER_GOOGLE_POLYGON_REFINEMENT",
        "PROVIDER_GOOGLE_HANASU",
        "PROVIDER_GOOGLE_FULLRIGHTS_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_FULLRIGHTS_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_ATTRIBUTION_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_SA_FROM_FOOD_MENUS",
        "PROVIDER_GOOGLE_GT_CONSISTENCY_EDITS",
        "PROVIDER_GOOGLE_SA_QUALITY",
        "PROVIDER_GOOGLE_GDCE_CLEANUP",
        "PROVIDER_GOOGLE_UGC_QUALITY_CHAINS",
        "PROVIDER_GOOGLE_ATTRIBUTES_DISCOVERY",
        "PROVIDER_GOOGLE_GEO_LDE",
        "PROVIDER_GOOGLE_GEO_SIGNAL_TRACKING",
        "PROVIDER_GOOGLE_UGC_AGGREGATION",
        "PROVIDER_GOOGLE_3D_BASEMAP",
        "PROVIDER_GOOGLE_MAPFACTS_PRIVACY",
        "PROVIDER_GOOGLE_GT_ALF",
        "PROVIDER_GOOGLE_GT_OPERATOR_PROVENANCE",
        "PROVIDER_GOOGLE_LOCAL_SERVICES_ADS",
        "PROVIDER_GOOGLE_GT_LANE_AUTOMATION",
        "PROVIDER_GOOGLE_GEO_NG_LOCAL",
        "PROVIDER_GOOGLE_MAPFACTS_CLEANUP",
        "PROVIDER_GOOGLE_THIRD_PARTY_UGC",
        "PROVIDER_GOOGLE_GEO_ISSUE_ADMIN",
        "PROVIDER_GOOGLE_LOCALSEARCH",
        "PROVIDER_GOOGLE_TRANSIT",
        "PROVIDER_GOOGLE_GEOWIKI",
        "PROVIDER_GOOGLE_CHINA_LOCAL_TEAM",
        "PROVIDER_GOOGLE_SYNTHESIZED",
        "PROVIDER_GOOGLE_INTERNAL_TEST",
        "PROVIDER_GOOGLE_DISPUTED_AREAS",
        "PROVIDER_GOOGLE_3DWAREHOUSE",
        "PROVIDER_GOOGLE_GROUNDS_BUILDER",
        "PROVIDER_GOOGLE_SESAME",
        "PROVIDER_GOOGLE_GT",
        "PROVIDER_GOOGLE_GT_BASEMAP_UPLOAD",
        "PROVIDER_GOOGLE_ADSDB",
        "PROVIDER_GOOGLE_MACHINE_TRANSLITERATION",
        "PROVIDER_GOOGLE_TRAVELSEARCH",
        "PROVIDER_GOOGLE_PANORAMIO",
        "PROVIDER_GOOGLE_YOUTUBE",
        "PROVIDER_GOOGLE_OLD",
        "PROVIDER_GOOGLE_STREETVIEW",
        "PROVIDER_GOOGLE_STREETVIEW_BIZVIEW",
        "PROVIDER_GOOGLE_ZIPIT",
        "PROVIDER_GOOGLE_OYSTER_CONNECT_ROUTES",
        "PROVIDER_GOOGLE_GOLDEN",
        "PROVIDER_GOOGLE_INNERSPACE",
        "PROVIDER_GOOGLE_MAPSEARCH",
        "PROVIDER_GOOGLE_CATEGORIES_TEAM",
        "PROVIDER_GOOGLE_CROWDSENSUS",
        "PROVIDER_GOOGLE_LOCAL_ALGORITHMIC_IDENTITY",
        "PROVIDER_GOOGLE_FREEBASE",
        "PROVIDER_GOOGLE_HOTELADS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGES",
        "PROVIDER_GOOGLE_PLACES_API",
        "PROVIDER_GOOGLE_NAMEHEATMAP",
        "PROVIDER_GOOGLE_MAPMAKER",
        "PROVIDER_GOOGLE_MAPMAKER_MOBILE",
        "PROVIDER_GOOGLE_MAPMAKER_PANCAKE",
        "PROVIDER_GOOGLE_MAPMAKER_V2",
        "PROVIDER_GOOGLE_LOCAL_CLUSTERING_OPERATOR_OVERRIDE",
        "PROVIDER_GOOGLE_SERVED_ON_MAPMAKER",
        "PROVIDER_GOOGLE_GT_LOCAL",
        "PROVIDER_GOOGLE_GT_LOCAL_WITH_RIGHTS",
        "PROVIDER_GOOGLE_LOGS_RANKING_SIGNALS",
        "PROVIDER_GOOGLE_ENTITY_NAVBOOST",
        "PROVIDER_GOOGLE_RELATED_PLACES",
        "PROVIDER_GOOGLE_KNOWN_FOR_TERMS",
        "PROVIDER_GOOGLE_SYNTHETIC_AREAS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGE_PHOTOS",
        "PROVIDER_GOOGLE_CROSS_STREETS",
        "PROVIDER_GOOGLE_CORRIDORS",
        "PROVIDER_GOOGLE_BICYCLE_RENTAL",
        "PROVIDER_GOOGLE_CONCRETE_URLS",
        "PROVIDER_GOOGLE_LEANBACK",
        "PROVIDER_GOOGLE_LOCKED_LISTINGS",
        "PROVIDER_GOOGLE_MONITORING",
        "PROVIDER_GOOGLE_SPROUT",
        "PROVIDER_GOOGLE_LOCAL_SEARCH_QUALITY",
        "PROVIDER_GOOGLE_GOBY",
        "PROVIDER_GOOGLE_PROBLEM_REPORT",
        "PROVIDER_GOOGLE_CANDID",
        "PROVIDER_GOOGLE_BIZBUILDER",
        "PROVIDER_AUTOMOTIVE_NAVIGATION_DATA",
        "PROVIDER_MAPDATA_SCIENCES",
        "PROVIDER_MAPONICS",
        "PROVIDER_SKI_RESORTS",
        "PROVIDER_ZENRIN",
        "PROVIDER_SANBORN",
        "PROVIDER_URBAN_MAPPING",
        "PROVIDER_US_GOVERNMENT",
        "PROVIDER_US_CENSUS",
        "PROVIDER_US_POSTAL_SERVICE",
        "PROVIDER_US_GEOLOGICAL_SURVEY",
        "PROVIDER_US_GNIS",
        "PROVIDER_US_LANDSAT",
        "PROVIDER_US_NATIONAL_GEOSPATIAL_INTELLIGENCE_AGENCY",
        "PROVIDER_US_NGA_GNS",
        "PROVIDER_US_SSIBL",
        "PROVIDER_US_BUREAU_OF_TRANSPORTATION_STATISTICS",
        "PROVIDER_US_NATIONAL_OCEANIC_AND_ATMOSPHERIC_ADMINISTRATION",
        "PROVIDER_US_POLAR_GEOSPATIAL_CENTER",
        "PROVIDER_US_DEPARTMENT_OF_AGRICULTURE",
        "PROVIDER_US_NPI_REGISTRY",
        "PROVIDER_US_BUREAU_OF_INDIAN_AFFAIRS",
        "PROVIDER_DMTI_SPATIAL",
        "PROVIDER_INTERNATIONAL_HYDROGRAPHIC_ORGANIZATION",
        "PROVIDER_MAPLINK",
        "PROVIDER_KINGWAY",
        "PROVIDER_GEOCENTRE",
        "PROVIDER_CN_NATIONAL_FOUNDAMENTAL_GIS",
        "PROVIDER_CN_MAPABC",
        "PROVIDER_SMITHSONIAN_INSTITUTE",
        "PROVIDER_TRACKS_FOR_AFRICA",
        "PROVIDER_PPWK",
        "PROVIDER_LEADDOG",
        "PROVIDER_CENTRE_DONNEES_ASTRONOMIQUES_STRASBOURG",
        "PROVIDER_GISRAEL",
        "PROVIDER_BASARSOFT",
        "PROVIDER_MAPINFO",
        "PROVIDER_MAPIT",
        "PROVIDER_GEOBASE",
        "PROVIDER_ORION",
        "PROVIDER_CENTRAL_EUROPEAN_DATA_AGENCY",
        "PROVIDER_ANASAT",
        "PROVIDER_MINED_POSTCODES",
        "PROVIDER_DMAPAS",
        "PROVIDER_COMMON_LOCALE_DATA_REPOSITORY",
        "PROVIDER_CH_SBB",
        "PROVIDER_SKENERGY",
        "PROVIDER_GBRMPA",
        "PROVIDER_KOREA_POST",
        "PROVIDER_CN_AUTONAVI",
        "PROVIDER_MINED_POI",
        "PROVIDER_ML_INFOMAP",
        "PROVIDER_SNOOPER",
        "PROVIDER_GEOSISTEMAS",
        "PROVIDER_AFRIGIS",
        "PROVIDER_TRANSNAVICOM",
        "PROVIDER_EASYCONNECT",
        "PROVIDER_LANTMATERIET",
        "PROVIDER_LOGICA",
        "PROVIDER_MAPKING",
        "PROVIDER_DIANPING",
        "PROVIDER_GEONAV",
        "PROVIDER_HEIBONSHA",
        "PROVIDER_DEUTSCHE_TELEKOM",
        "PROVIDER_LINGUISTIC_DATA_CONSORTIUM",
        "PROVIDER_ACXIOM",
        "PROVIDER_DUN_AND_BRADSTREET",
        "PROVIDER_FEDERAL_AVIATION_ADMINISTRATION",
        "PROVIDER_INFOUSA",
        "PROVIDER_INFOUSA_NIXIE",
        "PROVIDER_THOMSON_LOCAL",
        "PROVIDER_TELEFONICA_PUBLICIDAD_E_INFORMACION",
        "PROVIDER_WIKIPEDIA",
        "PROVIDER_INFOBEL",
        "PROVIDER_MX_GOVERNMENT",
        "PROVIDER_MX_NATIONAL_INSTITUTE_STATISTICS_GEOGRAPHY",
        "PROVIDER_MX_SERVICIO_POSTAL_MEXICANO",
        "PROVIDER_TELEGATE",
        "PROVIDER_TELELISTAS",
        "PROVIDER_MAPCITY",
        "PROVIDER_EXPLAINER_DC",
        "PROVIDER_DAIKEI",
        "PROVIDER_NL_CHAMBER_OF_COMMERCE",
        "PROVIDER_KOREA_INFO_SERVICE",
        "PROVIDER_WIKITRAVEL",
        "PROVIDER_FLICKR",
        "PROVIDER_DIANCO",
        "PROVIDER_VOLT_DELTA",
        "PROVIDER_SG_GOVERNMENT",
        "PROVIDER_SG_LAND_TRANSPORT_AUTHORITY",
        "PROVIDER_MAPBAR",
        "PROVIDER_LONGTU",
        "PROVIDER_SA_GOVERNMENT",
        "PROVIDER_SA_SAUDI_POST",
        "PROVIDER_PEAKLIST",
        "PROVIDER_LOCAL_BUSINESS_CENTER",
        "PROVIDER_LOCAL_FEED_XML",
        "PROVIDER_WEB",
        "PROVIDER_RAILS_TO_TRAILS",
        "PROVIDER_INDIACOM",
        "PROVIDER_INFOMEDIA",
        "PROVIDER_PICASA",
        "PROVIDER_AT_GOVERNMENT",
        "PROVIDER_AT_BUNDESAMT_FUR_EICH_UND_VERMESSUNGSWESEN",
        "PROVIDER_AT_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_AT_AUSTRIA_POST",
        "PROVIDER_NO_GOVERNMENT",
        "PROVIDER_NO_NORSK_EIENDOMSINFORMASJON",
        "PROVIDER_NO_POSTEN_NORGE_AS",
        "PROVIDER_CH_GOVERNMENT",
        "PROVIDER_CH_SWISS_POST",
        "PROVIDER_CH_SWISSTOPO",
        "PROVIDER_CH_SWISS_NATIONAL_PARK",
        "PROVIDER_NAVIT",
        "PROVIDER_GEOSEARCH",
        "PROVIDER_DE_GOVERNMENT",
        "PROVIDER_BUNDESAMT_KARTOGRAPHIE_UND_GEODASIE",
        "PROVIDER_BUNDESNETZAGENTUR",
        "PROVIDER_SCHOBER_GROUP",
        "PROVIDER_MIREO",
        "PROVIDER_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WEBSTER_TEXAS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_AMHERST_MASSACHUSETTS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BLOOMINGTON_INDIANA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PASADENA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_CHULA_VISTA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_TEMPE_ARIZONA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_COLUMBUS_OHIO",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PORTAGE_MICHIGAN",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GEORGETOWN_KENTUCKY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GREENVILLE_SOUTH_CAROLINA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_NASHVILLE_TENNESSEE",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WASHINGTON_DISTRICT_OF_COLUMBIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BOULDER_COLORADO",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY_ENVIRONMENT_BAY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY_BIELSKO_BIALA",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_FRANKFURT",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_HAMBURG",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_KARLSRUHE",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY_SANTA_CRUZ",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_KLAGENFURT",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_LINZ",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_AZKOITIA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_BEASAIN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_GIRONA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_SAN_SEBASTIAN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_CATALUNYA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_HONDARRIBIA",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY_LAUNCESTON_TASMANIA",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY_REYKJAVIK",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY_AMELSTEVEEN",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY_ANTWERPEN",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_FREDERICTON_NEW_BRUNSWICK",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_KAMLOOPS_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_NANAIMO_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_BANFF_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_CALGARY_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_TORONTO_ONTARIO",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY_UMEA",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY_KHARKIV",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY_AQUA_CALIENTE_CAHUILLA_INDIANS",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_PONT_AUDEMER",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_BORDEAUX",
        "PROVIDER_SG_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY_RIO_DE_JANEIRO",
        "PROVIDER_MAPCUBE",
        "PROVIDER_3D_REALITYMAPS",
        "PROVIDER_DEUTSCHES_ZENTRUM_FUR_LUFT_UND_RAUMFAHRT",
        "PROVIDER_3D_CITIES_SOCIEDADE_ANONIMA",
        "PROVIDER_DISNEY",
        "PROVIDER_CYBERCITY",
        "PROVIDER_PRECISION_LIGHTWORKS_MODELWORKS",
        "PROVIDER_VIRTUAL_HUNGARY_LIMITED",
        "PROVIDER_VIRTUEL_CITY",
        "PROVIDER_SCREAMPOINT_INTERNATIONAL",
        "PROVIDER_AGENTSCHAP_VOOR_GEOGRAFISCHE_INFORMATIE_VLAANDEREN",
        "PROVIDER_FR_GOVERNMENT",
        "PROVIDER_FR_INSTITUT_GEOGRAPHIQUE_NATIONAL",
        "PROVIDER_FR_CADASTRE",
        "PROVIDER_DIADIEM",
        "PROVIDER_THE_WEATHER_CHANNEL",
        "PROVIDER_COWI",
        "PROVIDER_FALKPLAN_ANDES",
        "PROVIDER_NL_GOVERNMENT",
        "PROVIDER_NL_KADASTER",
        "PROVIDER_NL_BOARD_OF_TOURISM_AND_CONVENTIONS",
        "PROVIDER_DIGITAL_MAP_PRODUCTS",
        "PROVIDER_SILICE_DIGITAL",
        "PROVIDER_TYDAC",
        "PROVIDER_ALBRECHT_GOLF",
        "PROVIDER_HEALTH_CH",
        "PROVIDER_VISITDENMARK",
        "PROVIDER_FLYHERE",
        "PROVIDER_DIGITAL_DATA_SERVICES",
        "PROVIDER_MECOMO",
        "PROVIDER_ZA_GOVERNMENT",
        "PROVIDER_ZA_RURAL_DEVELOPMENT_LAND_REFORM",
        "PROVIDER_SENSIS",
        "PROVIDER_JJCONNECT",
        "PROVIDER_OPPLYSNINGEN",
        "PROVIDER_TELLUS",
        "PROVIDER_IQONIA",
        "PROVIDER_BE_GOVERNMENT",
        "PROVIDER_BE_NATIONAAL_GEOGRAFISCH_INSTITUUT",
        "PROVIDER_BE_BRUSSELS_MOBILITY",
        "PROVIDER_YELLOWMAP_AG",
        "PROVIDER_STIFTUNG_GESUNDHEIT",
        "PROVIDER_GIATA",
        "PROVIDER_SANPARKS",
        "PROVIDER_CENTRE_DINFORMATIQUE_POUR_LA_REGION_BRUXELLOISE",
        "PROVIDER_INFOPORTUGAL",
        "PROVIDER_NEGOCIOS_DE_TELECOMUNICACOES_E_SISTEMAS_DE_INFORMACAO",
        "PROVIDER_COLLINS_BARTHOLOMEW",
        "PROVIDER_PROTECT_PLANET_OCEAN",
        "PROVIDER_KARTTAKESKUS",
        "PROVIDER_FI_GOVERNMENT",
        "PROVIDER_FI_NATIONAL_ROAD_ADMINISTRATION",
        "PROVIDER_FI_NATIONAL_LAND_SURVEY",
        "PROVIDER_FI_STATISTICS_FINLAND",
        "PROVIDER_GB_GOVERNMENT",
        "PROVIDER_GB_ORDNANCE_SURVEY",
        "PROVIDER_NATURAL_ENGLAND",
        "PROVIDER_WELSH_GOVERNMENT",
        "PROVIDER_GB_OFFICE_FOR_NATIONAL_STATISTICS",
        "PROVIDER_EPSILON",
        "PROVIDER_PARTNER_FRONT_END",
        "PROVIDER_CARTESIA",
        "PROVIDER_SE_GOVERNMENT",
        "PROVIDER_SE_TRAFIKVERKET",
        "PROVIDER_SE_NATURVARDSVERKET",
        "PROVIDER_IE_GOVERNMENT",
        "PROVIDER_IE_ORDNANCE_SURVEY_IRELAND",
        "PROVIDER_LU_GOVERNMENT",
        "PROVIDER_LU_P_AND_T_LUXEMBOURG",
        "PROVIDER_LU_ADMINISTRATION_DU_CADASTRE_ET_DE_LA_TOPOGRAPHIE",
        "PROVIDER_LU_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_MAPFLOW",
        "PROVIDER_TKARTOR",
        "PROVIDER_JUMPSTART",
        "PROVIDER_EPTISA",
        "PROVIDER_MC_GOVERNMENT",
        "PROVIDER_MC_PRINCIPAUTE_DE_MONACO",
        "PROVIDER_MONOLIT",
        "PROVIDER_ENVIRONMENTAL_SYSTEMS_RESEARCH_INSTITUTE",
        "PROVIDER_MODIS",
        "PROVIDER_GEOX",
        "PROVIDER_GEODIRECTORY",
        "PROVIDER_GEOPLAN",
        "PROVIDER_INFODIREKT",
        "PROVIDER_GEOGLOBAL",
        "PROVIDER_DEUTSCHE_POST",
        "PROVIDER_TRACASA",
        "PROVIDER_CORREOS",
        "PROVIDER_ES_GOVERNMENT",
        "PROVIDER_ES_CENTRO_NACIONAL_DE_INFORMACION_GEOGRAFICA",
        "PROVIDER_EDIMAP",
        "PROVIDER_VERIZON",
        "PROVIDER_NATIONAL_GEOGRAPHIC_MAPS",
        "PROVIDER_PROMAPS",
        "PROVIDER_CONSODATA",
        "PROVIDER_DE_AGOSTINI",
        "PROVIDER_FEDERPARCHI",
        "PROVIDER_NAVIGO",
        "PROVIDER_ITALIAMAPPE",
        "PROVIDER_CZECOT",
        "PROVIDER_NATURAL_EARTH",
        "PROVIDER_REGIO",
        "PROVIDER_SHIPWRECK_CENTRAL",
        "PROVIDER_RUTGERS_STATE_UNIVERSITY",
        "PROVIDER_TWINICE",
        "PROVIDER_NORTHERN_IRELAND_TOURIST_BOARD",
        "PROVIDER_INFOGROUP",
        "PROVIDER_TNET",
        "PROVIDER_CTT_CORREIOS_DE_PORTUGAL",
        "PROVIDER_EUROPARC",
        "PROVIDER_IUPPITER",
        "PROVIDER_MICHAEL_BAUER_INTERNATIONAL",
        "PROVIDER_LEPTON",
        "PROVIDER_MAPPOINT",
        "PROVIDER_GEODATA",
        "PROVIDER_RU_GOVERNMENT",
        "PROVIDER_RU_FNS_KLADR",
        "PROVIDER_BR_GOVERNMENT",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DO_MEIO_AMBIENTE_E_DOS_RECURSOS_NATURAIS_RENOVAVEIS",
        "PROVIDER_BR_MINISTERIO_DO_MEIO_AMBIENTE",
        "PROVIDER_BR_AGENCIA_NACIONAL_DE_AGUAS",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DE_GEOGRAFIA_E_ESTATISTICA",
        "PROVIDER_BR_FUNDACAO_NACIONAL_DO_INDIO",
        "PROVIDER_BR_DEPARTAMENTO_NACIONAL_DE_INFRAESTRUTURA_DE_TRANSPORTES",
        "PROVIDER_AZAVEA",
        "PROVIDER_NORTHSTAR",
        "PROVIDER_COMMEDI",
        "PROVIDER_NEXUS_GEOGRAFICS",
        "PROVIDER_INFOERA",
        "PROVIDER_AD_GOVERNMENT",
        "PROVIDER_AD_AREA_DE_CARTOGRAFIA",
        "PROVIDER_MAXXIMA",
        "PROVIDER_SI_GOVERNMENT",
        "PROVIDER_SI_AGENCY_FOR_ENVIRONMENT",
        "PROVIDER_TRANSPORT_HI_TECH_CONSULTANTS",
        "PROVIDER_L1_TECHNOLOGIES",
        "PROVIDER_TELEMEDIA",
        "PROVIDER_CDCOM_PROGOROD",
        "PROVIDER_MIT_CITYGUIDE",
        "PROVIDER_SUNCART",
        "PROVIDER_MICROMAPPER",
        "PROVIDER_RICHI",
        "PROVIDER_FORUM44",
        "PROVIDER_SEAT",
        "PROVIDER_VALASSIS",
        "PROVIDER_NAVICOM",
        "PROVIDER_COLTRACK",
        "PROVIDER_PSMA_AUSTRALIA",
        "PROVIDER_PT_DUTA_ASTAKONA_GIRINDA",
        "PROVIDER_CA_GOVERNMENT",
        "PROVIDER_STATISTICS_CANADA",
        "PROVIDER_TOCTOC",
        "PROVIDER_RMSI",
        "PROVIDER_TRUE_TECHNOLOGY",
        "PROVIDER_INCREMENT_P_CORPORATION",
        "PROVIDER_GOJAVAS",
        "PROVIDER_GEOINFORMATION_GROUP",
        "PROVIDER_CYBERSOFT",
        "PROVIDER_TSENTR_EFFEKTIVNYKH_TEKHNOLOGIY",
        "PROVIDER_EE_GOVERNMENT",
        "PROVIDER_EE_MAA_AMET",
        "PROVIDER_GASBUDDY",
        "PROVIDER_DK_GOVERNMENT",
        "PROVIDER_DK_GEODATASTYRELSEN",
        "PROVIDER_MURCIA_REGION_GOVERNMENT",
        "PROVIDER_CORREIOS",
        "PROVIDER_WEST_WORLD_MEDIA",
        "PROVIDER_INTERNATIONAL_MAPPING_ASSOCIATION",
        "PROVIDER_MEDICARE",
        "PROVIDER_POLARIS",
        "PROVIDER_TW_GOVERNMENT",
        "PROVIDER_TW_MINISTRY_OF_THE_INTERIOR_SURVEYING_AND_MAPPING_CENTER",
        "PROVIDER_NORDECA",
        "PROVIDER_AFRIMAPPING",
        "PROVIDER_OVERDRIVE",
        "PROVIDER_PROVIDER_NETWORK_DIRECTORIES",
        "PROVIDER_BR_MINISTERIO_DA_SAUDE",
        "PROVIDER_DIGITAL_EGYPT",
        "PROVIDER_INRIX",
        "PROVIDER_ARPINDO",
        "PROVIDER_IT_GOVERNMENT",
        "PROVIDER_ISTITUTO_GEOGRAFICO_MILITARE",
        "PROVIDER_EAST_END_GROUP",
        "PROVIDER_INGEOLAN",
        "PROVIDER_SEMACONNECT",
        "PROVIDER_BLINK",
        "PROVIDER_EVGO",
        "PROVIDER_CHARGEPOINT",
        "PROVIDER_TPL_TRAKKER",
        "PROVIDER_OI",
        "PROVIDER_MAPARADAR",
        "PROVIDER_SINGAPORE_POST",
        "PROVIDER_CHARGEMASTER",
        "PROVIDER_TESLA",
        "PROVIDER_VISICOM",
        "PROVIDER_GEOLYSIS",
        "PROVIDER_ZEPHEIRA",
        "PROVIDER_HUBJECT",
        "PROVIDER_PODPOINT",
        "PROVIDER_CHARGEFOX",
        "PROVIDER_KR_GOVERNMENT",
        "PROVIDER_KR_MOLIT",
        "PROVIDER_KR_MINISTRY_OF_THE_INTERIOR_AND_SAFETY",
        "PROVIDER_CRITCHLOW",
        "PROVIDER_EIFRIG",
        "PROVIDER_GIREVE",
        "PROVIDER_CN_NAVINFO",
        "PROVIDER_JAPAN_CHARGE_NETWORK",
        "PROVIDER_NOBIL",
        "PROVIDER_INDIA_BANKS",
        "PROVIDER_INDONESIA_ELECTION_KPU",
        "PROVIDER_CAREERS360",
        "PROVIDER_SOURCE_LONDON",
        "PROVIDER_EVBOX",
        "PROVIDER_JP_GOVERNMENT",
        "PROVIDER_JP_MINISTRY_OF_THE_ENVIRONMENT",
        "PROVIDER_YUMYUM",
        "PROVIDER_HWW_AUSTRALIA",
        "PROVIDER_CINERGY",
        "PROVIDER_MTIME",
        "PROVIDER_KULTUNAUT",
        "PROVIDER_BLITZ",
        "PROVIDER_PIA",
        "PROVIDER_INTERPARK",
        "PROVIDER_CINEMA_ONLINE",
        "PROVIDER_BELBIOS",
        "PROVIDER_MOVIESEER",
        "PROVIDER_SODAMEDYA",
        "PROVIDER_ATMOVIES",
        "PROVIDER_HOTELBEDS",
        "PROVIDER_VERICRED",
        "PROVIDER_CIRRANTIC",
        "PROVIDER_GOGO_LABS",
        "PROVIDER_ELECTRIFY_AMERICA",
        "PROVIDER_CMS_MPPUF",
        "PROVIDER_DIGIROAD",
        "PROVIDER_KONTEX_GEOMATICS",
        "PROVIDER_NZ_GOVERNMENT",
        "PROVIDER_NZ_LINZ",
        "PROVIDER_NZ_DOC",
        "PROVIDER_FASTNED",
        "PROVIDER_DESTINY_CS",
        "PROVIDER_IONITY",
        "PROVIDER_EV_CONNECT",
        "PROVIDER_PANPAGES",
        "PROVIDER_ETECNIC",
        "PROVIDER_VOLTA",
        "PROVIDER_NISSAN_MEXICO",
        "PROVIDER_BMW_GROUP_LATIN_AMERICA",
        "PROVIDER_FEDERAL_ELECTRICITY_COMMISSION_MEXICO",
        "PROVIDER_VOLVO_CARS_BRASIL",
        "PROVIDER_CHARGE_AND_PARKING",
        "PROVIDER_DEDUCE_TECHNOLOGIES",
        "PROVIDER_SK_TELECOM",
        "PROVIDER_ECO_MOVEMENT",
        "PROVIDER_GOOGLE_GMS",
        "PROVIDER_EASYWAY",
        "PROVIDER_PHYSICIAN_COMPARE",
        "PROVIDER_HOSPITAL_COMPARE",
        "PROVIDER_ENDOLLA_BARCELONA",
        "PROVIDER_BE_CHARGE",
        "PROVIDER_ONE_NETWORK",
        "PROVIDER_CARENAV_DUPLEX",
        "PROVIDER_CARENAV_POI",
        "PROVIDER_IN_GOVERNMENT",
        "PROVIDER_SURVEY_OF_INDIA",
        "PROVIDER_E_ON",
        "PROVIDER_ELECTRIFY_CANADA",
        "PROVIDER_GRIDCARS",
        "PROVIDER_DRIVECO",
        "PROVIDER_GREEN_ACTION_STUDIOS",
        "PROVIDER_GREEN_ACTION_STUDIO",
        "PROVIDER_EVINY",
        "PROVIDER_MASTERCARD",
        "PROVIDER_VATTENFALL",
        "PROVIDER_VIETGIS",
        "PROVIDER_UNITE",
        "PROVIDER_NEOGY",
        "PROVIDER_AMPUP",
        "PROVIDER_LOOP",
        "PROVIDER_ZEST",
        "PROVIDER_EZVOLT",
        "PROVIDER_JOLT",
        "PROVIDER_CHARGESMITH",
        "PROVIDER_PLUGO",
        "PROVIDER_ELECTRIC_ERA",
    ]
    rawMetadata: _list[GeostoreRawMetadataProto]
    release: str
    releaseDate: GeostoreDateTimeProto
    sourceDataset: str

@typing.type_check_only
class GeostoreDateTimeProto(typing_extensions.TypedDict, total=False):
    precision: typing_extensions.Literal[
        "PRECISION_CENTURY",
        "PRECISION_DECADE",
        "PRECISION_YEAR",
        "PRECISION_MONTH",
        "PRECISION_DAY",
        "PRECISION_HOUR",
        "PRECISION_MINUTE",
        "PRECISION_SECOND",
    ]
    seconds: float

@typing.type_check_only
class GeostoreDimensionComparisonProto(typing_extensions.TypedDict, total=False):
    comparisonOperator: typing_extensions.Literal[
        "UNSPECIFIED",
        "EQUAL",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL",
    ]
    dimensionWithUnit: GeostoreDimensionProto

@typing.type_check_only
class GeostoreDimensionProto(typing_extensions.TypedDict, total=False):
    dimension: float
    unit: typing_extensions.Literal["UNIT_UNKNOWN", "METERS", "FEET"]

@typing.type_check_only
class GeostoreDisplayDataProto(typing_extensions.TypedDict, total=False):
    displayLocation: GeostorePointProto

@typing.type_check_only
class GeostoreDisputedAreaProto(typing_extensions.TypedDict, total=False):
    administeredBy: str
    claimant: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreDoodleProto(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_USER_DEFINED_LABEL",
        "TYPE_POINT_ANNOTATION",
        "TYPE_LINE_ANNOTATION",
        "TYPE_AREA_ANNOTATION",
    ]

@typing.type_check_only
class GeostoreDurationBasedRateProto(typing_extensions.TypedDict, total=False):
    isFree: bool
    periodicitySeconds: int
    price: _list[FreebaseTopic]
    rangeEndSeconds: int
    rangeStartSeconds: int

@typing.type_check_only
class GeostoreElevationModelProto(typing_extensions.TypedDict, total=False):
    blendOrder: int
    dataLevel: int
    dataMaxlevel: int
    elevationData: Proto2BridgeMessageSet
    fullChildDataAvailable: bool
    partialChildDataAvailable: bool

@typing.type_check_only
class GeostoreElevationProto(typing_extensions.TypedDict, total=False):
    averageElevationMeters: float
    peak: GeostorePeakProto

@typing.type_check_only
class GeostoreEntranceProto(typing_extensions.TypedDict, total=False):
    allowance: typing_extensions.Literal["ENTER_AND_EXIT", "ENTER_ONLY", "EXIT_ONLY"]
    canEnter: bool
    canExit: bool

@typing.type_check_only
class GeostoreEntranceReferenceProto(typing_extensions.TypedDict, total=False):
    featureId: GeostoreFeatureIdProto

@typing.type_check_only
class GeostoreEstablishmentProto(typing_extensions.TypedDict, total=False):
    bizbuilderReference: GeostoreBizBuilderReferenceProto
    hours: GeostoreTimeScheduleProto
    openingHours: GeostoreOpeningHoursProto
    priceInfo: GeostorePriceInfoProto
    serviceArea: GeostoreServiceAreaProto
    telephone: _list[GeostoreTelephoneProto]
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_UNDEFINED",
        "TYPE_DEPRECATED_AVIATION",
        "TYPE_BUSINESS",
        "TYPE_TRAVEL_SERVICE",
        "TYPE_LODGING",
        "TYPE_HOTEL",
        "TYPE_RESORT",
        "TYPE_MOTEL",
        "TYPE_HOSTEL",
        "TYPE_GUESTHOUSE",
        "TYPE_VACATION_RENTAL",
        "TYPE_GAS_STATION",
        "TYPE_REST_AREA",
        "TYPE_CASH_MACHINE",
        "TYPE_CAR_RENTAL",
        "TYPE_CAR_REPAIR",
        "TYPE_TAXI_STAND",
        "TYPE_TRAVEL_AGENT",
        "TYPE_BICYCLE_RENTAL_POINT",
        "TYPE_ELECTRIC_VEHICLE_CHARGING_STATION",
        "TYPE_SHOPPING",
        "TYPE_GROCERY",
        "TYPE_ANTIQUES",
        "TYPE_APPAREL",
        "TYPE_GIFTS",
        "TYPE_JEWELRY",
        "TYPE_SPORTING_GOODS",
        "TYPE_VEHICLE",
        "TYPE_SHOPPING_CENTER",
        "TYPE_SUPERMARKET",
        "TYPE_FAIRGROUNDS",
        "TYPE_MARKET",
        "TYPE_PRODUCE_MARKET",
        "TYPE_FARMERS_MARKET",
        "TYPE_LIQUOR_STORE",
        "TYPE_SOUVENIR_SHOP",
        "TYPE_INDUSTRIAL",
        "TYPE_CONSTRUCTION",
        "TYPE_BUILDING_MATERIAL",
        "TYPE_SECURITY_PRODUCTS",
        "TYPE_MECHANICAL",
        "TYPE_TEXTILE",
        "TYPE_CHEMICAL",
        "TYPE_METAL",
        "TYPE_TRANSPORTATION",
        "TYPE_FREIGHT",
        "TYPE_AVIATION",
        "TYPE_COURIER",
        "TYPE_MOVING",
        "TYPE_PACKAGING",
        "TYPE_RAIL",
        "TYPE_PUBLIC_TRANSIT",
        "TYPE_WAREHOUSE",
        "TYPE_DEFENSE",
        "TYPE_AGRICULTURE",
        "TYPE_PLANTATION",
        "TYPE_PLANT_NURSERY",
        "TYPE_DESIGN",
        "TYPE_UTILITIES",
        "TYPE_POWER_PLANT",
        "TYPE_SEWAGE_TREATMENT_PLANT",
        "TYPE_WATER_TREATMENT_PLANT",
        "TYPE_SUBSTATION",
        "TYPE_MANUFACTURING",
        "TYPE_BIOTECH",
        "TYPE_MATERIALS",
        "TYPE_MINING",
        "TYPE_QUARRY",
        "TYPE_TANNERY",
        "TYPE_OIL_REFINERY",
        "TYPE_ADVERTISING_MARKETING",
        "TYPE_LEGAL",
        "TYPE_FAMILY_LAW",
        "TYPE_IP_LAW",
        "TYPE_LABOR_LAW",
        "TYPE_PERSONAL_INJURY_LAW",
        "TYPE_CRIMINAL_LAW",
        "TYPE_PERSONAL_FINANCE",
        "TYPE_LIFE_INSURANCE",
        "TYPE_LENDING",
        "TYPE_ACCOUNTING",
        "TYPE_INVESTING",
        "TYPE_BANKING",
        "TYPE_HEALTH",
        "TYPE_HEALTH_EQUIPMENT",
        "TYPE_NURSING",
        "TYPE_HEALTH_INSURANCE",
        "TYPE_HEALTH_FACILITY",
        "TYPE_DIAGNOSTIC_CENTER",
        "TYPE_HEALTH_RESOURCES",
        "TYPE_NUTRITION",
        "TYPE_VISION",
        "TYPE_COUNSELING",
        "TYPE_MASSAGE",
        "TYPE_BLOOD_BANK",
        "TYPE_HEARING",
        "TYPE_HOME_GARDEN",
        "TYPE_INTERIOR_DECOR",
        "TYPE_DOMESTIC_SERVICES",
        "TYPE_APPLIANCES",
        "TYPE_PEST_CONTROL",
        "TYPE_GARDENING",
        "TYPE_ELECTRONICS",
        "TYPE_COMPUTER",
        "TYPE_COMPUTER_HARDWARE",
        "TYPE_COMPUTER_SECURITY",
        "TYPE_COMPUTER_SOFTWARE",
        "TYPE_COMPUTER_SUPPORT",
        "TYPE_AUDIO_DEVICES",
        "TYPE_VIDEO_DEVICES",
        "TYPE_REAL_ESTATE",
        "TYPE_OFFICE_SERVICES",
        "TYPE_ENTERTAINMENT",
        "TYPE_GAMES",
        "TYPE_CASINO",
        "TYPE_LOTTO",
        "TYPE_VIDEO",
        "TYPE_CLUBS",
        "TYPE_DISCOTHEQUE",
        "TYPE_ANIMATION",
        "TYPE_MODELING",
        "TYPE_HUMOR",
        "TYPE_MOVIES",
        "TYPE_MOVIE_RENTAL",
        "TYPE_MOVIE_THEATER",
        "TYPE_MUSIC",
        "TYPE_RADIO",
        "TYPE_TV",
        "TYPE_BAR",
        "TYPE_PRINT_MEDIA",
        "TYPE_ADULT",
        "TYPE_SEXUAL_SERVICES",
        "TYPE_ANIMALS",
        "TYPE_PETS",
        "TYPE_FISHERY",
        "TYPE_ARTS",
        "TYPE_BOOKS",
        "TYPE_PERFORMING_ARTS",
        "TYPE_GALLERY",
        "TYPE_AUTOMOTIVE",
        "TYPE_PARTS",
        "TYPE_AUTO_FINANCE",
        "TYPE_AUTO_INSURANCE",
        "TYPE_RV",
        "TYPE_MOTORCYCLES",
        "TYPE_CARS",
        "TYPE_TRUCKS_SUVS",
        "TYPE_LICENSING",
        "TYPE_MAINTENANCE",
        "TYPE_PERSONAL_CARE",
        "TYPE_BODY_ART",
        "TYPE_COSMETICS",
        "TYPE_FITNESS",
        "TYPE_YOGA_CENTER",
        "TYPE_GYM",
        "TYPE_HAIR_CARE",
        "TYPE_SPA",
        "TYPE_BEAUTY_SALON",
        "TYPE_CORPORATE_EVENTS",
        "TYPE_HUMAN_RESOURCES",
        "TYPE_FOOD_AND_DRINK",
        "TYPE_BEVERAGE",
        "TYPE_RECIPES",
        "TYPE_COOKWARE",
        "TYPE_CULINARY",
        "TYPE_RETAIL",
        "TYPE_RESTAURANT",
        "TYPE_COFFEE",
        "TYPE_BAKERY",
        "TYPE_FOOD_CENTER",
        "TYPE_TEA",
        "TYPE_CAFE",
        "TYPE_WINERY",
        "TYPE_BREWERY",
        "TYPE_FAST_FOOD",
        "TYPE_FOOD_DELIVERY",
        "TYPE_INTERNET",
        "TYPE_WEB_DESIGN",
        "TYPE_WEB_HOSTING",
        "TYPE_WEB_SERVICES",
        "TYPE_LIFESTYLE",
        "TYPE_PHOTO_VIDEO",
        "TYPE_ACTIVITIES",
        "TYPE_BOATING",
        "TYPE_CYCLING",
        "TYPE_EQUESTRIAN",
        "TYPE_FISHING",
        "TYPE_HIKING",
        "TYPE_HUNTING",
        "TYPE_SWIMMING",
        "TYPE_GOLF",
        "TYPE_GOLF_COURSE",
        "TYPE_BASEBALL",
        "TYPE_BASKETBALL",
        "TYPE_HOCKEY",
        "TYPE_MOTOR_SPORTS",
        "TYPE_WINTER_SPORTS",
        "TYPE_FOOTBALL",
        "TYPE_SOCCER",
        "TYPE_ICE_SKATING",
        "TYPE_BOXING",
        "TYPE_CRICKET",
        "TYPE_ROWING",
        "TYPE_RUGBY",
        "TYPE_RACQUET_SPORTS",
        "TYPE_ROCK_CLIMBING",
        "TYPE_REFERENCES",
        "TYPE_MAPS",
        "TYPE_TIME",
        "TYPE_SCIENTIFIC_EQUIPMENT",
        "TYPE_TELECOMMUNICATIONS",
        "TYPE_EVENT_VENUE",
        "TYPE_BANQUET_HALL",
        "TYPE_CONFERENCE_HALL",
        "TYPE_WEDDING_HALL",
        "TYPE_EXHIBITION_HALL",
        "TYPE_COMMUNITY_CENTER",
        "TYPE_AUDITORIUM",
        "TYPE_FUNCTION_HALL",
        "TYPE_CONCERT_HALL",
        "TYPE_AMPHITHEATER",
        "TYPE_LAUNDRY",
        "TYPE_LAUNDROMAT",
        "TYPE_DRY_CLEANER",
        "TYPE_MORTUARY",
        "TYPE_REPAIR_AND_MAINTENANCE",
        "TYPE_GOVERNMENT",
        "TYPE_BORDER_CROSSING",
        "TYPE_CITY_HALL",
        "TYPE_COURTHOUSE",
        "TYPE_EMBASSY",
        "TYPE_LIBRARY",
        "TYPE_PRISON",
        "TYPE_TAX_OFFICE",
        "TYPE_PROSECUTORS_OFFICE",
        "TYPE_CONGRESS",
        "TYPE_TOWN_COUNCIL",
        "TYPE_CAPITOL_BUILDING",
        "TYPE_VOTING_FACILITY",
        "TYPE_CHECKPOINT",
        "TYPE_SCHOOL",
        "TYPE_UNIVERSITY",
        "TYPE_ORPHANAGE",
        "TYPE_KINDERGARTEN",
        "TYPE_DAYCARE",
        "TYPE_ACADEMY",
        "TYPE_TRADE_SCHOOL",
        "TYPE_SKILL_INSTRUCTION",
        "TYPE_EMERGENCY",
        "TYPE_HOSPITAL",
        "TYPE_PHARMACY",
        "TYPE_POLICE",
        "TYPE_FIRE",
        "TYPE_DOCTOR",
        "TYPE_DENTIST",
        "TYPE_VETERINARIAN",
        "TYPE_FIRST_AID",
        "TYPE_CIVIL_DEFENSE",
        "TYPE_TOURIST_DESTINATION",
        "TYPE_ECO_TOURIST_DESTINATION",
        "TYPE_BIRD_WATCHING",
        "TYPE_NATURE_RESERVE",
        "TYPE_MUSEUM",
        "TYPE_VISITOR_CENTER",
        "TYPE_OBSERVATION_DECK",
        "TYPE_OBSERVATORY",
        "TYPE_SCENIC_POINT",
        "TYPE_ZOO",
        "TYPE_AQUARIUM",
        "TYPE_AMUSEMENT_PARK",
        "TYPE_MONUMENT",
        "TYPE_PALACE",
        "TYPE_FORT",
        "TYPE_TOWER",
        "TYPE_LIGHTHOUSE",
        "TYPE_TEMPLE",
        "TYPE_CHURCH",
        "TYPE_GURUDWARA",
        "TYPE_HINDU_TEMPLE",
        "TYPE_MOSQUE",
        "TYPE_SYNAGOGUE",
        "TYPE_BUDDHIST_TEMPLE",
        "TYPE_JAIN_TEMPLE",
        "TYPE_BAHAI_TEMPLE",
        "TYPE_SHINTO_TEMPLE",
        "TYPE_MORMON_TEMPLE",
        "TYPE_SPORTS_COMPLEX",
        "TYPE_STADIUM",
        "TYPE_BOWLING",
        "TYPE_BADMINTON",
        "TYPE_TENNIS",
        "TYPE_TABLE_TENNIS",
        "TYPE_PARK",
        "TYPE_LOCAL_PARK",
        "TYPE_NATIONAL_PARK",
        "TYPE_US_NATIONAL_PARK",
        "TYPE_US_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_FOREST",
        "TYPE_NATIONAL_GRASSLAND",
        "TYPE_NATIONAL_PRESERVE",
        "TYPE_NATIONAL_RECREATION_AREA",
        "TYPE_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_HISTORIC_AREA",
        "TYPE_NATIONAL_SCENIC_AREA",
        "TYPE_NATIONAL_SCENIC_ROADWAY_AREA",
        "TYPE_NATIONAL_SCENIC_RIVER_AREA",
        "TYPE_PROVINCIAL_PARK",
        "TYPE_PROVINCIAL_FOREST",
        "TYPE_CAMPGROUNDS",
        "TYPE_WILDERNESS_AREA",
        "TYPE_WILDLIFE_AREA",
        "TYPE_BOTANICAL_GARDEN",
        "TYPE_GARDEN",
        "TYPE_ARBORETUM",
        "TYPE_MARINE_PROTECTED_AREA",
        "TYPE_AIRPORT",
        "TYPE_TARMAC",
        "TYPE_HELIPORT",
        "TYPE_SEAPLANE_BASE",
        "TYPE_MILITARY_AIRBASE",
        "TYPE_CEMETERY",
        "TYPE_MILITARY",
        "TYPE_ENCLOSED_TRAFFIC_AREA",
        "TYPE_PARKING",
        "TYPE_OFF_ROAD_AREA",
        "TYPE_POST_OFFICE",
        "TYPE_HOUSING_DEVELOPMENT",
        "TYPE_BRIDGE",
        "TYPE_ARCHAEOLOGICAL",
        "TYPE_HISTORICAL",
        "TYPE_RUINS",
        "TYPE_TUNNEL",
        "TYPE_RESIDENTIAL_DWELLING",
        "TYPE_DETACHED_DWELLING",
        "TYPE_ATTACHED_DWELLING",
        "TYPE_APARTMENT",
        "TYPE_GATED_COMMUNITY",
        "TYPE_RETIREMENT_HOME",
        "TYPE_TOLL_BOOTH",
        "TYPE_CULTURAL",
        "TYPE_CULTURAL_CENTER",
        "TYPE_OVERPASS",
        "TYPE_REST_ROOM",
        "TYPE_PUBLIC_PHONE",
        "TYPE_PHONE_BOOTH",
        "TYPE_MANNED_PCO",
        "TYPE_RESEARCH_INSTITUTE",
        "TYPE_NON_GOVERNMENTAL_ORGANIZATION",
        "TYPE_OFFICE_PARK",
        "TYPE_MEDITATION_CENTER",
        "TYPE_RELIGIOUS",
        "TYPE_MONASTERY",
        "TYPE_ASHRAM",
        "TYPE_PAGODA",
        "TYPE_MISSION",
        "TYPE_PILGRIM_DESTINATION",
        "TYPE_SOCIAL_SERVICE",
        "TYPE_RANGER_STATION",
        "TYPE_TRANSIT_STATION",
        "TYPE_BUS_STATION",
        "TYPE_TRAMWAY_STATION",
        "TYPE_TRAIN_STATION",
        "TYPE_SUBWAY_STATION",
        "TYPE_FERRY_TERMINAL",
        "TYPE_CABLE_CAR_STATION",
        "TYPE_GONDOLA_LIFT_STATION",
        "TYPE_FUNICULAR_STATION",
        "TYPE_HORSE_CARRIAGE_STATION",
        "TYPE_MONORAIL_STATION",
        "TYPE_SEAPORT",
        "TYPE_NATURAL_FEATURE",
        "TYPE_ELEVATED",
        "TYPE_PEAK",
    ]

@typing.type_check_only
class GeostoreExceptionalHoursProto(typing_extensions.TypedDict, total=False):
    hours: GeostoreBusinessHoursProto
    metadata: GeostoreFieldMetadataProto
    range: GeostoreTimeIntervalProto

@typing.type_check_only
class GeostoreExistenceProto(typing_extensions.TypedDict, total=False):
    closeReason: typing_extensions.Literal["CLOSED", "MOVED", "REBRANDED"]
    closed: bool
    endAsOfDate: GeostoreDateTimeProto
    endDate: GeostoreDateTimeProto
    featureBirthTimestampSeconds: str
    removed: bool
    removedReason: typing_extensions.Literal[
        "UNKNOWN",
        "BOGUS",
        "PRIVATE",
        "PRIVATE_MUST_PURGE",
        "SPAM",
        "UNSUPPORTED",
        "PENDING",
        "DUPLICATE",
        "OLD_SCHEMA",
        "REPLACED",
        "ROLLED_BACK",
    ]
    startDate: GeostoreDateTimeProto

@typing.type_check_only
class GeostoreFeatureFieldMetadataProto(typing_extensions.TypedDict, total=False):
    fieldProvenance: _list[GeostoreFeatureFieldMetadataProtoFieldProvenance]

@typing.type_check_only
class GeostoreFeatureFieldMetadataProtoFieldProvenance(
    typing_extensions.TypedDict, total=False
):
    fieldPath: _list[GeostoreStableFieldPathProto]
    provenance: GeostoreProvenanceProto

@typing.type_check_only
class GeostoreFeatureHistoryMetadataProto(typing_extensions.TypedDict, total=False):
    featureBirthTimestampUs: str
    lastModificationTimestampUs: str
    removalTimestampUs: str

@typing.type_check_only
class GeostoreFeatureIdForwardingsProto(typing_extensions.TypedDict, total=False):
    duplicateOf: GeostoreFeatureIdProto
    forwardedId: GeostoreFeatureIdProto
    inactiveDuplicate: _list[GeostoreFeatureIdProto]
    replacedBy: GeostoreFeatureIdListProto
    transitivelyDuplicateOf: GeostoreFeatureIdProto

@typing.type_check_only
class GeostoreFeatureIdListProto(typing_extensions.TypedDict, total=False):
    id: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreFeatureIdProto(typing_extensions.TypedDict, total=False):
    cellId: str
    fprint: str
    temporaryData: Proto2BridgeMessageSet

@typing.type_check_only
class GeostoreFeatureMetadataProto(typing_extensions.TypedDict, total=False):
    bulkUpdatable: typing_extensions.Literal["NOT_BULK_UPDATABLE", "BULK_UPDATABLE"]
    coreVersionToken: str
    featureReplacementInfo: GeostoreFeatureReplacementInfoProto
    fieldMetadata: GeostoreFeatureFieldMetadataProto
    forwardings: GeostoreFeatureIdForwardingsProto
    history: GeostoreFeatureHistoryMetadataProto
    versionToken: str

@typing.type_check_only
class GeostoreFeaturePropertyIdProto(typing_extensions.TypedDict, total=False):
    attachmentTypeId: str
    attributeId: str
    fieldType: typing_extensions.Literal[
        "NONE",
        "ACCESS_POINT",
        "ADDRESS",
        "ANCHORED_GEOMETRY_GEOMETRY_ID",
        "ASSOCIATED_EV_CHARGING_STATION",
        "ATTACHMENT",
        "BIZBUILDER_REFERENCE",
        "BORDER_FEATURE_ID_LEFT",
        "BORDER_FEATURE_ID_RIGHT",
        "BORDER_OVERRIDE_STATUS",
        "BORDER_STATUS",
        "BORDER_TYPE",
        "BORDER_LOGICAL_BORDER",
        "BOUND",
        "BUILDING_BASE_HEIGHT_METERS_AGL",
        "BUILDING_DEFAULT_DISPLAY_LEVEL",
        "BUILDING_FLOORS",
        "BUILDING_HEIGHT_METERS",
        "BUILDING_LEVEL",
        "BUILDING_STRUCTURE",
        "BUSINESS_CHAIN_CANONICAL_GCONCEPT",
        "BUSINESS_HOURS",
        "DATA_SOURCE",
        "DISPLAY_DATA",
        "DISPUTED_AREA_ADMINISTERED_BY",
        "DISPUTED_AREA_CLAIMANT",
        "ENTRANCE_ALLOWANCE",
        "ESTABLISHMENT_OPENING_HOURS_EXCEPTION",
        "ESTABLISHMENT_OPENING_HOURS_REGULAR_HOURS",
        "ESTABLISHMENT_PRICE_INFO",
        "ESTABLISHMENT_SERVICE_AREA_SERVED_FEATURE",
        "EXISTENCE_STATUS",
        "FEATURE_AVERAGE_ELEVATION",
        "FEATURE_BEST_LOCALE",
        "FEATURE_CELL_COVERING",
        "FEATURE_CENTER",
        "FEATURE_CHILD",
        "FEATURE_EXEMPT_REGULATED_AREA",
        "FEATURE_INTERIOR_CELL_COVERING",
        "FEATURE_NAME",
        "FEATURE_PARENT",
        "FEATURE_POSE",
        "FEATURE_PREFERRED_VIEWPORT",
        "FEATURE_TRACK",
        "FEATURE_TYPE",
        "FEATURE_WEBSITE",
        "FIELD_RIGHTS",
        "FUTURE_GEOMETRY",
        "FUTURE_GEOMETRY_FOR",
        "GCONCEPT",
        "GEOMETRY_3D",
        "GEOMETRY_PRECISION_METERS",
        "GEOPOLITICAL_CONVEYS_ATTRIBUTION_TO",
        "GEOPOLITICAL_REGION_SPECIFIC_NAME",
        "GEOPOLITICAL_GEOMETRY_REST_OF_WORLD_POLYGON",
        "GEOPOLITICAL_GEOMETRY_SELF_POLYGON",
        "INFERRED_GEOMETRY_GEOMETRY_COMPOSITION",
        "INFERRED_GEOMETRY_DEFINES_GEOMETRY_FOR",
        "INTERSECTION",
        "INTERSECTION_GROUP",
        "INTERSECTION_GROUP_CHILD_GROUP",
        "INTERSECTION_GROUP_GROUP_TYPE",
        "INTERSECTION_GROUP_PARENT_GROUP",
        "INTERSECTION_IN_GROUP",
        "INTERSECTION_TOLL_CLUSTER",
        "IN_SEGMENT",
        "KNOWLEDGE_GRAPH_PROPERTY",
        "LABEL_BACKGROUND_COLOR",
        "LABEL_TEXT_COLOR",
        "LANE_MARKER_BARRIER_MATERIALS",
        "LANE_MARKER_CROSSING_PATTERN",
        "LANE_MARKER_LINEAR_PATTERN",
        "LEVEL_BUILDING",
        "LEVEL_NUMBER",
        "LOCALE_LANGUAGE",
        "LOCALE_LOCALIZATION_POLICY_ID",
        "LOGICAL_BORDER_BORDER_SEGMENT",
        "LOGICAL_BORDER_STATUS",
        "OPERATIONS_TEMPORARY_CLOSURE",
        "PARKING_ALLOWANCE",
        "PARKING_AVAILABLE",
        "PARKING_OPENING_HOURS_EXCEPTION",
        "PARKING_OPENING_HOURS_REGULAR_HOURS",
        "PARKING_PROVIDER_FEATURE",
        "PARKING_RESTRICTION",
        "PEAK_PROMINENCE",
        "PHONE_NUMBER",
        "POINT",
        "POLITICAL_CLAIM",
        "POLYGON",
        "POLYGON_FOR_DISPLAY",
        "POLYLINE",
        "RANK",
        "RANK_SIGNAL",
        "REGULATED_AREA_RESTRICTION",
        "RELATED_BORDER",
        "RELATED_ENTRANCE",
        "RELATED_FEATURE",
        "RELATED_TERMINAL_POINT",
        "RELATED_TIMEZONE",
        "RESTRICTION_GROUP_SEGMENT",
        "ROAD_MONITOR_MONITORED_ROAD",
        "ROUTE_CHILD_TYPE",
        "SCHOOL_DISTRICT_TYPE",
        "SEGMENT_ADVISORY_MAXIMUM_SPEED",
        "SEGMENT_AVERAGE_SPEED",
        "SEGMENT_BARRIER",
        "SEGMENT_BICYCLE_FACILITY",
        "SEGMENT_BICYCLE_SAFETY",
        "SEGMENT_CONDITION",
        "SEGMENT_CONSTRUCTION_BEGIN_DATE",
        "SEGMENT_CONSTRUCTION_END_DATE",
        "SEGMENT_CONSTRUCTION_STATUS",
        "SEGMENT_COVERED",
        "SEGMENT_DISTANCE_TO_EDGE",
        "SEGMENT_EDGE_FOLLOWS_SEGMENT_BEGIN_FRACTION",
        "SEGMENT_EDGE_FOLLOWS_SEGMENT_END_FRACTION",
        "SEGMENT_ELEVATION",
        "SEGMENT_ENDPOINT",
        "SEGMENT_GRADE_LEVEL_LIST",
        "SEGMENT_INTERNAL_DISALLOWED_CONNECTIONS",
        "SEGMENT_INTERNAL_DISALLOWED_PRIMARY_CONNECTION",
        "SEGMENT_INTERNAL_TRAVEL_ALLOWANCE",
        "SEGMENT_INTERPOLATION_OFFSET_METERS",
        "SEGMENT_IS_MAX_PERMITTED_SPEED_DERIVED",
        "SEGMENT_LANE",
        "SEGMENT_LEGAL_MAXIMUM_SPEED",
        "SEGMENT_LEGAL_MINIMUM_SPEED",
        "SEGMENT_MAX_SPEED",
        "SEGMENT_ON_RIGHT",
        "SEGMENT_PATH",
        "SEGMENT_PEDESTRIAN_CROSSING",
        "SEGMENT_PEDESTRIAN_FACILITY",
        "SEGMENT_PEDESTRIAN_GRADE",
        "SEGMENT_PRIORITY",
        "SEGMENT_RAMP_MAX_CONNECTED_PRIORITY",
        "SEGMENT_RESTRICTION",
        "SEGMENT_ROAD_CAMERA",
        "SEGMENT_ROAD_SIGN",
        "SEGMENT_ROUTE",
        "SEGMENT_ROUTE_ASSOCIATION",
        "SEGMENT_SEPARATED_ROADWAYS",
        "SEGMENT_SLOPE",
        "SEGMENT_SURFACE",
        "SEGMENT_SWEEP",
        "SEGMENT_TOLL_ROAD",
        "SEGMENT_USAGE",
        "SEGMENT_VISIBLE_LANDMARK",
        "SIGN_COMPONENT",
        "SOCIAL_REFERENCE_CLAIMED_GAIA_ID",
        "SOURCE_INFO",
        "STATUS_CLOSED",
        "STATUS_CLOSE_REASON",
        "STATUS_END_AS_OF_DATE",
        "STATUS_END_DATE",
        "STATUS_REMOVED",
        "STATUS_REMOVED_REASON",
        "STATUS_START_DATE",
        "STOREFRONT_GEOMETRY",
        "STOREFRONT_GEOMETRY_MODEL",
        "SYNTHETIC_GEOMETRY",
        "THREE_DIMENSIONAL_MODEL",
        "TOLL_CLUSTER_INTERSECTION",
        "TRANSIT_LINE_AGENCY",
        "TRANSIT_LINE_STATION",
        "TRANSIT_LINE_VARIANT_LINE_CONCEPT",
        "TRANSIT_LINE_VARIANT_STOP",
        "TRANSIT_LINE_VEHICLE_TYPE",
        "TRANSIT_STATION_AGENCY_ASSOCIATION",
        "VERTICAL_ORDERING_LEVEL",
        "VISUALIZATION_AREA",
        "WATER_REMOVED_POLYGON",
        "DEPRECATED_DO_NOT_USE_EMAIL_ADDRESS",
        "DEPRECATED_DO_NOT_USE_RANK_GEOMETRY",
        "DEPRECATED_DO_NOT_USE_SEGMENT_INFO",
        "DEPRECATED_DO_NOT_USE_SEGMENT_LANE_LIST",
        "DEPRECATED_DO_NOT_USE_SEGMENT_WRONG_WAY",
        "DEPRECATED_DO_NOT_USE_WEBSITE",
        "FEATURE_ATTRIBUTE",
        "SOCIAL_REFERENCE",
        "CATEGORY",
        "DEPRECATED_DO_NOT_USE_CAPITAL",
        "DEPRECATED_DO_NOT_USE_DESCRIPTION",
        "DEPRECATED_DO_NOT_USE_DISTINCT",
        "DEPRECATED_DO_NOT_USE_DUPLICATE",
        "EDIT_PRECEDENCE",
        "DEPRECATED_DO_NOT_USE_EDIT_PRECEDENCE",
        "DEPRECATED_DO_NOT_USE_ENTRANCE_TARGET",
        "DEPRECATED_DO_NOT_USE_ESTABLISHMENT_PLACE_ACTION_PAGE",
        "DEPRECATED_DO_NOT_USE_ESTABLISHMENT_TYPE",
        "DEPRECATED_DO_NOT_USE_EVENT",
        "DEPRECATED_DO_NOT_USE_GEOMETRIC_ACCURACY",
        "DEPRECATED_DO_NOT_USE_HIGHEST_GRADE",
        "DEPRECATED_DO_NOT_USE_ID_TO_OVERRIDE",
        "DEPRECATED_DO_NOT_USE_ISSUE_HISTORY",
        "DEPRECATED_DO_NOT_USE_ISSUE_METADATA",
        "DEPRECATED_DO_NOT_USE_KNOWLEDGE_GRAPH_ID",
        "DEPRECATED_DO_NOT_USE_LOWEST_GRADE",
        "DEPRECATED_DO_NOT_USE_PAYMENT_TYPES",
        "DEPRECATED_DO_NOT_USE_PHOTO",
        "DEPRECATED_DO_NOT_USE_PHOTO_URL",
        "DEPRECATED_DO_NOT_USE_PLACE_CLOSED",
        "DEPRECATED_DO_NOT_USE_POPULATION",
        "DEPRECATED_DO_NOT_USE_RANK_USER",
        "DEPRECATED_DO_NOT_USE_REMOVE_DUPLICATE",
        "DEPRECATED_DO_NOT_USE_REMOVE_PLACE",
        "DEPRECATED_DO_NOT_USE_SCHOOL_TYPE",
        "DEPRECATED_DO_NOT_USE_SEGMENT_ELEVATION_BEGIN",
        "DEPRECATED_DO_NOT_USE_SEGMENT_ELEVATION_END",
        "DEPRECATED_DO_NOT_USE_SEGMENT_ELEVATION_MIDDLE",
        "DEPRECATED_DO_NOT_USE_SYLLABUS",
        "DEPRECATED_DO_NOT_USE_TRACK_CLASS",
        "DEPRECATED_DO_NOT_USE_VIEWCODE_INFO",
        "DEPRECATED_DO_NOT_USE_WORKAREA",
        "DEPRECATED_DO_NOT_USE_INFERRED_GEOMETRY_INCLUDES_GEOMETRY_OF",
        "DEPRECATED_DO_NOT_USE_INFERRED_GEOMETRY_EXCLUDES_GEOMETRY_OF",
        "DEPRECATED_DO_NOT_USE_TRANSIT_STATION_AGENCY",
    ]
    kgPropertyId: str
    nameLanguage: str

@typing.type_check_only
class GeostoreFeatureProto(typing_extensions.TypedDict, total=False):
    accessPoint: _list[GeostoreAccessPointProto]
    address: _list[GeostoreAddressProto]
    anchoredGeometry: GeostoreAnchoredGeometryProto
    associatedEvChargingStation: _list[GeostoreFeatureIdProto]
    attachment: _list[GeostoreAttachmentsAttachmentProto]
    attribute: _list[GeostoreAttributeProto]
    bestLocale: GeostoreBestLocaleProto
    border: GeostoreBorderProto
    bound: GeostoreRectProto
    building: GeostoreBuildingProto
    businessChain: GeostoreBusinessChainProto
    center: GeostorePointProto
    child: _list[GeostoreFeatureIdProto]
    covering: GeostoreCellCoveringProto
    dataSource: GeostoreDataSourceProto
    displayData: GeostoreDisplayDataProto
    disputedArea: GeostoreDisputedAreaProto
    doodle: GeostoreDoodleProto
    elevation: GeostoreElevationProto
    elevationModel: GeostoreElevationModelProto
    entrance: GeostoreEntranceProto
    establishment: GeostoreEstablishmentProto
    exemptRegulatedArea: _list[GeostoreFeatureIdProto]
    futureGeometry: GeostoreFeatureIdProto
    futureGeometryFor: GeostoreFeatureIdProto
    geometry3d: GeostoreGeometryStoreReferenceProto
    geometryPrecisionMeters: float
    geopolitical: GeostoreGeopoliticalProto
    geopoliticalGeometry: GeostoreGeopoliticalGeometryProto
    htmlText: _list[GeostoreHtmlTextProto]
    id: GeostoreFeatureIdProto
    inferredGeometry: GeostoreInferredGeometryProto
    interiorCovering: GeostoreCellCoveringProto
    internal: GeostoreInternalFeatureProto
    intersection: GeostoreIntersectionProto
    intersectionGroup: GeostoreIntersectionGroupProto
    kgProperty: _list[FreebasePropertyValue]
    knowledgeGraphReference: GeostoreKnowledgeGraphReferenceProto
    laneMarker: GeostoreLaneMarkerProto
    level: GeostoreLevelProto
    locale: GeostoreLocaleProto
    logicalBorder: GeostoreLogicalBorderProto
    metadata: GeostoreFeatureMetadataProto
    name: _list[GeostoreNameProto]
    operations: GeostoreOperationsProto
    originalId: GeostoreFeatureIdProto
    parent: _list[GeostoreFeatureIdProto]
    parking: GeostoreParkingProto
    point: _list[GeostorePointProto]
    political: GeostorePoliticalProto
    polygon: _list[GeostorePolygonProto]
    polygonForDisplay: GeostorePolygonProto
    polyline: _list[GeostorePolyLineProto]
    pose: GeostorePoseProto
    preferredViewport: GeostoreRectProto
    propertyValueStatus: _list[GeostorePropertyValueStatusProto]
    rank: float
    rankDetails: GeostoreRankDetailsProto
    rawGconceptInstanceContainer: GeostoreOntologyRawGConceptInstanceContainerProto
    regulatedArea: GeostoreRegulatedAreaProto
    relatedBorder: _list[GeostoreFeatureIdProto]
    relatedEntrance: _list[GeostoreEntranceReferenceProto]
    relatedFeature: _list[GeostoreRelationProto]
    relatedTerminalPoint: _list[GeostoreFeatureIdProto]
    relatedTimezone: _list[GeostoreTimezoneProto]
    restrictionGroup: GeostoreRestrictionGroupProto
    roadMonitor: GeostoreRoadMonitorProto
    route: GeostoreRouteProto
    schoolDistrict: GeostoreSchoolDistrictProto
    segment: GeostoreSegmentProto
    segmentPath: GeostoreSegmentPathProto
    sign: GeostoreRoadSignProto
    skiBoundary: GeostoreSkiBoundaryProto
    skiLift: GeostoreSkiLiftProto
    skiTrail: GeostoreSkiTrailProto
    socialReference: GeostoreSocialReferenceProto
    sourceInfo: _list[GeostoreSourceInfoProto]
    status: GeostoreExistenceProto
    storefrontGeometry: _list[GeostoreAnchoredGeometryProto]
    storefrontGeometryModel: GeostoreGeometryStoreReferenceProto
    syntheticGeometry: bool
    temporaryData: Proto2BridgeMessageSet
    threeDimModel: GeostoreThreeDimensionalModelProto
    tollCluster: GeostoreTollClusterProto
    track: _list[GeostoreTrackProto]
    transitLine: GeostoreTransitLineProto
    transitLineVariant: GeostoreTransitLineVariantProto
    transitStation: GeostoreTransitStationProto
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_TRANSPORTATION",
        "TYPE_ROUTE",
        "TYPE_DEPRECATED_HIGHWAY_DO_NOT_USE",
        "TYPE_HIGHWAY",
        "TYPE_HIGHWAY_1",
        "TYPE_HIGHWAY_2",
        "TYPE_HIGHWAY_3",
        "TYPE_HIGHWAY_4",
        "TYPE_HIGHWAY_5",
        "TYPE_HIGHWAY_6",
        "TYPE_HIGHWAY_7",
        "TYPE_HIGHWAY_8",
        "TYPE_HIGHWAY_9",
        "TYPE_BICYCLE_ROUTE",
        "TYPE_TRAIL",
        "TYPE_SEGMENT",
        "TYPE_ROAD",
        "TYPE_RAILWAY",
        "TYPE_STANDARD_TRACK",
        "TYPE_JR_TRACK",
        "TYPE_NARROW_TRACK",
        "TYPE_MONORAIL_TRACK",
        "TYPE_SUBWAY_TRACK",
        "TYPE_LIGHT_RAIL_TRACK",
        "TYPE_BROAD_TRACK",
        "TYPE_HIGH_SPEED_RAIL",
        "TYPE_TROLLEY_TRACK",
        "TYPE_FERRY",
        "TYPE_FERRY_BOAT",
        "TYPE_FERRY_TRAIN",
        "TYPE_VIRTUAL_SEGMENT",
        "TYPE_INTERSECTION",
        "TYPE_TRANSIT",
        "TYPE_TRANSIT_STATION",
        "TYPE_BUS_STATION",
        "TYPE_TRAMWAY_STATION",
        "TYPE_TRAIN_STATION",
        "TYPE_SUBWAY_STATION",
        "TYPE_FERRY_TERMINAL",
        "TYPE_AIRPORT",
        "TYPE_AIRPORT_CIVIL",
        "TYPE_AIRPORT_MILITARY",
        "TYPE_AIRPORT_MIXED",
        "TYPE_HELIPORT",
        "TYPE_SEAPLANE_BASE",
        "TYPE_AIRSTRIP",
        "TYPE_CABLE_CAR_STATION",
        "TYPE_GONDOLA_LIFT_STATION",
        "TYPE_FUNICULAR_STATION",
        "TYPE_SPECIAL_STATION",
        "TYPE_HORSE_CARRIAGE_STATION",
        "TYPE_MONORAIL_STATION",
        "TYPE_SEAPORT",
        "TYPE_TRANSIT_STOP",
        "TYPE_TRANSIT_TRIP",
        "TYPE_TRANSIT_DEPARTURE",
        "TYPE_TRANSIT_LEG",
        "TYPE_TRANSIT_LINE",
        "TYPE_TRANSIT_AGENCY_DEPRECATED_VALUE",
        "TYPE_TRANSIT_TRANSFER",
        "TYPE_SEGMENT_PATH",
        "TYPE_ROAD_SIGN",
        "TYPE_INTERSECTION_GROUP",
        "TYPE_PATHWAY",
        "TYPE_RESTRICTION_GROUP",
        "TYPE_TOLL_CLUSTER",
        "TYPE_POLITICAL",
        "TYPE_COUNTRY",
        "TYPE_ADMINISTRATIVE_AREA",
        "TYPE_ADMINISTRATIVE_AREA1",
        "TYPE_US_STATE",
        "TYPE_GB_COUNTRY",
        "TYPE_JP_TODOUFUKEN",
        "TYPE_ADMINISTRATIVE_AREA2",
        "TYPE_GB_FORMER_POSTAL_COUNTY",
        "TYPE_GB_TRADITIONAL_COUNTY",
        "TYPE_ADMINISTRATIVE_AREA3",
        "TYPE_ADMINISTRATIVE_AREA4",
        "TYPE_ADMINISTRATIVE_AREA5",
        "TYPE_ADMINISTRATIVE_AREA6",
        "TYPE_ADMINISTRATIVE_AREA7",
        "TYPE_ADMINISTRATIVE_AREA8",
        "TYPE_ADMINISTRATIVE_AREA9",
        "TYPE_COLLOQUIAL_AREA",
        "TYPE_RESERVATION",
        "TYPE_LOCALITY",
        "TYPE_GB_POST_TOWN",
        "TYPE_JP_GUN",
        "TYPE_JP_SHIKUCHOUSON",
        "TYPE_JP_SUB_SHIKUCHOUSON",
        "TYPE_COLLOQUIAL_CITY",
        "TYPE_SUBLOCALITY",
        "TYPE_US_BOROUGH",
        "TYPE_GB_DEPENDENT_LOCALITY",
        "TYPE_JP_OOAZA",
        "TYPE_JP_KOAZA",
        "TYPE_JP_GAIKU",
        "TYPE_GB_DOUBLE_DEPENDENT_LOCALITY",
        "TYPE_JP_CHIBAN",
        "TYPE_JP_EDABAN",
        "TYPE_SUBLOCALITY1",
        "TYPE_SUBLOCALITY2",
        "TYPE_SUBLOCALITY3",
        "TYPE_SUBLOCALITY4",
        "TYPE_SUBLOCALITY5",
        "TYPE_NEIGHBORHOOD",
        "TYPE_CONSTITUENCY",
        "TYPE_DESIGNATED_MARKET_AREA",
        "TYPE_SCHOOL_DISTRICT",
        "TYPE_LAND_PARCEL",
        "TYPE_DISPUTED_AREA",
        "TYPE_POLICE_JURISDICTION",
        "TYPE_STATISTICAL_AREA",
        "TYPE_CONSTITUENCY_FUTURE",
        "TYPE_PARK",
        "TYPE_GOLF_COURSE",
        "TYPE_LOCAL_PARK",
        "TYPE_NATIONAL_PARK",
        "TYPE_US_NATIONAL_PARK",
        "TYPE_US_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_FOREST",
        "TYPE_PROVINCIAL_PARK",
        "TYPE_PROVINCIAL_FOREST",
        "TYPE_CAMPGROUNDS",
        "TYPE_HIKING_AREA",
        "TYPE_BUSINESS",
        "TYPE_GOVERNMENT",
        "TYPE_BORDER_CROSSING",
        "TYPE_CITY_HALL",
        "TYPE_COURTHOUSE",
        "TYPE_EMBASSY",
        "TYPE_LIBRARY",
        "TYPE_SCHOOL",
        "TYPE_UNIVERSITY",
        "TYPE_EMERGENCY",
        "TYPE_HOSPITAL",
        "TYPE_PHARMACY",
        "TYPE_POLICE",
        "TYPE_FIRE",
        "TYPE_DOCTOR",
        "TYPE_DENTIST",
        "TYPE_VETERINARIAN",
        "TYPE_TRAVEL_SERVICE",
        "TYPE_LODGING",
        "TYPE_RESTAURANT",
        "TYPE_GAS_STATION",
        "TYPE_PARKING",
        "TYPE_POST_OFFICE",
        "TYPE_REST_AREA",
        "TYPE_CASH_MACHINE",
        "TYPE_CAR_RENTAL",
        "TYPE_CAR_REPAIR",
        "TYPE_SHOPPING",
        "TYPE_GROCERY",
        "TYPE_TOURIST_DESTINATION",
        "TYPE_ECO_TOURIST_DESTINATION",
        "TYPE_BIRD_WATCHING",
        "TYPE_FISHING",
        "TYPE_HUNTING",
        "TYPE_NATURE_RESERVE",
        "TYPE_TEMPLE",
        "TYPE_CHURCH",
        "TYPE_GURUDWARA",
        "TYPE_HINDU_TEMPLE",
        "TYPE_MOSQUE",
        "TYPE_SYNAGOGUE",
        "TYPE_STADIUM",
        "TYPE_BAR",
        "TYPE_MOVIE_RENTAL",
        "TYPE_COFFEE",
        "TYPE_GOLF",
        "TYPE_BANK",
        "TYPE_DOODLE",
        "TYPE_GROUNDS",
        "TYPE_AIRPORT_GROUNDS",
        "TYPE_BUILDING_GROUNDS",
        "TYPE_CEMETERY",
        "TYPE_HOSPITAL_GROUNDS",
        "TYPE_INDUSTRIAL",
        "TYPE_MILITARY",
        "TYPE_SHOPPING_CENTER",
        "TYPE_SPORTS_COMPLEX",
        "TYPE_UNIVERSITY_GROUNDS",
        "TYPE_DEPRECATED_TARMAC",
        "TYPE_ENCLOSED_TRAFFIC_AREA",
        "TYPE_PARKING_LOT",
        "TYPE_PARKING_GARAGE",
        "TYPE_OFF_ROAD_AREA",
        "TYPE_BORDER",
        "TYPE_BUILDING",
        "TYPE_GEOCODED_ADDRESS",
        "TYPE_NATURAL_FEATURE",
        "TYPE_TERRAIN",
        "TYPE_SAND",
        "TYPE_BEACH",
        "TYPE_DUNE",
        "TYPE_ROCKY",
        "TYPE_ICE",
        "TYPE_GLACIER",
        "TYPE_BUILT_UP_AREA",
        "TYPE_VEGETATION",
        "TYPE_SHRUBBERY",
        "TYPE_WOODS",
        "TYPE_AGRICULTURAL",
        "TYPE_GRASSLAND",
        "TYPE_TUNDRA",
        "TYPE_DESERT",
        "TYPE_SALT_FLAT",
        "TYPE_WATER",
        "TYPE_OCEAN",
        "TYPE_BAY",
        "TYPE_BIGHT",
        "TYPE_LAGOON",
        "TYPE_SEA",
        "TYPE_STRAIT",
        "TYPE_INLET",
        "TYPE_FJORD",
        "TYPE_LAKE",
        "TYPE_SEASONAL_LAKE",
        "TYPE_RESERVOIR",
        "TYPE_POND",
        "TYPE_RIVER",
        "TYPE_RAPIDS",
        "TYPE_DISTRIBUTARY",
        "TYPE_CONFLUENCE",
        "TYPE_WATERFALL",
        "TYPE_SPRING",
        "TYPE_GEYSER",
        "TYPE_HOT_SPRING",
        "TYPE_SEASONAL_RIVER",
        "TYPE_WADI",
        "TYPE_ESTUARY",
        "TYPE_WETLAND",
        "TYPE_WATER_NAVIGATION",
        "TYPE_FORD",
        "TYPE_CANAL",
        "TYPE_HARBOR",
        "TYPE_CHANNEL",
        "TYPE_REEF",
        "TYPE_REEF_FLAT",
        "TYPE_REEF_GROWTH",
        "TYPE_REEF_EXTENT",
        "TYPE_REEF_ROCK_SUBMERGED",
        "TYPE_IRRIGATION",
        "TYPE_DAM",
        "TYPE_DRINKING_WATER",
        "TYPE_CURRENT",
        "TYPE_WATERING_HOLE",
        "TYPE_TECTONIC",
        "TYPE_WATERING_HOLE_DEPRECATED",
        "TYPE_VOLCANO",
        "TYPE_LAVA_FIELD",
        "TYPE_FISSURE",
        "TYPE_FAULT",
        "TYPE_LAND_MASS",
        "TYPE_CONTINENT",
        "TYPE_ISLAND",
        "TYPE_ATOLL",
        "TYPE_OCEAN_ROCK_EXPOSED",
        "TYPE_CAY",
        "TYPE_PENINSULA",
        "TYPE_ISTHMUS",
        "TYPE_ELEVATED",
        "TYPE_PEAK",
        "TYPE_NUNATAK",
        "TYPE_SPUR",
        "TYPE_PASS",
        "TYPE_PLATEAU",
        "TYPE_RIDGE",
        "TYPE_RAVINE",
        "TYPE_CRATER",
        "TYPE_KARST",
        "TYPE_CLIFF",
        "TYPE_VISTA",
        "TYPE_DIGITAL_ELEVATION_MODEL",
        "TYPE_UPLAND",
        "TYPE_TERRACE",
        "TYPE_SLOPE",
        "TYPE_CONTOUR_LINE",
        "TYPE_PAN",
        "TYPE_UNSTABLE_HILLSIDE",
        "TYPE_MOUNTAIN_RANGE",
        "TYPE_UNDERSEA",
        "TYPE_SUBMARINE_SEAMOUNT",
        "TYPE_SUBMARINE_RIDGE",
        "TYPE_SUBMARINE_GAP",
        "TYPE_SUBMARINE_PLATEAU",
        "TYPE_SUBMARINE_DEEP",
        "TYPE_SUBMARINE_VALLEY",
        "TYPE_SUBMARINE_BASIN",
        "TYPE_SUBMARINE_SLOPE",
        "TYPE_SUBMARINE_CLIFF",
        "TYPE_SUBMARINE_PLAIN",
        "TYPE_SUBMARINE_FRACTURE_ZONE",
        "TYPE_CAVE",
        "TYPE_ROCK",
        "TYPE_ARCHIPELAGO",
        "TYPE_POSTAL",
        "TYPE_POSTAL_CODE",
        "TYPE_POSTAL_CODE_PREFIX",
        "TYPE_PREMISE",
        "TYPE_SUB_PREMISE",
        "TYPE_SUITE",
        "TYPE_POST_TOWN",
        "TYPE_POSTAL_ROUND",
        "TYPE_META_FEATURE",
        "TYPE_DATA_SOURCE",
        "TYPE_LOCALE",
        "TYPE_TIMEZONE",
        "TYPE_BUSINESS_CHAIN",
        "TYPE_PHONE_NUMBER_PREFIX",
        "TYPE_PHONE_NUMBER_AREA_CODE",
        "TYPE_BUSINESS_CORRIDOR",
        "TYPE_ADDRESS_TEMPLATE",
        "TYPE_TRANSIT_AGENCY",
        "TYPE_FUTURE_GEOMETRY",
        "TYPE_EVENT",
        "TYPE_EARTHQUAKE",
        "TYPE_HURRICANE",
        "TYPE_WEATHER_CONDITION",
        "TYPE_TRANSIENT",
        "TYPE_ENTRANCE",
        "TYPE_CARTOGRAPHIC",
        "TYPE_HIGH_TENSION",
        "TYPE_SKI_TRAIL",
        "TYPE_SKI_LIFT",
        "TYPE_SKI_BOUNDARY",
        "TYPE_WATERSHED_BOUNDARY",
        "TYPE_TARMAC",
        "TYPE_WALL",
        "TYPE_PICNIC_AREA",
        "TYPE_PLAY_GROUND",
        "TYPE_TRAIL_HEAD",
        "TYPE_GOLF_TEEING_GROUND",
        "TYPE_GOLF_PUTTING_GREEN",
        "TYPE_GOLF_ROUGH",
        "TYPE_GOLF_SAND_BUNKER",
        "TYPE_GOLF_FAIRWAY",
        "TYPE_GOLF_HOLE",
        "TYPE_DEPRECATED_GOLF_SHOP",
        "TYPE_CAMPING_SITE",
        "TYPE_DESIGNATED_BARBECUE_PIT",
        "TYPE_DESIGNATED_COOKING_AREA",
        "TYPE_CAMPFIRE_PIT",
        "TYPE_WATER_FOUNTAIN",
        "TYPE_LITTER_RECEPTACLE",
        "TYPE_LOCKER_AREA",
        "TYPE_ANIMAL_ENCLOSURE",
        "TYPE_CARTOGRAPHIC_LINE",
        "TYPE_ESTABLISHMENT",
        "TYPE_ESTABLISHMENT_GROUNDS",
        "TYPE_ESTABLISHMENT_BUILDING",
        "TYPE_ESTABLISHMENT_POI",
        "TYPE_ESTABLISHMENT_SERVICE",
        "TYPE_CELESTIAL",
        "TYPE_ROAD_MONITOR",
        "TYPE_PUBLIC_SPACES_AND_MONUMENTS",
        "TYPE_STATUE",
        "TYPE_TOWN_SQUARE",
        "TYPE_LEVEL",
        "TYPE_COMPOUND",
        "TYPE_COMPOUND_GROUNDS",
        "TYPE_COMPOUND_BUILDING",
        "TYPE_COMPOUND_SECTION",
        "TYPE_TERMINAL_POINT",
        "TYPE_REGULATED_AREA",
        "TYPE_LOGICAL_BORDER",
        "TYPE_DO_NOT_USE_RESERVED_TO_CATCH_GENERATED_FILES",
        "TYPE_UNKNOWN",
    ]
    verticalOrdering: GeostoreVerticalOrderingProto
    visualizationArea: GeostoreGeometryStoreReferenceProto
    waterRemovedPolygon: GeostorePolygonProto
    website: _list[GeostoreUrlProto]

@typing.type_check_only
class GeostoreFeatureReplacementInfoProto(typing_extensions.TypedDict, total=False):
    derivedFrom: _list[GeostoreFeatureIdProto]
    replacedBy: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreFieldMetadataProto(typing_extensions.TypedDict, total=False):
    internal: GeostoreInternalFieldMetadataProto

@typing.type_check_only
class GeostoreFieldWithRightsProto(typing_extensions.TypedDict, total=False):
    attributeId: str
    featurePropertyId: GeostoreFeaturePropertyIdProto
    fieldType: int
    minRightsLevel: typing_extensions.Literal[
        "UNKNOWN_RIGHTS", "GT_RIGHTS", "FULL_RIGHTS"
    ]

@typing.type_check_only
class GeostoreFlowLineProto(typing_extensions.TypedDict, total=False):
    curvature: GeostoreCurvatureProto
    track: GeostoreTrackProto

@typing.type_check_only
class GeostoreFoodMenuItemOptionProto(typing_extensions.TypedDict, total=False):
    allergenAbsent: _list[
        typing_extensions.Literal[
            "ALLERGEN_DAIRY",
            "ALLERGEN_EGG",
            "ALLERGEN_FISH",
            "ALLERGEN_PEANUT",
            "ALLERGEN_SHELLFISH",
            "ALLERGEN_SOY",
            "ALLERGEN_TREE_NUT",
            "ALLERGEN_WHEAT",
        ]
    ]
    allergenPresent: _list[
        typing_extensions.Literal[
            "ALLERGEN_DAIRY",
            "ALLERGEN_EGG",
            "ALLERGEN_FISH",
            "ALLERGEN_PEANUT",
            "ALLERGEN_SHELLFISH",
            "ALLERGEN_SOY",
            "ALLERGEN_TREE_NUT",
            "ALLERGEN_WHEAT",
        ]
    ]
    calories: int
    ingredients: _list[GeostoreFoodMenuItemOptionProtoIngredient]
    media: _list[GeostoreMediaItemProto]
    nameInfo: _list[GeostorePriceListNameInfoProto]
    nutritionFacts: GeostorePriceInfoFoodNutritionFacts
    portionSize: GeostoreFoodMenuItemOptionProtoPortionSize
    preparationMethods: _list[
        typing_extensions.Literal[
            "METHOD_UNDEFINED",
            "BAKED",
            "BOILED",
            "BLANCHED",
            "BRAISED",
            "CODDLED",
            "PRESSURE_COOKED",
            "SIMMERED",
            "STEAMED",
            "STEEPED",
            "GRILLED",
            "FRIED",
            "PAN_FRIED",
            "STIR_FRIED",
            "SAUTEED",
            "ROASTED",
            "BARBECUED",
            "SEARED",
            "SMOKED",
            "FERMENTED",
            "MARINATED",
            "PICKLED",
            "BASTED",
            "KNEADED",
            "OTHER_METHOD",
        ]
    ]
    price: GeostorePriceRangeProto
    restriction: _list[
        typing_extensions.Literal[
            "DIET_HALAL", "DIET_KOSHER", "DIET_ORGANIC", "DIET_VEGAN", "DIET_VEGETARIAN"
        ]
    ]
    servesNumPeople: int
    spiciness: typing_extensions.Literal[
        "SPICINESS_NONE", "SPICINESS_MILD", "SPICINESS_MEDIUM", "SPICINESS_HOT"
    ]

@typing.type_check_only
class GeostoreFoodMenuItemOptionProtoIngredient(
    typing_extensions.TypedDict, total=False
):
    nameInfo: _list[GeostorePriceListNameInfoProto]

@typing.type_check_only
class GeostoreFoodMenuItemOptionProtoPortionSize(
    typing_extensions.TypedDict, total=False
):
    quantity: int
    unit: _list[GeostorePriceListNameInfoProto]

@typing.type_check_only
class GeostoreFoodMenuItemProto(typing_extensions.TypedDict, total=False):
    itemOption: _list[GeostoreFoodMenuItemOptionProto]
    nameInfo: _list[GeostorePriceListNameInfoProto]

@typing.type_check_only
class GeostoreGConceptInstanceProto(typing_extensions.TypedDict, total=False):
    gconceptId: str
    metadata: GeostoreFieldMetadataProto
    prominence: typing_extensions.Literal["NON_PRIMARY", "PRIMARY"]

@typing.type_check_only
class GeostoreGeometryComposition(typing_extensions.TypedDict, total=False):
    excludesGeometryOf: _list[GeostoreFeatureIdProto]
    includesGeometryOf: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreGeometryStoreReferenceProto(typing_extensions.TypedDict, total=False):
    footprint: str
    geometry: GeostoreCityJsonProto
    geometryId: str

@typing.type_check_only
class GeostoreGeopoliticalGeometryProto(typing_extensions.TypedDict, total=False):
    restOfWorldPolygon: GeostorePolygonProto
    selfPolygon: GeostorePolygonProto

@typing.type_check_only
class GeostoreGeopoliticalProto(typing_extensions.TypedDict, total=False):
    conveysAttributionTo: str
    regionSpecificName: _list[GeostoreRegionSpecificNameProto]

@typing.type_check_only
class GeostoreGradeLevelProto(typing_extensions.TypedDict, total=False):
    index: int
    level: int

@typing.type_check_only
class GeostoreHtmlTextProto(typing_extensions.TypedDict, total=False):
    text: _list[GeostoreLanguageTaggedTextProto]
    type: typing_extensions.Literal["HTML_DESCRIPTION"]

@typing.type_check_only
class GeostoreInferredGeometryProto(typing_extensions.TypedDict, total=False):
    definesGeometryFor: _list[GeostoreFeatureIdProto]
    geometryComposition: GeostoreGeometryComposition

@typing.type_check_only
class GeostoreInternalFeatureProto(typing_extensions.TypedDict, total=False):
    polygonShapeId: str
    restOfWorldPolygonShapeId: str
    rightsStatus: GeostoreRightsStatusProto
    selfPolygonShapeId: str
    trust: GeostoreTrustSignalsProto
    waterRemovedPolygonShapeId: str

@typing.type_check_only
class GeostoreInternalFieldMetadataProto(typing_extensions.TypedDict, total=False):
    isAuto: bool
    sourceSummary: GeostoreInternalSourceSummaryProto

@typing.type_check_only
class GeostoreInternalSegmentProto(typing_extensions.TypedDict, total=False):
    disallowedConnections: _list[GeostoreInternalSegmentProtoLaneConnectionReference]
    disallowedPrimaryConnection: _list[
        GeostoreInternalSegmentProtoLaneConnectionReference
    ]
    travelAllowance: _list[GeostoreRestrictionProto]

@typing.type_check_only
class GeostoreInternalSegmentProtoLaneConnectionReference(
    typing_extensions.TypedDict, total=False
):
    fromLaneNumber: int
    segment: GeostoreFeatureIdProto
    toLaneNumber: int

@typing.type_check_only
class GeostoreInternalSourceSummaryProto(typing_extensions.TypedDict, total=False):
    dataset: str
    provider: typing_extensions.Literal[
        "PROVIDER_ANY",
        "PROVIDER_UNKNOWN",
        "PROVIDER_NAVTEQ",
        "PROVIDER_TELE_ATLAS",
        "PROVIDER_TELE_ATLAS_MULTINET",
        "PROVIDER_TELE_ATLAS_CODEPOINT",
        "PROVIDER_TELE_ATLAS_GEOPOST",
        "PROVIDER_TELE_ATLAS_DATAGEO",
        "PROVIDER_TELE_ATLAS_ADDRESS_POINTS",
        "PROVIDER_TELCONTAR",
        "PROVIDER_EUROPA",
        "PROVIDER_ROYAL_MAIL",
        "PROVIDER_GOOGLE",
        "PROVIDER_GOOGLE_HAND_EDIT",
        "PROVIDER_GOOGLE_BORDERS",
        "PROVIDER_GOOGLE_SUBRANGE",
        "PROVIDER_GOOGLE_GT_FUSION",
        "PROVIDER_GOOGLE_ZAGAT_CMS",
        "PROVIDER_GOOGLE_PLACE_NAVBOOST",
        "PROVIDER_GOOGLE_FOOTPRINT",
        "PROVIDER_GOOGLE_PRODUCT_TERMS",
        "PROVIDER_GOOGLE_POINTCARDS",
        "PROVIDER_GOOGLE_BUSINESS_CHAINS",
        "PROVIDER_GOOGLE_LOCAL_SUMMARIZATION",
        "PROVIDER_GOOGLE_PRONUNCIATIONS",
        "PROVIDER_GOOGLE_DUMPLING",
        "PROVIDER_GOOGLE_DISTILLERY",
        "PROVIDER_GOOGLE_LOCAL_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_RELATION_MINER",
        "PROVIDER_GOOGLE_MAPSPAM",
        "PROVIDER_GOOGLE_ROSE",
        "PROVIDER_GOOGLE_LOCAL_PLACE_RATINGS",
        "PROVIDER_GOOGLE_WIPEOUT",
        "PROVIDER_GOOGLE_KNOWLEDGE_GRAPH",
        "PROVIDER_GOOGLE_BEEGEES",
        "PROVIDER_GOOGLE_REVIEW_SUMMARIZATION",
        "PROVIDER_GOOGLE_OFFLINE_NON_CORE_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_GEO_WORLDMAPS",
        "PROVIDER_GOOGLE_GEO_MODERATION",
        "PROVIDER_GOOGLE_OYSTER_AUTO_EDITS",
        "PROVIDER_GOOGLE_LOCAL_ALCHEMY",
        "PROVIDER_GOOGLE_KEROUAC",
        "PROVIDER_GOOGLE_MOBRANK",
        "PROVIDER_GOOGLE_RAPTURE",
        "PROVIDER_GOOGLE_CULTURAL_INSTITUTE",
        "PROVIDER_GOOGLE_GEOCODES_FROM_LOCAL_FEEDS",
        "PROVIDER_GOOGLE_ATTRIBUTES_FROM_CRAWLED_CHAINS",
        "PROVIDER_GOOGLE_TACTILE_MAPS",
        "PROVIDER_GOOGLE_MAPS_FOR_MOBILE",
        "PROVIDER_GOOGLE_GEO_REALTIME",
        "PROVIDER_GOOGLE_PROMINENT_PLACES",
        "PROVIDER_GOOGLE_PLACE_ACTIONS",
        "PROVIDER_GOOGLE_GT_AUTO_EDITS",
        "PROVIDER_GOOGLE_WAZE",
        "PROVIDER_GOOGLE_ONTHEGO",
        "PROVIDER_GOOGLE_GT_IMPORT",
        "PROVIDER_GOOGLE_STRUCTURED_DATA",
        "PROVIDER_GOOGLE_HELICOPTER",
        "PROVIDER_GOOGLE_ROLLBACK",
        "PROVIDER_GOOGLE_RIGHTS_REPAIR",
        "PROVIDER_GOOGLE_PERFUME",
        "PROVIDER_GOOGLE_MAPS_TRANSLATION",
        "PROVIDER_GOOGLE_CALL_ME_MAYBE",
        "PROVIDER_GOOGLE_LOCAL_UNIVERSAL",
        "PROVIDER_GOOGLE_CROUPIER",
        "PROVIDER_GOOGLE_SKYSMART",
        "PROVIDER_GOOGLE_RIDDLER",
        "PROVIDER_GOOGLE_ROADCLOSURES",
        "PROVIDER_GOOGLE_SPORE",
        "PROVIDER_GOOGLE_LOCALIZATION",
        "PROVIDER_GOOGLE_CATTERMS",
        "PROVIDER_GOOGLE_GT_FIELD_OPS",
        "PROVIDER_GOOGLE_MATCHMAKER",
        "PROVIDER_GOOGLE_ARBITRATION",
        "PROVIDER_GOOGLE_BIZBUILDER_OPS",
        "PROVIDER_GOOGLE_LOCAL_INVENTORY_ADS",
        "PROVIDER_GOOGLE_GT_DRAFTY",
        "PROVIDER_GOOGLE_HOTELADS_OPS",
        "PROVIDER_GOOGLE_MARKERS",
        "PROVIDER_GOOGLE_STATE_MACHINE",
        "PROVIDER_GOOGLE_ATTRIBUTES_INFERENCE",
        "PROVIDER_GOOGLE_BIKESHARE",
        "PROVIDER_GOOGLE_GHOSTWRITER",
        "PROVIDER_GOOGLE_EDIT_PLATFORM",
        "PROVIDER_GOOGLE_BLUE_GINGER",
        "PROVIDER_GOOGLE_GEO_TIGER",
        "PROVIDER_GOOGLE_HYADES",
        "PROVIDER_GOOGLE_WEBQUARRY",
        "PROVIDER_GOOGLE_GEO_MADDEN",
        "PROVIDER_GOOGLE_ANDROID_PAY",
        "PROVIDER_GOOGLE_OPENING_HOURS_TEAM",
        "PROVIDER_GOOGLE_LOCAL_DISCOVERY",
        "PROVIDER_GOOGLE_LOCAL_HEALTH",
        "PROVIDER_GOOGLE_UGC_MAPS",
        "PROVIDER_GOOGLE_FIBER",
        "PROVIDER_GOOGLE_REVGEO",
        "PROVIDER_GOOGLE_HOTELADS_PARTNER_FRONT_END",
        "PROVIDER_GOOGLE_GEO_UGC_TASKS",
        "PROVIDER_GOOGLE_GEOCODING",
        "PROVIDER_GOOGLE_SPYGLASS",
        "PROVIDER_GOOGLE_PLUS_CODES_AS_ADDRESSES",
        "PROVIDER_GOOGLE_GEO_CHANGES",
        "PROVIDER_GOOGLE_HUME",
        "PROVIDER_GOOGLE_MEGAMIND",
        "PROVIDER_GOOGLE_GT_ROADSYNTH",
        "PROVIDER_GOOGLE_FIREBOLT",
        "PROVIDER_GOOGLE_LOCAL_PLACE_OFFERINGS",
        "PROVIDER_GOOGLE_UGC_SERVICES",
        "PROVIDER_GOOGLE_GEOALIGN",
        "PROVIDER_GOOGLE_GT_COMPOUNDS",
        "PROVIDER_GOOGLE_FOOD_ORDERING",
        "PROVIDER_GOOGLE_HOTEL_KNOWLEDGE_OPS",
        "PROVIDER_GOOGLE_URAW",
        "PROVIDER_GOOGLE_FLYEYE",
        "PROVIDER_GOOGLE_YOUKE",
        "PROVIDER_GOOGLE_GT_ZEPHYR",
        "PROVIDER_GOOGLE_USER_SAFETY",
        "PROVIDER_GOOGLE_ADDRESS_MAKER",
        "PROVIDER_GOOGLE_UGC_PHOTOS",
        "PROVIDER_GOOGLE_GT_WINDCHIME",
        "PROVIDER_GOOGLE_SNAG_FIXER",
        "PROVIDER_GOOGLE_GEO_DEALS",
        "PROVIDER_GOOGLE_LOCAL_PLACE_TOPICS",
        "PROVIDER_GOOGLE_PROPERTY_INSIGHTS",
        "PROVIDER_GOOGLE_GEO_CONSUMER_MERCHANT_EXPERIMENTS",
        "PROVIDER_GOOGLE_GEO_PORTKEY",
        "PROVIDER_GOOGLE_ROAD_MAPPER",
        "PROVIDER_GOOGLE_LOCATION_PLATFORM",
        "PROVIDER_GOOGLE_POSTTRIP",
        "PROVIDER_GOOGLE_TRAVEL_DESTINATION",
        "PROVIDER_GOOGLE_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_BIZBUILDER_CLEANUP",
        "PROVIDER_GOOGLE_USER",
        "PROVIDER_GOOGLE_STATION",
        "PROVIDER_GOOGLE_GEO_FOOD",
        "PROVIDER_GOOGLE_GEO_AR",
        "PROVIDER_GOOGLE_GEO_TEMPORAL",
        "PROVIDER_GOOGLE_SERVICES_MARKETPLACE",
        "PROVIDER_GOOGLE_IMT_CLEANUP",
        "PROVIDER_GOOGLE_GEO_FOOD_MENU",
        "PROVIDER_GOOGLE_CARENAV",
        "PROVIDER_GOOGLE_DRIVING_FEEDS",
        "PROVIDER_GOOGLE_DRIVING_UGC",
        "PROVIDER_GOOGLE_POLAR",
        "PROVIDER_GOOGLE_TRIWILD",
        "PROVIDER_GOOGLE_CROWD_COMPUTE_OPS",
        "PROVIDER_GOOGLE_SA_FROM_WEB",
        "PROVIDER_GOOGLE_POI_ALIGNMENT",
        "PROVIDER_GOOGLE_SA_FROM_HULK",
        "PROVIDER_GOOGLE_SERVICES_INTERACTIONS",
        "PROVIDER_GOOGLE_ROADS_UGC_EDITOR",
        "PROVIDER_GOOGLE_SA_FROM_NG_INFERENCE",
        "PROVIDER_GOOGLE_GEO_DRIVING_VIZ",
        "PROVIDER_GOOGLE_GEO_TASKING",
        "PROVIDER_GOOGLE_CROWDTASK_DATACOMPUTE",
        "PROVIDER_GOOGLE_CROWDTASK_TASKADS",
        "PROVIDER_GOOGLE_CROWDTASK_TASKMATE",
        "PROVIDER_GOOGLE_CROWDTASK_FURBALL",
        "PROVIDER_GOOGLE_CROWDTASK_ADAP",
        "PROVIDER_GOOGLE_GPAY",
        "PROVIDER_GOOGLE_GEO_UGC_TRUSTED_USERS",
        "PROVIDER_GOOGLE_THIRD_PARTY_DATA_PRODUCTION",
        "PROVIDER_GOOGLE_GEOTRACKER",
        "PROVIDER_GOOGLE_LOCAL_LANDMARK_INFERENCE",
        "PROVIDER_GOOGLE_GEO_CLOSED_LOOP",
        "PROVIDER_GOOGLE_SA_FROM_MERCHANT_POSTS",
        "PROVIDER_GOOGLE_CORE_DATA_RIGHTS",
        "PROVIDER_GOOGLE_SA_FROM_USER_REVIEWS",
        "PROVIDER_GOOGLE_GEO_CONTENT_FIXER",
        "PROVIDER_GOOGLE_POLYGON_REFINEMENT",
        "PROVIDER_GOOGLE_HANASU",
        "PROVIDER_GOOGLE_FULLRIGHTS_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_FULLRIGHTS_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_ATTRIBUTION_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_SA_FROM_FOOD_MENUS",
        "PROVIDER_GOOGLE_GT_CONSISTENCY_EDITS",
        "PROVIDER_GOOGLE_SA_QUALITY",
        "PROVIDER_GOOGLE_GDCE_CLEANUP",
        "PROVIDER_GOOGLE_UGC_QUALITY_CHAINS",
        "PROVIDER_GOOGLE_ATTRIBUTES_DISCOVERY",
        "PROVIDER_GOOGLE_GEO_LDE",
        "PROVIDER_GOOGLE_GEO_SIGNAL_TRACKING",
        "PROVIDER_GOOGLE_UGC_AGGREGATION",
        "PROVIDER_GOOGLE_3D_BASEMAP",
        "PROVIDER_GOOGLE_MAPFACTS_PRIVACY",
        "PROVIDER_GOOGLE_GT_ALF",
        "PROVIDER_GOOGLE_GT_OPERATOR_PROVENANCE",
        "PROVIDER_GOOGLE_LOCAL_SERVICES_ADS",
        "PROVIDER_GOOGLE_GT_LANE_AUTOMATION",
        "PROVIDER_GOOGLE_GEO_NG_LOCAL",
        "PROVIDER_GOOGLE_MAPFACTS_CLEANUP",
        "PROVIDER_GOOGLE_THIRD_PARTY_UGC",
        "PROVIDER_GOOGLE_GEO_ISSUE_ADMIN",
        "PROVIDER_GOOGLE_LOCALSEARCH",
        "PROVIDER_GOOGLE_TRANSIT",
        "PROVIDER_GOOGLE_GEOWIKI",
        "PROVIDER_GOOGLE_CHINA_LOCAL_TEAM",
        "PROVIDER_GOOGLE_SYNTHESIZED",
        "PROVIDER_GOOGLE_INTERNAL_TEST",
        "PROVIDER_GOOGLE_DISPUTED_AREAS",
        "PROVIDER_GOOGLE_3DWAREHOUSE",
        "PROVIDER_GOOGLE_GROUNDS_BUILDER",
        "PROVIDER_GOOGLE_SESAME",
        "PROVIDER_GOOGLE_GT",
        "PROVIDER_GOOGLE_GT_BASEMAP_UPLOAD",
        "PROVIDER_GOOGLE_ADSDB",
        "PROVIDER_GOOGLE_MACHINE_TRANSLITERATION",
        "PROVIDER_GOOGLE_TRAVELSEARCH",
        "PROVIDER_GOOGLE_PANORAMIO",
        "PROVIDER_GOOGLE_YOUTUBE",
        "PROVIDER_GOOGLE_OLD",
        "PROVIDER_GOOGLE_STREETVIEW",
        "PROVIDER_GOOGLE_STREETVIEW_BIZVIEW",
        "PROVIDER_GOOGLE_ZIPIT",
        "PROVIDER_GOOGLE_OYSTER_CONNECT_ROUTES",
        "PROVIDER_GOOGLE_GOLDEN",
        "PROVIDER_GOOGLE_INNERSPACE",
        "PROVIDER_GOOGLE_MAPSEARCH",
        "PROVIDER_GOOGLE_CATEGORIES_TEAM",
        "PROVIDER_GOOGLE_CROWDSENSUS",
        "PROVIDER_GOOGLE_LOCAL_ALGORITHMIC_IDENTITY",
        "PROVIDER_GOOGLE_FREEBASE",
        "PROVIDER_GOOGLE_HOTELADS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGES",
        "PROVIDER_GOOGLE_PLACES_API",
        "PROVIDER_GOOGLE_NAMEHEATMAP",
        "PROVIDER_GOOGLE_MAPMAKER",
        "PROVIDER_GOOGLE_MAPMAKER_MOBILE",
        "PROVIDER_GOOGLE_MAPMAKER_PANCAKE",
        "PROVIDER_GOOGLE_MAPMAKER_V2",
        "PROVIDER_GOOGLE_LOCAL_CLUSTERING_OPERATOR_OVERRIDE",
        "PROVIDER_GOOGLE_SERVED_ON_MAPMAKER",
        "PROVIDER_GOOGLE_GT_LOCAL",
        "PROVIDER_GOOGLE_GT_LOCAL_WITH_RIGHTS",
        "PROVIDER_GOOGLE_LOGS_RANKING_SIGNALS",
        "PROVIDER_GOOGLE_ENTITY_NAVBOOST",
        "PROVIDER_GOOGLE_RELATED_PLACES",
        "PROVIDER_GOOGLE_KNOWN_FOR_TERMS",
        "PROVIDER_GOOGLE_SYNTHETIC_AREAS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGE_PHOTOS",
        "PROVIDER_GOOGLE_CROSS_STREETS",
        "PROVIDER_GOOGLE_CORRIDORS",
        "PROVIDER_GOOGLE_BICYCLE_RENTAL",
        "PROVIDER_GOOGLE_CONCRETE_URLS",
        "PROVIDER_GOOGLE_LEANBACK",
        "PROVIDER_GOOGLE_LOCKED_LISTINGS",
        "PROVIDER_GOOGLE_MONITORING",
        "PROVIDER_GOOGLE_SPROUT",
        "PROVIDER_GOOGLE_LOCAL_SEARCH_QUALITY",
        "PROVIDER_GOOGLE_GOBY",
        "PROVIDER_GOOGLE_PROBLEM_REPORT",
        "PROVIDER_GOOGLE_CANDID",
        "PROVIDER_GOOGLE_BIZBUILDER",
        "PROVIDER_AUTOMOTIVE_NAVIGATION_DATA",
        "PROVIDER_MAPDATA_SCIENCES",
        "PROVIDER_MAPONICS",
        "PROVIDER_SKI_RESORTS",
        "PROVIDER_ZENRIN",
        "PROVIDER_SANBORN",
        "PROVIDER_URBAN_MAPPING",
        "PROVIDER_US_GOVERNMENT",
        "PROVIDER_US_CENSUS",
        "PROVIDER_US_POSTAL_SERVICE",
        "PROVIDER_US_GEOLOGICAL_SURVEY",
        "PROVIDER_US_GNIS",
        "PROVIDER_US_LANDSAT",
        "PROVIDER_US_NATIONAL_GEOSPATIAL_INTELLIGENCE_AGENCY",
        "PROVIDER_US_NGA_GNS",
        "PROVIDER_US_SSIBL",
        "PROVIDER_US_BUREAU_OF_TRANSPORTATION_STATISTICS",
        "PROVIDER_US_NATIONAL_OCEANIC_AND_ATMOSPHERIC_ADMINISTRATION",
        "PROVIDER_US_POLAR_GEOSPATIAL_CENTER",
        "PROVIDER_US_DEPARTMENT_OF_AGRICULTURE",
        "PROVIDER_US_NPI_REGISTRY",
        "PROVIDER_US_BUREAU_OF_INDIAN_AFFAIRS",
        "PROVIDER_DMTI_SPATIAL",
        "PROVIDER_INTERNATIONAL_HYDROGRAPHIC_ORGANIZATION",
        "PROVIDER_MAPLINK",
        "PROVIDER_KINGWAY",
        "PROVIDER_GEOCENTRE",
        "PROVIDER_CN_NATIONAL_FOUNDAMENTAL_GIS",
        "PROVIDER_CN_MAPABC",
        "PROVIDER_SMITHSONIAN_INSTITUTE",
        "PROVIDER_TRACKS_FOR_AFRICA",
        "PROVIDER_PPWK",
        "PROVIDER_LEADDOG",
        "PROVIDER_CENTRE_DONNEES_ASTRONOMIQUES_STRASBOURG",
        "PROVIDER_GISRAEL",
        "PROVIDER_BASARSOFT",
        "PROVIDER_MAPINFO",
        "PROVIDER_MAPIT",
        "PROVIDER_GEOBASE",
        "PROVIDER_ORION",
        "PROVIDER_CENTRAL_EUROPEAN_DATA_AGENCY",
        "PROVIDER_ANASAT",
        "PROVIDER_MINED_POSTCODES",
        "PROVIDER_DMAPAS",
        "PROVIDER_COMMON_LOCALE_DATA_REPOSITORY",
        "PROVIDER_CH_SBB",
        "PROVIDER_SKENERGY",
        "PROVIDER_GBRMPA",
        "PROVIDER_KOREA_POST",
        "PROVIDER_CN_AUTONAVI",
        "PROVIDER_MINED_POI",
        "PROVIDER_ML_INFOMAP",
        "PROVIDER_SNOOPER",
        "PROVIDER_GEOSISTEMAS",
        "PROVIDER_AFRIGIS",
        "PROVIDER_TRANSNAVICOM",
        "PROVIDER_EASYCONNECT",
        "PROVIDER_LANTMATERIET",
        "PROVIDER_LOGICA",
        "PROVIDER_MAPKING",
        "PROVIDER_DIANPING",
        "PROVIDER_GEONAV",
        "PROVIDER_HEIBONSHA",
        "PROVIDER_DEUTSCHE_TELEKOM",
        "PROVIDER_LINGUISTIC_DATA_CONSORTIUM",
        "PROVIDER_ACXIOM",
        "PROVIDER_DUN_AND_BRADSTREET",
        "PROVIDER_FEDERAL_AVIATION_ADMINISTRATION",
        "PROVIDER_INFOUSA",
        "PROVIDER_INFOUSA_NIXIE",
        "PROVIDER_THOMSON_LOCAL",
        "PROVIDER_TELEFONICA_PUBLICIDAD_E_INFORMACION",
        "PROVIDER_WIKIPEDIA",
        "PROVIDER_INFOBEL",
        "PROVIDER_MX_GOVERNMENT",
        "PROVIDER_MX_NATIONAL_INSTITUTE_STATISTICS_GEOGRAPHY",
        "PROVIDER_MX_SERVICIO_POSTAL_MEXICANO",
        "PROVIDER_TELEGATE",
        "PROVIDER_TELELISTAS",
        "PROVIDER_MAPCITY",
        "PROVIDER_EXPLAINER_DC",
        "PROVIDER_DAIKEI",
        "PROVIDER_NL_CHAMBER_OF_COMMERCE",
        "PROVIDER_KOREA_INFO_SERVICE",
        "PROVIDER_WIKITRAVEL",
        "PROVIDER_FLICKR",
        "PROVIDER_DIANCO",
        "PROVIDER_VOLT_DELTA",
        "PROVIDER_SG_GOVERNMENT",
        "PROVIDER_SG_LAND_TRANSPORT_AUTHORITY",
        "PROVIDER_MAPBAR",
        "PROVIDER_LONGTU",
        "PROVIDER_SA_GOVERNMENT",
        "PROVIDER_SA_SAUDI_POST",
        "PROVIDER_PEAKLIST",
        "PROVIDER_LOCAL_BUSINESS_CENTER",
        "PROVIDER_LOCAL_FEED_XML",
        "PROVIDER_WEB",
        "PROVIDER_RAILS_TO_TRAILS",
        "PROVIDER_INDIACOM",
        "PROVIDER_INFOMEDIA",
        "PROVIDER_PICASA",
        "PROVIDER_AT_GOVERNMENT",
        "PROVIDER_AT_BUNDESAMT_FUR_EICH_UND_VERMESSUNGSWESEN",
        "PROVIDER_AT_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_AT_AUSTRIA_POST",
        "PROVIDER_NO_GOVERNMENT",
        "PROVIDER_NO_NORSK_EIENDOMSINFORMASJON",
        "PROVIDER_NO_POSTEN_NORGE_AS",
        "PROVIDER_CH_GOVERNMENT",
        "PROVIDER_CH_SWISS_POST",
        "PROVIDER_CH_SWISSTOPO",
        "PROVIDER_CH_SWISS_NATIONAL_PARK",
        "PROVIDER_NAVIT",
        "PROVIDER_GEOSEARCH",
        "PROVIDER_DE_GOVERNMENT",
        "PROVIDER_BUNDESAMT_KARTOGRAPHIE_UND_GEODASIE",
        "PROVIDER_BUNDESNETZAGENTUR",
        "PROVIDER_SCHOBER_GROUP",
        "PROVIDER_MIREO",
        "PROVIDER_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WEBSTER_TEXAS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_AMHERST_MASSACHUSETTS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BLOOMINGTON_INDIANA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PASADENA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_CHULA_VISTA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_TEMPE_ARIZONA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_COLUMBUS_OHIO",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PORTAGE_MICHIGAN",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GEORGETOWN_KENTUCKY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GREENVILLE_SOUTH_CAROLINA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_NASHVILLE_TENNESSEE",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WASHINGTON_DISTRICT_OF_COLUMBIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BOULDER_COLORADO",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY_ENVIRONMENT_BAY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY_BIELSKO_BIALA",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_FRANKFURT",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_HAMBURG",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_KARLSRUHE",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY_SANTA_CRUZ",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_KLAGENFURT",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_LINZ",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_AZKOITIA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_BEASAIN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_GIRONA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_SAN_SEBASTIAN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_CATALUNYA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_HONDARRIBIA",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY_LAUNCESTON_TASMANIA",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY_REYKJAVIK",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY_AMELSTEVEEN",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY_ANTWERPEN",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_FREDERICTON_NEW_BRUNSWICK",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_KAMLOOPS_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_NANAIMO_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_BANFF_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_CALGARY_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_TORONTO_ONTARIO",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY_UMEA",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY_KHARKIV",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY_AQUA_CALIENTE_CAHUILLA_INDIANS",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_PONT_AUDEMER",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_BORDEAUX",
        "PROVIDER_SG_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY_RIO_DE_JANEIRO",
        "PROVIDER_MAPCUBE",
        "PROVIDER_3D_REALITYMAPS",
        "PROVIDER_DEUTSCHES_ZENTRUM_FUR_LUFT_UND_RAUMFAHRT",
        "PROVIDER_3D_CITIES_SOCIEDADE_ANONIMA",
        "PROVIDER_DISNEY",
        "PROVIDER_CYBERCITY",
        "PROVIDER_PRECISION_LIGHTWORKS_MODELWORKS",
        "PROVIDER_VIRTUAL_HUNGARY_LIMITED",
        "PROVIDER_VIRTUEL_CITY",
        "PROVIDER_SCREAMPOINT_INTERNATIONAL",
        "PROVIDER_AGENTSCHAP_VOOR_GEOGRAFISCHE_INFORMATIE_VLAANDEREN",
        "PROVIDER_FR_GOVERNMENT",
        "PROVIDER_FR_INSTITUT_GEOGRAPHIQUE_NATIONAL",
        "PROVIDER_FR_CADASTRE",
        "PROVIDER_DIADIEM",
        "PROVIDER_THE_WEATHER_CHANNEL",
        "PROVIDER_COWI",
        "PROVIDER_FALKPLAN_ANDES",
        "PROVIDER_NL_GOVERNMENT",
        "PROVIDER_NL_KADASTER",
        "PROVIDER_NL_BOARD_OF_TOURISM_AND_CONVENTIONS",
        "PROVIDER_DIGITAL_MAP_PRODUCTS",
        "PROVIDER_SILICE_DIGITAL",
        "PROVIDER_TYDAC",
        "PROVIDER_ALBRECHT_GOLF",
        "PROVIDER_HEALTH_CH",
        "PROVIDER_VISITDENMARK",
        "PROVIDER_FLYHERE",
        "PROVIDER_DIGITAL_DATA_SERVICES",
        "PROVIDER_MECOMO",
        "PROVIDER_ZA_GOVERNMENT",
        "PROVIDER_ZA_RURAL_DEVELOPMENT_LAND_REFORM",
        "PROVIDER_SENSIS",
        "PROVIDER_JJCONNECT",
        "PROVIDER_OPPLYSNINGEN",
        "PROVIDER_TELLUS",
        "PROVIDER_IQONIA",
        "PROVIDER_BE_GOVERNMENT",
        "PROVIDER_BE_NATIONAAL_GEOGRAFISCH_INSTITUUT",
        "PROVIDER_BE_BRUSSELS_MOBILITY",
        "PROVIDER_YELLOWMAP_AG",
        "PROVIDER_STIFTUNG_GESUNDHEIT",
        "PROVIDER_GIATA",
        "PROVIDER_SANPARKS",
        "PROVIDER_CENTRE_DINFORMATIQUE_POUR_LA_REGION_BRUXELLOISE",
        "PROVIDER_INFOPORTUGAL",
        "PROVIDER_NEGOCIOS_DE_TELECOMUNICACOES_E_SISTEMAS_DE_INFORMACAO",
        "PROVIDER_COLLINS_BARTHOLOMEW",
        "PROVIDER_PROTECT_PLANET_OCEAN",
        "PROVIDER_KARTTAKESKUS",
        "PROVIDER_FI_GOVERNMENT",
        "PROVIDER_FI_NATIONAL_ROAD_ADMINISTRATION",
        "PROVIDER_FI_NATIONAL_LAND_SURVEY",
        "PROVIDER_FI_STATISTICS_FINLAND",
        "PROVIDER_GB_GOVERNMENT",
        "PROVIDER_GB_ORDNANCE_SURVEY",
        "PROVIDER_NATURAL_ENGLAND",
        "PROVIDER_WELSH_GOVERNMENT",
        "PROVIDER_GB_OFFICE_FOR_NATIONAL_STATISTICS",
        "PROVIDER_EPSILON",
        "PROVIDER_PARTNER_FRONT_END",
        "PROVIDER_CARTESIA",
        "PROVIDER_SE_GOVERNMENT",
        "PROVIDER_SE_TRAFIKVERKET",
        "PROVIDER_SE_NATURVARDSVERKET",
        "PROVIDER_IE_GOVERNMENT",
        "PROVIDER_IE_ORDNANCE_SURVEY_IRELAND",
        "PROVIDER_LU_GOVERNMENT",
        "PROVIDER_LU_P_AND_T_LUXEMBOURG",
        "PROVIDER_LU_ADMINISTRATION_DU_CADASTRE_ET_DE_LA_TOPOGRAPHIE",
        "PROVIDER_LU_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_MAPFLOW",
        "PROVIDER_TKARTOR",
        "PROVIDER_JUMPSTART",
        "PROVIDER_EPTISA",
        "PROVIDER_MC_GOVERNMENT",
        "PROVIDER_MC_PRINCIPAUTE_DE_MONACO",
        "PROVIDER_MONOLIT",
        "PROVIDER_ENVIRONMENTAL_SYSTEMS_RESEARCH_INSTITUTE",
        "PROVIDER_MODIS",
        "PROVIDER_GEOX",
        "PROVIDER_GEODIRECTORY",
        "PROVIDER_GEOPLAN",
        "PROVIDER_INFODIREKT",
        "PROVIDER_GEOGLOBAL",
        "PROVIDER_DEUTSCHE_POST",
        "PROVIDER_TRACASA",
        "PROVIDER_CORREOS",
        "PROVIDER_ES_GOVERNMENT",
        "PROVIDER_ES_CENTRO_NACIONAL_DE_INFORMACION_GEOGRAFICA",
        "PROVIDER_EDIMAP",
        "PROVIDER_VERIZON",
        "PROVIDER_NATIONAL_GEOGRAPHIC_MAPS",
        "PROVIDER_PROMAPS",
        "PROVIDER_CONSODATA",
        "PROVIDER_DE_AGOSTINI",
        "PROVIDER_FEDERPARCHI",
        "PROVIDER_NAVIGO",
        "PROVIDER_ITALIAMAPPE",
        "PROVIDER_CZECOT",
        "PROVIDER_NATURAL_EARTH",
        "PROVIDER_REGIO",
        "PROVIDER_SHIPWRECK_CENTRAL",
        "PROVIDER_RUTGERS_STATE_UNIVERSITY",
        "PROVIDER_TWINICE",
        "PROVIDER_NORTHERN_IRELAND_TOURIST_BOARD",
        "PROVIDER_INFOGROUP",
        "PROVIDER_TNET",
        "PROVIDER_CTT_CORREIOS_DE_PORTUGAL",
        "PROVIDER_EUROPARC",
        "PROVIDER_IUPPITER",
        "PROVIDER_MICHAEL_BAUER_INTERNATIONAL",
        "PROVIDER_LEPTON",
        "PROVIDER_MAPPOINT",
        "PROVIDER_GEODATA",
        "PROVIDER_RU_GOVERNMENT",
        "PROVIDER_RU_FNS_KLADR",
        "PROVIDER_BR_GOVERNMENT",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DO_MEIO_AMBIENTE_E_DOS_RECURSOS_NATURAIS_RENOVAVEIS",
        "PROVIDER_BR_MINISTERIO_DO_MEIO_AMBIENTE",
        "PROVIDER_BR_AGENCIA_NACIONAL_DE_AGUAS",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DE_GEOGRAFIA_E_ESTATISTICA",
        "PROVIDER_BR_FUNDACAO_NACIONAL_DO_INDIO",
        "PROVIDER_BR_DEPARTAMENTO_NACIONAL_DE_INFRAESTRUTURA_DE_TRANSPORTES",
        "PROVIDER_AZAVEA",
        "PROVIDER_NORTHSTAR",
        "PROVIDER_COMMEDI",
        "PROVIDER_NEXUS_GEOGRAFICS",
        "PROVIDER_INFOERA",
        "PROVIDER_AD_GOVERNMENT",
        "PROVIDER_AD_AREA_DE_CARTOGRAFIA",
        "PROVIDER_MAXXIMA",
        "PROVIDER_SI_GOVERNMENT",
        "PROVIDER_SI_AGENCY_FOR_ENVIRONMENT",
        "PROVIDER_TRANSPORT_HI_TECH_CONSULTANTS",
        "PROVIDER_L1_TECHNOLOGIES",
        "PROVIDER_TELEMEDIA",
        "PROVIDER_CDCOM_PROGOROD",
        "PROVIDER_MIT_CITYGUIDE",
        "PROVIDER_SUNCART",
        "PROVIDER_MICROMAPPER",
        "PROVIDER_RICHI",
        "PROVIDER_FORUM44",
        "PROVIDER_SEAT",
        "PROVIDER_VALASSIS",
        "PROVIDER_NAVICOM",
        "PROVIDER_COLTRACK",
        "PROVIDER_PSMA_AUSTRALIA",
        "PROVIDER_PT_DUTA_ASTAKONA_GIRINDA",
        "PROVIDER_CA_GOVERNMENT",
        "PROVIDER_STATISTICS_CANADA",
        "PROVIDER_TOCTOC",
        "PROVIDER_RMSI",
        "PROVIDER_TRUE_TECHNOLOGY",
        "PROVIDER_INCREMENT_P_CORPORATION",
        "PROVIDER_GOJAVAS",
        "PROVIDER_GEOINFORMATION_GROUP",
        "PROVIDER_CYBERSOFT",
        "PROVIDER_TSENTR_EFFEKTIVNYKH_TEKHNOLOGIY",
        "PROVIDER_EE_GOVERNMENT",
        "PROVIDER_EE_MAA_AMET",
        "PROVIDER_GASBUDDY",
        "PROVIDER_DK_GOVERNMENT",
        "PROVIDER_DK_GEODATASTYRELSEN",
        "PROVIDER_MURCIA_REGION_GOVERNMENT",
        "PROVIDER_CORREIOS",
        "PROVIDER_WEST_WORLD_MEDIA",
        "PROVIDER_INTERNATIONAL_MAPPING_ASSOCIATION",
        "PROVIDER_MEDICARE",
        "PROVIDER_POLARIS",
        "PROVIDER_TW_GOVERNMENT",
        "PROVIDER_TW_MINISTRY_OF_THE_INTERIOR_SURVEYING_AND_MAPPING_CENTER",
        "PROVIDER_NORDECA",
        "PROVIDER_AFRIMAPPING",
        "PROVIDER_OVERDRIVE",
        "PROVIDER_PROVIDER_NETWORK_DIRECTORIES",
        "PROVIDER_BR_MINISTERIO_DA_SAUDE",
        "PROVIDER_DIGITAL_EGYPT",
        "PROVIDER_INRIX",
        "PROVIDER_ARPINDO",
        "PROVIDER_IT_GOVERNMENT",
        "PROVIDER_ISTITUTO_GEOGRAFICO_MILITARE",
        "PROVIDER_EAST_END_GROUP",
        "PROVIDER_INGEOLAN",
        "PROVIDER_SEMACONNECT",
        "PROVIDER_BLINK",
        "PROVIDER_EVGO",
        "PROVIDER_CHARGEPOINT",
        "PROVIDER_TPL_TRAKKER",
        "PROVIDER_OI",
        "PROVIDER_MAPARADAR",
        "PROVIDER_SINGAPORE_POST",
        "PROVIDER_CHARGEMASTER",
        "PROVIDER_TESLA",
        "PROVIDER_VISICOM",
        "PROVIDER_GEOLYSIS",
        "PROVIDER_ZEPHEIRA",
        "PROVIDER_HUBJECT",
        "PROVIDER_PODPOINT",
        "PROVIDER_CHARGEFOX",
        "PROVIDER_KR_GOVERNMENT",
        "PROVIDER_KR_MOLIT",
        "PROVIDER_KR_MINISTRY_OF_THE_INTERIOR_AND_SAFETY",
        "PROVIDER_CRITCHLOW",
        "PROVIDER_EIFRIG",
        "PROVIDER_GIREVE",
        "PROVIDER_CN_NAVINFO",
        "PROVIDER_JAPAN_CHARGE_NETWORK",
        "PROVIDER_NOBIL",
        "PROVIDER_INDIA_BANKS",
        "PROVIDER_INDONESIA_ELECTION_KPU",
        "PROVIDER_CAREERS360",
        "PROVIDER_SOURCE_LONDON",
        "PROVIDER_EVBOX",
        "PROVIDER_JP_GOVERNMENT",
        "PROVIDER_JP_MINISTRY_OF_THE_ENVIRONMENT",
        "PROVIDER_YUMYUM",
        "PROVIDER_HWW_AUSTRALIA",
        "PROVIDER_CINERGY",
        "PROVIDER_MTIME",
        "PROVIDER_KULTUNAUT",
        "PROVIDER_BLITZ",
        "PROVIDER_PIA",
        "PROVIDER_INTERPARK",
        "PROVIDER_CINEMA_ONLINE",
        "PROVIDER_BELBIOS",
        "PROVIDER_MOVIESEER",
        "PROVIDER_SODAMEDYA",
        "PROVIDER_ATMOVIES",
        "PROVIDER_HOTELBEDS",
        "PROVIDER_VERICRED",
        "PROVIDER_CIRRANTIC",
        "PROVIDER_GOGO_LABS",
        "PROVIDER_ELECTRIFY_AMERICA",
        "PROVIDER_CMS_MPPUF",
        "PROVIDER_DIGIROAD",
        "PROVIDER_KONTEX_GEOMATICS",
        "PROVIDER_NZ_GOVERNMENT",
        "PROVIDER_NZ_LINZ",
        "PROVIDER_NZ_DOC",
        "PROVIDER_FASTNED",
        "PROVIDER_DESTINY_CS",
        "PROVIDER_IONITY",
        "PROVIDER_EV_CONNECT",
        "PROVIDER_PANPAGES",
        "PROVIDER_ETECNIC",
        "PROVIDER_VOLTA",
        "PROVIDER_NISSAN_MEXICO",
        "PROVIDER_BMW_GROUP_LATIN_AMERICA",
        "PROVIDER_FEDERAL_ELECTRICITY_COMMISSION_MEXICO",
        "PROVIDER_VOLVO_CARS_BRASIL",
        "PROVIDER_CHARGE_AND_PARKING",
        "PROVIDER_DEDUCE_TECHNOLOGIES",
        "PROVIDER_SK_TELECOM",
        "PROVIDER_ECO_MOVEMENT",
        "PROVIDER_GOOGLE_GMS",
        "PROVIDER_EASYWAY",
        "PROVIDER_PHYSICIAN_COMPARE",
        "PROVIDER_HOSPITAL_COMPARE",
        "PROVIDER_ENDOLLA_BARCELONA",
        "PROVIDER_BE_CHARGE",
        "PROVIDER_ONE_NETWORK",
        "PROVIDER_CARENAV_DUPLEX",
        "PROVIDER_CARENAV_POI",
        "PROVIDER_IN_GOVERNMENT",
        "PROVIDER_SURVEY_OF_INDIA",
        "PROVIDER_E_ON",
        "PROVIDER_ELECTRIFY_CANADA",
        "PROVIDER_GRIDCARS",
        "PROVIDER_DRIVECO",
        "PROVIDER_GREEN_ACTION_STUDIOS",
        "PROVIDER_GREEN_ACTION_STUDIO",
        "PROVIDER_EVINY",
        "PROVIDER_MASTERCARD",
        "PROVIDER_VATTENFALL",
        "PROVIDER_VIETGIS",
        "PROVIDER_UNITE",
        "PROVIDER_NEOGY",
        "PROVIDER_AMPUP",
        "PROVIDER_LOOP",
        "PROVIDER_ZEST",
        "PROVIDER_EZVOLT",
        "PROVIDER_JOLT",
        "PROVIDER_CHARGESMITH",
        "PROVIDER_PLUGO",
        "PROVIDER_ELECTRIC_ERA",
    ]

@typing.type_check_only
class GeostoreIntersectionGroupProto(typing_extensions.TypedDict, total=False):
    childGroup: _list[GeostoreFeatureIdProto]
    groupType: typing_extensions.Literal["GROUP_ARTIFACT", "GROUP_LOGICAL"]
    intersection: _list[GeostoreFeatureIdProto]
    parentGroup: GeostoreFeatureIdProto

@typing.type_check_only
class GeostoreIntersectionProto(typing_extensions.TypedDict, total=False):
    intersectionGroup: GeostoreFeatureIdProto
    outSegment: _list[GeostoreFeatureIdProto]
    segment: _list[GeostoreFeatureIdProto]
    tollClusterId: GeostoreFeatureIdProto

@typing.type_check_only
class GeostoreJobMetadata(typing_extensions.TypedDict, total=False):
    duration: str
    jobRelatedCategories: _list[GeostoreJobRelatedCategory]
    jobTypeId: str
    jobTypeMid: str

@typing.type_check_only
class GeostoreJobRelatedCategory(typing_extensions.TypedDict, total=False):
    gcid: str
    language: str
    name: str

@typing.type_check_only
class GeostoreKnowledgeGraphReferenceProto(typing_extensions.TypedDict, total=False):
    id: str

@typing.type_check_only
class GeostoreLandmarkReferenceProto(typing_extensions.TypedDict, total=False):
    featureType: int
    landmark: GeostoreFeatureIdProto
    travelMode: _list[
        typing_extensions.Literal[
            "UNKNOWN",
            "TRAVEL_MOTOR_VEHICLE",
            "TRAVEL_AUTO",
            "TRAVEL_TWO_WHEELER",
            "TRAVEL_BICYCLE",
            "TRAVEL_PEDESTRIAN",
        ]
    ]

@typing.type_check_only
class GeostoreLaneMarkerProto(typing_extensions.TypedDict, total=False):
    barrierMaterials: GeostoreBarrierLogicalMaterialProto
    crossingPattern: GeostoreCrossingStripePatternProto
    linearPattern: GeostoreLinearStripePatternProto

@typing.type_check_only
class GeostoreLaneProto(typing_extensions.TypedDict, total=False):
    boundingMarker: _list[GeostoreBoundingMarkerProto]
    conjoinedCategory: typing_extensions.Literal[
        "CONJOINED_NONE",
        "CONJOINED_SPLIT_LEFT",
        "CONJOINED_SPLIT_MIDDLE",
        "CONJOINED_SPLIT_RIGHT",
        "CONJOINED_MERGE_LEFT",
        "CONJOINED_MERGE_MIDDLE",
        "CONJOINED_MERGE_RIGHT",
    ]
    distanceToNextLane: float
    flow: GeostoreFlowLineProto
    laneConnection: _list[GeostoreLaneProtoLaneConnection]
    laneDividerCrossing: typing_extensions.Literal[
        "CROSSING_ALLOWED",
        "CROSSING_DISALLOWED",
        "CROSSING_LEGALLY_DISALLOWED",
        "CROSSING_PHYSICALLY_IMPOSSIBLE",
    ]
    laneFollowsSegmentBeginFraction: float
    laneFollowsSegmentEndFraction: float
    laneNumber: int
    laneToken: str
    metadata: GeostoreFieldMetadataProto
    restriction: _list[GeostoreRestrictionProto]
    shared: bool
    stopLine: _list[GeostoreFeatureIdProto]
    surface: typing_extensions.Literal[
        "SURFACE_UNKNOWN",
        "SURFACE_PAVED",
        "SURFACE_ASPHALT",
        "SURFACE_CONCRETE",
        "SURFACE_CHIPSEAL",
        "SURFACE_BRICK",
        "SURFACE_SETT",
        "SURFACE_COBBLESTONE",
        "SURFACE_UNPAVED",
        "SURFACE_GRAVEL",
        "SURFACE_DIRT",
        "SURFACE_SAND",
    ]
    type: typing_extensions.Literal[
        "TYPE_UNKNOWN",
        "TYPE_NORMAL",
        "TYPE_PASSING",
        "TYPE_LEFT_TURN",
        "TYPE_LEFT_TURN_OFF",
        "TYPE_LEFT_TURN_ON_OFF",
        "TYPE_RIGHT_TURN",
        "TYPE_RIGHT_TURN_OFF",
        "TYPE_RIGHT_TURN_ON_OFF",
        "TYPE_BICYCLE",
        "TYPE_PARKING",
        "TYPE_PARKING_IMPLIED",
        "TYPE_PARKING_MARKED",
        "TYPE_EXIT_ENTRANCE",
        "TYPE_EXIT_LANE",
        "TYPE_ENTRANCE_LANE",
        "TYPE_PEDESTRIAN",
        "TYPE_SIDEWALK_SHOULDER",
        "TYPE_VEHICLE_SHOULDER",
        "TYPE_OFFSET",
    ]
    width: float

@typing.type_check_only
class GeostoreLaneProtoLaneConnection(typing_extensions.TypedDict, total=False):
    boundingMarker: _list[GeostoreBoundingMarkerProto]
    connectionToken: str
    curve: GeostoreCurveConnectionProto
    flow: GeostoreFlowLineProto
    laneNumber: int
    primaryConnection: bool
    segment: GeostoreFeatureIdProto
    yieldToOtherConnections: bool

@typing.type_check_only
class GeostoreLanguageTaggedTextProto(typing_extensions.TypedDict, total=False):
    language: str
    text: str

@typing.type_check_only
class GeostoreLevelProto(typing_extensions.TypedDict, total=False):
    building: _list[GeostoreFeatureIdProto]
    number: float

@typing.type_check_only
class GeostoreLinearStripePatternProto(typing_extensions.TypedDict, total=False):
    line: _list[GeostorePhysicalLineProto]

@typing.type_check_only
class GeostoreLocaleLanguageProto(typing_extensions.TypedDict, total=False):
    language: str
    official: bool
    preference: float
    speakingPercent: float
    writingPercent: float

@typing.type_check_only
class GeostoreLocaleProto(typing_extensions.TypedDict, total=False):
    language: _list[GeostoreLocaleLanguageProto]
    localizationPolicyId: str

@typing.type_check_only
class GeostoreLogicalBorderProto(typing_extensions.TypedDict, total=False):
    borderSegment: _list[GeostoreFeatureIdProto]
    status: typing_extensions.Literal[
        "STATUS_UNSPECIFIED", "STATUS_NORMAL", "STATUS_DISPUTED"
    ]

@typing.type_check_only
class GeostoreMediaItemProto(typing_extensions.TypedDict, total=False):
    googleUrl: str
    mediaFormat: typing_extensions.Literal[
        "MEDIA_FORMAT_UNSPECIFIED", "MEDIA_FORMAT_PHOTO"
    ]
    mediaKey: str
    mediaSize: GeostoreMediaItemProtoMediaSize

@typing.type_check_only
class GeostoreMediaItemProtoMediaSize(typing_extensions.TypedDict, total=False):
    originalHeightPx: int
    originalWidthPx: int

@typing.type_check_only
class GeostoreNameProto(typing_extensions.TypedDict, total=False):
    flag: _list[
        typing_extensions.Literal[
            "FLAG_ANY",
            "FLAG_IN_LOCAL_LANGUAGE",
            "FLAG_PREFERRED",
            "FLAG_OFFICIAL",
            "FLAG_OBSCURE",
            "FLAG_ON_SIGNS",
            "FLAG_EXIT_NAME_NUMBER",
            "FLAG_EXIT_NAME",
            "FLAG_INTERCHANGE_NAME",
            "FLAG_EXIT_NUMBER",
            "FLAG_INTERCHANGE_NUMBER",
            "FLAG_TRANSIT_HEADSIGN",
            "FLAG_CONNECTS_DIRECTLY",
            "FLAG_CONNECTS_INDIRECTLY",
            "FLAG_INTERSECTION_NAME",
            "FLAG_VANITY",
            "FLAG_ROUTE_NUMBER",
            "FLAG_COUNTRY_CODE_2",
            "FLAG_ABBREVIATED",
            "FLAG_ID",
            "FLAG_DESIGNATED_MARKET_AREA_ID",
            "FLAG_IATA_ID",
            "FLAG_ICAO_ID",
            "FLAG_ISO_3166_2",
            "FLAG_COUNTRY_SPECIFIC_ID",
            "FLAG_LANGUAGE_CODE",
            "FLAG_TIMEZONE_ID",
            "FLAG_PHONE_NUMBER_PREFIX",
            "FLAG_PHONE_NUMBER_AREA_CODE",
            "FLAG_TRANSLITERATED",
            "FLAG_NOT_ON_SIGNS",
            "FLAG_NOT_IN_LOCAL_LANGUAGE",
            "FLAG_ROUNDABOUT_ROUTE",
            "FLAG_NEVER_DISPLAY",
            "FLAG_BICYCLE_ROUTE",
            "FLAG_MACHINE_GENERATED",
            "FLAG_SUSPICIOUS",
        ]
    ]
    language: str
    metadata: GeostoreFieldMetadataProto
    rawText: str
    shortText: str
    temporaryData: Proto2BridgeMessageSet
    text: str

@typing.type_check_only
class GeostoreOntologyRawGConceptInstanceContainerProto(
    typing_extensions.TypedDict, total=False
):
    instance: _list[GeostoreOntologyRawGConceptInstanceProto]

@typing.type_check_only
class GeostoreOntologyRawGConceptInstanceProto(
    typing_extensions.TypedDict, total=False
):
    instance: GeostoreGConceptInstanceProto
    isAddedByEdit: bool
    isInferred: bool
    provider: typing_extensions.Literal[
        "PROVIDER_ANY",
        "PROVIDER_UNKNOWN",
        "PROVIDER_NAVTEQ",
        "PROVIDER_TELE_ATLAS",
        "PROVIDER_TELE_ATLAS_MULTINET",
        "PROVIDER_TELE_ATLAS_CODEPOINT",
        "PROVIDER_TELE_ATLAS_GEOPOST",
        "PROVIDER_TELE_ATLAS_DATAGEO",
        "PROVIDER_TELE_ATLAS_ADDRESS_POINTS",
        "PROVIDER_TELCONTAR",
        "PROVIDER_EUROPA",
        "PROVIDER_ROYAL_MAIL",
        "PROVIDER_GOOGLE",
        "PROVIDER_GOOGLE_HAND_EDIT",
        "PROVIDER_GOOGLE_BORDERS",
        "PROVIDER_GOOGLE_SUBRANGE",
        "PROVIDER_GOOGLE_GT_FUSION",
        "PROVIDER_GOOGLE_ZAGAT_CMS",
        "PROVIDER_GOOGLE_PLACE_NAVBOOST",
        "PROVIDER_GOOGLE_FOOTPRINT",
        "PROVIDER_GOOGLE_PRODUCT_TERMS",
        "PROVIDER_GOOGLE_POINTCARDS",
        "PROVIDER_GOOGLE_BUSINESS_CHAINS",
        "PROVIDER_GOOGLE_LOCAL_SUMMARIZATION",
        "PROVIDER_GOOGLE_PRONUNCIATIONS",
        "PROVIDER_GOOGLE_DUMPLING",
        "PROVIDER_GOOGLE_DISTILLERY",
        "PROVIDER_GOOGLE_LOCAL_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_RELATION_MINER",
        "PROVIDER_GOOGLE_MAPSPAM",
        "PROVIDER_GOOGLE_ROSE",
        "PROVIDER_GOOGLE_LOCAL_PLACE_RATINGS",
        "PROVIDER_GOOGLE_WIPEOUT",
        "PROVIDER_GOOGLE_KNOWLEDGE_GRAPH",
        "PROVIDER_GOOGLE_BEEGEES",
        "PROVIDER_GOOGLE_REVIEW_SUMMARIZATION",
        "PROVIDER_GOOGLE_OFFLINE_NON_CORE_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_GEO_WORLDMAPS",
        "PROVIDER_GOOGLE_GEO_MODERATION",
        "PROVIDER_GOOGLE_OYSTER_AUTO_EDITS",
        "PROVIDER_GOOGLE_LOCAL_ALCHEMY",
        "PROVIDER_GOOGLE_KEROUAC",
        "PROVIDER_GOOGLE_MOBRANK",
        "PROVIDER_GOOGLE_RAPTURE",
        "PROVIDER_GOOGLE_CULTURAL_INSTITUTE",
        "PROVIDER_GOOGLE_GEOCODES_FROM_LOCAL_FEEDS",
        "PROVIDER_GOOGLE_ATTRIBUTES_FROM_CRAWLED_CHAINS",
        "PROVIDER_GOOGLE_TACTILE_MAPS",
        "PROVIDER_GOOGLE_MAPS_FOR_MOBILE",
        "PROVIDER_GOOGLE_GEO_REALTIME",
        "PROVIDER_GOOGLE_PROMINENT_PLACES",
        "PROVIDER_GOOGLE_PLACE_ACTIONS",
        "PROVIDER_GOOGLE_GT_AUTO_EDITS",
        "PROVIDER_GOOGLE_WAZE",
        "PROVIDER_GOOGLE_ONTHEGO",
        "PROVIDER_GOOGLE_GT_IMPORT",
        "PROVIDER_GOOGLE_STRUCTURED_DATA",
        "PROVIDER_GOOGLE_HELICOPTER",
        "PROVIDER_GOOGLE_ROLLBACK",
        "PROVIDER_GOOGLE_RIGHTS_REPAIR",
        "PROVIDER_GOOGLE_PERFUME",
        "PROVIDER_GOOGLE_MAPS_TRANSLATION",
        "PROVIDER_GOOGLE_CALL_ME_MAYBE",
        "PROVIDER_GOOGLE_LOCAL_UNIVERSAL",
        "PROVIDER_GOOGLE_CROUPIER",
        "PROVIDER_GOOGLE_SKYSMART",
        "PROVIDER_GOOGLE_RIDDLER",
        "PROVIDER_GOOGLE_ROADCLOSURES",
        "PROVIDER_GOOGLE_SPORE",
        "PROVIDER_GOOGLE_LOCALIZATION",
        "PROVIDER_GOOGLE_CATTERMS",
        "PROVIDER_GOOGLE_GT_FIELD_OPS",
        "PROVIDER_GOOGLE_MATCHMAKER",
        "PROVIDER_GOOGLE_ARBITRATION",
        "PROVIDER_GOOGLE_BIZBUILDER_OPS",
        "PROVIDER_GOOGLE_LOCAL_INVENTORY_ADS",
        "PROVIDER_GOOGLE_GT_DRAFTY",
        "PROVIDER_GOOGLE_HOTELADS_OPS",
        "PROVIDER_GOOGLE_MARKERS",
        "PROVIDER_GOOGLE_STATE_MACHINE",
        "PROVIDER_GOOGLE_ATTRIBUTES_INFERENCE",
        "PROVIDER_GOOGLE_BIKESHARE",
        "PROVIDER_GOOGLE_GHOSTWRITER",
        "PROVIDER_GOOGLE_EDIT_PLATFORM",
        "PROVIDER_GOOGLE_BLUE_GINGER",
        "PROVIDER_GOOGLE_GEO_TIGER",
        "PROVIDER_GOOGLE_HYADES",
        "PROVIDER_GOOGLE_WEBQUARRY",
        "PROVIDER_GOOGLE_GEO_MADDEN",
        "PROVIDER_GOOGLE_ANDROID_PAY",
        "PROVIDER_GOOGLE_OPENING_HOURS_TEAM",
        "PROVIDER_GOOGLE_LOCAL_DISCOVERY",
        "PROVIDER_GOOGLE_LOCAL_HEALTH",
        "PROVIDER_GOOGLE_UGC_MAPS",
        "PROVIDER_GOOGLE_FIBER",
        "PROVIDER_GOOGLE_REVGEO",
        "PROVIDER_GOOGLE_HOTELADS_PARTNER_FRONT_END",
        "PROVIDER_GOOGLE_GEO_UGC_TASKS",
        "PROVIDER_GOOGLE_GEOCODING",
        "PROVIDER_GOOGLE_SPYGLASS",
        "PROVIDER_GOOGLE_PLUS_CODES_AS_ADDRESSES",
        "PROVIDER_GOOGLE_GEO_CHANGES",
        "PROVIDER_GOOGLE_HUME",
        "PROVIDER_GOOGLE_MEGAMIND",
        "PROVIDER_GOOGLE_GT_ROADSYNTH",
        "PROVIDER_GOOGLE_FIREBOLT",
        "PROVIDER_GOOGLE_LOCAL_PLACE_OFFERINGS",
        "PROVIDER_GOOGLE_UGC_SERVICES",
        "PROVIDER_GOOGLE_GEOALIGN",
        "PROVIDER_GOOGLE_GT_COMPOUNDS",
        "PROVIDER_GOOGLE_FOOD_ORDERING",
        "PROVIDER_GOOGLE_HOTEL_KNOWLEDGE_OPS",
        "PROVIDER_GOOGLE_URAW",
        "PROVIDER_GOOGLE_FLYEYE",
        "PROVIDER_GOOGLE_YOUKE",
        "PROVIDER_GOOGLE_GT_ZEPHYR",
        "PROVIDER_GOOGLE_USER_SAFETY",
        "PROVIDER_GOOGLE_ADDRESS_MAKER",
        "PROVIDER_GOOGLE_UGC_PHOTOS",
        "PROVIDER_GOOGLE_GT_WINDCHIME",
        "PROVIDER_GOOGLE_SNAG_FIXER",
        "PROVIDER_GOOGLE_GEO_DEALS",
        "PROVIDER_GOOGLE_LOCAL_PLACE_TOPICS",
        "PROVIDER_GOOGLE_PROPERTY_INSIGHTS",
        "PROVIDER_GOOGLE_GEO_CONSUMER_MERCHANT_EXPERIMENTS",
        "PROVIDER_GOOGLE_GEO_PORTKEY",
        "PROVIDER_GOOGLE_ROAD_MAPPER",
        "PROVIDER_GOOGLE_LOCATION_PLATFORM",
        "PROVIDER_GOOGLE_POSTTRIP",
        "PROVIDER_GOOGLE_TRAVEL_DESTINATION",
        "PROVIDER_GOOGLE_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_BIZBUILDER_CLEANUP",
        "PROVIDER_GOOGLE_USER",
        "PROVIDER_GOOGLE_STATION",
        "PROVIDER_GOOGLE_GEO_FOOD",
        "PROVIDER_GOOGLE_GEO_AR",
        "PROVIDER_GOOGLE_GEO_TEMPORAL",
        "PROVIDER_GOOGLE_SERVICES_MARKETPLACE",
        "PROVIDER_GOOGLE_IMT_CLEANUP",
        "PROVIDER_GOOGLE_GEO_FOOD_MENU",
        "PROVIDER_GOOGLE_CARENAV",
        "PROVIDER_GOOGLE_DRIVING_FEEDS",
        "PROVIDER_GOOGLE_DRIVING_UGC",
        "PROVIDER_GOOGLE_POLAR",
        "PROVIDER_GOOGLE_TRIWILD",
        "PROVIDER_GOOGLE_CROWD_COMPUTE_OPS",
        "PROVIDER_GOOGLE_SA_FROM_WEB",
        "PROVIDER_GOOGLE_POI_ALIGNMENT",
        "PROVIDER_GOOGLE_SA_FROM_HULK",
        "PROVIDER_GOOGLE_SERVICES_INTERACTIONS",
        "PROVIDER_GOOGLE_ROADS_UGC_EDITOR",
        "PROVIDER_GOOGLE_SA_FROM_NG_INFERENCE",
        "PROVIDER_GOOGLE_GEO_DRIVING_VIZ",
        "PROVIDER_GOOGLE_GEO_TASKING",
        "PROVIDER_GOOGLE_CROWDTASK_DATACOMPUTE",
        "PROVIDER_GOOGLE_CROWDTASK_TASKADS",
        "PROVIDER_GOOGLE_CROWDTASK_TASKMATE",
        "PROVIDER_GOOGLE_CROWDTASK_FURBALL",
        "PROVIDER_GOOGLE_CROWDTASK_ADAP",
        "PROVIDER_GOOGLE_GPAY",
        "PROVIDER_GOOGLE_GEO_UGC_TRUSTED_USERS",
        "PROVIDER_GOOGLE_THIRD_PARTY_DATA_PRODUCTION",
        "PROVIDER_GOOGLE_GEOTRACKER",
        "PROVIDER_GOOGLE_LOCAL_LANDMARK_INFERENCE",
        "PROVIDER_GOOGLE_GEO_CLOSED_LOOP",
        "PROVIDER_GOOGLE_SA_FROM_MERCHANT_POSTS",
        "PROVIDER_GOOGLE_CORE_DATA_RIGHTS",
        "PROVIDER_GOOGLE_SA_FROM_USER_REVIEWS",
        "PROVIDER_GOOGLE_GEO_CONTENT_FIXER",
        "PROVIDER_GOOGLE_POLYGON_REFINEMENT",
        "PROVIDER_GOOGLE_HANASU",
        "PROVIDER_GOOGLE_FULLRIGHTS_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_FULLRIGHTS_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_ATTRIBUTION_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_SA_FROM_FOOD_MENUS",
        "PROVIDER_GOOGLE_GT_CONSISTENCY_EDITS",
        "PROVIDER_GOOGLE_SA_QUALITY",
        "PROVIDER_GOOGLE_GDCE_CLEANUP",
        "PROVIDER_GOOGLE_UGC_QUALITY_CHAINS",
        "PROVIDER_GOOGLE_ATTRIBUTES_DISCOVERY",
        "PROVIDER_GOOGLE_GEO_LDE",
        "PROVIDER_GOOGLE_GEO_SIGNAL_TRACKING",
        "PROVIDER_GOOGLE_UGC_AGGREGATION",
        "PROVIDER_GOOGLE_3D_BASEMAP",
        "PROVIDER_GOOGLE_MAPFACTS_PRIVACY",
        "PROVIDER_GOOGLE_GT_ALF",
        "PROVIDER_GOOGLE_GT_OPERATOR_PROVENANCE",
        "PROVIDER_GOOGLE_LOCAL_SERVICES_ADS",
        "PROVIDER_GOOGLE_GT_LANE_AUTOMATION",
        "PROVIDER_GOOGLE_GEO_NG_LOCAL",
        "PROVIDER_GOOGLE_MAPFACTS_CLEANUP",
        "PROVIDER_GOOGLE_THIRD_PARTY_UGC",
        "PROVIDER_GOOGLE_GEO_ISSUE_ADMIN",
        "PROVIDER_GOOGLE_LOCALSEARCH",
        "PROVIDER_GOOGLE_TRANSIT",
        "PROVIDER_GOOGLE_GEOWIKI",
        "PROVIDER_GOOGLE_CHINA_LOCAL_TEAM",
        "PROVIDER_GOOGLE_SYNTHESIZED",
        "PROVIDER_GOOGLE_INTERNAL_TEST",
        "PROVIDER_GOOGLE_DISPUTED_AREAS",
        "PROVIDER_GOOGLE_3DWAREHOUSE",
        "PROVIDER_GOOGLE_GROUNDS_BUILDER",
        "PROVIDER_GOOGLE_SESAME",
        "PROVIDER_GOOGLE_GT",
        "PROVIDER_GOOGLE_GT_BASEMAP_UPLOAD",
        "PROVIDER_GOOGLE_ADSDB",
        "PROVIDER_GOOGLE_MACHINE_TRANSLITERATION",
        "PROVIDER_GOOGLE_TRAVELSEARCH",
        "PROVIDER_GOOGLE_PANORAMIO",
        "PROVIDER_GOOGLE_YOUTUBE",
        "PROVIDER_GOOGLE_OLD",
        "PROVIDER_GOOGLE_STREETVIEW",
        "PROVIDER_GOOGLE_STREETVIEW_BIZVIEW",
        "PROVIDER_GOOGLE_ZIPIT",
        "PROVIDER_GOOGLE_OYSTER_CONNECT_ROUTES",
        "PROVIDER_GOOGLE_GOLDEN",
        "PROVIDER_GOOGLE_INNERSPACE",
        "PROVIDER_GOOGLE_MAPSEARCH",
        "PROVIDER_GOOGLE_CATEGORIES_TEAM",
        "PROVIDER_GOOGLE_CROWDSENSUS",
        "PROVIDER_GOOGLE_LOCAL_ALGORITHMIC_IDENTITY",
        "PROVIDER_GOOGLE_FREEBASE",
        "PROVIDER_GOOGLE_HOTELADS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGES",
        "PROVIDER_GOOGLE_PLACES_API",
        "PROVIDER_GOOGLE_NAMEHEATMAP",
        "PROVIDER_GOOGLE_MAPMAKER",
        "PROVIDER_GOOGLE_MAPMAKER_MOBILE",
        "PROVIDER_GOOGLE_MAPMAKER_PANCAKE",
        "PROVIDER_GOOGLE_MAPMAKER_V2",
        "PROVIDER_GOOGLE_LOCAL_CLUSTERING_OPERATOR_OVERRIDE",
        "PROVIDER_GOOGLE_SERVED_ON_MAPMAKER",
        "PROVIDER_GOOGLE_GT_LOCAL",
        "PROVIDER_GOOGLE_GT_LOCAL_WITH_RIGHTS",
        "PROVIDER_GOOGLE_LOGS_RANKING_SIGNALS",
        "PROVIDER_GOOGLE_ENTITY_NAVBOOST",
        "PROVIDER_GOOGLE_RELATED_PLACES",
        "PROVIDER_GOOGLE_KNOWN_FOR_TERMS",
        "PROVIDER_GOOGLE_SYNTHETIC_AREAS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGE_PHOTOS",
        "PROVIDER_GOOGLE_CROSS_STREETS",
        "PROVIDER_GOOGLE_CORRIDORS",
        "PROVIDER_GOOGLE_BICYCLE_RENTAL",
        "PROVIDER_GOOGLE_CONCRETE_URLS",
        "PROVIDER_GOOGLE_LEANBACK",
        "PROVIDER_GOOGLE_LOCKED_LISTINGS",
        "PROVIDER_GOOGLE_MONITORING",
        "PROVIDER_GOOGLE_SPROUT",
        "PROVIDER_GOOGLE_LOCAL_SEARCH_QUALITY",
        "PROVIDER_GOOGLE_GOBY",
        "PROVIDER_GOOGLE_PROBLEM_REPORT",
        "PROVIDER_GOOGLE_CANDID",
        "PROVIDER_GOOGLE_BIZBUILDER",
        "PROVIDER_AUTOMOTIVE_NAVIGATION_DATA",
        "PROVIDER_MAPDATA_SCIENCES",
        "PROVIDER_MAPONICS",
        "PROVIDER_SKI_RESORTS",
        "PROVIDER_ZENRIN",
        "PROVIDER_SANBORN",
        "PROVIDER_URBAN_MAPPING",
        "PROVIDER_US_GOVERNMENT",
        "PROVIDER_US_CENSUS",
        "PROVIDER_US_POSTAL_SERVICE",
        "PROVIDER_US_GEOLOGICAL_SURVEY",
        "PROVIDER_US_GNIS",
        "PROVIDER_US_LANDSAT",
        "PROVIDER_US_NATIONAL_GEOSPATIAL_INTELLIGENCE_AGENCY",
        "PROVIDER_US_NGA_GNS",
        "PROVIDER_US_SSIBL",
        "PROVIDER_US_BUREAU_OF_TRANSPORTATION_STATISTICS",
        "PROVIDER_US_NATIONAL_OCEANIC_AND_ATMOSPHERIC_ADMINISTRATION",
        "PROVIDER_US_POLAR_GEOSPATIAL_CENTER",
        "PROVIDER_US_DEPARTMENT_OF_AGRICULTURE",
        "PROVIDER_US_NPI_REGISTRY",
        "PROVIDER_US_BUREAU_OF_INDIAN_AFFAIRS",
        "PROVIDER_DMTI_SPATIAL",
        "PROVIDER_INTERNATIONAL_HYDROGRAPHIC_ORGANIZATION",
        "PROVIDER_MAPLINK",
        "PROVIDER_KINGWAY",
        "PROVIDER_GEOCENTRE",
        "PROVIDER_CN_NATIONAL_FOUNDAMENTAL_GIS",
        "PROVIDER_CN_MAPABC",
        "PROVIDER_SMITHSONIAN_INSTITUTE",
        "PROVIDER_TRACKS_FOR_AFRICA",
        "PROVIDER_PPWK",
        "PROVIDER_LEADDOG",
        "PROVIDER_CENTRE_DONNEES_ASTRONOMIQUES_STRASBOURG",
        "PROVIDER_GISRAEL",
        "PROVIDER_BASARSOFT",
        "PROVIDER_MAPINFO",
        "PROVIDER_MAPIT",
        "PROVIDER_GEOBASE",
        "PROVIDER_ORION",
        "PROVIDER_CENTRAL_EUROPEAN_DATA_AGENCY",
        "PROVIDER_ANASAT",
        "PROVIDER_MINED_POSTCODES",
        "PROVIDER_DMAPAS",
        "PROVIDER_COMMON_LOCALE_DATA_REPOSITORY",
        "PROVIDER_CH_SBB",
        "PROVIDER_SKENERGY",
        "PROVIDER_GBRMPA",
        "PROVIDER_KOREA_POST",
        "PROVIDER_CN_AUTONAVI",
        "PROVIDER_MINED_POI",
        "PROVIDER_ML_INFOMAP",
        "PROVIDER_SNOOPER",
        "PROVIDER_GEOSISTEMAS",
        "PROVIDER_AFRIGIS",
        "PROVIDER_TRANSNAVICOM",
        "PROVIDER_EASYCONNECT",
        "PROVIDER_LANTMATERIET",
        "PROVIDER_LOGICA",
        "PROVIDER_MAPKING",
        "PROVIDER_DIANPING",
        "PROVIDER_GEONAV",
        "PROVIDER_HEIBONSHA",
        "PROVIDER_DEUTSCHE_TELEKOM",
        "PROVIDER_LINGUISTIC_DATA_CONSORTIUM",
        "PROVIDER_ACXIOM",
        "PROVIDER_DUN_AND_BRADSTREET",
        "PROVIDER_FEDERAL_AVIATION_ADMINISTRATION",
        "PROVIDER_INFOUSA",
        "PROVIDER_INFOUSA_NIXIE",
        "PROVIDER_THOMSON_LOCAL",
        "PROVIDER_TELEFONICA_PUBLICIDAD_E_INFORMACION",
        "PROVIDER_WIKIPEDIA",
        "PROVIDER_INFOBEL",
        "PROVIDER_MX_GOVERNMENT",
        "PROVIDER_MX_NATIONAL_INSTITUTE_STATISTICS_GEOGRAPHY",
        "PROVIDER_MX_SERVICIO_POSTAL_MEXICANO",
        "PROVIDER_TELEGATE",
        "PROVIDER_TELELISTAS",
        "PROVIDER_MAPCITY",
        "PROVIDER_EXPLAINER_DC",
        "PROVIDER_DAIKEI",
        "PROVIDER_NL_CHAMBER_OF_COMMERCE",
        "PROVIDER_KOREA_INFO_SERVICE",
        "PROVIDER_WIKITRAVEL",
        "PROVIDER_FLICKR",
        "PROVIDER_DIANCO",
        "PROVIDER_VOLT_DELTA",
        "PROVIDER_SG_GOVERNMENT",
        "PROVIDER_SG_LAND_TRANSPORT_AUTHORITY",
        "PROVIDER_MAPBAR",
        "PROVIDER_LONGTU",
        "PROVIDER_SA_GOVERNMENT",
        "PROVIDER_SA_SAUDI_POST",
        "PROVIDER_PEAKLIST",
        "PROVIDER_LOCAL_BUSINESS_CENTER",
        "PROVIDER_LOCAL_FEED_XML",
        "PROVIDER_WEB",
        "PROVIDER_RAILS_TO_TRAILS",
        "PROVIDER_INDIACOM",
        "PROVIDER_INFOMEDIA",
        "PROVIDER_PICASA",
        "PROVIDER_AT_GOVERNMENT",
        "PROVIDER_AT_BUNDESAMT_FUR_EICH_UND_VERMESSUNGSWESEN",
        "PROVIDER_AT_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_AT_AUSTRIA_POST",
        "PROVIDER_NO_GOVERNMENT",
        "PROVIDER_NO_NORSK_EIENDOMSINFORMASJON",
        "PROVIDER_NO_POSTEN_NORGE_AS",
        "PROVIDER_CH_GOVERNMENT",
        "PROVIDER_CH_SWISS_POST",
        "PROVIDER_CH_SWISSTOPO",
        "PROVIDER_CH_SWISS_NATIONAL_PARK",
        "PROVIDER_NAVIT",
        "PROVIDER_GEOSEARCH",
        "PROVIDER_DE_GOVERNMENT",
        "PROVIDER_BUNDESAMT_KARTOGRAPHIE_UND_GEODASIE",
        "PROVIDER_BUNDESNETZAGENTUR",
        "PROVIDER_SCHOBER_GROUP",
        "PROVIDER_MIREO",
        "PROVIDER_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WEBSTER_TEXAS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_AMHERST_MASSACHUSETTS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BLOOMINGTON_INDIANA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PASADENA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_CHULA_VISTA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_TEMPE_ARIZONA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_COLUMBUS_OHIO",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PORTAGE_MICHIGAN",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GEORGETOWN_KENTUCKY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GREENVILLE_SOUTH_CAROLINA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_NASHVILLE_TENNESSEE",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WASHINGTON_DISTRICT_OF_COLUMBIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BOULDER_COLORADO",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY_ENVIRONMENT_BAY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY_BIELSKO_BIALA",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_FRANKFURT",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_HAMBURG",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_KARLSRUHE",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY_SANTA_CRUZ",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_KLAGENFURT",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_LINZ",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_AZKOITIA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_BEASAIN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_GIRONA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_SAN_SEBASTIAN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_CATALUNYA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_HONDARRIBIA",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY_LAUNCESTON_TASMANIA",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY_REYKJAVIK",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY_AMELSTEVEEN",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY_ANTWERPEN",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_FREDERICTON_NEW_BRUNSWICK",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_KAMLOOPS_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_NANAIMO_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_BANFF_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_CALGARY_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_TORONTO_ONTARIO",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY_UMEA",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY_KHARKIV",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY_AQUA_CALIENTE_CAHUILLA_INDIANS",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_PONT_AUDEMER",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_BORDEAUX",
        "PROVIDER_SG_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY_RIO_DE_JANEIRO",
        "PROVIDER_MAPCUBE",
        "PROVIDER_3D_REALITYMAPS",
        "PROVIDER_DEUTSCHES_ZENTRUM_FUR_LUFT_UND_RAUMFAHRT",
        "PROVIDER_3D_CITIES_SOCIEDADE_ANONIMA",
        "PROVIDER_DISNEY",
        "PROVIDER_CYBERCITY",
        "PROVIDER_PRECISION_LIGHTWORKS_MODELWORKS",
        "PROVIDER_VIRTUAL_HUNGARY_LIMITED",
        "PROVIDER_VIRTUEL_CITY",
        "PROVIDER_SCREAMPOINT_INTERNATIONAL",
        "PROVIDER_AGENTSCHAP_VOOR_GEOGRAFISCHE_INFORMATIE_VLAANDEREN",
        "PROVIDER_FR_GOVERNMENT",
        "PROVIDER_FR_INSTITUT_GEOGRAPHIQUE_NATIONAL",
        "PROVIDER_FR_CADASTRE",
        "PROVIDER_DIADIEM",
        "PROVIDER_THE_WEATHER_CHANNEL",
        "PROVIDER_COWI",
        "PROVIDER_FALKPLAN_ANDES",
        "PROVIDER_NL_GOVERNMENT",
        "PROVIDER_NL_KADASTER",
        "PROVIDER_NL_BOARD_OF_TOURISM_AND_CONVENTIONS",
        "PROVIDER_DIGITAL_MAP_PRODUCTS",
        "PROVIDER_SILICE_DIGITAL",
        "PROVIDER_TYDAC",
        "PROVIDER_ALBRECHT_GOLF",
        "PROVIDER_HEALTH_CH",
        "PROVIDER_VISITDENMARK",
        "PROVIDER_FLYHERE",
        "PROVIDER_DIGITAL_DATA_SERVICES",
        "PROVIDER_MECOMO",
        "PROVIDER_ZA_GOVERNMENT",
        "PROVIDER_ZA_RURAL_DEVELOPMENT_LAND_REFORM",
        "PROVIDER_SENSIS",
        "PROVIDER_JJCONNECT",
        "PROVIDER_OPPLYSNINGEN",
        "PROVIDER_TELLUS",
        "PROVIDER_IQONIA",
        "PROVIDER_BE_GOVERNMENT",
        "PROVIDER_BE_NATIONAAL_GEOGRAFISCH_INSTITUUT",
        "PROVIDER_BE_BRUSSELS_MOBILITY",
        "PROVIDER_YELLOWMAP_AG",
        "PROVIDER_STIFTUNG_GESUNDHEIT",
        "PROVIDER_GIATA",
        "PROVIDER_SANPARKS",
        "PROVIDER_CENTRE_DINFORMATIQUE_POUR_LA_REGION_BRUXELLOISE",
        "PROVIDER_INFOPORTUGAL",
        "PROVIDER_NEGOCIOS_DE_TELECOMUNICACOES_E_SISTEMAS_DE_INFORMACAO",
        "PROVIDER_COLLINS_BARTHOLOMEW",
        "PROVIDER_PROTECT_PLANET_OCEAN",
        "PROVIDER_KARTTAKESKUS",
        "PROVIDER_FI_GOVERNMENT",
        "PROVIDER_FI_NATIONAL_ROAD_ADMINISTRATION",
        "PROVIDER_FI_NATIONAL_LAND_SURVEY",
        "PROVIDER_FI_STATISTICS_FINLAND",
        "PROVIDER_GB_GOVERNMENT",
        "PROVIDER_GB_ORDNANCE_SURVEY",
        "PROVIDER_NATURAL_ENGLAND",
        "PROVIDER_WELSH_GOVERNMENT",
        "PROVIDER_GB_OFFICE_FOR_NATIONAL_STATISTICS",
        "PROVIDER_EPSILON",
        "PROVIDER_PARTNER_FRONT_END",
        "PROVIDER_CARTESIA",
        "PROVIDER_SE_GOVERNMENT",
        "PROVIDER_SE_TRAFIKVERKET",
        "PROVIDER_SE_NATURVARDSVERKET",
        "PROVIDER_IE_GOVERNMENT",
        "PROVIDER_IE_ORDNANCE_SURVEY_IRELAND",
        "PROVIDER_LU_GOVERNMENT",
        "PROVIDER_LU_P_AND_T_LUXEMBOURG",
        "PROVIDER_LU_ADMINISTRATION_DU_CADASTRE_ET_DE_LA_TOPOGRAPHIE",
        "PROVIDER_LU_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_MAPFLOW",
        "PROVIDER_TKARTOR",
        "PROVIDER_JUMPSTART",
        "PROVIDER_EPTISA",
        "PROVIDER_MC_GOVERNMENT",
        "PROVIDER_MC_PRINCIPAUTE_DE_MONACO",
        "PROVIDER_MONOLIT",
        "PROVIDER_ENVIRONMENTAL_SYSTEMS_RESEARCH_INSTITUTE",
        "PROVIDER_MODIS",
        "PROVIDER_GEOX",
        "PROVIDER_GEODIRECTORY",
        "PROVIDER_GEOPLAN",
        "PROVIDER_INFODIREKT",
        "PROVIDER_GEOGLOBAL",
        "PROVIDER_DEUTSCHE_POST",
        "PROVIDER_TRACASA",
        "PROVIDER_CORREOS",
        "PROVIDER_ES_GOVERNMENT",
        "PROVIDER_ES_CENTRO_NACIONAL_DE_INFORMACION_GEOGRAFICA",
        "PROVIDER_EDIMAP",
        "PROVIDER_VERIZON",
        "PROVIDER_NATIONAL_GEOGRAPHIC_MAPS",
        "PROVIDER_PROMAPS",
        "PROVIDER_CONSODATA",
        "PROVIDER_DE_AGOSTINI",
        "PROVIDER_FEDERPARCHI",
        "PROVIDER_NAVIGO",
        "PROVIDER_ITALIAMAPPE",
        "PROVIDER_CZECOT",
        "PROVIDER_NATURAL_EARTH",
        "PROVIDER_REGIO",
        "PROVIDER_SHIPWRECK_CENTRAL",
        "PROVIDER_RUTGERS_STATE_UNIVERSITY",
        "PROVIDER_TWINICE",
        "PROVIDER_NORTHERN_IRELAND_TOURIST_BOARD",
        "PROVIDER_INFOGROUP",
        "PROVIDER_TNET",
        "PROVIDER_CTT_CORREIOS_DE_PORTUGAL",
        "PROVIDER_EUROPARC",
        "PROVIDER_IUPPITER",
        "PROVIDER_MICHAEL_BAUER_INTERNATIONAL",
        "PROVIDER_LEPTON",
        "PROVIDER_MAPPOINT",
        "PROVIDER_GEODATA",
        "PROVIDER_RU_GOVERNMENT",
        "PROVIDER_RU_FNS_KLADR",
        "PROVIDER_BR_GOVERNMENT",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DO_MEIO_AMBIENTE_E_DOS_RECURSOS_NATURAIS_RENOVAVEIS",
        "PROVIDER_BR_MINISTERIO_DO_MEIO_AMBIENTE",
        "PROVIDER_BR_AGENCIA_NACIONAL_DE_AGUAS",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DE_GEOGRAFIA_E_ESTATISTICA",
        "PROVIDER_BR_FUNDACAO_NACIONAL_DO_INDIO",
        "PROVIDER_BR_DEPARTAMENTO_NACIONAL_DE_INFRAESTRUTURA_DE_TRANSPORTES",
        "PROVIDER_AZAVEA",
        "PROVIDER_NORTHSTAR",
        "PROVIDER_COMMEDI",
        "PROVIDER_NEXUS_GEOGRAFICS",
        "PROVIDER_INFOERA",
        "PROVIDER_AD_GOVERNMENT",
        "PROVIDER_AD_AREA_DE_CARTOGRAFIA",
        "PROVIDER_MAXXIMA",
        "PROVIDER_SI_GOVERNMENT",
        "PROVIDER_SI_AGENCY_FOR_ENVIRONMENT",
        "PROVIDER_TRANSPORT_HI_TECH_CONSULTANTS",
        "PROVIDER_L1_TECHNOLOGIES",
        "PROVIDER_TELEMEDIA",
        "PROVIDER_CDCOM_PROGOROD",
        "PROVIDER_MIT_CITYGUIDE",
        "PROVIDER_SUNCART",
        "PROVIDER_MICROMAPPER",
        "PROVIDER_RICHI",
        "PROVIDER_FORUM44",
        "PROVIDER_SEAT",
        "PROVIDER_VALASSIS",
        "PROVIDER_NAVICOM",
        "PROVIDER_COLTRACK",
        "PROVIDER_PSMA_AUSTRALIA",
        "PROVIDER_PT_DUTA_ASTAKONA_GIRINDA",
        "PROVIDER_CA_GOVERNMENT",
        "PROVIDER_STATISTICS_CANADA",
        "PROVIDER_TOCTOC",
        "PROVIDER_RMSI",
        "PROVIDER_TRUE_TECHNOLOGY",
        "PROVIDER_INCREMENT_P_CORPORATION",
        "PROVIDER_GOJAVAS",
        "PROVIDER_GEOINFORMATION_GROUP",
        "PROVIDER_CYBERSOFT",
        "PROVIDER_TSENTR_EFFEKTIVNYKH_TEKHNOLOGIY",
        "PROVIDER_EE_GOVERNMENT",
        "PROVIDER_EE_MAA_AMET",
        "PROVIDER_GASBUDDY",
        "PROVIDER_DK_GOVERNMENT",
        "PROVIDER_DK_GEODATASTYRELSEN",
        "PROVIDER_MURCIA_REGION_GOVERNMENT",
        "PROVIDER_CORREIOS",
        "PROVIDER_WEST_WORLD_MEDIA",
        "PROVIDER_INTERNATIONAL_MAPPING_ASSOCIATION",
        "PROVIDER_MEDICARE",
        "PROVIDER_POLARIS",
        "PROVIDER_TW_GOVERNMENT",
        "PROVIDER_TW_MINISTRY_OF_THE_INTERIOR_SURVEYING_AND_MAPPING_CENTER",
        "PROVIDER_NORDECA",
        "PROVIDER_AFRIMAPPING",
        "PROVIDER_OVERDRIVE",
        "PROVIDER_PROVIDER_NETWORK_DIRECTORIES",
        "PROVIDER_BR_MINISTERIO_DA_SAUDE",
        "PROVIDER_DIGITAL_EGYPT",
        "PROVIDER_INRIX",
        "PROVIDER_ARPINDO",
        "PROVIDER_IT_GOVERNMENT",
        "PROVIDER_ISTITUTO_GEOGRAFICO_MILITARE",
        "PROVIDER_EAST_END_GROUP",
        "PROVIDER_INGEOLAN",
        "PROVIDER_SEMACONNECT",
        "PROVIDER_BLINK",
        "PROVIDER_EVGO",
        "PROVIDER_CHARGEPOINT",
        "PROVIDER_TPL_TRAKKER",
        "PROVIDER_OI",
        "PROVIDER_MAPARADAR",
        "PROVIDER_SINGAPORE_POST",
        "PROVIDER_CHARGEMASTER",
        "PROVIDER_TESLA",
        "PROVIDER_VISICOM",
        "PROVIDER_GEOLYSIS",
        "PROVIDER_ZEPHEIRA",
        "PROVIDER_HUBJECT",
        "PROVIDER_PODPOINT",
        "PROVIDER_CHARGEFOX",
        "PROVIDER_KR_GOVERNMENT",
        "PROVIDER_KR_MOLIT",
        "PROVIDER_KR_MINISTRY_OF_THE_INTERIOR_AND_SAFETY",
        "PROVIDER_CRITCHLOW",
        "PROVIDER_EIFRIG",
        "PROVIDER_GIREVE",
        "PROVIDER_CN_NAVINFO",
        "PROVIDER_JAPAN_CHARGE_NETWORK",
        "PROVIDER_NOBIL",
        "PROVIDER_INDIA_BANKS",
        "PROVIDER_INDONESIA_ELECTION_KPU",
        "PROVIDER_CAREERS360",
        "PROVIDER_SOURCE_LONDON",
        "PROVIDER_EVBOX",
        "PROVIDER_JP_GOVERNMENT",
        "PROVIDER_JP_MINISTRY_OF_THE_ENVIRONMENT",
        "PROVIDER_YUMYUM",
        "PROVIDER_HWW_AUSTRALIA",
        "PROVIDER_CINERGY",
        "PROVIDER_MTIME",
        "PROVIDER_KULTUNAUT",
        "PROVIDER_BLITZ",
        "PROVIDER_PIA",
        "PROVIDER_INTERPARK",
        "PROVIDER_CINEMA_ONLINE",
        "PROVIDER_BELBIOS",
        "PROVIDER_MOVIESEER",
        "PROVIDER_SODAMEDYA",
        "PROVIDER_ATMOVIES",
        "PROVIDER_HOTELBEDS",
        "PROVIDER_VERICRED",
        "PROVIDER_CIRRANTIC",
        "PROVIDER_GOGO_LABS",
        "PROVIDER_ELECTRIFY_AMERICA",
        "PROVIDER_CMS_MPPUF",
        "PROVIDER_DIGIROAD",
        "PROVIDER_KONTEX_GEOMATICS",
        "PROVIDER_NZ_GOVERNMENT",
        "PROVIDER_NZ_LINZ",
        "PROVIDER_NZ_DOC",
        "PROVIDER_FASTNED",
        "PROVIDER_DESTINY_CS",
        "PROVIDER_IONITY",
        "PROVIDER_EV_CONNECT",
        "PROVIDER_PANPAGES",
        "PROVIDER_ETECNIC",
        "PROVIDER_VOLTA",
        "PROVIDER_NISSAN_MEXICO",
        "PROVIDER_BMW_GROUP_LATIN_AMERICA",
        "PROVIDER_FEDERAL_ELECTRICITY_COMMISSION_MEXICO",
        "PROVIDER_VOLVO_CARS_BRASIL",
        "PROVIDER_CHARGE_AND_PARKING",
        "PROVIDER_DEDUCE_TECHNOLOGIES",
        "PROVIDER_SK_TELECOM",
        "PROVIDER_ECO_MOVEMENT",
        "PROVIDER_GOOGLE_GMS",
        "PROVIDER_EASYWAY",
        "PROVIDER_PHYSICIAN_COMPARE",
        "PROVIDER_HOSPITAL_COMPARE",
        "PROVIDER_ENDOLLA_BARCELONA",
        "PROVIDER_BE_CHARGE",
        "PROVIDER_ONE_NETWORK",
        "PROVIDER_CARENAV_DUPLEX",
        "PROVIDER_CARENAV_POI",
        "PROVIDER_IN_GOVERNMENT",
        "PROVIDER_SURVEY_OF_INDIA",
        "PROVIDER_E_ON",
        "PROVIDER_ELECTRIFY_CANADA",
        "PROVIDER_GRIDCARS",
        "PROVIDER_DRIVECO",
        "PROVIDER_GREEN_ACTION_STUDIOS",
        "PROVIDER_GREEN_ACTION_STUDIO",
        "PROVIDER_EVINY",
        "PROVIDER_MASTERCARD",
        "PROVIDER_VATTENFALL",
        "PROVIDER_VIETGIS",
        "PROVIDER_UNITE",
        "PROVIDER_NEOGY",
        "PROVIDER_AMPUP",
        "PROVIDER_LOOP",
        "PROVIDER_ZEST",
        "PROVIDER_EZVOLT",
        "PROVIDER_JOLT",
        "PROVIDER_CHARGESMITH",
        "PROVIDER_PLUGO",
        "PROVIDER_ELECTRIC_ERA",
    ]
    sourceDataset: str

@typing.type_check_only
class GeostoreOpeningHoursProto(typing_extensions.TypedDict, total=False):
    exception: _list[GeostoreExceptionalHoursProto]
    regularHours: GeostoreBusinessHoursProto

@typing.type_check_only
class GeostoreOperationsProto(typing_extensions.TypedDict, total=False):
    temporaryClosure: _list[GeostoreTemporaryClosureProto]

@typing.type_check_only
class GeostoreOverrideBorderStatusProto(typing_extensions.TypedDict, total=False):
    countryCode: str
    status: typing_extensions.Literal[
        "STATUS_NORMAL",
        "STATUS_DISPUTED",
        "STATUS_UNSURVEYED",
        "STATUS_INTERNATIONAL_WATER",
        "STATUS_NEVER_DISPLAY",
        "STATUS_TREATY",
        "STATUS_PROVISIONAL",
        "STATUS_NO_LABEL",
    ]

@typing.type_check_only
class GeostorePaintedElementLogicalColorProto(typing_extensions.TypedDict, total=False):
    color: typing_extensions.Literal[
        "UNKNOWN_LOGICAL_COLOR",
        "WHITE",
        "YELLOW",
        "RED",
        "GREEN",
        "BLUE",
        "BLACK",
        "GREY",
        "ORANGE",
    ]

@typing.type_check_only
class GeostoreParkingAllowanceProto(typing_extensions.TypedDict, total=False):
    allowanceType: typing_extensions.Literal[
        "STANDARD", "VALET", "PERMIT", "PICKUP_GOODS", "PICKUP_PASSENGERS"
    ]
    isDiscount: bool
    minPurchaseForValidation: _list[FreebaseTopic]
    permitType: _list[GeostoreLanguageTaggedTextProto]
    serviceType: _list[
        typing_extensions.Literal[
            "SERVICE_ALL",
            "SERVICE_GENERAL_DRIVER",
            "SERVICE_RIDESHARE",
            "SERVICE_TAXI",
            "SERVICE_COMMERCIAL",
        ]
    ]
    timeBasedRate: _list[GeostoreTimeBasedRateProto]
    vehicleType: typing_extensions.Literal["ANY", "CAR", "MOTORCYCLE", "TRUCK"]

@typing.type_check_only
class GeostoreParkingProto(typing_extensions.TypedDict, total=False):
    allowance: _list[GeostoreParkingAllowanceProto]
    openingHours: GeostoreOpeningHoursProto
    parkingAvailable: bool
    parkingProviderFeature: _list[GeostoreFeatureIdProto]
    restriction: _list[GeostoreParkingRestrictionProto]

@typing.type_check_only
class GeostoreParkingRestrictionProto(typing_extensions.TypedDict, total=False):
    restrictedHours: GeostoreTimeScheduleProto
    restrictionType: typing_extensions.Literal[
        "RESTRICTION_UNKNOWN",
        "RESTRICTION_PARKING",
        "RESTRICTION_STANDING",
        "RESTRICTION_STOPPING",
        "RESTRICTION_PICKUP_GOODS",
        "RESTRICTION_PICKUP_PASSENGERS",
    ]
    serviceType: _list[
        typing_extensions.Literal[
            "SERVICE_ALL",
            "SERVICE_GENERAL_DRIVER",
            "SERVICE_RIDESHARE",
            "SERVICE_TAXI",
            "SERVICE_COMMERCIAL",
        ]
    ]
    vehicleType: _list[typing_extensions.Literal["ANY", "CAR", "MOTORCYCLE", "TRUCK"]]

@typing.type_check_only
class GeostorePeakProto(typing_extensions.TypedDict, total=False):
    prominenceMeters: float

@typing.type_check_only
class GeostorePedestrianCrossingProto(typing_extensions.TypedDict, total=False):
    angleDegrees: float
    crossAnywhere: bool
    crossingType: typing_extensions.Literal[
        "UNKNOWN", "CROSSABLE", "UNMARKED_CROSSING", "MARKED_CROSSING", "UNCROSSABLE"
    ]
    offset: float
    restriction: _list[GeostoreRestrictionProto]
    width: float

@typing.type_check_only
class GeostorePhysicalLineProto(typing_extensions.TypedDict, total=False):
    dashLengthMeters: float
    gapColor: GeostorePaintedElementLogicalColorProto
    gapLengthMeters: float
    material: _list[
        typing_extensions.Literal[
            "UNKNOWN_STRIPE_MATERIAL", "PAINT_STRIPE", "ROUND_DOT", "SQUARE_DOT"
        ]
    ]
    paintColor: GeostorePaintedElementLogicalColorProto
    pattern: typing_extensions.Literal[
        "UNKNOWN_DASH_PATTERN", "SOLID", "DASHED", "DOTTED", "DOTTED_DASHED"
    ]
    physicalLineToken: str

@typing.type_check_only
class GeostorePointCurvatureProto(typing_extensions.TypedDict, total=False):
    curvatureStatus: typing_extensions.Literal[
        "CURVATURE_UNSPECIFIED", "CURVATURE_UNKNOWN"
    ]
    radiansPerMeter: float
    startPointFraction: float

@typing.type_check_only
class GeostorePointProto(typing_extensions.TypedDict, total=False):
    latE7: int
    lngE7: int
    metadata: GeostoreFieldMetadataProto
    temporaryData: Proto2BridgeMessageSet

@typing.type_check_only
class GeostorePointWithHeightProto(typing_extensions.TypedDict, total=False):
    altitudeMeters: float
    point: GeostorePointProto

@typing.type_check_only
class GeostorePoliticalProto(typing_extensions.TypedDict, total=False):
    capital: GeostoreFeatureIdProto
    claim: _list[GeostoreFeatureIdProto]
    grossDomesticProductUsdMillions: float
    literacyPercent: float
    population: str

@typing.type_check_only
class GeostorePolyLineProto(typing_extensions.TypedDict, total=False):
    metadata: GeostoreFieldMetadataProto
    temporaryData: Proto2BridgeMessageSet
    vertex: _list[GeostorePointProto]

@typing.type_check_only
class GeostorePolygonProto(typing_extensions.TypedDict, total=False):
    baseMeters: float
    cellId: str
    encoded: str
    heightMeters: float
    loop: _list[GeostorePolyLineProto]
    metadata: GeostoreFieldMetadataProto
    temporaryData: Proto2BridgeMessageSet
    unsuitableForDisplay: bool

@typing.type_check_only
class GeostorePoseProto(typing_extensions.TypedDict, total=False):
    altitude: float
    index: int
    lat: float
    lng: float
    pitch: float
    roll: float
    yaw: float

@typing.type_check_only
class GeostorePriceInfoFoodNutritionFacts(typing_extensions.TypedDict, total=False):
    calories: GeostorePriceInfoFoodNutritionFactsCaloriesFact
    cholesterol: GeostorePriceInfoFoodNutritionFactsNutritionFact
    protein: GeostorePriceInfoFoodNutritionFactsNutritionFact
    sodium: GeostorePriceInfoFoodNutritionFactsNutritionFact
    totalCarbohydrate: GeostorePriceInfoFoodNutritionFactsNutritionFact
    totalFat: GeostorePriceInfoFoodNutritionFactsNutritionFact

@typing.type_check_only
class GeostorePriceInfoFoodNutritionFactsCaloriesFact(
    typing_extensions.TypedDict, total=False
):
    lowerAmount: int
    unit: typing_extensions.Literal["UNDEFINED_ENERGY_UNIT", "CALORIE", "JOULE"]
    upperAmount: int

@typing.type_check_only
class GeostorePriceInfoFoodNutritionFactsNutritionFact(
    typing_extensions.TypedDict, total=False
):
    lowerAmount: float
    unit: typing_extensions.Literal["UNDEFINED_MASS_UNIT", "GRAM", "MILLIGRAM"]
    upperAmount: float

@typing.type_check_only
class GeostorePriceInfoProto(typing_extensions.TypedDict, total=False):
    priceList: _list[GeostorePriceListProto]
    priceListUrl: _list[GeostoreUrlListProto]
    status: GeostorePriceInfoStatus

@typing.type_check_only
class GeostorePriceInfoStatus(typing_extensions.TypedDict, total=False):
    isVerified: bool

@typing.type_check_only
class GeostorePriceListNameInfoProto(typing_extensions.TypedDict, total=False):
    description: str
    id: str
    language: str
    name: str

@typing.type_check_only
class GeostorePriceListProto(typing_extensions.TypedDict, total=False):
    aggregatorId: str
    availableTime: GeostoreTimeScheduleProto
    cuisines: _list[
        typing_extensions.Literal[
            "CUISINE_UNDEFINED",
            "FAST_FOOD",
            "AMERICAN",
            "JAPANESE",
            "BREAK_FAST",
            "PIZZA",
            "HAMBURGER",
            "ITALIAN",
            "SEAFOOD",
            "FAMILY",
            "MEXICAN",
            "CHINESE",
            "VEGETARIAN",
            "SUSHI",
            "CHICKEN",
            "INDIAN",
            "ASIAN",
            "MEDITERRANEAN",
            "FRENCH",
            "BRUNCH",
            "KOREAN",
            "THAI",
            "SPANISH",
            "VIETNAMESE",
            "LATIN_AMERICAN",
            "INDONESIAN",
            "GREEK",
            "GERMAN",
            "TURKISH",
            "BRAZILIAN",
            "PAKISTANI",
            "OTHER_CUISINE",
        ]
    ]
    nameInfo: _list[GeostorePriceListNameInfoProto]
    section: _list[GeostorePriceListSectionProto]
    sourceUrl: GeostoreUrlListProto

@typing.type_check_only
class GeostorePriceListSectionProto(typing_extensions.TypedDict, total=False):
    callToAction: GeostoreCallToActionProto
    foodItem: _list[GeostoreFoodMenuItemProto]
    item: _list[GeostoreComposableItemProto]
    itemType: _list[
        typing_extensions.Literal[
            "TYPE_ANY",
            "TYPE_FOOD",
            "TYPE_SERVICE",
            "TYPE_PRODUCT",
            "TYPE_JOB",
            "TYPE_3P_JOB",
        ]
    ]
    language: str
    media: _list[GeostoreMediaItemProto]
    nameInfo: _list[GeostorePriceListNameInfoProto]

@typing.type_check_only
class GeostorePriceRangeProto(typing_extensions.TypedDict, total=False):
    currency: str
    lowerPrice: float
    units: typing_extensions.Literal[
        "ANY_UNITS",
        "PER_USE",
        "PER_PHONE_CALL",
        "PER_RIDE",
        "PER_TIME_UNIT",
        "PER_SECOND",
        "PER_MINUTE",
        "PER_HOUR",
        "PER_DAY",
        "PER_NIGHT",
        "PER_WEEK",
        "PER_MONTH",
        "PER_YEAR",
        "PER_VOLUME_UNIT",
        "PER_LITER",
        "PER_GLASS",
        "PER_BOTTLE",
        "PER_POT",
        "PER_LENGTH_UNIT",
        "PER_CENTIMETER",
        "PER_METER",
        "PER_KILOMETER",
        "PER_MASS_UNIT",
        "PER_GRAM",
        "PER_KILOGRAM",
        "PER_OUNCE",
        "PER_POUND",
    ]
    upperPrice: float

@typing.type_check_only
class GeostorePropertyValueStatusProto(typing_extensions.TypedDict, total=False):
    propertyId: GeostoreFeaturePropertyIdProto
    valueStatus: typing_extensions.Literal[
        "PROPERTY_VALUE_STATUS_UNSPECIFIED", "HAS_NO_VALUE", "HAS_UNKNOWN_VALUE"
    ]

@typing.type_check_only
class GeostoreProvenanceProto(typing_extensions.TypedDict, total=False):
    dataset: str
    provider: typing_extensions.Literal[
        "PROVIDER_ANY",
        "PROVIDER_UNKNOWN",
        "PROVIDER_NAVTEQ",
        "PROVIDER_TELE_ATLAS",
        "PROVIDER_TELE_ATLAS_MULTINET",
        "PROVIDER_TELE_ATLAS_CODEPOINT",
        "PROVIDER_TELE_ATLAS_GEOPOST",
        "PROVIDER_TELE_ATLAS_DATAGEO",
        "PROVIDER_TELE_ATLAS_ADDRESS_POINTS",
        "PROVIDER_TELCONTAR",
        "PROVIDER_EUROPA",
        "PROVIDER_ROYAL_MAIL",
        "PROVIDER_GOOGLE",
        "PROVIDER_GOOGLE_HAND_EDIT",
        "PROVIDER_GOOGLE_BORDERS",
        "PROVIDER_GOOGLE_SUBRANGE",
        "PROVIDER_GOOGLE_GT_FUSION",
        "PROVIDER_GOOGLE_ZAGAT_CMS",
        "PROVIDER_GOOGLE_PLACE_NAVBOOST",
        "PROVIDER_GOOGLE_FOOTPRINT",
        "PROVIDER_GOOGLE_PRODUCT_TERMS",
        "PROVIDER_GOOGLE_POINTCARDS",
        "PROVIDER_GOOGLE_BUSINESS_CHAINS",
        "PROVIDER_GOOGLE_LOCAL_SUMMARIZATION",
        "PROVIDER_GOOGLE_PRONUNCIATIONS",
        "PROVIDER_GOOGLE_DUMPLING",
        "PROVIDER_GOOGLE_DISTILLERY",
        "PROVIDER_GOOGLE_LOCAL_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_RELATION_MINER",
        "PROVIDER_GOOGLE_MAPSPAM",
        "PROVIDER_GOOGLE_ROSE",
        "PROVIDER_GOOGLE_LOCAL_PLACE_RATINGS",
        "PROVIDER_GOOGLE_WIPEOUT",
        "PROVIDER_GOOGLE_KNOWLEDGE_GRAPH",
        "PROVIDER_GOOGLE_BEEGEES",
        "PROVIDER_GOOGLE_REVIEW_SUMMARIZATION",
        "PROVIDER_GOOGLE_OFFLINE_NON_CORE_ATTRIBUTE_SUMMARIZATION",
        "PROVIDER_GOOGLE_GEO_WORLDMAPS",
        "PROVIDER_GOOGLE_GEO_MODERATION",
        "PROVIDER_GOOGLE_OYSTER_AUTO_EDITS",
        "PROVIDER_GOOGLE_LOCAL_ALCHEMY",
        "PROVIDER_GOOGLE_KEROUAC",
        "PROVIDER_GOOGLE_MOBRANK",
        "PROVIDER_GOOGLE_RAPTURE",
        "PROVIDER_GOOGLE_CULTURAL_INSTITUTE",
        "PROVIDER_GOOGLE_GEOCODES_FROM_LOCAL_FEEDS",
        "PROVIDER_GOOGLE_ATTRIBUTES_FROM_CRAWLED_CHAINS",
        "PROVIDER_GOOGLE_TACTILE_MAPS",
        "PROVIDER_GOOGLE_MAPS_FOR_MOBILE",
        "PROVIDER_GOOGLE_GEO_REALTIME",
        "PROVIDER_GOOGLE_PROMINENT_PLACES",
        "PROVIDER_GOOGLE_PLACE_ACTIONS",
        "PROVIDER_GOOGLE_GT_AUTO_EDITS",
        "PROVIDER_GOOGLE_WAZE",
        "PROVIDER_GOOGLE_ONTHEGO",
        "PROVIDER_GOOGLE_GT_IMPORT",
        "PROVIDER_GOOGLE_STRUCTURED_DATA",
        "PROVIDER_GOOGLE_HELICOPTER",
        "PROVIDER_GOOGLE_ROLLBACK",
        "PROVIDER_GOOGLE_RIGHTS_REPAIR",
        "PROVIDER_GOOGLE_PERFUME",
        "PROVIDER_GOOGLE_MAPS_TRANSLATION",
        "PROVIDER_GOOGLE_CALL_ME_MAYBE",
        "PROVIDER_GOOGLE_LOCAL_UNIVERSAL",
        "PROVIDER_GOOGLE_CROUPIER",
        "PROVIDER_GOOGLE_SKYSMART",
        "PROVIDER_GOOGLE_RIDDLER",
        "PROVIDER_GOOGLE_ROADCLOSURES",
        "PROVIDER_GOOGLE_SPORE",
        "PROVIDER_GOOGLE_LOCALIZATION",
        "PROVIDER_GOOGLE_CATTERMS",
        "PROVIDER_GOOGLE_GT_FIELD_OPS",
        "PROVIDER_GOOGLE_MATCHMAKER",
        "PROVIDER_GOOGLE_ARBITRATION",
        "PROVIDER_GOOGLE_BIZBUILDER_OPS",
        "PROVIDER_GOOGLE_LOCAL_INVENTORY_ADS",
        "PROVIDER_GOOGLE_GT_DRAFTY",
        "PROVIDER_GOOGLE_HOTELADS_OPS",
        "PROVIDER_GOOGLE_MARKERS",
        "PROVIDER_GOOGLE_STATE_MACHINE",
        "PROVIDER_GOOGLE_ATTRIBUTES_INFERENCE",
        "PROVIDER_GOOGLE_BIKESHARE",
        "PROVIDER_GOOGLE_GHOSTWRITER",
        "PROVIDER_GOOGLE_EDIT_PLATFORM",
        "PROVIDER_GOOGLE_BLUE_GINGER",
        "PROVIDER_GOOGLE_GEO_TIGER",
        "PROVIDER_GOOGLE_HYADES",
        "PROVIDER_GOOGLE_WEBQUARRY",
        "PROVIDER_GOOGLE_GEO_MADDEN",
        "PROVIDER_GOOGLE_ANDROID_PAY",
        "PROVIDER_GOOGLE_OPENING_HOURS_TEAM",
        "PROVIDER_GOOGLE_LOCAL_DISCOVERY",
        "PROVIDER_GOOGLE_LOCAL_HEALTH",
        "PROVIDER_GOOGLE_UGC_MAPS",
        "PROVIDER_GOOGLE_FIBER",
        "PROVIDER_GOOGLE_REVGEO",
        "PROVIDER_GOOGLE_HOTELADS_PARTNER_FRONT_END",
        "PROVIDER_GOOGLE_GEO_UGC_TASKS",
        "PROVIDER_GOOGLE_GEOCODING",
        "PROVIDER_GOOGLE_SPYGLASS",
        "PROVIDER_GOOGLE_PLUS_CODES_AS_ADDRESSES",
        "PROVIDER_GOOGLE_GEO_CHANGES",
        "PROVIDER_GOOGLE_HUME",
        "PROVIDER_GOOGLE_MEGAMIND",
        "PROVIDER_GOOGLE_GT_ROADSYNTH",
        "PROVIDER_GOOGLE_FIREBOLT",
        "PROVIDER_GOOGLE_LOCAL_PLACE_OFFERINGS",
        "PROVIDER_GOOGLE_UGC_SERVICES",
        "PROVIDER_GOOGLE_GEOALIGN",
        "PROVIDER_GOOGLE_GT_COMPOUNDS",
        "PROVIDER_GOOGLE_FOOD_ORDERING",
        "PROVIDER_GOOGLE_HOTEL_KNOWLEDGE_OPS",
        "PROVIDER_GOOGLE_URAW",
        "PROVIDER_GOOGLE_FLYEYE",
        "PROVIDER_GOOGLE_YOUKE",
        "PROVIDER_GOOGLE_GT_ZEPHYR",
        "PROVIDER_GOOGLE_USER_SAFETY",
        "PROVIDER_GOOGLE_ADDRESS_MAKER",
        "PROVIDER_GOOGLE_UGC_PHOTOS",
        "PROVIDER_GOOGLE_GT_WINDCHIME",
        "PROVIDER_GOOGLE_SNAG_FIXER",
        "PROVIDER_GOOGLE_GEO_DEALS",
        "PROVIDER_GOOGLE_LOCAL_PLACE_TOPICS",
        "PROVIDER_GOOGLE_PROPERTY_INSIGHTS",
        "PROVIDER_GOOGLE_GEO_CONSUMER_MERCHANT_EXPERIMENTS",
        "PROVIDER_GOOGLE_GEO_PORTKEY",
        "PROVIDER_GOOGLE_ROAD_MAPPER",
        "PROVIDER_GOOGLE_LOCATION_PLATFORM",
        "PROVIDER_GOOGLE_POSTTRIP",
        "PROVIDER_GOOGLE_TRAVEL_DESTINATION",
        "PROVIDER_GOOGLE_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_BIZBUILDER_CLEANUP",
        "PROVIDER_GOOGLE_USER",
        "PROVIDER_GOOGLE_STATION",
        "PROVIDER_GOOGLE_GEO_FOOD",
        "PROVIDER_GOOGLE_GEO_AR",
        "PROVIDER_GOOGLE_GEO_TEMPORAL",
        "PROVIDER_GOOGLE_SERVICES_MARKETPLACE",
        "PROVIDER_GOOGLE_IMT_CLEANUP",
        "PROVIDER_GOOGLE_GEO_FOOD_MENU",
        "PROVIDER_GOOGLE_CARENAV",
        "PROVIDER_GOOGLE_DRIVING_FEEDS",
        "PROVIDER_GOOGLE_DRIVING_UGC",
        "PROVIDER_GOOGLE_POLAR",
        "PROVIDER_GOOGLE_TRIWILD",
        "PROVIDER_GOOGLE_CROWD_COMPUTE_OPS",
        "PROVIDER_GOOGLE_SA_FROM_WEB",
        "PROVIDER_GOOGLE_POI_ALIGNMENT",
        "PROVIDER_GOOGLE_SA_FROM_HULK",
        "PROVIDER_GOOGLE_SERVICES_INTERACTIONS",
        "PROVIDER_GOOGLE_ROADS_UGC_EDITOR",
        "PROVIDER_GOOGLE_SA_FROM_NG_INFERENCE",
        "PROVIDER_GOOGLE_GEO_DRIVING_VIZ",
        "PROVIDER_GOOGLE_GEO_TASKING",
        "PROVIDER_GOOGLE_CROWDTASK_DATACOMPUTE",
        "PROVIDER_GOOGLE_CROWDTASK_TASKADS",
        "PROVIDER_GOOGLE_CROWDTASK_TASKMATE",
        "PROVIDER_GOOGLE_CROWDTASK_FURBALL",
        "PROVIDER_GOOGLE_CROWDTASK_ADAP",
        "PROVIDER_GOOGLE_GPAY",
        "PROVIDER_GOOGLE_GEO_UGC_TRUSTED_USERS",
        "PROVIDER_GOOGLE_THIRD_PARTY_DATA_PRODUCTION",
        "PROVIDER_GOOGLE_GEOTRACKER",
        "PROVIDER_GOOGLE_LOCAL_LANDMARK_INFERENCE",
        "PROVIDER_GOOGLE_GEO_CLOSED_LOOP",
        "PROVIDER_GOOGLE_SA_FROM_MERCHANT_POSTS",
        "PROVIDER_GOOGLE_CORE_DATA_RIGHTS",
        "PROVIDER_GOOGLE_SA_FROM_USER_REVIEWS",
        "PROVIDER_GOOGLE_GEO_CONTENT_FIXER",
        "PROVIDER_GOOGLE_POLYGON_REFINEMENT",
        "PROVIDER_GOOGLE_HANASU",
        "PROVIDER_GOOGLE_FULLRIGHTS_GEO_DATA_UPLOAD",
        "PROVIDER_GOOGLE_FULLRIGHTS_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_ATTRIBUTION_3P_OUTREACH_UPLOAD",
        "PROVIDER_GOOGLE_SA_FROM_FOOD_MENUS",
        "PROVIDER_GOOGLE_GT_CONSISTENCY_EDITS",
        "PROVIDER_GOOGLE_SA_QUALITY",
        "PROVIDER_GOOGLE_GDCE_CLEANUP",
        "PROVIDER_GOOGLE_UGC_QUALITY_CHAINS",
        "PROVIDER_GOOGLE_ATTRIBUTES_DISCOVERY",
        "PROVIDER_GOOGLE_GEO_LDE",
        "PROVIDER_GOOGLE_GEO_SIGNAL_TRACKING",
        "PROVIDER_GOOGLE_UGC_AGGREGATION",
        "PROVIDER_GOOGLE_3D_BASEMAP",
        "PROVIDER_GOOGLE_MAPFACTS_PRIVACY",
        "PROVIDER_GOOGLE_GT_ALF",
        "PROVIDER_GOOGLE_GT_OPERATOR_PROVENANCE",
        "PROVIDER_GOOGLE_LOCAL_SERVICES_ADS",
        "PROVIDER_GOOGLE_GT_LANE_AUTOMATION",
        "PROVIDER_GOOGLE_GEO_NG_LOCAL",
        "PROVIDER_GOOGLE_MAPFACTS_CLEANUP",
        "PROVIDER_GOOGLE_THIRD_PARTY_UGC",
        "PROVIDER_GOOGLE_GEO_ISSUE_ADMIN",
        "PROVIDER_GOOGLE_LOCALSEARCH",
        "PROVIDER_GOOGLE_TRANSIT",
        "PROVIDER_GOOGLE_GEOWIKI",
        "PROVIDER_GOOGLE_CHINA_LOCAL_TEAM",
        "PROVIDER_GOOGLE_SYNTHESIZED",
        "PROVIDER_GOOGLE_INTERNAL_TEST",
        "PROVIDER_GOOGLE_DISPUTED_AREAS",
        "PROVIDER_GOOGLE_3DWAREHOUSE",
        "PROVIDER_GOOGLE_GROUNDS_BUILDER",
        "PROVIDER_GOOGLE_SESAME",
        "PROVIDER_GOOGLE_GT",
        "PROVIDER_GOOGLE_GT_BASEMAP_UPLOAD",
        "PROVIDER_GOOGLE_ADSDB",
        "PROVIDER_GOOGLE_MACHINE_TRANSLITERATION",
        "PROVIDER_GOOGLE_TRAVELSEARCH",
        "PROVIDER_GOOGLE_PANORAMIO",
        "PROVIDER_GOOGLE_YOUTUBE",
        "PROVIDER_GOOGLE_OLD",
        "PROVIDER_GOOGLE_STREETVIEW",
        "PROVIDER_GOOGLE_STREETVIEW_BIZVIEW",
        "PROVIDER_GOOGLE_ZIPIT",
        "PROVIDER_GOOGLE_OYSTER_CONNECT_ROUTES",
        "PROVIDER_GOOGLE_GOLDEN",
        "PROVIDER_GOOGLE_INNERSPACE",
        "PROVIDER_GOOGLE_MAPSEARCH",
        "PROVIDER_GOOGLE_CATEGORIES_TEAM",
        "PROVIDER_GOOGLE_CROWDSENSUS",
        "PROVIDER_GOOGLE_LOCAL_ALGORITHMIC_IDENTITY",
        "PROVIDER_GOOGLE_FREEBASE",
        "PROVIDER_GOOGLE_HOTELADS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGES",
        "PROVIDER_GOOGLE_PLACES_API",
        "PROVIDER_GOOGLE_NAMEHEATMAP",
        "PROVIDER_GOOGLE_MAPMAKER",
        "PROVIDER_GOOGLE_MAPMAKER_MOBILE",
        "PROVIDER_GOOGLE_MAPMAKER_PANCAKE",
        "PROVIDER_GOOGLE_MAPMAKER_V2",
        "PROVIDER_GOOGLE_LOCAL_CLUSTERING_OPERATOR_OVERRIDE",
        "PROVIDER_GOOGLE_SERVED_ON_MAPMAKER",
        "PROVIDER_GOOGLE_GT_LOCAL",
        "PROVIDER_GOOGLE_GT_LOCAL_WITH_RIGHTS",
        "PROVIDER_GOOGLE_LOGS_RANKING_SIGNALS",
        "PROVIDER_GOOGLE_ENTITY_NAVBOOST",
        "PROVIDER_GOOGLE_RELATED_PLACES",
        "PROVIDER_GOOGLE_KNOWN_FOR_TERMS",
        "PROVIDER_GOOGLE_SYNTHETIC_AREAS",
        "PROVIDER_GOOGLE_AUTHORITY_PAGE_PHOTOS",
        "PROVIDER_GOOGLE_CROSS_STREETS",
        "PROVIDER_GOOGLE_CORRIDORS",
        "PROVIDER_GOOGLE_BICYCLE_RENTAL",
        "PROVIDER_GOOGLE_CONCRETE_URLS",
        "PROVIDER_GOOGLE_LEANBACK",
        "PROVIDER_GOOGLE_LOCKED_LISTINGS",
        "PROVIDER_GOOGLE_MONITORING",
        "PROVIDER_GOOGLE_SPROUT",
        "PROVIDER_GOOGLE_LOCAL_SEARCH_QUALITY",
        "PROVIDER_GOOGLE_GOBY",
        "PROVIDER_GOOGLE_PROBLEM_REPORT",
        "PROVIDER_GOOGLE_CANDID",
        "PROVIDER_GOOGLE_BIZBUILDER",
        "PROVIDER_AUTOMOTIVE_NAVIGATION_DATA",
        "PROVIDER_MAPDATA_SCIENCES",
        "PROVIDER_MAPONICS",
        "PROVIDER_SKI_RESORTS",
        "PROVIDER_ZENRIN",
        "PROVIDER_SANBORN",
        "PROVIDER_URBAN_MAPPING",
        "PROVIDER_US_GOVERNMENT",
        "PROVIDER_US_CENSUS",
        "PROVIDER_US_POSTAL_SERVICE",
        "PROVIDER_US_GEOLOGICAL_SURVEY",
        "PROVIDER_US_GNIS",
        "PROVIDER_US_LANDSAT",
        "PROVIDER_US_NATIONAL_GEOSPATIAL_INTELLIGENCE_AGENCY",
        "PROVIDER_US_NGA_GNS",
        "PROVIDER_US_SSIBL",
        "PROVIDER_US_BUREAU_OF_TRANSPORTATION_STATISTICS",
        "PROVIDER_US_NATIONAL_OCEANIC_AND_ATMOSPHERIC_ADMINISTRATION",
        "PROVIDER_US_POLAR_GEOSPATIAL_CENTER",
        "PROVIDER_US_DEPARTMENT_OF_AGRICULTURE",
        "PROVIDER_US_NPI_REGISTRY",
        "PROVIDER_US_BUREAU_OF_INDIAN_AFFAIRS",
        "PROVIDER_DMTI_SPATIAL",
        "PROVIDER_INTERNATIONAL_HYDROGRAPHIC_ORGANIZATION",
        "PROVIDER_MAPLINK",
        "PROVIDER_KINGWAY",
        "PROVIDER_GEOCENTRE",
        "PROVIDER_CN_NATIONAL_FOUNDAMENTAL_GIS",
        "PROVIDER_CN_MAPABC",
        "PROVIDER_SMITHSONIAN_INSTITUTE",
        "PROVIDER_TRACKS_FOR_AFRICA",
        "PROVIDER_PPWK",
        "PROVIDER_LEADDOG",
        "PROVIDER_CENTRE_DONNEES_ASTRONOMIQUES_STRASBOURG",
        "PROVIDER_GISRAEL",
        "PROVIDER_BASARSOFT",
        "PROVIDER_MAPINFO",
        "PROVIDER_MAPIT",
        "PROVIDER_GEOBASE",
        "PROVIDER_ORION",
        "PROVIDER_CENTRAL_EUROPEAN_DATA_AGENCY",
        "PROVIDER_ANASAT",
        "PROVIDER_MINED_POSTCODES",
        "PROVIDER_DMAPAS",
        "PROVIDER_COMMON_LOCALE_DATA_REPOSITORY",
        "PROVIDER_CH_SBB",
        "PROVIDER_SKENERGY",
        "PROVIDER_GBRMPA",
        "PROVIDER_KOREA_POST",
        "PROVIDER_CN_AUTONAVI",
        "PROVIDER_MINED_POI",
        "PROVIDER_ML_INFOMAP",
        "PROVIDER_SNOOPER",
        "PROVIDER_GEOSISTEMAS",
        "PROVIDER_AFRIGIS",
        "PROVIDER_TRANSNAVICOM",
        "PROVIDER_EASYCONNECT",
        "PROVIDER_LANTMATERIET",
        "PROVIDER_LOGICA",
        "PROVIDER_MAPKING",
        "PROVIDER_DIANPING",
        "PROVIDER_GEONAV",
        "PROVIDER_HEIBONSHA",
        "PROVIDER_DEUTSCHE_TELEKOM",
        "PROVIDER_LINGUISTIC_DATA_CONSORTIUM",
        "PROVIDER_ACXIOM",
        "PROVIDER_DUN_AND_BRADSTREET",
        "PROVIDER_FEDERAL_AVIATION_ADMINISTRATION",
        "PROVIDER_INFOUSA",
        "PROVIDER_INFOUSA_NIXIE",
        "PROVIDER_THOMSON_LOCAL",
        "PROVIDER_TELEFONICA_PUBLICIDAD_E_INFORMACION",
        "PROVIDER_WIKIPEDIA",
        "PROVIDER_INFOBEL",
        "PROVIDER_MX_GOVERNMENT",
        "PROVIDER_MX_NATIONAL_INSTITUTE_STATISTICS_GEOGRAPHY",
        "PROVIDER_MX_SERVICIO_POSTAL_MEXICANO",
        "PROVIDER_TELEGATE",
        "PROVIDER_TELELISTAS",
        "PROVIDER_MAPCITY",
        "PROVIDER_EXPLAINER_DC",
        "PROVIDER_DAIKEI",
        "PROVIDER_NL_CHAMBER_OF_COMMERCE",
        "PROVIDER_KOREA_INFO_SERVICE",
        "PROVIDER_WIKITRAVEL",
        "PROVIDER_FLICKR",
        "PROVIDER_DIANCO",
        "PROVIDER_VOLT_DELTA",
        "PROVIDER_SG_GOVERNMENT",
        "PROVIDER_SG_LAND_TRANSPORT_AUTHORITY",
        "PROVIDER_MAPBAR",
        "PROVIDER_LONGTU",
        "PROVIDER_SA_GOVERNMENT",
        "PROVIDER_SA_SAUDI_POST",
        "PROVIDER_PEAKLIST",
        "PROVIDER_LOCAL_BUSINESS_CENTER",
        "PROVIDER_LOCAL_FEED_XML",
        "PROVIDER_WEB",
        "PROVIDER_RAILS_TO_TRAILS",
        "PROVIDER_INDIACOM",
        "PROVIDER_INFOMEDIA",
        "PROVIDER_PICASA",
        "PROVIDER_AT_GOVERNMENT",
        "PROVIDER_AT_BUNDESAMT_FUR_EICH_UND_VERMESSUNGSWESEN",
        "PROVIDER_AT_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_AT_AUSTRIA_POST",
        "PROVIDER_NO_GOVERNMENT",
        "PROVIDER_NO_NORSK_EIENDOMSINFORMASJON",
        "PROVIDER_NO_POSTEN_NORGE_AS",
        "PROVIDER_CH_GOVERNMENT",
        "PROVIDER_CH_SWISS_POST",
        "PROVIDER_CH_SWISSTOPO",
        "PROVIDER_CH_SWISS_NATIONAL_PARK",
        "PROVIDER_NAVIT",
        "PROVIDER_GEOSEARCH",
        "PROVIDER_DE_GOVERNMENT",
        "PROVIDER_BUNDESAMT_KARTOGRAPHIE_UND_GEODASIE",
        "PROVIDER_BUNDESNETZAGENTUR",
        "PROVIDER_SCHOBER_GROUP",
        "PROVIDER_MIREO",
        "PROVIDER_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WEBSTER_TEXAS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_AMHERST_MASSACHUSETTS",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BLOOMINGTON_INDIANA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PASADENA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_CHULA_VISTA_CALIFORNIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_TEMPE_ARIZONA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_COLUMBUS_OHIO",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_PORTAGE_MICHIGAN",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GEORGETOWN_KENTUCKY",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_GREENVILLE_SOUTH_CAROLINA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_NASHVILLE_TENNESSEE",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_WASHINGTON_DISTRICT_OF_COLUMBIA",
        "PROVIDER_US_PUBLIC_MUNICIPALITY_BOULDER_COLORADO",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY",
        "PROVIDER_NZ_PUBLIC_MUNICIPALITY_ENVIRONMENT_BAY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY",
        "PROVIDER_PL_PUBLIC_MUNICIPALITY_BIELSKO_BIALA",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_FRANKFURT",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_HAMBURG",
        "PROVIDER_DE_PUBLIC_MUNICIPALITY_KARLSRUHE",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY",
        "PROVIDER_PT_PUBLIC_MUNICIPALITY_SANTA_CRUZ",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_KLAGENFURT",
        "PROVIDER_AT_PUBLIC_MUNICIPALITY_LINZ",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_AZKOITIA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_BEASAIN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_GIRONA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_SAN_SEBASTIAN",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_CATALUNYA",
        "PROVIDER_ES_PUBLIC_MUNICIPALITY_HONDARRIBIA",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY",
        "PROVIDER_AU_PUBLIC_MUNICIPALITY_LAUNCESTON_TASMANIA",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY",
        "PROVIDER_IS_PUBLIC_MUNICIPALITY_REYKJAVIK",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY",
        "PROVIDER_NL_PUBLIC_MUNICIPALITY_AMELSTEVEEN",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY",
        "PROVIDER_BE_PUBLIC_MUNICIPALITY_ANTWERPEN",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_FREDERICTON_NEW_BRUNSWICK",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_KAMLOOPS_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_NANAIMO_BRITISH_COLUMBIA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_BANFF_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_CALGARY_ALBERTA",
        "PROVIDER_CA_PUBLIC_MUNICIPALITY_TORONTO_ONTARIO",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY",
        "PROVIDER_SE_PUBLIC_MUNICIPALITY_UMEA",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY",
        "PROVIDER_UA_PUBLIC_MUNICIPALITY_KHARKIV",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY",
        "PROVIDER_OTHER_PUBLIC_MUNICIPALITY_AQUA_CALIENTE_CAHUILLA_INDIANS",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_PONT_AUDEMER",
        "PROVIDER_FR_PUBLIC_MUNICIPALITY_BORDEAUX",
        "PROVIDER_SG_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY",
        "PROVIDER_BR_PUBLIC_MUNICIPALITY_RIO_DE_JANEIRO",
        "PROVIDER_MAPCUBE",
        "PROVIDER_3D_REALITYMAPS",
        "PROVIDER_DEUTSCHES_ZENTRUM_FUR_LUFT_UND_RAUMFAHRT",
        "PROVIDER_3D_CITIES_SOCIEDADE_ANONIMA",
        "PROVIDER_DISNEY",
        "PROVIDER_CYBERCITY",
        "PROVIDER_PRECISION_LIGHTWORKS_MODELWORKS",
        "PROVIDER_VIRTUAL_HUNGARY_LIMITED",
        "PROVIDER_VIRTUEL_CITY",
        "PROVIDER_SCREAMPOINT_INTERNATIONAL",
        "PROVIDER_AGENTSCHAP_VOOR_GEOGRAFISCHE_INFORMATIE_VLAANDEREN",
        "PROVIDER_FR_GOVERNMENT",
        "PROVIDER_FR_INSTITUT_GEOGRAPHIQUE_NATIONAL",
        "PROVIDER_FR_CADASTRE",
        "PROVIDER_DIADIEM",
        "PROVIDER_THE_WEATHER_CHANNEL",
        "PROVIDER_COWI",
        "PROVIDER_FALKPLAN_ANDES",
        "PROVIDER_NL_GOVERNMENT",
        "PROVIDER_NL_KADASTER",
        "PROVIDER_NL_BOARD_OF_TOURISM_AND_CONVENTIONS",
        "PROVIDER_DIGITAL_MAP_PRODUCTS",
        "PROVIDER_SILICE_DIGITAL",
        "PROVIDER_TYDAC",
        "PROVIDER_ALBRECHT_GOLF",
        "PROVIDER_HEALTH_CH",
        "PROVIDER_VISITDENMARK",
        "PROVIDER_FLYHERE",
        "PROVIDER_DIGITAL_DATA_SERVICES",
        "PROVIDER_MECOMO",
        "PROVIDER_ZA_GOVERNMENT",
        "PROVIDER_ZA_RURAL_DEVELOPMENT_LAND_REFORM",
        "PROVIDER_SENSIS",
        "PROVIDER_JJCONNECT",
        "PROVIDER_OPPLYSNINGEN",
        "PROVIDER_TELLUS",
        "PROVIDER_IQONIA",
        "PROVIDER_BE_GOVERNMENT",
        "PROVIDER_BE_NATIONAAL_GEOGRAFISCH_INSTITUUT",
        "PROVIDER_BE_BRUSSELS_MOBILITY",
        "PROVIDER_YELLOWMAP_AG",
        "PROVIDER_STIFTUNG_GESUNDHEIT",
        "PROVIDER_GIATA",
        "PROVIDER_SANPARKS",
        "PROVIDER_CENTRE_DINFORMATIQUE_POUR_LA_REGION_BRUXELLOISE",
        "PROVIDER_INFOPORTUGAL",
        "PROVIDER_NEGOCIOS_DE_TELECOMUNICACOES_E_SISTEMAS_DE_INFORMACAO",
        "PROVIDER_COLLINS_BARTHOLOMEW",
        "PROVIDER_PROTECT_PLANET_OCEAN",
        "PROVIDER_KARTTAKESKUS",
        "PROVIDER_FI_GOVERNMENT",
        "PROVIDER_FI_NATIONAL_ROAD_ADMINISTRATION",
        "PROVIDER_FI_NATIONAL_LAND_SURVEY",
        "PROVIDER_FI_STATISTICS_FINLAND",
        "PROVIDER_GB_GOVERNMENT",
        "PROVIDER_GB_ORDNANCE_SURVEY",
        "PROVIDER_NATURAL_ENGLAND",
        "PROVIDER_WELSH_GOVERNMENT",
        "PROVIDER_GB_OFFICE_FOR_NATIONAL_STATISTICS",
        "PROVIDER_EPSILON",
        "PROVIDER_PARTNER_FRONT_END",
        "PROVIDER_CARTESIA",
        "PROVIDER_SE_GOVERNMENT",
        "PROVIDER_SE_TRAFIKVERKET",
        "PROVIDER_SE_NATURVARDSVERKET",
        "PROVIDER_IE_GOVERNMENT",
        "PROVIDER_IE_ORDNANCE_SURVEY_IRELAND",
        "PROVIDER_LU_GOVERNMENT",
        "PROVIDER_LU_P_AND_T_LUXEMBOURG",
        "PROVIDER_LU_ADMINISTRATION_DU_CADASTRE_ET_DE_LA_TOPOGRAPHIE",
        "PROVIDER_LU_NATIONAL_TOURIST_OFFICE",
        "PROVIDER_MAPFLOW",
        "PROVIDER_TKARTOR",
        "PROVIDER_JUMPSTART",
        "PROVIDER_EPTISA",
        "PROVIDER_MC_GOVERNMENT",
        "PROVIDER_MC_PRINCIPAUTE_DE_MONACO",
        "PROVIDER_MONOLIT",
        "PROVIDER_ENVIRONMENTAL_SYSTEMS_RESEARCH_INSTITUTE",
        "PROVIDER_MODIS",
        "PROVIDER_GEOX",
        "PROVIDER_GEODIRECTORY",
        "PROVIDER_GEOPLAN",
        "PROVIDER_INFODIREKT",
        "PROVIDER_GEOGLOBAL",
        "PROVIDER_DEUTSCHE_POST",
        "PROVIDER_TRACASA",
        "PROVIDER_CORREOS",
        "PROVIDER_ES_GOVERNMENT",
        "PROVIDER_ES_CENTRO_NACIONAL_DE_INFORMACION_GEOGRAFICA",
        "PROVIDER_EDIMAP",
        "PROVIDER_VERIZON",
        "PROVIDER_NATIONAL_GEOGRAPHIC_MAPS",
        "PROVIDER_PROMAPS",
        "PROVIDER_CONSODATA",
        "PROVIDER_DE_AGOSTINI",
        "PROVIDER_FEDERPARCHI",
        "PROVIDER_NAVIGO",
        "PROVIDER_ITALIAMAPPE",
        "PROVIDER_CZECOT",
        "PROVIDER_NATURAL_EARTH",
        "PROVIDER_REGIO",
        "PROVIDER_SHIPWRECK_CENTRAL",
        "PROVIDER_RUTGERS_STATE_UNIVERSITY",
        "PROVIDER_TWINICE",
        "PROVIDER_NORTHERN_IRELAND_TOURIST_BOARD",
        "PROVIDER_INFOGROUP",
        "PROVIDER_TNET",
        "PROVIDER_CTT_CORREIOS_DE_PORTUGAL",
        "PROVIDER_EUROPARC",
        "PROVIDER_IUPPITER",
        "PROVIDER_MICHAEL_BAUER_INTERNATIONAL",
        "PROVIDER_LEPTON",
        "PROVIDER_MAPPOINT",
        "PROVIDER_GEODATA",
        "PROVIDER_RU_GOVERNMENT",
        "PROVIDER_RU_FNS_KLADR",
        "PROVIDER_BR_GOVERNMENT",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DO_MEIO_AMBIENTE_E_DOS_RECURSOS_NATURAIS_RENOVAVEIS",
        "PROVIDER_BR_MINISTERIO_DO_MEIO_AMBIENTE",
        "PROVIDER_BR_AGENCIA_NACIONAL_DE_AGUAS",
        "PROVIDER_BR_INSTITUTO_BRASILEIRO_DE_GEOGRAFIA_E_ESTATISTICA",
        "PROVIDER_BR_FUNDACAO_NACIONAL_DO_INDIO",
        "PROVIDER_BR_DEPARTAMENTO_NACIONAL_DE_INFRAESTRUTURA_DE_TRANSPORTES",
        "PROVIDER_AZAVEA",
        "PROVIDER_NORTHSTAR",
        "PROVIDER_COMMEDI",
        "PROVIDER_NEXUS_GEOGRAFICS",
        "PROVIDER_INFOERA",
        "PROVIDER_AD_GOVERNMENT",
        "PROVIDER_AD_AREA_DE_CARTOGRAFIA",
        "PROVIDER_MAXXIMA",
        "PROVIDER_SI_GOVERNMENT",
        "PROVIDER_SI_AGENCY_FOR_ENVIRONMENT",
        "PROVIDER_TRANSPORT_HI_TECH_CONSULTANTS",
        "PROVIDER_L1_TECHNOLOGIES",
        "PROVIDER_TELEMEDIA",
        "PROVIDER_CDCOM_PROGOROD",
        "PROVIDER_MIT_CITYGUIDE",
        "PROVIDER_SUNCART",
        "PROVIDER_MICROMAPPER",
        "PROVIDER_RICHI",
        "PROVIDER_FORUM44",
        "PROVIDER_SEAT",
        "PROVIDER_VALASSIS",
        "PROVIDER_NAVICOM",
        "PROVIDER_COLTRACK",
        "PROVIDER_PSMA_AUSTRALIA",
        "PROVIDER_PT_DUTA_ASTAKONA_GIRINDA",
        "PROVIDER_CA_GOVERNMENT",
        "PROVIDER_STATISTICS_CANADA",
        "PROVIDER_TOCTOC",
        "PROVIDER_RMSI",
        "PROVIDER_TRUE_TECHNOLOGY",
        "PROVIDER_INCREMENT_P_CORPORATION",
        "PROVIDER_GOJAVAS",
        "PROVIDER_GEOINFORMATION_GROUP",
        "PROVIDER_CYBERSOFT",
        "PROVIDER_TSENTR_EFFEKTIVNYKH_TEKHNOLOGIY",
        "PROVIDER_EE_GOVERNMENT",
        "PROVIDER_EE_MAA_AMET",
        "PROVIDER_GASBUDDY",
        "PROVIDER_DK_GOVERNMENT",
        "PROVIDER_DK_GEODATASTYRELSEN",
        "PROVIDER_MURCIA_REGION_GOVERNMENT",
        "PROVIDER_CORREIOS",
        "PROVIDER_WEST_WORLD_MEDIA",
        "PROVIDER_INTERNATIONAL_MAPPING_ASSOCIATION",
        "PROVIDER_MEDICARE",
        "PROVIDER_POLARIS",
        "PROVIDER_TW_GOVERNMENT",
        "PROVIDER_TW_MINISTRY_OF_THE_INTERIOR_SURVEYING_AND_MAPPING_CENTER",
        "PROVIDER_NORDECA",
        "PROVIDER_AFRIMAPPING",
        "PROVIDER_OVERDRIVE",
        "PROVIDER_PROVIDER_NETWORK_DIRECTORIES",
        "PROVIDER_BR_MINISTERIO_DA_SAUDE",
        "PROVIDER_DIGITAL_EGYPT",
        "PROVIDER_INRIX",
        "PROVIDER_ARPINDO",
        "PROVIDER_IT_GOVERNMENT",
        "PROVIDER_ISTITUTO_GEOGRAFICO_MILITARE",
        "PROVIDER_EAST_END_GROUP",
        "PROVIDER_INGEOLAN",
        "PROVIDER_SEMACONNECT",
        "PROVIDER_BLINK",
        "PROVIDER_EVGO",
        "PROVIDER_CHARGEPOINT",
        "PROVIDER_TPL_TRAKKER",
        "PROVIDER_OI",
        "PROVIDER_MAPARADAR",
        "PROVIDER_SINGAPORE_POST",
        "PROVIDER_CHARGEMASTER",
        "PROVIDER_TESLA",
        "PROVIDER_VISICOM",
        "PROVIDER_GEOLYSIS",
        "PROVIDER_ZEPHEIRA",
        "PROVIDER_HUBJECT",
        "PROVIDER_PODPOINT",
        "PROVIDER_CHARGEFOX",
        "PROVIDER_KR_GOVERNMENT",
        "PROVIDER_KR_MOLIT",
        "PROVIDER_KR_MINISTRY_OF_THE_INTERIOR_AND_SAFETY",
        "PROVIDER_CRITCHLOW",
        "PROVIDER_EIFRIG",
        "PROVIDER_GIREVE",
        "PROVIDER_CN_NAVINFO",
        "PROVIDER_JAPAN_CHARGE_NETWORK",
        "PROVIDER_NOBIL",
        "PROVIDER_INDIA_BANKS",
        "PROVIDER_INDONESIA_ELECTION_KPU",
        "PROVIDER_CAREERS360",
        "PROVIDER_SOURCE_LONDON",
        "PROVIDER_EVBOX",
        "PROVIDER_JP_GOVERNMENT",
        "PROVIDER_JP_MINISTRY_OF_THE_ENVIRONMENT",
        "PROVIDER_YUMYUM",
        "PROVIDER_HWW_AUSTRALIA",
        "PROVIDER_CINERGY",
        "PROVIDER_MTIME",
        "PROVIDER_KULTUNAUT",
        "PROVIDER_BLITZ",
        "PROVIDER_PIA",
        "PROVIDER_INTERPARK",
        "PROVIDER_CINEMA_ONLINE",
        "PROVIDER_BELBIOS",
        "PROVIDER_MOVIESEER",
        "PROVIDER_SODAMEDYA",
        "PROVIDER_ATMOVIES",
        "PROVIDER_HOTELBEDS",
        "PROVIDER_VERICRED",
        "PROVIDER_CIRRANTIC",
        "PROVIDER_GOGO_LABS",
        "PROVIDER_ELECTRIFY_AMERICA",
        "PROVIDER_CMS_MPPUF",
        "PROVIDER_DIGIROAD",
        "PROVIDER_KONTEX_GEOMATICS",
        "PROVIDER_NZ_GOVERNMENT",
        "PROVIDER_NZ_LINZ",
        "PROVIDER_NZ_DOC",
        "PROVIDER_FASTNED",
        "PROVIDER_DESTINY_CS",
        "PROVIDER_IONITY",
        "PROVIDER_EV_CONNECT",
        "PROVIDER_PANPAGES",
        "PROVIDER_ETECNIC",
        "PROVIDER_VOLTA",
        "PROVIDER_NISSAN_MEXICO",
        "PROVIDER_BMW_GROUP_LATIN_AMERICA",
        "PROVIDER_FEDERAL_ELECTRICITY_COMMISSION_MEXICO",
        "PROVIDER_VOLVO_CARS_BRASIL",
        "PROVIDER_CHARGE_AND_PARKING",
        "PROVIDER_DEDUCE_TECHNOLOGIES",
        "PROVIDER_SK_TELECOM",
        "PROVIDER_ECO_MOVEMENT",
        "PROVIDER_GOOGLE_GMS",
        "PROVIDER_EASYWAY",
        "PROVIDER_PHYSICIAN_COMPARE",
        "PROVIDER_HOSPITAL_COMPARE",
        "PROVIDER_ENDOLLA_BARCELONA",
        "PROVIDER_BE_CHARGE",
        "PROVIDER_ONE_NETWORK",
        "PROVIDER_CARENAV_DUPLEX",
        "PROVIDER_CARENAV_POI",
        "PROVIDER_IN_GOVERNMENT",
        "PROVIDER_SURVEY_OF_INDIA",
        "PROVIDER_E_ON",
        "PROVIDER_ELECTRIFY_CANADA",
        "PROVIDER_GRIDCARS",
        "PROVIDER_DRIVECO",
        "PROVIDER_GREEN_ACTION_STUDIOS",
        "PROVIDER_GREEN_ACTION_STUDIO",
        "PROVIDER_EVINY",
        "PROVIDER_MASTERCARD",
        "PROVIDER_VATTENFALL",
        "PROVIDER_VIETGIS",
        "PROVIDER_UNITE",
        "PROVIDER_NEOGY",
        "PROVIDER_AMPUP",
        "PROVIDER_LOOP",
        "PROVIDER_ZEST",
        "PROVIDER_EZVOLT",
        "PROVIDER_JOLT",
        "PROVIDER_CHARGESMITH",
        "PROVIDER_PLUGO",
        "PROVIDER_ELECTRIC_ERA",
    ]

@typing.type_check_only
class GeostoreRankDetailsProto(typing_extensions.TypedDict, total=False):
    signal: _list[GeostoreRankSignalProto]
    signalMixerType: typing_extensions.Literal[
        "MIXER_INVALID",
        "MIXER_MISSING",
        "MIXER_ADDRESS_AREA",
        "MIXER_ROUTE_SEGMENT_INTERSECTION",
        "MIXER_POLITICAL_EUROPA",
        "MIXER_POLITICAL_AREA",
        "MIXER_POLITICAL",
        "MIXER_COUNTRY_EUROPA",
        "MIXER_COUNTRY_AREA",
        "MIXER_COUNTRY",
        "MIXER_LOCALITY",
        "MIXER_LOCALITY_GEOWIKI",
        "MIXER_LOCALITY_EUROPA",
        "MIXER_LOCALITY_AREA",
        "MIXER_RIVER",
        "MIXER_LENGTH_WEBSCORE",
        "MIXER_SKENERGY",
        "MIXER_GEOCENTRE_GEOCODED_ADDRESS",
        "MIXER_PLACERANK",
        "MIXER_TRANSIT",
        "MIXER_LOCALITY_EUROPA_AREA",
        "MIXER_WEBSCORE",
        "MIXER_LOCALITY_MAPDATA_SCIENCES",
        "MIXER_SUBLOCALITY_MAPDATA_SCIENCES",
        "MIXER_PEAK",
        "MIXER_BUILDING",
        "MIXER_RESERVATION",
        "MIXER_AIRPORT",
        "MIXER_AREA",
        "MIXER_MANAGER",
        "MIXER_TEST_1",
        "MIXER_TEST_2",
        "MIXER_TEST_3",
        "MIXER_TEST_4",
        "MIXER_TEST_5",
    ]

@typing.type_check_only
class GeostoreRankSignalProto(typing_extensions.TypedDict, total=False):
    metadata: GeostoreFieldMetadataProto
    rank: float
    rawScalar: float
    rawString: str
    type: typing_extensions.Literal[
        "SIGNAL_UNKNOWN",
        "SIGNAL_LENGTH",
        "SIGNAL_AREA",
        "SIGNAL_ADDRESS",
        "SIGNAL_LISTING",
        "SIGNAL_ROAD_PRIORITY",
        "SIGNAL_POI_COUNT",
        "SIGNAL_WEBSCORE",
        "SIGNAL_PATHRADIUS_LENGTH_METERS",
        "SIGNAL_PATHRADIUS_LENGTH_SEGMENTS",
        "SIGNAL_PATHRADIUS_POPULARITY",
        "SIGNAL_PEAK_ELEVATION_PROMINENCE",
        "SIGNAL_ROAD_SEGMENT_COUNT",
        "SIGNAL_POI_SCORE",
        "SIGNAL_ATTRACTIONS_SCORE",
        "SIGNAL_HAND_RANKED_LOCALITY_PROMINENCE",
        "SIGNAL_POPULATION",
        "SIGNAL_GDP",
        "SIGNAL_EUROPA_CLASS",
        "SIGNAL_RMF_SOURCE_RANK",
        "SIGNAL_MDS_SOURCE_RANK",
        "SIGNAL_MULTINET_SOURCE_RANK",
        "SIGNAL_LOCALXML_MANUAL_RANK",
        "SIGNAL_TRANSIT_LINE",
        "SIGNAL_TRANSIT_TRAIN_DEPARTURE_COUNT",
        "SIGNAL_TRANSIT_METRO_DEPARTURE_COUNT",
        "SIGNAL_TRANSIT_BUS_DEPARTURE_COUNT",
        "SIGNAL_TRANSIT_OTHER_DEPARTURE_COUNT",
        "SIGNAL_TRANSIT_TRAIN_LINE_COUNT",
        "SIGNAL_TRANSIT_METRO_LINE_COUNT",
        "SIGNAL_TRANSIT_BUS_LINE_COUNT",
        "SIGNAL_TRANSIT_OTHER_LINE_COUNT",
        "SIGNAL_TRANSIT_STATION_LOCAL_RANK",
        "SIGNAL_TRANSIT_STATION_GLOBAL_RANK",
        "SIGNAL_ORION_LEVEL",
        "SIGNAL_GEOCENTRE_ADDRESS_RANK",
        "SIGNAL_GOOGLE_3DWAREHOUSE_RANK",
        "SIGNAL_SKENERGY_CATEGORY",
        "SIGNAL_GOOGLE_GEOWIKI_USER_RANK",
        "SIGNAL_WIKIPEDIA_ARTICLES",
        "SIGNAL_WIKIPEDIA_ARTICLES_IN_OFFICIAL_LANGUAGE",
        "SIGNAL_KML_PLACEMARKS",
        "SIGNAL_KML_SOURCES",
        "SIGNAL_PANORAMIO_USERS",
        "SIGNAL_GOOGLE_MAPSHOP_USERS",
        "SIGNAL_GOOGLE_LOCALSEARCH_DIRECTORY_INFOS",
        "SIGNAL_GOOGLE_MAPS_NAVBOOST_CLICKS",
        "SIGNAL_GOOGLE_MAPS_NAVBOOST_CLICKTHROUGH_RATE",
        "SIGNAL_GOOGLE_RBL_CLICKS",
        "SIGNAL_GOOGLE_RBL_CLICK_FRACTION",
        "SIGNAL_GOOGLE_AUTHORITYPAGE_PAGERANK",
        "SIGNAL_GOOGLE_AUTHORITYPAGE_PAGERANK_CONFIDENCE",
        "SIGNAL_GOOGLE_REVIEWS",
        "SIGNAL_GOOGLE_WEB_QUERYVOL",
        "SIGNAL_GOOGLE_WEBPAGE_REFERENCE_DOMAINS",
        "SIGNAL_GOOGLE_LISTING_IMPRESSIONS",
        "SIGNAL_GOOGLE_INFOWINDOW_VIEWS",
        "SIGNAL_GOOGLE_DIRECTION_REQUESTS",
        "SIGNAL_GOOGLE_HOMEPAGE_CLICKS",
        "SIGNAL_GOOGLE_CHAIN_STORES",
        "SIGNAL_FLICKR_USERS",
        "SIGNAL_GOOGLE_LEANBACK_TOURS",
        "SIGNAL_GOOGLE_LOCALSEARCH_PLACERANK",
        "SIGNAL_WIKIPEDIA_WIKI_SCORE",
        "SIGNAL_ZENRIN_CITY_CATEGORY",
        "SIGNAL_ZENRIN_BUILDING_CLASS",
        "SIGNAL_ZENRIN_PEAK_CLASS",
        "SIGNAL_PLACE_INSIGHTS_LANDMARK",
        "SIGNAL_PLACE_INSIGHTS_POPULARITY",
        "SIGNAL_PLACE_INSIGHTS_PROMINENCE",
        "SIGNAL_PLACE_INSIGHTS_APPROACHABILITY",
        "SIGNAL_PLACE_INSIGHTS_TOTAL_ROAD_SEGMENT_USAGE",
    ]

@typing.type_check_only
class GeostoreRawDataProto(typing_extensions.TypedDict, total=False):
    key: str
    valueString: str

@typing.type_check_only
class GeostoreRawMetadataProto(typing_extensions.TypedDict, total=False):
    conflationMethod: typing_extensions.Literal[
        "CONFLATION_PICK_FIRST_VALUE", "CONFLATION_UNION_CSV", "CONFLATION_SUM"
    ]
    description: str
    key: str
    label: str

@typing.type_check_only
class GeostoreRectProto(typing_extensions.TypedDict, total=False):
    hi: GeostorePointProto
    lo: GeostorePointProto

@typing.type_check_only
class GeostoreRegionSpecificNameProto(typing_extensions.TypedDict, total=False):
    displayableAsAlternativeName: bool
    name: GeostoreNameProto
    regionCode: str

@typing.type_check_only
class GeostoreRegulatedAreaProto(typing_extensions.TypedDict, total=False):
    restriction: _list[GeostoreRestrictionProto]

@typing.type_check_only
class GeostoreRelationProto(typing_extensions.TypedDict, total=False):
    metadata: GeostoreFieldMetadataProto
    otherFeatureCountryCode: str
    otherFeatureId: GeostoreFeatureIdProto
    otherFeatureName: _list[GeostoreNameProto]
    otherFeatureTerritorialAdministrator: str
    otherFeatureType: int
    overlapFraction: float
    relation: typing_extensions.Literal[
        "RELATION_OVERLAPS",
        "RELATION_CONTAINED_BY",
        "RELATION_EQUAL_TO",
        "RELATION_POLITICAL_DEPRECATED",
        "RELATION_CAPITAL_OF",
        "RELATION_DISAMBIGUATED_BY",
        "RELATION_NEIGHBOR_OF",
        "RELATION_OPPOSITE_TO",
        "RELATION_NEXT_TO",
        "RELATION_RIGHT_OF",
        "RELATION_LEFT_OF",
        "RELATION_BEHIND",
        "RELATION_IN_FRONT_OF",
        "RELATION_SAME_BUILDING",
        "RELATION_ABOVE",
        "RELATION_BELOW",
        "RELATION_NEAR",
        "RELATION_ORGANIZATIONALLY_PART_OF",
        "RELATION_DEPARTMENT_OF",
        "RELATION_WORKS_AT",
        "RELATION_INDEPENDENT_ESTABLISHMENT_IN",
        "RELATION_ON_LEVEL",
        "RELATION_OCCUPIES",
        "RELATION_BUSINESS_LIFE_CYCLE",
        "RELATION_BUSINESS_MOVED",
        "RELATION_BUSINESS_REBRANDED",
        "RELATION_MEMBER_OF_CHAIN",
        "RELATION_AUTHORIZED_DEALER_FOR_CHAIN",
        "RELATION_SUBSIDIARY_OF",
        "RELATION_PRIMARILY_OCCUPIED_BY",
        "RELATION_VARIATION",
        "RELATION_HAS_VARIANT",
        "RELATION_VARIANT_OF",
        "RELATION_VARIANT_SIBLING",
        "RELATION_CLIENT_DEFINED",
    ]
    relationIsReversed: bool
    temporaryData: Proto2BridgeMessageSet

@typing.type_check_only
class GeostoreRestrictionGroupProto(typing_extensions.TypedDict, total=False):
    metadata: GeostoreFieldMetadataProto
    segment: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreRestrictionProto(typing_extensions.TypedDict, total=False):
    autonomousDrivingProducts: _list[
        typing_extensions.Literal[
            "UNKNOWN", "HD_L4", "HD_L2", "ADAS", "AUTO_DRIVING_EXPERIENCE"
        ]
    ]
    intersectionGroup: GeostoreFeatureIdProto
    metadata: GeostoreFieldMetadataProto
    restrictionGroup: GeostoreFeatureIdProto
    restrictionToken: str
    schedule: GeostoreTimeScheduleProto
    scope: typing_extensions.Literal["SCOPE_DIRECTION", "SCOPE_SIDE"]
    style: typing_extensions.Literal[
        "STYLE_CONTIGUOUS", "STYLE_SINGLE", "STYLE_TURN", "STYLE_IN_OUT"
    ]
    subpath: _list[GeostoreFeatureIdProto]
    temporaryData: Proto2BridgeMessageSet
    travelMode: _list[
        typing_extensions.Literal[
            "TRAVEL_ANY",
            "TRAVEL_MOTOR_VEHICLE",
            "TRAVEL_AUTO",
            "TRAVEL_CARPOOL",
            "TRAVEL_MOTORCYCLE",
            "TRAVEL_BUS",
            "TRAVEL_TRUCK",
            "TRAVEL_DELIVERY",
            "TRAVEL_TAXI",
            "TRAVEL_EMERGENCY",
            "TRAVEL_THROUGH_TRAFFIC",
            "TRAVEL_AUTONOMOUS_VEHICLE",
            "TRAVEL_PEDESTRIAN",
            "TRAVEL_BICYCLE",
        ]
    ]
    type: typing_extensions.Literal[
        "RESTRICTION_TRAVEL_RESTRICTED",
        "RESTRICTION_ILLEGAL",
        "RESTRICTION_PHYSICAL",
        "RESTRICTION_LOGICAL",
        "RESTRICTION_GATE",
        "RESTRICTION_CONSTRUCTION",
        "RESTRICTION_SEASONAL_CLOSURE",
        "RESTRICTION_PRIVATE",
        "RESTRICTION_WRONG_WAY",
        "RESTRICTION_TERMINAL",
        "RESTRICTION_PAYMENT_REQUIRED",
        "RESTRICTION_TOLL_BOOTH",
        "RESTRICTION_USAGE_FEE_REQUIRED",
        "RESTRICTION_ENTRANCE_FEE_REQUIRED",
        "RESTRICTION_VIGNETTE_REQUIRED",
        "RESTRICTION_ADVISORY",
        "RESTRICTION_HIGH_CRIME",
        "RESTRICTION_POLITICALLY_SENSITIVE",
        "RESTRICTION_DISTURBED_BY_MAINTENANCE",
        "RESTRICTION_CHECKPOINT",
        "RESTRICTION_REGION_SPECIFIC",
    ]
    vehicleAttributeFilter: GeostoreVehicleAttributeFilterProto

@typing.type_check_only
class GeostoreRightsStatusProto(typing_extensions.TypedDict, total=False):
    fieldWithRights: _list[GeostoreFieldWithRightsProto]

@typing.type_check_only
class GeostoreRoadConditionalProto(typing_extensions.TypedDict, total=False):
    timeSchedule: GeostoreTimeScheduleProto
    vehicleAttribute: GeostoreVehicleAttributeFilterProto
    vehicleType: _list[
        typing_extensions.Literal["UNKNOWN", "ANY", "CAR", "MOTORCYCLE", "TRUCK", "BUS"]
    ]

@typing.type_check_only
class GeostoreRoadMonitorProto(typing_extensions.TypedDict, total=False):
    monitoredRoad: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreRoadSignComponentProto(typing_extensions.TypedDict, total=False):
    featureId: GeostoreFeatureIdProto
    featureType: int
    majorPosition: int
    minorPosition: int
    routeDirection: typing_extensions.Literal[
        "DIRECTION_NONE",
        "DIRECTION_NORTH",
        "DIRECTION_EAST",
        "DIRECTION_SOUTH",
        "DIRECTION_WEST",
        "DIRECTION_NORTHEAST",
        "DIRECTION_NORTHWEST",
        "DIRECTION_SOUTHEAST",
        "DIRECTION_SOUTHWEST",
        "DIRECTION_INNER",
        "DIRECTION_OUTER",
    ]
    semanticType: typing_extensions.Literal[
        "ROAD_SIGN_SEMANTIC_TYPE_UNSPECIFIED",
        "PRIORITY",
        "PRIORITY_STOP",
        "PRIORITY_STOP_AHEAD",
        "PRIORITY_YIELD",
        "PRIORITY_YIELD_AHEAD",
        "SPEED_LIMIT",
        "SPEED_LIMIT_START",
        "SPEED_LIMIT_START_MAX",
        "SPEED_LIMIT_START_MIN",
        "SPEED_LIMIT_START_SCHOOL",
        "SPEED_LIMIT_START_ZONE",
        "SPEED_LIMIT_START_ADVISORY",
        "SPEED_LIMIT_START_AHEAD",
        "SPEED_LIMIT_END",
        "SPEED_LIMIT_END_MAX",
        "SPEED_LIMIT_END_MIN",
        "SPEED_LIMIT_END_SCHOOL",
        "SPEED_LIMIT_END_ZONE",
        "RESTRICTION",
        "RESTRICTION_TURN",
        "RESTRICTION_TURN_NO_RIGHT",
        "RESTRICTION_TURN_NO_LEFT",
        "RESTRICTION_TURN_NO_U",
        "RESTRICTION_TURN_NO_THRU",
        "RESTRICTION_MOVEMENT",
        "RESTRICTION_MOVEMENT_PASSING",
        "RESTRICTION_ACCESS",
        "RESTRICTION_ACCESS_NO_ENTRY",
        "WARNING",
        "WARNING_CROSSING",
        "WARNING_CROSSING_CHILDREN",
        "WARNING_CROSSING_PEDESTRIAN",
        "WARNING_CROSSING_RAILROAD",
        "WARNING_CROSSING_SCHOOL",
        "WARNING_ROAD_WORK",
        "INFO",
        "INFO_BOUNDARY",
        "INFO_BOUNDARY_BUILT_UP_AREA",
        "INFO_BOUNDARY_BUILT_UP_AREA_START",
        "INFO_BOUNDARY_BUILT_UP_AREA_END",
        "INFO_BOUNDARY_RESIDENTIAL",
        "INFO_BOUNDARY_RESIDENTIAL_START",
        "INFO_BOUNDARY_RESIDENTIAL_END",
        "INFO_TRANSIT",
        "AUXILIARY",
        "AUXILIARY_ANIMAL",
        "AUXILIARY_DIRECTION",
        "AUXILIARY_DISTANCE",
        "AUXILIARY_TIME",
        "AUXILIARY_WEATHER",
        "AUXILIARY_WEIGHT",
        "AUXILIARY_VEHICLE",
    ]
    text: GeostoreNameProto
    type: typing_extensions.Literal["TYPE_TEXT"]

@typing.type_check_only
class GeostoreRoadSignProto(typing_extensions.TypedDict, total=False):
    component: _list[GeostoreRoadSignComponentProto]

@typing.type_check_only
class GeostoreRouteAssociationProto(typing_extensions.TypedDict, total=False):
    displayPreference: typing_extensions.Literal[
        "DISPLAY_PREFERRED", "DISPLAY_BEST", "DISPLAY_OK", "DISPLAY_HIDE"
    ]
    metadata: GeostoreFieldMetadataProto
    route: GeostoreFeatureIdProto
    routeDirection: typing_extensions.Literal[
        "DIRECTION_NONE",
        "DIRECTION_NORTH",
        "DIRECTION_EAST",
        "DIRECTION_SOUTH",
        "DIRECTION_WEST",
        "DIRECTION_NORTHEAST",
        "DIRECTION_NORTHWEST",
        "DIRECTION_SOUTHEAST",
        "DIRECTION_SOUTHWEST",
        "DIRECTION_INNER",
        "DIRECTION_OUTER",
    ]

@typing.type_check_only
class GeostoreRouteProto(typing_extensions.TypedDict, total=False):
    childType: int

@typing.type_check_only
class GeostoreSchoolDistrictProto(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal["TYPE_UNIFIED", "TYPE_ELEMENTARY", "TYPE_SECONDARY"]

@typing.type_check_only
class GeostoreSegmentPathProto(typing_extensions.TypedDict, total=False):
    subpath: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreSegmentProto(typing_extensions.TypedDict, total=False):
    advisoryMaximumSpeed: _list[GeostoreAppliedSpeedLimitProto]
    altitude: _list[float]
    avgSpeedKph: float
    avgSpeedKphMetadata: GeostoreFieldMetadataProto
    barrier: typing_extensions.Literal[
        "BARRIER_NONE", "BARRIER_PRESENT", "BARRIER_LEGAL", "BARRIER_PHYSICAL"
    ]
    barrierMetadata: GeostoreFieldMetadataProto
    bicycleFacility: typing_extensions.Literal[
        "BICYCLE_FACILITY_SEPARATE_TRAIL",
        "BICYCLE_FACILITY_PEDESTRIAN_PATH",
        "BICYCLE_FACILITY_BIKE_FRIENDLY_PEDESTRIAN_PATH",
        "BICYCLE_FACILITY_SHARED_ROAD",
        "BICYCLE_FACILITY_BIKE_LANE",
        "BICYCLE_FACILITY_BIKE_LANE_WITH_PEDESTRIAN_PATH",
        "BICYCLE_FACILITY_WIDE_SHOULDER",
        "BICYCLE_FACILITY_SHARROW",
        "BICYCLE_FACILITY_SHARED_ROAD_WITH_PEDESTRIAN_PATH",
    ]
    bicycleSafety: typing_extensions.Literal[
        "BICYCLE_SAFETY_RECOMMENDED", "BICYCLE_SAFETY_NEUTRAL", "BICYCLE_SAFETY_CAUTION"
    ]
    condition: typing_extensions.Literal["CONDITION_GOOD", "CONDITION_POOR"]
    conditionMetadata: GeostoreFieldMetadataProto
    constructionBeginDate: GeostoreDateTimeProto
    constructionEndDate: GeostoreDateTimeProto
    constructionStatus: typing_extensions.Literal[
        "CONSTRUCTION_PLANNED",
        "CONSTRUCTION_STARTED",
        "CONSTRUCTION_COMPLETE",
        "CONSTRUCTION_CLOSED_FOR_MAINTENANCE",
        "CONSTRUCTION_DISTURBED_BY_MAINTENANCE",
    ]
    constructionStatusMetadata: GeostoreFieldMetadataProto
    covered: bool
    distanceToEdge: float
    distanceToEdgeMetadata: GeostoreFieldMetadataProto
    edgeFollowsSegmentBeginFraction: float
    edgeFollowsSegmentEndFraction: float
    elevation: typing_extensions.Literal[
        "ELEVATION_NORMAL",
        "ELEVATION_BRIDGE",
        "ELEVATION_TUNNEL",
        "ELEVATION_SKYWAY",
        "ELEVATION_STAIRWAY",
        "ELEVATION_ESCALATOR",
        "ELEVATION_ELEVATOR",
        "ELEVATION_SLOPEWAY",
        "ELEVATION_MOVING_WALKWAY",
    ]
    elevationMetadata: GeostoreFieldMetadataProto
    endpoint: typing_extensions.Literal[
        "ENDPOINT_UNKNOWN",
        "ENDPOINT_UNRESTRICTED",
        "ENDPOINT_UNCONTROLLED",
        "ENDPOINT_STOP_SIGN",
        "ENDPOINT_ALL_WAY_STOP",
        "ENDPOINT_TRAFFIC_LIGHT",
        "ENDPOINT_THREE_WAY",
        "ENDPOINT_FLASHING_RED",
        "ENDPOINT_FLASHING_YELLOW",
        "ENDPOINT_YIELD",
        "ENDPOINT_MERGE",
        "ENDPOINT_ROUNDABOUT",
        "ENDPOINT_RAILROAD_CROSSING",
        "ENDPOINT_NO_EXIT",
        "ENDPOINT_WRONG_WAY",
        "ENDPOINT_TOLL_BOOTH",
    ]
    endpointMetadata: GeostoreFieldMetadataProto
    gradeLevel: _list[GeostoreGradeLevelProto]
    internal: GeostoreInternalSegmentProto
    interpolationOffsetMeters: float
    intersection: GeostoreFeatureIdProto
    isMaxPermittedSpeedDerived: bool
    lane: _list[GeostoreLaneProto]
    legalMaximumSpeed: _list[GeostoreAppliedSpeedLimitProto]
    legalMinimumSpeed: _list[GeostoreAppliedSpeedLimitProto]
    maxPermittedSpeedKph: float
    maxPermittedSpeedKphMetadata: GeostoreFieldMetadataProto
    onRight: bool
    pedestrianCrossing: GeostorePedestrianCrossingProto
    pedestrianFacility: typing_extensions.Literal[
        "PEDESTRIAN_FACILITY_UNKNOWN",
        "PEDESTRIAN_FACILITY_NONE",
        "PEDESTRIAN_FACILITY_PRESENT",
        "PEDESTRIAN_FACILITY_SIDEWALK",
        "PEDESTRIAN_FACILITY_WIDE_SHOULDER",
    ]
    pedestrianGrade: typing_extensions.Literal[
        "PEDESTRIAN_GRADE_FLAT", "PEDESTRIAN_GRADE_UP", "PEDESTRIAN_GRADE_DOWN"
    ]
    priority: typing_extensions.Literal[
        "PRIORITY_UNKNOWN",
        "PRIORITY_NON_TRAFFIC",
        "PRIORITY_TERMINAL",
        "PRIORITY_LOCAL",
        "PRIORITY_MINOR_ARTERIAL",
        "PRIORITY_MAJOR_ARTERIAL",
        "PRIORITY_SECONDARY_ROAD",
        "PRIORITY_PRIMARY_HIGHWAY",
        "PRIORITY_LIMITED_ACCESS",
        "PRIORITY_CONTROLLED_ACCESS",
    ]
    priorityMetadata: GeostoreFieldMetadataProto
    ramp: GeostoreSegmentProtoRampProto
    restriction: _list[GeostoreRestrictionProto]
    roadMonitor: _list[GeostoreFeatureIdProto]
    roadSign: _list[GeostoreFeatureIdProto]
    route: _list[GeostoreFeatureIdProto]
    routeAssociation: _list[GeostoreRouteAssociationProto]
    separatedRoadways: bool
    sibling: GeostoreFeatureIdProto
    slope: _list[GeostoreSlopeProto]
    surface: typing_extensions.Literal[
        "SURFACE_UNKNOWN",
        "SURFACE_PAVED",
        "SURFACE_ASPHALT",
        "SURFACE_CONCRETE",
        "SURFACE_CHIPSEAL",
        "SURFACE_BRICK",
        "SURFACE_SETT",
        "SURFACE_COBBLESTONE",
        "SURFACE_UNPAVED",
        "SURFACE_GRAVEL",
        "SURFACE_DIRT",
        "SURFACE_SAND",
    ]
    surfaceMetadata: GeostoreFieldMetadataProto
    sweep: _list[GeostoreSweepProto]
    tollRoad: bool
    usage: typing_extensions.Literal[
        "USAGE_ANY",
        "USAGE_RAMP",
        "USAGE_ON_RAMP",
        "USAGE_OFF_RAMP",
        "USAGE_ON_OFF_RAMP",
        "USAGE_INTERCHANGE",
        "USAGE_SPECIAL_TRAFFIC_FIGURE",
        "USAGE_ROUNDABOUT",
        "USAGE_ROUNDABOUT_BYPASS",
        "USAGE_ROUNDABOUT_INTERNAL_BYPASS",
        "USAGE_ROUNDABOUT_EXTERNAL_BYPASS",
        "USAGE_ENCLOSED_TRAFFIC_AREA",
        "USAGE_PEDESTRIAN_MALL",
        "USAGE_MAJOR_PEDESTRIAN_MALL",
        "USAGE_MINOR_PEDESTRIAN_MALL",
        "USAGE_WALKWAY",
        "USAGE_TRAIL",
        "USAGE_STATION_PATH",
        "USAGE_ACCESS_PATH",
        "USAGE_CROSSING",
        "USAGE_MARKED_CROSSING",
        "USAGE_UNMARKED_CROSSING",
        "USAGE_OVERPASS",
        "USAGE_UNDERPASS",
        "USAGE_HALLWAY",
        "USAGE_TURN_SEGMENT",
        "USAGE_INDOOR_CONNECTION_PATH",
    ]
    visibleLandmark: _list[GeostoreLandmarkReferenceProto]

@typing.type_check_only
class GeostoreSegmentProtoRampProto(typing_extensions.TypedDict, total=False):
    maxConnectedPriority: typing_extensions.Literal[
        "PRIORITY_UNKNOWN",
        "PRIORITY_NON_TRAFFIC",
        "PRIORITY_TERMINAL",
        "PRIORITY_LOCAL",
        "PRIORITY_MINOR_ARTERIAL",
        "PRIORITY_MAJOR_ARTERIAL",
        "PRIORITY_SECONDARY_ROAD",
        "PRIORITY_PRIMARY_HIGHWAY",
        "PRIORITY_LIMITED_ACCESS",
        "PRIORITY_CONTROLLED_ACCESS",
    ]

@typing.type_check_only
class GeostoreServiceAreaProto(typing_extensions.TypedDict, total=False):
    servedFeature: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreServicedStopProto(typing_extensions.TypedDict, total=False):
    id: GeostoreFeatureIdProto
    index: int

@typing.type_check_only
class GeostoreSkiBoundaryProto(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "TYPE_ANY", "TYPE_DANGER", "TYPE_SKI_AREA", "TYPE_SLOW_ZONE"
    ]

@typing.type_check_only
class GeostoreSkiLiftProto(typing_extensions.TypedDict, total=False):
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_SURFACE",
        "TYPE_T_BAR",
        "TYPE_J_BAR",
        "TYPE_ROPE_TOW",
        "TYPE_POMA",
        "TYPE_CARPET",
        "TYPE_FUNICULAR",
        "TYPE_GONDOLA",
        "TYPE_CHAIR",
        "TYPE_AERIAL",
        "TYPE_TRAM",
    ]

@typing.type_check_only
class GeostoreSkiTrailProto(typing_extensions.TypedDict, total=False):
    difficulty: typing_extensions.Literal[
        "DIFFICULTY_EASIEST",
        "DIFFICULTY_EASY",
        "DIFFICULTY_INTERMEDIATE",
        "DIFFICULTY_ADVANCED_INTERMEDIATE",
        "DIFFICULTY_DIFFICULT",
        "DIFFICULTY_ADVANCED_DIFFICULT",
    ]
    type: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_GLADE",
        "TYPE_TRAIL_TERRAIN",
        "TYPE_TRAIL",
        "TYPE_RACE_COURSE",
        "TYPE_BOWL",
    ]

@typing.type_check_only
class GeostoreSlopeProto(typing_extensions.TypedDict, total=False):
    slopeValue: float
    startPointFraction: float

@typing.type_check_only
class GeostoreSocialReferenceProto(typing_extensions.TypedDict, total=False):
    baseGaiaId: str
    claimedGaiaId: str
    gaiaIdForDisplay: str

@typing.type_check_only
class GeostoreSourceInfoProto(typing_extensions.TypedDict, total=False):
    attributionUrl: _list[GeostoreUrlProto]
    collectionDate: GeostoreDateTimeProto
    cookie: str
    dataset: str
    gaiaId: str
    impersonationUser: GeostoreUserProto
    layer: str
    ogrFid: str
    provider: int
    rawData: _list[GeostoreRawDataProto]
    release: str
    sourceId: GeostoreFeatureIdProto
    temporaryData: Proto2BridgeMessageSet
    user: GeostoreUserProto

@typing.type_check_only
class GeostoreSourceTrustProto(typing_extensions.TypedDict, total=False):
    level: typing_extensions.Literal[
        "UNKNOWN", "BLOCKED", "NOT_TRUSTED", "YP_FEEDS", "TRUSTED", "SUPER_TRUSTED"
    ]

@typing.type_check_only
class GeostoreSpeedLimitProto(typing_extensions.TypedDict, total=False):
    category: typing_extensions.Literal[
        "SPEED_LIMIT_CATEGORY_UNKNOWN", "NONE", "SCHOOL", "CONSTRUCTION"
    ]
    condition: _list[GeostoreRoadConditionalProto]
    sourceType: typing_extensions.Literal[
        "SPEED_LIMIT_SOURCE_TYPE_UNKNOWN", "EXPLICIT", "IMPLICIT"
    ]
    speedWithUnit: GeostoreSpeedProto
    unlimitedSpeed: GeostoreUnlimitedSpeedProto
    variableSpeed: GeostoreVariableSpeedProto

@typing.type_check_only
class GeostoreSpeedProto(typing_extensions.TypedDict, total=False):
    speed: float
    unit: typing_extensions.Literal[
        "UNIT_UNKNOWN", "MILES_PER_HOUR", "KILOMETERS_PER_HOUR"
    ]

@typing.type_check_only
class GeostoreStableFieldPathProto(typing_extensions.TypedDict, total=False):
    fieldPath: _list[GeostoreStableFieldPathProtoStableFieldSelector]

@typing.type_check_only
class GeostoreStableFieldPathProtoStableFieldSelector(
    typing_extensions.TypedDict, total=False
):
    fieldNum: int
    versionToken: str

@typing.type_check_only
class GeostoreSweepProto(typing_extensions.TypedDict, total=False):
    otherSegmentFeatureId: GeostoreFeatureIdProto
    polygon: GeostorePolygonProto
    sweepCurve: GeostoreCurveConnectionProto
    sweepToken: str

@typing.type_check_only
class GeostoreTelephoneProto(typing_extensions.TypedDict, total=False):
    callRate: _list[GeostorePriceRangeProto]
    contactCategory: typing_extensions.Literal[
        "CONTACT_CATEGORY_UNSPECIFIED", "CUSTOMER_SERVICE", "RESERVATIONS", "SALES"
    ]
    flag: _list[typing_extensions.Literal["FLAG_NO_COLD_CALLS", "FLAG_PREFERRED"]]
    isSharedNumber: bool
    label: _list[GeostoreNameProto]
    language: _list[str]
    metadata: GeostoreFieldMetadataProto
    number: TelephoneNumber
    phoneNumber: I18nPhonenumbersPhoneNumber
    serviceLocationFeature: _list[GeostoreFeatureIdProto]
    type: typing_extensions.Literal[
        "VOICE", "FAX", "TDD", "DATA", "MOBILE", "MESSAGING"
    ]

@typing.type_check_only
class GeostoreTemporaryClosureProto(typing_extensions.TypedDict, total=False):
    endAsOfDate: GeostoreDateTimeProto
    endDate: GeostoreDateTimeProto
    startAsOfDate: GeostoreDateTimeProto
    startDate: GeostoreDateTimeProto

@typing.type_check_only
class GeostoreTextAffixProto(typing_extensions.TypedDict, total=False):
    language: str
    prefix: str
    suffix: str

@typing.type_check_only
class GeostoreThreeDimensionalModelProto(typing_extensions.TypedDict, total=False):
    pointIndices: _list[int]
    points: _list[GeostorePointWithHeightProto]

@typing.type_check_only
class GeostoreTimeBasedRateProto(typing_extensions.TypedDict, total=False):
    durationBasedRate: _list[GeostoreDurationBasedRateProto]
    taxIncluded: bool
    validEndWithin: GeostoreTimeScheduleProto
    validStartWithin: GeostoreTimeScheduleProto

@typing.type_check_only
class GeostoreTimeComponentProto(typing_extensions.TypedDict, total=False):
    componentType: typing_extensions.Literal[
        "COMPONENT_TYPE_POSITIVE", "COMPONENT_TYPE_MISSING_DATA"
    ]
    interval: _list[GeostoreTimeIntervalProto]

@typing.type_check_only
class GeostoreTimeEndpointProto(typing_extensions.TypedDict, total=False):
    day: int
    dayType: typing_extensions.Literal["DAY_OF_WEEK", "DAY_OF_MONTH", "DAY_OF_YEAR"]
    hour: int
    minute: int
    month: typing_extensions.Literal[
        "JANUARY",
        "FEBRUARY",
        "MARCH",
        "APRIL",
        "MAY",
        "JUNE",
        "JULY",
        "AUGUST",
        "SEPTEMBER",
        "OCTOBER",
        "NOVEMBER",
        "DECEMBER",
        "NEXT_JANUARY",
    ]
    second: int
    week: int
    weekType: typing_extensions.Literal["WEEK_OF_MONTH", "WEEK_OF_YEAR"]
    year: int

@typing.type_check_only
class GeostoreTimeIntervalProto(typing_extensions.TypedDict, total=False):
    begin: GeostoreTimeEndpointProto
    end: GeostoreTimeEndpointProto
    inverted: bool
    occasion: typing_extensions.Literal[
        "OCCASION_SEASON",
        "OCCASION_SEASON_WINTER",
        "OCCASION_SEASON_SUMMER",
        "OCCASION_DAYS",
        "OCCASION_DAYS_SCHOOL",
        "OCCASION_DAYS_HOLIDAY",
        "OCCASION_DAYS_PRE_HOLIDAY",
        "OCCASION_HOURS",
        "OCCASION_HOURS_PEAK",
        "OCCASION_HOURS_SCHOOL",
        "OCCASION_HOURS_MARKET",
        "OCCASION_HOURS_BUSINESS",
        "OCCASION_HOURS_DUSK_TO_DAWN",
        "OCCASION_HOURS_HIGH_TIDE",
        "OCCASION_CONDITIONS",
        "OCCASION_CONDITIONS_HIGH_WATER",
        "OCCASION_CONDITIONS_ADVERSE",
        "OCCASION_CONDITIONS_ADVERSE_RAIN",
        "OCCASION_CONDITIONS_ADVERSE_WET",
        "OCCASION_CONDITIONS_ADVERSE_FOG",
        "OCCASION_CONDITIONS_WINTERY",
        "OCCASION_CONDITIONS_WINTERY_AVALANCHE",
        "OCCASION_CONDITIONS_WINTERY_SNOW",
        "OCCASION_CONDITIONS_WINTERY_ICE",
        "OCCASION_CONDITIONS_EVENT",
        "OCCASION_CONDITIONS_POLLUTION",
        "OCCASION_CONDITIONS_LOW_WATER",
        "OCCASION_UNDEFINED",
        "OCCASION_UNDEFINED_REGULAR",
        "OCCASION_UNDEFINED_SELDOM",
    ]
    type: typing_extensions.Literal["TYPE_OCCASION", "TYPE_RANGE"]

@typing.type_check_only
class GeostoreTimeScheduleProto(typing_extensions.TypedDict, total=False):
    component: _list[GeostoreTimeComponentProto]

@typing.type_check_only
class GeostoreTimezoneProto(typing_extensions.TypedDict, total=False):
    id: str
    metadata: GeostoreFieldMetadataProto

@typing.type_check_only
class GeostoreTollClusterProto(typing_extensions.TypedDict, total=False):
    intersection: _list[GeostoreFeatureIdProto]

@typing.type_check_only
class GeostoreTrackProto(typing_extensions.TypedDict, total=False):
    index: int
    pose: _list[GeostorePoseProto]

@typing.type_check_only
class GeostoreTransitLineProto(typing_extensions.TypedDict, total=False):
    agency: _list[GeostoreFeatureIdProto]
    labelBackgroundColor: int
    labelTextColor: int
    stations: _list[GeostoreFeatureIdProto]
    vehicleType: typing_extensions.Literal[
        "VEHICLE_TYPE_ANY",
        "VEHICLE_TYPE_RAIL",
        "VEHICLE_TYPE_METRO_RAIL",
        "VEHICLE_TYPE_SUBWAY",
        "VEHICLE_TYPE_TRAM",
        "VEHICLE_TYPE_MONORAIL",
        "VEHICLE_TYPE_HEAVY_RAIL",
        "VEHICLE_TYPE_COMMUTER_TRAIN",
        "VEHICLE_TYPE_HIGH_SPEED_TRAIN",
        "VEHICLE_TYPE_LONG_DISTANCE_TRAIN",
        "VEHICLE_TYPE_BUS",
        "VEHICLE_TYPE_INTERCITY_BUS",
        "VEHICLE_TYPE_TROLLEYBUS",
        "VEHICLE_TYPE_SHARE_TAXI",
        "VEHICLE_TYPE_FERRY",
        "VEHICLE_TYPE_CABLE_CAR",
        "VEHICLE_TYPE_GONDOLA_LIFT",
        "VEHICLE_TYPE_FUNICULAR",
        "VEHICLE_TYPE_SPECIAL",
        "VEHICLE_TYPE_HORSE_CARRIAGE",
        "VEHICLE_TYPE_AIRPLANE",
    ]

@typing.type_check_only
class GeostoreTransitLineVariantProto(typing_extensions.TypedDict, total=False):
    lineConcept: GeostoreFeatureIdProto
    stops: _list[GeostoreServicedStopProto]

@typing.type_check_only
class GeostoreTransitStationProto(typing_extensions.TypedDict, total=False):
    agencyAssociations: _list[GeostoreTransitStationProtoTransitAgencyAssociationProto]

@typing.type_check_only
class GeostoreTransitStationProtoTransitAgencyAssociationProto(
    typing_extensions.TypedDict, total=False
):
    agency: GeostoreFeatureIdProto
    stationCode: str

@typing.type_check_only
class GeostoreTrustSignalsProto(typing_extensions.TypedDict, total=False):
    sourceTrust: GeostoreSourceTrustProto

@typing.type_check_only
class GeostoreUnlimitedSpeedProto(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class GeostoreUrlListProto(typing_extensions.TypedDict, total=False):
    url: _list[GeostoreUrlProto]

@typing.type_check_only
class GeostoreUrlProto(typing_extensions.TypedDict, total=False):
    language: str
    metadata: GeostoreFieldMetadataProto
    pagerank: int
    url: str

@typing.type_check_only
class GeostoreUserProto(typing_extensions.TypedDict, total=False):
    encryptedGaiaId: str
    encryptionKeyName: str
    keystoreConfigId: int
    username: str

@typing.type_check_only
class GeostoreVariableSpeedProto(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class GeostoreVehicleAttributeFilterProto(typing_extensions.TypedDict, total=False):
    axleCount: _list[GeostoreCountComparisonProto]
    hasTrailer: bool
    hazardousGoods: _list[
        typing_extensions.Literal[
            "HAZARDOUS_GOODS_TYPE_UNSPECIFIED",
            "EXPLOSIVES",
            "GASES",
            "FLAMMABLE",
            "COMBUSTIBLE",
            "ORGANIC",
            "POISON",
            "RADIOACTIVE",
            "CORROSIVE",
            "ASPIRATION_HAZARD",
            "ENVIRONMENTAL_HAZARD",
            "OTHER",
        ]
    ]
    numTrailers: _list[GeostoreCountComparisonProto]
    trailerLength: _list[GeostoreDimensionComparisonProto]
    vehicleHeight: _list[GeostoreDimensionComparisonProto]
    vehicleLength: _list[GeostoreDimensionComparisonProto]
    vehicleWeight: _list[GeostoreWeightComparisonProto]
    vehicleWidth: _list[GeostoreDimensionComparisonProto]

@typing.type_check_only
class GeostoreVerticalOrderingProto(typing_extensions.TypedDict, total=False):
    level: float

@typing.type_check_only
class GeostoreWeightComparisonProto(typing_extensions.TypedDict, total=False):
    comparison: typing_extensions.Literal[
        "COMPARISONOPERATOR_UNKNOWN", "LESS_THAN", "GREATER_THAN"
    ]
    comparisonOperator: typing_extensions.Literal[
        "UNSPECIFIED",
        "EQUAL",
        "LESS_THAN",
        "LESS_THAN_OR_EQUAL",
        "GREATER_THAN",
        "GREATER_THAN_OR_EQUAL",
    ]
    weightWithUnit: GeostoreWeightProto

@typing.type_check_only
class GeostoreWeightProto(typing_extensions.TypedDict, total=False):
    unit: typing_extensions.Literal[
        "UNIT_UNKNOWN", "METRIC_TON", "LONG_TON", "SHORT_TON", "POUND", "KILOGRAM"
    ]
    weight: float

@typing.type_check_only
class GoodocAnchorLabel(typing_extensions.TypedDict, total=False):
    Anchor: str
    anchorScope: int

@typing.type_check_only
class GoodocBoundingBox(typing_extensions.TypedDict, total=False):
    Height: int
    Label: int
    Left: int
    Top: int
    Width: int

@typing.type_check_only
class GoodocBoxPartitions(typing_extensions.TypedDict, total=False):
    direction: int
    span: _list[int]

@typing.type_check_only
class GoodocBreakLabel(typing_extensions.TypedDict, total=False):
    BreakLabelType: int
    isPrefix: bool

@typing.type_check_only
class GoodocCharLabel(typing_extensions.TypedDict, total=False):
    BaseLine: int
    CharacterHeight: int
    Color: int
    Confidence: int
    FontId: int
    FontSize: int
    FontSizeFloat: float
    FontType: int
    HasUncertainHeight: bool
    HorizontalScale: int
    IsBold: bool
    IsItalic: bool
    IsSmallCaps: bool
    IsStrikeout: bool
    IsSubscript: bool
    IsSuperscript: bool
    IsSuspicious: bool
    IsUnderlined: bool
    NotOcrablePerQA: bool
    Penalty: int
    SerifProbability: int

@typing.type_check_only
class GoodocDocument(typing_extensions.TypedDict, total=False):
    EditingHistory: _list[str]
    LogicalEntity: _list[str]
    LogicalEntityMessageName: _list[str]
    SubDocuments: _list[GoodocDocument]
    header: GoodocDocumentHeader
    page: _list[GoodocDocumentPage]

@typing.type_check_only
class GoodocDocumentHeader(typing_extensions.TypedDict, total=False):
    OcrEngineId: str
    OcrEngineVersion: str
    font: _list[GoodocDocumentHeaderFont]

@typing.type_check_only
class GoodocDocumentHeaderFont(typing_extensions.TypedDict, total=False):
    FontId: int
    FontName: str

@typing.type_check_only
class GoodocDocumentPage(typing_extensions.TypedDict, total=False):
    GarbageDetectorChangeList: int
    GarbageDetectorWasProduction: bool
    Height: int
    HorizontalDpi: int
    Label: GoodocLabel
    PornScore: float
    TextConfidence: int
    VerticalDpi: int
    Width: int
    block: _list[GoodocDocumentPageBlock]
    mergedpageinfo: _list[GoodocDocumentPageMergedPageInfo]
    postOcrConfidence: bool
    stats: GoodocSummaryStats

@typing.type_check_only
class GoodocDocumentPageBlock(typing_extensions.TypedDict, total=False):
    BlockType: int
    Box: GoodocBoundingBox
    Label: GoodocLabel
    OrientationLabel: GoodocOrientationLabel
    Paragraph: _list[GoodocParagraph]
    RotatedBox: GoodocRotatedBoundingBox
    TextConfidence: int

@typing.type_check_only
class GoodocDocumentPageMergedPageInfo(typing_extensions.TypedDict, total=False):
    OcrEngineId: str
    OcrEngineVersion: str

@typing.type_check_only
class GoodocFontSizeStats(typing_extensions.TypedDict, total=False):
    fontId: int
    fontSize: int
    medianHeight: int
    medianLineHeight: int
    medianLineSpace: int
    medianLineSpan: int
    medianWidth: int
    numLineSpaces: int
    numLines: int
    numSymbols: int

@typing.type_check_only
class GoodocLabel(typing_extensions.TypedDict, total=False):
    AnchorLabel: _list[GoodocAnchorLabel]
    BreakLabel: GoodocBreakLabel
    CharLabel: GoodocCharLabel
    LanguageLabel: _list[GoodocLanguageLabel]
    SemanticLabel: GoodocSemanticLabel

@typing.type_check_only
class GoodocLanguageCombinationLanguage(typing_extensions.TypedDict, total=False):
    bcp47Tag: str
    weight: float

@typing.type_check_only
class GoodocLanguageLabel(typing_extensions.TypedDict, total=False):
    ClosestLanguageId: int
    Confidence: int
    LanguageCode: str

@typing.type_check_only
class GoodocLogicalEntity(typing_extensions.TypedDict, total=False):
    Metadata: str
    link: _list[GoodocLogicalEntityLink]

@typing.type_check_only
class GoodocLogicalEntityLink(typing_extensions.TypedDict, total=False):
    Anchor: str
    BlockId: int
    DocId: int
    PageId: int
    ParagraphId: int
    RouteId: int
    SymbolId: int
    Url: str
    WordId: int

@typing.type_check_only
class GoodocOrdinal(typing_extensions.TypedDict, total=False):
    implicit: typing_extensions.Literal["UNKNOWN_IMPLICIT", "IMPLICIT", "EXPLICIT"]
    sectionStringValue: str
    sectionValue: int
    sectionValueType: typing_extensions.Literal[
        "UNKNOWN_VALUE_TYPE",
        "LEGACY_PRE_VALUE",
        "ROMAN",
        "ASCII",
        "ALPHA",
        "LEGACY_POST_VALUE",
        "UNDEFINED_VALUE_TYPE",
        "CHINESE",
        "JAPANESE",
        "KOREAN",
        "ARABIC_ARABIC",
    ]
    stringValue: str
    value: int
    valueDelta: typing_extensions.Literal["DELTA_HALF", "DELTA_ONE", "DELTA_TWO"]
    valueType: typing_extensions.Literal[
        "UNKNOWN_VALUE_TYPE",
        "LEGACY_PRE_VALUE",
        "ROMAN",
        "ASCII",
        "ALPHA",
        "LEGACY_POST_VALUE",
        "UNDEFINED_VALUE_TYPE",
        "CHINESE",
        "JAPANESE",
        "KOREAN",
        "ARABIC_ARABIC",
    ]

@typing.type_check_only
class GoodocOrientationLabel(typing_extensions.TypedDict, total=False):
    deskewAngle: float
    mirrored: bool
    orientation: typing_extensions.Literal[
        "ORIENTATION_PAGE_UP",
        "ORIENTATION_PAGE_RIGHT",
        "ORIENTATION_PAGE_DOWN",
        "ORIENTATION_PAGE_LEFT",
    ]
    textlineOrder: typing_extensions.Literal[
        "TEXTLINE_ORDER_LEFT_TO_RIGHT",
        "TEXTLINE_ORDER_RIGHT_TO_LEFT",
        "TEXTLINE_ORDER_TOP_TO_BOTTOM",
    ]
    writingDirection: typing_extensions.Literal[
        "WRITING_DIRECTION_LEFT_TO_RIGHT",
        "WRITING_DIRECTION_RIGHT_TO_LEFT",
        "WRITING_DIRECTION_TOP_TO_BOTTOM",
    ]

@typing.type_check_only
class GoodocOverrides(typing_extensions.TypedDict, total=False):
    blockImagination: typing_extensions.Literal[
        "LEAVE_ALONE", "FORCE_TRUE", "FORCE_FALSE"
    ]
    doNotExpandGraphicBox: bool
    fullPageAsImage: typing_extensions.Literal[
        "LEAVE_ALONE", "FORCE_TRUE", "FORCE_FALSE"
    ]
    fullPageLineated: typing_extensions.Literal[
        "LEAVE_ALONE", "FORCE_TRUE", "FORCE_FALSE"
    ]
    fullPageSkipped: typing_extensions.Literal[
        "LEAVE_ALONE", "FORCE_TRUE", "FORCE_FALSE"
    ]
    needNotSuppressPhoto: bool
    pageBreakBefore: typing_extensions.Literal[
        "LEAVE_ALONE", "FORCE_TRUE", "FORCE_FALSE"
    ]
    style: _list[GoodocOverridesStyle]
    wordHtml: str

@typing.type_check_only
class GoodocOverridesStyle(typing_extensions.TypedDict, total=False):
    name: str
    value: str

@typing.type_check_only
class GoodocParagraph(typing_extensions.TypedDict, total=False):
    Box: GoodocBoundingBox
    FirstLineIndent: int
    Label: GoodocLabel
    LeftIndent: int
    LineSpacing: int
    OrientationLabel: GoodocOrientationLabel
    RightIndent: int
    RotatedBox: GoodocRotatedBoundingBox
    SpaceAfter: int
    SpaceBefore: int
    SubsumedParagraphProperties: _list[GoodocParagraph]
    TextConfidence: int
    Width: int
    alignment: int
    droppedcap: GoodocParagraphDroppedCap
    route: _list[GoodocParagraphRoute]

@typing.type_check_only
class GoodocParagraphDroppedCap(typing_extensions.TypedDict, total=False):
    Box: GoodocBoundingBox
    LettersCount: int

@typing.type_check_only
class GoodocParagraphRoute(typing_extensions.TypedDict, total=False):
    EndPoint: GoodocRoutePoint
    StartPoint: GoodocRoutePoint
    Weight: int
    Word: _list[GoodocWord]

@typing.type_check_only
class GoodocRotatedBoundingBox(typing_extensions.TypedDict, total=False):
    Angle: float
    Height: int
    Left: int
    Top: int
    Width: int

@typing.type_check_only
class GoodocRoutePoint(typing_extensions.TypedDict, total=False):
    RouteIndex: int
    WordIndex: int

@typing.type_check_only
class GoodocSemanticLabel(typing_extensions.TypedDict, total=False):
    AlternateText: str
    Attribute: _list[str]
    ChapterStart: bool
    CleanupAnnotation: _list[int]
    ContinuesFromPreviousPage: bool
    ContinuesFromPreviousPageHyphenated: bool
    ContinuesOnNextPage: bool
    EndOfSpanningLabel: GoodocLogicalEntity
    ExperimentalData: Proto2BridgeMessageSet
    Flow: str
    ModificationRecord: str
    PageNumberOrdinal: GoodocOrdinal
    appearance: int
    columndetails: GoodocSemanticLabelColumnDetails
    contentlink: GoodocSemanticLabelContentLink
    editcorrectioncandidate: _list[GoodocSemanticLabelEditCorrectionCandidate]
    overrides: GoodocOverrides
    snippetfilter: _list[GoodocSemanticLabelSnippetFilter]
    tablecelldetails: GoodocSemanticLabelTableCellDetails
    tabledetails: GoodocSemanticLabelTableDetails

@typing.type_check_only
class GoodocSemanticLabelColumnDetails(typing_extensions.TypedDict, total=False):
    Column: int
    Columns: int

@typing.type_check_only
class GoodocSemanticLabelContentLink(typing_extensions.TypedDict, total=False):
    UrlTarget: str
    citationtarget: GoodocSemanticLabelContentLinkCitationTarget
    involumetarget: GoodocSemanticLabelContentLinkInVolumeTarget

@typing.type_check_only
class GoodocSemanticLabelContentLinkCitationTarget(
    typing_extensions.TypedDict, total=False
):
    Authors: str
    BibKey: str
    Confidence: float
    Title: str
    Year: int

@typing.type_check_only
class GoodocSemanticLabelContentLinkInVolumeTarget(
    typing_extensions.TypedDict, total=False
):
    Confidence: float
    LogicalEntity: GoodocLogicalEntity

@typing.type_check_only
class GoodocSemanticLabelEditCorrectionCandidate(
    typing_extensions.TypedDict, total=False
):
    EditedWord: str
    Probability: float

@typing.type_check_only
class GoodocSemanticLabelSnippetFilter(typing_extensions.TypedDict, total=False):
    badwordFraction: float
    windowSize: int

@typing.type_check_only
class GoodocSemanticLabelTableCellDetails(typing_extensions.TypedDict, total=False):
    Column: int
    ColumnSpan: int
    Row: int
    RowSpan: int

@typing.type_check_only
class GoodocSemanticLabelTableDetails(typing_extensions.TypedDict, total=False):
    Columns: int
    Rows: int

@typing.type_check_only
class GoodocSummaryStats(typing_extensions.TypedDict, total=False):
    estimatedFontSizes: bool
    fontSizeHistogram: _list[GoodocFontSizeStats]
    meanSymbolsPerBlock: int
    meanSymbolsPerLine: int
    meanSymbolsPerParagraph: int
    meanSymbolsPerWord: int
    meanWordsPerBlock: int
    meanWordsPerLine: int
    meanWordsPerParagraph: int
    medianBlockSpace: int
    medianEvenPrintedBox: GoodocBoundingBox
    medianFullEvenPrintedBox: GoodocBoundingBox
    medianFullOddPrintedBox: GoodocBoundingBox
    medianFullPrintedBox: GoodocBoundingBox
    medianHeight: int
    medianHorizontalDpi: int
    medianLineHeight: int
    medianLineSpace: int
    medianLineSpan: int
    medianOddPrintedBox: GoodocBoundingBox
    medianParagraphIndent: int
    medianParagraphSpace: int
    medianPrintedBox: GoodocBoundingBox
    medianSymbolsPerBlock: int
    medianSymbolsPerLine: int
    medianSymbolsPerParagraph: int
    medianSymbolsPerWord: int
    medianVerticalDpi: int
    medianWidth: int
    medianWordsPerBlock: int
    medianWordsPerLine: int
    medianWordsPerParagraph: int
    numBlockSpaces: int
    numBlocks: int
    numLineSpaces: int
    numLines: int
    numNonGraphicBlocks: int
    numPages: int
    numParagraphSpaces: int
    numParagraphs: int
    numSymbols: int
    numWords: int

@typing.type_check_only
class GoodocSymbol(typing_extensions.TypedDict, total=False):
    Box: GoodocBoundingBox
    Code: int
    Label: GoodocLabel
    RotatedBox: GoodocRotatedBoundingBox
    symbolvariant: _list[GoodocSymbolSymbolVariant]

@typing.type_check_only
class GoodocSymbolSymbolVariant(typing_extensions.TypedDict, total=False):
    Code: int
    Confidence: int

@typing.type_check_only
class GoodocWord(typing_extensions.TypedDict, total=False):
    Baseline: int
    Box: GoodocBoundingBox
    Capline: int
    CompactSymbolBoxes: GoodocBoxPartitions
    Confidence: int
    IsFromDictionary: bool
    IsIdentifier: bool
    IsLastInSentence: bool
    IsNumeric: bool
    Label: GoodocLabel
    Penalty: int
    RotatedBox: GoodocRotatedBoundingBox
    Symbol: _list[GoodocSymbol]
    alternates: GoodocWordAlternates
    text: str
    writingDirection: typing_extensions.Literal[
        "WRITING_DIRECTION_LEFT_TO_RIGHT",
        "WRITING_DIRECTION_RIGHT_TO_LEFT",
        "WRITING_DIRECTION_TOP_TO_BOTTOM",
    ]

@typing.type_check_only
class GoodocWordAlternates(typing_extensions.TypedDict, total=False):
    ErrorProbability: int
    alternate: _list[GoodocWordAlternatesAlternate]

@typing.type_check_only
class GoodocWordAlternatesAlternate(typing_extensions.TypedDict, total=False):
    OcrEngineId: str
    OcrEngineVersion: str
    Word: GoodocWord

@typing.type_check_only
class GoogleApiServiceconsumermanagementV1BillingConfig(
    typing_extensions.TypedDict, total=False
):
    billingAccount: str

@typing.type_check_only
class GoogleApiServiceconsumermanagementV1PolicyBinding(
    typing_extensions.TypedDict, total=False
):
    members: _list[str]
    role: str

@typing.type_check_only
class GoogleAssistantAccessoryV1AudioOutConfig(
    typing_extensions.TypedDict, total=False
):
    audioMode: typing_extensions.Literal[
        "AUDIO_MODE_UNSPECIFIED", "MUTED", "SILENT", "PLAYING"
    ]
    audioRoutingMode: typing_extensions.Literal[
        "AUDIO_ROUTING_MODE_UNSPECIFIED", "BLUETOOTH_HEADPHONES"
    ]
    encoding: typing_extensions.Literal[
        "ENCODING_UNSPECIFIED",
        "LINEAR16",
        "MP3",
        "OGG_OPUS",
        "MULAW",
        "OPUS_CONTAINERLESS",
    ]
    preferredBitrateBps: int

@typing.type_check_only
class GoogleAssistantAccessoryV1DeviceConfig(typing_extensions.TypedDict, total=False):
    deviceModelCapabilitiesOverride: GoogleAssistantEmbeddedV1DeviceModelCapabilitiesOverride
    heterodyneToken: str
    surfaceIdentity: GoogleAssistantEmbeddedV1SurfaceIdentity

@typing.type_check_only
class GoogleAssistantAccessoryV1DeviceState(typing_extensions.TypedDict, total=False):
    alarmState: GoogleAssistantEmbeddedV1Alarms
    contextParams: str
    deviceTime: str
    deviceTimeZone: GoogleTypeTimeZone
    doNotDisturb: bool
    fitnessActivitiesState: GoogleAssistantEmbeddedV1FitnessActivities
    installedApps: GoogleAssistantAccessoryV1DeviceStateInstalledAppsState
    installedAppsZlib: str
    timerState: GoogleAssistantEmbeddedV1Timers
    unavailableSettings: _list[
        typing_extensions.Literal[
            "UNSPECIFIED",
            "ABOUT_ME",
            "ACCESSIBILITY",
            "ACTIVE_EDGE",
            "ACTIVE_EDGE_SENSITIVITY",
            "ADAPTIVE_BATTERY",
            "ADAPTIVE_BRIGHTNESS",
            "ADAPTIVE_CHARGING",
            "ADAPTIVE_CONNECTIVITY",
            "ADAPTIVE_SOUND",
            "ADD_ACCOUNT",
            "ADD_BLUETOOTH_DEVICE",
            "ADD_DEVICE",
            "ADD_FINGERPRINT",
            "ADS_TRACKING",
            "AIRPLANE_MODE",
            "ALARM_VOLUME",
            "ALARM_SOUND",
            "ALLOW_MULTIPLE_USERS",
            "AMBIENT_DISPLAY_ALWAYS_ON",
            "AMBIENT_DISPLAY_NEW_NOTIFICATION",
            "ANDROID_AUTO",
            "ANDROID_VERSION",
            "APP_BATTERY_USAGE",
            "APP_DATA_USAGE",
            "APP_DETAILS",
            "APP_SHORTCUT",
            "APPS_NOTIFICATIONS",
            "APPS_STORAGE",
            "ASSISTANT_ACCOUNT",
            "ASSISTANT_FACE_MATCH",
            "ASSISTANT_LANGUAGE",
            "ASSISTANT_VOICE_MATCH",
            "AUTO_ROTATE",
            "AUTO_ROTATE_FACE_DETECTION",
            "BACKUP",
            "BATTERY_HEALTH",
            "BATTERY_LEVEL",
            "BATTERY_LOW",
            "BATTERY_PERCENTAGE",
            "BATTERY_PRESENT",
            "BATTERY_SAVER",
            "BATTERY_SAVER_SCHEDULE",
            "BATTERY_SHARE",
            "BATTERY_USAGE",
            "BIOMETRIC",
            "BLUETOOTH",
            "BLUETOOTH_NAME",
            "BLUETOOTH_ADDRESS",
            "BLUETOOTH_SETTINGS",
            "BRIGHTNESS_LEVEL",
            "BUBBLES",
            "CALL_VOLUME",
            "CAMERA_DOUBLE_TWIST",
            "CAST",
            "CAR_CRASH_DETECTION",
            "COLOR_INVERSION",
            "COLOR_CORRECTION",
            "CONVERSATIONS",
            "CHARGING_SOUNDS_AND_VIBRATION",
            "CHARGING_STATE",
            "CONNECTED_DEVICES",
            "CONTACTLESS_PAYMENTS",
            "DATA_ROAMING",
            "DATA_SAVER",
            "DATA_USAGE",
            "DATA_LIMIT",
            "DATA_LIMIT_LEVEL",
            "DATA_WARNING",
            "DATA_WARNING_LEVEL",
            "DEFAULT_ALARM_SOUND",
            "DEFAULT_NOTIFICATION_SOUND",
            "DEFAULT_APPS",
            "DEVELOPER_OPTIONS",
            "DEVICE_ASSISTANT_APP",
            "DEVICE_NAME",
            "DISPLAY_OVER_OTHER_APPS",
            "DISPLAY_SIZE",
            "DO_NOT_DISTURB",
            "DO_NOT_DISTURB_MESSAGES",
            "DO_NOT_DISTURB_CALLS",
            "DO_NOT_DISTURB_ALARMS",
            "DO_NOT_DISTURB_SCHEDULES",
            "DOUBLE_TAP_CHECK_PHONE",
            "DRIVING_MODE",
            "EARTHQUAKE_ALERTS",
            "EMERGENCY",
            "EMERGENCY_ALERTS",
            "EMERGENCY_CONTACTS",
            "EMERGENCY_INFORMATION",
            "ETHERNET_TETHERING",
            "EXTRA_DIM",
            "EXTREME_BATTERY_SAVER",
            "FACTORY_RESET",
            "FIND_MY_DEVICE",
            "FLASHLIGHT",
            "FOCUS_MODE",
            "FONT_SIZE",
            "FREE_UP_SPACE",
            "FINGERPRINT_MANAGER",
            "GESTURES",
            "HAPTIC_FEEDBACK_VIBRATION",
            "HARD_KEYBOARD",
            "HEADS_UP",
            "HIGH_REFRESH_RATE",
            "HOT_SPOT",
            "HOTSPOT_TETHERING",
            "HOT_WORD",
            "HUB_MODE",
            "IP_ADDRESS",
            "IMPROVE_LOCATION_ACCURACY",
            "JUMP_TO_CAMERA",
            "KEYBOARD_SHORTCUTS",
            "LIFT_CHECK_PHONE",
            "LIVE_TRANSLATE",
            "LOCATION",
            "LOCATION_HISTORY",
            "LOCATION_BLUETOOTH_SCANNING",
            "LOCATION_WIFI_SCANNING",
            "LOCK_SCREEN",
            "LOCK_SCREEN_DEVICE_CONTROLS",
            "LOCK_SCREEN_WALLET",
            "MAC_ADDRESS",
            "MAGNIFICATION",
            "MAGNIFY_BUTTON",
            "MAGNIFY_TRIPLE_TAP",
            "MANIFY_BUTTON",
            "MANIFY_TRIPLE_TAP",
            "MEDIA",
            "MEDIA_VOLUME",
            "MICROPHONE_ACCESS",
            "MOBILE",
            "MOBILE_DATA",
            "MUSIC",
            "MUTE_MODE",
            "NETWORK",
            "NETWORK_RESET",
            "NFC",
            "NIGHT_LIGHT_INTENSITY",
            "NIGHT_LIGHT_SWITCH",
            "NIGHT_MODE",
            "NOTIFICATION_BADGE",
            "NOTIFICATION_SOUND",
            "NOTIFICATION_ON_SCREEN",
            "NOTIFICATION_HISTORY",
            "NOTIFY_FOR_PUBLIC_NETWORKS",
            "ONEHANDED_MODE",
            "OS_VERSION",
            "PASSWORD",
            "PERMISSION_MANAGER",
            "PERMISSION_USAGE",
            "PERSONALIZATION",
            "PRINTING",
            "PHONE_NUMBER",
            "PICTURE_IN_PICTURE",
            "POINTER_SPEED",
            "POWER_MENU",
            "REMINDERS",
            "REQUIRE_DEVICE_UNLOCK_FOR_NFC",
            "RINGTONE",
            "RING_VOLUME",
            "NEARBY_DEVICES_SCANNING",
            "NEARBY_SHARE",
            "SCREEN_LOCKING_SOUND",
            "SCREEN_MAGNIFICATION",
            "SCREEN_TIMEOUT",
            "SCREEN_LOCK",
            "SCREEN_SAVER",
            "SELECT_TO_SPEAK",
            "SET_TIME_AUTOMATICALLY",
            "SET_TIME_ZONE_AUTOMATICALLY",
            "SETTINGS",
            "SIM",
            "SIM_MANAGER",
            "SPEECH_RATE",
            "STORAGE_USAGE",
            "SWIPE_FOR_NOTIFICATION",
            "SWITCH_ACCESS",
            "SYSTEM_UPDATE",
            "SYSTEM_UPDATES",
            "SYSTEM_NAVIGATION",
            "SYSTEM_NAVIGATION_GESTURES",
            "SYSTEM_NAVIGATION_BUTTONS",
            "TALKBACK_PASSWORDS",
            "TEXT_TO_SPEECH",
            "TIME_ZONE",
            "UNUSED_APPS",
            "USB",
            "USB_TETHERING",
            "VERBOSE_TTS",
            "VIBRATE",
            "VIBRATION",
            "VIBRATION_MODE",
            "VOICE",
            "VOLUME_LEVEL",
            "WAKE_SCREEN_FOR_NOTIFICATIONS",
            "WALLPAPERS",
            "WEBVIEW",
            "WIFI",
            "WIFI_ADD_NETWORK",
            "WIFI_ADD_NETWORK_QR_CODE",
            "WIFI_CALLING",
            "WIFI_HOTSPOT",
            "ACCESSIBILITY_SELECT_TO_SPEAK",
            "CRISIS_ALERTS",
            "REGULATORY_LABELS",
            "SEND_FEEDBACK",
            "OS_BUILD_NUMBER",
            "ACCESSIBILITY_SHORTCUTS",
            "ACCESSIBILITY_MENU",
            "ACCESSIBILITY_SOUND_AMPLIFIER",
            "ACCESSIBILITY_LIVE_TRANSCRIBE",
            "ACCESSIBILITY_SOUND_NOTIFICATIONS",
            "ACCESSIBILITY_TALKBACK",
            "ACCESSIBILITY_TIMEOUT",
            "CAMERA_SETTINGS",
            "BATTERY_SAVER_TOGGLE",
            "COVID_NOTIFICATIONS",
            "APP_LOCATION",
            "LOCATION_SERVICES",
            "PRIVATE_DNS",
            "UNRESTRICTED_DATA",
            "PREFERRED_NETWORK",
            "NETWORK_PREFERENCES",
            "PASSWORDS_AND_ACCOUNTS",
            "PRIVACY_DASHBOARD",
            "MORE_SECURITY",
            "APP_PINNING",
            "CONFIRM_SIM_DELETION",
            "ENCRYPT_PHONE",
            "FACE_UNLOCK",
            "INSTALL_UNKNOWN_APPS",
            "NOW_PLAYING",
            "STAY_AWAKE",
            "ASSISTANT_VOICE",
            "RESET_BLUETOOTH_WIFI",
            "DEFAULT_PHONE_APP",
            "GOOGLE_ACCOUNT",
            "ACCESSIBILITY_CAPTION_SIZE_AND_STYLE",
            "ACCESSIBILITY_CAPTION_STYLE",
            "ACCESSIBILITY_CAPTION_TEXT",
            "ACCESSIBILITY_CAPTION_PREFERENCES",
            "ACCESSIBILITY_COLOR_AND_MOTION",
            "ACCESSIBILITY_BOLD_TEXT",
            "LIVE_CAPTION",
            "POWER_BUTTON_ENDS_CALL",
            "TOUCH_AND_HOLD_DELAY",
            "ACCESSIBILITY_VOICE_ACCESS",
            "SMS_PERMISSIONS",
            "SPECIAL_APP_ACCESS",
            "DARK_THEME_SCHEDULE",
            "LOCK_SCREEN_TEXT",
            "NIGHT_LIGHT_SCHEDULE",
            "AUTOFILL",
            "USAGE_AND_DIAGNOSTICS",
            "SENSITIVE_NOTIFICATIONS",
            "ENCRYPTION_AND_CREDENTIALS",
            "SPACIAL_AUDIO",
            "RESET_OPTIONS",
            "QUICK_TAP",
            "TIPS_AND_SUPPORT",
            "SCREEN_ATTENTION",
            "BLUETOOTH_TETHERING",
            "ALL_APPS",
            "EXTEND_UNLOCK",
            "CLEAR_CALLING",
            "GOOGLE_SETTINGS",
            "APP_LANGUAGES",
            "SIM_STATUS",
            "MICROPHONE_PERMISSIONS",
            "GOOGLE_PLAY_UPDATE",
            "ADD_GOOGLE_ACCOUNT",
            "ASSISTANT_SPOKEN_NOTIFICATIONS",
            "ABOUT_PHONE",
            "ACCOUNTS",
            "APPLICATION",
            "ASSISTANT",
            "AUDIO",
            "BATTERY",
            "BELL_SCHEDULE",
            "CONTINUED_CONVERSATION",
            "DATE_TIME",
            "DARK_THEME",
            "DEVICE_INFO",
            "DICTIONARY",
            "DIGITAL_WELLBEING",
            "DISPLAY",
            "LANGUAGE",
            "NIGHT_LIGHT",
            "NOTIFICATION",
            "NOTIFICATION_VOLUME",
            "PHONE_RINGTONE",
            "PRIVACY",
            "ROAMING",
            "ROUTINES",
            "SEARCH",
            "SECURITY",
            "SOUND",
            "SPELL_CHECKER",
            "SYSTEM",
            "STORAGE",
            "VPN",
            "AUTOCLICK",
            "CARET_HIGHLIGHT",
            "CHROMEVOX",
            "CURSOR_HIGHLIGHT",
            "DOCKED_MAGNIFIER",
            "FOCUS_HIGHLIGHT",
            "FULLSCREEN_MAGNIFIER",
            "HIGH_CONTRAST_MODE",
            "LARGE_CURSOR",
            "MONO_AUDIO",
            "STICKY_KEYS",
            "TAP_DRAGGING",
            "VIRTUAL_KEYBOARD",
            "WEARABLE_AMBIENT",
            "WEARABLE_NOISE_CANCELLATION",
            "WEARABLE_TOUCH_CONTROLS",
            "RAISE_TO_TALK",
            "BEDTIME_MODE",
            "THEATER_MODE",
            "TOUCH_LOCK",
            "PRESS_AND_HOLD",
            "WATCH_FACE",
            "NOTIFICATION_ANNOUNCEMENT",
        ]
    ]

@typing.type_check_only
class GoogleAssistantAccessoryV1DeviceStateInstalledAppsState(
    typing_extensions.TypedDict, total=False
):
    apps: _list[AssistantApiCoreTypesProvider]

@typing.type_check_only
class GoogleAssistantAccessoryV1ResponseConfig(
    typing_extensions.TypedDict, total=False
):
    audioOutConfig: GoogleAssistantAccessoryV1AudioOutConfig
    deviceConfig: GoogleAssistantAccessoryV1DeviceConfig
    deviceInteraction: str
    deviceState: GoogleAssistantAccessoryV1DeviceState
    initialAudioBytes: int
    isNewConversation: bool
    outputSampleRateHz: int
    responseType: typing_extensions.Literal[
        "RESPONSE_TYPE_UNSPECIFIED", "TEXT", "TRANSCRIPTION"
    ]
    screenOutConfig: GoogleAssistantAccessoryV1ScreenOutConfig

@typing.type_check_only
class GoogleAssistantAccessoryV1ScreenOutConfig(
    typing_extensions.TypedDict, total=False
):
    dimensions: GoogleAssistantAccessoryV1ScreenOutConfigDimensions
    fontScaleFactor: float

@typing.type_check_only
class GoogleAssistantAccessoryV1ScreenOutConfigDimensions(
    typing_extensions.TypedDict, total=False
):
    screenDpi: float
    screenHeightPx: int
    screenShape: typing_extensions.Literal[
        "SCREEN_SHAPE_UNSPECIFIED", "SCREEN_SHAPE_OVAL", "SCREEN_SHAPE_RECT"
    ]
    screenWidthPx: int

@typing.type_check_only
class GoogleAssistantEmbeddedV1Alarm(typing_extensions.TypedDict, total=False):
    alarmId: str
    alarmSource: typing_extensions.Literal["ALARM_SOURCE_UNSPECIFIED", "PHONE", "WATCH"]
    datePattern: GoogleTypeDate
    label: str
    recurrencePattern: GoogleAssistantEmbeddedV1AlarmRecurrence
    scheduledTime: str
    status: typing_extensions.Literal[
        "ALARM_STATUS_UNSPECIFIED", "SCHEDULED", "FIRING", "SNOOZED", "DISABLED"
    ]
    timePattern: GoogleTypeTimeOfDay

@typing.type_check_only
class GoogleAssistantEmbeddedV1AlarmRecurrence(
    typing_extensions.TypedDict, total=False
):
    dayOfWeek: _list[
        typing_extensions.Literal[
            "DAY_OF_WEEK_UNSPECIFIED",
            "MONDAY",
            "TUESDAY",
            "WEDNESDAY",
            "THURSDAY",
            "FRIDAY",
            "SATURDAY",
            "SUNDAY",
        ]
    ]

@typing.type_check_only
class GoogleAssistantEmbeddedV1Alarms(typing_extensions.TypedDict, total=False):
    alarms: _list[GoogleAssistantEmbeddedV1Alarm]
    snoozeDuration: str
    stateFetchError: typing_extensions.Literal[
        "STATE_FETCH_ERROR_UNSPECIFIED",
        "STATE_FETCH_ERROR_TIMEOUT",
        "STATE_FETCH_ERROR_UNSUPPORTED",
    ]

@typing.type_check_only
class GoogleAssistantEmbeddedV1DeviceModelCapabilitiesOverride(
    typing_extensions.TypedDict, total=False
):
    deviceModelCapabilities: str
    updateMask: str

@typing.type_check_only
class GoogleAssistantEmbeddedV1FitnessActivities(
    typing_extensions.TypedDict, total=False
):
    fitnessActivities: _list[GoogleAssistantEmbeddedV1FitnessActivity]

@typing.type_check_only
class GoogleAssistantEmbeddedV1FitnessActivity(
    typing_extensions.TypedDict, total=False
):
    activityId: str
    mostRecentStartTime: str
    previouslyAccumulatedDuration: str
    state: typing_extensions.Literal["STATE_UNSPECIFIED", "ACTIVE", "PAUSED"]
    type: typing_extensions.Literal[
        "TYPE_UNSPECIFIED",
        "WALK",
        "RUN",
        "ELLIPTICAL",
        "SWIM",
        "WEIGHTS",
        "TREADMILL",
        "BIKE",
        "YOGA",
        "WORKOUT",
        "BOOT_CAMP",
        "CIRCUIT_TRAINING",
        "GOLF",
        "HIKING",
        "INTERVAL_TRAINING",
        "KICKBOXING",
        "MARTIAL_ARTS",
        "PILATES",
        "SPINNING",
        "STAIR_CLIMBING",
        "TENNIS",
        "AEROBICS",
        "CORE_TRAINING",
        "DANCING",
        "HIGH_INTENSITY_INTERVAL_TRAINING",
        "KAYAKING",
        "ROWING",
        "SKIING",
        "STANDUP_PADDLEBOARDING",
        "STRENGTH_TRAINING",
        "SNOWBOARDING",
    ]

@typing.type_check_only
class GoogleAssistantEmbeddedV1SurfaceIdentity(
    typing_extensions.TypedDict, total=False
):
    surfaceType: typing_extensions.Literal[
        "UNKNOWN_TYPE",
        "ACCL",
        "AGSA",
        "ANDROID",
        "ANDROID_AUTO",
        "ANDROID_LITE",
        "ANDROID_PHONE",
        "ANDROID_SCREENLESS",
        "ANDROID_SMART_DISPLAY",
        "ANDROID_TABLET",
        "ANDROID_THINGS",
        "ANDROID_THINGS_CUBE",
        "ANDROID_THINGS_JASPER",
        "ANDROID_TV",
        "ANDROID_WEAR",
        "ASSISTANT_KIT",
        "ASSISTANT_SDK",
        "AUTO",
        "CAST_OS",
        "CHROME_OS",
        "CHROMECAST_MANHATTAN",
        "CLOUD_DEVICE",
        "CROS",
        "FITBIT_OS_WATCH",
        "FITBIT_OS_WATCH_ANDROID",
        "FITBIT_OS_WATCH_IOS",
        "GOOGLE_HOME",
        "HEADPHONE",
        "HEADPHONE_ANDROID",
        "HEADPHONE_IOS",
        "IOPA",
        "IOS",
        "IOS_SCREENLESS",
        "IPAD",
        "IPHONE",
        "KAI_OS",
        "KAI_OS_AMA",
        "LIBASSISTANT",
        "PHONE",
        "PIXEL",
        "PIXEL5",
        "PIXEL6",
        "PIXEL7",
        "PIXEL8",
        "PIXEL_BUDS",
        "PIXEL_TABLET",
        "PIXEL_TABLET_HUB_MODE",
        "PIXEL_TABLET_PERSONAL_MODE",
        "PIXEL_WATCH",
        "SCREENLESS",
        "SMART_DISPLAY",
        "SPEAKER",
        "TABLET",
        "TELEPHONE",
        "THING",
        "WATCH",
        "WEAR_OS",
        "WEAR_OS_WATCH",
    ]
    userAgentSuffix: str

@typing.type_check_only
class GoogleAssistantEmbeddedV1Timer(typing_extensions.TypedDict, total=False):
    expireTime: str
    label: str
    originalDuration: str
    remainingDuration: str
    status: typing_extensions.Literal[
        "TIMER_STATUS_UNSPECIFIED", "RUNNING", "PAUSED", "FIRING"
    ]
    timerId: str

@typing.type_check_only
class GoogleAssistantEmbeddedV1Timers(typing_extensions.TypedDict, total=False):
    stateFetchError: typing_extensions.Literal[
        "STATE_FETCH_ERROR_UNSPECIFIED",
        "STATE_FETCH_ERROR_TIMEOUT",
        "STATE_FETCH_ERROR_UNSUPPORTED",
    ]
    timers: _list[GoogleAssistantEmbeddedV1Timer]

@typing.type_check_only
class GoogleCloudContentwarehouseV1AccessControlAction(
    typing_extensions.TypedDict, total=False
):
    operationType: typing_extensions.Literal[
        "UNKNOWN",
        "ADD_POLICY_BINDING",
        "REMOVE_POLICY_BINDING",
        "REPLACE_POLICY_BINDING",
    ]
    policy: GoogleIamV1Policy

@typing.type_check_only
class GoogleCloudContentwarehouseV1Action(typing_extensions.TypedDict, total=False):
    accessControl: GoogleCloudContentwarehouseV1AccessControlAction
    actionId: str
    addToFolder: GoogleCloudContentwarehouseV1AddToFolderAction
    dataUpdate: GoogleCloudContentwarehouseV1DataUpdateAction
    dataValidation: GoogleCloudContentwarehouseV1DataValidationAction
    deleteDocumentAction: GoogleCloudContentwarehouseV1DeleteDocumentAction
    publishToPubSub: GoogleCloudContentwarehouseV1PublishAction
    removeFromFolderAction: GoogleCloudContentwarehouseV1RemoveFromFolderAction

@typing.type_check_only
class GoogleCloudContentwarehouseV1ActionExecutorOutput(
    typing_extensions.TypedDict, total=False
):
    ruleActionsPairs: _list[GoogleCloudContentwarehouseV1RuleActionsPair]

@typing.type_check_only
class GoogleCloudContentwarehouseV1ActionOutput(
    typing_extensions.TypedDict, total=False
):
    actionId: str
    actionState: typing_extensions.Literal[
        "UNKNOWN",
        "ACTION_SUCCEEDED",
        "ACTION_FAILED",
        "ACTION_TIMED_OUT",
        "ACTION_PENDING",
    ]
    outputMessage: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1AddToFolderAction(
    typing_extensions.TypedDict, total=False
):
    folders: _list[str]

@typing.type_check_only
class GoogleCloudContentwarehouseV1CloudAIDocumentOption(
    typing_extensions.TypedDict, total=False
):
    customizedEntitiesPropertiesConversions: dict[str, typing.Any]
    enableEntitiesConversions: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1CreateDocumentLinkRequest(
    typing_extensions.TypedDict, total=False
):
    documentLink: GoogleCloudContentwarehouseV1DocumentLink
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1CreateDocumentMetadata(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1CreateDocumentRequest(
    typing_extensions.TypedDict, total=False
):
    cloudAiDocumentOption: GoogleCloudContentwarehouseV1CloudAIDocumentOption
    createMask: str
    document: GoogleCloudContentwarehouseV1Document
    policy: GoogleIamV1Policy
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1CreateDocumentResponse(
    typing_extensions.TypedDict, total=False
):
    document: GoogleCloudContentwarehouseV1Document
    longRunningOperations: _list[GoogleLongrunningOperation]
    metadata: GoogleCloudContentwarehouseV1ResponseMetadata
    ruleEngineOutput: GoogleCloudContentwarehouseV1RuleEngineOutput

@typing.type_check_only
class GoogleCloudContentwarehouseV1CustomWeightsMetadata(
    typing_extensions.TypedDict, total=False
):
    weightedSchemaProperties: _list[GoogleCloudContentwarehouseV1WeightedSchemaProperty]

@typing.type_check_only
class GoogleCloudContentwarehouseV1DataUpdateAction(
    typing_extensions.TypedDict, total=False
):
    entries: dict[str, typing.Any]

@typing.type_check_only
class GoogleCloudContentwarehouseV1DataValidationAction(
    typing_extensions.TypedDict, total=False
):
    conditions: dict[str, typing.Any]

@typing.type_check_only
class GoogleCloudContentwarehouseV1DateTimeArray(
    typing_extensions.TypedDict, total=False
):
    values: _list[GoogleTypeDateTime]

@typing.type_check_only
class GoogleCloudContentwarehouseV1DateTimeTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1DeleteDocumentAction(
    typing_extensions.TypedDict, total=False
):
    enableHardDelete: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1DeleteDocumentLinkRequest(
    typing_extensions.TypedDict, total=False
):
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1DeleteDocumentRequest(
    typing_extensions.TypedDict, total=False
):
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1Document(typing_extensions.TypedDict, total=False):
    cloudAiDocument: GoogleCloudDocumentaiV1Document
    contentCategory: typing_extensions.Literal[
        "CONTENT_CATEGORY_UNSPECIFIED",
        "CONTENT_CATEGORY_IMAGE",
        "CONTENT_CATEGORY_AUDIO",
        "CONTENT_CATEGORY_VIDEO",
    ]
    createTime: str
    creator: str
    displayName: str
    displayUri: str
    dispositionTime: str
    documentSchemaName: str
    inlineRawDocument: str
    legalHold: bool
    name: str
    plainText: str
    properties: _list[GoogleCloudContentwarehouseV1Property]
    rawDocumentFileType: typing_extensions.Literal[
        "RAW_DOCUMENT_FILE_TYPE_UNSPECIFIED",
        "RAW_DOCUMENT_FILE_TYPE_PDF",
        "RAW_DOCUMENT_FILE_TYPE_DOCX",
        "RAW_DOCUMENT_FILE_TYPE_XLSX",
        "RAW_DOCUMENT_FILE_TYPE_PPTX",
        "RAW_DOCUMENT_FILE_TYPE_TEXT",
        "RAW_DOCUMENT_FILE_TYPE_TIFF",
    ]
    rawDocumentPath: str
    referenceId: str
    textExtractionDisabled: bool
    textExtractionEnabled: bool
    title: str
    updateTime: str
    updater: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1DocumentLink(
    typing_extensions.TypedDict, total=False
):
    createTime: str
    description: str
    name: str
    sourceDocumentReference: GoogleCloudContentwarehouseV1DocumentReference
    state: typing_extensions.Literal["STATE_UNSPECIFIED", "ACTIVE", "SOFT_DELETED"]
    targetDocumentReference: GoogleCloudContentwarehouseV1DocumentReference
    updateTime: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1DocumentQuery(
    typing_extensions.TypedDict, total=False
):
    customPropertyFilter: str
    customWeightsMetadata: GoogleCloudContentwarehouseV1CustomWeightsMetadata
    documentCreatorFilter: _list[str]
    documentNameFilter: _list[str]
    documentSchemaNames: _list[str]
    fileTypeFilter: GoogleCloudContentwarehouseV1FileTypeFilter
    folderNameFilter: str
    isNlQuery: bool
    propertyFilter: _list[GoogleCloudContentwarehouseV1PropertyFilter]
    query: str
    queryContext: _list[str]
    timeFilters: _list[GoogleCloudContentwarehouseV1TimeFilter]

@typing.type_check_only
class GoogleCloudContentwarehouseV1DocumentReference(
    typing_extensions.TypedDict, total=False
):
    createTime: str
    deleteTime: str
    displayName: str
    documentIsFolder: bool
    documentIsLegalHoldFolder: bool
    documentIsRetentionFolder: bool
    documentName: str
    snippet: str
    updateTime: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1DocumentSchema(
    typing_extensions.TypedDict, total=False
):
    createTime: str
    description: str
    displayName: str
    documentIsFolder: bool
    name: str
    propertyDefinitions: _list[GoogleCloudContentwarehouseV1PropertyDefinition]
    updateTime: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1EnumArray(typing_extensions.TypedDict, total=False):
    values: _list[str]

@typing.type_check_only
class GoogleCloudContentwarehouseV1EnumTypeOptions(
    typing_extensions.TypedDict, total=False
):
    possibleValues: _list[str]
    validationCheckDisabled: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1EnumValue(typing_extensions.TypedDict, total=False):
    value: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ExportToCdwPipeline(
    typing_extensions.TypedDict, total=False
):
    docAiDataset: str
    documents: _list[str]
    exportFolderPath: str
    trainingSplitRatio: float

@typing.type_check_only
class GoogleCloudContentwarehouseV1FetchAclRequest(
    typing_extensions.TypedDict, total=False
):
    projectOwner: bool
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1FetchAclResponse(
    typing_extensions.TypedDict, total=False
):
    metadata: GoogleCloudContentwarehouseV1ResponseMetadata
    policy: GoogleIamV1Policy

@typing.type_check_only
class GoogleCloudContentwarehouseV1FileTypeFilter(
    typing_extensions.TypedDict, total=False
):
    fileType: typing_extensions.Literal[
        "FILE_TYPE_UNSPECIFIED", "ALL", "FOLDER", "DOCUMENT", "ROOT_FOLDER"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1FloatArray(typing_extensions.TypedDict, total=False):
    values: _list[float]

@typing.type_check_only
class GoogleCloudContentwarehouseV1FloatTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1GcsIngestPipeline(
    typing_extensions.TypedDict, total=False
):
    inputPath: str
    pipelineConfig: GoogleCloudContentwarehouseV1IngestPipelineConfig
    processorType: str
    schemaName: str
    skipIngestedDocuments: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline(
    typing_extensions.TypedDict, total=False
):
    extractProcessorInfos: _list[GoogleCloudContentwarehouseV1ProcessorInfo]
    inputPath: str
    pipelineConfig: GoogleCloudContentwarehouseV1IngestPipelineConfig
    processorResultsFolderPath: str
    skipIngestedDocuments: bool
    splitClassifyProcessorInfo: GoogleCloudContentwarehouseV1ProcessorInfo

@typing.type_check_only
class GoogleCloudContentwarehouseV1GetDocumentRequest(
    typing_extensions.TypedDict, total=False
):
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1HistogramQuery(
    typing_extensions.TypedDict, total=False
):
    filters: GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter
    histogramQuery: str
    requirePreciseResultSize: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1HistogramQueryPropertyNameFilter(
    typing_extensions.TypedDict, total=False
):
    documentSchemas: _list[str]
    propertyNames: _list[str]
    yAxis: typing_extensions.Literal[
        "HISTOGRAM_YAXIS_DOCUMENT", "HISTOGRAM_YAXIS_PROPERTY"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1HistogramQueryResult(
    typing_extensions.TypedDict, total=False
):
    histogram: dict[str, typing.Any]
    histogramQuery: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1IngestPipelineConfig(
    typing_extensions.TypedDict, total=False
):
    cloudFunction: str
    documentAclPolicy: GoogleIamV1Policy
    enableDocumentTextExtraction: bool
    folder: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1InitializeProjectRequest(
    typing_extensions.TypedDict, total=False
):
    accessControlMode: typing_extensions.Literal[
        "ACL_MODE_UNKNOWN",
        "ACL_MODE_UNIVERSAL_ACCESS",
        "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID",
        "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI",
    ]
    databaseType: typing_extensions.Literal[
        "DB_UNKNOWN", "DB_INFRA_SPANNER", "DB_CLOUD_SQL_POSTGRES"
    ]
    documentCreatorDefaultRole: typing_extensions.Literal[
        "DOCUMENT_CREATOR_DEFAULT_ROLE_UNSPECIFIED",
        "DOCUMENT_ADMIN",
        "DOCUMENT_EDITOR",
        "DOCUMENT_VIEWER",
    ]
    enableCalUserEmailLogging: bool
    kmsKey: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1InitializeProjectResponse(
    typing_extensions.TypedDict, total=False
):
    message: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED", "SUCCEEDED", "FAILED", "CANCELLED", "RUNNING"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1IntegerArray(
    typing_extensions.TypedDict, total=False
):
    values: _list[int]

@typing.type_check_only
class GoogleCloudContentwarehouseV1IntegerTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1InvalidRule(
    typing_extensions.TypedDict, total=False
):
    error: str
    rule: GoogleCloudContentwarehouseV1Rule

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListDocumentSchemasResponse(
    typing_extensions.TypedDict, total=False
):
    documentSchemas: _list[GoogleCloudContentwarehouseV1DocumentSchema]
    nextPageToken: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListLinkedSourcesRequest(
    typing_extensions.TypedDict, total=False
):
    pageSize: int
    pageToken: str
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListLinkedSourcesResponse(
    typing_extensions.TypedDict, total=False
):
    documentLinks: _list[GoogleCloudContentwarehouseV1DocumentLink]
    nextPageToken: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListLinkedTargetsRequest(
    typing_extensions.TypedDict, total=False
):
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListLinkedTargetsResponse(
    typing_extensions.TypedDict, total=False
):
    documentLinks: _list[GoogleCloudContentwarehouseV1DocumentLink]
    nextPageToken: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListRuleSetsResponse(
    typing_extensions.TypedDict, total=False
):
    nextPageToken: str
    ruleSets: _list[GoogleCloudContentwarehouseV1RuleSet]

@typing.type_check_only
class GoogleCloudContentwarehouseV1ListSynonymSetsResponse(
    typing_extensions.TypedDict, total=False
):
    nextPageToken: str
    synonymSets: _list[GoogleCloudContentwarehouseV1SynonymSet]

@typing.type_check_only
class GoogleCloudContentwarehouseV1LockDocumentRequest(
    typing_extensions.TypedDict, total=False
):
    collectionId: str
    lockingUser: GoogleCloudContentwarehouseV1UserInfo

@typing.type_check_only
class GoogleCloudContentwarehouseV1MapProperty(
    typing_extensions.TypedDict, total=False
):
    fields: dict[str, typing.Any]

@typing.type_check_only
class GoogleCloudContentwarehouseV1MapTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1MergeFieldsOptions(
    typing_extensions.TypedDict, total=False
):
    replaceMessageFields: bool
    replaceRepeatedFields: bool

@typing.type_check_only
class GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline(
    typing_extensions.TypedDict, total=False
):
    documents: _list[str]
    exportFolderPath: str
    processorInfo: GoogleCloudContentwarehouseV1ProcessorInfo
    processorResultsFolderPath: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ProcessorInfo(
    typing_extensions.TypedDict, total=False
):
    documentType: str
    processorName: str
    schemaName: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1ProjectStatus(
    typing_extensions.TypedDict, total=False
):
    accessControlMode: typing_extensions.Literal[
        "ACL_MODE_UNKNOWN",
        "ACL_MODE_UNIVERSAL_ACCESS",
        "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_BYOID",
        "ACL_MODE_DOCUMENT_LEVEL_ACCESS_CONTROL_GCI",
    ]
    databaseType: typing_extensions.Literal[
        "DB_UNKNOWN", "DB_INFRA_SPANNER", "DB_CLOUD_SQL_POSTGRES"
    ]
    documentCreatorDefaultRole: str
    location: str
    qaEnabled: bool
    state: typing_extensions.Literal[
        "PROJECT_STATE_UNSPECIFIED",
        "PROJECT_STATE_PENDING",
        "PROJECT_STATE_COMPLETED",
        "PROJECT_STATE_FAILED",
        "PROJECT_STATE_DELETING",
        "PROJECT_STATE_DELETING_FAILED",
        "PROJECT_STATE_DELETED",
        "PROJECT_STATE_NOT_FOUND",
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1Property(typing_extensions.TypedDict, total=False):
    dateTimeValues: GoogleCloudContentwarehouseV1DateTimeArray
    enumValues: GoogleCloudContentwarehouseV1EnumArray
    floatValues: GoogleCloudContentwarehouseV1FloatArray
    integerValues: GoogleCloudContentwarehouseV1IntegerArray
    mapProperty: GoogleCloudContentwarehouseV1MapProperty
    name: str
    propertyValues: GoogleCloudContentwarehouseV1PropertyArray
    textValues: GoogleCloudContentwarehouseV1TextArray
    timestampValues: GoogleCloudContentwarehouseV1TimestampArray

@typing.type_check_only
class GoogleCloudContentwarehouseV1PropertyArray(
    typing_extensions.TypedDict, total=False
):
    properties: _list[GoogleCloudContentwarehouseV1Property]

@typing.type_check_only
class GoogleCloudContentwarehouseV1PropertyDefinition(
    typing_extensions.TypedDict, total=False
):
    dateTimeTypeOptions: GoogleCloudContentwarehouseV1DateTimeTypeOptions
    displayName: str
    enumTypeOptions: GoogleCloudContentwarehouseV1EnumTypeOptions
    floatTypeOptions: GoogleCloudContentwarehouseV1FloatTypeOptions
    integerTypeOptions: GoogleCloudContentwarehouseV1IntegerTypeOptions
    isFilterable: bool
    isMetadata: bool
    isRepeatable: bool
    isRequired: bool
    isSearchable: bool
    mapTypeOptions: GoogleCloudContentwarehouseV1MapTypeOptions
    name: str
    propertyTypeOptions: GoogleCloudContentwarehouseV1PropertyTypeOptions
    retrievalImportance: typing_extensions.Literal[
        "RETRIEVAL_IMPORTANCE_UNSPECIFIED",
        "HIGHEST",
        "HIGHER",
        "HIGH",
        "MEDIUM",
        "LOW",
        "LOWEST",
    ]
    schemaSources: _list[GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource]
    textTypeOptions: GoogleCloudContentwarehouseV1TextTypeOptions
    timestampTypeOptions: GoogleCloudContentwarehouseV1TimestampTypeOptions

@typing.type_check_only
class GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSource(
    typing_extensions.TypedDict, total=False
):
    name: str
    processorType: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1PropertyFilter(
    typing_extensions.TypedDict, total=False
):
    condition: str
    documentSchemaName: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1PropertyTypeOptions(
    typing_extensions.TypedDict, total=False
):
    propertyDefinitions: _list[GoogleCloudContentwarehouseV1PropertyDefinition]

@typing.type_check_only
class GoogleCloudContentwarehouseV1PublishAction(
    typing_extensions.TypedDict, total=False
):
    messages: _list[str]
    topicId: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1QAResult(typing_extensions.TypedDict, total=False):
    confidenceScore: float
    highlights: _list[GoogleCloudContentwarehouseV1QAResultHighlight]

@typing.type_check_only
class GoogleCloudContentwarehouseV1QAResultHighlight(
    typing_extensions.TypedDict, total=False
):
    endIndex: int
    startIndex: int

@typing.type_check_only
class GoogleCloudContentwarehouseV1RemoveFromFolderAction(
    typing_extensions.TypedDict, total=False
):
    condition: str
    folder: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1RequestMetadata(
    typing_extensions.TypedDict, total=False
):
    userInfo: GoogleCloudContentwarehouseV1UserInfo

@typing.type_check_only
class GoogleCloudContentwarehouseV1ResponseMetadata(
    typing_extensions.TypedDict, total=False
):
    requestId: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1Rule(typing_extensions.TypedDict, total=False):
    actions: _list[GoogleCloudContentwarehouseV1Action]
    condition: str
    description: str
    ruleId: str
    triggerType: typing_extensions.Literal[
        "UNKNOWN", "ON_CREATE", "ON_UPDATE", "ON_CREATE_LINK", "ON_DELETE_LINK"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1RuleActionsPair(
    typing_extensions.TypedDict, total=False
):
    actionOutputs: _list[GoogleCloudContentwarehouseV1ActionOutput]
    rule: GoogleCloudContentwarehouseV1Rule

@typing.type_check_only
class GoogleCloudContentwarehouseV1RuleEngineOutput(
    typing_extensions.TypedDict, total=False
):
    actionExecutorOutput: GoogleCloudContentwarehouseV1ActionExecutorOutput
    documentName: str
    ruleEvaluatorOutput: GoogleCloudContentwarehouseV1RuleEvaluatorOutput

@typing.type_check_only
class GoogleCloudContentwarehouseV1RuleEvaluatorOutput(
    typing_extensions.TypedDict, total=False
):
    invalidRules: _list[GoogleCloudContentwarehouseV1InvalidRule]
    matchedRules: _list[GoogleCloudContentwarehouseV1Rule]
    triggeredRules: _list[GoogleCloudContentwarehouseV1Rule]

@typing.type_check_only
class GoogleCloudContentwarehouseV1RuleSet(typing_extensions.TypedDict, total=False):
    description: str
    name: str
    rules: _list[GoogleCloudContentwarehouseV1Rule]
    source: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineMetadata(
    typing_extensions.TypedDict, total=False
):
    exportToCdwPipelineMetadata: GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata
    failedFileCount: int
    gcsIngestPipelineMetadata: GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata
    individualDocumentStatuses: _list[
        GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus
    ]
    processWithDocAiPipelineMetadata: GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata
    totalFileCount: int
    userInfo: GoogleCloudContentwarehouseV1UserInfo

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineMetadataExportToCdwPipelineMetadata(
    typing_extensions.TypedDict, total=False
):
    docAiDataset: str
    documents: _list[str]
    outputPath: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineMetadataGcsIngestPipelineMetadata(
    typing_extensions.TypedDict, total=False
):
    inputPath: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineMetadataIndividualDocumentStatus(
    typing_extensions.TypedDict, total=False
):
    documentId: str
    status: GoogleRpcStatus

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineMetadataProcessWithDocAiPipelineMetadata(
    typing_extensions.TypedDict, total=False
):
    documents: _list[str]
    processorInfo: GoogleCloudContentwarehouseV1ProcessorInfo

@typing.type_check_only
class GoogleCloudContentwarehouseV1RunPipelineRequest(
    typing_extensions.TypedDict, total=False
):
    exportCdwPipeline: GoogleCloudContentwarehouseV1ExportToCdwPipeline
    gcsIngestPipeline: GoogleCloudContentwarehouseV1GcsIngestPipeline
    gcsIngestWithDocAiProcessorsPipeline: GoogleCloudContentwarehouseV1GcsIngestWithDocAiProcessorsPipeline
    processWithDocAiPipeline: GoogleCloudContentwarehouseV1ProcessWithDocAiPipeline
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1SearchDocumentsRequest(
    typing_extensions.TypedDict, total=False
):
    documentQuery: GoogleCloudContentwarehouseV1DocumentQuery
    histogramQueries: _list[GoogleCloudContentwarehouseV1HistogramQuery]
    offset: int
    orderBy: str
    pageSize: int
    pageToken: str
    qaSizeLimit: int
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata
    requireTotalSize: bool
    totalResultSize: typing_extensions.Literal[
        "TOTAL_RESULT_SIZE_UNSPECIFIED", "ESTIMATED_SIZE", "ACTUAL_SIZE"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1SearchDocumentsResponse(
    typing_extensions.TypedDict, total=False
):
    histogramQueryResults: _list[GoogleCloudContentwarehouseV1HistogramQueryResult]
    matchingDocuments: _list[
        GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument
    ]
    metadata: GoogleCloudContentwarehouseV1ResponseMetadata
    nextPageToken: str
    questionAnswer: str
    totalSize: int

@typing.type_check_only
class GoogleCloudContentwarehouseV1SearchDocumentsResponseMatchingDocument(
    typing_extensions.TypedDict, total=False
):
    document: GoogleCloudContentwarehouseV1Document
    matchedTokenPageIndices: _list[str]
    qaResult: GoogleCloudContentwarehouseV1QAResult
    searchTextSnippet: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1SetAclRequest(
    typing_extensions.TypedDict, total=False
):
    policy: GoogleIamV1Policy
    projectOwner: bool
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata

@typing.type_check_only
class GoogleCloudContentwarehouseV1SetAclResponse(
    typing_extensions.TypedDict, total=False
):
    metadata: GoogleCloudContentwarehouseV1ResponseMetadata
    policy: GoogleIamV1Policy

@typing.type_check_only
class GoogleCloudContentwarehouseV1SynonymSet(typing_extensions.TypedDict, total=False):
    context: str
    name: str
    synonyms: _list[GoogleCloudContentwarehouseV1SynonymSetSynonym]

@typing.type_check_only
class GoogleCloudContentwarehouseV1SynonymSetSynonym(
    typing_extensions.TypedDict, total=False
):
    words: _list[str]

@typing.type_check_only
class GoogleCloudContentwarehouseV1TextArray(typing_extensions.TypedDict, total=False):
    values: _list[str]

@typing.type_check_only
class GoogleCloudContentwarehouseV1TextTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1TimeFilter(typing_extensions.TypedDict, total=False):
    timeField: typing_extensions.Literal[
        "TIME_FIELD_UNSPECIFIED", "CREATE_TIME", "UPDATE_TIME", "DISPOSITION_TIME"
    ]
    timeRange: GoogleTypeInterval

@typing.type_check_only
class GoogleCloudContentwarehouseV1TimestampArray(
    typing_extensions.TypedDict, total=False
):
    values: _list[GoogleCloudContentwarehouseV1TimestampValue]

@typing.type_check_only
class GoogleCloudContentwarehouseV1TimestampTypeOptions(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1TimestampValue(
    typing_extensions.TypedDict, total=False
):
    textValue: str
    timestampValue: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateDocumentMetadata(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateDocumentRequest(
    typing_extensions.TypedDict, total=False
):
    cloudAiDocumentOption: GoogleCloudContentwarehouseV1CloudAIDocumentOption
    document: GoogleCloudContentwarehouseV1Document
    requestMetadata: GoogleCloudContentwarehouseV1RequestMetadata
    updateOptions: GoogleCloudContentwarehouseV1UpdateOptions

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateDocumentResponse(
    typing_extensions.TypedDict, total=False
):
    document: GoogleCloudContentwarehouseV1Document
    metadata: GoogleCloudContentwarehouseV1ResponseMetadata
    ruleEngineOutput: GoogleCloudContentwarehouseV1RuleEngineOutput

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateDocumentSchemaRequest(
    typing_extensions.TypedDict, total=False
):
    documentSchema: GoogleCloudContentwarehouseV1DocumentSchema

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateOptions(
    typing_extensions.TypedDict, total=False
):
    mergeFieldsOptions: GoogleCloudContentwarehouseV1MergeFieldsOptions
    updateMask: str
    updateType: typing_extensions.Literal[
        "UPDATE_TYPE_UNSPECIFIED",
        "UPDATE_TYPE_REPLACE",
        "UPDATE_TYPE_MERGE",
        "UPDATE_TYPE_INSERT_PROPERTIES_BY_NAMES",
        "UPDATE_TYPE_REPLACE_PROPERTIES_BY_NAMES",
        "UPDATE_TYPE_DELETE_PROPERTIES_BY_NAMES",
        "UPDATE_TYPE_MERGE_AND_REPLACE_OR_INSERT_PROPERTIES_BY_NAMES",
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1UpdateRuleSetRequest(
    typing_extensions.TypedDict, total=False
):
    ruleSet: GoogleCloudContentwarehouseV1RuleSet

@typing.type_check_only
class GoogleCloudContentwarehouseV1UserInfo(typing_extensions.TypedDict, total=False):
    groupIds: _list[str]
    id: str

@typing.type_check_only
class GoogleCloudContentwarehouseV1Value(typing_extensions.TypedDict, total=False):
    booleanValue: bool
    datetimeValue: GoogleTypeDateTime
    enumValue: GoogleCloudContentwarehouseV1EnumValue
    floatValue: float
    intValue: int
    stringValue: str
    timestampValue: GoogleCloudContentwarehouseV1TimestampValue

@typing.type_check_only
class GoogleCloudContentwarehouseV1WeightedSchemaProperty(
    typing_extensions.TypedDict, total=False
):
    documentSchemaName: str
    propertyNames: _list[str]

@typing.type_check_only
class GoogleCloudContentwarehouseV1beta1CreateDocumentMetadata(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudContentwarehouseV1beta1InitializeProjectResponse(
    typing_extensions.TypedDict, total=False
):
    message: str
    state: typing_extensions.Literal[
        "STATE_UNSPECIFIED", "SUCCEEDED", "FAILED", "CANCELLED", "RUNNING"
    ]

@typing.type_check_only
class GoogleCloudContentwarehouseV1beta1UpdateDocumentMetadata(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleCloudDocumentaiV1Barcode(typing_extensions.TypedDict, total=False):
    format: str
    rawValue: str
    valueFormat: str

@typing.type_check_only
class GoogleCloudDocumentaiV1BoundingPoly(typing_extensions.TypedDict, total=False):
    normalizedVertices: _list[GoogleCloudDocumentaiV1NormalizedVertex]
    vertices: _list[GoogleCloudDocumentaiV1Vertex]

@typing.type_check_only
class GoogleCloudDocumentaiV1Document(typing_extensions.TypedDict, total=False):
    content: str
    entities: _list[GoogleCloudDocumentaiV1DocumentEntity]
    entityRelations: _list[GoogleCloudDocumentaiV1DocumentEntityRelation]
    error: GoogleRpcStatus
    mimeType: str
    pages: _list[GoogleCloudDocumentaiV1DocumentPage]
    revisions: _list[GoogleCloudDocumentaiV1DocumentRevision]
    shardInfo: GoogleCloudDocumentaiV1DocumentShardInfo
    text: str
    textChanges: _list[GoogleCloudDocumentaiV1DocumentTextChange]
    textStyles: _list[GoogleCloudDocumentaiV1DocumentStyle]
    uri: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentEntity(typing_extensions.TypedDict, total=False):
    confidence: float
    id: str
    mentionId: str
    mentionText: str
    normalizedValue: GoogleCloudDocumentaiV1DocumentEntityNormalizedValue
    pageAnchor: GoogleCloudDocumentaiV1DocumentPageAnchor
    properties: _list[GoogleCloudDocumentaiV1DocumentEntity]
    provenance: GoogleCloudDocumentaiV1DocumentProvenance
    redacted: bool
    textAnchor: GoogleCloudDocumentaiV1DocumentTextAnchor
    type: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentEntityNormalizedValue(
    typing_extensions.TypedDict, total=False
):
    addressValue: GoogleTypePostalAddress
    booleanValue: bool
    dateValue: GoogleTypeDate
    datetimeValue: GoogleTypeDateTime
    floatValue: float
    integerValue: int
    moneyValue: GoogleTypeMoney
    text: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentEntityRelation(
    typing_extensions.TypedDict, total=False
):
    objectId: str
    relation: str
    subjectId: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPage(typing_extensions.TypedDict, total=False):
    blocks: _list[GoogleCloudDocumentaiV1DocumentPageBlock]
    detectedBarcodes: _list[GoogleCloudDocumentaiV1DocumentPageDetectedBarcode]
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    dimension: GoogleCloudDocumentaiV1DocumentPageDimension
    formFields: _list[GoogleCloudDocumentaiV1DocumentPageFormField]
    image: GoogleCloudDocumentaiV1DocumentPageImage
    imageQualityScores: GoogleCloudDocumentaiV1DocumentPageImageQualityScores
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    lines: _list[GoogleCloudDocumentaiV1DocumentPageLine]
    pageNumber: int
    paragraphs: _list[GoogleCloudDocumentaiV1DocumentPageParagraph]
    provenance: GoogleCloudDocumentaiV1DocumentProvenance
    symbols: _list[GoogleCloudDocumentaiV1DocumentPageSymbol]
    tables: _list[GoogleCloudDocumentaiV1DocumentPageTable]
    tokens: _list[GoogleCloudDocumentaiV1DocumentPageToken]
    transforms: _list[GoogleCloudDocumentaiV1DocumentPageMatrix]
    visualElements: _list[GoogleCloudDocumentaiV1DocumentPageVisualElement]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageAnchor(
    typing_extensions.TypedDict, total=False
):
    pageRefs: _list[GoogleCloudDocumentaiV1DocumentPageAnchorPageRef]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageAnchorPageRef(
    typing_extensions.TypedDict, total=False
):
    boundingPoly: GoogleCloudDocumentaiV1BoundingPoly
    confidence: float
    layoutId: str
    layoutType: typing_extensions.Literal[
        "LAYOUT_TYPE_UNSPECIFIED",
        "BLOCK",
        "PARAGRAPH",
        "LINE",
        "TOKEN",
        "VISUAL_ELEMENT",
        "TABLE",
        "FORM_FIELD",
    ]
    page: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageBlock(
    typing_extensions.TypedDict, total=False
):
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    provenance: GoogleCloudDocumentaiV1DocumentProvenance

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageDetectedBarcode(
    typing_extensions.TypedDict, total=False
):
    barcode: GoogleCloudDocumentaiV1Barcode
    layout: GoogleCloudDocumentaiV1DocumentPageLayout

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageDetectedLanguage(
    typing_extensions.TypedDict, total=False
):
    confidence: float
    languageCode: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageDimension(
    typing_extensions.TypedDict, total=False
):
    height: float
    unit: str
    width: float

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageFormField(
    typing_extensions.TypedDict, total=False
):
    correctedKeyText: str
    correctedValueText: str
    fieldName: GoogleCloudDocumentaiV1DocumentPageLayout
    fieldValue: GoogleCloudDocumentaiV1DocumentPageLayout
    nameDetectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    provenance: GoogleCloudDocumentaiV1DocumentProvenance
    valueDetectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    valueType: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageImage(
    typing_extensions.TypedDict, total=False
):
    content: str
    height: int
    mimeType: str
    width: int

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageImageQualityScores(
    typing_extensions.TypedDict, total=False
):
    detectedDefects: _list[
        GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect
    ]
    qualityScore: float

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefect(
    typing_extensions.TypedDict, total=False
):
    confidence: float
    type: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageLayout(
    typing_extensions.TypedDict, total=False
):
    boundingPoly: GoogleCloudDocumentaiV1BoundingPoly
    confidence: float
    orientation: typing_extensions.Literal[
        "ORIENTATION_UNSPECIFIED", "PAGE_UP", "PAGE_RIGHT", "PAGE_DOWN", "PAGE_LEFT"
    ]
    textAnchor: GoogleCloudDocumentaiV1DocumentTextAnchor

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageLine(typing_extensions.TypedDict, total=False):
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    provenance: GoogleCloudDocumentaiV1DocumentProvenance

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageMatrix(
    typing_extensions.TypedDict, total=False
):
    cols: int
    data: str
    rows: int
    type: int

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageParagraph(
    typing_extensions.TypedDict, total=False
):
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    provenance: GoogleCloudDocumentaiV1DocumentProvenance

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageSymbol(
    typing_extensions.TypedDict, total=False
):
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageTable(
    typing_extensions.TypedDict, total=False
):
    bodyRows: _list[GoogleCloudDocumentaiV1DocumentPageTableTableRow]
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    headerRows: _list[GoogleCloudDocumentaiV1DocumentPageTableTableRow]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    provenance: GoogleCloudDocumentaiV1DocumentProvenance

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageTableTableCell(
    typing_extensions.TypedDict, total=False
):
    colSpan: int
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    rowSpan: int

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageTableTableRow(
    typing_extensions.TypedDict, total=False
):
    cells: _list[GoogleCloudDocumentaiV1DocumentPageTableTableCell]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageToken(
    typing_extensions.TypedDict, total=False
):
    detectedBreak: GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    provenance: GoogleCloudDocumentaiV1DocumentProvenance
    styleInfo: GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreak(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal["TYPE_UNSPECIFIED", "SPACE", "WIDE_SPACE", "HYPHEN"]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageTokenStyleInfo(
    typing_extensions.TypedDict, total=False
):
    backgroundColor: GoogleTypeColor
    bold: bool
    fontSize: int
    fontType: str
    fontWeight: int
    handwritten: bool
    italic: bool
    letterSpacing: float
    pixelFontSize: float
    smallcaps: bool
    strikeout: bool
    subscript: bool
    superscript: bool
    textColor: GoogleTypeColor
    underlined: bool

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentPageVisualElement(
    typing_extensions.TypedDict, total=False
):
    detectedLanguages: _list[GoogleCloudDocumentaiV1DocumentPageDetectedLanguage]
    layout: GoogleCloudDocumentaiV1DocumentPageLayout
    type: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentProvenance(
    typing_extensions.TypedDict, total=False
):
    id: int
    parents: _list[GoogleCloudDocumentaiV1DocumentProvenanceParent]
    revision: int
    type: typing_extensions.Literal[
        "OPERATION_TYPE_UNSPECIFIED",
        "ADD",
        "REMOVE",
        "UPDATE",
        "REPLACE",
        "EVAL_REQUESTED",
        "EVAL_APPROVED",
        "EVAL_SKIPPED",
    ]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentProvenanceParent(
    typing_extensions.TypedDict, total=False
):
    id: int
    index: int
    revision: int

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentRevision(typing_extensions.TypedDict, total=False):
    agent: str
    createTime: str
    humanReview: GoogleCloudDocumentaiV1DocumentRevisionHumanReview
    id: str
    parent: _list[int]
    parentIds: _list[str]
    processor: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentRevisionHumanReview(
    typing_extensions.TypedDict, total=False
):
    state: str
    stateMessage: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentShardInfo(
    typing_extensions.TypedDict, total=False
):
    shardCount: str
    shardIndex: str
    textOffset: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentStyle(typing_extensions.TypedDict, total=False):
    backgroundColor: GoogleTypeColor
    color: GoogleTypeColor
    fontFamily: str
    fontSize: GoogleCloudDocumentaiV1DocumentStyleFontSize
    fontWeight: str
    textAnchor: GoogleCloudDocumentaiV1DocumentTextAnchor
    textDecoration: str
    textStyle: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentStyleFontSize(
    typing_extensions.TypedDict, total=False
):
    size: float
    unit: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentTextAnchor(
    typing_extensions.TypedDict, total=False
):
    content: str
    textSegments: _list[GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment]

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentTextAnchorTextSegment(
    typing_extensions.TypedDict, total=False
):
    endIndex: str
    startIndex: str

@typing.type_check_only
class GoogleCloudDocumentaiV1DocumentTextChange(
    typing_extensions.TypedDict, total=False
):
    changedText: str
    provenance: _list[GoogleCloudDocumentaiV1DocumentProvenance]
    textAnchor: GoogleCloudDocumentaiV1DocumentTextAnchor

@typing.type_check_only
class GoogleCloudDocumentaiV1NormalizedVertex(typing_extensions.TypedDict, total=False):
    x: float
    y: float

@typing.type_check_only
class GoogleCloudDocumentaiV1Vertex(typing_extensions.TypedDict, total=False):
    x: int
    y: int

@typing.type_check_only
class GoogleIamV1AuditConfig(typing_extensions.TypedDict, total=False):
    auditLogConfigs: _list[GoogleIamV1AuditLogConfig]
    service: str

@typing.type_check_only
class GoogleIamV1AuditLogConfig(typing_extensions.TypedDict, total=False):
    exemptedMembers: _list[str]
    logType: typing_extensions.Literal[
        "LOG_TYPE_UNSPECIFIED", "ADMIN_READ", "DATA_WRITE", "DATA_READ"
    ]

@typing.type_check_only
class GoogleIamV1Binding(typing_extensions.TypedDict, total=False):
    condition: GoogleTypeExpr
    members: _list[str]
    role: str

@typing.type_check_only
class GoogleIamV1Policy(typing_extensions.TypedDict, total=False):
    auditConfigs: _list[GoogleIamV1AuditConfig]
    bindings: _list[GoogleIamV1Binding]
    etag: str
    version: int

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaAvailabilityPeriod(
    typing_extensions.TypedDict, total=False
):
    dayOfWeek: int
    periodEndMinutes: int
    periodStartMinutes: int

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaCalendarBusy(
    typing_extensions.TypedDict, total=False
):
    committedUntil: str
    eventSummary: str
    nextAvailable: str
    occupiedUntil: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaCustomLocation(
    typing_extensions.TypedDict, total=False
):
    geoCoordinates: GoogleTypeLatLng
    label: str
    location: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaDoNotDisturb(
    typing_extensions.TypedDict, total=False
):
    committedUntil: str
    nextAvailable: str
    occupiedUntil: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaHomeLocation(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaInMeeting(typing_extensions.TypedDict, total=False):
    committedUntil: str
    eventSummary: str
    inMeetingsUntil: str
    nextAvailable: str
    occupiedUntil: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaInactive(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaLocalTimeContext(
    typing_extensions.TypedDict, total=False
):
    timeZone: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaOfficeLocation(
    typing_extensions.TypedDict, total=False
):
    experimentalBuildingId: str
    experimentalDeskId: str
    experimentalFloorId: str
    label: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaOutOfOffice(
    typing_extensions.TypedDict, total=False
):
    comeBackTime: str
    committedUntil: str
    eventSummary: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaOutsideWorkingHours(
    typing_extensions.TypedDict, total=False
):
    comeBackTime: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaTimeRange(typing_extensions.TypedDict, total=False):
    endTime: str
    startTime: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUpcomingCommitmentContext(
    typing_extensions.TypedDict, total=False
):
    nextCommitmentStatus: GoogleInternalAppsWaldoV1alphaUserStatus
    nextCommitmentTime: str

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUpcomingOooContext(
    typing_extensions.TypedDict, total=False
):
    timeRange: GoogleInternalAppsWaldoV1alphaTimeRange

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUserAvailabilities(
    typing_extensions.TypedDict, total=False
):
    availabilities: _list[GoogleInternalAppsWaldoV1alphaUserAvailability]
    nextPollTime: str
    workingHours: GoogleInternalAppsWaldoV1alphaWorkingHours

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUserAvailability(
    typing_extensions.TypedDict, total=False
):
    contexts: GoogleInternalAppsWaldoV1alphaUserContext
    status: GoogleInternalAppsWaldoV1alphaUserStatus
    timeRange: GoogleInternalAppsWaldoV1alphaTimeRange

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUserContext(
    typing_extensions.TypedDict, total=False
):
    localTime: GoogleInternalAppsWaldoV1alphaLocalTimeContext
    upcomingCommitmentContext: GoogleInternalAppsWaldoV1alphaUpcomingCommitmentContext
    upcomingOoo: GoogleInternalAppsWaldoV1alphaUpcomingOooContext
    workingElsewhere: GoogleInternalAppsWaldoV1alphaWorkingElsewhereContext

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUserLocation(
    typing_extensions.TypedDict, total=False
):
    customLocation: GoogleInternalAppsWaldoV1alphaCustomLocation
    homeLocation: GoogleInternalAppsWaldoV1alphaHomeLocation
    officeLocation: GoogleInternalAppsWaldoV1alphaOfficeLocation

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaUserStatus(
    typing_extensions.TypedDict, total=False
):
    calendarBusy: GoogleInternalAppsWaldoV1alphaCalendarBusy
    doNotDisturb: GoogleInternalAppsWaldoV1alphaDoNotDisturb
    inMeeting: GoogleInternalAppsWaldoV1alphaInMeeting
    inactive: GoogleInternalAppsWaldoV1alphaInactive
    outOfOffice: GoogleInternalAppsWaldoV1alphaOutOfOffice
    outsideWorkingHours: GoogleInternalAppsWaldoV1alphaOutsideWorkingHours

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaWorkingElsewhereContext(
    typing_extensions.TypedDict, total=False
):
    location: GoogleInternalAppsWaldoV1alphaUserLocation

@typing.type_check_only
class GoogleInternalAppsWaldoV1alphaWorkingHours(
    typing_extensions.TypedDict, total=False
):
    availableTime: _list[GoogleInternalAppsWaldoV1alphaAvailabilityPeriod]

@typing.type_check_only
class GoogleInternalCommunicationsInstantmessagingV1Id(
    typing_extensions.TypedDict, total=False
):
    app: str
    countryCode: str
    id: str
    locationHint: GoogleInternalCommunicationsInstantmessagingV1LocationHint
    routingInfoToken: str
    type: typing_extensions.Literal[
        "UNSET",
        "PHONE_NUMBER",
        "GROUP_ID",
        "FIREBALL_BOT",
        "CALL_CONTROLLER",
        "SUGGESTER",
        "FI_ID",
        "SYSTEM",
        "DUO_BOT",
        "MATCHBOX_ID",
        "RCS_BOT",
        "WIREBALL",
        "SERVICE_ACCOUNT",
        "DEVICE_ID",
        "FOREIGN_RCS_GROUP",
        "DITTO",
        "EMAIL",
        "GAIA_ID",
        "LIGHTER_ID",
        "OPAQUE_ID",
        "SERVER",
        "SHORT_CODE",
        "CLOUDCAST_PLAYER_ID",
        "CHROMOTING_ID",
        "UNNORMALIZABLE_PHONE_NUMBER",
        "NOT_KNOWN",
        "ANDROID_ID",
        "NEARBY_ID",
        "WAZE_ID",
        "GUEST",
        "MESSAGES_DATA_DONATION",
        "DUO_CLIP_ID",
        "ACCOUNT_ID",
        "CARRIER_ID",
        "EXTERNAL_PARTNER_ID",
        "UNAUTHENTICATED_USER_ID",
        "SUPPORT_CASES_ID",
        "FITBIT_P11_ID",
        "SHORT_PHONE_NUMBER",
        "USER_HANDLE",
    ]

@typing.type_check_only
class GoogleInternalCommunicationsInstantmessagingV1LocationHint(
    typing_extensions.TypedDict, total=False
):
    format: typing_extensions.Literal["UNKNOWN", "E164_CALLING", "ISO_3166_1_ALPHA_2"]
    location: str

@typing.type_check_only
class GoogleLongrunningOperation(typing_extensions.TypedDict, total=False):
    done: bool
    error: GoogleRpcStatus
    metadata: dict[str, typing.Any]
    name: str
    response: dict[str, typing.Any]

@typing.type_check_only
class GoogleProtobufEmpty(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class GoogleRpcStatus(typing_extensions.TypedDict, total=False):
    code: int
    details: _list[dict[str, typing.Any]]
    message: str

@typing.type_check_only
class GoogleTypeColor(typing_extensions.TypedDict, total=False):
    alpha: float
    blue: float
    green: float
    red: float

@typing.type_check_only
class GoogleTypeDate(typing_extensions.TypedDict, total=False):
    day: int
    month: int
    year: int

@typing.type_check_only
class GoogleTypeDateTime(typing_extensions.TypedDict, total=False):
    day: int
    hours: int
    minutes: int
    month: int
    nanos: int
    seconds: int
    timeZone: GoogleTypeTimeZone
    utcOffset: str
    year: int

@typing.type_check_only
class GoogleTypeExpr(typing_extensions.TypedDict, total=False):
    description: str
    expression: str
    location: str
    title: str

@typing.type_check_only
class GoogleTypeInterval(typing_extensions.TypedDict, total=False):
    endTime: str
    startTime: str

@typing.type_check_only
class GoogleTypeLatLng(typing_extensions.TypedDict, total=False):
    latitude: float
    longitude: float

@typing.type_check_only
class GoogleTypeMoney(typing_extensions.TypedDict, total=False):
    currencyCode: str
    nanos: int
    units: str

@typing.type_check_only
class GoogleTypePostalAddress(typing_extensions.TypedDict, total=False):
    addressLines: _list[str]
    administrativeArea: str
    languageCode: str
    locality: str
    organization: str
    postalCode: str
    recipients: _list[str]
    regionCode: str
    revision: int
    sortingCode: str
    sublocality: str

@typing.type_check_only
class GoogleTypeTimeOfDay(typing_extensions.TypedDict, total=False):
    hours: int
    minutes: int
    nanos: int
    seconds: int

@typing.type_check_only
class GoogleTypeTimeZone(typing_extensions.TypedDict, total=False):
    id: str
    version: str

@typing.type_check_only
class GroupsPerDocData(typing_extensions.TypedDict, total=False):
    AuthorId: str
    GroupGaiaId: str
    GroupId: str
    ThreadId: str

@typing.type_check_only
class HomeGraphCommonRoute(typing_extensions.TypedDict, total=False):
    agentDeviceId: str
    agentId: str
    chipEndpoint: _list[int]
    targetType: typing_extensions.Literal[
        "UNSPECIFIED", "PARTNER_CLOUD", "LOCAL", "CHIP"
    ]

@typing.type_check_only
class HomeGraphCommonRoutingTable(typing_extensions.TypedDict, total=False):
    supportedRoutes: _list[HomeGraphCommonRoute]

@typing.type_check_only
class HomeGraphCommonTraitRoutingHints(typing_extensions.TypedDict, total=False):
    cloudFulfillmentOnly: bool
    trait: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoAnonTimingStatPair(
    typing_extensions.TypedDict, total=False
):
    name: str
    timeS: float

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoBox(typing_extensions.TypedDict, total=False):
    height: int
    width: int
    x: int
    y: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoChromiumTrace(
    typing_extensions.TypedDict, total=False
):
    chromiumTrace: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoConsoleLogEntry(
    typing_extensions.TypedDict, total=False
):
    lineNumber: int
    message: str
    messageLevel: typing_extensions.Literal[
        "TIP_MESSAGE_LEVEL",
        "DEBUG_MESSAGE_LEVEL",
        "LOG_MESSAGE_LEVEL",
        "INFO_MESSAGE_LEVEL",
        "WARNING_MESSAGE_LEVEL",
        "ERROR_MESSAGE_LEVEL",
    ]
    sourceUrl: str
    stackTrace: _list[HtmlrenderWebkitHeadlessProtoScriptStackFrame]
    timestamp: float

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoCookie(typing_extensions.TypedDict, total=False):
    domain: str
    expiration: float
    httpOnly: bool
    name: str
    path: str
    sameSite: typing_extensions.Literal[
        "SAME_SITE_UNSPECIFIED", "SAME_SITE_LAX", "SAME_SITE_STRICT", "SAME_SITE_NONE"
    ]
    secure: bool
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoDOMStorageItem(
    typing_extensions.TypedDict, total=False
):
    key: str
    securityOrigin: str
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoDOMTreeNode(
    typing_extensions.TypedDict, total=False
):
    attribute: _list[HtmlrenderWebkitHeadlessProtoDOMTreeNodeAttribute]
    childDomTreeNodeIndex: _list[int]
    currentSourceUrl: str
    document: HtmlrenderWebkitHeadlessProtoDocument
    htmlTagType: int
    isClickable: bool
    name: str
    originUrl: str
    referencedResourceIndex: _list[int]
    renderTreeNodeIndex: _list[int]
    type: typing_extensions.Literal[
        "ELEMENT_NODE",
        "ATTRIBUTE_NODE",
        "TEXT_NODE",
        "CDATA_SECTION_NODE",
        "ENTITY_REFERENCE_NODE",
        "ENTITY_NODE",
        "PROCESSING_INSTRUCTION_NODE",
        "COMMENT_NODE",
        "DOCUMENT_NODE",
        "DOCUMENT_TYPE_NODE",
        "DOCUMENT_FRAGMENT_NODE",
        "NOTATION_NODE",
        "XPATH_NAMESPACE_NODE",
        "SHADOW_ROOT_NODE",
    ]
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoDOMTreeNodeAttribute(
    typing_extensions.TypedDict, total=False
):
    htmlAttributeType: int
    name: str
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoDocument(typing_extensions.TypedDict, total=False):
    baseUri: str
    charset: str
    contentHeight: int
    contentLanguage: str
    contentWidth: int
    domTreeNode: _list[HtmlrenderWebkitHeadlessProtoDOMTreeNode]
    frameId: str
    frameName: str
    javascriptTimeOfDay: float
    redirectHop: _list[HtmlrenderWebkitHeadlessProtoRedirectHop]
    referencedResource: _list[HtmlrenderWebkitHeadlessProtoReferencedResource]
    renderEvent: _list[HtmlrenderWebkitHeadlessProtoRenderEvent]
    renderStyle: _list[HtmlrenderWebkitHeadlessProtoStyle]
    renderTreeNode: _list[HtmlrenderWebkitHeadlessProtoRenderTreeNode]
    renderTreeQualityScore: float
    renderedContentArea: HtmlrenderWebkitHeadlessProtoBox
    scrollX: int
    scrollY: int
    snapshotQualityScore: float
    title: str
    uri: str
    viewport: HtmlrenderWebkitHeadlessProtoBox

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoFrameResizeEvent(
    typing_extensions.TypedDict, total=False
):
    resizeType: typing_extensions.Literal[
        "UNKNOWN",
        "AUTOMATIC_FRAME_EXPANSION_TO_CONTENT_WIDTH",
        "AUTOMATIC_FRAME_EXPANSION_TO_CONTENT_HEIGHT",
    ]
    visibleRectAfterResize: HtmlrenderWebkitHeadlessProtoBox
    visibleRectBeforeResize: HtmlrenderWebkitHeadlessProtoBox

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoImage(typing_extensions.TypedDict, total=False):
    data: str
    height: int
    pageNumber: int
    viewport: HtmlrenderWebkitHeadlessProtoBox
    width: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoInitialLoadEvent(
    typing_extensions.TypedDict, total=False
):
    url: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoModalDialogEvent(
    typing_extensions.TypedDict, total=False
):
    confirmed: bool
    message: str
    result: str
    type: typing_extensions.Literal["CONFIRM", "PROMPT", "ALERT"]

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoOffset(typing_extensions.TypedDict, total=False):
    unit: typing_extensions.Literal["PIXELS", "PERCENT"]
    value: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoPartialRender(
    typing_extensions.TypedDict, total=False
):
    cookie: _list[HtmlrenderWebkitHeadlessProtoCookie]
    currentClientUrl: str
    document: HtmlrenderWebkitHeadlessProtoDocument
    id: str
    image: HtmlrenderWebkitHeadlessProtoImage

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoPdf(typing_extensions.TypedDict, total=False):
    data: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRectangle(typing_extensions.TypedDict, total=False):
    bottom: HtmlrenderWebkitHeadlessProtoOffset
    left: HtmlrenderWebkitHeadlessProtoOffset
    right: HtmlrenderWebkitHeadlessProtoOffset
    top: HtmlrenderWebkitHeadlessProtoOffset

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRedirectEvent(
    typing_extensions.TypedDict, total=False
):
    httpMethod: typing_extensions.Literal["OTHER_HTTP_METHOD", "GET", "POST"]
    httpStatusCode: int
    refreshType: typing_extensions.Literal["HTTP_REFRESH", "META_HTTP_EQUIV_REFRESH"]
    targetContentDownloaded: bool
    targetUrl: str
    type: typing_extensions.Literal[
        "UNKNOWN_REDIRECT_TYPE", "HTTP", "SCRIPT", "REFRESH"
    ]

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRedirectHop(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal["SERVER", "CLIENT"]
    url: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoReferencedResource(
    typing_extensions.TypedDict, total=False
):
    canceled: bool
    contentType: int
    domTreeNodeIndex: _list[int]
    failedHttpAccessControlCheck: bool
    fetchSourceInfo: _list[WirelessTranscoderFetchFetchSourceInfo]
    fetchStatus: typing_extensions.Literal[
        "SUCCESS",
        "TIMEOUT",
        "CONNECTION_ERROR",
        "IO_ERROR",
        "RPC_ERROR",
        "INTERRUPTED",
        "UNSUPPORTED_PROTOCOL",
        "MALFORMED_URL",
        "TOO_MANY_REDIRECTS",
        "MALFORMED_RESPONSE",
        "NOT_PERMITTED",
        "CERTIFICATE_ERROR",
        "INVALID_REQUEST",
        "BUSY",
        "INVALID_CUSTOM_PARAMS",
        "NOT_HANDLED",
    ]
    httpHeader: _list[HtmlrenderWebkitHeadlessProtoReferencedResourceHttpHeader]
    httpResponseCode: int
    metadata: _list[WirelessTranscoderFetchFetchMetadata]
    postData: str
    redirectTarget: str
    referencedResourceContentIndex: int
    requestHeader: _list[HtmlrenderWebkitHeadlessProtoReferencedResourceHttpHeader]
    requestMethod: int
    styleIndex: _list[int]
    synchronouslyFetched: bool
    timing: _list[HtmlrenderWebkitHeadlessProtoReferencedResourceFetchTiming]
    url: str
    webkitMetadata: HtmlrenderWebkitHeadlessProtoWebKitFetchMetadata

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoReferencedResourceFetchTiming(
    typing_extensions.TypedDict, total=False
):
    finishMsec: str
    name: str
    startMsec: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoReferencedResourceHttpHeader(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderEvent(
    typing_extensions.TypedDict, total=False
):
    frameResize: HtmlrenderWebkitHeadlessProtoFrameResizeEvent
    initialLoad: HtmlrenderWebkitHeadlessProtoInitialLoadEvent
    modalDialog: HtmlrenderWebkitHeadlessProtoModalDialogEvent
    redirect: HtmlrenderWebkitHeadlessProtoRedirectEvent
    scriptOriginUrl: str
    virtualTimeOffset: float
    windowOpen: HtmlrenderWebkitHeadlessProtoWindowOpenEvent

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderExtensionResult(
    typing_extensions.TypedDict, total=False
):
    consoleLogEntry: _list[HtmlrenderWebkitHeadlessProtoConsoleLogEntry]
    result: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderResponse(
    typing_extensions.TypedDict, total=False
):
    chromiumTrace: HtmlrenderWebkitHeadlessProtoChromiumTrace
    cookie: _list[HtmlrenderWebkitHeadlessProtoCookie]
    document: HtmlrenderWebkitHeadlessProtoDocument
    exceptionDetail: str
    exceptions: str
    extensionResult: HtmlrenderWebkitHeadlessProtoRenderExtensionResult
    finalClientUrl: str
    image: _list[HtmlrenderWebkitHeadlessProtoImage]
    localStorage: _list[HtmlrenderWebkitHeadlessProtoDOMStorageItem]
    partialRender: _list[HtmlrenderWebkitHeadlessProtoPartialRender]
    pdf: HtmlrenderWebkitHeadlessProtoPdf
    referencedResourceContent: _list[HtmlrenderWebkitHeadlessProtoResource]
    renderStats: HtmlrenderWebkitHeadlessProtoRenderStats
    sessionStorage: _list[HtmlrenderWebkitHeadlessProtoDOMStorageItem]
    title: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderStats(
    typing_extensions.TypedDict, total=False
):
    anonRenderFineTimingStats: _list[HtmlrenderWebkitHeadlessProtoAnonTimingStatPair]
    consoleLogEntry: _list[HtmlrenderWebkitHeadlessProtoConsoleLogEntry]
    counter: _list[HtmlrenderWebkitHeadlessProtoRenderStatsCounter]
    documentBuildTimeMsec: int
    droppedLogEntryCount: int
    imageEncodingTimeMsec: int
    imageScalingTimeMsec: int
    layoutTimeMsec: int
    paintTimeMsec: int
    renderCostMgcu: int
    renderEngine: typing_extensions.Literal[
        "UNKNOWN", "BLINK_HEADLESS", "CHROME_HEADLESS", "UNKNOWN_DUE_TO_RPC_FAILURE"
    ]
    renderRunningTimeMsec: int
    renderServerBaselineCl: str
    renderTimeMsec: int
    sandboxRenderTimeMsec: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderStatsCounter(
    typing_extensions.TypedDict, total=False
):
    count: str
    name: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderTreeNode(
    typing_extensions.TypedDict, total=False
):
    box: HtmlrenderWebkitHeadlessProtoBox
    childRenderTreeNodeIndex: _list[int]
    domTreeNodeIndex: int
    inlineTextBox: _list[HtmlrenderWebkitHeadlessProtoRenderTreeNodeInlineTextBox]
    renderedText: str
    styleIndex: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoRenderTreeNodeInlineTextBox(
    typing_extensions.TypedDict, total=False
):
    box: HtmlrenderWebkitHeadlessProtoBox
    renderedText: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoResource(typing_extensions.TypedDict, total=False):
    content: str
    fetchSourceInfo: _list[WirelessTranscoderFetchFetchSourceInfo]
    finalContentUrl: str
    metadata: _list[WirelessTranscoderFetchFetchMetadata]
    method: int
    postData: str
    requestHeader: _list[HtmlrenderWebkitHeadlessProtoResourceHttpHeader]
    url: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoResourceHttpHeader(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoScriptStackFrame(
    typing_extensions.TypedDict, total=False
):
    columnNumber: int
    functionName: str
    lineNumber: int
    url: str

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoStyle(typing_extensions.TypedDict, total=False):
    backgroundAttachment: typing_extensions.Literal["SCROLL", "FIXED"]
    backgroundColorArgb: int
    backgroundGradientColorStopArgb: _list[int]
    backgroundGradientRepeat: bool
    backgroundGradientType: typing_extensions.Literal["LINEAR", "RADIAL"]
    backgroundImageRepeat: typing_extensions.Literal[
        "NO_REPEAT", "REPEAT", "REPEAT_X", "REPEAT_Y"
    ]
    backgroundImageUrl: str
    backgroundImageXPos: HtmlrenderWebkitHeadlessProtoOffset
    backgroundImageYPos: HtmlrenderWebkitHeadlessProtoOffset
    backgroundSize: typing_extensions.Literal[
        "CONTAIN", "COVER", "SIZE_LENGTH", "SIZE_NONE"
    ]
    backgroundSizeHeight: HtmlrenderWebkitHeadlessProtoOffset
    backgroundSizeWidth: HtmlrenderWebkitHeadlessProtoOffset
    borderColorArgbBottom: int
    borderColorArgbLeft: int
    borderColorArgbRight: int
    borderColorArgbTop: int
    borderPixelWidthBottom: int
    borderPixelWidthLeft: int
    borderPixelWidthRight: int
    borderPixelWidthTop: int
    borderStyleBottom: typing_extensions.Literal[
        "BNONE",
        "BHIDDEN",
        "INSET",
        "GROOVE",
        "RIDGE",
        "OUTSET",
        "DOTTED",
        "DASHED",
        "SOLID",
        "DOUBLE",
    ]
    borderStyleLeft: typing_extensions.Literal[
        "BNONE",
        "BHIDDEN",
        "INSET",
        "GROOVE",
        "RIDGE",
        "OUTSET",
        "DOTTED",
        "DASHED",
        "SOLID",
        "DOUBLE",
    ]
    borderStyleRight: typing_extensions.Literal[
        "BNONE",
        "BHIDDEN",
        "INSET",
        "GROOVE",
        "RIDGE",
        "OUTSET",
        "DOTTED",
        "DASHED",
        "SOLID",
        "DOUBLE",
    ]
    borderStyleTop: typing_extensions.Literal[
        "BNONE",
        "BHIDDEN",
        "INSET",
        "GROOVE",
        "RIDGE",
        "OUTSET",
        "DOTTED",
        "DASHED",
        "SOLID",
        "DOUBLE",
    ]
    clip: HtmlrenderWebkitHeadlessProtoRectangle
    direction: typing_extensions.Literal["LTR", "RTL"]
    display: typing_extensions.Literal["BLOCK", "INLINE", "INLINE_BLOCK"]
    fontFamily: str
    fontSize: int
    fontStyle: typing_extensions.Literal["FONT_NORMAL", "FONT_ITALIC"]
    fontWeight: int
    foregroundColorArgb: int
    hasBackground: bool
    listStyleImageUrl: str
    listStyleType: typing_extensions.Literal[
        "DEFAULT_DISC",
        "CIRCLE",
        "SQUARE",
        "DECIMAL_LIST_STYLE",
        "DECIMAL_LEADING_ZERO",
        "ARABIC_INDIC",
        "BINARY_LIST_STYLE",
        "BENGALI",
        "CAMBODIAN",
        "KHMER",
        "DEVANAGARI",
        "GUJARATI",
        "GURMUKHI",
        "KANNADA",
        "LOWER_HEXADECIMAL",
        "LAO",
        "MALAYALAM",
        "MONGOLIAN",
        "MYANMAR",
        "OCTAL",
        "ORIYA",
        "PERSIAN",
        "URDU",
        "TELUGU",
        "TIBETAN",
        "THAI",
        "UPPER_HEXADECIMAL",
        "LOWER_ROMAN",
        "UPPER_ROMAN",
        "LOWER_GREEK",
        "LOWER_ALPHA",
        "LOWER_LATIN",
        "UPPER_ALPHA",
        "UPPER_LATIN",
        "AFAR",
        "ETHIOPIC_HALEHAME_AA_ET",
        "ETHIOPIC_HALEHAME_AA_ER",
        "AMHARIC",
        "ETHIOPIC_HALEHAME_AM_ET",
        "AMHARIC_ABEGEDE",
        "ETHIOPIC_ABEGEDE_AM_ET",
        "CJK_EARTHLY_BRANCH",
        "CJK_HEAVENLY_STEM",
        "ETHIOPIC",
        "ETHIOPIC_HALEHAME_GEZ",
        "ETHIOPIC_ABEGEDE",
        "ETHIOPIC_ABEGEDE_GEZ",
        "HANGUL_CONSONANT",
        "HANGUL",
        "LOWER_NORWEGIAN",
        "OROMO",
        "ETHIOPIC_HALEHAME_OM_ET",
        "SIDAMA",
        "ETHIOPIC_HALEHAME_SID_ET",
        "SOMALI",
        "ETHIOPIC_HALEHAME_SO_ET",
        "TIGRE",
        "ETHIOPIC_HALEHAME_TIG",
        "TIGRINYA_ER",
        "ETHIOPIC_HALEHAME_TI_ER",
        "TIGRINYA_ER_ABEGEDE",
        "ETHIOPIC_ABEGEDE_TI_ER",
        "TIGRINYA_ET",
        "ETHIOPIC_HALEHAME_TI_ET",
        "TIGRINYA_ET_ABEGEDE",
        "ETHIOPIC_ABEGEDE_TI_ET",
        "UPPER_GREEK",
        "UPPER_NORWEGIAN",
        "ASTERISKS",
        "FOOTNOTES",
        "HEBREW",
        "ARMENIAN",
        "LOWER_ARMENIAN",
        "UPPER_ARMENIAN",
        "GEORGIAN",
        "CJK_IDEOGRAPHIC",
        "HIRAGANA",
        "KATAKANA",
        "HIRAGANA_IROHA",
        "KATAKANA_IROHA",
        "NONE_LIST_STYLE",
    ]
    marginBottom: HtmlrenderWebkitHeadlessProtoOffset
    marginLeft: HtmlrenderWebkitHeadlessProtoOffset
    marginRight: HtmlrenderWebkitHeadlessProtoOffset
    marginTop: HtmlrenderWebkitHeadlessProtoOffset
    opacity: float
    overflowX: typing_extensions.Literal[
        "OVISIBLE", "OHIDDEN", "OSCROLL", "OAUTO", "OOVERLAY", "OMARQUEE"
    ]
    overflowY: typing_extensions.Literal[
        "OVISIBLE", "OHIDDEN", "OSCROLL", "OAUTO", "OOVERLAY", "OMARQUEE"
    ]
    paddingBottom: HtmlrenderWebkitHeadlessProtoOffset
    paddingLeft: HtmlrenderWebkitHeadlessProtoOffset
    paddingRight: HtmlrenderWebkitHeadlessProtoOffset
    paddingTop: HtmlrenderWebkitHeadlessProtoOffset
    position: typing_extensions.Literal[
        "POSITION_STATIC", "POSITION_RELATIVE", "POSITION_ABSOLUTE", "POSITION_FIXED"
    ]
    referencedResourceIndex: _list[int]
    textAlign: typing_extensions.Literal[
        "DEFAULT_TASTART",
        "LEFT",
        "RIGHT",
        "CENTER",
        "JUSTIFY",
        "WEBKIT_LEFT",
        "WEBKIT_RIGHT",
        "WEBKIT_CENTER",
        "TAEND",
    ]
    textDecoration: typing_extensions.Literal["NONE", "UNDERLINED", "LINE_THROUGH"]
    textShadowColorArgb: int
    visibility: typing_extensions.Literal["VISIBLE", "HIDDEN", "COLLAPSE"]
    zIndex: int

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoWebKitFetchMetadata(
    typing_extensions.TypedDict, total=False
):
    devtoolsFrameId: str
    targetType: typing_extensions.Literal[
        "TARGET_UNSPECIFIED",
        "TARGET_MAIN_FRAME",
        "TARGET_SUBFRAME",
        "TARGET_SUBRESOURCE",
        "TARGET_STYLE_SHEET",
        "TARGET_SCRIPT",
        "TARGET_FONT",
        "TARGET_IMAGE",
        "TARGET_OBJECT",
        "TARGET_MEDIA",
        "TARGET_WORKER",
        "TARGET_SHARED_WORKER",
        "TARGET_PREFETCH",
        "TARGET_FAVICON",
        "TARGET_XHR",
        "TARGET_TEXT_TRACK",
        "TARGET_BEACON",
        "TARGET_FILE",
        "TARGET_MANIFEST",
        "TARGET_PING",
        "TARGET_RAW",
        "TARGET_EVENT_SOURCE",
    ]

@typing.type_check_only
class HtmlrenderWebkitHeadlessProtoWindowOpenEvent(
    typing_extensions.TypedDict, total=False
):
    allowed: bool
    url: str
    windowFeatures: str
    windowName: str

@typing.type_check_only
class I18nPhonenumbersPhoneNumber(typing_extensions.TypedDict, total=False):
    countryCode: int
    countryCodeSource: typing_extensions.Literal[
        "UNSPECIFIED",
        "FROM_NUMBER_WITH_PLUS_SIGN",
        "FROM_NUMBER_WITH_IDD",
        "FROM_NUMBER_WITHOUT_PLUS_SIGN",
        "FROM_DEFAULT_COUNTRY",
    ]
    extension: str
    italianLeadingZero: bool
    nationalNumber: str
    numberOfLeadingZeros: int
    preferredDomesticCarrierCode: str
    rawInput: str

@typing.type_check_only
class ImageBaseThumbnailMetadata(typing_extensions.TypedDict, total=False):
    byteSize: int
    crops: ContentAwareCropsIndexing
    deepCrop: DeepCropIndexing
    deepCropPixels: DeepCropPixels
    docid: str
    encryptedDocid: str
    fprint: str
    height: int
    mimeType: str
    originalHeight: int
    originalWidth: int
    type: typing_extensions.Literal[
        "THUMBNAIL_TYPE_DEFAULT",
        "THUMBNAIL_TYPE_AREA_50K",
        "THUMBNAIL_TYPE_400",
        "THUMBNAIL_TYPE_800",
        "THUMBNAIL_TYPE_ORIGINAL",
        "THUMBNAIL_TYPE_ORIGINAL_HQ",
        "THUMBNAIL_TYPE_FAVICON_16",
        "THUMBNAIL_TYPE_FAVICON_28",
        "THUMBNAIL_TYPE_FAVICON_32",
        "THUMBNAIL_TYPE_FAVICON_64",
        "THUMBNAIL_TYPE_FAVICON_ORIGINAL",
        "THUMBNAIL_TYPE_FAVICON_16_DARK",
        "THUMBNAIL_TYPE_FAVICON_28_DARK",
        "THUMBNAIL_TYPE_FAVICON_32_DARK",
        "THUMBNAIL_TYPE_FAVICON_64_DARK",
        "THUMBNAIL_TYPE_FAVICON_ORIGINAL_DARK",
        "THUMBNAIL_TYPE_1080",
        "THUMBNAIL_TYPE_1600_HQ",
        "THUMBNAIL_TYPE_AREA_300K",
        "THUMBNAIL_TYPE_AREA_50K_ALPHA",
        "THUMBNAIL_TYPE_AREA_50K_SYNTHETIC_ALPHA",
        "THUMBNAIL_TYPE_AREA_2M",
        "THUMBNAIL_TYPE_AREA_2M_METADATA",
        "THUMBNAIL_TYPE_800_ALPHA_WHITE",
        "THUMBNAIL_TYPE_ORIGINAL_ALPHA_WHITE",
        "THUMBNAIL_TYPE_ANIMATED_H144",
        "THUMBNAIL_TYPE_ORIGINAL_HQ_LICENSED",
        "THUMBNAIL_TYPE_TENOR_250K_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_GIF",
        "THUMBNAIL_TYPE_TENOR_30K_OPTIMIZED_THUMBNAIL_GIF",
        "THUMBNAIL_TYPE_TENOR_45K_OPTIMIZED_90P_GIF",
        "THUMBNAIL_TYPE_TENOR_50K_OPTIMIZED_100P_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_200P_GIF",
        "THUMBNAIL_TYPE_TENOR_50K_OPTIMIZED_100W_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_200W_GIF",
        "THUMBNAIL_TYPE_TENOR_45K_PREVIEW_GIF",
        "THUMBNAIL_TYPE_TENOR_250K_MEDIUM_GIF",
        "THUMBNAIL_TYPE_AREA_2M_WEBP",
        "THUMBNAIL_TYPE_AREA_2M_WEBP_METADATA",
        "THUMBNAIL_TYPE_AREA_2M_AVIF",
        "THUMBNAIL_TYPE_AREA_2M_AVIF_METADATA",
        "THUMBNAIL_TYPE_AREA_50K_WEBP",
        "THUMBNAIL_TYPE_AREA_50K_AVIF",
        "THUMBNAIL_TYPE_ORIGINAL_HQ_KG",
    ]
    width: int

@typing.type_check_only
class ImageBaseVideoPreviewMetadata(typing_extensions.TypedDict, total=False):
    byteSize: int
    docid: str
    duration: int
    expirationTimestampMicros: str
    fprint: str
    height: int
    mimeType: str
    state: typing_extensions.Literal[
        "STATE_UNKNOWN",
        "STATE_DONE",
        "STATE_NOT_APPLICABLE",
        "STATE_MISSING",
        "STATE_DELETED",
        "STATE_DIRTY",
        "STATE_OBSOLETE",
        "STATE_PENDING_PUBLICATION",
        "STATE_FAILED",
    ]
    timestamp: int
    type: typing_extensions.Literal[
        "VPREVIEW_TYPE_8K",
        "VPREVIEW_TYPE_30K",
        "VPREVIEW_TYPE_90K",
        "VPREVIEW_TYPE_300K_24FPS",
        "VPREVIEW_TYPE_VERTICAL_30K",
        "VPREVIEW_TYPE_VERTICAL_90K",
        "VPREVIEW_TYPE_540K_ORIGINAL_HQ_LICENSED",
        "VPREVIEW_TYPE_90K_SPORT_HIGHLIGHT",
        "VPREVIEW_TYPE_VIDEO_ANSWER_300K_15SEC",
        "VPREVIEW_TYPE_VIDEO_ANSWER_300K_6SEC",
        "VPREVIEW_TENOR_250K_PREVIEW",
        "VPREVIEW_TENOR_100K_OPTIMIZED_PREVIEW",
        "VPREVIEW_TENOR_30K_OPTIMIZED_THUMBNAIL_PREVIEW",
        "VPREVIEW_TENOR_45K_OPTIMIZED_90P_PREVIEW",
        "VPREVIEW_TENOR_50K_OPTIMIZED_100P_PREVIEW",
        "VPREVIEW_TENOR_100K_OPTIMIZED_200P_PREVIEW",
        "VPREVIEW_TENOR_50K_OPTIMIZED_100W_PREVIEW",
        "VPREVIEW_TENOR_100K_OPTIMIZED_200W_PREVIEW",
        "VPREVIEW_TENOR_250K_MEDIUM_PREVIEW",
        "VPREVIEW_TENOR_250K_TINY_VIDEO_PREVIEW",
        "VPREVIEW_TENOR_250K_NANO_VIDEO_PREVIEW",
        "VPREVIEW_TENOR_100K_PREVIEW_MP4",
        "VPREVIEW_TENOR_250K_MP4",
        "VPREVIEW_TENOR_250K_MP4_AV",
        "VPREVIEW_TENOR_160K_TINY_MP4",
        "VPREVIEW_TENOR_75K_NANO_MP4",
        "VPREVIEW_TENOR_50K_FIXED_100P_MP4",
        "VPREVIEW_TENOR_100K_FIXED_200P_MP4",
        "VPREVIEW_TENOR_50K_FIXED_100W_MP4",
        "VPREVIEW_TENOR_100K_FIXED_200W_MP4",
    ]
    videoSegmentEndUs: str
    videoSegmentStartUs: str
    width: int

@typing.type_check_only
class ImageContentFlowProtoProd(typing_extensions.TypedDict, total=False):
    starburst: _list[ImageContentStarburstVersionGroup]

@typing.type_check_only
class ImageContentQueryBoost(typing_extensions.TypedDict, total=False):
    queryboost: _list[ImageContentQueryBoostQueryBoost]

@typing.type_check_only
class ImageContentQueryBoostQueryBoost(typing_extensions.TypedDict, total=False):
    boost: float
    query: str

@typing.type_check_only
class ImageContentStarburstVersionGroup(typing_extensions.TypedDict, total=False):
    descriptorFloat: _list[float]
    descriptorShort: str
    enumVersion: typing_extensions.Literal[
        "UNKNOWN_VERSION",
        "STARBURST_V1",
        "STARBURST_V2",
        "STARBURST_V3",
        "STARBURST_V4",
        "STARBURST_VISUAL_V4",
        "STARBURST_V5",
        "STARBURST_V5_5",
        "STARBURST_V6",
        "STARBURST_EXP",
    ]
    minorVersion: typing_extensions.Literal[
        "UNKNOWN_MINOR_VERSION",
        "V3_ORIGINAL",
        "V3_ENET_EMULATED",
        "V3_FNET_EMULATED",
        "V3_STARBURST_LITE",
        "V4_ORIGINAL",
        "V4_STRETCH_RESIZE",
        "VISUAL_V4_ORIGINAL",
        "V5_ORIGINAL",
        "V5_5_ORIGINAL",
        "V6_ORIGINAL",
        "EXP_ORIGINAL",
    ]
    starburstTokens: _list[int]
    version: int

@typing.type_check_only
class ImageData(typing_extensions.TypedDict, total=False):
    adaboostImageFeaturePorn: float
    adaboostImageFeaturePornMinorVersion: int
    adaboostImageFeaturePornVersion: int
    animatedImageData: ImageRepositoryAnimatedImagePerdocData
    brainPornScores: ImageSafesearchContentBrainPornAnnotation
    brainPornScoresVersion: str
    canonicalDocid: str
    clickMagnetScore: float
    clipartDetectorScore: float
    clipartDetectorVersion: int
    clusterId: str
    codomainStrength: int
    colorScore: _list[float]
    colorScoreVersion: int
    coloredPixelsFrac: float
    contentFirstCrawlTime: int
    corpusSelectionInfo: _list[CorpusSelectionInfo]
    crops: ContentAwareCropsIndexing
    deepCrop: DeepCropIndexing
    deepImageEngagingness: ImageRepositoryDeepImageEngagingnessOutput
    deepTags: CommerceDatastoreImageDeepTags
    docid: str
    embeddedMetadata: ImageExifImageEmbeddedMetadata
    expirationTimestamp: str
    extendedExif: PhotosImageMetadata
    featuredImageProp: ImageMonetizationFeaturedImageProperties
    fileFormat: typing_extensions.Literal[
        "FF_INVALID",
        "FF_JPG",
        "FF_GIF",
        "FF_PNG",
        "FF_BMP",
        "FF_SVG",
        "FF_WEBP",
        "FF_ICO",
        "FF_CRAW",
        "FF_HEIF",
    ]
    finalPornScore: float
    finalPornScoreVersion: str
    firstCrawlTime: int
    firstTimeSeenOnDocSec: int
    flags: int
    flowOutput: ImageContentFlowProtoProd
    h2c: float
    h2i: float
    hateLogoDetection: ImageUnderstandingIndexingAnnotationGroup
    height: int
    imageContentQueryBoost: ImageContentQueryBoost
    imageExactBoost: ImageExactBoost
    imageLicenseInfo: ImageSearchImageLicenseInfo
    imageRegions: ImageRegionsImageRegions
    imagerank: int
    indexedVerticals: _list[ImageDataVerticalIndexingInfoImage]
    isIipInScope: bool
    isIndexedByImagesearch: bool
    isMultiframe: bool
    isUnwantedContent: bool
    isVisible: bool
    largestFaceFrac: float
    largestFaceFraction: int
    lastCrawlTime: int
    licensedWebImagesOptInState: typing_extensions.Literal[
        "IMAGES_OPTIN_NONE",
        "IMAGES_OPTIN_FULL",
        "PAGE_SNIPPET_CONTROL_SIZE_NONE",
        "PAGE_SNIPPET_CONTROL_SIZE_STANDARD",
        "PAGE_SNIPPET_CONTROL_SIZE_LARGE",
        "IMAGE_TAG_SNIPPET_CONTROL_SIZE_NONE",
        "IMAGE_TAG_SNIPPET_CONTROL_SIZE_STANDARD",
        "IMAGE_TAG_SNIPPET_CONTROL_SIZE_LARGE",
    ]
    lineartDetectorScore: float
    lineartDetectorVersion: int
    linkinfoType: str
    multibangKgEntities: ImageDataMultibangEntities
    nearDupFeatures: str
    nearDupFeaturesSmall: _list[str]
    nearDupFeaturesSmallVersion: int
    nearDupFeaturesVersion: int
    nimaAva: ImageRepositoryNimaOutput
    nimaVq: ImageRepositoryNimaOutput
    noIndexReason: _list[
        typing_extensions.Literal[
            "NO_INDEX_IMAGE_URL_NOT_SELECTED",
            "NO_INDEX_REFERRER_URL_NOT_SELECTED",
            "NO_INDEX_X_RAW_IMAGE",
            "NO_INDEX_FAVICON",
            "NO_INDEX_DETECTED_VIA_CONTENT",
            "NO_INDEX_EXTERNAL_VIDEO_THUMBNAIL",
            "NO_INDEX_ONSITE_ANCHOR",
            "NO_INDEX_RSS_FEED",
            "NO_INDEX_REJECTED_BY_IMAGE_SELECTION",
            "NO_INDEX_EXPIRED_THUMBNAIL",
            "NO_INDEX_REJECTED_BY_IMAGE_SELECTION_V1",
            "NO_INDEX_REJECTED_BY_PYTHIA",
            "NO_INDEX_EMPTY_THUMBNAIL",
        ]
    ]
    numberFaces: int
    ocrGoodoc: GoodocDocument
    ocrTaser: GoodocDocument
    ocrTextboxes: _list[OcrPhotoTextBox]
    onPageAlternateUrl: str
    orbitIntents: QualityOrbitOrbitImageIntents
    packedFullFaceInfo: FaceIndexing
    personAttributes: LensDiscoveryStylePersonAttributes
    personDetectionSignals: LensDiscoveryStylePersonDetectionSignals
    photoDetectorScore: float
    photoDetectorVersion: int
    pornFlagData: PornFlagData
    precomputedRestricts: PrecomputedRestricts
    rankInNeardupCluster: int
    restrictStrings: _list[str]
    robotedAgents: str
    shoppingProductInformation: ImageRepositoryShoppingProductInformation
    size: int
    smearedTopWebLandingPageDocids: _list[str]
    smearedTopWebLandingPages: _list[SmearedWebLandingPageEntry]
    styleAestheticsScore: LensDiscoveryStyleAestheticsScoreSignals
    styleImageType: LensDiscoveryStyleStyleImageTypeSignals
    testingScore: int
    thumbHeight: int
    thumbSize: int
    thumbWidth: int
    thumbnail: _list[ImageDataThumbnail]
    unavailableAfterSecs: str
    url: str
    whiteBackgroundScore: float
    whiteBackgroundScoreVersion: int
    width: int

@typing.type_check_only
class ImageDataMultibangEntities(typing_extensions.TypedDict, total=False):
    entity: _list[ImageDataMultibangEntitiesMultibangEntity]

@typing.type_check_only
class ImageDataMultibangEntitiesMultibangEntity(
    typing_extensions.TypedDict, total=False
):
    entityId: str
    score: float

@typing.type_check_only
class ImageDataThumbnail(typing_extensions.TypedDict, total=False):
    expirationTimestampMicros: str
    height: int
    mimeType: str
    size: int
    type: typing_extensions.Literal[
        "THUMBNAIL_TYPE_DEFAULT",
        "THUMBNAIL_TYPE_AREA_50K",
        "THUMBNAIL_TYPE_400",
        "THUMBNAIL_TYPE_800",
        "THUMBNAIL_TYPE_ORIGINAL",
        "THUMBNAIL_TYPE_ORIGINAL_HQ",
        "THUMBNAIL_TYPE_FAVICON_16",
        "THUMBNAIL_TYPE_FAVICON_28",
        "THUMBNAIL_TYPE_FAVICON_32",
        "THUMBNAIL_TYPE_FAVICON_64",
        "THUMBNAIL_TYPE_FAVICON_ORIGINAL",
        "THUMBNAIL_TYPE_FAVICON_16_DARK",
        "THUMBNAIL_TYPE_FAVICON_28_DARK",
        "THUMBNAIL_TYPE_FAVICON_32_DARK",
        "THUMBNAIL_TYPE_FAVICON_64_DARK",
        "THUMBNAIL_TYPE_FAVICON_ORIGINAL_DARK",
        "THUMBNAIL_TYPE_1080",
        "THUMBNAIL_TYPE_1600_HQ",
        "THUMBNAIL_TYPE_AREA_300K",
        "THUMBNAIL_TYPE_AREA_50K_ALPHA",
        "THUMBNAIL_TYPE_AREA_50K_SYNTHETIC_ALPHA",
        "THUMBNAIL_TYPE_AREA_2M",
        "THUMBNAIL_TYPE_AREA_2M_METADATA",
        "THUMBNAIL_TYPE_800_ALPHA_WHITE",
        "THUMBNAIL_TYPE_ORIGINAL_ALPHA_WHITE",
        "THUMBNAIL_TYPE_ANIMATED_H144",
        "THUMBNAIL_TYPE_ORIGINAL_HQ_LICENSED",
        "THUMBNAIL_TYPE_TENOR_250K_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_GIF",
        "THUMBNAIL_TYPE_TENOR_30K_OPTIMIZED_THUMBNAIL_GIF",
        "THUMBNAIL_TYPE_TENOR_45K_OPTIMIZED_90P_GIF",
        "THUMBNAIL_TYPE_TENOR_50K_OPTIMIZED_100P_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_200P_GIF",
        "THUMBNAIL_TYPE_TENOR_50K_OPTIMIZED_100W_GIF",
        "THUMBNAIL_TYPE_TENOR_100K_OPTIMIZED_200W_GIF",
        "THUMBNAIL_TYPE_TENOR_45K_PREVIEW_GIF",
        "THUMBNAIL_TYPE_TENOR_250K_MEDIUM_GIF",
        "THUMBNAIL_TYPE_AREA_2M_WEBP",
        "THUMBNAIL_TYPE_AREA_2M_WEBP_METADATA",
        "THUMBNAIL_TYPE_AREA_2M_AVIF",
        "THUMBNAIL_TYPE_AREA_2M_AVIF_METADATA",
        "THUMBNAIL_TYPE_AREA_50K_WEBP",
        "THUMBNAIL_TYPE_AREA_50K_AVIF",
        "THUMBNAIL_TYPE_ORIGINAL_HQ_KG",
    ]
    width: int

@typing.type_check_only
class ImageDataVerticalIndexingInfoImage(typing_extensions.TypedDict, total=False):
    name: str

@typing.type_check_only
class ImageExactBoost(typing_extensions.TypedDict, total=False):
    navquery: _list[ImageExactBoostNavQuery]

@typing.type_check_only
class ImageExactBoostNavQuery(typing_extensions.TypedDict, total=False):
    confidence: int
    imageClickRank: int
    navFp: str
    navQuery: str
    referrerDocid: _list[str]
    referrerRank: int

@typing.type_check_only
class ImageExifIPTCMetadata(typing_extensions.TypedDict, total=False):
    acquireLicensePage: str
    artwork: _list[ImageExifIPTCMetadataArtwork]
    contactinfo: ImageExifIPTCMetadataContactInfo
    copyrightNotice: str
    creator: _list[str]
    creditLine: str
    dateCreated: str
    dateExpired: str
    dateReleased: str
    description: str
    digitalSourceType: typing_extensions.Literal[
        "DST_NOT_RECORDED",
        "DST_TRAINED_ALGORITHMIC_MEDIA",
        "DST_COMPOSITE_SYNTHETIC",
        "DST_ALGORITHMIC_MEDIA",
    ]
    event: str
    headline: str
    imageSupplier: str
    instructions: str
    keywords: _list[str]
    licenseUrl: str
    location: ImageExifIPTCMetadataLocation
    locationCreated: ImageExifIPTCMetadataLocationInfo
    locationShown: _list[ImageExifIPTCMetadataLocationInfo]
    modelReleaseStatus: typing_extensions.Literal[
        "MR_UNKNOWN",
        "MR_NONE",
        "MR_NOT_APPLICABLE",
        "MR_UNLIMITED",
        "MR_LIMITED_OR_INCOMPLETE",
    ]
    propertyReleaseStatus: typing_extensions.Literal[
        "PR_UNKNOWN",
        "PR_NONE",
        "PR_NOT_APPLICABLE",
        "PR_UNLIMITED",
        "PR_LIMITED_OR_INCOMPLETE",
    ]
    rightsUsageTerms: str
    source: str
    supplementalCategories: _list[str]
    title: str

@typing.type_check_only
class ImageExifIPTCMetadataArtwork(typing_extensions.TypedDict, total=False):
    title: str

@typing.type_check_only
class ImageExifIPTCMetadataContactInfo(typing_extensions.TypedDict, total=False):
    address: str
    city: str
    country: str
    email: str
    phone: str
    postalCode: str
    state: str
    webUrl: str

@typing.type_check_only
class ImageExifIPTCMetadataLocation(typing_extensions.TypedDict, total=False):
    city: str
    country: str
    countryCode: str
    state: str
    subLocation: str
    worldRegion: str

@typing.type_check_only
class ImageExifIPTCMetadataLocationInfo(typing_extensions.TypedDict, total=False):
    city: str
    country: str
    countryCode: str
    state: str
    subLocation: str
    worldRegion: str

@typing.type_check_only
class ImageExifImageEmbeddedMetadata(typing_extensions.TypedDict, total=False):
    altitude: float
    aperture: float
    author: str
    author2: str
    brightness: float
    cameraMaker: str
    cameraModel: str
    cameraSerialNumber: str
    captureTime: str
    colorSpace: int
    comments: str
    comments2: str
    continousDriveMode: bool
    copyright: str
    deprecatedCity: str
    deprecatedCountry: str
    deprecatedState: str
    description: str
    destBearing: float
    destBearingRef: float
    destDistance: float
    destLatitude: float
    destLongitude: float
    digitalZoomRatio: float
    exposureBias: float
    exposureProgram: int
    exposureTime: float
    flashUsed: bool
    focalLength: float
    focalLength35mm: float
    focalPlaneResUnit: int
    focalPlaneXres: float
    focusMode: typing_extensions.Literal[
        "MANUAL_FOCUS", "AF_ONE_SHOT", "AF_CONTINUOUS", "AF_AUTO", "OTHER_FOCUS"
    ]
    gpsDop: float
    gpsMeasureMode: typing_extensions.Literal["MEASURE_MODE_2D", "MEASURE_MODE_3D"]
    gpsStatus: typing_extensions.Literal["GPS_STATUS_ACTIVE", "GPS_STATUS_VOID"]
    hPositioningError: float
    imageHeight: int
    imageWidth: int
    imgDirection: float
    imgDirectionRef: typing_extensions.Literal[
        "DirectionRef_True", "DirectionRef_Magnetic"
    ]
    iptc: ImageExifIPTCMetadata
    iso: int
    keywords: str
    latitude: float
    lensId: str
    lensMaker: str
    lightSource: int
    longFocal: int
    longitude: float
    maxApertureAtLongFocal: float
    maxApertureAtShortFocal: float
    meteringMode: int
    modificationTime: str
    orientation: typing_extensions.Literal[
        "ORIENTATION_0_DEG",
        "ORIENTATION_MIRROR_0_DEG",
        "ORIENTATION_180_DEG",
        "ORIENTATION_MIRROR_180_DEG",
        "ORIENTATION_MIRROR_270_DEG",
        "ORIENTATION_90_DEG",
        "ORIENTATION_MIRROR_90_DEG",
        "ORIENTATION_270_DEG",
    ]
    shortFocal: int
    software: str
    subject: str
    subjectDistance: float
    subjectLocationX: int
    subjectLocationY: int
    title: str
    xResolution: float
    yResolution: float

@typing.type_check_only
class ImageMonetizationFeaturedImageProperties(
    typing_extensions.TypedDict, total=False
):
    inspirationScore: float

@typing.type_check_only
class ImageMoosedogCrawlState(typing_extensions.TypedDict, total=False):
    code: typing_extensions.Literal[
        "VALID_IMAGE",
        "INVALID_FETCH_REPLY",
        "XROBOTED",
        "URL_NOT_CRAWLED",
        "PARSE_ERROR",
        "INVALID_IMAGE",
        "IMS_CRAWL_NOT_MODIFIED",
        "EXPIRED_DISCOVERY_CRAWL",
        "EXPIRED_FEED_CRAWL",
        "EXPIRED_PRIORITY_FEED_CRAWL",
        "INVALID_URL",
        "VALID_VIDEO",
        "VALID_SWF",
        "VALID_SILVERLIGHT",
        "INVALID_VIDEO",
        "TRUNCATED_CONTENTS",
        "FAST_CRAWL_LOCK_ACQUIRE_FAILED",
        "FAST_CRAWL_TTL_EXPIRED",
    ]
    detailedReason: int
    internalStatus: UtilStatusProto
    isTerminal: bool
    noIndexAfterTimestamp: str
    notCrawledReason: typing_extensions.Literal[
        "URL_CRAWLED",
        "URL_ERROR",
        "URL_ROBOTED",
        "URL_UNREACHABLE",
        "URL_TIMEOUT",
        "URL_REJECTED",
        "URL_NOT_FOLLOWED",
        "NUM_STATE_TYPES",
    ]
    overrodeTerminalState: bool
    repid: str
    robotedAgents: str
    url: str
    urlDeleted: bool

@typing.type_check_only
class ImageMustangImageLinkSelectionInfo(typing_extensions.TypedDict, total=False):
    webRelevanceScore: float

@typing.type_check_only
class ImageMustangShoppingOffer(typing_extensions.TypedDict, total=False):
    inferredImageTypes: _list[
        typing_extensions.Literal[
            "UNKNOWN", "MERCHANT_IMAGE", "ML_INFERRED_IMAGE", "NEARDUP_INFERRED_IMAGE"
        ]
    ]
    ipsOfferId: str

@typing.type_check_only
class ImagePerDocData(typing_extensions.TypedDict, total=False):
    DEPRECATEDEntropyColor: int
    filename: str
    flags: int
    height: int
    width: int

@typing.type_check_only
class ImagePornDebugInfo(typing_extensions.TypedDict, total=False):
    info: str

@typing.type_check_only
class ImageQualitySensitiveMediaOrPeopleEntities(
    typing_extensions.TypedDict, total=False
):
    mediaEntitiesId: _list[str]
    peopleEntitiesId: _list[str]

@typing.type_check_only
class ImageRegionsImageRegion(typing_extensions.TypedDict, total=False):
    boundingBox: PhotosVisionGroundtruthdbNormalizedBoundingBox
    boundingBoxScore: float
    id: str
    isProduct: bool
    knnScore: float
    labelGroup: ImageUnderstandingIndexingLabelGroup
    labelVersion: str
    primaryLabel: ImageUnderstandingIndexingLabel
    renderType: typing_extensions.Literal[
        "UNSET",
        "DONT_RENDER",
        "RENDER_ONLY_BOUNDING_BOX",
        "RENDER_BOUNDING_BOX_AND_PRIMARY_LABEL",
    ]
    starburstV4: ImageUnderstandingIndexingFeature

@typing.type_check_only
class ImageRegionsImageRegions(typing_extensions.TypedDict, total=False):
    finalPornScore: float
    finalViolenceScore: float
    flowOutput: ImageContentFlowProtoProd
    has300kThumb: bool
    hasNavboost: bool
    isIuInappropriate: bool
    pedoScore: float
    precomputedRestricts: PrecomputedRestricts
    racyScore: float
    region: _list[ImageRegionsImageRegion]

@typing.type_check_only
class ImageRepositoryAmarnaCloudSpeechSignals(typing_extensions.TypedDict, total=False):
    duplicateOfYtS3Asr: bool
    langWithoutLocale: str
    langidInput: ImageRepositoryLanguageIdentificationResult
    modelIdentifier: str
    results: _list[ImageRepositorySpeechRecognitionResult]
    s3RecognizerMetadataResponse: ImageRepositoryS3RecognizerMetadataResponse
    transcriptAsr: PseudoVideoData

@typing.type_check_only
class ImageRepositoryAmarnaSignalsBlob(typing_extensions.TypedDict, total=False):
    frameFeatures: DrishtiFeatureSetDataSequence

@typing.type_check_only
class ImageRepositoryAmarnaSignalsBlobInfo(typing_extensions.TypedDict, total=False):
    signalsBlobId: str
    signalsBlobUpdateTimestamp: str

@typing.type_check_only
class ImageRepositoryAmarnaStatus(typing_extensions.TypedDict, total=False):
    reason: typing_extensions.Literal[
        "NOT_REJECTED",
        "INVALID_MEDIA",
        "TERMINAL_CRAWL_ERROR",
        "LOW_PRIORITY_REFERRER",
        "REMOVED_BY_CLIENT_REQUEST",
        "XROBOTED",
        "CONTENT_PROCESSING_ERROR",
        "MISSING_DOCID",
        "ROBOTED",
        "UNWANTED_CONTENT",
        "NOT_A_VIDEO",
        "INDEXING_DELAY",
    ]
    status: typing_extensions.Literal["READY", "REJECTED", "NOT_READY", "DEPRECATED_3"]

@typing.type_check_only
class ImageRepositoryAnimatedImagePerdocData(typing_extensions.TypedDict, total=False):
    aggregatedPornScores: ImageSafesearchContentBrainPornAnnotation
    durationMs: int

@typing.type_check_only
class ImageRepositoryApiItagSpecificMetadata(typing_extensions.TypedDict, total=False):
    expirationTimestampSec: str
    genus: typing_extensions.Literal[
        "GENUS_UNKNOWN",
        "GENUS_YT_HIGH_VALUE_CONTENT",
        "GENUS_YT_USER_GENERATED_CONTENT",
        "GENUS_GMAIL",
        "GENUS_KIDS_HUB",
        "GENUS_YOUTUBE_DIRECTOR",
        "GENUS_DCLK_VIDEO_ADS",
        "GENUS_DAI_PODCAST",
        "GENUS_TESTING",
        "GENUS_YT_UNPLUGGED_SVOD",
        "GENUS_YT_UNPLUGGED_DVR",
        "GENUS_HVC_INGESTION",
        "GENUS_DRIVE",
        "GENUS_YT_LIGHTWEIGHT_VIDEO",
        "GENUS_ASK_QNA",
        "GENUS_LOCAL_VIDEO",
        "GENUS_PLAY_AUDIOBOOKS",
        "GENUS_HANGOUTS_CHAT",
        "GENUS_VIDEO_INTEREST_FEED",
        "GENUS_YT_MUSIC",
        "GENUS_RECORDER",
        "GENUS_YT_ORIGINAL_CONTENT",
        "GENUS_STAMP",
        "GENUS_BULLETIN_AUDIO",
        "GENUS_CRAWL",
        "GENUS_PHOTOS",
        "GENUS_MATERIAL_GALLERY",
        "GENUS_YT_REFERENCE",
        "GENUS_LENSLETS_VIDEOS",
        "GENUS_BLOGGER",
        "GENUS_PODCASTS",
        "GENUS_OCEAN",
        "GENUS_LMS",
        "GENUS_WEB_VIDEO_ADS",
        "GENUS_STUDIO",
        "GENUS_YT_TDSD_REFERENCE",
        "GENUS_WEB_STORY",
        "GENUS_NEST_CAMERA_CLOUD",
        "GENUS_AREA120_BLUEBIRD",
        "GENUS_ARTS_AND_CULTURE",
        "GENUS_DEMO",
        "GENUS_KARTO",
        "GENUS_CONTRIB_SERVICE_SHARED",
        "GENUS_CONTRIB_SERVICE_GEO_UGC",
        "GENUS_CONTRIB_SERVICE_BARD_STORAGE",
        "GENUS_SEARCH_SPORTS",
        "GENUS_BUSINESSMESSAGING",
        "GENUS_AERIAL_VIEW",
        "GENUS_DOCS_FLIX_RENDER",
        "GENUS_SHOPPING",
    ]
    state: typing_extensions.Literal[
        "STATE_UNKNOWN",
        "STATE_DONE",
        "STATE_NOT_APPLICABLE",
        "STATE_MISSING",
        "STATE_DELETED",
        "STATE_DIRTY",
        "STATE_OBSOLETE",
        "STATE_PENDING_PUBLICATION",
        "STATE_FAILED",
    ]
    transcodeItag: int
    videoId: VideoAssetsVenomVideoId
    xtagsList: ImageRepositoryApiXtagList

@typing.type_check_only
class ImageRepositoryApiXtag(typing_extensions.TypedDict, total=False):
    name: str
    value: str

@typing.type_check_only
class ImageRepositoryApiXtagList(typing_extensions.TypedDict, total=False):
    xtags: _list[ImageRepositoryApiXtag]

@typing.type_check_only
class ImageRepositoryContentBasedVideoMetadata(
    typing_extensions.TypedDict, total=False
):
    amarnaDocid: str
    aresClassificationRequestTimestamp: str
    audioOnly: bool
    cloudSpeechSignals: ImageRepositoryAmarnaCloudSpeechSignals
    featureSetData: DrishtiFeatureSetData
    golden7SoapboxSummary: DrishtiFeatureSetData
    golden7SoapboxTracksBlobInfo: ImageRepositoryAmarnaSignalsBlobInfo
    inlinePlayback: VideoCrawlVideoInlinePlaybackMetadata
    languageIdentification: VideoTimedtextS4ALIResults
    legosAnnotationData: VideoLegosLegosAnnotationsSets
    lmsPreviewFramePerdocs: ImageRepositoryFramePerdocs
    loudnessData: VideoStorageLoudnessData
    mediaInfo: VideoMediaInfo
    multiThumbnailsFramePerdocs: ImageRepositoryFramePerdocs
    representativeFrameData: ImageData
    s3Asr: ImageRepositoryAmarnaCloudSpeechSignals
    s3LanguageIdentification: ImageRepositoryS3LangIdSignals
    safesearchVideoContentSignals: SafesearchVideoContentSignals
    searchDocid: str
    signalsBlob: ImageRepositoryAmarnaSignalsBlob
    signalsBlobInfo: ImageRepositoryAmarnaSignalsBlobInfo
    speechProperties: IndexingSpeechSpeechPropertiesProto
    thumbnailQualityScore: VideoThumbnailsThumbnailScore
    thumbnailerData: VideoPipelineViperThumbnailerColumnData
    transcodeMetadata: _list[ImageRepositoryApiItagSpecificMetadata]
    transcriptAsr: PseudoVideoData
    truncationInfo: ImageRepositoryFileTruncationInfo
    unwantedContent: ImageRepositoryUnwantedContent
    venomId: str
    venomProcessingInfo: ImageRepositoryVenomProcessingInfo
    videoAnchorSet: VideoContentSearchVideoAnchorSets
    videoDurationSec: float
    videoPornScore: float
    videoPornScoreV4: float
    videoPreviewBytes: _list[ImageRepositoryVideoPreviewsVideoPreview]
    videoPreviews: _list[ImageBaseVideoPreviewMetadata]
    videoStreamInfo: VideoPipelineViperVSIColumnData
    videoTranscriptAnnotations: QualityWebanswersVideoTranscriptAnnotations
    youtubeProcessingFilter: ImageRepositoryYoutubeProcessingFilter

@typing.type_check_only
class ImageRepositoryCrawlStatusInfo(typing_extensions.TypedDict, total=False):
    code: typing_extensions.Literal[
        "VALID_IMAGE",
        "INVALID_FETCH_REPLY",
        "XROBOTED",
        "URL_NOT_CRAWLED",
        "PARSE_ERROR",
        "INVALID_IMAGE",
        "IMS_CRAWL_NOT_MODIFIED",
        "EXPIRED_DISCOVERY_CRAWL",
        "EXPIRED_FEED_CRAWL",
        "EXPIRED_PRIORITY_FEED_CRAWL",
        "INVALID_URL",
        "VALID_VIDEO",
        "VALID_SWF",
        "VALID_SILVERLIGHT",
        "INVALID_VIDEO",
        "TRUNCATED_CONTENTS",
        "FAST_CRAWL_LOCK_ACQUIRE_FAILED",
        "FAST_CRAWL_TTL_EXPIRED",
    ]
    notCrawledReason: typing_extensions.Literal[
        "URL_CRAWLED",
        "URL_ERROR",
        "URL_ROBOTED",
        "URL_UNREACHABLE",
        "URL_TIMEOUT",
        "URL_REJECTED",
        "URL_NOT_FOLLOWED",
        "NUM_STATE_TYPES",
    ]

@typing.type_check_only
class ImageRepositoryDeepImageEngagingnessOutput(
    typing_extensions.TypedDict, total=False
):
    score: float

@typing.type_check_only
class ImageRepositoryFileTruncationInfo(typing_extensions.TypedDict, total=False):
    originalFileSizeLowerBoundBytes: str
    truncationState: typing_extensions.Literal["UNKNOWN", "COMPLETE", "TRUNCATED"]

@typing.type_check_only
class ImageRepositoryFrameIdentifier(typing_extensions.TypedDict, total=False):
    multiThumbnailVariant: ImageRepositoryFrameIdentifierMultiThumbnailVariant
    previewFrameZeroVariant: ImageRepositoryFrameIdentifierPreviewFrameZeroVariant
    thumbnailVariant: ImageRepositoryFrameIdentifierThumbnailVariant
    timestampMs: int

@typing.type_check_only
class ImageRepositoryFrameIdentifierMultiThumbnailVariant(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class ImageRepositoryFrameIdentifierPreviewFrameZeroVariant(
    typing_extensions.TypedDict, total=False
):
    previewLength: typing_extensions.Literal[
        "UNSPECIFIED", "THREE_SECONDS", "SIX_SECONDS"
    ]
    xtagList: ImageRepositoryApiXtagList

@typing.type_check_only
class ImageRepositoryFrameIdentifierThumbnailVariant(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class ImageRepositoryFramePerdoc(typing_extensions.TypedDict, total=False):
    frameIdentifier: ImageRepositoryFrameIdentifier
    perdoc: ImageData
    timestampMsec: int

@typing.type_check_only
class ImageRepositoryFramePerdocs(typing_extensions.TypedDict, total=False):
    framePerdoc: _list[ImageRepositoryFramePerdoc]

@typing.type_check_only
class ImageRepositoryLanguageIdentificationResult(
    typing_extensions.TypedDict, total=False
):
    localeStripped: bool
    s3TopLocale: str
    ytCapsAudioLanguage: str

@typing.type_check_only
class ImageRepositoryNimaOutput(typing_extensions.TypedDict, total=False):
    score: float

@typing.type_check_only
class ImageRepositoryS3LangIdDebuggingInfo(typing_extensions.TypedDict, total=False):
    audioInputCap: str
    failedSegments: int
    processedSegments: int
    segmentDuration: str
    segmentStride: int
    waveHeader: SpeechWaveHeader

@typing.type_check_only
class ImageRepositoryS3LangIdSignals(typing_extensions.TypedDict, total=False):
    containsSpeech: bool
    debuggingInfo: ImageRepositoryS3LangIdDebuggingInfo
    endSec: str
    langidResult: SpeechS3LanguageIdentificationResult
    languageIdentification: VideoTimedtextS4ALIResults
    modelVersion: str
    speechFrameCount: int
    startSec: str
    totalFrameCount: int

@typing.type_check_only
class ImageRepositoryS3RecognizerMetadataResponse(
    typing_extensions.TypedDict, total=False
):
    mode: str
    modelInfoLabel: str
    serviceName: str

@typing.type_check_only
class ImageRepositoryShoppingProductInformation(
    typing_extensions.TypedDict, total=False
):
    productSets: _list[
        ImageRepositoryShoppingProductInformationVersionedProductInformationSet
    ]

@typing.type_check_only
class ImageRepositoryShoppingProductInformationBoundingBox(
    typing_extensions.TypedDict, total=False
):
    h: float
    w: float
    x: float
    y: float

@typing.type_check_only
class ImageRepositoryShoppingProductInformationEntity(
    typing_extensions.TypedDict, total=False
):
    id: str
    score: float

@typing.type_check_only
class ImageRepositoryShoppingProductInformationProductInformation(
    typing_extensions.TypedDict, total=False
):
    categoryId: _list[int]
    clusterIds: _list[int]
    detectionScore: float
    embedding: str
    entities: _list[ImageRepositoryShoppingProductInformationEntity]
    featureType: str
    productLocation: ImageRepositoryShoppingProductInformationBoundingBox
    tokenGroups: _list[
        ImageRepositoryShoppingProductInformationProductInformationTokenGroup
    ]

@typing.type_check_only
class ImageRepositoryShoppingProductInformationProductInformationTokenGroup(
    typing_extensions.TypedDict, total=False
):
    model: typing_extensions.Literal["UNKNOWN", "KMEANS", "KMEANSV2", "KMEANSV3"]
    tokens: _list[int]

@typing.type_check_only
class ImageRepositoryShoppingProductInformationVersionedProductInformationSet(
    typing_extensions.TypedDict, total=False
):
    modelType: typing_extensions.Literal[
        "MODEL_TYPE_UNKNOWN", "MODEL_TYPE_PRODUCTNET", "MODEL_TYPE_PRIMI_GENERIC"
    ]
    products: _list[ImageRepositoryShoppingProductInformationProductInformation]
    version: int

@typing.type_check_only
class ImageRepositorySpeechRecognitionAlternative(
    typing_extensions.TypedDict, total=False
):
    confidence: float
    transcript: str
    words: _list[ImageRepositoryWordInfo]

@typing.type_check_only
class ImageRepositorySpeechRecognitionResult(typing_extensions.TypedDict, total=False):
    alternatives: _list[ImageRepositorySpeechRecognitionAlternative]
    channelTag: int
    languageCode: str
    resultEndTime: str

@typing.type_check_only
class ImageRepositoryUnwantedContent(typing_extensions.TypedDict, total=False):
    deletionReason: typing_extensions.Literal["OTHER", "CP"]
    hideReason: typing_extensions.Literal["UNKNOWN", "NCEI"]

@typing.type_check_only
class ImageRepositoryVenomProcessingInfo(typing_extensions.TypedDict, total=False):
    venomStatus: _list[ImageRepositoryVenomStatus]

@typing.type_check_only
class ImageRepositoryVenomStatus(typing_extensions.TypedDict, total=False):
    acl: VideoAssetsVenomACL
    deletionTimestampUsec: str
    genus: typing_extensions.Literal[
        "GENUS_UNKNOWN",
        "GENUS_YT_HIGH_VALUE_CONTENT",
        "GENUS_YT_USER_GENERATED_CONTENT",
        "GENUS_GMAIL",
        "GENUS_KIDS_HUB",
        "GENUS_YOUTUBE_DIRECTOR",
        "GENUS_DCLK_VIDEO_ADS",
        "GENUS_DAI_PODCAST",
        "GENUS_TESTING",
        "GENUS_YT_UNPLUGGED_SVOD",
        "GENUS_YT_UNPLUGGED_DVR",
        "GENUS_HVC_INGESTION",
        "GENUS_DRIVE",
        "GENUS_YT_LIGHTWEIGHT_VIDEO",
        "GENUS_ASK_QNA",
        "GENUS_LOCAL_VIDEO",
        "GENUS_PLAY_AUDIOBOOKS",
        "GENUS_HANGOUTS_CHAT",
        "GENUS_VIDEO_INTEREST_FEED",
        "GENUS_YT_MUSIC",
        "GENUS_RECORDER",
        "GENUS_YT_ORIGINAL_CONTENT",
        "GENUS_STAMP",
        "GENUS_BULLETIN_AUDIO",
        "GENUS_CRAWL",
        "GENUS_PHOTOS",
        "GENUS_MATERIAL_GALLERY",
        "GENUS_YT_REFERENCE",
        "GENUS_LENSLETS_VIDEOS",
        "GENUS_BLOGGER",
        "GENUS_PODCASTS",
        "GENUS_OCEAN",
        "GENUS_LMS",
        "GENUS_WEB_VIDEO_ADS",
        "GENUS_STUDIO",
        "GENUS_YT_TDSD_REFERENCE",
        "GENUS_WEB_STORY",
        "GENUS_NEST_CAMERA_CLOUD",
        "GENUS_AREA120_BLUEBIRD",
        "GENUS_ARTS_AND_CULTURE",
        "GENUS_DEMO",
        "GENUS_KARTO",
        "GENUS_CONTRIB_SERVICE_SHARED",
        "GENUS_CONTRIB_SERVICE_GEO_UGC",
        "GENUS_CONTRIB_SERVICE_BARD_STORAGE",
        "GENUS_SEARCH_SPORTS",
        "GENUS_BUSINESSMESSAGING",
        "GENUS_AERIAL_VIEW",
        "GENUS_DOCS_FLIX_RENDER",
        "GENUS_SHOPPING",
    ]
    insertionResponseTimestampUsec: str
    insertionTimestampUsec: str
    lastInsertionAttemptsNum: int
    reason: typing_extensions.Literal[
        "NONE",
        "INVALID",
        "WRONG_CRITERIA",
        "DISABLED",
        "FAILED_INSERTION",
        "INSERTION_SKIPPED",
        "FAILED_DELETION",
        "INCOMPLETE_DOWNLOAD",
        "FILTERED",
        "NOT_FOUND",
        "INSERTION_ATTEMPTS_EXCEEDED",
        "ASSET_ALREADY_EXISTS",
    ]
    settings: _list[VideoAssetsVenomSettings]
    state: typing_extensions.Literal[
        "UNKNOWN_STATE",
        "INSERTED",
        "RESPONDED",
        "NOT_INSERTED",
        "DELETED",
        "NOT_DELETED",
    ]
    transition: VideoAssetsVenomTransition
    venomId: VideoAssetsVenomVideoId
    venomMutationGeneration: str
    videoVenomSetting: typing_extensions.Literal[
        "VIDEO_VENOM_SETTING_COMMON", "VIDEO_VENOM_SETTING_VINEYARD"
    ]

@typing.type_check_only
class ImageRepositoryVideoIndexingInfo(typing_extensions.TypedDict, total=False):
    notIndexedVideoLink: _list[ImageRepositoryVideoLinkIndexingInfo]

@typing.type_check_only
class ImageRepositoryVideoLinkIndexingInfo(typing_extensions.TypedDict, total=False):
    crawlStatusInfo: ImageRepositoryCrawlStatusInfo
    url: str

@typing.type_check_only
class ImageRepositoryVideoPreviewsDebuggingInfo(
    typing_extensions.TypedDict, total=False
):
    lastAmarnaProcessingTime: str
    processingEngine: str

@typing.type_check_only
class ImageRepositoryVideoPreviewsVideoPreview(
    typing_extensions.TypedDict, total=False
):
    content: str
    debuggingInfo: ImageRepositoryVideoPreviewsDebuggingInfo
    metadata: ImageBaseVideoPreviewMetadata
    previewFrameZero: DrishtiVesperVideoThumbnail

@typing.type_check_only
class ImageRepositoryVideoProperties(typing_extensions.TypedDict, total=False):
    audioOnly: bool
    contentBasedMetadata: ImageRepositoryContentBasedVideoMetadata
    crawlState: ImageMoosedogCrawlState
    firstCrawlTimestampSec: str
    firstProcessingTimestampSec: str
    indexedVerticals: _list[ImageRepositoryVideoPropertiesVerticalIndexingInfoVideo]
    inlinePlayback: VideoCrawlVideoInlinePlaybackMetadata
    lastCrawlRequestTimestampSec: str
    lastProcessingTimestampSec: str
    url: str

@typing.type_check_only
class ImageRepositoryVideoPropertiesVerticalIndexingInfoVideo(
    typing_extensions.TypedDict, total=False
):
    name: str

@typing.type_check_only
class ImageRepositoryWordInfo(typing_extensions.TypedDict, total=False):
    confidence: float
    endTime: str
    speakerTag: int
    startTime: str
    word: str

@typing.type_check_only
class ImageRepositoryYoutubeProcessingFilter(typing_extensions.TypedDict, total=False):
    previewsFilteredReason: _list[
        typing_extensions.Literal[
            "UNKNOWN",
            "CONTENT_CLAIMS",
            "MATURE_CONTENT",
            "INVALID_VIDEO_DATA",
            "NO_VSI",
            "SHORT_DURATION",
            "NO_DURATION",
            "EMPTY_DATA",
            "DELETED",
            "OFFICIAL_MUSIC_VIDEO",
            "PREMIUM_CONTENT",
            "ART_TRACK",
            "PHARMA_CHANNEL",
        ]
    ]

@typing.type_check_only
class ImageSafesearchContentBrainPornAnnotation(
    typing_extensions.TypedDict, total=False
):
    childScore: float
    csaiScore: float
    csamA1Score: float
    csamAgeIndeterminateScore: float
    iuInappropriateScore: float
    medicalScore: float
    pedoScore: float
    pornScore: float
    racyScore: float
    semanticSexualizationScore: float
    spoofScore: float
    version: str
    violenceScore: float
    ytPornScore: float

@typing.type_check_only
class ImageSafesearchContentOCRAnnotation(typing_extensions.TypedDict, total=False):
    ocrAnnotationVersion: str
    ocrProminenceScore: float
    pornScore: float
    prominentOffensiveScore: float
    prominentVulgarScore: float
    qbstOffensiveScore: float
    vulgarI18nBit: bool
    vulgarScore: float

@typing.type_check_only
class ImageSafesearchContentOffensiveSymbolDetection(
    typing_extensions.TypedDict, total=False
):
    matches: _list[ImageSafesearchContentOffensiveSymbolMatch]

@typing.type_check_only
class ImageSafesearchContentOffensiveSymbolMatch(
    typing_extensions.TypedDict, total=False
):
    score: float
    type: typing_extensions.Literal[
        "INVALID",
        "SWASTIKA_WHITE_ON_BLACK",
        "SWASTIKA_BLACK_ON_WHITE",
        "SWASTIKA_BLACK_ON_WHITE_ROTATED",
        "NAZI_YELLOW_BADGE",
    ]

@typing.type_check_only
class ImageSearchImageIndexingInfo(typing_extensions.TypedDict, total=False):
    imageLinkSelectionInfo: _list[ImageSearchImageSelectionInfo]
    rejectedNotIndexedImageLink: _list[ImageSearchUnindexedImageLink]
    selectedNotIndexedImageLink: _list[ImageSearchUnindexedImageLink]

@typing.type_check_only
class ImageSearchImageLicenseInfo(typing_extensions.TypedDict, total=False):
    acquireLicensePage: str
    copyrightNotice: str
    copyrightNoticeSourceType: typing_extensions.Literal[
        "UNKNOWN_SOURCE", "SCHEMA_ORG_MARKUP", "IPTC_METADATA"
    ]
    creator: _list[str]
    creatorSourceType: typing_extensions.Literal[
        "UNKNOWN_SOURCE", "SCHEMA_ORG_MARKUP", "IPTC_METADATA"
    ]
    creditText: str
    creditTextSourceType: typing_extensions.Literal[
        "UNKNOWN_SOURCE", "SCHEMA_ORG_MARKUP", "IPTC_METADATA"
    ]
    isRetiredCcUrl: bool
    licenseType: typing_extensions.Literal[
        "NO_LICENSE", "CREATIVE_COMMONS_LICENSE", "NON_CREATIVE_COMMONS_LICENSE"
    ]
    licenseUrl: str
    safesearchFlags: int
    sourceType: typing_extensions.Literal[
        "UNKNOWN_SOURCE", "SCHEMA_ORG_MARKUP", "IPTC_METADATA"
    ]

@typing.type_check_only
class ImageSearchImageSelectionInfo(typing_extensions.TypedDict, total=False):
    imageLinkSelectionInfo: ImageMustangImageLinkSelectionInfo
    url: str

@typing.type_check_only
class ImageSearchUnindexedImageLink(typing_extensions.TypedDict, total=False):
    amarnaStatus: ImageRepositoryAmarnaStatus
    crawlStatusInfo: ImageRepositoryCrawlStatusInfo
    url: str

@typing.type_check_only
class ImageUnderstandingIndexingAnnotation(typing_extensions.TypedDict, total=False):
    feature: _list[ImageUnderstandingIndexingFeature]
    labelGroup: _list[ImageUnderstandingIndexingLabelGroup]
    roi: ImageUnderstandingIndexingImageRegion

@typing.type_check_only
class ImageUnderstandingIndexingAnnotationGroup(
    typing_extensions.TypedDict, total=False
):
    annotation: _list[ImageUnderstandingIndexingAnnotation]

@typing.type_check_only
class ImageUnderstandingIndexingFeature(typing_extensions.TypedDict, total=False):
    bytesValue: str
    floatValue: _list[float]
    imageTemplate: PhotosVisionObjectrecImageTemplate
    int32Value: _list[int]
    version: str

@typing.type_check_only
class ImageUnderstandingIndexingImageRegion(typing_extensions.TypedDict, total=False):
    box: PhotosVisionGroundtruthdbNormalizedBoundingBox
    score: float
    version: str

@typing.type_check_only
class ImageUnderstandingIndexingLabel(typing_extensions.TypedDict, total=False):
    canonicalText: str
    entityId: str
    metaData: _list[ImageUnderstandingIndexingMetaData]
    score: float

@typing.type_check_only
class ImageUnderstandingIndexingLabelGroup(typing_extensions.TypedDict, total=False):
    label: _list[ImageUnderstandingIndexingLabel]
    version: str

@typing.type_check_only
class ImageUnderstandingIndexingMetaData(typing_extensions.TypedDict, total=False):
    floatValue: float
    name: str
    stringValue: str

@typing.type_check_only
class IndexingBadSSLCertificate(typing_extensions.TypedDict, total=False):
    badSslCertificate: TrawlerSSLCertificateInfo
    urlWithBadSslCertificate: str

@typing.type_check_only
class IndexingConverterLocalizedAlternateName(typing_extensions.TypedDict, total=False):
    annotationSource: typing_extensions.Literal["HTTP", "HTML", "SITEMAP"]
    deviceMatchInfo: typing_extensions.Literal[
        "UNKNOWN", "WWW_TO_WWW", "WWW_TO_M", "M_TO_M", "M_TO_WWW"
    ]
    ecnFp: str
    feedUrl: str
    language: str
    parsedLanguage: typing_extensions.Literal[
        "ENGLISH",
        "DANISH",
        "DUTCH",
        "FINNISH",
        "FRENCH",
        "GERMAN",
        "HEBREW",
        "ITALIAN",
        "JAPANESE",
        "KOREAN",
        "NORWEGIAN",
        "POLISH",
        "PORTUGUESE",
        "RUSSIAN",
        "SPANISH",
        "SWEDISH",
        "CHINESE",
        "CZECH",
        "GREEK",
        "ICELANDIC",
        "LATVIAN",
        "LITHUANIAN",
        "ROMANIAN",
        "HUNGARIAN",
        "ESTONIAN",
        "TG_UNKNOWN_LANGUAGE",
        "UNKNOWN_LANGUAGE",
        "BULGARIAN",
        "CROATIAN",
        "SERBIAN",
        "IRISH",
        "GALICIAN",
        "TAGALOG",
        "TURKISH",
        "UKRAINIAN",
        "HINDI",
        "MACEDONIAN",
        "BENGALI",
        "INDONESIAN",
        "LATIN",
        "MALAY",
        "MALAYALAM",
        "WELSH",
        "NEPALI",
        "TELUGU",
        "ALBANIAN",
        "TAMIL",
        "BELARUSIAN",
        "JAVANESE",
        "OCCITAN",
        "URDU",
        "BIHARI",
        "GUJARATI",
        "THAI",
        "ARABIC",
        "CATALAN",
        "ESPERANTO",
        "BASQUE",
        "INTERLINGUA",
        "KANNADA",
        "PUNJABI",
        "SCOTS_GAELIC",
        "SWAHILI",
        "SLOVENIAN",
        "MARATHI",
        "MALTESE",
        "VIETNAMESE",
        "FRISIAN",
        "SLOVAK",
        "CHINESE_T",
        "FAROESE",
        "SUNDANESE",
        "UZBEK",
        "AMHARIC",
        "AZERBAIJANI",
        "GEORGIAN",
        "TIGRINYA",
        "PERSIAN",
        "BOSNIAN",
        "SINHALESE",
        "NORWEGIAN_N",
        "PORTUGUESE_P",
        "PORTUGUESE_B",
        "XHOSA",
        "ZULU",
        "GUARANI",
        "SESOTHO",
        "TURKMEN",
        "KYRGYZ",
        "BRETON",
        "TWI",
        "YIDDISH",
        "SERBO_CROATIAN",
        "SOMALI",
        "UIGHUR",
        "KURDISH",
        "MONGOLIAN",
        "ARMENIAN",
        "LAOTHIAN",
        "SINDHI",
        "RHAETO_ROMANCE",
        "AFRIKAANS",
        "LUXEMBOURGISH",
        "BURMESE",
        "KHMER",
        "TIBETAN",
        "DHIVEHI",
        "CHEROKEE",
        "SYRIAC",
        "LIMBU",
        "ORIYA",
        "ASSAMESE",
        "CORSICAN",
        "INTERLINGUE",
        "KAZAKH",
        "LINGALA",
        "MOLDAVIAN",
        "PASHTO",
        "QUECHUA",
        "SHONA",
        "TAJIK",
        "TATAR",
        "TONGA",
        "YORUBA",
        "CREOLES_AND_PIDGINS_ENGLISH_BASED",
        "CREOLES_AND_PIDGINS_FRENCH_BASED",
        "CREOLES_AND_PIDGINS_PORTUGUESE_BASED",
        "CREOLES_AND_PIDGINS_OTHER",
        "MAORI",
        "WOLOF",
        "ABKHAZIAN",
        "AFAR",
        "AYMARA",
        "BASHKIR",
        "BISLAMA",
        "DZONGKHA",
        "FIJIAN",
        "GREENLANDIC",
        "HAUSA",
        "HAITIAN_CREOLE",
        "INUPIAK",
        "INUKTITUT",
        "KASHMIRI",
        "KINYARWANDA",
        "MALAGASY",
        "NAURU",
        "OROMO",
        "RUNDI",
        "SAMOAN",
        "SANGO",
        "SANSKRIT",
        "SISWANT",
        "TSONGA",
        "TSWANA",
        "VOLAPUK",
        "ZHUANG",
        "KHASI",
        "SCOTS",
        "GANDA",
        "MANX",
        "MONTENEGRIN",
        "AKAN",
        "IGBO",
        "MAURITIAN_CREOLE",
        "HAWAIIAN",
        "CEBUANO",
        "EWE",
        "GA",
        "HMONG",
        "KRIO",
        "LOZI",
        "LUBA_LULUA",
        "LUO_KENYA_AND_TANZANIA",
        "NEWARI",
        "NYANJA",
        "OSSETIAN",
        "PAMPANGA",
        "PEDI",
        "RAJASTHANI",
        "SESELWA_CREOLE_FRENCH",
        "TUMBUKA",
        "VENDA",
        "WARAY_PHILIPPINES",
        "NUM_LANGUAGES",
    ]
    parsedRegion: int
    url: str
    urlEncoding: int

@typing.type_check_only
class IndexingConverterRawRedirectInfo(typing_extensions.TypedDict, total=False):
    rawFinalTargetFromRendering: str
    rawFinalTargetFromTrawler: str
    rawRedirectChainFromRendering: IndexingConverterRedirectChain
    renderingRedirectLimit: int

@typing.type_check_only
class IndexingConverterRedirectChain(typing_extensions.TypedDict, total=False):
    hop: _list[IndexingConverterRedirectChainHop]

@typing.type_check_only
class IndexingConverterRedirectChainHop(typing_extensions.TypedDict, total=False):
    params: IndexingConverterRedirectParams
    rawTarget: str
    target: str

@typing.type_check_only
class IndexingConverterRedirectParams(typing_extensions.TypedDict, total=False):
    delay: int
    frameTargetDeniesFraming: bool
    isDownload: bool
    isRenderingRedirect: bool
    metaRedirectFromTrawler: bool
    type: typing_extensions.Literal[
        "PERMANENT",
        "TEMPORARY",
        "WIKIPEDIA_DEPRECATED",
        "JAVASCRIPT",
        "META",
        "SINGLE_FRAME",
        "CRYPTO301",
        "LINK_REL_CANONICAL",
        "SINGLE_IFRAME",
        "WEBKIT",
        "META_FRAGMENT",
        "SINGLE_CHOICE_300",
        "SINGLE_PAGE",
        "DATAFILE",
        "HTTP_REFRESH",
        "HTTP_POST",
        "HTML5_HISTORY_API",
        "AJAX_CRAWLING",
    ]

@typing.type_check_only
class IndexingConverterRichContentData(typing_extensions.TypedDict, total=False):
    range: _list[IndexingConverterRichContentDataRange]

@typing.type_check_only
class IndexingConverterRichContentDataRange(typing_extensions.TypedDict, total=False):
    rangeType: typing_extensions.Literal[
        "ORIGINAL_AND_PROCESSED",
        "ORIGINAL_ONLY",
        "PROCESSED_ONLY",
        "ORIGINAL_AND_INTERMEDIATE",
        "INTERMEDIATE_ONLY",
    ]
    size: int
    sourceType: typing_extensions.Literal[
        "SEPARATOR",
        "FRAME",
        "DOMTRACKER_JAVASCRIPT",
        "FLASH",
        "IFRAME",
        "WEBKIT_PHRASES_DEPRECATED",
        "WEBKIT_CONTENT_REPLACEMENT",
    ]
    sourceUrl: str
    text: str
    textCompressionMethod: typing_extensions.Literal[
        "TEXT_COMPRESSION_NONE", "TEXT_COMPRESSION_BMDIFF"
    ]

@typing.type_check_only
class IndexingConverterRobotsInfo(typing_extensions.TypedDict, total=False):
    contentExpiry: int
    convertToRobotedReason: typing_extensions.Literal[
        "BLOCKING_HOST",
        "EMPTY_PAGE",
        "MOBILE_IP_RESTRICTED",
        "CLOAKING_4XX",
        "UNSUPPORTED_PROTOCOL",
    ]
    disallowedReason: int
    indexifembeddedReason: int
    maxImagePreview: typing_extensions.Literal[
        "THUMBNAIL_UNSPECIFIED", "NONE", "STANDARD", "LARGE"
    ]
    maxSnippetLength: str
    noarchiveReason: int
    nofollowReason: int
    noimageframeoverlayReason: int
    noimageindexReason: int
    noindexReason: int
    nopreviewReason: int
    nosnippetReason: int
    notranslateReason: int

@typing.type_check_only
class IndexingConverterShingleFingerprint(typing_extensions.TypedDict, total=False):
    metadata: str
    value: _list[str]

@typing.type_check_only
class IndexingCrawlerIdServingDocumentIdentifier(
    typing_extensions.TypedDict, total=False
):
    doubleIndexingExperimentId: str
    dupExperimentId: str
    key: str

@typing.type_check_only
class IndexingDocjoinerAnchorPhraseSpamInfo(typing_extensions.TypedDict, total=False):
    phraseAnchorSpamCount: float
    phraseAnchorSpamDays: float
    phraseAnchorSpamDemoted: int
    phraseAnchorSpamEnd: int
    phraseAnchorSpamFraq: float
    phraseAnchorSpamPenalty: float
    phraseAnchorSpamProcessed: int
    phraseAnchorSpamRate: float
    phraseAnchorSpamStart: int

@typing.type_check_only
class IndexingDocjoinerAnchorSpamInfo(typing_extensions.TypedDict, total=False):
    anchorEnd: int
    anchorFraq: float
    anchorStart: int
    demoted: int
    demotedAll: bool
    demotedEnd: int
    demotedStart: int
    phraseCount: float
    phraseDays: float
    phraseFraq: float
    phraseRate: float
    processed: int
    sampled: bool
    sources: _list[IndexingDocjoinerAnchorTrustedInfo]
    spamDebugInfo: str
    spamPenalty: float
    spamProbability: float
    trustedDemoted: int
    trustedExamples: str
    trustedMatching: int
    trustedTarget: bool
    trustedTotal: int

@typing.type_check_only
class IndexingDocjoinerAnchorStatistics(typing_extensions.TypedDict, total=False):
    anchorCount: int
    anchorPhraseCount: int
    anchorSpamInfo: IndexingDocjoinerAnchorSpamInfo
    anchorsWithDedupedImprovanchors: int
    badbacklinksPenalized: bool
    baseAnchorCount: int
    baseOffdomainAnchorCount: int
    droppedHomepageAnchorCount: int
    droppedLocalAnchorCount: int
    droppedNonLocalAnchorCount: int
    droppedRedundantAnchorCount: int
    fakeAnchorCount: int
    forwardedAnchorCount: int
    forwardedOffdomainAnchorCount: int
    globalAnchorDelta: int
    linkBeforeSitechangeTaggedAnchors: int
    localAnchorCount: int
    lowCorpusAnchorCount: int
    lowCorpusOffdomainAnchorCount: int
    mediumCorpusAnchorCount: int
    mediumCorpusOffdomainAnchorCount: int
    minDomainHomePageLocalOutdegree: int
    minHostHomePageLocalOutdegree: int
    nonLocalAnchorCount: int
    offdomainAnchorCount: int
    ondomainAnchorCount: int
    onsiteAnchorCount: int
    pageFromExpiredTaggedAnchors: int
    pageMismatchTaggedAnchors: int
    penguinEarlyAnchorProtected: bool
    penguinLastUpdate: int
    penguinPenalty: float
    penguinTooManySources: bool
    perdupstats: _list[IndexingDocjoinerAnchorStatisticsPerDupStats]
    phraseAnchorSpamInfo: IndexingDocjoinerAnchorPhraseSpamInfo
    redundantAnchorForPhraseCapCount: int
    redundantanchorinfo: _list[IndexingDocjoinerAnchorStatisticsRedundantAnchorInfo]
    redundantanchorinfoforphrasecap: _list[
        IndexingDocjoinerAnchorStatisticsRedundantAnchorInfoForPhraseCap
    ]
    scannedAnchorCount: int
    skippedAccumulate: int
    skippedOrReusedReason: str
    spamLog10Odds: float
    timestamp: int
    topPrOffdomainAnchorCount: int
    topPrOndomainAnchorCount: int
    topPrOnsiteAnchorCount: int
    totalDomainPhrasePairsAboveLimit: int
    totalDomainPhrasePairsSeenApprox: int
    totalDomainsAbovePhraseCap: int
    totalDomainsSeen: int

@typing.type_check_only
class IndexingDocjoinerAnchorStatisticsPerDupStats(
    typing_extensions.TypedDict, total=False
):
    anchorCount: int
    collectType: int
    dupUrl: str
    offdomainAnchorCount: int
    redundantAnchorCount: int
    scannedAnchorCount: int
    timestamp: int

@typing.type_check_only
class IndexingDocjoinerAnchorStatisticsRedundantAnchorInfo(
    typing_extensions.TypedDict, total=False
):
    anchorsDropped: str
    domain: str
    text: str

@typing.type_check_only
class IndexingDocjoinerAnchorStatisticsRedundantAnchorInfoForPhraseCap(
    typing_extensions.TypedDict, total=False
):
    anchorsDropped: int
    domain: str

@typing.type_check_only
class IndexingDocjoinerAnchorTrustedInfo(typing_extensions.TypedDict, total=False):
    matchedScore: float
    matchedScoreInfo: _list[str]
    phrasesScore: float
    site: str
    text: _list[str]
    trustedScore: float

@typing.type_check_only
class IndexingDocjoinerCDocBuildInfo(typing_extensions.TypedDict, total=False):
    extraMessage: Proto2BridgeMessageSet

@typing.type_check_only
class IndexingDocjoinerDataVersion(typing_extensions.TypedDict, total=False):
    acceleratedShoppingSignal: IndexingDocjoinerDataVersionVersionInfo
    adsAdsaiMagicApfelApfelRegionFinderAnnotation: IndexingDocjoinerDataVersionVersionInfo
    adsAdsaiMagicMagicPageTypeAnnotation: IndexingDocjoinerDataVersionVersionInfo
    adsShoppingWebpxRawShoppingAnnotation: IndexingDocjoinerDataVersionVersionInfo
    amphtmlSignedExchangeErrorDetails: IndexingDocjoinerDataVersionVersionInfo
    amphtmlSignedExchangeValidationPayload: IndexingDocjoinerDataVersionVersionInfo
    analyticsSiteidAnalyticsPropertyAnnotation: IndexingDocjoinerDataVersionVersionInfo
    analyticsSiteidAnalyticsRenderedOutput: IndexingDocjoinerDataVersionVersionInfo
    authenticSiteRankData: IndexingDocjoinerDataVersionVersionInfo
    babelEncoderBabelEncodings: IndexingDocjoinerDataVersionVersionInfo
    badurlsBadurlsForceSelectionSignal: IndexingDocjoinerDataVersionVersionInfo
    boilerplateAnnotations: IndexingDocjoinerDataVersionVersionInfo
    boilerplateVisibleBytesEstimates: IndexingDocjoinerDataVersionVersionInfo
    chromeCounts: IndexingDocjoinerDataVersionVersionInfo
    commerceDataqualityOrganicCrawledSellerData: IndexingDocjoinerDataVersionVersionInfo
    commerceDataqualityOrganicShoppingAnnotationSignal: IndexingDocjoinerDataVersionVersionInfo
    commerceDataqualityOrganicShoppingSiteQuality: IndexingDocjoinerDataVersionVersionInfo
    commonsenseQueriosityGoldmineQnaAnnotations: IndexingDocjoinerDataVersionVersionInfo
    commonsenseScoredCompoundReferenceAnnotation: IndexingDocjoinerDataVersionVersionInfo
    commonsenseStoneSoupProtoRaffiaInstructionsSeq: IndexingDocjoinerDataVersionVersionInfo
    contraContentReviewAnnotations: IndexingDocjoinerDataVersionVersionInfo
    contraCuratedContent: IndexingDocjoinerDataVersionVersionInfo
    countryCountryAttachment: IndexingDocjoinerDataVersionVersionInfo
    crawzallSignal: IndexingDocjoinerDataVersionVersionInfo
    creator: IndexingDocjoinerDataVersionVersionInfo
    datacommonsDatacommonsTriplesSignal: IndexingDocjoinerDataVersionVersionInfo
    dateAnnotationTags: IndexingDocjoinerDataVersionVersionInfo
    dateAnnotations: IndexingDocjoinerDataVersionVersionInfo
    dateRangeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    dateTimeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    discoverSource: IndexingDocjoinerDataVersionVersionInfo
    discussion: IndexingDocjoinerDataVersionVersionInfo
    documentIntent: IndexingDocjoinerDataVersionVersionInfo
    dotsGaramondSignal: IndexingDocjoinerDataVersionVersionInfo
    dotsNewsstandSignal: IndexingDocjoinerDataVersionVersionInfo
    emailAddressAnnotations: IndexingDocjoinerDataVersionVersionInfo
    extractedBookInfo: IndexingDocjoinerDataVersionVersionInfo
    fatcatCompactDocClassification: IndexingDocjoinerDataVersionVersionInfo
    fatcatSiteVerticalsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    firstseen: IndexingDocjoinerDataVersionVersionInfo
    fontsAnalysisAnnotatorFontsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    forumRankingForumPostsSafeSearchAnnotation: IndexingDocjoinerDataVersionVersionInfo
    foundationSplinterSignal: IndexingDocjoinerDataVersionVersionInfo
    freshboxFreshboxArticleAnnotation: IndexingDocjoinerDataVersionVersionInfo
    geoPointAnnotations: IndexingDocjoinerDataVersionVersionInfo
    geoPointResolution: IndexingDocjoinerDataVersionVersionInfo
    geostoreAddressProto: IndexingDocjoinerDataVersionVersionInfo
    i2eV2ImageEntitiesInfos: IndexingDocjoinerDataVersionVersionInfo
    imageContentAnnotationLabels: IndexingDocjoinerDataVersionVersionInfo
    imageContentColorSearchColorDetectionResults: IndexingDocjoinerDataVersionVersionInfo
    imageDataList: IndexingDocjoinerDataVersionVersionInfo
    imageExtraImageExtraTerms: IndexingDocjoinerDataVersionVersionInfo
    imageMonetizationFeaturedDocumentProperties: IndexingDocjoinerDataVersionVersionInfo
    imageMustangFaviconInfo: IndexingDocjoinerDataVersionVersionInfo
    imageMustangWebsearchImageSnippetResponse: IndexingDocjoinerDataVersionVersionInfo
    imageQualityLabelmakerDocMediaLabels: IndexingDocjoinerDataVersionVersionInfo
    imageQualityLandingPageProtoLandingPageSalientTextSet: IndexingDocjoinerDataVersionVersionInfo
    imageQualityLayoutDocument: IndexingDocjoinerDataVersionVersionInfo
    imageQualityRichdataProtoImageAnchor: IndexingDocjoinerDataVersionVersionInfo
    imageQualityRichdataProtoRichdata: IndexingDocjoinerDataVersionVersionInfo
    imageQualitySalientTermsImageQuerySmearingList: IndexingDocjoinerDataVersionVersionInfo
    imageQualitySalientTermsImageSalientTermSetMap: IndexingDocjoinerDataVersionVersionInfo
    imageQualitySensitiveFaceSkinToneSignals: IndexingDocjoinerDataVersionVersionInfo
    imageQualitySensitiveMediaOrPeopleEntities: IndexingDocjoinerDataVersionVersionInfo
    imageRepositoryGeolocation: IndexingDocjoinerDataVersionVersionInfo
    imageRepositoryPicasaGeoData: IndexingDocjoinerDataVersionVersionInfo
    imageSearchRejectedImageInfoList: IndexingDocjoinerDataVersionVersionInfo
    imageStockStockImageAnnotation: IndexingDocjoinerDataVersionVersionInfo
    imageembed: IndexingDocjoinerDataVersionVersionInfo
    imageembedDomainNorm: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsAnnotationMeta: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsAppMarketAppMarketAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsAppsCacheColonAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsAppsDocRestrictionsDocPreviewRestrictionsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsAutomobileVinAnnotatorAutomobileVinAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsCanonicalUrl: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsCleanTextProto: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsCollectionsDocCollections: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsCommentBlockGroups: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsDatasetModelAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsDatesDateTimes: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsDocImportance: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsDocRestrictionsInDocRestrictionsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsEntityPage: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsFeedbackSet: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsIBertEmbeddingAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsImageRepositoryImageLicenseInfoAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsPcuAmpError: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsPcuSignedExchangeInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsPersonPersonAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsSduPageTypeAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsSocialLinksSocialLinksAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsSubscribewithgoogleSwgAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsTwitterEmbeddedTweetsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsTypedNumberTypedNumberAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsWaPassagesQueryToPassageAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingAnnotationsWaPassagesTrimmedQueryToPassageAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingAppsAffiliatedInstantAppInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingAppsMergedAppInfoAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingBadpagesBadPageParseResult: IndexingDocjoinerDataVersionVersionInfo
    indexingBadpagesCollapserInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingBadpagesIndexSelectionRemoval: IndexingDocjoinerDataVersionVersionInfo
    indexingBadpagesLoginPageResult: IndexingDocjoinerDataVersionVersionInfo
    indexingBadpagesUnifiedModelFeatures: IndexingDocjoinerDataVersionVersionInfo
    indexingBeringPublisherOnPageAdsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingCenterpieceCenterPieceAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingCenterpieceCenterpieceChecksums: IndexingDocjoinerDataVersionVersionInfo
    indexingCenterpieceComponentLearningSource: IndexingDocjoinerDataVersionVersionInfo
    indexingCenterpieceSectionTitleAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterContentGenerationInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterContentParserResults: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterFileMetaInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterLinkRelOutlinks: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterMetaDetectorsResultsProto: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterPdfFileMetaInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingConverterPdfPageAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingCustomCorpusCdmAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingDeepwebStoreListAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingDocjoinerServingTimeClusterIds: IndexingDocjoinerDataVersionVersionInfo
    indexingDocjoinerWikiInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingDocskeletonRepeatedPatternRepeatedPatternAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingDupsLocalizedLocalizedCluster: IndexingDocjoinerDataVersionVersionInfo
    indexingFreshSchedulerFreshSchedulerDoubleInstantExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingFreshSchedulerOutlinkDiscoveryHistoricalHubsSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingImagesRelatedImageSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantActiveClusterScorerSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantBaseReindexWhitelistData: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantClusterScorerArticle: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantClusterScorerSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantHistoricalContentSignals: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantNewsHighlyCitedDocumentSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantNewsImagesInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingInstantSignalSourceTagsExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingLatticeLatticeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingMetricsUrlIndexingProps: IndexingDocjoinerDataVersionVersionInfo
    indexingMlDomNodeSegments: IndexingDocjoinerDataVersionVersionInfo
    indexingMlEntityInfoboxes: IndexingDocjoinerDataVersionVersionInfo
    indexingMlPageStructure: IndexingDocjoinerDataVersionVersionInfo
    indexingMlSemanticArticle: IndexingDocjoinerDataVersionVersionInfo
    indexingMlShoppingUniverseAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingMlVerticalVerticalClassificationResult: IndexingDocjoinerDataVersionVersionInfo
    indexingMlVerticalVerticalClassificationV2: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileClientDependentInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileInterstitialsProtoDesktopInterstitials: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileObelixInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileSmartphoneContentAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileSmartphonePatternClassification: IndexingDocjoinerDataVersionVersionInfo
    indexingMobileSpeedPageSpeedFieldData: IndexingDocjoinerDataVersionVersionInfo
    indexingPlusonePlusOneSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingPlusoneSocialScoreSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingRaffiaDataRecoveryInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingRaffiaIndexingIntermediate: IndexingDocjoinerDataVersionVersionInfo
    indexingRaffiaMediaProcessingMetadata: IndexingDocjoinerDataVersionVersionInfo
    indexingRaffiaOverlayCDocAttachment: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionAcquisitionMetadataAttachment: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionDoubleIndexingExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionFastServingPush: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionFreshdocsPassthroughExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionImageImageSelectionAttachment: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionLanguageExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionPriorScorerParameterSet: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionProcessingPriorityExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionProtoBasePromotionInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingSelectionTensorFlowExtension: IndexingDocjoinerDataVersionVersionInfo
    indexingSignalAggregatorUrlPatternSignals: IndexingDocjoinerDataVersionVersionInfo
    indexingSignalsAccumulatedOnlineSignals: IndexingDocjoinerDataVersionVersionInfo
    indexingSignalsImpressionsPerDayContainer: IndexingDocjoinerDataVersionVersionInfo
    indexingSocialCountsSocialWidgetsIndicator: IndexingDocjoinerDataVersionVersionInfo
    indexingSpeechGoldminePodcastAnnotation: IndexingDocjoinerDataVersionVersionInfo
    indexingSpeechSpeechPagePropertiesProto: IndexingDocjoinerDataVersionVersionInfo
    indexingThirdpartyThirdPartyInputs: IndexingDocjoinerDataVersionVersionInfo
    indexingUgcPageParamInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingUnionKeyData: IndexingDocjoinerDataVersionVersionInfo
    indexingUrlPatternUrlTreeUrlPatternAnnotations: IndexingDocjoinerDataVersionVersionInfo
    indexingVideosVideoAnchorSourceInfo: IndexingDocjoinerDataVersionVersionInfo
    indexingVideosVideoPlaylistAnchorSignal: IndexingDocjoinerDataVersionVersionInfo
    indexingWebChannelsWebChannelAnnotations: IndexingDocjoinerDataVersionVersionInfo
    infoextractionPinpointPinpointAnnotationSignal: IndexingDocjoinerDataVersionVersionInfo
    infoextractionPinpointPinpointSignal: IndexingDocjoinerDataVersionVersionInfo
    instantChromeViews: IndexingDocjoinerDataVersionVersionInfo
    instantNavboost: IndexingDocjoinerDataVersionVersionInfo
    knowledgeGraphAcquisitionFeedsQuotesQuotesAnnotation: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsDocumentSignals: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsFactEvaluationSignals: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsHtmlTableSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsKatsSignals: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsLocalizedFact: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsObjectAnnotationsSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsProductCompositionSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsServingData: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsShoppingSignals: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsStructuredSnippetsSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsUdrExtraFactData: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsUdrExtraFactMentionData: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsUniversalFactMetadata: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsUniversalFactScores: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsUniversalTableSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningFactsWebKvSiteGroupSignal: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningShoppingBrowseonomyData: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMiningShoppingTwdModelVersions: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMumStoryTeaserAnnotation: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMumStorytimeStampEngagementAnnotation: IndexingDocjoinerDataVersionVersionInfo
    knowledgeMumStorytimeStampQualityAnnotation: IndexingDocjoinerDataVersionVersionInfo
    knowledgeTablesTableInternalData: IndexingDocjoinerDataVersionVersionInfo
    knowledgeTablesUniversalTableAnnotations: IndexingDocjoinerDataVersionVersionInfo
    knowledgeTasksUniversalTaskAnnotation: IndexingDocjoinerDataVersionVersionInfo
    knowledgeTpfHowtodoHowtoVideoAnnotation: IndexingDocjoinerDataVersionVersionInfo
    langIdLangReasonerDocumentLanguages: IndexingDocjoinerDataVersionVersionInfo
    lensVsaiDatasets: IndexingDocjoinerDataVersionVersionInfo
    localsearchAuthoritySiteAnnotation: IndexingDocjoinerDataVersionVersionInfo
    localyp: IndexingDocjoinerDataVersionVersionInfo
    mapsSyntheticsGeoDocFetchKey: IndexingDocjoinerDataVersionVersionInfo
    measurementAnnotations: IndexingDocjoinerDataVersionVersionInfo
    metawebExtractionDocumentEvidence: IndexingDocjoinerDataVersionVersionInfo
    modernFormatContent: IndexingDocjoinerDataVersionVersionInfo
    navBoostDocument: IndexingDocjoinerDataVersionVersionInfo
    navboost: IndexingDocjoinerDataVersionVersionInfo
    newsAnnotationsContentAnnotations: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusHubPageAnnotations: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusLeafPageAnnotation: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusNewsAggregateSignal: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusNewsCorpusAnnotation: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusNewsCorpusRootAnnotation: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusNewsCorpusStatusAnnotation: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusNewsinessAnnotation: IndexingDocjoinerDataVersionVersionInfo
    newsCorpusPositionRankAnnotations: IndexingDocjoinerDataVersionVersionInfo
    newsCrawlFilterNewsLinkCrawlSignal: IndexingDocjoinerDataVersionVersionInfo
    newsExtractionNewsPbeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    newsNarIndexingMetadata: IndexingDocjoinerDataVersionVersionInfo
    newsNarRow: IndexingDocjoinerDataVersionVersionInfo
    newsNarRowContainer: IndexingDocjoinerDataVersionVersionInfo
    newsNearDupsInfo: IndexingDocjoinerDataVersionVersionInfo
    newsNewromanIndexingNewRomanSignal: IndexingDocjoinerDataVersionVersionInfo
    newsNewsArticleChecksum: IndexingDocjoinerDataVersionVersionInfo
    newsNewsClassifications: IndexingDocjoinerDataVersionVersionInfo
    newsNewsContentSignals: IndexingDocjoinerDataVersionVersionInfo
    newsNewsForEducationReadingStatistics: IndexingDocjoinerDataVersionVersionInfo
    newsVideosNewsAnchorSourceInfo: IndexingDocjoinerDataVersionVersionInfo
    newsVideosNewsVideoAnnotationSignals: IndexingDocjoinerDataVersionVersionInfo
    nlpAtcClaraAnnotation: IndexingDocjoinerDataVersionVersionInfo
    nlpSaftDocument: IndexingDocjoinerDataVersionVersionInfo
    nlpSaftNlxDocAnnotatorMigration: IndexingDocjoinerDataVersionVersionInfo
    nlpSaftRodinClassification: IndexingDocjoinerDataVersionVersionInfo
    nlpSentimentSentimentAnnotation: IndexingDocjoinerDataVersionVersionInfo
    nlxDocAnnotation: IndexingDocjoinerDataVersionVersionInfo
    noindexedImageDataList: IndexingDocjoinerDataVersionVersionInfo
    numberAnnotations: IndexingDocjoinerDataVersionVersionInfo
    oceanLibrarianBookMetadata: IndexingDocjoinerDataVersionVersionInfo
    oceanLibrarianPopulatorData: IndexingDocjoinerDataVersionVersionInfo
    oceanLibrarianPopulatorPageData: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataAllItemSpecificBibdatas: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataAvailabilityInfoComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataAvailabilitySnapshot: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataAvailabilitySnapshotHolder: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataBibkeyComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataClusterHorizontalReference: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataClusterRecord: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataClusterVolumes: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataClusteringSeriesSeriesInfo: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataClusteringTomeHorizontalLinkDescriptor: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataContributorLinks: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataItemSpecificBibdataComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataKgTopicLinks: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataLanguageInfoComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataMaterialInfoComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataParsedAccessTerms: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataParsedSuDoc: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataPatentPublicationDetails: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataPhysicalMeasurementsComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataPublicDomainInfo: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataPublicationDetailsComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataRightsComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataSeriesInfoComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataTomeDetailsComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataTomeMembersComponent: IndexingDocjoinerDataVersionVersionInfo
    oceanMetadataTomePriceInfo: IndexingDocjoinerDataVersionVersionInfo
    oceanReviewsForWork: IndexingDocjoinerDataVersionVersionInfo
    oceanRightsOptOutRequest: IndexingDocjoinerDataVersionVersionInfo
    officialPagesQuerySet: IndexingDocjoinerDataVersionVersionInfo
    perDocLangidData: IndexingDocjoinerDataVersionVersionInfo
    personalizationGameWebeventsConsolidatedEvents: IndexingDocjoinerDataVersionVersionInfo
    personalizationGameWebeventsEvent: IndexingDocjoinerDataVersionVersionInfo
    personalizationGameWebeventsEvents: IndexingDocjoinerDataVersionVersionInfo
    photosGeoAnnotation: IndexingDocjoinerDataVersionVersionInfo
    predictedAuthenticity: IndexingDocjoinerDataVersionVersionInfo
    priceAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityAnchorsOutdegreeOutdegreeInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityAnimaLivewebLivewebAttachment: IndexingDocjoinerDataVersionVersionInfo
    qualityAnimaRoutinesRoutinesPropertiesProto: IndexingDocjoinerDataVersionVersionInfo
    qualityAuthorityTopicEmbeddings: IndexingDocjoinerDataVersionVersionInfo
    qualityAuthorshipAuthorAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityBreadcrumbsBreadcrumbAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityCalypsoAppsLink: IndexingDocjoinerDataVersionVersionInfo
    qualityChardDocument: IndexingDocjoinerDataVersionVersionInfo
    qualityChardPredictedQueryFringeScore: IndexingDocjoinerDataVersionVersionInfo
    qualityChardPredictedXlq: IndexingDocjoinerDataVersionVersionInfo
    qualityContraSelectedAttributions: IndexingDocjoinerDataVersionVersionInfo
    qualityCopiaFireflySiteInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityDiscoverUgcScatScatEmbeddingAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityDniNewsstandPcu: IndexingDocjoinerDataVersionVersionInfo
    qualityDniPcuAuxiliaryData: IndexingDocjoinerDataVersionVersionInfo
    qualityDniPcuMetaAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityDniPcuParsedData: IndexingDocjoinerDataVersionVersionInfo
    qualityDniPcuRawData: IndexingDocjoinerDataVersionVersionInfo
    qualityExploreQueryableFeedEcsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityExploreQueryableFeedHashtagAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityExploreQueryableFeedHashtagListAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityExploreQueryableFeedTopicFeedScoringSignals: IndexingDocjoinerDataVersionVersionInfo
    qualityFreshnessAbacusInstantNegativeClicksInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityFringeFringeQueryPrior: IndexingDocjoinerDataVersionVersionInfo
    qualityGeoBrainlocGoldmineBrainlocAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityGeoLoglocGoldmineDocumentLocationAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityHistoricalContentAge: IndexingDocjoinerDataVersionVersionInfo
    qualityHorizonProtoHorizonEmbeddings: IndexingDocjoinerDataVersionVersionInfo
    qualityHorizonRecordInfoAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityImprovDocToQueries: IndexingDocjoinerDataVersionVersionInfo
    qualityImprovImprovAnchors: IndexingDocjoinerDataVersionVersionInfo
    qualityLisztomaniaDocument: IndexingDocjoinerDataVersionVersionInfo
    qualityNavboostCrapsCrapsData: IndexingDocjoinerDataVersionVersionInfo
    qualityNavboostCrapsCrapsPatternSignal: IndexingDocjoinerDataVersionVersionInfo
    qualityNegativeClicksNegativeClicksInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityNlqStructuredSearchAnnotationAnalysisAutomaticExtractionAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityNlqStructuredSearchListingPagesListingPageAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrDokiAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrNsrData: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrNsrSitechunksAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrPairwiseqPairwiseQData: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrPqData: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrSiteAuthority: IndexingDocjoinerDataVersionVersionInfo
    qualityNsrUvSitechunksAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityOrbitAsteroidBeltIntermediateDocumentIntentScores: IndexingDocjoinerDataVersionVersionInfo
    qualityPagemasterPagemasterAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticIndexingDiscoverCorpusAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticIndexingDiscoverDocumentSignal: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticIndexingPanopticAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticStorytimeAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticStorytimeScoringSignals: IndexingDocjoinerDataVersionVersionInfo
    qualityPanopticVoiceUgcAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityPeoplesearchNamedetectorNameOccurrenceAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPopfeedsChromeBackgroundAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityPopfeedsHubDataAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPopfeedsUrlPredictionAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPopfeedsUrlSourceAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPricedetectorKefirPriceAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityPricedetectorProductBlockAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityProseJsonLdAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityProseThumbnailSelection: IndexingDocjoinerDataVersionVersionInfo
    qualityQ2QualityBoost: IndexingDocjoinerDataVersionVersionInfo
    qualityQ2SiteQualityFeatures: IndexingDocjoinerDataVersionVersionInfo
    qualityRealtimeBoostRealtimeBoostEvent: IndexingDocjoinerDataVersionVersionInfo
    qualityRealtimeBoostRealtimeBoostResponse: IndexingDocjoinerDataVersionVersionInfo
    qualityRealtimeBoostSeismographEventAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityRealtimeRealtimeResultInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityRealtimeRtFactAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityResultFilteringIndexingClusterAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityRichsnippetsAppsProtosApplicationInformationAttachment: IndexingDocjoinerDataVersionVersionInfo
    qualityRodinRodinSiteSignal: IndexingDocjoinerDataVersionVersionInfo
    qualitySalientCountriesSalientCountrySet: IndexingDocjoinerDataVersionVersionInfo
    qualitySalientStructuresSalientStructureSet: IndexingDocjoinerDataVersionVersionInfo
    qualitySalientStuffSalientStuffSet: IndexingDocjoinerDataVersionVersionInfo
    qualitySalientTermsQuerySmearingModel: IndexingDocjoinerDataVersionVersionInfo
    qualitySalientTermsSalientTermSet: IndexingDocjoinerDataVersionVersionInfo
    qualitySearchoversiteAnnotatorStructuredResultsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualitySherlockKnexAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityShoppingProductReview: IndexingDocjoinerDataVersionVersionInfo
    qualityShoppingProductReviewPage: IndexingDocjoinerDataVersionVersionInfo
    qualityShoppingShoppingProductReviewAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualitySimilarpagesRelatedInfoSignal: IndexingDocjoinerDataVersionVersionInfo
    qualitySitemapDocument: IndexingDocjoinerDataVersionVersionInfo
    qualitySitemapThirdPartyCarouselsItemLists: IndexingDocjoinerDataVersionVersionInfo
    qualitySixfaceSixfaceUrlData: IndexingDocjoinerDataVersionVersionInfo
    qualitySnippetsHiddenTextHiddenSpanAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualitySnippetsListSnippetsAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualitySnippetsMetadescriptionDuplicateMetaSiteSignal: IndexingDocjoinerDataVersionVersionInfo
    qualitySnippetsSnippetSpansInfo: IndexingDocjoinerDataVersionVersionInfo
    qualitySosGoldmineSosAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualitySummarySummary: IndexingDocjoinerDataVersionVersionInfo
    qualityTangramInformationTypes: IndexingDocjoinerDataVersionVersionInfo
    qualityTimebasedTimeSensitivityTimeSensitivityAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityTitlesAlternativeTitlesInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityTitlesSitelinksTargetTitleInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityTwiddlerDomainClassification: IndexingDocjoinerDataVersionVersionInfo
    qualityViewsAnswersAnswerAnnotationInfo: IndexingDocjoinerDataVersionVersionInfo
    qualityVisualwebVisualWebAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityVisualwebVisualWebModelsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    qualityWebanswersAltTitleSaftDoc: IndexingDocjoinerDataVersionVersionInfo
    qualityWebanswersTranscriptAnnotations: IndexingDocjoinerDataVersionVersionInfo
    qualityWebfeederDocEmbedding: IndexingDocjoinerDataVersionVersionInfo
    qualityWebshineDocResources: IndexingDocjoinerDataVersionVersionInfo
    rankBoostDocAttachment: IndexingDocjoinerDataVersionVersionInfo
    rankembed: IndexingDocjoinerDataVersionVersionInfo
    relativeDateAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsAddressAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsAmenitiesAmenitiesAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsCrawzallAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsDiscussionThreadDiscussionViewProto: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsLicensedResources: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsListFilterAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsListSummaryAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsMicrodataMicrodataAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsMicroformatsHproduct: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsMicroformatsMicroformatAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsPhoneTypePhoneTypeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsRdfaRdfaAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsRodinArticleAnnotation: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSectionHeadingAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSnippetSegmentSnippetSegmentAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeAuthoritySignal: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeDeeplinkAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeExtractorTopicAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeExtractorTripleAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeSporeEtlAnnotation: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsSporeSporeEtlInputAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsStorehoursStoreHoursAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsVerseAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryAnnotationsWebanswersContextItemAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryProtiumEncyclojoinsEncycloJoin: IndexingDocjoinerDataVersionVersionInfo
    repositoryProtiumGoldmineTriplificationResult: IndexingDocjoinerDataVersionVersionInfo
    repositoryProtiumGoldmineTypeAssertionOutput: IndexingDocjoinerDataVersionVersionInfo
    repositoryProtiumWebkvWebKv: IndexingDocjoinerDataVersionVersionInfo
    repositoryProtiumWikiaWikiaInfo: IndexingDocjoinerDataVersionVersionInfo
    repositoryUpdaterIndexSelectionAttachment: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefEntityJoin: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefExperimentalWebrefEntitiesAttachment: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefGraphMention: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefJuggernautIndices: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefPageClassificationAnchorSignalsSet: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefPageClassificationSignalsSet: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefPiannoDocumentIntents: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefPiannoTvSeasonEpisode: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefPreprocessingReferencePageCandidateList: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefReconcileResponse: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefRefconJugglerReferencePageMappings: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefReferencePagesClassifierScoredPage: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefSalientEntitySet: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefUndermergedEntities: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefUniversalEmbeddingRetrievalDebug: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebitIntermediaryMids: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebitScopeFprint: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebitScopeSignals: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebitTripleSignals: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebrefEntities: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebrefWebrefStatus: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebtablesDataTableAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebtablesDataTableMidAnnotation: IndexingDocjoinerDataVersionVersionInfo
    repositoryWebtablesTranslationMessage: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaAliasList: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaAnnotatorWikipediaPageComponentAnnotations: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaSentenceCompressionAnnotation: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaWikiJoin: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaWikiMapperTripleSet: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaWikibaseEntity: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaWikidataOrgTripleSet: IndexingDocjoinerDataVersionVersionInfo
    repositoryWikipediaWikitrustWikiTrustInfo: IndexingDocjoinerDataVersionVersionInfo
    researchCoauthorOpinionAnnotations: IndexingDocjoinerDataVersionVersionInfo
    researchStructuredDataInadvertentAnchorScoreAnnotation: IndexingDocjoinerDataVersionVersionInfo
    researchStructuredDataKnowledgeExplorationAnnotations: IndexingDocjoinerDataVersionVersionInfo
    researchStructuredDataNewsEmbeddingAnnotations: IndexingDocjoinerDataVersionVersionInfo
    richsnippetsDataObject: IndexingDocjoinerDataVersionVersionInfo
    richsnippetsFeedPageMap: IndexingDocjoinerDataVersionVersionInfo
    richsnippetsPageMap: IndexingDocjoinerDataVersionVersionInfo
    richsnippetsPageMapAnnotations: IndexingDocjoinerDataVersionVersionInfo
    richsnippetsSchemaThing: IndexingDocjoinerDataVersionVersionInfo
    rosettaLanguage: IndexingDocjoinerDataVersionVersionInfo
    safesearchPageClassifierOutput: IndexingDocjoinerDataVersionVersionInfo
    safesearchSafeSearchInternalPageSignals: IndexingDocjoinerDataVersionVersionInfo
    scienceIndexSignal: IndexingDocjoinerDataVersionVersionInfo
    searchEngagementHighlightSharedHighlightSignal: IndexingDocjoinerDataVersionVersionInfo
    searcharSearchArPipelineSignal: IndexingDocjoinerDataVersionVersionInfo
    shoppingQualityShoppingSiteClassifier: IndexingDocjoinerDataVersionVersionInfo
    shoppingQualityShoppingSiteClassifierShopfab: IndexingDocjoinerDataVersionVersionInfo
    shoppingWebentityShoppingAnnotation: IndexingDocjoinerDataVersionVersionInfo
    sitemapsSitemapsSignals: IndexingDocjoinerDataVersionVersionInfo
    smearingSmearedTerms: IndexingDocjoinerDataVersionVersionInfo
    socialPersonalizationKnexAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamBrainSpamBrainData: IndexingDocjoinerDataVersionVersionInfo
    spamBrainSpamBrainPageClassifierAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamContentAnchorDist: IndexingDocjoinerDataVersionVersionInfo
    spamContentAuthenticAuthenticTextAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamContentImageMapPb: IndexingDocjoinerDataVersionVersionInfo
    spamContentSiteAgeStats: IndexingDocjoinerDataVersionVersionInfo
    spamCookbookCookbookAnnotations: IndexingDocjoinerDataVersionVersionInfo
    spamCookbookCookbookSitechunkAnnotations: IndexingDocjoinerDataVersionVersionInfo
    spamFatpingIndexFeed: IndexingDocjoinerDataVersionVersionInfo
    spamGodclusterAffIdAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamGodclusterServerHeaderAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamGooglebombsGooglebombsAnnotation: IndexingDocjoinerDataVersionVersionInfo
    spamHackedSitesDocSpamInfo: IndexingDocjoinerDataVersionVersionInfo
    spamHackedSitesGpgbGpgbNgramStats: IndexingDocjoinerDataVersionVersionInfo
    spamHackedSitesWordFrequencies: IndexingDocjoinerDataVersionVersionInfo
    spamJsJsInfo: IndexingDocjoinerDataVersionVersionInfo
    spamScamScamness: IndexingDocjoinerDataVersionVersionInfo
    spamScamUnauthoritativeSite: IndexingDocjoinerDataVersionVersionInfo
    spamTokensSpamTokensAnnotation: IndexingDocjoinerDataVersionVersionInfo
    tableTalkStrideOfferPagePriceAnnotation: IndexingDocjoinerDataVersionVersionInfo
    tasksTabaTabaDocSignals: IndexingDocjoinerDataVersionVersionInfo
    telephoneNumberAnnotations: IndexingDocjoinerDataVersionVersionInfo
    timeAnnotationTags: IndexingDocjoinerDataVersionVersionInfo
    timeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    timeRangeAnnotations: IndexingDocjoinerDataVersionVersionInfo
    travelAssistantTravelDocClassification: IndexingDocjoinerDataVersionVersionInfo
    ucpSignal: IndexingDocjoinerDataVersionVersionInfo
    udrConverterDocumentShoppingData: IndexingDocjoinerDataVersionVersionInfo
    udrConverterOffer: IndexingDocjoinerDataVersionVersionInfo
    udrConverterProductBlockData: IndexingDocjoinerDataVersionVersionInfo
    udrProtoDetailedEntityScores: IndexingDocjoinerDataVersionVersionInfo
    udrProtoOverlay: IndexingDocjoinerDataVersionVersionInfo
    udrProtoWebrefMention: IndexingDocjoinerDataVersionVersionInfo
    universalFacts: IndexingDocjoinerDataVersionVersionInfo
    unwantedImageDataList: IndexingDocjoinerDataVersionVersionInfo
    uriAnnotations: IndexingDocjoinerDataVersionVersionInfo
    utilStatusProto: IndexingDocjoinerDataVersionVersionInfo
    verticalsDiscussionDiscussionAnnotationTag: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlAutomatedAudioExtractionSignals: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlAutomatedExtractionSignals: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlDomainVideoClickData: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlVideoClickData: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlVideoSalientTermSet: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlVideoScoringSignals: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlWatchPagePatternClassification: IndexingDocjoinerDataVersionVersionInfo
    videoCrawlYoutubeEmbedSignal: IndexingDocjoinerDataVersionVersionInfo
    videoScoringSignal: IndexingDocjoinerDataVersionVersionInfo
    videoWebGallery: IndexingDocjoinerDataVersionVersionInfo
    videoYoutubeLiveCardioCardioStats: IndexingDocjoinerDataVersionVersionInfo
    volt: IndexingDocjoinerDataVersionVersionInfo
    watchpageLanguageWatchPageLanguageResult: IndexingDocjoinerDataVersionVersionInfo
    websitetoolsFeedsAnnotationsFeedContentAnnotations: IndexingDocjoinerDataVersionVersionInfo
    websitetoolsFeedsLinkedFeedLinkedFeed: IndexingDocjoinerDataVersionVersionInfo
    websitetoolsFeedsPodcastPodcastSignals: IndexingDocjoinerDataVersionVersionInfo
    websitetoolsFeedsSporeFeedsSporeTriples: IndexingDocjoinerDataVersionVersionInfo
    whatshappStrideExtractions: IndexingDocjoinerDataVersionVersionInfo
    youtubeAlexandriaYoutubeBody: IndexingDocjoinerDataVersionVersionInfo
    youtubeAlexandriaYoutubeSignal: IndexingDocjoinerDataVersionVersionInfo

@typing.type_check_only
class IndexingDocjoinerDataVersionVersionInfo(typing_extensions.TypedDict, total=False):
    considerationTimestampMicros: str
    humanReadableVersion: str
    timestampMicros: str

@typing.type_check_only
class IndexingDocjoinerServingTimeClusterId(typing_extensions.TypedDict, total=False):
    clusterId: str
    indexForDebugging: int
    reason: typing_extensions.Literal[
        "UNKNOWN",
        "LINK_REL_NEXT_PREVIOUS",
        "PAGE_PARAMETER_INFO",
        "DEPRECATED_DO_NOT_USE_LANGUAGE_REGION_VARIATION",
        "SITE_DUP",
        "FLIPPED_CANONICAL",
        "MOBILE_REDIRECTION_DUP",
        "BROKEN_REL_CANONICAL",
        "ROBOTED_SAME_HOST",
        "DEPRECATED_DO_NOT_USE_SAME_PRE_RENDER_CHECKSUM",
    ]

@typing.type_check_only
class IndexingDocjoinerServingTimeClusterIds(typing_extensions.TypedDict, total=False):
    clusterId: _list[IndexingDocjoinerServingTimeClusterId]

@typing.type_check_only
class IndexingDupsComputedLocalizedAlternateNamesLocaleEntry(
    typing_extensions.TypedDict, total=False
):
    clusterId: str
    deviceMatchInfo: typing_extensions.Literal[
        "UNKNOWN", "WWW_TO_WWW", "WWW_TO_M", "M_TO_M", "M_TO_WWW"
    ]
    language: str
    url: str
    urlEncoding: int
    urlRegionCode: int

@typing.type_check_only
class IndexingDupsLocalizedLocalizedCluster(typing_extensions.TypedDict, total=False):
    boostSourceBlocker: bool
    cluster: _list[IndexingDupsLocalizedLocalizedClusterCluster]
    deprecatedHreflangInfo: IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfo
    deprecatedOutlinksInfo: IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfo
    documentLanguage: typing_extensions.Literal[
        "ENGLISH",
        "DANISH",
        "DUTCH",
        "FINNISH",
        "FRENCH",
        "GERMAN",
        "HEBREW",
        "ITALIAN",
        "JAPANESE",
        "KOREAN",
        "NORWEGIAN",
        "POLISH",
        "PORTUGUESE",
        "RUSSIAN",
        "SPANISH",
        "SWEDISH",
        "CHINESE",
        "CZECH",
        "GREEK",
        "ICELANDIC",
        "LATVIAN",
        "LITHUANIAN",
        "ROMANIAN",
        "HUNGARIAN",
        "ESTONIAN",
        "TG_UNKNOWN_LANGUAGE",
        "UNKNOWN_LANGUAGE",
        "BULGARIAN",
        "CROATIAN",
        "SERBIAN",
        "IRISH",
        "GALICIAN",
        "TAGALOG",
        "TURKISH",
        "UKRAINIAN",
        "HINDI",
        "MACEDONIAN",
        "BENGALI",
        "INDONESIAN",
        "LATIN",
        "MALAY",
        "MALAYALAM",
        "WELSH",
        "NEPALI",
        "TELUGU",
        "ALBANIAN",
        "TAMIL",
        "BELARUSIAN",
        "JAVANESE",
        "OCCITAN",
        "URDU",
        "BIHARI",
        "GUJARATI",
        "THAI",
        "ARABIC",
        "CATALAN",
        "ESPERANTO",
        "BASQUE",
        "INTERLINGUA",
        "KANNADA",
        "PUNJABI",
        "SCOTS_GAELIC",
        "SWAHILI",
        "SLOVENIAN",
        "MARATHI",
        "MALTESE",
        "VIETNAMESE",
        "FRISIAN",
        "SLOVAK",
        "CHINESE_T",
        "FAROESE",
        "SUNDANESE",
        "UZBEK",
        "AMHARIC",
        "AZERBAIJANI",
        "GEORGIAN",
        "TIGRINYA",
        "PERSIAN",
        "BOSNIAN",
        "SINHALESE",
        "NORWEGIAN_N",
        "PORTUGUESE_P",
        "PORTUGUESE_B",
        "XHOSA",
        "ZULU",
        "GUARANI",
        "SESOTHO",
        "TURKMEN",
        "KYRGYZ",
        "BRETON",
        "TWI",
        "YIDDISH",
        "SERBO_CROATIAN",
        "SOMALI",
        "UIGHUR",
        "KURDISH",
        "MONGOLIAN",
        "ARMENIAN",
        "LAOTHIAN",
        "SINDHI",
        "RHAETO_ROMANCE",
        "AFRIKAANS",
        "LUXEMBOURGISH",
        "BURMESE",
        "KHMER",
        "TIBETAN",
        "DHIVEHI",
        "CHEROKEE",
        "SYRIAC",
        "LIMBU",
        "ORIYA",
        "ASSAMESE",
        "CORSICAN",
        "INTERLINGUE",
        "KAZAKH",
        "LINGALA",
        "MOLDAVIAN",
        "PASHTO",
        "QUECHUA",
        "SHONA",
        "TAJIK",
        "TATAR",
        "TONGA",
        "YORUBA",
        "CREOLES_AND_PIDGINS_ENGLISH_BASED",
        "CREOLES_AND_PIDGINS_FRENCH_BASED",
        "CREOLES_AND_PIDGINS_PORTUGUESE_BASED",
        "CREOLES_AND_PIDGINS_OTHER",
        "MAORI",
        "WOLOF",
        "ABKHAZIAN",
        "AFAR",
        "AYMARA",
        "BASHKIR",
        "BISLAMA",
        "DZONGKHA",
        "FIJIAN",
        "GREENLANDIC",
        "HAUSA",
        "HAITIAN_CREOLE",
        "INUPIAK",
        "INUKTITUT",
        "KASHMIRI",
        "KINYARWANDA",
        "MALAGASY",
        "NAURU",
        "OROMO",
        "RUNDI",
        "SAMOAN",
        "SANGO",
        "SANSKRIT",
        "SISWANT",
        "TSONGA",
        "TSWANA",
        "VOLAPUK",
        "ZHUANG",
        "KHASI",
        "SCOTS",
        "GANDA",
        "MANX",
        "MONTENEGRIN",
        "AKAN",
        "IGBO",
        "MAURITIAN_CREOLE",
        "HAWAIIAN",
        "CEBUANO",
        "EWE",
        "GA",
        "HMONG",
        "KRIO",
        "LOZI",
        "LUBA_LULUA",
        "LUO_KENYA_AND_TANZANIA",
        "NEWARI",
        "NYANJA",
        "OSSETIAN",
        "PAMPANGA",
        "PEDI",
        "RAJASTHANI",
        "SESELWA_CREOLE_FRENCH",
        "TUMBUKA",
        "VENDA",
        "WARAY_PHILIPPINES",
        "NUM_LANGUAGES",
    ]
    hreflangTargetLink: IndexingDupsLocalizedLocalizedClusterTargetLinkSets
    inbodyTargetLink: IndexingDupsLocalizedLocalizedClusterTargetLinkSets
    outlinksTargetLink: IndexingDupsLocalizedLocalizedClusterTargetLinkSets
    sitedupRuleId: _list[str]
    warningMessage: _list[str]

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterCluster(
    typing_extensions.TypedDict, total=False
):
    clusterId: str
    clusterType: typing_extensions.Literal[
        "UNDEFINED_CLUSTER_TYPE",
        "COMPUTED_ORGMAP",
        "COMPUTED_URL_PATTERN",
        "HREFLANG_ANNOTATION",
        "HREFLANG_ANNOTATION_OPTIMISTIC_GUESS",
        "HREFLANG_ANNOTATION_FROM_BODY",
        "PAGE_OUTLINKS",
        "NOT_USED_4",
        "NOT_USED_6",
        "NOT_USED_8",
        "NOT_USED_9",
    ]
    deprecatedDebugInfo: _list[str]
    filteringEnabled: bool
    language: typing_extensions.Literal[
        "ENGLISH",
        "DANISH",
        "DUTCH",
        "FINNISH",
        "FRENCH",
        "GERMAN",
        "HEBREW",
        "ITALIAN",
        "JAPANESE",
        "KOREAN",
        "NORWEGIAN",
        "POLISH",
        "PORTUGUESE",
        "RUSSIAN",
        "SPANISH",
        "SWEDISH",
        "CHINESE",
        "CZECH",
        "GREEK",
        "ICELANDIC",
        "LATVIAN",
        "LITHUANIAN",
        "ROMANIAN",
        "HUNGARIAN",
        "ESTONIAN",
        "TG_UNKNOWN_LANGUAGE",
        "UNKNOWN_LANGUAGE",
        "BULGARIAN",
        "CROATIAN",
        "SERBIAN",
        "IRISH",
        "GALICIAN",
        "TAGALOG",
        "TURKISH",
        "UKRAINIAN",
        "HINDI",
        "MACEDONIAN",
        "BENGALI",
        "INDONESIAN",
        "LATIN",
        "MALAY",
        "MALAYALAM",
        "WELSH",
        "NEPALI",
        "TELUGU",
        "ALBANIAN",
        "TAMIL",
        "BELARUSIAN",
        "JAVANESE",
        "OCCITAN",
        "URDU",
        "BIHARI",
        "GUJARATI",
        "THAI",
        "ARABIC",
        "CATALAN",
        "ESPERANTO",
        "BASQUE",
        "INTERLINGUA",
        "KANNADA",
        "PUNJABI",
        "SCOTS_GAELIC",
        "SWAHILI",
        "SLOVENIAN",
        "MARATHI",
        "MALTESE",
        "VIETNAMESE",
        "FRISIAN",
        "SLOVAK",
        "CHINESE_T",
        "FAROESE",
        "SUNDANESE",
        "UZBEK",
        "AMHARIC",
        "AZERBAIJANI",
        "GEORGIAN",
        "TIGRINYA",
        "PERSIAN",
        "BOSNIAN",
        "SINHALESE",
        "NORWEGIAN_N",
        "PORTUGUESE_P",
        "PORTUGUESE_B",
        "XHOSA",
        "ZULU",
        "GUARANI",
        "SESOTHO",
        "TURKMEN",
        "KYRGYZ",
        "BRETON",
        "TWI",
        "YIDDISH",
        "SERBO_CROATIAN",
        "SOMALI",
        "UIGHUR",
        "KURDISH",
        "MONGOLIAN",
        "ARMENIAN",
        "LAOTHIAN",
        "SINDHI",
        "RHAETO_ROMANCE",
        "AFRIKAANS",
        "LUXEMBOURGISH",
        "BURMESE",
        "KHMER",
        "TIBETAN",
        "DHIVEHI",
        "CHEROKEE",
        "SYRIAC",
        "LIMBU",
        "ORIYA",
        "ASSAMESE",
        "CORSICAN",
        "INTERLINGUE",
        "KAZAKH",
        "LINGALA",
        "MOLDAVIAN",
        "PASHTO",
        "QUECHUA",
        "SHONA",
        "TAJIK",
        "TATAR",
        "TONGA",
        "YORUBA",
        "CREOLES_AND_PIDGINS_ENGLISH_BASED",
        "CREOLES_AND_PIDGINS_FRENCH_BASED",
        "CREOLES_AND_PIDGINS_PORTUGUESE_BASED",
        "CREOLES_AND_PIDGINS_OTHER",
        "MAORI",
        "WOLOF",
        "ABKHAZIAN",
        "AFAR",
        "AYMARA",
        "BASHKIR",
        "BISLAMA",
        "DZONGKHA",
        "FIJIAN",
        "GREENLANDIC",
        "HAUSA",
        "HAITIAN_CREOLE",
        "INUPIAK",
        "INUKTITUT",
        "KASHMIRI",
        "KINYARWANDA",
        "MALAGASY",
        "NAURU",
        "OROMO",
        "RUNDI",
        "SAMOAN",
        "SANGO",
        "SANSKRIT",
        "SISWANT",
        "TSONGA",
        "TSWANA",
        "VOLAPUK",
        "ZHUANG",
        "KHASI",
        "SCOTS",
        "GANDA",
        "MANX",
        "MONTENEGRIN",
        "AKAN",
        "IGBO",
        "MAURITIAN_CREOLE",
        "HAWAIIAN",
        "CEBUANO",
        "EWE",
        "GA",
        "HMONG",
        "KRIO",
        "LOZI",
        "LUBA_LULUA",
        "LUO_KENYA_AND_TANZANIA",
        "NEWARI",
        "NYANJA",
        "OSSETIAN",
        "PAMPANGA",
        "PEDI",
        "RAJASTHANI",
        "SESELWA_CREOLE_FRENCH",
        "TUMBUKA",
        "VENDA",
        "WARAY_PHILIPPINES",
        "NUM_LANGUAGES",
    ]
    regionCode: int
    urlRegionCode: int

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfo(
    typing_extensions.TypedDict, total=False
):
    fpOutlinks: str
    lastModifiedInputTimestampMs: str
    lastProcessedOutputTimestampMs: str
    linkMember: _list[
        IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfoLinkMember
    ]
    unvalidatedOutlink: _list[
        IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfoLinkData
    ]

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfoLinkData(
    typing_extensions.TypedDict, total=False
):
    annotationSource: typing_extensions.Literal["HTTP", "HTML", "SITEMAP"]
    crawlTimestamp: int
    url: str

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterLinkBasedClusterInfoLinkMember(
    typing_extensions.TypedDict, total=False
):
    annotationSource: typing_extensions.Literal["HTTP", "HTML", "SITEMAP"]
    languageCode: _list[str]
    url: str

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLink(
    typing_extensions.TypedDict, total=False
):
    linkData: IndexingDupsLocalizedLocalizedClusterTargetLinkLink
    metaData: IndexingDupsLocalizedLocalizedClusterTargetLinkMetadata
    targetDocData: IndexingDupsLocalizedLocalizedClusterTargetLinkTargetDocData
    validationStatus: typing_extensions.Literal[
        "VALIDATION_UNKNOWN",
        "SELFLINK",
        "NO_BACKLINK",
        "HAS_BACKLINK",
        "BLINDLY_TRUSTED",
        "BLINDLY_TRUSTED_WITH_BACKLINK",
    ]

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLinkLink(
    typing_extensions.TypedDict, total=False
):
    annotationSourceInfo: _list[
        IndexingDupsLocalizedLocalizedClusterTargetLinkLinkAnnotationSourceInfo
    ]
    crossDomain: bool
    url: str

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLinkLinkAnnotationSourceInfo(
    typing_extensions.TypedDict, total=False
):
    anchorText: str
    annotationSource: typing_extensions.Literal["HTTP", "HTML", "SITEMAP"]
    languageCode: str
    sourceFeedUrl: str

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLinkMetadata(
    typing_extensions.TypedDict, total=False
):
    firstSeenMs: str
    lastVerifiedMs: str

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLinkSets(
    typing_extensions.TypedDict, total=False
):
    directTargetLink: _list[IndexingDupsLocalizedLocalizedClusterTargetLink]
    indirectTargetLink: _list[IndexingDupsLocalizedLocalizedClusterTargetLink]

@typing.type_check_only
class IndexingDupsLocalizedLocalizedClusterTargetLinkTargetDocData(
    typing_extensions.TypedDict, total=False
):
    contentLanguage: typing_extensions.Literal[
        "ENGLISH",
        "DANISH",
        "DUTCH",
        "FINNISH",
        "FRENCH",
        "GERMAN",
        "HEBREW",
        "ITALIAN",
        "JAPANESE",
        "KOREAN",
        "NORWEGIAN",
        "POLISH",
        "PORTUGUESE",
        "RUSSIAN",
        "SPANISH",
        "SWEDISH",
        "CHINESE",
        "CZECH",
        "GREEK",
        "ICELANDIC",
        "LATVIAN",
        "LITHUANIAN",
        "ROMANIAN",
        "HUNGARIAN",
        "ESTONIAN",
        "TG_UNKNOWN_LANGUAGE",
        "UNKNOWN_LANGUAGE",
        "BULGARIAN",
        "CROATIAN",
        "SERBIAN",
        "IRISH",
        "GALICIAN",
        "TAGALOG",
        "TURKISH",
        "UKRAINIAN",
        "HINDI",
        "MACEDONIAN",
        "BENGALI",
        "INDONESIAN",
        "LATIN",
        "MALAY",
        "MALAYALAM",
        "WELSH",
        "NEPALI",
        "TELUGU",
        "ALBANIAN",
        "TAMIL",
        "BELARUSIAN",
        "JAVANESE",
        "OCCITAN",
        "URDU",
        "BIHARI",
        "GUJARATI",
        "THAI",
        "ARABIC",
        "CATALAN",
        "ESPERANTO",
        "BASQUE",
        "INTERLINGUA",
        "KANNADA",
        "PUNJABI",
        "SCOTS_GAELIC",
        "SWAHILI",
        "SLOVENIAN",
        "MARATHI",
        "MALTESE",
        "VIETNAMESE",
        "FRISIAN",
        "SLOVAK",
        "CHINESE_T",
        "FAROESE",
        "SUNDANESE",
        "UZBEK",
        "AMHARIC",
        "AZERBAIJANI",
        "GEORGIAN",
        "TIGRINYA",
        "PERSIAN",
        "BOSNIAN",
        "SINHALESE",
        "NORWEGIAN_N",
        "PORTUGUESE_P",
        "PORTUGUESE_B",
        "XHOSA",
        "ZULU",
        "GUARANI",
        "SESOTHO",
        "TURKMEN",
        "KYRGYZ",
        "BRETON",
        "TWI",
        "YIDDISH",
        "SERBO_CROATIAN",
        "SOMALI",
        "UIGHUR",
        "KURDISH",
        "MONGOLIAN",
        "ARMENIAN",
        "LAOTHIAN",
        "SINDHI",
        "RHAETO_ROMANCE",
        "AFRIKAANS",
        "LUXEMBOURGISH",
        "BURMESE",
        "KHMER",
        "TIBETAN",
        "DHIVEHI",
        "CHEROKEE",
        "SYRIAC",
        "LIMBU",
        "ORIYA",
        "ASSAMESE",
        "CORSICAN",
        "INTERLINGUE",
        "KAZAKH",
        "LINGALA",
        "MOLDAVIAN",
        "PASHTO",
        "QUECHUA",
        "SHONA",
        "TAJIK",
        "TATAR",
        "TONGA",
        "YORUBA",
        "CREOLES_AND_PIDGINS_ENGLISH_BASED",
        "CREOLES_AND_PIDGINS_FRENCH_BASED",
        "CREOLES_AND_PIDGINS_PORTUGUESE_BASED",
        "CREOLES_AND_PIDGINS_OTHER",
        "MAORI",
        "WOLOF",
        "ABKHAZIAN",
        "AFAR",
        "AYMARA",
        "BASHKIR",
        "BISLAMA",
        "DZONGKHA",
        "FIJIAN",
        "GREENLANDIC",
        "HAUSA",
        "HAITIAN_CREOLE",
        "INUPIAK",
        "INUKTITUT",
        "KASHMIRI",
        "KINYARWANDA",
        "MALAGASY",
        "NAURU",
        "OROMO",
        "RUNDI",
        "SAMOAN",
        "SANGO",
        "SANSKRIT",
        "SISWANT",
        "TSONGA",
        "TSWANA",
        "VOLAPUK",
        "ZHUANG",
        "KHASI",
        "SCOTS",
        "GANDA",
        "MANX",
        "MONTENEGRIN",
        "AKAN",
        "IGBO",
        "MAURITIAN_CREOLE",
        "HAWAIIAN",
        "CEBUANO",
        "EWE",
        "GA",
        "HMONG",
        "KRIO",
        "LOZI",
        "LUBA_LULUA",
        "LUO_KENYA_AND_TANZANIA",
        "NEWARI",
        "NYANJA",
        "OSSETIAN",
        "PAMPANGA",
        "PEDI",
        "RAJASTHANI",
        "SESELWA_CREOLE_FRENCH",
        "TUMBUKA",
        "VENDA",
        "WARAY_PHILIPPINES",
        "NUM_LANGUAGES",
    ]
    crawlStatus: typing_extensions.Literal["UNKNOWN", "CONTENT", "ROBOTED", "ERROR"]
    crawlTimestampSeconds: int
    isCanonical: bool
    outgoingLinkData: _list[IndexingDupsLocalizedLocalizedClusterTargetLinkLink]

@typing.type_check_only
class IndexingEmbeddedContentEmbeddedContentInfo(
    typing_extensions.TypedDict, total=False
):
    compressedDocumentTrees: str
    convertedContents: str
    embeddedLinksInfo: IndexingEmbeddedContentEmbeddedLinksInfo
    headlessResponse: HtmlrenderWebkitHeadlessProtoRenderResponse
    isAlternateSnapshot: bool
    originalEncoding: int
    rawRedirectInfo: IndexingConverterRawRedirectInfo
    referencedResource: _list[HtmlrenderWebkitHeadlessProtoReferencedResource]
    renderedSnapshot: HtmlrenderWebkitHeadlessProtoImage
    renderedSnapshotImage: str
    renderedSnapshotMetadata: SnapshotSnapshotMetadata
    renderedSnapshotQualityScore: float
    renderingOutputMetadata: IndexingEmbeddedContentRenderingOutputMetadata
    richcontentData: IndexingConverterRichContentData

@typing.type_check_only
class IndexingEmbeddedContentEmbeddedLinksInfo(
    typing_extensions.TypedDict, total=False
):
    embedderInfo: IndexingEmbeddedContentEmbedderInfo
    link: _list[IndexingEmbeddedContentLinkInfo]
    pageSizeInfo: IndexingEmbeddedContentPageSizeInfo
    sumHttpResponseLength: int
    uncrawledLinkUrl: _list[str]

@typing.type_check_only
class IndexingEmbeddedContentEmbedderInfo(typing_extensions.TypedDict, total=False):
    importanceAsEmbedder: int
    linkInfo: IndexingEmbeddedContentLinkInfo

@typing.type_check_only
class IndexingEmbeddedContentFetchHostCount(typing_extensions.TypedDict, total=False):
    counter: _list[IndexingEmbeddedContentFetchHostCountCounter]
    host: str
    num: int

@typing.type_check_only
class IndexingEmbeddedContentFetchHostCountCounter(
    typing_extensions.TypedDict, total=False
):
    name: str
    num: int

@typing.type_check_only
class IndexingEmbeddedContentFetchUrlResponseMetadata(
    typing_extensions.TypedDict, total=False
):
    adsResourceType: typing_extensions.Literal[
        "ADS_TYPE_UNKNOWN",
        "ADS_TYPE_NON_ADS",
        "ADS_TYPE_PATTERN",
        "ADS_TYPE_CENTERPIECE_ADS_MATCHER",
    ]
    crawlStatus: int
    criticalResourceType: typing_extensions.Literal[
        "UNKNOWN",
        "NON_CRITICAL",
        "CONTENT_BASED",
        "GEOMETRY_LAYOUT_BASED",
        "THREE_WAY",
        "MANUAL",
        "TARGET_MAIN_FRAME",
        "ROBOTED",
    ]
    fetchWithSmartphoneUa: bool
    isAdsResource: bool
    isCriticalResource: bool
    isTrivialResource: bool
    numTrawlerFetches: int
    rewriteMethod: str
    robotsInfo: IndexingConverterRobotsInfo

@typing.type_check_only
class IndexingEmbeddedContentLinkInfo(typing_extensions.TypedDict, total=False):
    contentLength: int
    contentType: int
    crawlDuration: int
    crawlStatus: int
    crawlTimestamp: int
    deprecatedRedirect: _list[str]
    fetchSourceInfo: _list[WirelessTranscoderFetchFetchSourceInfo]
    fetchStatus: TrawlerFetchStatus
    fetchUrlResponseMetadata: IndexingEmbeddedContentFetchUrlResponseMetadata
    frd: TrawlerFetchReplyData
    httpResponseLength: int
    isCacheable: bool
    isRobotedContentFromFastnet: bool
    uncompressedContentLength: int
    url: str
    webkitFetchMetadata: HtmlrenderWebkitHeadlessProtoWebKitFetchMetadata

@typing.type_check_only
class IndexingEmbeddedContentOutputGenerationTimestamps(
    typing_extensions.TypedDict, total=False
):
    documentData: int
    renderedSnapshot: int

@typing.type_check_only
class IndexingEmbeddedContentPageSizeInfo(typing_extensions.TypedDict, total=False):
    numImages: int
    numImagesWithContent: int
    numResources: int
    numResourcesWithContent: int
    sumHttpResponseLength: int

@typing.type_check_only
class IndexingEmbeddedContentRenderCacheStats(typing_extensions.TypedDict, total=False):
    cacheExpireTimestampUsec: str
    crawledSimhashDistance: int
    lastRenderedTimestampUsec: str
    renderCache: typing_extensions.Literal[
        "UNKNOWN_CACHE",
        "CACHE_MISS",
        "CACHE_SKIPPED",
        "ARECA_CACHE",
        "CRAWLED_SIMHASH_CACHE",
    ]
    renderedSimhashDistance: int

@typing.type_check_only
class IndexingEmbeddedContentRenderRequestConfigConfigParams(
    typing_extensions.TypedDict, total=False
):
    virtualTime: float

@typing.type_check_only
class IndexingEmbeddedContentRenderingFetchStats(
    typing_extensions.TypedDict, total=False
):
    fetchHostCount: _list[IndexingEmbeddedContentFetchHostCount]

@typing.type_check_only
class IndexingEmbeddedContentRenderingOutputMetadata(
    typing_extensions.TypedDict, total=False
):
    configParams: IndexingEmbeddedContentRenderRequestConfigConfigParams
    exceptions: str
    experimentalRenderTimeMsec: int
    generationTimestamps: IndexingEmbeddedContentOutputGenerationTimestamps
    importance: int
    lastNewContentProbingTimestamp: int
    newTokensPercentageAfterRendering: float
    numNewTokensFoundInRendering: int
    refresh: bool
    renderCacheStats: IndexingEmbeddedContentRenderCacheStats
    renderEngine: typing_extensions.Literal[
        "UNKNOWN", "BLINK_HEADLESS", "CHROME_HEADLESS"
    ]
    renderEvent: _list[HtmlrenderWebkitHeadlessProtoRenderEvent]
    renderServerCl: str
    renderTreeQualityScore: float
    renderedSnapshotSignature: str
    renderedTimeUsec: str
    renderingFetchStats: IndexingEmbeddedContentRenderingFetchStats
    selectionResult: IndexingEmbeddedContentSelectionResult
    snapshotQualityScore: float
    withMissingResources: bool

@typing.type_check_only
class IndexingEmbeddedContentSelectionResult(typing_extensions.TypedDict, total=False):
    renderEffort: typing_extensions.Literal[
        "RENDER_NONE",
        "RENDER_SKIP",
        "RENDER_TRIVIAL",
        "RENDER_LIGHT",
        "RENDER_CONTROL",
        "RENDER_FULL",
        "RENDER_FORCE",
        "RENDER_REJECT",
    ]
    selectorId: typing_extensions.Literal[
        "NO_SELECTOR",
        "INELIGIBLE",
        "NO_INDEX",
        "IMPORTANCE",
        "HOME_PAGE",
        "LIGHT_WEIGHT",
        "SMARTPHONE",
        "VIDEO_SIGNAL",
        "VIDEO_CLASSIFER",
        "PINPOINT_SIGNAL",
        "CENTER_PIECE_SIGNAL",
        "INDEXABLE_FRAGMENT",
        "ESCAPED_FRAGMENT",
        "FRAGMENT_REDIRECT",
        "META_REFRESH_REDIRECT",
        "FORCE",
        "FORCE_BY_TIMESTAMP",
        "INTEREST",
        "IMPORTANCE_PROTECTED",
        "NOT_SUPPORTED_CRAWLER_ID",
        "BLACK_LIST",
        "NEWS_ONLY",
        "SAMPLER",
        "CONTENT_REPLACEMENT_WHITELIST",
        "SMART",
        "SMART_RANDOM",
        "SMARTPHONE_SMART",
        "SMARTPHONE_REJECT",
        "SMART_GROUND_TRUTH",
        "APP",
        "CONTROL_GROUP",
        "NAVBOOST_COUNT",
        "DEFAULT_LIGHT",
        "NEWS",
    ]

@typing.type_check_only
class IndexingMlVerticalVerticalItem(typing_extensions.TypedDict, total=False):
    id: int
    name: str
    petacatId: int
    probability: float

@typing.type_check_only
class IndexingMobileInterstitialsProtoDesktopInterstitials(
    typing_extensions.TypedDict, total=False
):
    details: _list[IndexingMobileInterstitialsProtoDesktopInterstitialsDetails]
    pipelineEpoch: str
    pipelinePattern: str
    urlTree: IndexingUrlPatternUrlTreeUrlTree
    violatesDesktopInterstitialPolicy: bool

@typing.type_check_only
class IndexingMobileInterstitialsProtoDesktopInterstitialsDetails(
    typing_extensions.TypedDict, total=False
):
    basicInfo: IndexingMobileInterstitialsProtoInterstitialBasicInfo
    isSmearedSignal: bool

@typing.type_check_only
class IndexingMobileInterstitialsProtoInterstitialBasicInfo(
    typing_extensions.TypedDict, total=False
):
    absoluteBox: HtmlrenderWebkitHeadlessProtoBox
    contentType: typing_extensions.Literal[
        "UNSPECIFIED",
        "GENERIC",
        "APP_INSTALL_PROMO",
        "COOKIE",
        "ADULT_CONTENT",
        "LOGIN",
        "HEALTH_CARE_PROFESSIONAL",
        "WHITELISTED",
        "ADS",
        "SUBSCRIPTION",
    ]
    detectionMode: typing_extensions.Literal["NORMAL", "DELAYED", "AFTER_SCROLL"]
    layoutType: typing_extensions.Literal[
        "INTERSTITIAL_LAYOUT_TYPE_UNSPECIFIED",
        "OVERLAY",
        "SCROLLABLE",
        "STANDALONE",
        "DENSITY",
    ]

@typing.type_check_only
class IndexingMobileVoltCoreWebVitals(typing_extensions.TypedDict, total=False):
    cls: str
    fid: str
    inp: str
    lcp: str

@typing.type_check_only
class IndexingMobileVoltVoltPerDocData(typing_extensions.TypedDict, total=False):
    desktopCwv: IndexingMobileVoltCoreWebVitals
    desktopDisplayUrlIsHttps: bool
    displayUrlIsHttps: bool
    mobileCwv: IndexingMobileVoltCoreWebVitals

@typing.type_check_only
class IndexingPrivacyAccessAccessRequirements(typing_extensions.TypedDict, total=False):
    restrictionCategories: _list[
        typing_extensions.Literal["UNSPECIFIED", "CHILD_SAFETY_CONTENT"]
    ]

@typing.type_check_only
class IndexingSignalAggregatorAdaptiveIntervalData(
    typing_extensions.TypedDict, total=False
):
    clicksGoodInterval: float
    clicksGoodPriorWeight: float
    clicksTotalInterval: float
    clicksTotalPriorWeight: float
    ctrwiInterval: float
    ctrwiPriorWeight: float
    dwellsInterval: float
    dwellsPriorWeight: float
    luDwellsInterval: float
    luDwellsPriorWeight: float

@typing.type_check_only
class IndexingSignalAggregatorAgeWeightedCoverageData(
    typing_extensions.TypedDict, total=False
):
    averageChanceTime: float
    chances: float
    clicksBad: float
    clicksGood: float
    clicksImage: float
    clicksTotal: float
    clicksUnclassified: float
    coverageTimestamp: str
    ctrWeightedImpressions: float
    dwells: float
    firstBaseCoverageTimestamp: str
    firstCoveragePagerankNs: int
    firstCoverageTimestamp: str
    firstseen: str
    impressions: float
    intervalData: IndexingSignalAggregatorAdaptiveIntervalData
    language: int
    lastDwellDateInDays: int
    lastGoodClickDateInDays: int
    lastImpressionDateInDays: int
    lastLuDwellDateInDays: int
    lastPseudoImpressionsDateInDays: int
    luDwells: float
    repid: str
    totalChances: str
    url: str
    urlfp: str

@typing.type_check_only
class IndexingSignalAggregatorAggregatedScore(typing_extensions.TypedDict, total=False):
    deviation: float
    m2: float
    maxScoreUrl: IndexingSignalAggregatorUrlScore
    mean: float
    meanScore: float
    minScoreUrl: IndexingSignalAggregatorUrlScore
    numImportantUrls: str
    numUrlsMatched: str
    numUrlsWithSignal: str
    patternLayer: typing_extensions.Literal[
        "PRODUCTION", "EXPERIMENTAL_LAYER_A", "EXPERIMENTAL_LAYER_B", "NEXT_LAYER"
    ]
    patternsUsedInMediation: _list[str]
    percentile: _list[float]
    runningMeanAndVarianceInternalState: IndexingSignalAggregatorRunningMeanAndVarianceInternalState
    samples: _list[IndexingSignalAggregatorUrlScore]
    scores: _list[float]
    signalId: int
    singleUrlScore: IndexingSignalAggregatorUrlScore
    totalScore: float
    totalScoreLow: float
    totalScoreSqr: float
    totalScoreSqrLow: float
    totalWeight: float
    totalWeightLow: float

@typing.type_check_only
class IndexingSignalAggregatorRunningMeanAndVarianceInternalState(
    typing_extensions.TypedDict, total=False
):
    m2: float
    mean: float
    totalWeight: float

@typing.type_check_only
class IndexingSignalAggregatorSccData(typing_extensions.TypedDict, total=False):
    parentPattern: IndexingSignalAggregatorSccSignal
    pattern: IndexingSignalAggregatorSccSignal

@typing.type_check_only
class IndexingSignalAggregatorSccSignal(typing_extensions.TypedDict, total=False):
    clicksBad: float
    clicksImage: float
    clicksTotal: float
    debugInfo: _list[str]
    numImageUrls: float
    numUrls: str
    pattern: str

@typing.type_check_only
class IndexingSignalAggregatorUrlPatternSignals(
    typing_extensions.TypedDict, total=False
):
    coverage: IndexingSignalAggregatorAgeWeightedCoverageData
    pagerankScore: IndexingSignalAggregatorAggregatedScore
    patternScore: IndexingSignalAggregatorAggregatedScore
    priorSignal: _list[IndexingSignalAggregatorUrlPatternSignalsPriorSignal]
    regexpPatternScore: IndexingSignalAggregatorAggregatedScore
    sccData: IndexingSignalAggregatorSccData

@typing.type_check_only
class IndexingSignalAggregatorUrlPatternSignalsPriorSignal(
    typing_extensions.TypedDict, total=False
):
    aggregatedScore: IndexingSignalAggregatorAggregatedScore
    priorSignalId: typing_extensions.Literal[
        "PRIOR_SIGNAL_PAGERANK",
        "PRIOR_SIGNAL_PATTERN",
        "PRIOR_SIGNAL_REGEXP_PATTERN",
        "PRIOR_SIGNAL_CLICKRANK",
        "PRIOR_SIGNAL_LENGTH",
        "PRIOR_SIGNAL_SIBYL",
        "PRIOR_SIGNAL_TENSORFLOW",
    ]

@typing.type_check_only
class IndexingSignalAggregatorUrlScore(typing_extensions.TypedDict, total=False):
    dsacNumWeeklyPerfRecords: int
    eligibleExperimentalLayer: typing_extensions.Literal[
        "PRODUCTION", "EXPERIMENTAL_LAYER_A", "EXPERIMENTAL_LAYER_B", "NEXT_LAYER"
    ]
    firstServedTimestamp: str
    isImportant: bool
    score: float
    url: str
    weight: float

@typing.type_check_only
class IndexingSpeechSpeechPropertiesProto(typing_extensions.TypedDict, total=False):
    audioDuration: int
    audioOnly: bool
    estimatedAudioDuration: int
    estimatedAudioDurationConfidence: float
    languageCode: str
    numWords: int
    recognizerAccuracy: float
    speechDuration: int
    truncatedFile: bool

@typing.type_check_only
class IndexingUrlPatternUrlTreeBigTreeBranch(typing_extensions.TypedDict, total=False):
    features: IndexingUrlPatternUrlTreeUrlFeatures
    patternId: str
    payload: Proto2BridgeMessageSet

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlFeature(typing_extensions.TypedDict, total=False):
    fingerprint: str
    fingerprintWithGroupInType: bool
    groupInType: str
    type: typing_extensions.Literal[
        "HOST_SEGMENT",
        "PATH_SEGMENT",
        "DOCUMENT_NAME_SEGMENT",
        "QUERY_NAME",
        "QUERY_VALUE",
        "HOST_SEGMENT_COUNT",
        "PATH_SEGMENT_COUNT",
        "QUERY_COUNT",
        "GMAIL_SUBJECT",
        "GMAIL_BODY_TEXT",
        "GMAIL_BODY_TREE",
        "PROTOCOL",
        "PACKAGE_ID",
        "SCHEME",
        "AUTHORITY",
        "APP_URI_PATH_SEGMENT",
        "APP_URI_PATH_SEGMENT_COUNT",
        "APP_URI_DOCUMENT_NAME_SEGMENT",
        "APP_URI_QUERY_NAME",
        "APP_URI_QUERY_VALUE",
    ]
    value: str

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlFeatures(typing_extensions.TypedDict, total=False):
    feature: _list[IndexingUrlPatternUrlTreeUrlFeature]

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlTree(typing_extensions.TypedDict, total=False):
    bigBranch: _list[IndexingUrlPatternUrlTreeBigTreeBranch]
    debugInfo: IndexingUrlPatternUrlTreeUrlTreeDebugInfo
    key: IndexingUrlPatternUrlTreeUrlTreeKey
    node: _list[IndexingUrlPatternUrlTreeUrlTreeNode]
    retrievalTimestamp: int
    site: str
    timestamp: int
    treeInfo: Proto2BridgeMessageSet

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlTreeDebugInfo(
    typing_extensions.TypedDict, total=False
):
    innerSimilarity: float

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlTreeKey(typing_extensions.TypedDict, total=False):
    crawlerId: typing_extensions.Literal["UNKNOWN", "DESKTOP", "SMARTPHONE"]
    domain: str
    hostname: str

@typing.type_check_only
class IndexingUrlPatternUrlTreeUrlTreeNode(typing_extensions.TypedDict, total=False):
    indexOfSubTreeWithSplittingFeature: int
    indexOfSubTreeWithoutSplittingFeature: int
    parent: int
    pathFromRoot: str
    patternId: str
    payload: Proto2BridgeMessageSet
    splittingFeature: IndexingUrlPatternUrlTreeUrlFeature
    splittingFeatureScore: float

@typing.type_check_only
class IndexingVideosAsrTranscriptRepairAnnotation(
    typing_extensions.TypedDict, total=False
):
    gibberishResult: typing_extensions.Literal[
        "UNDEFINED_GIBBERISH_RESULT",
        "NOT_GIBBERISH",
        "IS_GIBBERISH",
        "GIBBERISH_UNSUPPORTED_LANGUAGE",
        "GIBBERISH_DECLINED",
        "GIBBERISH_DETECTION_FAILED",
    ]
    numGibberishSegments: int
    numSegmentsClassified: int

@typing.type_check_only
class KaltixPerDocData(typing_extensions.TypedDict, total=False):
    KaltixRank: int
    LocalKaltixRank: int
    SiteKaltixRank: int

@typing.type_check_only
class KeGovernanceTypedRegions(typing_extensions.TypedDict, total=False):
    regionType: typing_extensions.Literal[
        "UNKNOWN", "FRONTEND_REGION_CODE", "TRUSTED_LOCATION_VIEW_REGION_CODE"
    ]
    regions: _list[str]

@typing.type_check_only
class KnowledgeAnswersAnyType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersAttributeType(typing_extensions.TypedDict, total=False):
    attribute: _list[str]
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    pivotEntitySlot: str
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersBooleanType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersCollectionType(typing_extensions.TypedDict, total=False):
    collection: _list[str]
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersCompoundType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersContainerType(typing_extensions.TypedDict, total=False):
    slotNames: _list[str]

@typing.type_check_only
class KnowledgeAnswersDateType(typing_extensions.TypedDict, total=False):
    allowAllRangeResolutions: bool
    allowAllResolutions: bool
    allowAllResolutionsExceptHolidays: bool
    allowAllResolutionsWithout4digit24hrTime: bool
    allowAllResolutionsWithoutTime: bool
    allowDayResolution: bool
    allowDayResolutionExceptHolidaysOrOrdinal: bool
    allowHourResolution: bool
    allowMonthResolution: bool
    allowNowResolution: bool
    allowSymbolicTime: bool
    allowTimeResolutionsWithoutExplicitTimezone: bool
    allowYearResolution: bool
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings
    subType: typing_extensions.Literal[
        "DATE_TIME_DEFAULT",
        "DATE_ONLY",
        "DATE_WITH_DAY_OF_WEEK",
        "DATE_YEAR_ONLY",
        "DATE_MONTH_ONLY",
    ]

@typing.type_check_only
class KnowledgeAnswersDependencyType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    containerType: KnowledgeAnswersContainerType
    intersectType: KnowledgeAnswersIntersectType
    remodelings: NlpMeaningMeaningRemodelings
    sameType: KnowledgeAnswersSameType
    unionType: KnowledgeAnswersUnionType

@typing.type_check_only
class KnowledgeAnswersDialogReferentialResolution(
    typing_extensions.TypedDict, total=False
):
    refersToFullMrf: bool
    resolutionType: typing_extensions.Literal[
        "NONE",
        "SAFT_PRONOUN",
        "NOUN_PHRASE",
        "LOCAL_SEMANTIC_FUNCTION_MERGE",
        "CONTEXTUAL_SUBGRAMMAR_ANNOTATION",
        "RIPPLES_LIST_SELECTION",
    ]

@typing.type_check_only
class KnowledgeAnswersDurationType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    rangeConstraint: KnowledgeAnswersRangeConstraint
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersEntityType(typing_extensions.TypedDict, total=False):
    collection: _list[str]
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    excludedCollection: _list[str]
    id: _list[str]
    identifier: _list[KnowledgeAnswersIntentQueryIdentifier]
    inAllCollections: bool
    includeGeolocationData: bool
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersIntentModifiers(typing_extensions.TypedDict, total=False):
    alternateLanguage: str
    definiteness: typing_extensions.Literal[
        "UNKNOWN_DEFINITENESS", "DEFINITE", "INDEFINITE"
    ]
    language: str
    mood: typing_extensions.Literal["UNKNOWN_MOOD", "IMPERATIVE"]
    plurality: typing_extensions.Literal["UNKNOWN_PLURALITY", "SINGULAR", "PLURAL"]
    polarQuestion: bool
    sentiment: SentimentSentiment
    tense: typing_extensions.Literal["UNKNOWN_TENSE", "PRESENT", "FUTURE", "PAST"]

@typing.type_check_only
class KnowledgeAnswersIntentQueryAnnotationLayerSignals(
    typing_extensions.TypedDict, total=False
):
    customVehicleActionArgumentAnnotatorSignals: KnowledgeAnswersIntentQueryCustomVehicleActionArgumentAnnotatorSignals
    freetextAnnotationSignals: KnowledgeAnswersIntentQueryFreetextAnnotationSignals
    nimbleAnnotationSignals: KnowledgeAnswersIntentQueryNimbleAnnotationSignals
    ntprAnnotationSignals: KnowledgeAnswersIntentQueryNTPRAnnotationSignals
    qrefAnnotationSignals: KnowledgeAnswersIntentQueryQrefAnnotationSignals
    semanticAnnotationSignals: KnowledgeAnswersIntentQuerySemanticAnnotationSignals
    teleportArgumentAnnotatorSignals: KnowledgeAnswersIntentQueryTeleportArgumentAnnotatorSignals

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgPath(typing_extensions.TypedDict, total=False):
    components: _list[KnowledgeAnswersIntentQueryArgPathComponent]

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgPathComponent(
    typing_extensions.TypedDict, total=False
):
    argName: str
    index: int

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgument(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    heuristicEvalData: NlpSemanticParsingAnnotationEvalData
    key: KnowledgeAnswersMeaningSchemaSlotKey
    modifiers: KnowledgeAnswersIntentModifiers
    name: str
    signals: KnowledgeAnswersIntentQueryArgumentSignals
    value: KnowledgeAnswersIntentQueryArgumentValue

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenance(
    typing_extensions.TypedDict, total=False
):
    anaphor: KnowledgeAnswersIntentQueryArgumentProvenanceQueryAnaphor
    attentionalEntity: KnowledgeAnswersIntentQueryArgumentProvenanceAttentionalEntity
    currentQuery: KnowledgeAnswersIntentQueryArgumentProvenanceCurrentQuery
    injectedContextualSchema: KnowledgeAnswersIntentQueryArgumentProvenanceInjectedContextualSchema
    previousQuery: KnowledgeAnswersIntentQueryArgumentProvenancePreviousQuery
    previousResponseMeaning: KnowledgeAnswersIntentQueryArgumentProvenancePreviousResponseMeaning
    previousTaskState: KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskState
    searchAnswerValue: KnowledgeAnswersIntentQueryArgumentProvenanceSearchAnswerValue

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceAttentionalEntity(
    typing_extensions.TypedDict, total=False
):
    attentionalEntityKey: str
    mentionProperties: AttentionalEntitiesMentionProperties

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceCurrentQuery(
    typing_extensions.TypedDict, total=False
):
    evalData: _list[NlpSemanticParsingAnnotationEvalData]
    neuralLocationAnnotator: KnowledgeAnswersIntentQueryArgumentProvenanceNeuralLocationAnnotator

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceInjectedContextualSchema(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceNeuralLocationAnnotator(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousQuery(
    typing_extensions.TypedDict, total=False
):
    currentQueryEvalData: _list[NlpSemanticParsingAnnotationEvalData]
    evalData: _list[NlpSemanticParsingAnnotationEvalData]
    eventId: EventIdMessage
    neuralLocationAnnotator: KnowledgeAnswersIntentQueryArgumentProvenanceNeuralLocationAnnotator
    role: KnowledgeAnswersIntentQueryArgumentProvenancePreviousQueryRole
    source: typing_extensions.Literal[
        "UNKNOWN", "QUERY_STRING", "INTERPRETATION", "QUERY_JOIN", "PROMPT"
    ]

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousQueryRole(
    typing_extensions.TypedDict, total=False
):
    intentId: str
    slotName: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousResponseMeaning(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskState(
    typing_extensions.TypedDict, total=False
):
    argumentName: _list[str]
    currentQueryEvalData: _list[NlpSemanticParsingAnnotationEvalData]
    dialogIntentStateId: str
    intentName: str
    listCandidate: KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskStateListCandidate
    previousFunctionCall: KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskStatePreviousFunctionCall

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskStateListCandidate(
    typing_extensions.TypedDict, total=False
):
    candidateIndex: int

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenancePreviousTaskStatePreviousFunctionCall(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceQueryAnaphor(
    typing_extensions.TypedDict, total=False
):
    evalData: _list[NlpSemanticParsingAnnotationEvalData]

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentProvenanceSearchAnswerValue(
    typing_extensions.TypedDict, total=False
):
    eventId: EventIdMessage
    metadataValueIndex: int
    text: str
    valueIndex: int

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentSignals(
    typing_extensions.TypedDict, total=False
):
    addedByCloseAnswers: bool
    allowedFuzzyMatch: bool
    annotatedRelationship: _list[
        LogsSemanticInterpretationIntentQueryWebrefEntityRelationship
    ]
    annotationLayerSignals: KnowledgeAnswersIntentQueryAnnotationLayerSignals
    chainId: _list[LocalsearchChainId]
    clusterInfo: QualityViewsExtractionClusterInfo
    collectionMembership: _list[KnowledgeAnswersIntentQueryCollectionMembership]
    contextResolution: typing_extensions.Literal[
        "NONE",
        "SAFT_PRONOUN",
        "NOUN_PHRASE",
        "LOCAL_SEMANTIC_FUNCTION_MERGE",
        "CONTEXTUAL_SUBGRAMMAR_ANNOTATION",
    ]
    deprecatedFreebaseType: _list[str]
    deprecatedSupportingMid: _list[str]
    entityNumber: int
    entityRelationship: _list[NlpSemanticParsingQRefAnnotationEntityRelationship]
    expressionStatus: NlpSemanticParsingExpressionStatus
    fromManualSymbolAnnotation: bool
    fromSymbolAnnotation: bool
    gaiaId: str
    groundingSignals: KnowledgeAnswersIntentQueryGroundingSignals
    isAUngroundedTypeOf: str
    isDefaultValue: bool
    isEnum: bool
    isEvalDataHeuristic: bool
    isGenieAnnotation: bool
    isIntentgenAnnotation: bool
    isNimbleAnnotation: bool
    location: GeostorePointProto
    locationClassificationScore: float
    locationMarkersSignals: KnowledgeAnswersIntentQueryLocationMarkersSignals
    locationType: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_TRANSPORTATION",
        "TYPE_ROUTE",
        "TYPE_DEPRECATED_HIGHWAY_DO_NOT_USE",
        "TYPE_HIGHWAY",
        "TYPE_HIGHWAY_1",
        "TYPE_HIGHWAY_2",
        "TYPE_HIGHWAY_3",
        "TYPE_HIGHWAY_4",
        "TYPE_HIGHWAY_5",
        "TYPE_HIGHWAY_6",
        "TYPE_HIGHWAY_7",
        "TYPE_HIGHWAY_8",
        "TYPE_HIGHWAY_9",
        "TYPE_BICYCLE_ROUTE",
        "TYPE_TRAIL",
        "TYPE_SEGMENT",
        "TYPE_ROAD",
        "TYPE_RAILWAY",
        "TYPE_STANDARD_TRACK",
        "TYPE_JR_TRACK",
        "TYPE_NARROW_TRACK",
        "TYPE_MONORAIL_TRACK",
        "TYPE_SUBWAY_TRACK",
        "TYPE_LIGHT_RAIL_TRACK",
        "TYPE_BROAD_TRACK",
        "TYPE_HIGH_SPEED_RAIL",
        "TYPE_TROLLEY_TRACK",
        "TYPE_FERRY",
        "TYPE_FERRY_BOAT",
        "TYPE_FERRY_TRAIN",
        "TYPE_VIRTUAL_SEGMENT",
        "TYPE_INTERSECTION",
        "TYPE_TRANSIT",
        "TYPE_TRANSIT_STATION",
        "TYPE_BUS_STATION",
        "TYPE_TRAMWAY_STATION",
        "TYPE_TRAIN_STATION",
        "TYPE_SUBWAY_STATION",
        "TYPE_FERRY_TERMINAL",
        "TYPE_AIRPORT",
        "TYPE_AIRPORT_CIVIL",
        "TYPE_AIRPORT_MILITARY",
        "TYPE_AIRPORT_MIXED",
        "TYPE_HELIPORT",
        "TYPE_SEAPLANE_BASE",
        "TYPE_AIRSTRIP",
        "TYPE_CABLE_CAR_STATION",
        "TYPE_GONDOLA_LIFT_STATION",
        "TYPE_FUNICULAR_STATION",
        "TYPE_SPECIAL_STATION",
        "TYPE_HORSE_CARRIAGE_STATION",
        "TYPE_MONORAIL_STATION",
        "TYPE_SEAPORT",
        "TYPE_TRANSIT_STOP",
        "TYPE_TRANSIT_TRIP",
        "TYPE_TRANSIT_DEPARTURE",
        "TYPE_TRANSIT_LEG",
        "TYPE_TRANSIT_LINE",
        "TYPE_TRANSIT_AGENCY_DEPRECATED_VALUE",
        "TYPE_TRANSIT_TRANSFER",
        "TYPE_SEGMENT_PATH",
        "TYPE_ROAD_SIGN",
        "TYPE_INTERSECTION_GROUP",
        "TYPE_PATHWAY",
        "TYPE_RESTRICTION_GROUP",
        "TYPE_TOLL_CLUSTER",
        "TYPE_POLITICAL",
        "TYPE_COUNTRY",
        "TYPE_ADMINISTRATIVE_AREA",
        "TYPE_ADMINISTRATIVE_AREA1",
        "TYPE_US_STATE",
        "TYPE_GB_COUNTRY",
        "TYPE_JP_TODOUFUKEN",
        "TYPE_ADMINISTRATIVE_AREA2",
        "TYPE_GB_FORMER_POSTAL_COUNTY",
        "TYPE_GB_TRADITIONAL_COUNTY",
        "TYPE_ADMINISTRATIVE_AREA3",
        "TYPE_ADMINISTRATIVE_AREA4",
        "TYPE_ADMINISTRATIVE_AREA5",
        "TYPE_ADMINISTRATIVE_AREA6",
        "TYPE_ADMINISTRATIVE_AREA7",
        "TYPE_ADMINISTRATIVE_AREA8",
        "TYPE_ADMINISTRATIVE_AREA9",
        "TYPE_COLLOQUIAL_AREA",
        "TYPE_RESERVATION",
        "TYPE_LOCALITY",
        "TYPE_GB_POST_TOWN",
        "TYPE_JP_GUN",
        "TYPE_JP_SHIKUCHOUSON",
        "TYPE_JP_SUB_SHIKUCHOUSON",
        "TYPE_COLLOQUIAL_CITY",
        "TYPE_SUBLOCALITY",
        "TYPE_US_BOROUGH",
        "TYPE_GB_DEPENDENT_LOCALITY",
        "TYPE_JP_OOAZA",
        "TYPE_JP_KOAZA",
        "TYPE_JP_GAIKU",
        "TYPE_GB_DOUBLE_DEPENDENT_LOCALITY",
        "TYPE_JP_CHIBAN",
        "TYPE_JP_EDABAN",
        "TYPE_SUBLOCALITY1",
        "TYPE_SUBLOCALITY2",
        "TYPE_SUBLOCALITY3",
        "TYPE_SUBLOCALITY4",
        "TYPE_SUBLOCALITY5",
        "TYPE_NEIGHBORHOOD",
        "TYPE_CONSTITUENCY",
        "TYPE_DESIGNATED_MARKET_AREA",
        "TYPE_SCHOOL_DISTRICT",
        "TYPE_LAND_PARCEL",
        "TYPE_DISPUTED_AREA",
        "TYPE_POLICE_JURISDICTION",
        "TYPE_STATISTICAL_AREA",
        "TYPE_CONSTITUENCY_FUTURE",
        "TYPE_PARK",
        "TYPE_GOLF_COURSE",
        "TYPE_LOCAL_PARK",
        "TYPE_NATIONAL_PARK",
        "TYPE_US_NATIONAL_PARK",
        "TYPE_US_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_FOREST",
        "TYPE_PROVINCIAL_PARK",
        "TYPE_PROVINCIAL_FOREST",
        "TYPE_CAMPGROUNDS",
        "TYPE_HIKING_AREA",
        "TYPE_BUSINESS",
        "TYPE_GOVERNMENT",
        "TYPE_BORDER_CROSSING",
        "TYPE_CITY_HALL",
        "TYPE_COURTHOUSE",
        "TYPE_EMBASSY",
        "TYPE_LIBRARY",
        "TYPE_SCHOOL",
        "TYPE_UNIVERSITY",
        "TYPE_EMERGENCY",
        "TYPE_HOSPITAL",
        "TYPE_PHARMACY",
        "TYPE_POLICE",
        "TYPE_FIRE",
        "TYPE_DOCTOR",
        "TYPE_DENTIST",
        "TYPE_VETERINARIAN",
        "TYPE_TRAVEL_SERVICE",
        "TYPE_LODGING",
        "TYPE_RESTAURANT",
        "TYPE_GAS_STATION",
        "TYPE_PARKING",
        "TYPE_POST_OFFICE",
        "TYPE_REST_AREA",
        "TYPE_CASH_MACHINE",
        "TYPE_CAR_RENTAL",
        "TYPE_CAR_REPAIR",
        "TYPE_SHOPPING",
        "TYPE_GROCERY",
        "TYPE_TOURIST_DESTINATION",
        "TYPE_ECO_TOURIST_DESTINATION",
        "TYPE_BIRD_WATCHING",
        "TYPE_FISHING",
        "TYPE_HUNTING",
        "TYPE_NATURE_RESERVE",
        "TYPE_TEMPLE",
        "TYPE_CHURCH",
        "TYPE_GURUDWARA",
        "TYPE_HINDU_TEMPLE",
        "TYPE_MOSQUE",
        "TYPE_SYNAGOGUE",
        "TYPE_STADIUM",
        "TYPE_BAR",
        "TYPE_MOVIE_RENTAL",
        "TYPE_COFFEE",
        "TYPE_GOLF",
        "TYPE_BANK",
        "TYPE_DOODLE",
        "TYPE_GROUNDS",
        "TYPE_AIRPORT_GROUNDS",
        "TYPE_BUILDING_GROUNDS",
        "TYPE_CEMETERY",
        "TYPE_HOSPITAL_GROUNDS",
        "TYPE_INDUSTRIAL",
        "TYPE_MILITARY",
        "TYPE_SHOPPING_CENTER",
        "TYPE_SPORTS_COMPLEX",
        "TYPE_UNIVERSITY_GROUNDS",
        "TYPE_DEPRECATED_TARMAC",
        "TYPE_ENCLOSED_TRAFFIC_AREA",
        "TYPE_PARKING_LOT",
        "TYPE_PARKING_GARAGE",
        "TYPE_OFF_ROAD_AREA",
        "TYPE_BORDER",
        "TYPE_BUILDING",
        "TYPE_GEOCODED_ADDRESS",
        "TYPE_NATURAL_FEATURE",
        "TYPE_TERRAIN",
        "TYPE_SAND",
        "TYPE_BEACH",
        "TYPE_DUNE",
        "TYPE_ROCKY",
        "TYPE_ICE",
        "TYPE_GLACIER",
        "TYPE_BUILT_UP_AREA",
        "TYPE_VEGETATION",
        "TYPE_SHRUBBERY",
        "TYPE_WOODS",
        "TYPE_AGRICULTURAL",
        "TYPE_GRASSLAND",
        "TYPE_TUNDRA",
        "TYPE_DESERT",
        "TYPE_SALT_FLAT",
        "TYPE_WATER",
        "TYPE_OCEAN",
        "TYPE_BAY",
        "TYPE_BIGHT",
        "TYPE_LAGOON",
        "TYPE_SEA",
        "TYPE_STRAIT",
        "TYPE_INLET",
        "TYPE_FJORD",
        "TYPE_LAKE",
        "TYPE_SEASONAL_LAKE",
        "TYPE_RESERVOIR",
        "TYPE_POND",
        "TYPE_RIVER",
        "TYPE_RAPIDS",
        "TYPE_DISTRIBUTARY",
        "TYPE_CONFLUENCE",
        "TYPE_WATERFALL",
        "TYPE_SPRING",
        "TYPE_GEYSER",
        "TYPE_HOT_SPRING",
        "TYPE_SEASONAL_RIVER",
        "TYPE_WADI",
        "TYPE_ESTUARY",
        "TYPE_WETLAND",
        "TYPE_WATER_NAVIGATION",
        "TYPE_FORD",
        "TYPE_CANAL",
        "TYPE_HARBOR",
        "TYPE_CHANNEL",
        "TYPE_REEF",
        "TYPE_REEF_FLAT",
        "TYPE_REEF_GROWTH",
        "TYPE_REEF_EXTENT",
        "TYPE_REEF_ROCK_SUBMERGED",
        "TYPE_IRRIGATION",
        "TYPE_DAM",
        "TYPE_DRINKING_WATER",
        "TYPE_CURRENT",
        "TYPE_WATERING_HOLE",
        "TYPE_TECTONIC",
        "TYPE_WATERING_HOLE_DEPRECATED",
        "TYPE_VOLCANO",
        "TYPE_LAVA_FIELD",
        "TYPE_FISSURE",
        "TYPE_FAULT",
        "TYPE_LAND_MASS",
        "TYPE_CONTINENT",
        "TYPE_ISLAND",
        "TYPE_ATOLL",
        "TYPE_OCEAN_ROCK_EXPOSED",
        "TYPE_CAY",
        "TYPE_PENINSULA",
        "TYPE_ISTHMUS",
        "TYPE_ELEVATED",
        "TYPE_PEAK",
        "TYPE_NUNATAK",
        "TYPE_SPUR",
        "TYPE_PASS",
        "TYPE_PLATEAU",
        "TYPE_RIDGE",
        "TYPE_RAVINE",
        "TYPE_CRATER",
        "TYPE_KARST",
        "TYPE_CLIFF",
        "TYPE_VISTA",
        "TYPE_DIGITAL_ELEVATION_MODEL",
        "TYPE_UPLAND",
        "TYPE_TERRACE",
        "TYPE_SLOPE",
        "TYPE_CONTOUR_LINE",
        "TYPE_PAN",
        "TYPE_UNSTABLE_HILLSIDE",
        "TYPE_MOUNTAIN_RANGE",
        "TYPE_UNDERSEA",
        "TYPE_SUBMARINE_SEAMOUNT",
        "TYPE_SUBMARINE_RIDGE",
        "TYPE_SUBMARINE_GAP",
        "TYPE_SUBMARINE_PLATEAU",
        "TYPE_SUBMARINE_DEEP",
        "TYPE_SUBMARINE_VALLEY",
        "TYPE_SUBMARINE_BASIN",
        "TYPE_SUBMARINE_SLOPE",
        "TYPE_SUBMARINE_CLIFF",
        "TYPE_SUBMARINE_PLAIN",
        "TYPE_SUBMARINE_FRACTURE_ZONE",
        "TYPE_CAVE",
        "TYPE_ROCK",
        "TYPE_ARCHIPELAGO",
        "TYPE_POSTAL",
        "TYPE_POSTAL_CODE",
        "TYPE_POSTAL_CODE_PREFIX",
        "TYPE_PREMISE",
        "TYPE_SUB_PREMISE",
        "TYPE_SUITE",
        "TYPE_POST_TOWN",
        "TYPE_POSTAL_ROUND",
        "TYPE_META_FEATURE",
        "TYPE_DATA_SOURCE",
        "TYPE_LOCALE",
        "TYPE_TIMEZONE",
        "TYPE_BUSINESS_CHAIN",
        "TYPE_PHONE_NUMBER_PREFIX",
        "TYPE_PHONE_NUMBER_AREA_CODE",
        "TYPE_BUSINESS_CORRIDOR",
        "TYPE_ADDRESS_TEMPLATE",
        "TYPE_TRANSIT_AGENCY",
        "TYPE_FUTURE_GEOMETRY",
        "TYPE_EVENT",
        "TYPE_EARTHQUAKE",
        "TYPE_HURRICANE",
        "TYPE_WEATHER_CONDITION",
        "TYPE_TRANSIENT",
        "TYPE_ENTRANCE",
        "TYPE_CARTOGRAPHIC",
        "TYPE_HIGH_TENSION",
        "TYPE_SKI_TRAIL",
        "TYPE_SKI_LIFT",
        "TYPE_SKI_BOUNDARY",
        "TYPE_WATERSHED_BOUNDARY",
        "TYPE_TARMAC",
        "TYPE_WALL",
        "TYPE_PICNIC_AREA",
        "TYPE_PLAY_GROUND",
        "TYPE_TRAIL_HEAD",
        "TYPE_GOLF_TEEING_GROUND",
        "TYPE_GOLF_PUTTING_GREEN",
        "TYPE_GOLF_ROUGH",
        "TYPE_GOLF_SAND_BUNKER",
        "TYPE_GOLF_FAIRWAY",
        "TYPE_GOLF_HOLE",
        "TYPE_DEPRECATED_GOLF_SHOP",
        "TYPE_CAMPING_SITE",
        "TYPE_DESIGNATED_BARBECUE_PIT",
        "TYPE_DESIGNATED_COOKING_AREA",
        "TYPE_CAMPFIRE_PIT",
        "TYPE_WATER_FOUNTAIN",
        "TYPE_LITTER_RECEPTACLE",
        "TYPE_LOCKER_AREA",
        "TYPE_ANIMAL_ENCLOSURE",
        "TYPE_CARTOGRAPHIC_LINE",
        "TYPE_ESTABLISHMENT",
        "TYPE_ESTABLISHMENT_GROUNDS",
        "TYPE_ESTABLISHMENT_BUILDING",
        "TYPE_ESTABLISHMENT_POI",
        "TYPE_ESTABLISHMENT_SERVICE",
        "TYPE_CELESTIAL",
        "TYPE_ROAD_MONITOR",
        "TYPE_PUBLIC_SPACES_AND_MONUMENTS",
        "TYPE_STATUE",
        "TYPE_TOWN_SQUARE",
        "TYPE_LEVEL",
        "TYPE_COMPOUND",
        "TYPE_COMPOUND_GROUNDS",
        "TYPE_COMPOUND_BUILDING",
        "TYPE_COMPOUND_SECTION",
        "TYPE_TERMINAL_POINT",
        "TYPE_REGULATED_AREA",
        "TYPE_LOGICAL_BORDER",
        "TYPE_DO_NOT_USE_RESERVED_TO_CATCH_GENERATED_FILES",
        "TYPE_UNKNOWN",
    ]
    mediaEntitySignals: KnowledgeAnswersIntentQueryMediaEntitySignals
    mergedImpliedEntity: _list[KnowledgeAnswersIntentQueryImpliedEntity]
    midEquivalentToCollection: str
    multipleHorizontalListSelectionMatches: bool
    muninSignals: KnowledgeAnswersIntentQueryMuninSignals
    onDeviceAnnotationSignals: KnowledgeAnswersIntentQueryOnDeviceAnnotationSignals
    oysterId: GeostoreFeatureIdProto
    parsedDueToExperiment: _list[str]
    personalEntity: _list[KnowledgeAnswersIntentQueryPersonalEntity]
    provenance: _list[KnowledgeAnswersIntentQueryArgumentProvenance]
    qrefConfidenceScore: float
    qrefInterpretationIndex: int
    rawQueryText: str
    relatedEntity: _list[NlpSemanticParsingRelatedEntity]
    relatednessSignals: KnowledgeAnswersIntentQueryRelatednessSignals
    resolvedFromContext: bool
    resolvedFromPronoun: bool
    responseMeaningSignals: KnowledgeAnswersIntentQueryResponseMeaningSignalsResponseMeaningSignals
    resultSupport: _list[UniversalsearchNewPackerKnowledgeResultSupport]
    saftSignals: KnowledgeAnswersIntentQuerySaftSignals
    shoppingIds: KnowledgeAnswersIntentQueryShoppingIds
    source: typing_extensions.Literal[
        "ARGUMENT_SOURCE_UNSPECIFIED", "ARGUMENT_SOURCE_ASSISTANT_GROUNDING_BOX"
    ]
    supportTransferRules: _list[
        LogsSemanticInterpretationIntentQuerySupportTransferRule
    ]
    supportTransferSignals: KnowledgeAnswersIntentQuerySupportTransferSignals
    ungroundedValueType: KnowledgeAnswersValueType
    valueSource: typing_extensions.Literal[
        "ARGUMENT_VALUE_SOURCE_UNSPECIFIED",
        "ARGUMENT_VALUE_SOURCE_ASSISTANT_GROUNDING_BOX",
    ]
    webrefEntitiesIndex: int
    webrefListSource: typing_extensions.Literal[
        "UNSET", "INTERPRETATION_LIST", "ANNOTATION_LIST", "CANDIDATE_LIST"
    ]

@typing.type_check_only
class KnowledgeAnswersIntentQueryArgumentValue(
    typing_extensions.TypedDict, total=False
):
    aogSlot: NlpSemanticParsingProtoActionsOnGoogleAogSlot
    appAnnotation: NlpSemanticParsingAppAnnotation
    audio: NlpSemanticParsingModelsMediaAudio
    calendarEvent: AssistantApiCoreTypesCalendarEvent
    calendarEventWrapper: AssistantApiCoreTypesCalendarEventWrapper
    calendarReference: QualityQrewriteCalendarReference
    complexQueriesRewrite: QualityGenieComplexQueriesComplexQueriesOutputRewrite
    componentReference: RepositoryWebrefComponentReference
    coreference: KnowledgeAnswersIntentQueryCoreference
    dateTime: NlpSemanticParsingDatetimeDateTime
    device: NlpSemanticParsingModelsMediaCastDeviceAnnotation
    deviceId: AssistantApiCoreTypesDeviceId
    deviceUserIdentity: AssistantApiCoreTypesDeviceUserIdentity
    duration: NlpSemanticParsingDatetimeDuration
    funcall: KnowledgeAnswersIntentQueryFunctionCall
    homeAutomationDevice: AssistantVerticalsHomeautomationProtoHomeAutomationDevice
    location: NlpSemanticParsingLocalLocation
    media: NlpSemanticParsingModelsMediaMediaAnnotation
    messageNotification: AssistantApiCoreTypesMessageNotification
    money: NlpSemanticParsingModelsMoneyMoney
    narrativeNewsProvider: NlpSemanticParsingModelsNarrativeNewsNewsProvider
    number: NlpSemanticParsingNumberNumber
    onDevice: NlpSemanticParsingModelsOnDevice
    person: NlpSemanticParsingModelsPersonPerson
    personalIntelligenceEntity: NlpSemanticParsingPersonalIntelligenceEntity
    productivityListItem: AssistantProductivityListItem
    recurrence: NlpSemanticParsingModelsRecurrence
    reminder: QualityActionsReminder
    sensitiveValue: KnowledgeAnswersIntentQuerySensitiveArgumentValueGuard
    sensitivity: _list[KnowledgeAnswersSensitivitySensitivity]
    shoppingMerchant: NlpSemanticParsingModelsShoppingAssistantMerchant
    shoppingOffer: NlpSemanticParsingModelsShoppingAssistantOffer
    shoppingProduct: NlpSemanticParsingModelsShoppingAssistantProduct
    shoppingProductExpression: NlpSemanticParsingModelsShoppingAssistantProductExpression
    shoppingStore: NlpSemanticParsingModelsShoppingAssistantStore
    simpleValue: KnowledgeAnswersIntentQuerySimpleValue
    timer: QualityActionsTimer
    timezone: NlpSemanticParsingDatetimeTimeZone

@typing.type_check_only
class KnowledgeAnswersIntentQueryAttributeSignal(
    typing_extensions.TypedDict, total=False
):
    attributeId: str
    score: float

@typing.type_check_only
class KnowledgeAnswersIntentQueryCollectionMembership(
    typing_extensions.TypedDict, total=False
):
    collectionId: str
    collectionMid: str
    collectionScore: float
    score: _list[KnowledgeAnswersIntentQueryCollectionScore]

@typing.type_check_only
class KnowledgeAnswersIntentQueryCollectionScore(
    typing_extensions.TypedDict, total=False
):
    scoreType: typing_extensions.Literal["UNKNOWN", "GENERAL"]
    scoreValue: float

@typing.type_check_only
class KnowledgeAnswersIntentQueryConceptInfo(typing_extensions.TypedDict, total=False):
    id: ConceptsConceptId

@typing.type_check_only
class KnowledgeAnswersIntentQueryConceptSignals(
    typing_extensions.TypedDict, total=False
):
    dataEpochId: int

@typing.type_check_only
class KnowledgeAnswersIntentQueryCoreference(typing_extensions.TypedDict, total=False):
    argPath: KnowledgeAnswersIntentQueryArgPath

@typing.type_check_only
class KnowledgeAnswersIntentQueryCustomVehicleActionArgumentAnnotatorSignals(
    typing_extensions.TypedDict, total=False
):
    additionalAnnotationData: dict[str, typing.Any]

@typing.type_check_only
class KnowledgeAnswersIntentQueryFreetextAnnotationSignals(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryFunctionCall(typing_extensions.TypedDict, total=False):
    argument: _list[KnowledgeAnswersIntentQueryArgument]
    catalogVersion: str
    conceptInfo: KnowledgeAnswersIntentQueryConceptInfo
    contextualSensitivity: _list[KnowledgeAnswersSensitivitySensitivity]
    enabledRemodelings: NlpMeaningMeaningRemodelingControl
    ignoredTokens: _list[KnowledgeAnswersIntentQueryTokens]
    key: KnowledgeAnswersMeaningSchemaKey
    marker: KnowledgeAnswersMarker
    modifiers: KnowledgeAnswersIntentModifiers
    name: str
    sensitivity: KnowledgeAnswersSensitivitySensitivity
    signals: KnowledgeAnswersIntentQueryFunctionCallSignals
    unexplainedTokens: _list[KnowledgeAnswersIntentQueryTokens]

@typing.type_check_only
class KnowledgeAnswersIntentQueryFunctionCallSignals(
    typing_extensions.TypedDict, total=False
):
    argumentComposingMid: str
    attributeSignals: _list[KnowledgeAnswersIntentQueryAttributeSignal]
    conceptEntityMid: str
    conceptSignals: KnowledgeAnswersIntentQueryConceptSignals
    confidenceLevel: typing_extensions.Literal[
        "UNKNOWN", "LOW", "MEDIUM", "HIGH", "ALWAYS_TRIGGER"
    ]
    dedupedFuncalls: _list[KnowledgeAnswersIntentQueryFunctionCall]
    expressionStatus: NlpSemanticParsingExpressionStatus
    freefolksTrigger: typing_extensions.Literal[
        "NONE_FREEFOLKS_TRIGGER",
        "LOW_CONF_FREEFOLKS_TRIGGER",
        "HIGH_CONF_FREEFOLKS_TRIGGER",
    ]
    groundingSignals: KnowledgeAnswersIntentQueryGroundingSignals
    highConfidence: bool
    intentAnnotationSources: _list[
        typing_extensions.Literal["UNKNOWN_SOURCE", "ORBIT", "LEXICON"]
    ]
    intentComposingMid: str
    intentProvenance: _list[KnowledgeAnswersIntentQueryArgumentProvenance]
    intentRelevantMid: _list[str]
    isCloseInterpretation: bool
    isDisambiguationCardIntent: bool
    isDisambiguationIntent: bool
    isNeuralCategoricalInterpretation: bool
    isRefinedMeaning: bool
    isUiCompositionIntent: bool
    localSignals: KnowledgeAnswersIntentQueryLocalSignals
    osrpJourneyTag: str
    parsedDueToExperiment: _list[str]
    parsingSignals: KnowledgeAnswersIntentQueryParsingSignals
    prefulfillmentRankingScore: float
    prefulfillmentSignals: AssistantPrefulfillmentRankerPrefulfillmentSignals
    referentialResolution: KnowledgeAnswersDialogReferentialResolution
    refxSummaryNodeId: str
    responseMeaningSignals: KnowledgeAnswersIntentQueryResponseMeaningSignalsResponseMeaningSignals
    resultSupport: _list[UniversalsearchNewPackerKnowledgeResultSupport]
    role: typing_extensions.Literal[
        "UNKNOWN_ROLE", "QUERY_INTERPRETATION", "DERIVED_INTENT"
    ]
    selectedByPrefulfillmentRanking: bool
    shoppingIds: KnowledgeAnswersIntentQueryShoppingIds
    signalsFallbackIntents: _list[
        KnowledgeAnswersIntentQuerySignalComputationFallbackIntent
    ]
    usesPrefulfillmentRanker: bool

@typing.type_check_only
class KnowledgeAnswersIntentQueryGroundingSignals(
    typing_extensions.TypedDict, total=False
):
    addedByGrounding: bool
    groundabilityScore: float
    numConstraints: float
    numConstraintsSatisfied: float
    numGroundableArgs: float
    numGroundedArgs: float
    numVariables: float
    numVariablesGrounded: float
    pgrpOutputFormat: typing_extensions.Literal[
        "INTENT_FORMAT_UNSPECIFIED", "PROD_INTENT_FACTORY", "PORTMON_FULFILLMENT"
    ]
    provenance: typing_extensions.Literal["UNKNOWN_PROVENANCE", "FIELD_CANDIDATE"]
    sentiment: typing_extensions.Literal["UNKNOWN_SENTIMENT", "REJECT"]
    usesGroundingBox: bool

@typing.type_check_only
class KnowledgeAnswersIntentQueryIdentifier(typing_extensions.TypedDict, total=False):
    id: str
    idType: typing_extensions.Literal[
        "UNKNOWN_ID_TYPE",
        "ALARM",
        "CALENDAR",
        "CALENDAR_EVENT",
        "KG",
        "LIST",
        "LIST_ITEM",
        "NOTE",
        "PROVIDER",
        "STOPWATCH",
        "TIMER",
        "DEVICE",
        "DEVICE_SETTING",
        "ROOM",
        "STRUCTURE",
        "ZONE",
        "TRAIT_ATTRIBUTE_VALUE",
        "TRAIT_SEMANTIC_VALUE",
        "REMINDER",
        "RECIPE",
        "PERSON",
        "COMM_ENDPOINT",
        "CALL_LOG",
        "NEWS",
        "MEDIA",
        "CONCEPT",
        "RELATION",
        "ATTENTIONAL_ENTITY",
        "AUDIO_MESSAGE_METADATA_ID",
        "BROADCAST",
        "MESSAGE_CONTENT",
        "INLINE_INVENTORY",
        "MEDIA_PLAYBACK",
        "CONCEPT_ID",
    ]

@typing.type_check_only
class KnowledgeAnswersIntentQueryImpliedEntity(
    typing_extensions.TypedDict, total=False
):
    annotatedSpan: str
    evalData: NlpSemanticParsingAnnotationEvalData
    isUngroundedValue: bool
    mid: str
    qrefConfidenceScore: float
    shoppingIds: KnowledgeAnswersIntentQueryShoppingIds

@typing.type_check_only
class KnowledgeAnswersIntentQueryIndexingIQLAttachment(
    typing_extensions.TypedDict, total=False
):
    iqlEncodingVersion: int
    iqlFuncalls: str
    piannoConfidenceScoreE2: _list[int]
    piannoIqlBitmap: _list[int]

@typing.type_check_only
class KnowledgeAnswersIntentQueryLocalResultSignals(
    typing_extensions.TypedDict, total=False
):
    gcidIntent: _list[str]
    salientTermSet: QualitySalientTermsSalientTermSet

@typing.type_check_only
class KnowledgeAnswersIntentQueryLocalSignals(typing_extensions.TypedDict, total=False):
    localResultSignals: _list[KnowledgeAnswersIntentQueryLocalResultSignals]
    minSalientTermSimilarity: float

@typing.type_check_only
class KnowledgeAnswersIntentQueryLocationMarkersSignals(
    typing_extensions.TypedDict, total=False
):
    type: typing_extensions.Literal["UNKNOWN", "SOURCE", "GOAL"]

@typing.type_check_only
class KnowledgeAnswersIntentQueryMediaEntitySignals(
    typing_extensions.TypedDict, total=False
):
    artistTitle: str
    name: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryMuninSignals(typing_extensions.TypedDict, total=False):
    isIsolated: bool
    softModifierCollection: _list[str]
    textIsGenerated: bool

@typing.type_check_only
class KnowledgeAnswersIntentQueryNTPRAnnotationSignals(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryNimbleAnnotationSignals(
    typing_extensions.TypedDict, total=False
):
    annotationSource: typing_extensions.Literal[
        "SSTABLE", "LG", "TS", "PRIVATE_SSTABLE"
    ]
    type: str
    version: _list[str]

@typing.type_check_only
class KnowledgeAnswersIntentQueryOnDeviceAnnotationSignals(
    typing_extensions.TypedDict, total=False
):
    provenance: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryParsingSignals(
    typing_extensions.TypedDict, total=False
):
    calibratedParsingScore: float
    effectiveArgSpanLength: float
    inQueryMaxEffectiveArgSpanLength: float
    qrewriteCallPathInfoFingerprint: str
    source: typing_extensions.Literal[
        "UNKNOWN_PARSING_SOURCE",
        "SAGE",
        "UNSTRUCTURED_INTENTS",
        "NSP",
        "AQUA",
        "PHONE_GENIE",
    ]

@typing.type_check_only
class KnowledgeAnswersIntentQueryPersonalEntity(
    typing_extensions.TypedDict, total=False
):
    attributeId: str
    entityRelationship: _list[
        KnowledgeAnswersIntentQueryPersonalEntityEntityRelationship
    ]
    freebaseMid: str
    personalEntityChild: _list[KnowledgeAnswersIntentQueryPersonalEntity]

@typing.type_check_only
class KnowledgeAnswersIntentQueryPersonalEntityEntityRelationship(
    typing_extensions.TypedDict, total=False
):
    entityIndex: int
    linkPropertyName: _list[str]

@typing.type_check_only
class KnowledgeAnswersIntentQueryQrefAnnotationSignals(
    typing_extensions.TypedDict, total=False
):
    score: float
    trustedNameConfidence: float

@typing.type_check_only
class KnowledgeAnswersIntentQueryRelatednessSignals(
    typing_extensions.TypedDict, total=False
):
    queryPopularity: float
    youtubeViews: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryResponseMeaningSignalsAnswersHeaderSignals(
    typing_extensions.TypedDict, total=False
):
    answersValueGender: typing_extensions.Literal["UNKNOWN", "FEMALE", "MALE"]
    numAnswers: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryResponseMeaningSignalsResponseMeaningSignals(
    typing_extensions.TypedDict, total=False
):
    answersHeaderSignals: KnowledgeAnswersIntentQueryResponseMeaningSignalsAnswersHeaderSignals
    propertyValue: _list[FreebasePropertyValue]
    responseMeaningApplication: typing_extensions.Literal[
        "DEFAULT", "HEADER", "VOICE_ANSWERS", "DISPLAY_ANSWERS"
    ]

@typing.type_check_only
class KnowledgeAnswersIntentQuerySaftSignals(typing_extensions.TypedDict, total=False):
    entityType: typing_extensions.Literal[
        "UNMARKED", "PERSON", "NOMINAL_PERSON", "ORGANIZATION", "LOCATION", "OTHER"
    ]
    isHeadOfIntent: bool
    isVerb: bool
    number: typing_extensions.Literal["UNKNOWN", "SINGULAR", "PLURAL"]

@typing.type_check_only
class KnowledgeAnswersIntentQuerySemanticAnnotationSignals(
    typing_extensions.TypedDict, total=False
):
    category: str
    domain: str
    features: _list[KnowledgeAnswersIntentQuerySemanticAnnotationSignalsFeature]
    score: float

@typing.type_check_only
class KnowledgeAnswersIntentQuerySemanticAnnotationSignalsFeature(
    typing_extensions.TypedDict, total=False
):
    name: str
    value: float

@typing.type_check_only
class KnowledgeAnswersIntentQuerySensitiveArgumentValueGuard(
    typing_extensions.TypedDict, total=False
):
    doNotUseDebugOnlyDecryptedValue: KnowledgeAnswersIntentQueryArgumentValue
    encryptedValue: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryShoppingIds(typing_extensions.TypedDict, total=False):
    aspectClusterIds: _list[str]
    brandEntityId: str
    bxCategoryIds: _list[int]
    measures: _list[KnowledgeAnswersIntentQueryShoppingIdsMeasureValue]
    merchantIds: _list[str]
    merchantSourceIds: _list[str]
    tagIds: _list[str]

@typing.type_check_only
class KnowledgeAnswersIntentQueryShoppingIdsMeasureValue(
    typing_extensions.TypedDict, total=False
):
    facetId: str
    value: float

@typing.type_check_only
class KnowledgeAnswersIntentQuerySignalComputationFallbackIntent(
    typing_extensions.TypedDict, total=False
):
    intent: str

@typing.type_check_only
class KnowledgeAnswersIntentQuerySimpleValue(typing_extensions.TypedDict, total=False):
    boolValue: bool
    doubleValue: float
    identifier: KnowledgeAnswersIntentQueryIdentifier
    intValue: str
    stringValue: str
    ungroundedValue: str

@typing.type_check_only
class KnowledgeAnswersIntentQuerySupportTransferSignals(
    typing_extensions.TypedDict, total=False
):
    supportTransferSource: _list[str]
    supportTransferTarget: _list[str]

@typing.type_check_only
class KnowledgeAnswersIntentQueryTeleportArgumentAnnotatorSignals(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersIntentQueryToken(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    ngram: str
    parsedDueToExperiment: _list[str]
    prior: float
    provenance: typing_extensions.Literal[
        "UNKNOWN",
        "INTENT_PRIMARY",
        "INTENT_COMPONENT",
        "STOPWORD",
        "CONTEXT_INTENT",
        "CONTEXT_ANSWER_TYPE",
        "CONTEXT_ENTITY_TYPE",
        "PUNCTUATION",
        "LOCATION_ALIAS_ANNOTATION",
        "OPTIONALIZED",
    ]
    provenanceId: _list[str]
    provenanceLanguage: str
    synonyms: _list[KnowledgeAnswersIntentQueryTokenSynonym]

@typing.type_check_only
class KnowledgeAnswersIntentQueryTokenSynonym(typing_extensions.TypedDict, total=False):
    source: typing_extensions.Literal["UNKNOWN", "SQUERY"]
    synonymNgram: str

@typing.type_check_only
class KnowledgeAnswersIntentQueryTokens(typing_extensions.TypedDict, total=False):
    score: float
    token: _list[KnowledgeAnswersIntentQueryToken]

@typing.type_check_only
class KnowledgeAnswersIntersectType(typing_extensions.TypedDict, total=False):
    slotNames: _list[str]

@typing.type_check_only
class KnowledgeAnswersMarker(typing_extensions.TypedDict, total=False):
    command: KnowledgeAnswersMarkerCommand
    openQuestion: KnowledgeAnswersMarkerOpenQuestion
    polarQuestion: KnowledgeAnswersMarkerPolarQuestion
    stateOfAffairs: KnowledgeAnswersMarkerStateOfAffairs

@typing.type_check_only
class KnowledgeAnswersMarkerCommand(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersMarkerOpenQuestion(typing_extensions.TypedDict, total=False):
    slotKey: KnowledgeAnswersMeaningSchemaSlotKey
    slotName: _list[str]

@typing.type_check_only
class KnowledgeAnswersMarkerPolarQuestion(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersMarkerStateOfAffairs(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersMeaningSchemaKey(typing_extensions.TypedDict, total=False):
    deprecatedVersion: str
    mid: str

@typing.type_check_only
class KnowledgeAnswersMeaningSchemaSlotKey(typing_extensions.TypedDict, total=False):
    mid: str
    uniqueId: str

@typing.type_check_only
class KnowledgeAnswersMeasurementType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersNormalizedStringType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    normalizedValue: _list[str]
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersNumberType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    keepAsString: bool
    rangeConstraint: KnowledgeAnswersRangeConstraint
    remodelings: NlpMeaningMeaningRemodelings
    subType: _list[
        typing_extensions.Literal[
            "NONE", "ORDINAL", "NUMERIC", "INTEGER", "FLOAT", "NUMBER_PROTO"
        ]
    ]

@typing.type_check_only
class KnowledgeAnswersOpaqueAogType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueAppAnnotationType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueAudioType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueCalendarEventType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueCalendarEventWrapperType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueCalendarReferenceType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueComplexQueriesRewriteType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueComponentReferenceIndexType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueDeviceIdType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueDeviceType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueDeviceUserIdentityType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueHomeAutomationDeviceType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueLocationType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueMediaType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueMessageNotificationType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueMoneyType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueNewsProviderType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueOnDeviceType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaquePersonType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaquePersonalIntelligenceEntityType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueProductivityListItemType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueRecurrenceType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueReminderType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueShoppingMerchantType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueShoppingOfferType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueShoppingProductExpressionType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueShoppingProductType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueShoppingStoreType(
    typing_extensions.TypedDict, total=False
): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueTimerType(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class KnowledgeAnswersOpaqueType(typing_extensions.TypedDict, total=False):
    aogType: KnowledgeAnswersOpaqueAogType
    appAnnotationType: KnowledgeAnswersOpaqueAppAnnotationType
    audioType: KnowledgeAnswersOpaqueAudioType
    calendarEventType: KnowledgeAnswersOpaqueCalendarEventType
    calendarEventWrapperType: KnowledgeAnswersOpaqueCalendarEventWrapperType
    calendarReferenceType: KnowledgeAnswersOpaqueCalendarReferenceType
    complexQueriesRewriteType: KnowledgeAnswersOpaqueComplexQueriesRewriteType
    componentReferenceType: KnowledgeAnswersOpaqueComponentReferenceIndexType
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    deviceIdType: KnowledgeAnswersOpaqueDeviceIdType
    deviceType: KnowledgeAnswersOpaqueDeviceType
    deviceUserIdentityType: KnowledgeAnswersOpaqueDeviceUserIdentityType
    homeAutomationDeviceType: KnowledgeAnswersOpaqueHomeAutomationDeviceType
    locationType: KnowledgeAnswersOpaqueLocationType
    mediaType: KnowledgeAnswersOpaqueMediaType
    messageNotificationType: KnowledgeAnswersOpaqueMessageNotificationType
    moneyType: KnowledgeAnswersOpaqueMoneyType
    narrativeNewsProviderType: KnowledgeAnswersOpaqueNewsProviderType
    onDeviceType: KnowledgeAnswersOpaqueOnDeviceType
    personType: KnowledgeAnswersOpaquePersonType
    personalIntelligenceEntityType: KnowledgeAnswersOpaquePersonalIntelligenceEntityType
    productivityListItemType: KnowledgeAnswersOpaqueProductivityListItemType
    recurrenceType: KnowledgeAnswersOpaqueRecurrenceType
    reminderType: KnowledgeAnswersOpaqueReminderType
    remodelings: NlpMeaningMeaningRemodelings
    shoppingMerchantType: KnowledgeAnswersOpaqueShoppingMerchantType
    shoppingOfferType: KnowledgeAnswersOpaqueShoppingOfferType
    shoppingProductExpressionType: KnowledgeAnswersOpaqueShoppingProductExpressionType
    shoppingProductType: KnowledgeAnswersOpaqueShoppingProductType
    shoppingStoreType: KnowledgeAnswersOpaqueShoppingStoreType
    timerType: KnowledgeAnswersOpaqueTimerType

@typing.type_check_only
class KnowledgeAnswersPlexityRequirement(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings
    simplePlexity: typing_extensions.Literal[
        "UNSPECIFIED_PLEXITY", "UNIPLEX", "MULTIPLEX", "ANY_PLEXITY"
    ]

@typing.type_check_only
class KnowledgeAnswersPolarQuestionType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersRangeConstraint(typing_extensions.TypedDict, total=False):
    max: KnowledgeAnswersRangeConstraintRangeEndpoint
    min: KnowledgeAnswersRangeConstraintRangeEndpoint

@typing.type_check_only
class KnowledgeAnswersRangeConstraintRangeEndpoint(
    typing_extensions.TypedDict, total=False
):
    isExclusive: bool
    value: float

@typing.type_check_only
class KnowledgeAnswersSameType(typing_extensions.TypedDict, total=False):
    slotName: str

@typing.type_check_only
class KnowledgeAnswersSemanticType(typing_extensions.TypedDict, total=False):
    allowAll: bool
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    includesContainingIntent: bool
    name: _list[str]
    nameContracts: _list[NlpMeaningSemanticTypeNameComponentSpecificContracts]
    nameRemodelings: _list[NlpMeaningSemanticTypeNameMeaningRemodelings]
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersSensitivityArgumentEvalPolicy(
    typing_extensions.TypedDict, total=False
):
    policyName: str
    redactQuerySpan: bool
    replacement: str
    scrubArgumentValue: bool

@typing.type_check_only
class KnowledgeAnswersSensitivityInstruction(typing_extensions.TypedDict, total=False):
    argument: KnowledgeAnswersSensitivityInstructionArgument
    intent: KnowledgeAnswersSensitivityInstructionIntent
    legacyAssistantSensitivity: SearchPolicyRankableSensitivity
    multiAccountAllowed: bool
    previousQuery: KnowledgeAnswersSensitivityInstructionPreviousQuery

@typing.type_check_only
class KnowledgeAnswersSensitivityInstructionArgument(
    typing_extensions.TypedDict, total=False
):
    eval: KnowledgeAnswersSensitivityArgumentEvalPolicy
    logging: KnowledgeAnswersSensitivityLoggingPolicy
    serving: KnowledgeAnswersSensitivityServingPolicy
    storage: KnowledgeAnswersSensitivityStoragePolicy

@typing.type_check_only
class KnowledgeAnswersSensitivityInstructionIntent(
    typing_extensions.TypedDict, total=False
):
    eval: KnowledgeAnswersSensitivityIntentEvalPolicy
    footprints: KnowledgeAnswersSensitivityMyActivityPolicy
    logging: KnowledgeAnswersSensitivityLoggingPolicy
    serving: KnowledgeAnswersSensitivityServingPolicy
    storage: KnowledgeAnswersSensitivityStoragePolicy

@typing.type_check_only
class KnowledgeAnswersSensitivityInstructionPreviousQuery(
    typing_extensions.TypedDict, total=False
):
    logging: KnowledgeAnswersSensitivityLoggingPolicy
    serving: KnowledgeAnswersSensitivityServingPolicy
    storage: KnowledgeAnswersSensitivityStoragePolicy

@typing.type_check_only
class KnowledgeAnswersSensitivityIntentEvalPolicy(
    typing_extensions.TypedDict, total=False
):
    allArguments: KnowledgeAnswersSensitivityArgumentEvalPolicy
    enabled: bool
    nestedIntentOnly: bool
    scrubEntireIntent: bool

@typing.type_check_only
class KnowledgeAnswersSensitivityLoggingPolicy(
    typing_extensions.TypedDict, total=False
):
    scrubArgumentValue: bool
    scrubContext: bool

@typing.type_check_only
class KnowledgeAnswersSensitivityMyActivityPolicy(
    typing_extensions.TypedDict, total=False
):
    myActivityRedactedAction: typing_extensions.Literal[
        "UNKNOWN_ACTION",
        "REPLY_TO_BROADCAST",
        "INITIATE_CALL",
        "SEARCH_EMAIL",
        "SEND_SMS",
        "SEND_MESSAGE",
        "SEND_EMAIL",
        "SEND_CHAT_MESSAGE",
        "VIEW_AGENDA",
        "SHOW_CALENDAR_EVENT",
        "ADD_CALENDAR_EVENT",
        "DELETE_CALENDAR_EVENT",
        "MODIFY_CALENDAR_EVENT",
        "SEARCH_CALENDAR",
        "SEARCH_TEXT_MESSAGE",
        "REPLY_TO_MESSAGE",
        "REPLY_TO_NOTIFICATION",
        "READ_MESSAGE_NOTIFICATION",
        "REPLY_TO_READ_MESSAGE_NOTIFICATION",
        "SEARCH_GMAIL",
        "YOUTUBE_KIDS",
        "SEND_DIGITAL_OBJECT",
        "SEND_FEEDBACK",
        "SHARE_PHOTO",
        "SHARE_VIDEO",
        "SHARE_MUSIC",
        "SHARE_SCREENSHOT",
        "SHARE_WEBPAGE",
        "REDIAL_CALL",
        "RETURN_CALL",
        "RETURN_MISSED_CALL",
        "ROUTINE",
        "ROUTINE_INVOCATION",
        "DIAL_INTO_MEETING",
        "SHARE_DIGITAL_OBJECT",
        "COMPOSE_EMAIL",
        "FIND_ON_APP_OR_BROWSER",
        "KEYBOARD_DICTATION",
        "SEARCH_GSUITE",
        "JOIN_MEETING",
        "CREATE_MEETING",
        "CREATE_MEMORY",
        "IN_CALL_PUNT",
        "TELL_MY_FAMILY",
        "ADD_REMINDER",
        "SHOW_REMINDER",
        "UPDATE_REMINDER",
        "DELETE_REMINDER",
        "SHOW_LIST",
        "MODIFY_LIST",
        "SHOW_NOTE",
        "MODIFY_NOTE",
        "READ_SLEEP",
        "WRITE_SLEEP",
        "READ_ACTIVITY",
        "WRITE_ACTIVITY",
        "READ_NUTRITION",
        "WRITE_NUTRITION",
        "READ_WELLNESS",
        "WRITE_WELLNESS",
        "MAKE_BROADCAST",
    ]
    myActivityRedactionKey: str

@typing.type_check_only
class KnowledgeAnswersSensitivitySensitivity(typing_extensions.TypedDict, total=False):
    accountProvenance: _list[QualityQrewriteAccountProvenance]
    instruction: KnowledgeAnswersSensitivityInstruction
    source: _list[
        typing_extensions.Literal[
            "UNKNOWN_SOURCE",
            "INTENT_CATALOG",
            "GENIE_REWRITER",
            "FUNCTION_CALL_ARGUMENT_VALUE",
            "ATTENTIONAL_ENTITY",
            "PII_DETECTOR",
            "DIALOG_STATE",
            "ON_DEVICE",
            "FUNCTION_CALL",
            "END_OF_QREWRITE",
            "SYSTEM_RESPONSE",
            "DIALOG_INTENT_STATE",
            "ANALYZER_POST_PROCESSOR",
            "SAGE",
            "ANNOTATION_ARGUMENT_VALUE",
            "DIALOG_INTENT_STATE_INTENT",
            "DIALOG_INTENT_STATE_INTENT_CONTEXTUAL",
            "IGDP",
        ]
    ]
    type: typing_extensions.Literal["UNKNOWN_TYPE", "INTENT", "CONTEXTUAL"]

@typing.type_check_only
class KnowledgeAnswersSensitivityServingPolicy(
    typing_extensions.TypedDict, total=False
):
    enableRpcWhitelist: bool

@typing.type_check_only
class KnowledgeAnswersSensitivityStoragePolicy(
    typing_extensions.TypedDict, total=False
):
    encryptArgumentValue: bool
    encryptFieldCandidateValueTerm: bool
    encryptQueryAnnotationData: bool
    scrubAuxiliaryFieldsInConversationSnapshot: bool

@typing.type_check_only
class KnowledgeAnswersStateOfAffairsType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersStringType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings
    singleToken: bool

@typing.type_check_only
class KnowledgeAnswersTimeZoneType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersTrackingNumberType(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class KnowledgeAnswersUnionType(typing_extensions.TypedDict, total=False):
    slotNames: _list[str]

@typing.type_check_only
class KnowledgeAnswersValueType(typing_extensions.TypedDict, total=False):
    anyType: KnowledgeAnswersAnyType
    attributeType: KnowledgeAnswersAttributeType
    booleanType: KnowledgeAnswersBooleanType
    collectionType: KnowledgeAnswersCollectionType
    compoundType: KnowledgeAnswersCompoundType
    dateType: KnowledgeAnswersDateType
    dependencyType: KnowledgeAnswersDependencyType
    durationType: KnowledgeAnswersDurationType
    entityType: KnowledgeAnswersEntityType
    inputCompositionConfig: typing_extensions.Literal[
        "UNSPECIFIED_COMPOSITION",
        "ALL_COMPOSITION",
        "PRIMITIVES_ONLY_COMPOSITION",
        "PRIMITIVES_AND_OPERATORS_OF_PRIMITIVES_COMPOSITION",
        "PRIMITIVES_AND_SEMANTIC_TYPES_COMPOSITION",
    ]
    measurementType: KnowledgeAnswersMeasurementType
    normalizedStringType: KnowledgeAnswersNormalizedStringType
    numberType: KnowledgeAnswersNumberType
    opaqueType: KnowledgeAnswersOpaqueType
    plexityRequirement: KnowledgeAnswersPlexityRequirement
    polarQuestionType: KnowledgeAnswersPolarQuestionType
    semanticType: KnowledgeAnswersSemanticType
    stateOfAffairsType: KnowledgeAnswersStateOfAffairsType
    stringType: KnowledgeAnswersStringType
    timezoneType: KnowledgeAnswersTimeZoneType
    trackingNumberType: KnowledgeAnswersTrackingNumberType
    viewSpecificNumberTypes: _list[KnowledgeAnswersNumberType]

@typing.type_check_only
class KnowledgeGraphDateTimeProto(typing_extensions.TypedDict, total=False):
    days: int
    hours: int
    microseconds: int
    minutes: int
    months: int
    seconds: int
    tzOffset: str
    years: int

@typing.type_check_only
class KnowledgeGraphNestedStruct(typing_extensions.TypedDict, total=False):
    predicateObjs: _list[KnowledgeGraphNestedStructPredicateObjs]

@typing.type_check_only
class KnowledgeGraphNestedStructPredicateObjs(typing_extensions.TypedDict, total=False):
    objs: _list[KnowledgeGraphTripleObj]
    pred: str

@typing.type_check_only
class KnowledgeGraphQualifier(typing_extensions.TypedDict, total=False):
    pred: str
    value: KnowledgeGraphTripleObj

@typing.type_check_only
class KnowledgeGraphQualifierSet(typing_extensions.TypedDict, total=False):
    qualifiers: _list[KnowledgeGraphQualifier]

@typing.type_check_only
class KnowledgeGraphTriple(typing_extensions.TypedDict, total=False):
    isNegation: bool
    obj: KnowledgeGraphTripleObj
    pred: str
    provenance: _list[KnowledgeGraphTripleProvenance]
    qualifierSets: _list[KnowledgeGraphQualifierSet]
    sub: str

@typing.type_check_only
class KnowledgeGraphTripleObj(typing_extensions.TypedDict, total=False):
    boolValue: bool
    datetimeValue: KnowledgeGraphDateTimeProto
    doubleValue: float
    durationValue: str
    idValue: str
    int64Value: str
    locale: str
    nestedStructValue: KnowledgeGraphNestedStruct
    protoValue: KnowledgeGraphTripleObjProto
    s2cellId: str
    stringValue: str
    uint64Value: str
    uriValue: str

@typing.type_check_only
class KnowledgeGraphTripleObjProto(typing_extensions.TypedDict, total=False):
    data: str
    descriptorFullName: str

@typing.type_check_only
class KnowledgeGraphTripleProvenance(typing_extensions.TypedDict, total=False):
    accessRequired: int
    creator: str
    datasetMid: str
    isSupportingData: bool
    lgMetadata: StorageGraphBfgLivegraphProvenanceMetadata
    policyMetadata: StorageGraphBfgPolicyMetadata
    process: str
    restrictions: _list[
        typing_extensions.Literal[
            "REQUIRES_CITATION",
            "REQUIRES_PCOUNSEL_REVIEW",
            "UNRESTRICTED_WITHIN_GOOGLE_NO_3P_USE",
        ]
    ]
    sourceCategory: typing_extensions.Literal[
        "THIRD_PARTY", "CURATION", "PARTNER_FEED", "EXTRACTION"
    ]
    sourceDocId: str
    sourceUrl: str
    spiiCertification: StorageGraphBfgSpiiCertification

@typing.type_check_only
class KnowledgeVerticalsWeatherProtoUserSpecifiedLocation(
    typing_extensions.TypedDict, total=False
):
    featureId: GeostoreFeatureIdProto
    latLng: GoogleTypeLatLng
    locationName: str
    mid: str
    timezone: str

@typing.type_check_only
class LegalCitation(typing_extensions.TypedDict, total=False):
    CountryCode: str
    ParseType: int
    State: str
    Type: int
    courtdocument: LegalCitationCourtDocument
    law: LegalCitationLaw

@typing.type_check_only
class LegalCitationCourtDocument(typing_extensions.TypedDict, total=False):
    ArguedBefore: _list[LegalPerson]
    ArguedDate: LegalDate
    CertiorariCourtName: str
    CertiorariRelationship: int
    CourtTerm: str
    DecidedDate: LegalDate
    FiledDate: LegalDate
    MemoID: str
    ModifiedDate: LegalDate
    Syllabus: str
    court: LegalCitationCourtDocumentCourt
    opinioninfo: _list[LegalCitationCourtDocumentOpinionInfo]
    perdocketinfo: _list[LegalCitationCourtDocumentPerDocketInfo]
    pub: _list[LegalCitationCourtDocumentPub]
    unknowndate: _list[LegalCitationCourtDocumentUnknownDate]

@typing.type_check_only
class LegalCitationCourtDocumentCourt(typing_extensions.TypedDict, total=False):
    DisplayName: str
    Level: int
    Name: str
    OriginalName: str
    namecomponent: _list[LegalCitationCourtDocumentCourtNameComponent]

@typing.type_check_only
class LegalCitationCourtDocumentCourtNameComponent(
    typing_extensions.TypedDict, total=False
):
    Text: str
    Type: int

@typing.type_check_only
class LegalCitationCourtDocumentOpinionInfo(typing_extensions.TypedDict, total=False):
    Bench: int
    DeliveredBy: LegalPerson
    JoinedBy: LegalPerson
    Type: int

@typing.type_check_only
class LegalCitationCourtDocumentPerDocketInfo(typing_extensions.TypedDict, total=False):
    DocketID: str
    Petitioner: _list[LegalPerson]
    PetitionerCounsel: _list[LegalPerson]
    Respondent: _list[LegalPerson]
    RespondentCounsel: _list[LegalPerson]
    Topic: str

@typing.type_check_only
class LegalCitationCourtDocumentPub(typing_extensions.TypedDict, total=False):
    Page: str
    Paragraph: str
    Reporter: str
    Volume: int
    Year: int

@typing.type_check_only
class LegalCitationCourtDocumentUnknownDate(typing_extensions.TypedDict, total=False):
    Date: LegalDate
    Description: str

@typing.type_check_only
class LegalCitationLaw(typing_extensions.TypedDict, total=False):
    RevisionDate: LegalDate
    Status: int
    Type: int
    collectionname: LegalCitationLawCollectionName
    level: _list[LegalCitationLawLevel]

@typing.type_check_only
class LegalCitationLawCollectionName(typing_extensions.TypedDict, total=False):
    Normalized: str
    Source: str

@typing.type_check_only
class LegalCitationLawLevel(typing_extensions.TypedDict, total=False):
    Depth: int
    LevelTypeNormalized: str
    LevelTypeSourceText: str
    LevelTypeString: str
    Name: str
    Type: int
    Value: str

@typing.type_check_only
class LegalDate(typing_extensions.TypedDict, total=False):
    Day: int
    Month: int
    Year: int

@typing.type_check_only
class LegalPerson(typing_extensions.TypedDict, total=False):
    Description: str
    LastName: str
    OtherNames: str

@typing.type_check_only
class LensDiscoveryStyleAestheticsScoreSignals(
    typing_extensions.TypedDict, total=False
):
    discretizedAestheticsScore: int
    version: typing_extensions.Literal[
        "VERSION_UNKNOWN", "AESTHETICS_V1", "AESTHETICS_V2"
    ]

@typing.type_check_only
class LensDiscoveryStyleBoundingBox(typing_extensions.TypedDict, total=False):
    x1: int
    x2: int
    y1: int
    y2: int

@typing.type_check_only
class LensDiscoveryStylePersonAttributes(typing_extensions.TypedDict, total=False):
    discretizedFaceVisibilityScore: int
    discretizedFemaleConfidence: int
    discretizedMaleConfidence: int
    discretizedPredictedAge: int
    discretizedVisualSaliencyScore: int
    personBoundingBox: LensDiscoveryStyleBoundingBox
    personVisibilityScores: LensDiscoveryStylePersonAttributesPersonVisibilityScores
    predictedAgeBucket: typing_extensions.Literal[
        "PERSON_AGE_UNKNOWN",
        "PERSON_AGE_YOUNG_ADULT",
        "PERSON_AGE_20_29",
        "PERSON_AGE_30_49",
        "PERSON_AGE_50_64",
        "PERSON_AGE_65_74",
        "PERSON_AGE_ABOVE_75",
    ]
    version: typing_extensions.Literal[
        "VERSION_UNKNOWN", "LOOKNET_PERSON_V2B", "PERSON_INTERPRETATION_V1"
    ]

@typing.type_check_only
class LensDiscoveryStylePersonAttributesPersonVisibilityScores(
    typing_extensions.TypedDict, total=False
):
    discretizedPersonVisibilityScore: int
    personVisibilityPredictions: _list[
        LensDiscoveryStylePersonAttributesPersonVisibilityScoresPersonVisibilityPrediction
    ]

@typing.type_check_only
class LensDiscoveryStylePersonAttributesPersonVisibilityScoresPersonVisibilityPrediction(
    typing_extensions.TypedDict, total=False
):
    discretizedIconicPersonVisibilityConfidence: int
    iconicPersonVisibilityType: typing_extensions.Literal[
        "PERSON_VISIBILITY_UNKNOWN",
        "PERSON_VISIBILITY_HEAD_AND_SHOULDERS_ONLY",
        "PERSON_VISIBILITY_HALF_LENGTH",
        "PERSON_VISIBILITY_THREE_QUARTER_LENGTH",
        "PERSON_VISIBILITY_FULL_LENGTH",
    ]

@typing.type_check_only
class LensDiscoveryStylePersonDetectionSignals(
    typing_extensions.TypedDict, total=False
):
    detectedPersons: _list[LensDiscoveryStylePersonDetectionSignalsDetectedPerson]
    version: typing_extensions.Literal[
        "VERSION_UNKNOWN", "FASTER_RCNN", "PERSON_INTERPRETATION_V1"
    ]

@typing.type_check_only
class LensDiscoveryStylePersonDetectionSignalsDetectedPerson(
    typing_extensions.TypedDict, total=False
):
    boundingBox: LensDiscoveryStyleBoundingBox

@typing.type_check_only
class LensDiscoveryStyleStyleImageTypeSignals(typing_extensions.TypedDict, total=False):
    styleImageTypePredictions: _list[
        LensDiscoveryStyleStyleImageTypeSignalsStyleImageTypePrediction
    ]
    version: typing_extensions.Literal["VERSION_UNKNOWN", "STYLE_IMAGE_TYPE_V1"]

@typing.type_check_only
class LensDiscoveryStyleStyleImageTypeSignalsStyleImageTypePrediction(
    typing_extensions.TypedDict, total=False
):
    discretizedStyleImageTypeConfidence: int
    styleImageType: typing_extensions.Literal[
        "TYPE_UNKNOWN", "TYPE_STAGE", "TYPE_STOCK", "TYPE_STREET", "TYPE_OUTFITS"
    ]

@typing.type_check_only
class ListSnippetResponse(typing_extensions.TypedDict, total=False):
    header: ListSnippetResponseRow
    isTable: bool
    row: _list[ListSnippetResponseRow]
    totalRows: int

@typing.type_check_only
class ListSnippetResponseRow(typing_extensions.TypedDict, total=False):
    column: _list[str]

@typing.type_check_only
class LocalWWWInfo(typing_extensions.TypedDict, total=False):
    address: _list[LocalWWWInfoAddress]
    brickAndMortarStrength: float
    cluster: _list[LocalWWWInfoCluster]
    docid: str
    geotopicality: RepositoryAnnotationsGeoTopicality
    hours: _list[LocalWWWInfoOpeningHours]
    isLargeChain: bool
    isLargeLocalwwwinfo: bool
    phone: _list[LocalWWWInfoPhone]
    siteSiblings: int
    url: str
    wrapptorItem: _list[LocalWWWInfoWrapptorItem]

@typing.type_check_only
class LocalWWWInfoAddress(typing_extensions.TypedDict, total=False):
    addrFprint: str
    address: GeostoreAddressProto
    latE7: int
    lngE7: int

@typing.type_check_only
class LocalWWWInfoCluster(typing_extensions.TypedDict, total=False):
    addrFprint: str
    annotationConfidence: float
    clusterdocid: str
    clusterid: str
    confidence: float
    featureType: int
    hours: GeostoreTimeScheduleProto
    hoursSource: typing_extensions.Literal["LOCAL", "EXTRACTED_ONPAGE"]
    includeInIndex: bool
    isPlusbox: bool
    latitudeE6: int
    level: int
    longitudeE6: int
    makePlusboxVisible: bool
    menuUrl: _list[str]
    pageTypeFlags: int
    phoneFprint: str
    phoneNumber: TelephoneNumber
    postalAddress: PostalAddress
    relevance: float
    showInSnippets: bool
    source: _list[str]
    title: str

@typing.type_check_only
class LocalWWWInfoOpeningHours(typing_extensions.TypedDict, total=False):
    hours: GeostoreTimeScheduleProto
    hoursFprint: str

@typing.type_check_only
class LocalWWWInfoPhone(typing_extensions.TypedDict, total=False):
    phoneFprint: str
    phoneNumber: TelephoneNumber

@typing.type_check_only
class LocalWWWInfoWrapptorItem(typing_extensions.TypedDict, total=False):
    addrFprint: str
    bizName: str
    phoneFprint: str

@typing.type_check_only
class LocalsearchChainId(typing_extensions.TypedDict, total=False):
    category: str
    prominentEntityId: str
    sitechunk: str

@typing.type_check_only
class LocalsearchDocInfo(typing_extensions.TypedDict, total=False): ...

@typing.type_check_only
class LocalsearchProtoInternalFoodOrderingActionMetadata(
    typing_extensions.TypedDict, total=False
):
    actionType: typing_extensions.Literal[
        "UNKNOWN_ACTION_TYPE", "E2E", "TOA", "AUTOBOT", "PAS"
    ]
    hasPrimarilyFoodIntent: bool
    isOutOfOperationalHours: bool
    isWhitelistedExternalRestaurant: bool
    nextOpeningTime: str
    onlyOrderAheadServicesAvailable: bool
    serviceInfo: _list[LocalsearchProtoInternalFoodOrderingActionMetadataServiceInfo]
    supportedServiceType: typing_extensions.Literal[
        "UNKNOWN_TYPE", "DELIVERY", "PICKUP", "ANY_TYPE"
    ]
    unavailabilityReason: typing_extensions.Literal[
        "UNKNOWN_REASON",
        "NOT_INTEGRATED_WITH_FOPA",
        "OUT_OF_OPERATIONAL_HOURS",
        "OUT_OF_SERVICE_AREA",
        "PERMANENTLY_CLOSED",
        "BLACKLISTED",
        "TEMPORARILY_CLOSED",
    ]

@typing.type_check_only
class LocalsearchProtoInternalFoodOrderingActionMetadataAvailablePartnerInfo(
    typing_extensions.TypedDict, total=False
):
    availablePartnerId: str
    logOnly: bool

@typing.type_check_only
class LocalsearchProtoInternalFoodOrderingActionMetadataServiceInfo(
    typing_extensions.TypedDict, total=False
):
    availablePartnerInfo: _list[
        LocalsearchProtoInternalFoodOrderingActionMetadataAvailablePartnerInfo
    ]
    maxWaitTimeSec: str
    minDeliveryFee: GoogleTypeMoney
    minWaitTimeSec: str
    serviceType: typing_extensions.Literal[
        "UNKNOWN_TYPE", "DELIVERY", "PICKUP", "ANY_TYPE"
    ]

@typing.type_check_only
class LogsProtoIndexingCrawlerIdCrawlerIdProto(
    typing_extensions.TypedDict, total=False
):
    country: typing_extensions.Literal[
        "NO_COUNTRY", "AUSTRALIA", "CANADA", "GREAT_BRITAIN", "MEXICO", "RUSSIA"
    ]
    deviceType: typing_extensions.Literal[
        "DESKTOP",
        "SMARTPHONE",
        "MOBILE",
        "JPMOBILE",
        "IMAGE",
        "VIDEO",
        "APP",
        "ANDROID_APP",
        "IOS_APP",
        "PIDGIN",
    ]
    indexGrowthExptType: typing_extensions.Literal[
        "INDEX_GROWTH_EXPERIMENT_TYPE_DEFAULT",
        "INDEX_GROWTH_EXPERIMENT_TYPE_DUPLICATED",
    ]
    language: typing_extensions.Literal[
        "ENGLISH",
        "DANISH",
        "DUTCH",
        "FINNISH",
        "FRENCH",
        "GERMAN",
        "HEBREW",
        "ITALIAN",
        "JAPANESE",
        "KOREAN",
        "NORWEGIAN",
        "POLISH",
        "PORTUGUESE",
        "RUSSIAN",
        "SPANISH",
        "SWEDISH",
        "CHINESE",
        "CZECH",
        "GREEK",
        "ICELANDIC",
        "LATVIAN",
        "LITHUANIAN",
        "ROMANIAN",
        "HUNGARIAN",
        "ESTONIAN",
        "TG_UNKNOWN_LANGUAGE",
        "UNKNOWN_LANGUAGE",
        "BULGARIAN",
        "CROATIAN",
        "SERBIAN",
        "IRISH",
        "GALICIAN",
        "TAGALOG",
        "TURKISH",
        "UKRAINIAN",
        "HINDI",
        "MACEDONIAN",
        "BENGALI",
        "INDONESIAN",
        "LATIN",
        "MALAY",
        "MALAYALAM",
        "WELSH",
        "NEPALI",
        "TELUGU",
        "ALBANIAN",
        "TAMIL",
        "BELARUSIAN",
        "JAVANESE",
        "OCCITAN",
        "URDU",
        "BIHARI",
        "GUJARATI",
        "THAI",
        "ARABIC",
        "CATALAN",
        "ESPERANTO",
        "BASQUE",
        "INTERLINGUA",
        "KANNADA",
        "PUNJABI",
        "SCOTS_GAELIC",
        "SWAHILI",
        "SLOVENIAN",
        "MARATHI",
        "MALTESE",
        "VIETNAMESE",
        "FRISIAN",
        "SLOVAK",
        "CHINESE_T",
        "FAROESE",
        "SUNDANESE",
        "UZBEK",
        "AMHARIC",
        "AZERBAIJANI",
        "GEORGIAN",
        "TIGRINYA",
        "PERSIAN",
        "BOSNIAN",
        "SINHALESE",
        "NORWEGIAN_N",
        "PORTUGUESE_P",
        "PORTUGUESE_B",
        "XHOSA",
        "ZULU",
        "GUARANI",
        "SESOTHO",
        "TURKMEN",
        "KYRGYZ",
        "BRETON",
        "TWI",
        "YIDDISH",
        "SERBO_CROATIAN",
        "SOMALI",
        "UIGHUR",
        "KURDISH",
        "MONGOLIAN",
        "ARMENIAN",
        "LAOTHIAN",
        "SINDHI",
        "RHAETO_ROMANCE",
        "AFRIKAANS",
        "LUXEMBOURGISH",
        "BURMESE",
        "KHMER",
        "TIBETAN",
        "DHIVEHI",
        "CHEROKEE",
        "SYRIAC",
        "LIMBU",
        "ORIYA",
        "ASSAMESE",
        "CORSICAN",
        "INTERLINGUE",
        "KAZAKH",
        "LINGALA",
        "MOLDAVIAN",
        "PASHTO",
        "QUECHUA",
        "SHONA",
        "TAJIK",
        "TATAR",
        "TONGA",
        "YORUBA",
        "CREOLES_AND_PIDGINS_ENGLISH_BASED",
        "CREOLES_AND_PIDGINS_FRENCH_BASED",
        "CREOLES_AND_PIDGINS_PORTUGUESE_BASED",
        "CREOLES_AND_PIDGINS_OTHER",
        "MAORI",
        "WOLOF",
        "ABKHAZIAN",
        "AFAR",
        "AYMARA",
        "BASHKIR",
        "BISLAMA",
        "DZONGKHA",
        "FIJIAN",
        "GREENLANDIC",
        "HAUSA",
        "HAITIAN_CREOLE",
        "INUPIAK",
        "INUKTITUT",
        "KASHMIRI",
        "KINYARWANDA",
        "MALAGASY",
        "NAURU",
        "OROMO",
        "RUNDI",
        "SAMOAN",
        "SANGO",
        "SANSKRIT",
        "SISWANT",
        "TSONGA",
        "TSWANA",
        "VOLAPUK",
        "ZHUANG",
        "KHASI",
        "SCOTS",
        "GANDA",
        "MANX",
        "MONTENEGRIN",
        "AKAN",
        "IGBO",
        "MAURITIAN_CREOLE",
        "HAWAIIAN",
        "CEBUANO",
        "EWE",
        "GA",
        "HMONG",
        "KRIO",
        "LOZI",
        "LUBA_LULUA",
        "LUO_KENYA_AND_TANZANIA",
        "NEWARI",
        "NYANJA",
        "OSSETIAN",
        "PAMPANGA",
        "PEDI",
        "RAJASTHANI",
        "SESELWA_CREOLE_FRENCH",
        "TUMBUKA",
        "VENDA",
        "WARAY_PHILIPPINES",
        "NUM_LANGUAGES",
    ]
    languageCode: typing_extensions.Literal[
        "LANGCODE_UNKNOWN",
        "LANGCODE_EN_US",
        "LANGCODE_EN_AU",
        "LANGCODE_EN_CA",
        "LANGCODE_DE_DE",
        "LANGCODE_FR_FR",
        "LANGCODE_FR_CA",
    ]

@typing.type_check_only
class LogsSemanticInterpretationIntentQueryEntityLinkMetadata(
    typing_extensions.TypedDict, total=False
):
    aggregateFlags: LogsSemanticInterpretationIntentQueryLinkKindFlags
    kindInfo: _list[LogsSemanticInterpretationIntentQueryLinkKindInfo]

@typing.type_check_only
class LogsSemanticInterpretationIntentQueryLinkKindFlags(
    typing_extensions.TypedDict, total=False
):
    cluster: typing_extensions.Literal[
        "NO_CLUSTER", "CLUSTER_CHILD_OF", "CLUSTER_PARENT_OF"
    ]
    geoContainment: typing_extensions.Literal[
        "NO_CONTAINMENT",
        "CONTAINED_BY",
        "CONTAINS",
        "PARTIAL_OVERLAP",
        "HAS_STREET_NUMBER",
        "LOCATED_ON_STREET",
    ]
    implication: typing_extensions.Literal[
        "NO_IMPLICATION",
        "IMPLIED_BY",
        "IMPLIES",
        "BIDIRECTIONAL_IMPLICATION",
        "UNDERMERGED",
    ]
    latentEntity: typing_extensions.Literal[
        "NO_LATENT_ENTITY",
        "LATENT_ENTITY",
        "MANIFEST_ENTITY",
        "LATENT_ENTITY_V2",
        "MANIFEST_ENTITY_V2",
    ]
    mdvc: typing_extensions.Literal[
        "NO_MDVC",
        "MDVC_SPECIALIZATION_OF",
        "MDVC_GENERALIZATION_OF",
        "MDVC_DIMENSION_VALUE",
        "MDVC_DIMENSION_VALUE_OF",
        "MDVC_RESOLUTION",
        "MDVC_EXPANDED_OUTPUT",
    ]
    property: typing_extensions.Literal[
        "NO_PROPERTY", "EQUIVALENT_TOPIC", "EQUIVALENT_PROPERTY"
    ]
    resolution: typing_extensions.Literal[
        "NO_RESOLUTION",
        "MAY_BE_RESOLVED_FROM",
        "MAY_RESOLVE_TO",
        "RESOLVED_FROM",
        "RESOLVES_TO",
    ]

@typing.type_check_only
class LogsSemanticInterpretationIntentQueryLinkKindInfo(
    typing_extensions.TypedDict, total=False
):
    flags: LogsSemanticInterpretationIntentQueryLinkKindFlags
    kcLinkName: str
    topicPropertyName: str

@typing.type_check_only
class LogsSemanticInterpretationIntentQuerySupportTransferRule(
    typing_extensions.TypedDict, total=False
):
    allowWildcardIntents: bool
    domain: str
    isReverseLink: bool
    mentionsOnly: bool
    supportShare: bool
    targetCollection: str
    userCountry: str
    userLanguage: str

@typing.type_check_only
class LogsSemanticInterpretationIntentQueryWebrefEntityRelationship(
    typing_extensions.TypedDict, total=False
):
    entityIndex: int
    linkMetadata: LogsSemanticInterpretationIntentQueryEntityLinkMetadata
    linkWeight: float

@typing.type_check_only
class LongStructuredSnippet(typing_extensions.TypedDict, total=False):
    entry: _list[LongStructuredSnippetEntry]

@typing.type_check_only
class LongStructuredSnippetEntry(typing_extensions.TypedDict, total=False):
    header: bool
    text: str

@typing.type_check_only
class MajelContactInformationShortcutInformation(
    typing_extensions.TypedDict, total=False
):
    shortcutContactType: typing_extensions.Literal[
        "UNSPECIFIED", "NON_SHORTCUT", "INDIVIDUAL", "GROUP"
    ]

@typing.type_check_only
class MapsQualitySpecialWordsFlags(typing_extensions.TypedDict, total=False):
    isAlleyAffix: bool
    isCommonWord: bool
    isDeconstructible: bool
    isDirectionalModifier: bool
    isDistanceMarker: bool
    isForbiddenWord: bool
    isHouseIdIdentifier: bool
    isIntersectionConnector: bool
    isLandmarkIdentifier: bool
    isLanguageIndicator: bool
    isNameSynonym: bool
    isNotForLegacyStreetNumberDetection: bool
    isNotOptionalizable: bool
    isNumber: bool
    isNumberSuffix: bool
    isOptional: bool
    isOrdinalNumber: bool
    isPenalizedIfMissing: bool
    isPersonalTitle: bool
    isStopWord: bool
    isStreetNumberIdentifier: bool

@typing.type_check_only
class MapsQualitySpecialWordsProto(typing_extensions.TypedDict, total=False):
    alternate: _list[str]
    canonical: _list[str]
    country: _list[str]
    flags: MapsQualitySpecialWordsFlags
    language: _list[str]
    position: typing_extensions.Literal["AFFIX", "PREFIX", "SUFFIX"]
    visibleTypeId: _list[str]

@typing.type_check_only
class MediaIndexBoundingbox(typing_extensions.TypedDict, total=False):
    areaFraction: float
    xmax: float
    xmin: float
    ymax: float
    ymin: float

@typing.type_check_only
class MediaIndexEntityField(typing_extensions.TypedDict, total=False):
    customSource: str
    entityId: str
    quantizedScore: str
    source: typing_extensions.Literal[
        "UNKNOWN",
        "ICA_LABELS",
        "VISUAL_DICTIONARY",
        "VISUAL_SEARCH_LANDMARK",
        "WEBREF_ANNOTATIONS",
        "KG_KP",
        "SMEARED_VISUAL_DICTIONARY",
        "SMEARED_VISUAL_SEARCH_LANDMARK",
        "CURATED_SIGNAL",
        "LAVD_BONES",
        "ICA_H_TOPICALITY",
        "WEBREF_CONFIDENCE",
        "LAVD_TRAVEL_SNAPWIRE",
        "LAVD_TRAVEL_500PX",
        "LAVD_TRAVEL_ALAMY",
        "LAVD_TRAVEL_EYEEM",
        "LAVD_TRAVEL_SHUTTERSTOCK",
        "LAVD_TRAVEL_GETTY",
        "PROVIDED_PEOPLE",
        "KG_AUTOMOTIVE",
        "SMEARED_NAVBOOST",
        "KIWI_ENTITY_VISUAL_SCORE",
        "KIWI_ENTITY_RANK",
        "KIWI_ENTITY_VISUAL_SCORE_EXP",
        "KIWI_ENTITY_RANK_EXP",
    ]

@typing.type_check_only
class MediaIndexFrameIdentifier(typing_extensions.TypedDict, total=False):
    previewFrameZeroVariant: MediaIndexFrameIdentifierPreviewFrameZeroVariant
    timestampMs: int

@typing.type_check_only
class MediaIndexFrameIdentifierPreviewFrameZeroVariant(
    typing_extensions.TypedDict, total=False
):
    previewLength: typing_extensions.Literal[
        "UNSPECIFIED", "THREE_SECONDS", "SIX_SECONDS"
    ]
    xtagList: MediaIndexXtagList

@typing.type_check_only
class MediaIndexRegion(typing_extensions.TypedDict, total=False):
    boundingBox: MediaIndexBoundingbox
    entityFields: _list[MediaIndexEntityField]
    labels: MediaIndexSparseFloatVector
    primiApparelFeaturesV2: str
    primiApparelTokensV2: _list[str]
    primiGenericFeaturesV25: str
    primiGenericTokensV25: _list[str]
    starburstFeaturesV4: str
    starburstFeaturesV5: str
    starburstTokensV4: _list[str]
    starburstTokensV5: _list[str]
    starburstV4: ImageContentStarburstVersionGroup
    starburstV5: ImageContentStarburstVersionGroup

@typing.type_check_only
class MediaIndexSparseFloatVector(typing_extensions.TypedDict, total=False):
    columns: _list[str]
    columnsInt16: str
    columnsInt32: _list[int]
    columnsInt64: _list[str]
    columnsInt8: str
    values: _list[float]

@typing.type_check_only
class MediaIndexVideoCentroid(typing_extensions.TypedDict, total=False):
    domainScores: _list[MediaIndexVideoCentroidDomainScore]

@typing.type_check_only
class MediaIndexVideoCentroidDomainScore(typing_extensions.TypedDict, total=False):
    domain: str
    numDocs: int
    score: float

@typing.type_check_only
class MediaIndexVideoCoreSignals(typing_extensions.TypedDict, total=False):
    centroid: MediaIndexVideoCentroid
    videoFrames: _list[MediaIndexVideoFrame]

@typing.type_check_only
class MediaIndexVideoFrame(typing_extensions.TypedDict, total=False):
    docid: str
    frameIdentifier: MediaIndexFrameIdentifier
    regions: _list[MediaIndexRegion]
    starburstFeaturesV4: str
    starburstTokensV4: _list[str]
    thumbnailType: _list[str]

@typing.type_check_only
class MediaIndexVideoFrames(typing_extensions.TypedDict, total=False):
    videoFrames: _list[MediaIndexVideoFrame]

@typing.type_check_only
class MediaIndexXtag(typing_extensions.TypedDict, total=False):
    name: str
    value: str

@typing.type_check_only
class MediaIndexXtagList(typing_extensions.TypedDict, total=False):
    xtags: _list[MediaIndexXtag]

@typing.type_check_only
class MobilePerDocData(typing_extensions.TypedDict, total=False):
    flags: int
    mobileurl: str
    transcodedPageScore: int

@typing.type_check_only
class MultiscaleFieldPresence(typing_extensions.TypedDict, total=False):
    present: bool
    wellDefined: typing_extensions.Literal[
        "WD_UNDEFINED", "WD_WELL_DEFINED", "WD_PARTIAL"
    ]

@typing.type_check_only
class MultiscaleLayerPresence(typing_extensions.TypedDict, total=False):
    implicitLength: int
    present: bool

@typing.type_check_only
class MultiscalePointerIndex(typing_extensions.TypedDict, total=False):
    index: int

@typing.type_check_only
class MultiscalePointerSpan(typing_extensions.TypedDict, total=False):
    limit: int
    start: int

@typing.type_check_only
class MustangReposWwwSnippetsCandidateFeature(typing_extensions.TypedDict, total=False):
    name: str
    score: float

@typing.type_check_only
class MustangReposWwwSnippetsOrganicListSnippetResponse(
    typing_extensions.TypedDict, total=False
):
    header: str
    headerTitleRedundancy: float
    headerUsedInSnippet: bool
    items: _list[str]
    originalTotalItems: int
    radishScore: float

@typing.type_check_only
class MustangReposWwwSnippetsSnippetCandidate(typing_extensions.TypedDict, total=False):
    dataSourceType: int
    features: _list[MustangReposWwwSnippetsCandidateFeature]
    text: str

@typing.type_check_only
class MustangReposWwwSnippetsSnippetsRanklabFeatures(
    typing_extensions.TypedDict, total=False
):
    browserWidth: int
    candidates: _list[MustangReposWwwSnippetsSnippetCandidate]
    displaySnippet: QualityPreviewRanklabSnippet
    documentLanguage: str
    originalQueryTermCoverages: QualityPreviewSnippetQueryTermCoverageFeatures
    queryLanguage: str
    snippetDataSourceType: int
    snippetQueryTermCoverage: float
    snippets: _list[QualityPreviewRanklabSnippet]
    titleDataSourceType: int
    titleQueryTermCoverage: float
    titleSnippetQueryTermCoverage: float
    titles: _list[QualityPreviewRanklabTitle]

@typing.type_check_only
class MustangSnippetsRenderedToken(typing_extensions.TypedDict, total=False):
    bolded: bool
    byteOffsetBegin: int
    byteOffsetEnd: int
    section: typing_extensions.Literal["UNKNOWN", "BODY_WITH_SOFT_TOKEN", "GWD", "META"]
    tokenPos: str

@typing.type_check_only
class NSRVersionedItem(typing_extensions.TypedDict, total=False):
    value: float
    versionId: int

@typing.type_check_only
class NetFabricRpcVirtualNetworkId(typing_extensions.TypedDict, total=False):
    id: int

@typing.type_check_only
class NlpMeaningComponentSpecificContracts(typing_extensions.TypedDict, total=False):
    componentSpecificContracts: _list[
        typing_extensions.Literal["UNSPECIFIED", "P2_LWA"]
    ]

@typing.type_check_only
class NlpMeaningMeaningRemodeling(typing_extensions.TypedDict, total=False):
    deletion: bool
    id: str

@typing.type_check_only
class NlpMeaningMeaningRemodelingControl(typing_extensions.TypedDict, total=False):
    remodelingId: _list[str]

@typing.type_check_only
class NlpMeaningMeaningRemodelings(typing_extensions.TypedDict, total=False):
    remodeling: _list[NlpMeaningMeaningRemodeling]

@typing.type_check_only
class NlpMeaningSemanticTypeNameComponentSpecificContracts(
    typing_extensions.TypedDict, total=False
):
    componentSpecificContracts: NlpMeaningComponentSpecificContracts
    name: str

@typing.type_check_only
class NlpMeaningSemanticTypeNameMeaningRemodelings(
    typing_extensions.TypedDict, total=False
):
    name: str
    remodelings: NlpMeaningMeaningRemodelings

@typing.type_check_only
class NlpSaftAnnotatedPhrase(typing_extensions.TypedDict, total=False):
    info: Proto2BridgeMessageSet
    phrase: NlpSaftPhrase

@typing.type_check_only
class NlpSaftConstituencyNode(typing_extensions.TypedDict, total=False):
    child: _list[int]
    label: str
    phrase: NlpSaftPhrase

@typing.type_check_only
class NlpSaftDocument(typing_extensions.TypedDict, total=False):
    annotatedPhrase: _list[NlpSaftAnnotatedPhrase]
    annotations: Proto2BridgeMessageSet
    author: _list[str]
    bylineDate: str
    constituencyNode: _list[NlpSaftConstituencyNode]
    constituencyRoot: _list[int]
    contentFirstseen: str
    contentType: int
    contentage: str
    date: str
    docid: str
    entity: _list[NlpSaftEntity]
    entityLabel: _list[str]
    focusEntity: int
    golden: bool
    httpHeaders: str
    hyperlink: _list[NlpSaftHyperlink]
    labeledSpans: dict[str, typing.Any]
    language: int
    lastSignificantUpdate: str
    measure: _list[NlpSaftMeasure]
    privacySensitive: bool
    relation: _list[NlpSaftRelation]
    rpcError: bool
    semanticNode: _list[NlpSaftSemanticNode]
    subsection: _list[NlpSaftDocument]
    syntacticDate: str
    text: str
    title: str
    token: _list[NlpSaftToken]
    topic: _list[NlpSaftDocumentTopic]
    trace: bool
    url: str

@typing.type_check_only
class NlpSaftDocumentTopic(typing_extensions.TypedDict, total=False):
    name: str
    score: float

@typing.type_check_only
class NlpSaftEntity(typing_extensions.TypedDict, total=False):
    antecedent: int
    entityType: str
    entityTypeProbability: _list[float]
    gender: typing_extensions.Literal["MASCULINE", "FEMININE", "NEUTER", "PLURAL"]
    info: Proto2BridgeMessageSet
    mention: _list[NlpSaftMention]
    name: str
    profile: NlpSaftEntityProfile
    referent: NlpSaftReferent
    representativeMention: int
    salience: float
    type: _list[NlpSaftEntityType]

@typing.type_check_only
class NlpSaftEntityProfile(typing_extensions.TypedDict, total=False):
    alternate: _list[NlpSaftEntityProfileAlternate]
    annotations: Proto2BridgeMessageSet
    attribute: _list[NlpSaftEntityProfileAttribute]
    canonicalName: str
    collectionScoreType: typing_extensions.Literal[
        "COLLECTION_GIVEN_ENTITY", "ENTITY_GIVEN_COLLECTION"
    ]
    disambiguation: str
    embedding: _list[float]
    frame: str
    gender: typing_extensions.Literal["MASCULINE", "FEMININE", "NEUTER", "PLURAL"]
    id: str
    identifier: _list[NlpSaftIdentifier]
    keyword: _list[NlpSaftEntityProfileKeyword]
    mid: str
    name: str
    nameLanguage: int
    nature: typing_extensions.Literal[
        "UNKNOWN",
        "CONCEPT",
        "THING",
        "ESTABLISHMENT",
        "INDIVIDUAL",
        "GIVEN_NAME",
        "FAMILY_NAME",
    ]
    reference: _list[NlpSaftEntityProfileReference]
    related: _list[NlpSaftEntityProfileRelated]
    type: str

@typing.type_check_only
class NlpSaftEntityProfileAlternate(typing_extensions.TypedDict, total=False):
    count: int
    form: int
    frame: str
    language: int
    name: str
    sources: int

@typing.type_check_only
class NlpSaftEntityProfileAttribute(typing_extensions.TypedDict, total=False):
    boolValue: bool
    floatValue: float
    intValue: str
    language: int
    type: str
    typeId: int
    value: str
    valueType: typing_extensions.Literal[
        "ATTRIBUTE_TYPE_STRING",
        "ATTRIBUTE_TYPE_INT",
        "ATTRIBUTE_TYPE_FLOAT",
        "ATTRIBUTE_TYPE_BOOL",
        "ATTRIBUTE_TYPE_DATETIME",
    ]

@typing.type_check_only
class NlpSaftEntityProfileKeyword(typing_extensions.TypedDict, total=False):
    count: int
    language: int
    score: float
    term: str
    type: typing_extensions.Literal[
        "CONTEXT",
        "MENTION",
        "HEADLINE",
        "TOPIC",
        "TEMPORAL",
        "FREEBASE_TYPE",
        "FREEBASE_NOTABLE_TYPE",
        "FREEBASE_NOTABLE_FOR",
        "FINE_TYPE",
        "KG_COLLECTION",
        "HYPERNYM",
    ]

@typing.type_check_only
class NlpSaftEntityProfileReference(typing_extensions.TypedDict, total=False):
    docid: str
    entity: int

@typing.type_check_only
class NlpSaftEntityProfileRelated(typing_extensions.TypedDict, total=False):
    count: int
    inverse: bool
    relationId: int
    relationIdentifier: NlpSaftIdentifier
    score: float
    targetId: str
    targetIdentifier: NlpSaftIdentifier
    targetName: str
    type: str

@typing.type_check_only
class NlpSaftEntityType(typing_extensions.TypedDict, total=False):
    basedOnMention: int
    domain: typing_extensions.Literal[
        "UNSPECIFIED",
        "SAFT",
        "SAFT_FINE",
        "SAFT_FINE_MENTION",
        "COLLECTIONS",
        "FREEBASE",
        "FIGER",
        "ISA",
    ]
    info: Proto2BridgeMessageSet
    name: str
    score: float

@typing.type_check_only
class NlpSaftHyperlink(typing_extensions.TypedDict, total=False):
    anchorText: str
    byteEnd: int
    byteStart: int
    phrase: NlpSaftPhrase
    url: str

@typing.type_check_only
class NlpSaftIdentifier(typing_extensions.TypedDict, total=False):
    domain: typing_extensions.Literal[
        "WIKIPEDIA_ARTICLE_NAME",
        "WEBREFERENCES_ID",
        "FREEBASE_MID",
        "WIKIPEDIA_ARTICLE_ID",
        "CANONICAL_URL",
        "FREEBASE_TOPIC",
        "FREEBASE_MID_CHAIN",
        "FREEBASE_ID",
        "OYSTER_FEATURE_ID",
        "WORDNET_SENSE_KEY",
        "EXACT_STRING_MATCH",
        "GOOGLE_PLAY_ID",
        "GOOGLE_PLAY_DEVELOPER",
        "GOOGLE_PLAY_TITLE",
        "OXFORD_ID",
        "NOUN_COMPOUND",
    ]
    id: str

@typing.type_check_only
class NlpSaftLabeledSpan(typing_extensions.TypedDict, total=False):
    byteEnd: int
    byteStart: int
    label: str
    labelScores: dict[str, typing.Any]
    score: float
    tokenEnd: int
    tokenStart: int

@typing.type_check_only
class NlpSaftLabeledSpans(typing_extensions.TypedDict, total=False):
    labeledSpan: _list[NlpSaftLabeledSpan]

@typing.type_check_only
class NlpSaftMeasure(typing_extensions.TypedDict, total=False):
    canonical: float
    granularity: float
    info: Proto2BridgeMessageSet
    phrase: NlpSaftPhrase
    type: typing_extensions.Literal[
        "NUMBER",
        "PERCENT",
        "ORDINAL",
        "DATE",
        "TIME",
        "PERIOD",
        "CURRENCY",
        "LENGTH",
        "AREA",
        "VOLUME",
        "MASS",
        "TEMPERATURE",
        "ANGLE",
        "BRIGHTNESS",
        "CHARGE",
        "DATA",
        "DATA_RATE",
        "DURATION",
        "ENERGY",
        "FREQUENCY",
        "FUEL_EFFICIENCY",
        "POWER",
        "PRESSURE",
        "SPEED",
        "VOLTAGE",
        "RESISTANCE",
        "FORCE",
    ]
    unit: str
    value: str

@typing.type_check_only
class NlpSaftMention(typing_extensions.TypedDict, total=False):
    confidence: float
    info: Proto2BridgeMessageSet
    kind: typing_extensions.Literal[
        "UNSPECIFIED_KIND", "REFERENTIAL", "ATTRIBUTIVE", "MODIFIER"
    ]
    nestingRelation: typing_extensions.Literal[
        "UNSPECIFIED_RELATION",
        "ALIAS",
        "NESTED_MODIFIER",
        "EPONYM",
        "CONJUNCTION",
        "IN_CREATIVE_WORK",
        "SPECIFIED_HEAD",
    ]
    phrase: NlpSaftPhrase
    resolution: NlpSaftMentionResolution
    role: typing_extensions.Literal["UNSPECIFIED", "CONJUNCTION_ITEM"]
    type: typing_extensions.Literal[
        "NAM", "NOM", "PRE", "PRO", "CMC", "NRP", "VRB", "IMP"
    ]

@typing.type_check_only
class NlpSaftMentionResolution(typing_extensions.TypedDict, total=False):
    profile: NlpSaftEntityProfile
    type: typing_extensions.Literal["MATCH", "BROADER_MATCH"]

@typing.type_check_only
class NlpSaftMorphology(typing_extensions.TypedDict, total=False):
    attrValue: _list[
        typing_extensions.Literal[
            "OTHER",
            "ATTR_ANIMACY",
            "UNSP_ANIMACY",
            "ANIMATE",
            "INANIMATE",
            "IRRATIONAL",
            "RATIONAL",
            "PERSONAL",
            "ATTR_ASPECT",
            "UNSP_ASPECT",
            "PERFECT",
            "IMPERFECT",
            "PROGRESSIVE",
            "ATTR_CASE",
            "UNSP_CASE",
            "NOMINATIVE",
            "ACCUSATIVE",
            "DATIVE",
            "GENITIVE",
            "PREPOSITIONAL",
            "INSTRUMENTAL",
            "VOCATIVE",
            "ADVERBIAL",
            "COMPLEMENTIVE",
            "LOCATIVE",
            "OBLIQUE",
            "PARTITIVE",
            "REFLEXIVE_CASE",
            "RELATIVE_CASE",
            "DIRECT_CASE",
            "ERGATIVE",
            "ATTR_DEFINITENESS",
            "UNSP_DEFINITENESS",
            "DEFINITE",
            "INDEFINITE",
            "ATTR_DEGREE",
            "UNSP_DEGREE",
            "COMPARATIVE",
            "SUPERLATIVE",
            "POSITIVE",
            "ABSOLUTE_DEGREE",
            "RELATIVE_DEGREE",
            "ATTR_FORM",
            "UNSP_FORM",
            "ADNOMIAL",
            "AUXILIARY",
            "COMPLEMENTIZER",
            "FINAL_ENDING",
            "GERUND",
            "IRREALIS",
            "LONG_FORM",
            "ORDER_FORM",
            "REALIS",
            "SHORT_FORM",
            "SPECIFIC_FORM",
            "ATTR_GENDER_AGR",
            "UNSP_GENDER_AGR",
            "FEMININE_AGR",
            "MASCULINE_AGR",
            "NEUTER_AGR",
            "ATTR_GENDER",
            "UNSP_GENDER",
            "FEMININE",
            "MASCULINE",
            "NEUTER",
            "PLURALE_TANTUM",
            "COMMON",
            "ATTR_MOOD",
            "UNSP_MOOD",
            "CONDITIONAL_MOOD",
            "IMPERATIVE",
            "INDICATIVE",
            "INTERROGATIVE",
            "JUSSIVE",
            "SUBJUNCTIVE",
            "SUBJUNCTIVE1",
            "SUBJUNCTIVE2",
            "OPTATIVE",
            "ATTR_NUMBER_AGR",
            "UNSP_NUMBER_AGR",
            "SINGULAR_AGR",
            "PLURAL_AGR",
            "ATTR_NUMBER",
            "UNSP_NUMBER",
            "SINGULAR",
            "PLURAL",
            "DUAL",
            "ATTR_PERSON",
            "UNSP_PERSON",
            "FIRST",
            "SECOND",
            "THIRD",
            "REFLEXIVE_PERSON",
            "ATTR_PROPER",
            "UNSP_PROPER",
            "NOT_PROPER",
            "PROPER",
            "ATTR_RECIPROCITY",
            "UNSP_RECIPROCITY",
            "NON_RECIPROCAL",
            "RECIPROCAL",
            "ATTR_TENSE",
            "UNSP_TENSE",
            "CONDITIONAL_TENSE",
            "FUTURE",
            "PAST",
            "PRESENT",
            "PLUPERFECT",
            "IMPERFECT_TENSE",
            "ATTR_VOICE",
            "UNSP_VOICE",
            "ACTIVE",
            "CAUSATIVE",
            "PASSIVE",
            "ATTR_GENDER_ANTECEDENT",
            "UNSP_GENDER_ANTECEDENT",
            "FEMININE_ANTECEDENT",
            "MASCULINE_ANTECEDENT",
            "NEUTER_ANTECEDENT",
            "ATTR_NUMBER_ANTECEDENT",
            "UNSP_NUMBER_ANTECEDENT",
            "SINGULAR_ANTECEDENT",
            "PLURAL_ANTECEDENT",
            "ATTR_HONORIFIC",
            "UNSP_HONORIFIC",
            "HONORIFIC",
            "ATTR_FORMALITY",
            "UNSP_FORMALITY",
            "FORMAL",
            "INFORMAL",
            "ATTR_INFLECTION_TYPE",
            "UNSP_INFLECTION_TYPE",
            "WEAK_INFLECTION",
            "STRONG_INFLECTION",
            "MIXED_INFLECTION",
        ]
    ]

@typing.type_check_only
class NlpSaftPhrase(typing_extensions.TypedDict, total=False):
    end: int
    facet: typing_extensions.Literal["EXPLICIT", "SUBJ", "DOBJ"]
    head: int
    start: int

@typing.type_check_only
class NlpSaftReferent(typing_extensions.TypedDict, total=False):
    distance: float
    explicitness: typing_extensions.Literal["NAMED", "DEFINITE", "INDEFINITE"]
    info: Proto2BridgeMessageSet
    phrase: NlpSaftPhrase
    prominence: float
    role: typing_extensions.Literal["CONTEXT", "NARRATOR", "ADDRESSEE", "SUBJECT"]
    token: _list[NlpSaftToken]

@typing.type_check_only
class NlpSaftRelation(typing_extensions.TypedDict, total=False):
    identifier: NlpSaftIdentifier
    info: Proto2BridgeMessageSet
    kind: typing_extensions.Literal["ENTITY", "ATTRIBUTE"]
    mention: _list[NlpSaftRelationMention]
    score: float
    source: int
    target: int
    type: str
    typeId: int

@typing.type_check_only
class NlpSaftRelationMention(typing_extensions.TypedDict, total=False):
    info: Proto2BridgeMessageSet
    phrase: NlpSaftPhrase
    source: int
    sourceInfo: _list[str]
    target: int

@typing.type_check_only
class NlpSaftSemanticNode(typing_extensions.TypedDict, total=False):
    arc: _list[NlpSaftSemanticNodeArc]
    confidence: float
    description: str
    entity: int
    implicit: bool
    info: Proto2BridgeMessageSet
    kind: typing_extensions.Literal[
        "PROPBANK",
        "MONOTONIC",
        "FRAMENET",
        "OPEN_RELATION",
        "PATTERN_CLUSTERS",
        "OED_WORD_SENSE",
        "EVENT",
        "NAME",
        "TIME_EXPRESSION",
        "MOLECULE",
        "WORDNET",
        "HYPERNYM",
        "DIALOGUE",
        "ANAPHOR",
        "SENSE_ANTECEDENT",
        "NOUN_COMPOUND",
        "ISTA",
    ]
    measure: int
    mention: int
    phrase: NlpSaftPhrase
    type: str
    value: str

@typing.type_check_only
class NlpSaftSemanticNodeArc(typing_extensions.TypedDict, total=False):
    description: str
    implicit: bool
    info: Proto2BridgeMessageSet
    semanticNode: int
    type: str

@typing.type_check_only
class NlpSaftToken(typing_extensions.TypedDict, total=False):
    breakLevel: typing_extensions.Literal[
        "NO_BREAK",
        "SPACE_BREAK",
        "LINE_BREAK",
        "SENTENCE_BREAK",
        "PARAGRAPH_BREAK",
        "SECTION_BREAK",
        "CHAPTER_BREAK",
    ]
    breakSkippedText: bool
    category: str
    end: int
    head: int
    info: Proto2BridgeMessageSet
    label: str
    lemma: str
    morph: NlpSaftMorphology
    scriptCode: str
    start: int
    tag: str
    tagConfidence: float
    textProperties: int
    word: str

@typing.type_check_only
class NlpSciencelitArticleData(typing_extensions.TypedDict, total=False):
    analyzedText: NlxDataSchemaScaleSet
    articleId: _list[NlpSciencelitArticleId]
    citation: _list[NlpSciencelitCitationData]
    earliestPubDate: str
    metadata: NlpSciencelitArticleMetadata
    nonAbstractWordCount: str
    parsedFrom: str
    pubDate: _list[NlpSciencelitPubDate]
    referencedBlock: _list[NlpSciencelitReferencedBlock]
    scholarCitation: ScienceCitation
    scholarDocument: _list[CompositeDoc]
    scholarSignal: ScienceIndexSignal
    source: str
    title: str
    wordCount: str

@typing.type_check_only
class NlpSciencelitArticleId(typing_extensions.TypedDict, total=False):
    id: str
    idType: str

@typing.type_check_only
class NlpSciencelitArticleMetadata(typing_extensions.TypedDict, total=False):
    abstract: NlpSciencelitTokenizedText
    articleId: _list[NlpSciencelitArticleId]
    author: _list[NlpSciencelitAuthor]
    dataset: _list[NlpSciencelitDataset]
    dateStr: str
    deleted: bool
    heading: _list[NlpSciencelitMeshHeading]
    issue: str
    journal: str
    language: str
    lastRevisedDateStr: str
    metadataSource: _list[
        typing_extensions.Literal["UNKNOWN", "PUBMED", "PMC", "SCHOLAR", "CORD"]
    ]
    parsedFrom: str
    pmid: str
    publicationType: _list[NlpSciencelitPublicationType]
    scamRestrictTokens: ResearchScamV3Restrict
    title: str
    url: _list[str]
    volume: str

@typing.type_check_only
class NlpSciencelitAuthor(typing_extensions.TypedDict, total=False):
    firstName: str
    lastName: str

@typing.type_check_only
class NlpSciencelitCitationData(typing_extensions.TypedDict, total=False):
    articleId: _list[NlpSciencelitArticleId]
    author: _list[NlpSciencelitAuthor]
    externalLink: str
    fullText: str
    reference: str
    scholarCitation: ScienceCitation
    title: str

@typing.type_check_only
class NlpSciencelitDataset(typing_extensions.TypedDict, total=False):
    association: typing_extensions.Literal["UNKNOWN", "DATABANK", "CITATION", "MATCH"]
    datasetMetadata: ResearchScienceSearchReconciledMetadata

@typing.type_check_only
class NlpSciencelitMeshHeading(typing_extensions.TypedDict, total=False):
    meshDescriptor: NlpSciencelitSubjectHeading
    meshQualifier: _list[NlpSciencelitSubjectHeading]

@typing.type_check_only
class NlpSciencelitPubDate(typing_extensions.TypedDict, total=False):
    dateStr: str
    pubType: str

@typing.type_check_only
class NlpSciencelitPublicationType(typing_extensions.TypedDict, total=False):
    name: str
    ui: str

@typing.type_check_only
class NlpSciencelitReferencedBlock(typing_extensions.TypedDict, total=False):
    caption: NlpSciencelitTokenizedText
    reference: str
    title: NlpSciencelitTokenizedText
    type: str

@typing.type_check_only
class NlpSciencelitRetrievalQueryEncodingDebugInfo(
    typing_extensions.TypedDict, total=False
):
    scamQueryEncoding: ResearchScamGenericFeatureVector

@typing.type_check_only
class NlpSciencelitRetrievalSearchResultDebugInfo(
    typing_extensions.TypedDict, total=False
):
    articleData: NlpSciencelitArticleData
    goldDocid: _list[str]
    goldSnippets: _list[str]
    isGold: bool
    rerankingScore: float
    reverseRerankingOrder: int
    sectionIrScore: dict[str, typing.Any]

@typing.type_check_only
class NlpSciencelitRetrievalSearchResultSetDebugInfo(
    typing_extensions.TypedDict, total=False
):
    queryEncoding: NlpSciencelitRetrievalQueryEncodingDebugInfo
    scamResponse: ResearchScamQueryResponse

@typing.type_check_only
class NlpSciencelitRetrievalSnippetDebugInfo(typing_extensions.TypedDict, total=False):
    goldHighlightSentenceIndices: _list[int]
    highlightIdxToOverlap: dict[str, typing.Any]
    highlightIdxToSentenceOverlap: dict[str, typing.Any]
    isGold: bool
    offsetWithinSection: int
    sectionIndex: int
    sectionIrScore: float
    snippetBleuScore: float

@typing.type_check_only
class NlpSciencelitSubjectHeading(typing_extensions.TypedDict, total=False):
    id: str
    majorTopic: bool
    term: str

@typing.type_check_only
class NlpSciencelitTokenizedText(typing_extensions.TypedDict, total=False):
    text: str
    token: _list[str]

@typing.type_check_only
class NlpSemanticParsingAnnotationEvalData(typing_extensions.TypedDict, total=False):
    additionalSpans: _list[NlpSemanticParsingAnnotationEvalData]
    numBytes: int
    numTokens: int
    startByte: int
    startToken: int

@typing.type_check_only
class NlpSemanticParsingAppAnnotation(typing_extensions.TypedDict, total=False):
    appInfo: _list[QualityActionsAppInfo]

@typing.type_check_only
class NlpSemanticParsingDateTimeAnnotation(typing_extensions.TypedDict, total=False):
    dateType: typing_extensions.Literal[
        "UNKNOWN_DATE_TYPE", "TODAY", "TOMORROW", "WEEKEND", "WEEK"
    ]
    endDate: _list[str]
    endTime: _list[str]
    endWeekday: typing_extensions.Literal[
        "UNKNOWN_DAY",
        "SUNDAY",
        "MONDAY",
        "TUESDAY",
        "WEDNESDAY",
        "THURSDAY",
        "FRIDAY",
        "SATURDAY",
    ]
    rawText: str
    startDate: _list[str]
    startTime: _list[str]
    startWeekday: typing_extensions.Literal[
        "UNKNOWN_DAY",
        "SUNDAY",
        "MONDAY",
        "TUESDAY",
        "WEDNESDAY",
        "THURSDAY",
        "FRIDAY",
        "SATURDAY",
    ]
    timeType: typing_extensions.Literal[
        "UNKNOWN_TIME_TYPE", "MORNING", "AFTERNOON", "EVENING", "NIGHT"
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeAbsoluteDateTime(
    typing_extensions.TypedDict, total=False
):
    allowPersonal: bool
    day: int
    deleted11: typing_extensions.Literal["NONE", "YEAR", "YEAR_MONTH", "YEAR_MONTH_DAY"]
    holiday: NlpSemanticParsingDatetimeHoliday
    hour: int
    hourState: typing_extensions.Literal["UNAMBIGUOUS", "AMBIGUOUS", "CHANGEABLE"]
    isBc: bool
    meridiem: typing_extensions.Literal["INVALID_MERIDIEM", "AM", "PM"]
    minute: int
    modifier: typing_extensions.Literal[
        "NO_MOD",
        "BEFORE",
        "AFTER",
        "ON_OR_BEFORE",
        "ON_OR_AFTER",
        "LESS_THAN",
        "MORE_THAN",
        "EQUAL_OR_LESS",
        "EQUAL_OR_MORE",
        "START",
        "MID",
        "END",
        "APPROX",
        "ADD",
        "SUBTRACT",
    ]
    month: typing_extensions.Literal[
        "NO_MONTH",
        "JANUARY",
        "FEBRUARY",
        "MARCH",
        "APRIL",
        "MAY",
        "JUNE",
        "JULY",
        "AUGUST",
        "SEPTEMBER",
        "OCTOBER",
        "NOVEMBER",
        "DECEMBER",
    ]
    nonGregorianDate: NlpSemanticParsingDatetimeNonGregorianDate
    partialSecond: float
    properties: NlpSemanticParsingDatetimeDateTimeProperty
    quarter: typing_extensions.Literal[
        "INVALID_QUARTER",
        "FIRST_QUARTER",
        "SECOND_QUARTER",
        "THIRD_QUARTER",
        "FOURTH_QUARTER",
    ]
    rangeModifier: typing_extensions.Literal[
        "RANGE_MODIFIER_NONE",
        "RANGE_MODIFIER_EARLY",
        "RANGE_MODIFIER_MIDDLE",
        "RANGE_MODIFIER_LATE",
    ]
    season: typing_extensions.Literal[
        "INVALID_SEASON",
        "SPRING",
        "SUMMER",
        "FALL",
        "WINTER",
        "EARLY_SPRING",
        "MID_SPRING",
        "LATE_SPRING",
        "EARLY_SUMMER",
        "MID_SUMMER",
        "LATE_SUMMER",
        "EARLY_FALL",
        "MID_FALL",
        "LATE_FALL",
        "EARLY_WINTER",
        "MID_WINTER",
        "LATE_WINTER",
    ]
    second: int
    timezone: str
    weekday: typing_extensions.Literal[
        "NO_DAY_OF_WEEK",
        "SUNDAY",
        "MONDAY",
        "TUESDAY",
        "WEDNESDAY",
        "THURSDAY",
        "FRIDAY",
        "SATURDAY",
        "WEEKEND",
    ]
    year: int

@typing.type_check_only
class NlpSemanticParsingDatetimeDateTime(typing_extensions.TypedDict, total=False):
    compositionElement: NlpSemanticParsingDatetimeDateTime
    deleted7: bool
    deleted8: bool
    evalData: NlpSemanticParsingAnnotationEvalData
    groundingStage: typing_extensions.Literal[
        "UNKNOWN_GROUNDING_STAGE",
        "UNGROUNDED",
        "UNGROUNDED_COMPOSITION",
        "RESOLVED",
        "PARTIALLY_GROUNDED",
        "FULLY_GROUNDED",
    ]
    point: _list[NlpSemanticParsingDatetimeAbsoluteDateTime]
    properties: NlpSemanticParsingDatetimeResolutionProperties
    range: _list[NlpSemanticParsingDatetimeRange]
    recurrent: NlpSemanticParsingDatetimeRecurrent
    relative: NlpSemanticParsingDatetimeRelativeDateTime
    span: NlpSemanticParsingDatetimeSpan

@typing.type_check_only
class NlpSemanticParsingDatetimeDateTimeProperty(
    typing_extensions.TypedDict, total=False
):
    dateFormat: typing_extensions.Literal[
        "DEFAULT_DATE_FORMAT", "NUM_MONTH_DAY", "NUM_DAY_MONTH"
    ]
    expandYearToCurrent: bool
    hourStatus: typing_extensions.Literal[
        "HOUR_NONE",
        "HOUR_UNAMBIGUOUS",
        "HOUR_AMBIGUOUS_ORIGINAL",
        "HOUR_AMBIGUOUS_INFERRED",
    ]
    inferredDateValue: typing_extensions.Literal[
        "NONE", "YEAR", "YEAR_MONTH", "YEAR_MONTH_DAY"
    ]
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    personalReferenceMetadata: CopleyPersonalReferenceMetadata
    relationToReference: typing_extensions.Literal[
        "UNDEFINED", "CLOSEST_FUTURE", "CLOSEST_PAST", "OTHER_FUTURE", "OTHER_PAST"
    ]
    relative: NlpSemanticParsingDatetimeRelativeDateTime
    sourceCalendar: typing_extensions.Literal[
        "GREGORIAN",
        "BUDDHIST",
        "CHINESE",
        "COPTIC",
        "ETHIOPIC",
        "HEBREW",
        "INDIAN_NATIONAL",
        "ISLAMIC",
        "JAPANESE",
        "PERSIAN",
        "ISLAMIC_UMALQURA",
    ]
    sourceTypeList: CopleySourceTypeList
    timeFormat: _list[
        typing_extensions.Literal[
            "DEFAULT", "SEPARATED_HMS", "AM_PM_TOKEN", "WITH_TIMEWORD"
        ]
    ]
    timezoneIsExplicit: bool

@typing.type_check_only
class NlpSemanticParsingDatetimeDuration(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    modifier: typing_extensions.Literal[
        "NO_MOD",
        "BEFORE",
        "AFTER",
        "ON_OR_BEFORE",
        "ON_OR_AFTER",
        "LESS_THAN",
        "MORE_THAN",
        "EQUAL_OR_LESS",
        "EQUAL_OR_MORE",
        "START",
        "MID",
        "END",
        "APPROX",
        "ADD",
        "SUBTRACT",
    ]
    quantity: NlpSemanticParsingDatetimeQuantity
    span: NlpSemanticParsingDatetimeSpan

@typing.type_check_only
class NlpSemanticParsingDatetimeEvent(typing_extensions.TypedDict, total=False):
    holiday: typing_extensions.Literal[
        "UNKNOWN_HOLIDAY",
        "AIDS_DAY",
        "AIR_FORCES_DAY",
        "ALL_SAINTS_DAY",
        "ALL_SOULDS_DAY",
        "ANZAC_DAY",
        "APARECIDA_DAY",
        "APPLE_SAVIOUR_DAY",
        "ARBOR_DAY",
        "ARMED_FORCES_DAY",
        "ARMISTICE_DAY",
        "ASCENSION_DAY",
        "ASH_WEDNESDAY",
        "ASSUMPTION_OF_MARY",
        "ATATURK_DAY",
        "BERCHTOLDS_DAY",
        "BLACK_DAY",
        "BLACK_FRIDAY",
        "BRAZIL_PROCLAMATION_DAY",
        "CABOTAGE_DAY",
        "CAMBODIAN_CORONATION_DAY",
        "CANDLEMAS",
        "CARINTHIAN_PLEBISCITE_DAY",
        "CHAKRI_DAY",
        "CHILDRENS_DAY",
        "CHINA_COMMUNIST_PARTY_DAY",
        "CHINA_GRAVE_SWEEPING_FESTIVAL",
        "CHINA_HUMILIATION_DAY",
        "LUNAR_NEW_YEAR",
        "CHRISTMAS",
        "CHRISTMAS_EVE",
        "CHULA_MEMORIAL_DAY",
        "CIVIL_SERVANT_DAY",
        "COLUMBUS_DAY",
        "COMING_OF_AGE_DAY",
        "CONFUCIUS_DAY",
        "CONSTITUTION_MEMORIAL_DAY",
        "CONSUMERS_DAY",
        "COPTIC_CHRISTMAS",
        "CORPUS_CRISTI",
        "CULTURE_DAY",
        "CYBER_MONDAY",
        "CZECH_FREEDOM_DEMOCRACY_DAY",
        "DOCTORS_DAY",
        "EARTH_DAY",
        "EASTER",
        "EASTERN_ANNUNCIATION_DAY",
        "EASTER_MONDAY",
        "ELECTION_DAY",
        "ELECTION_DAY_RUNOFF",
        "EPIPHANY",
        "FATHERLAND_DEFENDER_DAY",
        "FATHERS_DAY",
        "FIRST_ADVENT_SUNDAY",
        "FLAG_DAY",
        "FLEMISH_COMMUNITY_DAY",
        "FOOLS_DAY",
        "FOURTH_ADVENT_SUNDAY",
        "FREEDOM_DAY",
        "FRENCH_COMMUNITY_DAY",
        "GERMAN_COMMUNITY_DAY",
        "GOOD_FRIDAY",
        "GRAND_FATHERS_DAY",
        "GRAND_MOTHERS_DAY",
        "GRAND_PARENTS_DAY",
        "GREAT_PRAYER_DAY",
        "GREENERY_DAY",
        "GROUNDHOG_DAY",
        "HALLOWEEN",
        "HEALTH_DAY",
        "HIDIRELLEZ",
        "HOLY_SATURDAY",
        "HONEY_SAVIOUR_DAY",
        "HONG_KONG_HANDOVER_DAY",
        "HUMAN_RIGHTS_DAY",
        "IMMACULATE_CONCEPTION_DAY",
        "INDEPENDENCE_DAY",
        "INDEPENDENCE_MOVEMENT_DAY",
        "INTERCESSION_DAY",
        "INTERNATIONAL_WORKERS_DAY",
        "INTERNATIONA_WOMEN_DAY",
        "JAPANESE_EMPERORS_BIRTHDAY",
        "JESUS_BAPTISM",
        "JOHN_HUS_DAY",
        "JOURNALIST_DAY",
        "KINGS_DAY",
        "KING_OF_CAMBODIAS_BIRTHDAY",
        "KING_OF_CAMBODIA_FATHERS_BIRTHDAY",
        "KING_OF_CAMBODIA_MOTHERS_BIRTHDAY",
        "KING_RAMA_IX_DEATH_ANNIVERSARY",
        "KING_RAMA_X_BIRTHDAY",
        "KNOWLEDGE_DAY",
        "KOREAN_ALPHABET_DAY",
        "KOREAN_MEMORIAL_DAY",
        "KUPALA_NIGHT",
        "KVEN_NATIONAL_DAY",
        "LABOUR_DAY",
        "LABOUR_THANKSGIVING_DAY",
        "LIBERATION_DAY",
        "LITTLE_CHRISTMAS_EVE",
        "MACAU_DAY",
        "MARDI_GRAS",
        "MARTIAL_DAY",
        "MARTIN_LUTHER_KING_DAY",
        "MAUNDY_THURSDAY",
        "MAY_DAY",
        "MEDICINE_DAY",
        "MELBOURNE_CUP",
        "MEMORIAL_DAY",
        "MIDSUMMER_DAY",
        "MIDSUMMER_EVE",
        "MOTHERING_SUNDAY",
        "MOTHERS_DAY",
        "NATIONAL_DAY",
        "NATIONAL_FOUNDATION_DAY",
        "NEW_YEAR",
        "NEW_YEARS_EVE",
        "NURSE_DAY",
        "OBON_FESTIVAL",
        "OCEAN_DAY",
        "OCTOBER_REVOLUTION_DAY",
        "ORTHODOX_CHRISTMAS",
        "ORTHODOX_EASTER",
        "ORTHODOX_NEW_YEAR",
        "ORTHODOX_NEW_YEARS_EVE",
        "PALM_SUNDAY",
        "PARATROOPERS_DAY",
        "PARENTS_DAY",
        "PARIS_PEACE_AGREEMENTS_DAY",
        "PARLIAMNET_DAY",
        "PEACE_DAY",
        "PENTECOST",
        "PENTECOST_EVE",
        "PEPERO_DAY",
        "PERSIAN_NEW_YEAR",
        "PLOUGHING_CEREMONY_DAY",
        "POLICE_DAY",
        "POLISH_MAY_HOLIDAYS",
        "PORTUGAL_PROCLAMATION_DAY",
        "PRESIDENT_DAY",
        "REFORMATION_DAY",
        "REMEMBRANCE_AND_SORROW_DAY",
        "REMEMBRANCE_DAY",
        "REPENTANCE_AND_PRAYER_DAY",
        "REPUBLIC_DAY",
        "RESPECT_FOR_THE_ELDERLY_DAY",
        "ROSE_DAY",
        "RUSSIAN_GUARD_DAY",
        "SAINT_CYRIL_METHODIUS_DAY",
        "SAINT_FLORIAN_DAY",
        "SAINT_FRANCIS_DAY",
        "SAINT_JOHN_DAY",
        "SAINT_JOHN_EVE",
        "SAINT_JOSEPH",
        "SAINT_LEOPOLD_DAY",
        "SAINT_LUCY_DAY",
        "SAINT_MARTIN_DAY",
        "SAINT_NICHOLAS_DAY",
        "SAINT_OLAF_DAY",
        "SAINT_RUPERT_DAY",
        "SAINT_STEPHEN_DAY",
        "SAMI_NATIONAL_DAY",
        "SCOUTING_DAY",
        "SECOND_ADVENT_SUNDAY",
        "SECOND_CHRISTMAS_DAY",
        "SHOWA_DAY",
        "SINAI_DAY",
        "SINGLES_DAY",
        "SONGKRAN_DAY",
        "SPORTS_DAY",
        "SUNFLOWER_MOVEMENT_DAY",
        "TATIANA_DAY",
        "TEACHERS_DAY",
        "THAI_CORONATION_DAY",
        "THAI_PONGAL_DAY",
        "THANKSGIVING_DAY",
        "THIRD_ADVENT_SUNDAY",
        "TIRADENTES_DAY",
        "UNITY_DAY",
        "VALENTINE_DAY",
        "VETERANS_DAY",
        "VICTORY_DAY",
        "VIETNAMESE_REUNIFICATION_DAY",
        "VIETNAM_COMMUNIST_PARTY_DAY",
        "VIETNAM_REWVOLUATIONARY_PRESS_DAY",
        "WALPURGIS_NIGHT",
        "WENCESLAUS_DAY",
        "WESTERN_ANNUNCIATION_DAY",
        "WHITE_DAY",
        "WHIT_MONDAY",
        "WOMEN_RIGHTS_DAY",
        "YOUTH_DAY",
    ]
    moonEvent: NlpSemanticParsingDatetimeMoonEventInfo
    sunEvent: typing_extensions.Literal[
        "INVALID_SUN_EVENT", "SUNRISE", "SUNSET", "DAWN", "DUSK"
    ]
    type: typing_extensions.Literal[
        "INVALID_EVENT", "ASTRONOMICAL_EVENT", "HOLIDAY_EVENT"
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeFetchedRelativeDateTime(
    typing_extensions.TypedDict, total=False
):
    baseType: typing_extensions.Literal[
        "UNKNOWN", "CURRENT_DATETIME", "EXPLICIT_PRONOUN"
    ]
    count: int
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    ordinal: _list[int]
    range: NlpSemanticParsingDatetimeRange
    rangeModifier: typing_extensions.Literal[
        "RANGE_MODIFIER_NONE",
        "RANGE_MODIFIER_EARLY",
        "RANGE_MODIFIER_MIDDLE",
        "RANGE_MODIFIER_LATE",
    ]
    relativeRange: NlpSemanticParsingDatetimeResolutionProperties
    target: NlpSemanticParsingDatetimeTargetToFetch

@typing.type_check_only
class NlpSemanticParsingDatetimeHoliday(typing_extensions.TypedDict, total=False):
    nonFixed: typing_extensions.Literal[
        "UNKNOWN_NON_FIXED_HOLIDAY",
        "EASTER",
        "CHINESE_NEW_YEAR",
        "ORTHODOX_EASTER",
        "MARDI_GRAS",
        "ASH_WEDNESDAY",
        "GOOD_FRIDAY",
        "EASTER_MONDAY",
        "PENTECOST",
        "CORPUS_CRISTI",
        "WHIT_MONDAY",
        "PALM_SUNDAY",
        "MAUNDY_THURSDAY",
        "ASCENSION_DAY",
        "GREAT_PRAYER_DAY",
        "HOLY_SATURDAY",
        "PENTECOST_EVE",
        "MOTHERING_SUNDAY",
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeMoonEventInfo(typing_extensions.TypedDict, total=False):
    phase: typing_extensions.Literal[
        "UNKNOWN_MOON_PHASE",
        "NEW_MOON",
        "WAXING_CRESCENT",
        "FIRST_QUARTER_PHASE",
        "WAXING_GIBBOUS",
        "FULL_MOON",
        "WANING_GIBBOUS",
        "LAST_QUARTER_PHASE",
        "WANING_CRESCENT",
    ]
    type: typing_extensions.Literal["INVALID_MOON_EVENT", "MOONRISE", "MOONSET"]

@typing.type_check_only
class NlpSemanticParsingDatetimeNonGregorianDate(
    typing_extensions.TypedDict, total=False
):
    chineseMonth: typing_extensions.Literal[
        "UNKNOWN_CHINESE_MONTH",
        "FIRST_MONTH",
        "SECOND_MONTH",
        "THIRD_MONTH",
        "FOURTH_MONTH",
        "FIFTH_MONTH",
        "SIXTH_MONTH",
        "SEVENTH_MONTH",
        "EIGHTH_MONTH",
        "NINTH_MONTH",
        "TENTH_MONTH",
        "ELEVENTH_MONTH",
        "TWELFTH_MONTH",
    ]
    day: int
    hebrewMonth: typing_extensions.Literal[
        "UNKNOWN_HEBREW_MONTH",
        "TISHRI",
        "HESHVAN",
        "KISLEV",
        "TEVET",
        "SHEVAT",
        "ADAR_1",
        "ADAR",
        "NISAN",
        "IYAR",
        "SIVAN",
        "TAMUZ",
        "AV",
        "ELUL",
    ]
    islamicMonth: typing_extensions.Literal[
        "UNKNOWN_ISLAMIC_MONTH",
        "MUHARRAM",
        "SAFAR",
        "RABI_AL_AWWAL",
        "RABI_AL_THANI",
        "JUMADA_AL_AWWAL",
        "JUMADA_AL_THANI",
        "RAJAB",
        "SHABAN",
        "RAMADAN",
        "SHAWWAL",
        "ZUL_QAADAH",
        "ZUL_HIJJAH",
    ]
    year: int

@typing.type_check_only
class NlpSemanticParsingDatetimeQuantity(typing_extensions.TypedDict, total=False):
    modifier: typing_extensions.Literal[
        "NO_MOD",
        "BEFORE",
        "AFTER",
        "ON_OR_BEFORE",
        "ON_OR_AFTER",
        "LESS_THAN",
        "MORE_THAN",
        "EQUAL_OR_LESS",
        "EQUAL_OR_MORE",
        "START",
        "MID",
        "END",
        "APPROX",
        "ADD",
        "SUBTRACT",
    ]
    number: float
    numberSpan: NlpSemanticParsingAnnotationEvalData
    symbolicQuantity: _list[NlpSemanticParsingDatetimeQuantity]
    unit: typing_extensions.Literal[
        "NO_UNIT",
        "NANOSECOND",
        "MICROSECOND",
        "MILLISECOND",
        "SECOND",
        "MINUTE",
        "HOUR",
        "DAY",
        "WEEK",
        "TEN_DAY",
        "HALF_MONTH",
        "MONTH",
        "QUARTER",
        "HALF_YEAR",
        "YEAR",
        "DECADE",
        "CENTURY",
        "MILLENNIUM",
        "NIGHT",
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeRange(typing_extensions.TypedDict, total=False):
    begin: NlpSemanticParsingDatetimeAbsoluteDateTime
    beginRelative: NlpSemanticParsingDatetimeRelativeDateTime
    duration: NlpSemanticParsingDatetimeQuantity
    end: NlpSemanticParsingDatetimeAbsoluteDateTime
    endRelative: NlpSemanticParsingDatetimeRelativeDateTime
    exclusive: bool
    finish: NlpSemanticParsingDatetimeDateTime
    fuzzyRange: typing_extensions.Literal[
        "NO_FUZZY_RANGE",
        "FUZZY_RANGE_MORNING",
        "FUZZY_RANGE_AFTERNOON",
        "FUZZY_RANGE_EVENING",
        "FUZZY_RANGE_NIGHT",
        "FUZZY_RANGE_EVE",
        "FUZZY_RANGE_DAYTIME",
        "FUZZY_RANGE_DAWN",
        "FUZZY_RANGE_DUSK",
        "FUZZY_RANGE_NIGHTTIME",
        "FUZZY_RANGE_EARLY_MORNING",
        "FUZZY_RANGE_MID_MORNING",
        "FUZZY_RANGE_LATE_MORNING",
        "FUZZY_RANGE_EARLY_AFTERNOON",
        "FUZZY_RANGE_MID_AFTERNOON",
        "FUZZY_RANGE_LATE_AFTERNOON",
        "FUZZY_RANGE_EARLY_EVENING",
        "FUZZY_RANGE_MID_EVENING",
        "FUZZY_RANGE_LATE_EVENING",
        "FUZZY_RANGE_LATE_NIGHT",
        "DELETED_11",
    ]
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    properties: NlpSemanticParsingDatetimeResolutionProperties
    rangeModifier: typing_extensions.Literal[
        "RANGE_MODIFIER_NONE",
        "RANGE_MODIFIER_EARLY",
        "RANGE_MODIFIER_MIDDLE",
        "RANGE_MODIFIER_LATE",
    ]
    start: NlpSemanticParsingDatetimeDateTime
    symbolicValue: typing_extensions.Literal[
        "NO_SYMBOLIC_DATETIME",
        "SYMBOLIC_MORNING",
        "SYMBOLIC_AFTERNOON",
        "SYMBOLIC_EVENING",
        "SYMBOLIC_NIGHT",
        "DELETED_5",
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeRecurrent(typing_extensions.TypedDict, total=False):
    countRestriction: int
    exception: _list[NlpSemanticParsingDatetimeDateTime]
    frequency: int
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    period: int
    rangeRestriction: NlpSemanticParsingDatetimeRange
    relativeRangeRestriction: NlpSemanticParsingDatetimeRelativeDateTime
    restriction: NlpSemanticParsingDatetimeDateTime
    start: _list[NlpSemanticParsingDatetimeDateTime]
    startPoint: _list[NlpSemanticParsingDatetimeAbsoluteDateTime]
    startRange: _list[NlpSemanticParsingDatetimeRange]
    startRelative: _list[NlpSemanticParsingDatetimeRelativeDateTime]
    target: NlpSemanticParsingDatetimeTargetToFetch
    timeInterval: NlpSemanticParsingDatetimeQuantity
    unit: typing_extensions.Literal[
        "NO_UNIT",
        "NANOSECOND",
        "MICROSECOND",
        "MILLISECOND",
        "SECOND",
        "MINUTE",
        "HOUR",
        "DAY",
        "WEEK",
        "TEN_DAY",
        "HALF_MONTH",
        "MONTH",
        "QUARTER",
        "HALF_YEAR",
        "YEAR",
        "DECADE",
        "CENTURY",
        "MILLENNIUM",
        "NIGHT",
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeRelativeDateTime(
    typing_extensions.TypedDict, total=False
):
    fetched: NlpSemanticParsingDatetimeFetchedRelativeDateTime
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    modifier: typing_extensions.Literal[
        "NO_MOD",
        "BEFORE",
        "AFTER",
        "ON_OR_BEFORE",
        "ON_OR_AFTER",
        "LESS_THAN",
        "MORE_THAN",
        "EQUAL_OR_LESS",
        "EQUAL_OR_MORE",
        "START",
        "MID",
        "END",
        "APPROX",
        "ADD",
        "SUBTRACT",
    ]
    shifted: NlpSemanticParsingDatetimeShiftedRelativeDateTime

@typing.type_check_only
class NlpSemanticParsingDatetimeResolutionProperties(
    typing_extensions.TypedDict, total=False
):
    meridiem: typing_extensions.Literal["INVALID_MERIDIEM", "AM", "PM"]
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    relative: NlpSemanticParsingDatetimeRelativeDateTime

@typing.type_check_only
class NlpSemanticParsingDatetimeShiftedRelativeDateTime(
    typing_extensions.TypedDict, total=False
):
    base: NlpSemanticParsingDatetimeAbsoluteDateTime
    baseType: typing_extensions.Literal[
        "UNKNOWN", "CURRENT_DATETIME", "EXPLICIT_PRONOUN"
    ]
    metadata: typing_extensions.Literal[
        "NO_METADATA",
        "HOLIDAY",
        "ORDINAL",
        "WEEKEND",
        "DECADE",
        "MONTH",
        "DAY_OF_WEEK",
        "YEAR_NUMBER",
        "MONTH_YEAR",
        "PERSONAL",
        "SEASON",
        "WEE_HOURS_INFERRED",
        "PROACTIVE_DEFAULT_TIME",
        "PROACTIVE_DEFAULT_DATE",
        "PROACTIVE_DEFAULT_DATETIME",
        "HOUR_NUMBER",
        "ASTRONOMICAL_EVENT",
        "RECURRENT_UNKNOWN_FREQUENCY",
    ]
    relativeBase: NlpSemanticParsingDatetimeResolutionProperties
    shiftAmount: NlpSemanticParsingDatetimeQuantity
    shiftPast: bool

@typing.type_check_only
class NlpSemanticParsingDatetimeSpan(typing_extensions.TypedDict, total=False):
    numBytes: int
    startByte: int
    text: str

@typing.type_check_only
class NlpSemanticParsingDatetimeTargetToFetch(typing_extensions.TypedDict, total=False):
    event: NlpSemanticParsingDatetimeEvent
    fuzzyRange: typing_extensions.Literal[
        "NO_FUZZY_RANGE",
        "FUZZY_RANGE_MORNING",
        "FUZZY_RANGE_AFTERNOON",
        "FUZZY_RANGE_EVENING",
        "FUZZY_RANGE_NIGHT",
        "FUZZY_RANGE_EVE",
        "FUZZY_RANGE_DAYTIME",
        "FUZZY_RANGE_DAWN",
        "FUZZY_RANGE_DUSK",
        "FUZZY_RANGE_NIGHTTIME",
        "FUZZY_RANGE_EARLY_MORNING",
        "FUZZY_RANGE_MID_MORNING",
        "FUZZY_RANGE_LATE_MORNING",
        "FUZZY_RANGE_EARLY_AFTERNOON",
        "FUZZY_RANGE_MID_AFTERNOON",
        "FUZZY_RANGE_LATE_AFTERNOON",
        "FUZZY_RANGE_EARLY_EVENING",
        "FUZZY_RANGE_MID_EVENING",
        "FUZZY_RANGE_LATE_EVENING",
        "FUZZY_RANGE_LATE_NIGHT",
        "DELETED_11",
    ]
    month: typing_extensions.Literal[
        "NO_MONTH",
        "JANUARY",
        "FEBRUARY",
        "MARCH",
        "APRIL",
        "MAY",
        "JUNE",
        "JULY",
        "AUGUST",
        "SEPTEMBER",
        "OCTOBER",
        "NOVEMBER",
        "DECEMBER",
    ]
    quarter: typing_extensions.Literal[
        "INVALID_QUARTER",
        "FIRST_QUARTER",
        "SECOND_QUARTER",
        "THIRD_QUARTER",
        "FOURTH_QUARTER",
    ]
    reference: typing_extensions.Literal[
        "INVALID",
        "CURRENT_DATETIME",
        "CURRENT_TIME",
        "CURRENT_DATE",
        "RECENT",
        "LATEST",
        "NEXT_DAY",
        "PREVIOUS_DAY",
        "DAY_AFTER_NEXT",
        "DAY_BEFORE_PREVIOUS",
    ]
    season: typing_extensions.Literal[
        "INVALID_SEASON",
        "SPRING",
        "SUMMER",
        "FALL",
        "WINTER",
        "EARLY_SPRING",
        "MID_SPRING",
        "LATE_SPRING",
        "EARLY_SUMMER",
        "MID_SUMMER",
        "LATE_SUMMER",
        "EARLY_FALL",
        "MID_FALL",
        "LATE_FALL",
        "EARLY_WINTER",
        "MID_WINTER",
        "LATE_WINTER",
    ]
    unit: typing_extensions.Literal[
        "NO_UNIT",
        "NANOSECOND",
        "MICROSECOND",
        "MILLISECOND",
        "SECOND",
        "MINUTE",
        "HOUR",
        "DAY",
        "WEEK",
        "TEN_DAY",
        "HALF_MONTH",
        "MONTH",
        "QUARTER",
        "HALF_YEAR",
        "YEAR",
        "DECADE",
        "CENTURY",
        "MILLENNIUM",
        "NIGHT",
    ]
    weekday: _list[
        typing_extensions.Literal[
            "NO_DAY_OF_WEEK",
            "SUNDAY",
            "MONDAY",
            "TUESDAY",
            "WEDNESDAY",
            "THURSDAY",
            "FRIDAY",
            "SATURDAY",
            "WEEKEND",
        ]
    ]

@typing.type_check_only
class NlpSemanticParsingDatetimeTimeZone(typing_extensions.TypedDict, total=False):
    timezone: str

@typing.type_check_only
class NlpSemanticParsingEntitySourceData(typing_extensions.TypedDict, total=False):
    entitySources: _list[
        typing_extensions.Literal[
            "UNKNOWN_ENTITY_SOURCE",
            "QREF_PERSONAL_WALDREF",
            "QREF_PERSONAL_TOPIC_SERVER",
            "MYENTITIES_MODEL_T",
        ]
    ]

@typing.type_check_only
class NlpSemanticParsingExpressionStatus(typing_extensions.TypedDict, total=False):
    status: typing_extensions.Literal[
        "EXPRESSION_STATUS_UNSPECIFIED", "PARTIAL", "COMPLETE", "LIKELY_COMPLETE"
    ]
    textCompletenessProbability: float

@typing.type_check_only
class NlpSemanticParsingLocalAmenities(typing_extensions.TypedDict, total=False):
    type: _list[
        typing_extensions.Literal[
            "UNKNOWN_TYPE",
            "AIR_CONDITIONED",
            "BAR",
            "BEACH",
            "BREAKFAST",
            "FREE_BREAKFAST",
            "FREE_PARKING",
            "FREE_WIFI",
            "GYM",
            "HEATED_POOL",
            "HOT_TUB",
            "IN_ROOM_HOT_TUB",
            "INDOOR_POOL",
            "KID_FRIENDLY",
            "NON_SMOKING",
            "PET_FRIENDLY",
            "POOL",
            "RESTAURANT",
            "SMOKING",
            "TRUCK_PARKING",
            "WIFI",
            "DEAL",
            "LAST_MINUTE",
            "ALL_INCLUSIVE",
            "PARKING",
            "SPA",
            "FREE_PET_FRIENDLY",
            "WIFI_IN_ROOM",
            "ALL_INCLUSIVE_ONLY",
            "ROOM_SERVICE",
            "OUTDOOR_POOL",
            "HAS_24_HOUR_FRONT_DESK",
            "FREE_GYM",
            "MASSAGE",
            "SAUNA",
            "KIDS_ACTIVITIES",
            "KIDS_CLUB",
            "SUITE",
            "BALCONY",
            "BATHTUB",
            "HOUSEKEEPING",
            "DAILY_HOUSEKEEPING",
            "DOG_FRIENDLY",
            "THERMAL_POOL",
            "TREADMILL",
            "PRIVATE_BEACH",
            "VIEW_OF_CITY",
            "VIEW_OF_GARDEN",
            "VIEW_OF_LAKE",
            "VIEW_OF_LANDMARK",
            "VIEW_OF_OCEAN",
            "VIEW_OF_POOL",
            "VIEW_OF_VALLEY",
            "CASINO",
            "KITCHEN",
            "AVAILABLE_FOR_ESSENTIAL_WORKERS",
            "FREE_CANCELLATION",
        ]
    ]

@typing.type_check_only
class NlpSemanticParsingLocalBasicLocation(typing_extensions.TypedDict, total=False):
    element: _list[NlpSemanticParsingLocalLocationElement]

@typing.type_check_only
class NlpSemanticParsingLocalBusinessType(typing_extensions.TypedDict, total=False):
    airline: bool
    airport: bool
    bank: bool
    bikeSharingStation: bool
    busStop: bool
    clothingStore: bool
    cuisineGcid: _list[str]
    departmentStore: bool
    drugDropOff: bool
    electricVehicleChargingStation: bool
    electronicStore: bool
    emergency: str
    foodPantry: bool
    gasStation: bool
    groceryStore: bool
    hairdresser: bool
    hardwareStore: bool
    hospital: bool
    hotel: bool
    parking: bool
    petStore: bool
    pharmacy: bool
    qrefTransitStation: bool
    restaurant: bool
    retail: bool
    school: bool
    shoppingCenter: bool
    soupKitchen: bool
    sportStore: bool
    subwayStation: bool
    telecom: bool
    toyStore: bool
    trainStation: bool
    transitLine: bool
    transitOperator: bool
    transitStation: bool
    university: bool
    vehicleType: _list[
        typing_extensions.Literal[
            "VEHICLE_TYPE_ANY",
            "VEHICLE_TYPE_RAIL",
            "VEHICLE_TYPE_METRO_RAIL",
            "VEHICLE_TYPE_SUBWAY",
            "VEHICLE_TYPE_TRAM",
            "VEHICLE_TYPE_MONORAIL",
            "VEHICLE_TYPE_HEAVY_RAIL",
            "VEHICLE_TYPE_COMMUTER_TRAIN",
            "VEHICLE_TYPE_HIGH_SPEED_TRAIN",
            "VEHICLE_TYPE_LONG_DISTANCE_TRAIN",
            "VEHICLE_TYPE_BUS",
            "VEHICLE_TYPE_INTERCITY_BUS",
            "VEHICLE_TYPE_TROLLEYBUS",
            "VEHICLE_TYPE_SHARE_TAXI",
            "VEHICLE_TYPE_FERRY",
            "VEHICLE_TYPE_CABLE_CAR",
            "VEHICLE_TYPE_GONDOLA_LIFT",
            "VEHICLE_TYPE_FUNICULAR",
            "VEHICLE_TYPE_SPECIAL",
            "VEHICLE_TYPE_HORSE_CARRIAGE",
            "VEHICLE_TYPE_AIRPLANE",
        ]
    ]
    venue: bool

@typing.type_check_only
class NlpSemanticParsingLocalChainMemberConstraint(
    typing_extensions.TypedDict, total=False
):
    chainIds: _list[str]

@typing.type_check_only
class NlpSemanticParsingLocalCompoundLocation(typing_extensions.TypedDict, total=False):
    joiner: NlpSemanticParsingLocalJoiner
    location1: NlpSemanticParsingLocalLocation
    location2: NlpSemanticParsingLocalLocation

@typing.type_check_only
class NlpSemanticParsingLocalContactLocation(typing_extensions.TypedDict, total=False):
    contact: NlpSemanticParsingModelsCommunicationRecipient
    contactType: NlpSemanticParsingModelsCommunicationPhoneType

@typing.type_check_only
class NlpSemanticParsingLocalCuisineConstraint(
    typing_extensions.TypedDict, total=False
):
    cuisineGcid: str

@typing.type_check_only
class NlpSemanticParsingLocalEvChargingStationConnectorConstraint(
    typing_extensions.TypedDict, total=False
):
    connectorType: typing_extensions.Literal[
        "OTHER",
        "J_1772",
        "MENNEKES",
        "CHADEMO",
        "CCS_COMBO_1",
        "CCS_COMBO_2",
        "TESLA_ROADSTER",
        "TESLA_S_HPWC",
        "TESLA",
        "GB_T",
        "WALL_OUTLET",
    ]

@typing.type_check_only
class NlpSemanticParsingLocalEvChargingStationPaymentConstraint(
    typing_extensions.TypedDict, total=False
):
    paymentNetworkMid: str

@typing.type_check_only
class NlpSemanticParsingLocalEvChargingStationSpeedConstraint(
    typing_extensions.TypedDict, total=False
):
    chargingSpeed: typing_extensions.Literal[
        "UNKNOWN_CHARGING_SPEED", "FAST_CHARGING_SPEED", "VERY_FAST_CHARGING_SPEED"
    ]

@typing.type_check_only
class NlpSemanticParsingLocalExtent(typing_extensions.TypedDict, total=False):
    nonSpecificValue: bool
    units: typing_extensions.Literal[
        "METER",
        "KILOMETER",
        "FOOT",
        "YARD",
        "MILE",
        "BLOCK",
        "MINUTE",
        "HOUR",
        "OTHER_UNITS",
    ]
    unitsString: str
    value: float
    valueString: str

@typing.type_check_only
class NlpSemanticParsingLocalGcidConstraint(typing_extensions.TypedDict, total=False):
    gcid: str

@typing.type_check_only
class NlpSemanticParsingLocalHealthInsuranceConstraint(
    typing_extensions.TypedDict, total=False
):
    network: typing_extensions.Literal[
        "UNKNOWN_HEALTH_INSURANCE", "ACCEPTS_MEDICARE", "ACCEPTS_MEDICAID"
    ]

@typing.type_check_only
class NlpSemanticParsingLocalHotelType(typing_extensions.TypedDict, total=False):
    allInclusiveResort: bool
    beachResort: bool
    bedAndBreakfast: bool
    boutiqueHotel: bool
    businessHotel: bool
    cabin: bool
    campsite: bool
    capsuleHotel: bool
    casinoAccommodation: bool
    castleHotel: bool
    chalet: bool
    commonLodgingHouse: bool
    condoHotel: bool
    conventionHotel: bool
    cottage: bool
    ecoHotel: bool
    extendedStayHotel: bool
    farmstay: bool
    gite: bool
    golfResort: bool
    guestRanch: bool
    guesthouse: bool
    hostel: bool
    hotel: bool
    houseboat: bool
    inn: bool
    japaneseInn: bool
    japaneseInnWithHotSpring: bool
    lodge: bool
    lodging: bool
    loveHotel: bool
    motel: bool
    mountainHut: bool
    other: bool
    pension: bool
    resort: bool
    safariLodge: bool
    seasideResort: bool
    servicedApartment: bool
    skiResort: bool
    suite: bool
    vacationApartment: bool
    vacationHouse: bool
    vacationRental: bool
    villa: bool
    wellnessAndSpaAccommodation: bool
    youthHostel: bool

@typing.type_check_only
class NlpSemanticParsingLocalHyperReliableData(
    typing_extensions.TypedDict, total=False
):
    commodityStrength: float
    gcidsynsOverride: _list[NlpSemanticParsingLocalHyperReliableDataGCIDSynsOverride]
    hyperReliable: bool
    retrievalGcids: _list[str]

@typing.type_check_only
class NlpSemanticParsingLocalHyperReliableDataGCIDSynsOverride(
    typing_extensions.TypedDict, total=False
):
    gcidScore: float
    hyperReliableGcid: str

@typing.type_check_only
class NlpSemanticParsingLocalImplicitLocalCategory(
    typing_extensions.TypedDict, total=False
):
    airport: bool
    bank: bool
    chargingStation: bool
    gasStation: bool
    gym: bool
    hairSalon: bool
    hospital: bool
    hotel: bool
    laundromat: bool
    movieTheater: bool
    postOffice: bool
    spa: bool

@typing.type_check_only
class NlpSemanticParsingLocalJoiner(typing_extensions.TypedDict, total=False):
    numBytes: int
    numBytesForConversion: int
    startByte: int
    startByteForConversion: int
    text: str
    type: typing_extensions.Literal[
        "IN",
        "NEAR",
        "NEAREST",
        "BETWEEN",
        "JUNCTION",
        "UNION",
        "OTHER_JOINER",
        "EMPTY_JOINER",
    ]

@typing.type_check_only
class NlpSemanticParsingLocalLocalResultId(typing_extensions.TypedDict, total=False):
    featureId: GeostoreFeatureIdProto
    geocodingAddress: str
    kgMid: str
    position: GeostorePointProto
    rect: GeostoreRectProto

@typing.type_check_only
class NlpSemanticParsingLocalLocation(typing_extensions.TypedDict, total=False):
    basicLocation: NlpSemanticParsingLocalBasicLocation
    compoundLocation: NlpSemanticParsingLocalCompoundLocation
    contactLocation: NlpSemanticParsingLocalContactLocation
    isMerged: bool
    locationConstraint: _list[NlpSemanticParsingLocalLocationConstraint]
    numBytes: int
    resolvedLocalResult: QualityDialogManagerLocalResult
    startByte: int
    text: str
    userSpecifiedLocation: KnowledgeVerticalsWeatherProtoUserSpecifiedLocation
    vicinityLocation: NlpSemanticParsingLocalVicinityLocation

@typing.type_check_only
class NlpSemanticParsingLocalLocationConstraint(
    typing_extensions.TypedDict, total=False
):
    amenities: NlpSemanticParsingLocalAmenities
    chainMember: NlpSemanticParsingLocalChainMemberConstraint
    cuisine: NlpSemanticParsingLocalCuisineConstraint
    evcsConnectorConstraint: NlpSemanticParsingLocalEvChargingStationConnectorConstraint
    evcsPaymentConstraint: NlpSemanticParsingLocalEvChargingStationPaymentConstraint
    evcsSpeedConstraint: NlpSemanticParsingLocalEvChargingStationSpeedConstraint
    gcidConstraint: NlpSemanticParsingLocalGcidConstraint
    healthInsurance: NlpSemanticParsingLocalHealthInsuranceConstraint
    hyperReliableData: NlpSemanticParsingLocalHyperReliableData
    menuItem: NlpSemanticParsingLocalMenuItem
    new: bool
    numBytes: int
    open24Hours: bool
    price: NlpSemanticParsingLocalPriceConstraint
    quality: NlpSemanticParsingLocalQualityConstraint
    rooms: NlpSemanticParsingLocalRoomConstraint
    scalableAttribute: NlpSemanticParsingLocalScalableAttribute
    service: NlpSemanticParsingLocalServiceConstraint
    startByte: int
    text: str
    ungroundedConstraint: bool
    unspecified: bool
    vaccineType: typing_extensions.Literal[
        "UNKNOWN_VACCINE_TYPE",
        "COVAXIN",
        "JOHNSON_AND_JOHNSON",
        "MODERNA",
        "OXFORD_ASTRAZENECA",
        "PFIZER",
        "SPUTNIK",
        "ZYCOV_D",
        "COVISHIELD",
        "CORBEVAX",
        "PFIZER_BOOSTER",
        "MODERNA_BOOSTER",
    ]
    visitHistory: NlpSemanticParsingLocalVisitHistoryConstraint

@typing.type_check_only
class NlpSemanticParsingLocalLocationElement(typing_extensions.TypedDict, total=False):
    aliasIcon: _list[PersonalizationMapsAliasIcon]
    aliasLocation: typing_extensions.Literal[
        "UNDEFINED", "HERE", "HOME", "WORK", "NICKNAME", "NEXT_DESTINATION"
    ]
    businessType: NlpSemanticParsingLocalBusinessType
    contactLocation: NlpSemanticParsingLocalContactLocation
    dialogReferents: _list[NlpSemanticParsingModelsDialogReferentsDialogReferents]
    directionalModifier: typing_extensions.Literal[
        "NORTH",
        "SOUTH",
        "EAST",
        "WEST",
        "NORTHEAST",
        "SOUTHEAST",
        "NORTHWEST",
        "SOUTHWEST",
        "DOWNTOWN",
        "INBOUND",
        "UPTOWN",
        "OUTBOUND",
        "CLOCKWISE",
        "COUNTERCLOCKWISE",
    ]
    genericLocation: bool
    hotelType: NlpSemanticParsingLocalHotelType
    hyperReliableData: NlpSemanticParsingLocalHyperReliableData
    implicitLocalCategory: NlpSemanticParsingLocalImplicitLocalCategory
    localResultId: NlpSemanticParsingLocalLocalResultId
    numBytes: int
    number: int
    personalReferenceLocation: NlpSemanticParsingPersonalReferenceAnnotation
    qrefLocation: NlpSemanticParsingQRefAnnotation
    saftLocation: NlpSemanticParsingSaftMentionAnnotation
    source: typing_extensions.Literal[
        "GRAMMAR",
        "QREF",
        "SAFT",
        "GENIE",
        "DIALOG",
        "NIMBLE",
        "ATTENTIONAL_ENTITY",
        "LES",
        "UNGROUNDED",
    ]
    startByte: int
    text: str
    transitLineNumber: str
    type: typing_extensions.Literal[
        "PLACE_NAME",
        "BUSINESS_NAME",
        "BUSINESS_CATEGORY",
        "ALIAS",
        "GEO_MODIFIER",
        "DIRECTIONAL_MODIFIER",
        "NUMBER_MODIFIER",
        "DETERMINER",
        "ZIP_CODE",
        "PERSONAL_MODIFIER",
        "TEXT",
        "PUNCTUATION",
        "STREET_NAME",
        "HIGHWAY_NAME",
        "OLC",
        "CONTACT",
        "CONTACT_AND_ALIAS",
        "PERSONAL_PLACE_NAME",
        "PERSONAL_REFERENCE",
        "UNGROUNDED_LOCATION",
        "LATITUDE_LONGITUDE",
        "DIALOG_REFERENT",
        "LOCATION_REFERENT",
    ]

@typing.type_check_only
class NlpSemanticParsingLocalMenuItem(typing_extensions.TypedDict, total=False):
    menuItemId: str

@typing.type_check_only
class NlpSemanticParsingLocalPriceConstraint(typing_extensions.TypedDict, total=False):
    cheap: bool
    currencyCode: str
    expensive: bool
    maxPrice: float
    minPrice: float
    moderatelyPriced: bool
    unspecified: bool

@typing.type_check_only
class NlpSemanticParsingLocalQualityConstraint(
    typing_extensions.TypedDict, total=False
):
    best: bool
    highlyRated: bool
    starType: typing_extensions.Literal["HOTEL_CLASS", "USER_RATING"]
    stars: NlpSemanticParsingLocalStarRatings
    unspecified: bool

@typing.type_check_only
class NlpSemanticParsingLocalRoomConstraint(typing_extensions.TypedDict, total=False):
    minNumBathrooms: float
    minNumBedrooms: int

@typing.type_check_only
class NlpSemanticParsingLocalScalableAttribute(
    typing_extensions.TypedDict, total=False
):
    attributeId: str

@typing.type_check_only
class NlpSemanticParsingLocalServiceConstraint(
    typing_extensions.TypedDict, total=False
):
    serviceType: typing_extensions.Literal[
        "SERVICE_TYPE_UNSPECIFIED",
        "ACCESS",
        "BRUNCH",
        "DELIVERY",
        "DRIVE_THROUGH",
        "KITCHEN",
        "HAPPY_HOUR",
        "PICKUP",
        "SENIOR_ONLY",
        "TAKEOUT",
    ]

@typing.type_check_only
class NlpSemanticParsingLocalStarRatings(typing_extensions.TypedDict, total=False):
    five: bool
    four: bool
    fourAndAHalf: bool
    one: bool
    oneAndAHalf: bool
    orFewer: bool
    orMore: bool
    three: bool
    threeAndAHalf: bool
    two: bool
    twoAndAHalf: bool
    unspecified: bool

@typing.type_check_only
class NlpSemanticParsingLocalVicinityLocation(typing_extensions.TypedDict, total=False):
    base: NlpSemanticParsingLocalLocation
    connector: str
    extent: NlpSemanticParsingLocalExtent

@typing.type_check_only
class NlpSemanticParsingLocalVisitHistoryConstraint(
    typing_extensions.TypedDict, total=False
):
    visitedType: typing_extensions.Literal[
        "UNKNOWN_VISITED_TYPE", "VISITED", "NOT_VISITED"
    ]

@typing.type_check_only
class NlpSemanticParsingModelsCommunicationPhoneType(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    normalizedText: str
    originalText: str
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsCommunicationRecipient(
    typing_extensions.TypedDict, total=False
):
    calendarEvent: AssistantApiCoreTypesCalendarEvent
    calendarEventWrapper: AssistantApiCoreTypesCalendarEventWrapper
    contact: NlpSemanticParsingModelsPersonPerson
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    nameAnnotationSource: typing_extensions.Literal[
        "UNKNOWN_NAME_ANNOTATOR",
        "FOCUS_NAME",
        "DEVICE_CONTACT",
        "SAFT_PERSON",
        "NAME_DETECTION_PERSON",
        "NAME_PERSON",
        "MANUAL_RULES",
        "SAFT_POS",
        "TEXT",
    ]
    numberAnnotationSource: typing_extensions.Literal[
        "UNKNOWN_NUMBER_ANNOTATOR",
        "PHONE_NUMBER_ANNOTATOR",
        "NUMBER_ANNOTATOR",
        "MANUAL",
    ]
    rawText: str
    recipientType: typing_extensions.Literal[
        "CONTACT",
        "BUSINESS",
        "EMAIL_ADDRESS",
        "PHONE_NUMBER",
        "AMBIGUOUS",
        "CALENDAR_EVENT",
        "CALENDAR_EVENT_WRAPPER",
    ]
    relationship: NlpSemanticParsingModelsCommunicationRelationshipArgument
    sensitiveNumBytes: int
    sensitiveStartByte: int

@typing.type_check_only
class NlpSemanticParsingModelsCommunicationRelationshipArgument(
    typing_extensions.TypedDict, total=False
):
    alias: str
    canonical: str
    canonicalLexicalMid: str

@typing.type_check_only
class NlpSemanticParsingModelsDevice(typing_extensions.TypedDict, total=False):
    deviceName: NlpSemanticParsingModelsDeviceName
    deviceType: typing_extensions.Literal["UNKNOWN", "PHONE", "TABLET", "WATCH"]

@typing.type_check_only
class NlpSemanticParsingModelsDeviceName(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsDialogReferentsDialogReferents(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    field: NlpSemanticParsingModelsDialogReferentsListSelection
    index: int
    next: NlpSemanticParsingModelsDialogReferentsDialogReferents
    selection: _list[NlpSemanticParsingModelsDialogReferentsListSelection]
    taskMention: _list[NlpSemanticParsingModelsDialogReferentsListSelection]

@typing.type_check_only
class NlpSemanticParsingModelsDialogReferentsListSelection(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    id: str
    looseOffsetRestriction: bool
    offset: int
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaAlbumTitle(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    favorite: bool
    first: bool
    isFromFastPath: bool
    latest: bool
    playMore: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaAudio(typing_extensions.TypedDict, total=False):
    album: NlpSemanticParsingModelsMediaAlbumTitle
    artist: NlpSemanticParsingModelsMediaMusicArtist
    book: NlpSemanticParsingModelsMediaBook
    dateTime: NlpSemanticParsingDatetimeDateTime
    episodeConstraint: _list[NlpSemanticParsingModelsMediaEpisodeConstraint]
    game: NlpSemanticParsingModelsMediaGame
    genericMusic: NlpSemanticParsingModelsMediaGenericMusic
    genre: NlpSemanticParsingModelsMediaMusicGenre
    movie: NlpSemanticParsingModelsMediaMovie
    newsTopic: NlpSemanticParsingModelsMediaNewsTopic
    noExplicitAudio: bool
    playlist: NlpSemanticParsingModelsMediaMusicPlaylist
    podcast: NlpSemanticParsingModelsMediaPodcast
    radio: NlpSemanticParsingModelsMediaRadio
    radioNetwork: NlpSemanticParsingModelsMediaRadioNetwork
    rawText: str
    scoreType: typing_extensions.Literal["UNKNOWN", "SOUNDTRACK", "THEME_SONG"]
    seasonConstraint: NlpSemanticParsingModelsMediaSeasonConstraint
    song: NlpSemanticParsingModelsMediaSong
    tag: _list[
        typing_extensions.Literal[
            "UNKNOWN_TAG",
            "SEED_RADIO",
            "VIDEO_TAG",
            "TOP_TRACKS",
            "RECORDED",
            "LIVE",
            "FOLLOWED_BY_SEED_RADIO",
        ]
    ]
    tvShow: NlpSemanticParsingModelsMediaTVShow

@typing.type_check_only
class NlpSemanticParsingModelsMediaAudiobookInfo(
    typing_extensions.TypedDict, total=False
):
    audiobookMid: str
    authors: _list[str]
    bookMid: str
    narrators: _list[str]

@typing.type_check_only
class NlpSemanticParsingModelsMediaBook(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    latest: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaCastDeviceAnnotation(
    typing_extensions.TypedDict, total=False
):
    castDeviceSource: typing_extensions.Literal[
        "COMMON_DEVICE_NAME", "PERSONAL_DEVICE", "DEVICE_TYPE"
    ]
    castDeviceType: typing_extensions.Literal[
        "UNKNOWN",
        "CHROMECAST",
        "AUDIOCAST",
        "CHIRP",
        "TV",
        "SPEAKER",
        "CAR",
        "ORIGINATING_DEVICE",
        "SMART_DISPLAY",
    ]
    creationTimestampMs: str
    deviceId: str
    deviceIdentifier: AssistantApiCoreTypesDeviceId
    name: str
    quantification: NlpSemanticParsingModelsMediaQuantification

@typing.type_check_only
class NlpSemanticParsingModelsMediaCost(typing_extensions.TypedDict, total=False):
    currencyCode: str
    price: float

@typing.type_check_only
class NlpSemanticParsingModelsMediaDeeplinkInfo(
    typing_extensions.TypedDict, total=False
):
    actionType: typing_extensions.Literal[
        "UNSPECIFIED", "PLAY", "PLAY_TRAILER", "RECORD"
    ]
    blacklistedCountry: _list[str]
    country: _list[str]
    deeplink: str
    deeplinkForExecution: str
    incompatibleWithCredentials: bool
    offer: _list[
        typing_extensions.Literal[
            "UNKNOWN_SUBSCRIPTION",
            "NO_ACCOUNT_REQUIRED",
            "FREE",
            "BASIC_SUBSCRIPTION",
            "PREMIUM_SUBSCRIPTION",
            "PAY_PER_USE",
        ]
    ]
    paidOfferDetail: _list[NlpSemanticParsingModelsMediaPaidOfferDetail]
    platform: _list[
        typing_extensions.Literal[
            "UNKNOWN_PLATFORM",
            "ANDROID_PLATFORM",
            "CAST_AUDIO",
            "CAST_VIDEO",
            "IOS_PLATFORM",
            "DESKTOP_WEB",
            "MOBILE_WEB",
            "CHROMECAST",
            "ANDROID_TV",
            "KAIOS_PLATFORM",
            "MEDIA_3P_DEVICE",
        ]
    ]
    score: float
    subscriptionPackageName: _list[str]
    tag: _list[
        typing_extensions.Literal[
            "UNKNOWN_TAG",
            "SEED_RADIO",
            "VIDEO_TAG",
            "TOP_TRACKS",
            "RECORDED",
            "LIVE",
            "FOLLOWED_BY_SEED_RADIO",
        ]
    ]
    validTimeWindow: NlpSemanticParsingModelsMediaDeeplinkInfoTimeWindow
    vuiId: str
    youtubeDeeplinkInfo: NlpSemanticParsingModelsMediaYouTubeDeeplinkInfo

@typing.type_check_only
class NlpSemanticParsingModelsMediaDeeplinkInfoTimeWindow(
    typing_extensions.TypedDict, total=False
):
    endTimestamp: str
    startTimestamp: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaDescription(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaEpisodeConstraint(
    typing_extensions.TypedDict, total=False
):
    absoluteIndex: int
    dateTime: NlpSemanticParsingDatetimeDateTime
    description: NlpSemanticParsingModelsMediaDescription
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str
    relativeIndex: int

@typing.type_check_only
class NlpSemanticParsingModelsMediaFrequency(typing_extensions.TypedDict, total=False):
    band: typing_extensions.Literal["AM", "FM", "DAB", "UNSET"]
    value: float

@typing.type_check_only
class NlpSemanticParsingModelsMediaGame(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaGenericMusic(
    typing_extensions.TypedDict, total=False
):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    newMusic: bool
    rawText: str
    type: typing_extensions.Literal[
        "UNKNOWN",
        "MUSIC",
        "LIBRARY",
        "PROVIDER_SPECIFIC",
        "PLAY_PROVIDER",
        "RESUME_PROVIDER",
        "NEW_MUSIC",
        "STREAM",
        "HISTORY",
        "POSTS",
        "LIKES",
        "TRACKS",
        "ALBUMS",
        "ARTISTS",
        "THUMBPRINT_RADIO",
        "SOMETHING_ELSE",
        "FLOW",
        "SHUFFLE_RADIO",
        "PLAYLISTS",
        "RECENTLY_PLAYED",
    ]

@typing.type_check_only
class NlpSemanticParsingModelsMediaLatLng(typing_extensions.TypedDict, total=False):
    latitude: float
    longitude: float

@typing.type_check_only
class NlpSemanticParsingModelsMediaMediaAnnotation(
    typing_extensions.TypedDict, total=False
):
    artistName: str
    audiobookInfo: NlpSemanticParsingModelsMediaAudiobookInfo
    contentType: typing_extensions.Literal[
        "MEDIA_CONTENT_TYPE_UNSPECIFIED",
        "MUSIC_TRACK",
        "MUSIC_ARTIST",
        "MUSIC_ALBUM",
        "PUBLIC_PLAYLIST",
        "PERSONAL_PLAYLIST",
        "MUSIC_PERSONALIZED_MIX",
        "MUSIC_GENRE_MIX",
        "MUSIC_SEED_RADIO",
        "MUSIC_STATION",
        "RADIO_STATION",
        "RADIO_NETWORK",
        "PODCAST_SERIES",
        "PODCAST_GENERIC",
        "PODCAST_GENRE",
        "PODCAST_TOPIC",
        "PODCAST_RESUME",
        "PODCAST_EPISODE",
        "VIDEO",
        "MUSIC_VIDEO",
        "VIDEO_RECOMMENDED_PLAYLIST",
        "MUSIC_VIDEO_PERSONALIZED_PLAYLIST",
        "TV_SHOW",
        "TV_SHOW_SEASON",
        "TV_SHOW_EPISODE",
        "MOVIE",
        "YOUTUBE_CHANNEL",
        "TV_CHANNEL",
        "SPORTS_TEAM_GAME",
        "AUDIO_BOOK",
        "AUDIO_STORY",
        "YOUTUBE_VIDEO_PLAYLIST",
        "TV_ARTIST",
        "NEWS",
        "VIDEO_GAME",
        "DIRECTOR",
        "ACTOR",
        "MOVIE_SERIES",
        "APP",
    ]
    image: _list[AssistantApiCoreTypesImage]
    name: str
    newsInfo: NlpSemanticParsingModelsMediaNewsInfo
    personalDataIngestionEngine: typing_extensions.Literal[
        "UNKNOWN_INGESTION_ENGINE", "PINTS", "PACIFIC"
    ]
    playlistVisibility: typing_extensions.Literal[
        "UNSPECIFIED", "VISIBILITY_PUBLIC", "VISIBILITY_PRIVATE", "VISIBILITY_UNLISTED"
    ]
    podcastInfo: NlpSemanticParsingModelsMediaPodcastInfo
    primaryEntityMid: str
    providerInfo: _list[NlpSemanticParsingModelsMediaMediaProviderInfo]
    purchaseInfo: NlpSemanticParsingModelsMediaPurchaseInfo
    radioInfo: NlpSemanticParsingModelsMediaRadioInfo
    rentalInfo: NlpSemanticParsingModelsMediaRentalInfo
    source: typing_extensions.Literal[
        "UNKNOWN_SOURCE",
        "USER_CREATED",
        "FAVORITES",
        "RECENT",
        "PUBLIC",
        "USER_OWNED",
        "PROVIDER_CURATED",
        "CLIENT_REPORTED",
    ]
    youtubePlaylistInfo: NlpSemanticParsingModelsMediaYouTubePlaylistInfo

@typing.type_check_only
class NlpSemanticParsingModelsMediaMediaAnnotationList(
    typing_extensions.TypedDict, total=False
):
    annotation: _list[NlpSemanticParsingModelsMediaMediaAnnotation]

@typing.type_check_only
class NlpSemanticParsingModelsMediaMediaProviderInfo(
    typing_extensions.TypedDict, total=False
):
    deeplinkInfo: _list[NlpSemanticParsingModelsMediaDeeplinkInfo]
    kgProviderKey: str
    mediaId: str
    providerMid: str
    providerName: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaMovie(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    isFromFastPath: bool
    providerMetadata: _list[NlpSemanticParsingModelsMediaProviderMetadata]
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaMusicArtist(
    typing_extensions.TypedDict, total=False
):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    favorite: bool
    isFromFastPath: bool
    playMore: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaMusicGenre(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    playMore: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaMusicPlaylist(
    typing_extensions.TypedDict, total=False
):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    longtailMood: bool
    normalizedText: str
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str
    special: typing_extensions.Literal[
        "NONE", "THUMBS_UP", "LAST_ADDED", "FREE_AND_PURCHASED"
    ]

@typing.type_check_only
class NlpSemanticParsingModelsMediaNewsInfo(typing_extensions.TypedDict, total=False):
    docid: str
    newsContentType: typing_extensions.Literal[
        "NEWS_CONTENT_TYPE_UNSPECIFIED", "AMP_ARTICLE_ONLY"
    ]
    publicationTime: AssistantApiTimestamp
    publisher: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaNewsTopic(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaPaidOfferDetail(
    typing_extensions.TypedDict, total=False
):
    cost: _list[NlpSemanticParsingModelsMediaCost]
    paidOfferType: typing_extensions.Literal["UNKNOWN_PAID_OFFER_TYPE", "RENT", "BUY"]

@typing.type_check_only
class NlpSemanticParsingModelsMediaPodcast(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    isAnnotatedFromText: bool
    normalizedText: str
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaPodcastInfo(
    typing_extensions.TypedDict, total=False
):
    clusterId: str
    episodeGuid: str
    feedUrl: str
    podcastRecsFeatures: SuperrootPodcastsRecommendationsPodcastRecsFeatures
    title: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaProviderMetadata(
    typing_extensions.TypedDict, total=False
):
    deeplinkUrl: str
    providerMid: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaPurchaseInfo(
    typing_extensions.TypedDict, total=False
):
    orderType: typing_extensions.Literal[
        "ORDER_TYPE_UNSPECIFIED", "PREORDER", "REGULAR"
    ]
    purchaseTimestampSec: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaQuantification(
    typing_extensions.TypedDict, total=False
):
    lexical: typing_extensions.Literal["NONE", "ALL"]
    number: int

@typing.type_check_only
class NlpSemanticParsingModelsMediaRadio(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    favorite: bool
    frequency: NlpSemanticParsingModelsMediaFrequency
    isAnnotatedFromText: bool
    isFromFastPath: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaRadioInfo(typing_extensions.TypedDict, total=False):
    frequency: NlpSemanticParsingModelsMediaFrequency
    location: NlpSemanticParsingModelsMediaLatLng
    popularity: float

@typing.type_check_only
class NlpSemanticParsingModelsMediaRadioNetwork(
    typing_extensions.TypedDict, total=False
):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaRentalInfo(typing_extensions.TypedDict, total=False):
    activatePeriodSec: str
    grantPeriodSec: str
    purchaseTimestampSec: str
    validUntilTimestampSec: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaSeasonConstraint(
    typing_extensions.TypedDict, total=False
):
    absoluteIndex: int
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str
    relativeIndex: int

@typing.type_check_only
class NlpSemanticParsingModelsMediaSong(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    favorite: bool
    first: bool
    isAnnotatedFromText: bool
    isFromFastPath: bool
    latest: bool
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaTVShow(typing_extensions.TypedDict, total=False):
    annotationList: NlpSemanticParsingModelsMediaMediaAnnotationList
    evalData: NlpSemanticParsingAnnotationEvalData
    isFromFastPath: bool
    providerMetadata: _list[NlpSemanticParsingModelsMediaProviderMetadata]
    qref: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaYouTubeDeeplinkInfo(
    typing_extensions.TypedDict, total=False
):
    clickTrackingId: str
    uploaderChannelId: str

@typing.type_check_only
class NlpSemanticParsingModelsMediaYouTubePlaylistInfo(
    typing_extensions.TypedDict, total=False
):
    numVidsPlayableInWoodstock: str
    videoCount: int

@typing.type_check_only
class NlpSemanticParsingModelsMoneyCurrency(typing_extensions.TypedDict, total=False):
    freebaseMid: str

@typing.type_check_only
class NlpSemanticParsingModelsMoneyMoney(typing_extensions.TypedDict, total=False):
    amount: NlpSemanticParsingNumberNumber
    currency: NlpSemanticParsingModelsMoneyCurrency

@typing.type_check_only
class NlpSemanticParsingModelsNarrativeNewsNewsProvider(
    typing_extensions.TypedDict, total=False
):
    data: QualityActionsNewsProviderAnnotationData
    evalData: NlpSemanticParsingAnnotationEvalData
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsOnDevice(typing_extensions.TypedDict, total=False):
    device: _list[NlpSemanticParsingModelsDevice]

@typing.type_check_only
class NlpSemanticParsingModelsPersonPerson(typing_extensions.TypedDict, total=False):
    alternativeNameInfo: _list[QualityQrewriteAlternativeNameInfo]
    alternativeNames: _list[str]
    annotationSource: _list[
        typing_extensions.Literal[
            "PERSONAL_CONTACT",
            "RELATIONSHIP",
            "NAMES",
            "NAME_DETECTION",
            "SAFT",
            "PERSONAL_KNOWLEDGE_GRAPH",
            "PRESENCE_PEOPLE_SEARCH",
            "LOOSE_TEXT",
        ]
    ]
    contactData: _list[QualityQrewritePersonalContactData]
    evalData: NlpSemanticParsingAnnotationEvalData
    isPersonGroupReference: bool
    isPersonalContact: bool
    name: str
    normalizedText: str
    pkgSemantics: NlpSemanticParsingQRefAnnotation
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsRecurrence(typing_extensions.TypedDict, total=False):
    dailyPattern: NlpSemanticParsingModelsRecurrenceDailyPattern
    evalData: NlpSemanticParsingAnnotationEvalData
    every: int
    frequency: typing_extensions.Literal[
        "DAILY", "WEEKLY", "MONTHLY", "YEARLY", "UNKNOWN"
    ]
    monthlyPattern: NlpSemanticParsingModelsRecurrenceMonthlyPattern
    numInstancesInFrequency: int
    recurrenceEnd: NlpSemanticParsingModelsRecurrenceRecurrenceEnd
    recurrenceStart: NlpSemanticParsingModelsRecurrenceRecurrenceStart
    time: NlpSemanticParsingDatetimeDateTime
    weeklyPattern: NlpSemanticParsingModelsRecurrenceWeeklyPattern
    yearlyPattern: NlpSemanticParsingModelsRecurrenceYearlyPattern

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceDailyPattern(
    typing_extensions.TypedDict, total=False
):
    dayPeriod: NlpSemanticParsingDateTimeAnnotation
    timeOfDay: NlpSemanticParsingDateTimeAnnotation

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceMonthlyPattern(
    typing_extensions.TypedDict, total=False
):
    lastDay: bool
    lastWeek: bool
    monthDay: _list[int]
    weekDay: typing_extensions.Literal[
        "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"
    ]
    weekDayNumber: int

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceRecurrenceEnd(
    typing_extensions.TypedDict, total=False
):
    autoRenew: bool
    autoRenewUntil: NlpSemanticParsingDateTimeAnnotation
    endDateTime: NlpSemanticParsingDateTimeAnnotation
    endMillis: str
    numOccurrences: int

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceRecurrenceStart(
    typing_extensions.TypedDict, total=False
):
    startDateTime: NlpSemanticParsingDateTimeAnnotation
    startMillis: str

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceWeeklyPattern(
    typing_extensions.TypedDict, total=False
):
    weekDay: _list[
        typing_extensions.Literal[
            "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"
        ]
    ]
    weeklyPatternEnd: typing_extensions.Literal[
        "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"
    ]
    weeklyPatternStart: typing_extensions.Literal[
        "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"
    ]

@typing.type_check_only
class NlpSemanticParsingModelsRecurrenceYearlyPattern(
    typing_extensions.TypedDict, total=False
):
    monthlyPattern: NlpSemanticParsingModelsRecurrenceMonthlyPattern
    yearMonth: _list[
        typing_extensions.Literal[
            "JANUARY",
            "FEBRUARY",
            "MARCH",
            "APRIL",
            "MAY",
            "JUNE",
            "JULY",
            "AUGUST",
            "SEPTEMBER",
            "OCTOBER",
            "NOVEMBER",
            "DECEMBER",
        ]
    ]

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantBrandPhrase(
    typing_extensions.TypedDict, total=False
):
    mid: str
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantMerchant(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    localMerchantId: str
    mcid: _list[NlpSemanticParsingModelsShoppingAssistantMerchantMerchantCenterId]
    merchantId: _list[str]
    mid: str
    name: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantMerchantMerchantCenterId(
    typing_extensions.TypedDict, total=False
):
    id: str
    isGsx: bool
    isLocal: bool
    isPla: bool

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantOffer(
    typing_extensions.TypedDict, total=False
):
    docid: str
    merchant: NlpSemanticParsingModelsShoppingAssistantMerchant
    price: NlpSemanticParsingModelsMoneyMoney
    product: NlpSemanticParsingModelsShoppingAssistantProduct
    store: NlpSemanticParsingModelsShoppingAssistantStore

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantPhrase(
    typing_extensions.TypedDict, total=False
):
    brand: NlpSemanticParsingModelsShoppingAssistantBrandPhrase
    offer: NlpSemanticParsingModelsShoppingAssistantOffer
    product: NlpSemanticParsingModelsShoppingAssistantProductPhrase
    unrecognized: NlpSemanticParsingModelsShoppingAssistantUnrecognizedPhrase

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProduct(
    typing_extensions.TypedDict, total=False
):
    catalogId: str
    maxPrice: NlpSemanticParsingModelsMoneyMoney
    mediaProduct: NlpSemanticParsingModelsShoppingAssistantProductMediaProduct
    mid: str
    minPrice: NlpSemanticParsingModelsMoneyMoney
    title: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProductClassification(
    typing_extensions.TypedDict, total=False
):
    bookConfidence: float
    isVideoGame: bool
    movieConfidence: float
    videoGameConfidence: float

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProductExpression(
    typing_extensions.TypedDict, total=False
):
    evalData: NlpSemanticParsingAnnotationEvalData
    grammaticalGender: typing_extensions.Literal[
        "UNKNOWN_GENDER", "FEMININE", "MASCULINE"
    ]
    grammaticalNumber: typing_extensions.Literal[
        "UNKNOWN_NUMBER", "PLURAL", "SINGULAR", "DUAL"
    ]
    phrases: _list[NlpSemanticParsingModelsShoppingAssistantPhrase]
    productClassification: NlpSemanticParsingModelsShoppingAssistantProductClassification
    shoppingListItemInfo: NlpSemanticParsingModelsShoppingAssistantShoppingListItemInfo

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProductMediaProduct(
    typing_extensions.TypedDict, total=False
):
    author: NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue
    genre: NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue
    mediaTitle: NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue
    orderInSeries: NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue
    topic: NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProductMediaProductMediaAttributeValue(
    typing_extensions.TypedDict, total=False
):
    mid: str
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantProductPhrase(
    typing_extensions.TypedDict, total=False
):
    metadata: NlpSemanticParsingModelsShoppingAssistantProduct
    rawText: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantShoppingListItemInfo(
    typing_extensions.TypedDict, total=False
):
    itemId: str
    listId: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantStore(
    typing_extensions.TypedDict, total=False
):
    id: str
    location: NlpSemanticParsingLocalLocation
    name: str

@typing.type_check_only
class NlpSemanticParsingModelsShoppingAssistantUnrecognizedPhrase(
    typing_extensions.TypedDict, total=False
):
    rawText: str

@typing.type_check_only
class NlpSemanticParsingNumberFractionNumber(typing_extensions.TypedDict, total=False):
    denominator: NlpSemanticParsingNumberSimpleNumber
    numerator: NlpSemanticParsingNumberSimpleNumber
    precision: int
    wholeNumber: NlpSemanticParsingNumberSimpleNumber

@typing.type_check_only
class NlpSemanticParsingNumberNumber(typing_extensions.TypedDict, total=False):
    evalData: NlpSemanticParsingAnnotationEvalData
    fractionNumber: NlpSemanticParsingNumberFractionNumber
    isSpelledOut: bool
    modifier: typing_extensions.Literal["UNKNOWN", "ADD", "SUBTRACT"]
    normalizedValue: str
    rawText: str
    simpleNumber: NlpSemanticParsingNumberSimpleNumber
    spelledOutType: typing_extensions.Literal[
        "UNKNOWN_SPELLED_OUT_TYPE",
        "FULL_NUMBER",
        "LIST_OF_SINGLE_DIGITS",
        "SHORTHAND",
        "COMBINED",
    ]

@typing.type_check_only
class NlpSemanticParsingNumberSimpleNumber(typing_extensions.TypedDict, total=False):
    decimalMark: typing_extensions.Literal["NO_DELIMITER", "DOT", "COMMA", "SPACE"]
    groupingDelimiter: typing_extensions.Literal[
        "NO_DELIMITER", "DOT", "COMMA", "SPACE"
    ]
    groupingSystem: typing_extensions.Literal[
        "UNKNOWN_GROUPING_SYSTEM",
        "GROUPBY_3_DIGITS",
        "GROUPBY_4_DIGITS",
        "GROUPBY_INDIAN_SYSTEM",
    ]
    normalizedValue: str
    prefix: str
    suffix: str
    type: typing_extensions.Literal[
        "UNKNOWN_NUMBER_TYPE", "INT", "FLOAT", "ORDINAL", "PERCENTAGE"
    ]

@typing.type_check_only
class NlpSemanticParsingPersonalIntelligenceEntity(
    typing_extensions.TypedDict, total=False
):
    airlineConfig: TravelFlightsAirlineConfig
    evalData: NlpSemanticParsingAnnotationEvalData
    name: str
    qrefAnnotation: NlpSemanticParsingQRefAnnotation

@typing.type_check_only
class NlpSemanticParsingPersonalReferenceAnnotation(
    typing_extensions.TypedDict, total=False
):
    reference: NlpSemanticParsingQRefAnnotation
    resolutions: _list[NlpSemanticParsingQRefAnnotation]

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleAogSlot(
    typing_extensions.TypedDict, total=False
):
    entityId: str
    numBytes: int
    original: str
    parameterName: str
    slotList: NlpSemanticParsingProtoActionsOnGoogleSlotList
    slotMap: NlpSemanticParsingProtoActionsOnGoogleSlotMap
    startByte: int
    value: NlpSemanticParsingProtoActionsOnGoogleSlotValue

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleDateTime(
    typing_extensions.TypedDict, total=False
):
    date: GoogleTypeDate
    property: NlpSemanticParsingProtoActionsOnGoogleDateTimeProperty
    time: GoogleTypeTimeOfDay
    timeZone: GoogleTypeTimeZone

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleDateTimeProperty(
    typing_extensions.TypedDict, total=False
):
    datetimeType: typing_extensions.Literal[
        "UNSPECIFIED_TYPE", "DATE", "TIME", "DATETIME"
    ]
    relativeDatetimeType: typing_extensions.Literal[
        "UNSPECIFIED_RELATIVE_TYPE", "RECENT", "FUTURE_OR_NOW", "PARTIAL"
    ]

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleSlotList(
    typing_extensions.TypedDict, total=False
):
    slots: _list[NlpSemanticParsingProtoActionsOnGoogleAogSlot]

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleSlotMap(
    typing_extensions.TypedDict, total=False
):
    slots: dict[str, typing.Any]

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleSlotValue(
    typing_extensions.TypedDict, total=False
):
    values: _list[NlpSemanticParsingProtoActionsOnGoogleSlotValueSingleValue]

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleSlotValueSingleValue(
    typing_extensions.TypedDict, total=False
):
    dateTimeValue: NlpSemanticParsingProtoActionsOnGoogleDateTime
    stringValue: str
    typeValue: NlpSemanticParsingProtoActionsOnGoogleTypedValue

@typing.type_check_only
class NlpSemanticParsingProtoActionsOnGoogleTypedValue(
    typing_extensions.TypedDict, total=False
):
    boolValue: bool
    dateTimeValue: NlpSemanticParsingProtoActionsOnGoogleDateTime
    numberValue: float
    stringValue: str

@typing.type_check_only
class NlpSemanticParsingQRefAnnotation(typing_extensions.TypedDict, total=False):
    addedByCloseAnswers: bool
    annotatedSpan: str
    attributeId: str
    clusterId: str
    clusterSetScore: float
    clusterSiblingMid: _list[str]
    collectionMembership: _list[NlpSemanticParsingQRefAnnotationCollectionMembership]
    confidenceScore: float
    deprecatedEquivalentMids: _list[str]
    deprecatedMdvcSupportingMid: _list[str]
    displayName: str
    entityNumber: int
    entityRelationship: _list[NlpSemanticParsingQRefAnnotationEntityRelationship]
    entitySourceData: NlpSemanticParsingEntitySourceData
    freebaseMid: str
    gaiaId: str
    globalProductClusterId: _list[str]
    interpretationNumber: int
    isMdvcDimension: bool
    isNimbleAnnotation: bool
    location: GeostorePointProto
    locationType: int
    lowConfidence: bool
    matchedLightweightToken: _list[
        RepositoryWebrefLightweightTokensMatchedLightweightToken
    ]
    mdvcChild: _list[NlpSemanticParsingQRefAnnotation]
    mdvcVerticals: _list[str]
    mergedImpliedEntity: _list[NlpSemanticParsingQRefAnnotation]
    merlotCategory: _list[NlpSemanticParsingQRefAnnotationMerlotCategoryData]
    otherMetadata: Proto2BridgeMessageSet
    oysterId: GeostoreFeatureIdProto
    personalSummaryNodeChild: _list[NlpSemanticParsingQRefAnnotation]
    productLineId: _list[str]
    referenceScore: float
    relatedEntity: _list[NlpSemanticParsingRelatedEntity]
    resolutionScore: float
    sourceTypeList: CopleySourceTypeList
    subCluster: _list[NlpSemanticParsingQRefAnnotationSubCluster]

@typing.type_check_only
class NlpSemanticParsingQRefAnnotationCollectionMembership(
    typing_extensions.TypedDict, total=False
):
    collectionId: str
    collectionScore: float

@typing.type_check_only
class NlpSemanticParsingQRefAnnotationEntityRelationship(
    typing_extensions.TypedDict, total=False
):
    entityIndex: int
    impliedBy: bool
    implies: bool
    linkPropertyName: _list[str]

@typing.type_check_only
class NlpSemanticParsingQRefAnnotationMerlotCategoryData(
    typing_extensions.TypedDict, total=False
):
    categoryId: int
    confidence: float

@typing.type_check_only
class NlpSemanticParsingQRefAnnotationSubCluster(
    typing_extensions.TypedDict, total=False
):
    clusterId: str
    clusterSetScore: float
    clusterSiblingMid: _list[str]

@typing.type_check_only
class NlpSemanticParsingRelatedEntity(typing_extensions.TypedDict, total=False):
    clusterSupportTransferRelation: typing_extensions.Literal[
        "NO_CLUSTER_SUPPORT", "CLUSTER_SUPPORT"
    ]
    composedFromRelation: typing_extensions.Literal[
        "NONE_COMPOSED_FROM", "COMPOSED_FROM"
    ]
    equivalentRelation: typing_extensions.Literal[
        "NO_EQUIVALENT", "EQUIVALENT", "MUNIN_SYNONYM"
    ]
    mdvcRelation: typing_extensions.Literal[
        "NO_MDVC",
        "GENERALIZATION_OF",
        "SPECIALIZATION_OF",
        "HAS_DIMENSION_VALUE",
        "IS_DIMENSION_OF",
    ]
    mid: str
    supportTransferRelation: typing_extensions.Literal[
        "NO_SUPPORT_TRANSFER",
        "SUPPORT_TRANSFER_TARGET",
        "SUPPORT_TRANSFER_SOURCE",
        "MENTION_TRANSFER_TARGET",
        "MENTION_TRANSFER_SOURCE",
        "SUPPORT_SHARE_TARGET",
        "SUPPORT_SHARE_SOURCE",
    ]
    targetIsStbrSource: bool

@typing.type_check_only
class NlpSemanticParsingSaftCoreference(typing_extensions.TypedDict, total=False):
    category: str
    rawText: str
    referentText: str

@typing.type_check_only
class NlpSemanticParsingSaftMeasure(typing_extensions.TypedDict, total=False):
    category: str
    rawText: str
    value: float

@typing.type_check_only
class NlpSemanticParsingSaftMentionAnnotation(typing_extensions.TypedDict, total=False):
    coreference: NlpSemanticParsingSaftCoreference
    entity: NlpSemanticParsingSaftSpan
    measure: NlpSemanticParsingSaftMeasure
    title: NlpSemanticParsingSaftSpan

@typing.type_check_only
class NlpSemanticParsingSaftSpan(typing_extensions.TypedDict, total=False):
    category: str
    rawText: str

@typing.type_check_only
class NlxDataSchemaByte(typing_extensions.TypedDict, total=False):
    document: MultiscalePointerIndex

@typing.type_check_only
class NlxDataSchemaCharacter(typing_extensions.TypedDict, total=False):
    document: MultiscalePointerIndex
    paragraph: MultiscalePointerIndex
    sentence: MultiscalePointerIndex
    text: str
    token: MultiscalePointerIndex

@typing.type_check_only
class NlxDataSchemaDocument(typing_extensions.TypedDict, total=False):
    author: _list[MultiscalePointerIndex]
    bytes: MultiscalePointerSpan
    characters: MultiscalePointerSpan
    id: str
    languageCode: _list[str]
    languageSpans: MultiscalePointerSpan
    mentions: MultiscalePointerSpan
    paragraphs: MultiscalePointerSpan
    sentences: MultiscalePointerSpan
    text: str
    tokens: MultiscalePointerSpan
    url: str

@typing.type_check_only
class NlxDataSchemaEntity(typing_extensions.TypedDict, total=False):
    gender: str
    mid: str
    name: str
    type: _list[str]

@typing.type_check_only
class NlxDataSchemaLanguageSpan(typing_extensions.TypedDict, total=False):
    bytes: MultiscalePointerSpan
    characters: MultiscalePointerSpan
    document: MultiscalePointerIndex
    languageCode: _list[str]

@typing.type_check_only
class NlxDataSchemaMention(typing_extensions.TypedDict, total=False):
    bytes: MultiscalePointerSpan
    document: MultiscalePointerIndex
    entity: MultiscalePointerIndex
    kind: str
    text: str
    tokens: MultiscalePointerSpan
    type: str

@typing.type_check_only
class NlxDataSchemaParagraph(typing_extensions.TypedDict, total=False):
    bytes: MultiscalePointerSpan
    characters: MultiscalePointerSpan
    document: MultiscalePointerIndex
    sentences: MultiscalePointerSpan
    text: str
    tokens: MultiscalePointerSpan

@typing.type_check_only
class NlxDataSchemaScaleSet(typing_extensions.TypedDict, total=False):
    byte: _list[NlxDataSchemaByte]
    byteDocumentPresence: MultiscaleFieldPresence
    bytePresence: MultiscaleLayerPresence
    character: _list[NlxDataSchemaCharacter]
    characterDocumentPresence: MultiscaleFieldPresence
    characterParagraphPresence: MultiscaleFieldPresence
    characterPresence: MultiscaleLayerPresence
    characterSentencePresence: MultiscaleFieldPresence
    characterTextPresence: MultiscaleFieldPresence
    characterTokenPresence: MultiscaleFieldPresence
    document: _list[NlxDataSchemaDocument]
    documentAuthorPresence: MultiscaleFieldPresence
    documentBytesPresence: MultiscaleFieldPresence
    documentCharactersPresence: MultiscaleFieldPresence
    documentIdPresence: MultiscaleFieldPresence
    documentLanguageCodePresence: MultiscaleFieldPresence
    documentLanguageSpansPresence: MultiscaleFieldPresence
    documentMentionsPresence: MultiscaleFieldPresence
    documentParagraphsPresence: MultiscaleFieldPresence
    documentPresence: MultiscaleLayerPresence
    documentSentencesPresence: MultiscaleFieldPresence
    documentTextPresence: MultiscaleFieldPresence
    documentTokensPresence: MultiscaleFieldPresence
    documentUrlPresence: MultiscaleFieldPresence
    entity: _list[NlxDataSchemaEntity]
    entityGenderPresence: MultiscaleFieldPresence
    entityMidPresence: MultiscaleFieldPresence
    entityNamePresence: MultiscaleFieldPresence
    entityPresence: MultiscaleLayerPresence
    entityTypePresence: MultiscaleFieldPresence
    languageSpan: _list[NlxDataSchemaLanguageSpan]
    languageSpanBytesPresence: MultiscaleFieldPresence
    languageSpanCharactersPresence: MultiscaleFieldPresence
    languageSpanDocumentPresence: MultiscaleFieldPresence
    languageSpanLanguageCodePresence: MultiscaleFieldPresence
    languageSpanPresence: MultiscaleLayerPresence
    mention: _list[NlxDataSchemaMention]
    mentionBytesPresence: MultiscaleFieldPresence
    mentionDocumentPresence: MultiscaleFieldPresence
    mentionEntityPresence: MultiscaleFieldPresence
    mentionKindPresence: MultiscaleFieldPresence
    mentionPresence: MultiscaleLayerPresence
    mentionTextPresence: MultiscaleFieldPresence
    mentionTokensPresence: MultiscaleFieldPresence
    mentionTypePresence: MultiscaleFieldPresence
    paragraph: _list[NlxDataSchemaParagraph]
    paragraphBytesPresence: MultiscaleFieldPresence
    paragraphCharactersPresence: MultiscaleFieldPresence
    paragraphDocumentPresence: MultiscaleFieldPresence
    paragraphPresence: MultiscaleLayerPresence
    paragraphSentencesPresence: MultiscaleFieldPresence
    paragraphTextPresence: MultiscaleFieldPresence
    paragraphTokensPresence: MultiscaleFieldPresence
    sentence: _list[NlxDataSchemaSentence]
    sentenceBytesPresence: MultiscaleFieldPresence
    sentenceCharactersPresence: MultiscaleFieldPresence
    sentenceDocumentPresence: MultiscaleFieldPresence
    sentenceParagraphPresence: MultiscaleFieldPresence
    sentencePresence: MultiscaleLayerPresence
    sentenceTextPresence: MultiscaleFieldPresence
    sentenceTokensPresence: MultiscaleFieldPresence
    token: _list[NlxDataSchemaToken]
    tokenBytesPresence: MultiscaleFieldPresence
    tokenCharactersPresence: MultiscaleFieldPresence
    tokenDependencyHeadPresence: MultiscaleFieldPresence
    tokenDependencyLabelPresence: MultiscaleFieldPresence
    tokenDependencyPresence: MultiscaleFieldPresence
    tokenDocumentPresence: MultiscaleFieldPresence
    tokenParagraphPresence: MultiscaleFieldPresence
    tokenPosPresence: MultiscaleFieldPresence
    tokenPresence: MultiscaleLayerPresence
    tokenSentencePresence: MultiscaleFieldPresence
    tokenTextPresence: MultiscaleFieldPresence

@typing.type_check_only
class NlxDataSchemaSentence(typing_extensions.TypedDict, total=False):
    bytes: MultiscalePointerSpan
    characters: MultiscalePointerSpan
    document: MultiscalePointerIndex
    paragraph: MultiscalePointerIndex
    text: str
    tokens: MultiscalePointerSpan

@typing.type_check_only
class NlxDataSchemaToken(typing_extensions.TypedDict, total=False):
    bytes: MultiscalePointerSpan
    characters: MultiscalePointerSpan
    dependency: NlxDataSchemaTokenDependencyEdge
    dependencyHead: MultiscalePointerIndex
    dependencyLabel: str
    document: MultiscalePointerIndex
    paragraph: MultiscalePointerIndex
    pos: str
    sentence: MultiscalePointerIndex
    text: str

@typing.type_check_only
class NlxDataSchemaTokenDependencyEdge(typing_extensions.TypedDict, total=False):
    deprel: str
    head: MultiscalePointerIndex

@typing.type_check_only
class OceanDataDocinfoWoodwingItemMetadata(typing_extensions.TypedDict, total=False):
    author: str
    category: str
    description: str
    title: str

@typing.type_check_only
class OceanDocInfo(typing_extensions.TypedDict, total=False):
    docTag: OceanDocTag

@typing.type_check_only
class OceanDocTag(typing_extensions.TypedDict, total=False):
    DEPRECATEDApplicationDate: str
    DEPRECATEDIssueDate: str
    DEPRECATEDPatentAssignee: str
    DEPRECATEDPatentNumber: str
    DEPRECATEDPublisherPercentVisible: int
    authors: str
    availableDownloads: int
    blockSnippet: bool
    bookspecific: OceanDocTagBookSpecific
    catalogspecific: OceanDocTagCatalogSpecific
    contentType: int
    contributor: _list[OceanDocTagContributor]
    coverPage: str
    coverPageSize: OceanImageSize
    editors: str
    encryptedExpressionId: str
    encryptedVolumeId: str
    geoRestrict: _list[str]
    goodTextDetail: int
    grantableLocale: _list[str]
    isGeQuality: bool
    isLandingPage: bool
    magazinespecific: OceanDocTagMagazineSpecific
    metadataCoverExists: bool
    metadataCoverSize: OceanImageSize
    newspaperspecific: OceanDocTagNewspaperSpecific
    numPages: int
    objectionableContentBitmap: int
    pageNumber: int
    pageid: int
    pagerank: float
    patentspecific: OceanDocTagPatentSpecific
    price: OceanGEPrice
    printedPageNumber: str
    refPageUrl: str
    searchInBookUrl: str
    segmentTime: int
    sourceType: int
    structuredPageNumber: str
    subTitle: str
    subjectBitmap: str
    thumbnailUrl: str
    title: str
    urlKey: str
    usingActualCover: bool
    viewability: OceanVolumeViewability
    volumeType: int
    volumeVersion: str
    workcluster: OceanDocTagWorkCluster

@typing.type_check_only
class OceanDocTagBookSpecific(typing_extensions.TypedDict, total=False):
    auxBibkeys: _list[str]
    imprint: str
    numRatingHalfStars: int
    numberingrange: _list[OceanDocTagBookSpecificNumberingRange]
    partnerId: str
    productEditionNumber: int
    publicationDate: str
    publisherName: str
    subject: str

@typing.type_check_only
class OceanDocTagBookSpecificNumberingRange(typing_extensions.TypedDict, total=False):
    endNumbering: _list[str]
    numberType: _list[int]
    numberingSchema: _list[int]
    startNumbering: _list[str]

@typing.type_check_only
class OceanDocTagCatalogSpecific(typing_extensions.TypedDict, total=False):
    latest: bool
    publicationDate: int
    publicationTimeToDisplay: str

@typing.type_check_only
class OceanDocTagContributor(typing_extensions.TypedDict, total=False):
    name: str
    type: int

@typing.type_check_only
class OceanDocTagMagazineSpecific(typing_extensions.TypedDict, total=False):
    displayDate: str
    issueDescription: str
    issueEnd: int
    issueStart: int
    item: _list[OceanDataDocinfoWoodwingItemMetadata]
    otherNumberingEnd: int
    otherNumberingSchema: int
    otherNumberingStart: int
    pageToItem: _list[int]
    publicationDateEnd: str
    publicationDateStart: str
    serialTitle: str
    serialVolumeid: str
    volume: int

@typing.type_check_only
class OceanDocTagNewspaperSpecific(typing_extensions.TypedDict, total=False):
    articleRollCoords: str
    newspaperDate: float
    newspaperName: str
    newspaperUrl: str
    publicationDate: str
    publisher: str

@typing.type_check_only
class OceanDocTagPatentSpecific(typing_extensions.TypedDict, total=False):
    applicationDate: str
    contentLanguage: str
    docType: int
    documentNumber: str
    domesticClassification: _list[str]
    internationalClassification: _list[str]
    issueDate: str
    patentAssignee: str
    publicationNumber: str
    relativeThumbnailPath: str
    tenCharUsClassification: _list[str]

@typing.type_check_only
class OceanDocTagWorkCluster(typing_extensions.TypedDict, total=False):
    clusterSize: int
    workId: str

@typing.type_check_only
class OceanGEMoney(typing_extensions.TypedDict, total=False):
    amountInMicros: str
    currencyCode: str

@typing.type_check_only
class OceanGEPrice(typing_extensions.TypedDict, total=False):
    locale: _list[OceanGEPriceLocale]

@typing.type_check_only
class OceanGEPriceLocale(typing_extensions.TypedDict, total=False):
    locale: str
    offerPrice: OceanGEMoney
    onSaleTimeSecs: str

@typing.type_check_only
class OceanImageSize(typing_extensions.TypedDict, total=False):
    height: int
    width: int

@typing.type_check_only
class OceanLocaleViewability(typing_extensions.TypedDict, total=False):
    accessRights: OceanVolumeAccessRights
    allowAddingFrontmatterToPreview: bool
    allowContinuousBrowse: bool
    allowRetailSyndication: bool
    bibkey: str
    canDisplayAds: bool
    canDownloadEpub: bool
    canDownloadPdf: bool
    canShowLibraryLinks: bool
    canShowPhotos: bool
    canUseMetadataCover: bool
    clientId: str
    computedAccessRights: OceanVolumeComputedAccessRights
    dates: OceanLocaleViewabilityDates
    displayDetails: OceanVolumeDisplayDetails
    metadataViewMayIncludeInfoFromScans: bool
    metadataViewSampleAllowed: bool
    percentBookShown: int
    publicDomain: bool
    sourcedetails: OceanLocaleViewabilitySourceDetails
    viewReason: typing_extensions.Literal[
        "REASON_UNKNOWN",
        "REASON_NO_SOURCE",
        "REASON_KILLED",
        "REASON_CONTENT_TYPE",
        "REASON_SCANLESS",
        "REASON_OPTED_OUT",
        "REASON_QUALITY",
        "REASON_INSUFFICIENT_PAGES",
        "REASON_PARTNER",
        "REASON_REFERENCE",
        "REASON_COPYRIGHT",
        "REASON_PUBLIC_DOMAIN",
        "REASON_NEW_COURTESY",
        "REASON_LIBRARY_RESTRICT",
        "REASON_INDEXING_OVERRIDE",
        "REASON_UPLIFTED",
        "REASON_OUTSTANDING_QUESTIONS",
        "REASON_NO_VALID_SCANJOBS",
        "REASON_OPEN_ACCESS_DEPRECATED",
    ]
    viewType: typing_extensions.Literal[
        "VIEW_NONE",
        "VIEW_METADATA",
        "VIEW_SNIPPET",
        "VIEW_FIXED",
        "VIEW_PARTIAL",
        "VIEW_FULL",
    ]

@typing.type_check_only
class OceanLocaleViewabilityDates(typing_extensions.TypedDict, total=False):
    effectiveDate: str

@typing.type_check_only
class OceanLocaleViewabilitySourceDetails(typing_extensions.TypedDict, total=False):
    imprint: OceanVolumeImprint

@typing.type_check_only
class OceanPerDocData(typing_extensions.TypedDict, total=False):
    flags: str
    numPages: int
    pageNumber: int
    pageid: int
    volumeid: str

@typing.type_check_only
class OceanVolumeAccessRights(typing_extensions.TypedDict, total=False):
    allowAutoGeneratedText: bool
    canShowInfoCards: bool
    canShowPhotos: bool
    numAdeDeviceAllowed: int
    numAdobeIdAllowed: int
    numDownloadsAllowed: int
    numSimultaneousAccess: int
    offlineDownload: typing_extensions.Literal[
        "NO_DOWNLOAD", "DRM_FREE_DOWNLOAD", "ACS4_DOWNLOAD"
    ]
    percentCopyable: int
    percentPrintable: int
    restrictOnlyToText: bool
    sellFixedLayoutAsImageOnly: bool
    textToSpeech: bool
    treatAsPublicDomain: bool

@typing.type_check_only
class OceanVolumeComputedAccessRights(typing_extensions.TypedDict, total=False):
    canFamilyShare: bool
    panelizationFeatureInternalOnly: bool
    viewableInternalOnly: bool

@typing.type_check_only
class OceanVolumeDisplayDetails(typing_extensions.TypedDict, total=False):
    ccLicense: int

@typing.type_check_only
class OceanVolumeImprint(typing_extensions.TypedDict, total=False):
    accessRights: OceanVolumeAccessRights
    adsId: str
    allowAddingFrontmatterToPreview: bool
    allowContinuousBrowse: bool
    allowRetailSyndication: bool
    author: str
    bibkey: str
    buyTheBookText: str
    buyTheBookUrl: str
    canDownloadEpub: bool
    canDownloadPdf: bool
    canShowLibraryLinks: bool
    canUseMetadataCover: bool
    disableOtherBuyTheBookLinks: bool
    displayDetails: OceanVolumeDisplayDetails
    geBibkey: str
    imprintId: str
    imprintName: str
    imprintUrl: str
    logoHeight: int
    logoLocation: str
    logoWidth: int
    percentBookShown: int
    promotionalText: str
    promotionalUrl: str
    publishedImprintName: str
    pviRowid: str
    title: str
    useBibdata: bool
    verticalType: typing_extensions.Literal["BOOK", "JOURNAL", "MAGAZINE", "NEWSPAPER"]

@typing.type_check_only
class OceanVolumeViewability(typing_extensions.TypedDict, total=False):
    DEPRECATEDDefaultViewType: int
    defaultViewability: OceanLocaleViewability
    inViewabilityLimbo: bool
    locale: _list[OceanVolumeViewabilityLocale]
    updatedByIndexer: bool

@typing.type_check_only
class OceanVolumeViewabilityLocale(typing_extensions.TypedDict, total=False):
    DEPRECATEDViewType: int
    locale: str
    viewability: OceanLocaleViewability

@typing.type_check_only
class OcrPhotoBoundingBox(typing_extensions.TypedDict, total=False):
    angle: float
    curvedBox: OcrPhotoCurvedBoundingBox
    height: int
    left: int
    top: int
    width: int

@typing.type_check_only
class OcrPhotoCurve(typing_extensions.TypedDict, total=False):
    points: _list[OcrPhotoCurvePoint]

@typing.type_check_only
class OcrPhotoCurvePoint(typing_extensions.TypedDict, total=False):
    x: float
    y: float

@typing.type_check_only
class OcrPhotoCurvedBoundingBox(typing_extensions.TypedDict, total=False):
    midLineCurve: OcrPhotoCurve
    thickness: float
    topToBottom: bool

@typing.type_check_only
class OcrPhotoTextBox(typing_extensions.TypedDict, total=False):
    blockId: int
    box: OcrPhotoBoundingBox
    contentType: typing_extensions.Literal[
        "TEXT",
        "HANDWRITTEN_TEXT",
        "IMAGE",
        "LINE_DRAWING",
        "SEPARATOR",
        "UNREADABLE_TEXT",
        "FORMULA",
        "HANDWRITTEN_FORMULA",
        "NOT_ANNOTATED",
        "SIGNATURE",
        "DIAGRAM_2D",
        "DIAGRAM_OTHER",
        "UNKNOWN",
        "CUSTOM",
    ]
    symbolWidths: _list[int]
    text: str

@typing.type_check_only
class OfficialPagesOfficialKey(typing_extensions.TypedDict, total=False):
    country: str
    language: int
    query: str

@typing.type_check_only
class OfficialPagesQuerySet(typing_extensions.TypedDict, total=False):
    queries: _list[OfficialPagesOfficialKey]
    queryCountryLanguageFingerprints: _list[str]

@typing.type_check_only
class OrionDocEntitiesProto(typing_extensions.TypedDict, total=False):
    docid: str
    encodedEntity: _list[int]

@typing.type_check_only
class PairwiseQScoringData(typing_extensions.TypedDict, total=False):
    confidenceValue: float
    value: float

@typing.type_check_only
class PairwiseQVersionedItem(typing_extensions.TypedDict, total=False):
    confidenceValue: float
    value: float
    versionId: int

@typing.type_check_only
class PeoplestackFlexorgsProtoInternalExternal(
    typing_extensions.TypedDict, total=False
):
    application: typing_extensions.Literal[
        "UNKNOWN_APPLICATION",
        "GPLUS",
        "GPLUS_WEB",
        "GPLUS_ARES_FEATURE_PROVIDER",
        "GPLUS_PHOTOS",
        "GPLUS_HANGOUT",
        "GPLUS_EVENTS",
        "GPLUS_SQUARES",
        "GPLUS_NOTIFICATIONS",
        "GPLUS_GAMES",
        "GPLUS_WHATS_HOT",
        "GPLUS_LOCAL",
        "GPLUS_PLUS_PAGES",
        "GPLUS_PLUS_PAGES_RSS",
        "GPLUS_PROFILE",
        "GPLUS_FIND_PEOPLE",
        "GPLUS_PHOTO_EDITOR",
        "GPLUS_SOCIALCAST",
        "GPLUS_INTERACTION_EVENTS",
        "GPLUS_ENTITY_TRANSFER",
        "GPLUS_LIS",
        "GPLUS_DRAWBRIDGE",
        "GPLUS_DASHER",
        "GPLUS_DASHER_TAKEOUT",
        "PAISA_MERCHANT_CONSOLE",
        "GEO_DATA_UPLOAD_STAGING",
        "GEO_DATA_UPLOAD",
        "GOOGLE_PLAY_SERVICES",
        "GOOGLE_SETTINGS",
        "THIRD_PARTY",
        "PICASA_PHOTOS",
        "GMAIL_HANGOUT",
        "FOUNTAIN",
        "FOUNTAIN_YOUTUBE",
        "YOUTUBE_LEGACY_COMMENT_MIGRATION",
        "FOUNTAIN_YOUTUBE_DISCUSS",
        "FOUNTAIN_YOUTUBE_MESSAGES",
        "YOUTUBE_AUTOSHARES",
        "FOUNTAIN_YOUTUBE_LEGACY_GDATA",
        "YOUTUBE_CHOWN_PIPELINE",
        "FOUNTAIN_YOUTUBE_ACTIVITY_LOG",
        "FOUNTAIN_YOUTUBE_ADMIN",
        "YOUTUBE_HELD_COMMENT_EXPIRY",
        "ONEMARKET_CALENDAR",
        "FOCUS_FRONTEND",
        "URL_SHAREBOX",
        "READER",
        "GOOGLE_MAIL",
        "PLUS_SHARE",
        "YOUTUBE",
        "CHECKIN",
        "FRAMES",
        "PHOTOS_CHROMEAPP",
        "MOBILE_BASIC",
        "GLASSWARE",
        "GAMES",
        "THIRD_PARTY_STREAM_EVERYWHERE_SINGLE_POST_WIDGET",
        "PLAY_STORE",
        "GMAIL_INBOX_POSTS",
        "GMAIL_RECENT_POSTS",
        "SIDECAR",
        "GOOGLE_QUICK_SEARCH_BOX",
        "WALLET",
        "FRAMELESS_SHAREBOX",
        "YOUTUBE_CAPTURE",
        "YOUTUBE_WATCH_PAGE_SHARE",
        "YOUTUBE_REACTR",
        "YOUTUBE_MANGO",
        "YOUTUBE_REACTR_TAKEOUT",
        "YOUTUBE_COMMENTS_NOTIFICATION",
        "YOUTUBE_COMMENTS_TIMED",
        "YOUTUBE_COMMENTS_ENGAGEMENT_P13N",
        "YOUTUBE_COMMENTS_LEGAL_TAKEOUT",
        "YOUTUBE_COMMENTS_INDEXING",
        "YOUTUBE_COMMENTS_NEWEST_FIRST",
        "YOUTUBE_COMMENTS_BACKEND",
        "YOUTUBE_SUBSCRIPTIONS_FEEDS",
        "YOUTUBE_COMMENT_API",
        "GHUB_COMMENTS",
        "GOOGLE_KEEP",
        "VEGA",
        "SOCIAL_REVIEWS",
        "PLAY_MOVIES",
        "GMAIL",
        "GMAIL_GO",
        "HELPOUTS",
        "MAPS",
        "MAPS_ENGINE_MOBILE",
        "CALENDAR",
        "PLAY_NEWSSTAND",
        "FITNESS",
        "WEAR_HEALTH",
        "WEAR_HEALTH_PROVISIONING",
        "PLAY_BOOKS",
        "INSTORE",
        "PLAY_MUSIC",
        "GOOGLE_CHROME",
        "LOCATION_FLARE",
        "NEWS_WEATHER",
        "PROMOTED_POSTS",
        "CLOUD_PRINT",
        "CLOUD_DEVICES",
        "CPANEL",
        "DRIVE",
        "CLASSROOM",
        "STORIES",
        "GOOGLE_ANALYTICS",
        "LOCATION_SAMPLE",
        "BIGTOP",
        "GOOGLE_CAST",
        "AUTHZEN",
        "PARENTS",
        "SEARCH",
        "NEWS",
        "DOCS",
        "PHOTOS",
        "PHOTOS_TAKEOUT",
        "PHOTOS_ABUSE",
        "SIMBA_MOBILE",
        "GOOGLE_JOBS",
        "CLOUD_PLATFORM",
        "CLOUD_PLATFORM_WEB",
        "FIREFOX_BROWSER",
        "MOVIEMAKER",
        "MOVIEMAKER_PHOTOS",
        "GOOGLE_STARS",
        "SNAPSEED",
        "BLOGGER",
        "DEVICE_POLICY",
        "DOUBLECLICK_CREATIVE_PREVIEW",
        "UNICORN",
        "ADWORDS_MOBILE",
        "FAMILY_COMPASS",
        "AUTH_GRANT_CREDENTIAL",
        "HALLWAY",
        "FAMILY_CAMERA",
        "ENDER",
        "MAPS_VIEWS",
        "TABLESCAPE",
        "TOPAZ",
        "FIBER",
        "ATARI",
        "RIDEMATCH",
        "GMONEY",
        "GOOGLE_EXPRESS",
        "CONSUMER_PHOTO_EDITOR",
        "JETSTREAM",
        "SOCIAL_SERENDIPITY",
        "ONE_TODAY",
        "PROFILES",
        "SOCIAL_POLLS",
        "SPACES",
        "ADWORDS_EXPRESS",
        "IDENTITY",
        "IDENTITY_FRONTEND_VISUAL_ELEMENTS",
        "YOUTUBE_BACKSTAGE",
        "YOUTUBE_BACKSTAGE_ADMIN",
        "YOUTUBE_UNPLUGGED",
        "YOUTUBE_MUSIC",
        "HUB",
        "ANDROID_EDU_PROVISIONING",
        "ANDROID_WEAR",
        "CHROMECAST",
        "ONTHEGO",
        "ADSENSE",
        "PROJECT_FI",
        "JAM",
        "HUDDLE",
        "CAR_APP",
        "TAILORMADE",
        "ACTIVITY_LOG",
        "SPACES_ACTIVITY_LOG",
        "PHOTOS_ACTIVITY_LOG",
        "MEMEGEN",
        "SOCIETY",
        "SOCIETY_CHAT",
        "HIGHLIGHT",
        "YOUTUBE_LIVE",
        "YOUTUBE_LIVE_ACTIVITY_LOG",
        "YOUTUBE_LIVE_TAKEOUT",
        "CARDBOARD_CAMERA",
        "PLAY_DEVELOPER_CONSOLE",
        "MIXX",
        "CHROME_REMOTE_DESKTOP",
        "HOT_LANE",
        "CONTACTS",
        "CONTACTSHEET",
        "HOVERCARD",
        "DORY",
        "SPECTRUM",
        "DYNAMITE",
        "DASHER_USER_HUB",
        "CULTURAL",
        "BOOND",
        "EXPEDITIONS",
        "PHOTO_ALBUM_ARCHIVE",
        "GAMMAGO",
        "FIREBALL",
        "SUPPLY_CHAIN_CENTRAL",
        "PAISA",
        "SANDCLOCK",
        "ACCOUNT_SETTINGS_MOBILE",
        "GOOGLE_VOICE",
        "WING_MARKETPLACE",
        "CHIME",
        "LIFESCIENCE_FRONTENDS",
        "WYLO_TODAY",
        "NAKSHA_CONSUMER",
        "ENTERPRISE_ENROLLMENT",
        "IMPROV",
        "TRANSLATE",
        "SOCIAL_ENGAGE",
        "CORPCAM",
        "ANDROID_CONTACTS",
        "CURATOR",
        "TRAVEL_BOOKING",
        "SOCIAL_DISCOVERY",
        "GPOST",
        "PAIDTASKS",
        "PRIMER",
        "LOCAL_DISCOVERY",
        "BASELINE",
        "QUARTZ",
        "DPANEL",
        "TRIPS",
        "HOME_SERVICES",
        "SOCIALGOOD",
        "LOUPE",
        "UGC_LIVE_COMMENTS",
        "FAMILY_LINK",
        "G3DOC",
        "MOMA",
        "DASHER_ADMIN_CONSOLE",
        "DASHER_COMMERCE_CONSOLE",
        "TRAVEL_VACATIONS",
        "TRENDS",
        "TASKS",
        "VIMES",
        "SECURITY_EVENT_MANAGER",
        "VR_EVA",
        "MINDSEARCH",
        "MINDSEARCH_ADMIN",
        "ANDROID_AUTO",
        "CLOUDCAST_TEXTCHAT",
        "APPS_ASSISTANT_OVERLAY",
        "SEARCH_CONSOLE",
        "CHROME_WEB_STORE",
        "SAVE",
        "FOOD_ORDERING",
        "SOCIAL_RECOVERY",
        "ANDROID_ONBOARD_WEB",
        "WEAR_HOME",
        "FACT_CHECK_EXPLORER",
        "ALLO",
        "FAMILY_LINK_HELPER",
        "PROXY_GAL_PROVIDER",
        "ONEGOOGLE",
        "ONEGOOGLE_ASYNC",
        "WICKED",
        "SHEETS",
        "SLIDES",
        "ASSISTANT_EXPLORE_WEB",
        "ASSISTANT_SETTINGS_WEB_UI",
        "ANDROID_DIALER",
        "KLOPFKLOPF",
        "LAGEPLAN",
        "SCIENCE_JOURNAL",
        "HIRE",
        "ZANDRIA",
        "DASHER_RESELLER_FRONTEND",
        "ZOOMSIGHTS",
        "UGC_LIVE_COMMENTS_TAKEOUT",
        "GUARDIAN",
        "GUARDIAN_CORP",
        "GOOGLE_MY_BUSINESS",
        "PRESTO_ALP",
        "PRESTO_FE",
        "KIDS_HOME",
        "OPA",
        "SUBSCRIBEWITHGOOGLE_CLIENT",
        "REVEAL",
        "ANDROID_NATIVE_ONBOARDING",
        "AMP_ACTIONS",
        "SPOT",
        "MEDICAL_SCRIBE",
        "MEDICAL_SCRIBE_TASKING",
        "DASHER_RULES_FRONTEND",
        "ANDROID_TV_LAUNCHERX",
        "ANDROID_TV_SETUP_WIZARD",
        "SOS_LIVE_COMMENTS",
        "GMAIL_LOCKER_UI",
        "POLYGLOT",
        "PLX",
        "GROUPS_UI",
        "MSV",
        "WOLVERINE",
        "MIC",
        "FORMS",
        "ARCORE",
        "ANDROID_EMERGENCY",
        "LENSLET",
        "MEDICAL_LABELING",
        "G_SUITE_ADD_ONS",
        "LOCATION_HISTORY_CONSENT_ANDROID_LIBRARY",
        "PAYMENTS_WEB_5",
        "APPS_PLATFORM_CONSOLE",
        "INTROSPECT",
        "NGA",
        "SUPPLY_CHAIN_HW_CHP2",
        "DUC_COMPANION",
        "AUTOMON",
        "TV_LIVE_COMMENTS",
        "GUP_PEEPS",
        "FOCUS_SYNC_ADAPTER_V1",
        "NOVA",
        "NOVA_STAGING",
        "DASHER_DATA_CLASSIFICATION_FRONTEND",
        "GOOGLE_ADMIN",
        "MESSAGE_PROCESSOR",
        "EMAIL_PROCESSOR",
        "ENGAGE_PIPELINE",
        "AUTO_DOC_PROBER",
        "DOC_PROBER",
        "FRAMES_DELETE_SYNC",
        "EMBEDS_MIGRATION",
        "SOCIAL_REVIEWS_SYNC",
        "GUNS",
        "POSTBOX_ONEOFF",
        "PLUS_API_ONEOFF",
        "STANZA_ACTIVITY_POST_DELETE_SYNC",
        "GRAPH_PROBER",
        "STANZA_PERIODIC",
        "MADISON_PERIODIC",
        "PAPYRUS_PERIODIC",
        "PHOTOS_BACKEND",
        "REDBOX_BACKEND",
        "PHOTOS_FIFE",
        "ABUSEIAM",
        "ARES",
        "STREAM_INDEXING",
        "STANZA_INDEXING",
        "STANZA",
        "STANZA_MOONSHINE_INDEXING",
        "STREAM_ACTIONS",
        "STREAM_CONFIG",
        "STREAM_SERVICE",
        "STREAM_DELETE",
        "KWYJIBO",
        "STANZA_TEST",
        "TEST_APPLICATION",
        "SOCIAL_ANNOTATION_SERVICE",
        "ANNOTATION_SERVICE_STANZA_LISTENER",
        "SBE_PLAYGROUND",
        "EXPO",
        "ANDROID_VR_HOME",
        "YOUTUBE_BLARNEY_STONE",
        "SOCIAL_EVENTS",
        "EMERGENCY_ASSIST",
        "ADS_INTEGRITY_ENFORCER",
        "ADS_INTEGRITY_ENFORCEMENT_MANAGER",
        "ADS_INTEGRITY_EXPLORER",
        "ADS_INTEGRITY_REVIEWER",
        "GPLUS_COLLEXION_PIPELINE",
        "GPLUS_OFFLINE",
        "PAPYRUS",
        "YOUTUBE_ADMIN",
        "YOUTUBE_ADMIN_REVIEW_QUEUE_PACING",
        "YOUTUBE_TNS_VERTICAL_MANAGER",
        "YOUTUBE_DECIDER",
        "YOUTUBE_TNS_ACTION",
        "YOUTUBE_EXTERNAL_LINKS",
        "FOCUS_BACKEND_BATCH",
        "TEAMSPACES",
        "ASSISTANT_OPA",
        "TRASNLATION_MEMORY_MANAGER",
        "THREADIT",
        "RESOURCE_SYMPHONY",
        "L10N_INFRA_SHARED",
        "WORK_TRACKER",
        "ARIANE",
        "COLAB_INTERNAL",
        "COLAB_EXTERNAL",
        "TALENT_GROW",
        "ROCKET_LABS",
        "MY_GOOGLE_FAMILIES",
        "DATA_STUDIO",
        "LEGAL_CONTRACTS",
        "BRIEF",
        "HARDWARE_MFG_DATA_VENUS",
        "BETTERBUG",
        "DCMS",
        "PLAY_BOOKS_PUBENG",
        "YAQS",
        "PROSPER",
        "CAMPAIGN_AUTOMATION_TOOL",
        "HIRING",
        "DATACENTER_SOFTWARE",
        "MARKETING_WORKFLOWS",
        "YOUTUBE_PARENT_TOOLS",
        "RELIABILITY_INSIGHTS_PST",
        "CUSTOMER_CARE_PORTAL",
        "FUSION",
        "PRODUCTION2020_UIE",
        "SPEAKEASY",
        "GPAY_RELEASE_OPS",
        "SKILLSSTACK",
        "WHOSTORY",
        "BETTANY",
        "BASECAMP",
        "CULTURE_EVENTS_CALENDAR",
        "DATABRIDGE_CONSOLE",
        "COMMSTAR",
        "CDDB",
        "MONOSPACE",
        "MY_ACCOUNT",
        "NUDGEIT_CAMPAIGN_MANAGER",
        "DECS",
        "GSOX_MOCHI",
        "PMW_TI",
        "ACCESSIBILITY_TRACKER",
        "DUCKIEWEB",
        "MATTERSPACE",
        "WAYMO_TRIAGE_TOOLING",
        "TWENTYPERCENT_JOBPOSTINGS",
        "ENGAGEMENTS",
        "CLOUDCONNECT",
        "PERSONAL_AGENT",
        "MOBILE_HARNESS",
        "LOOKER_STUDIO_PRO",
        "SUPPORT_CLASSIFICATION_UI",
        "NOTEBOOKLM",
        "ZOMBIE_CLOUD",
        "RELATIONSHIPS",
        "APPS_WORKFLOW",
        "DEPRECATED_QUICKSTART_FLUME",
        "DUO_CLIENT",
        "ALBERT",
        "PEOPLE_PLAYGROUND",
        "GPLUS_POST_RECOMMENDER",
        "IMAGES",
        "GOOGLE_STORE",
        "GCONNECT_MUSTARD",
        "MADDEN",
        "MOBDOG",
        "GBOARD",
        "RECORDER",
        "UNMAPPED_LEGACY_GPLUS_SOURCE",
        "PODIUM",
        "GSA_FUSE",
        "HONEYPHISH",
        "SOCIAL_ANNOTATION_SERVICE_BACKFILL",
        "CONTACT_HR",
        "PAISA_WANDER",
        "NEXTGENRETAIL_SELF_ORDER",
        "UNSET_APPLICATION",
        "UNKNOWN_FIRST_PARTY_APPLICATION",
        "WABEL",
        "VIDEO_HANGOUT",
        "VIDEO_HANGOUT_LITE",
        "VIDEO_HANGOUT_GVC",
        "VIDEO_HANGOUT_PRESENT",
        "VIDEO_HANGOUT_HOA",
        "VIDEO_HANGOUT_TEE",
        "VIDEO_HANGOUT_SDK",
        "VIDEO_HANGOUT_ENVOY",
        "BABEL",
        "BABEL_NOVA",
        "WABEL_MEDIACALL",
        "HANGOUT_START_PAGE",
        "EXPRESS_LANE",
        "MEETINGS_ANDROID",
        "EXPRESS_LANE_BOQ",
        "RTC_FLEET_MGMT",
        "STAX",
        "RIGEL",
        "PHOTOS_SCANNER",
        "PHOTOS_LIBRARY_API",
        "PHOTOS_PARTNER_API",
        "VAULT",
        "PROF",
        "TOTAL",
        "TOTAL_ZERO_PARTY",
        "TOTAL_FIRST_PARTY",
        "TOTAL_THIRD_PARTY",
        "TOTAL_INTERNAL",
        "TOTAL_UNKNOWN",
        "TOTAL_MINUS_YOUTUBE",
        "TOTAL_FIRST_PARTY_WITH_PRIMARY_INTENT_TO_SHARE_TO_GPLUS",
        "TOTAL_FIRST_PARTY_WITH_SECONDARY_INTENT_TO_SHARE_TO_GPLUS",
        "TOTAL_GPLUS",
        "TOTAL_SOCIAL_APPS",
        "CROWD_COMPUTE",
        "KHAZANA",
        "LIGHTER_GMM",
        "LIGHTER_GMB",
        "MYACTIVITY",
        "BLOG_COMPASS",
        "CONCORD",
        "NAVSTAR",
        "SETTINGS_INTELLIGENCE",
        "TOPAZ_TEAMS",
        "GEMAGENT",
        "DUMBLEDORE",
        "GOOGLE_ONE",
        "NBU_GCONNECT_KIMCHI",
        "FASTDASH",
        "AQUARIUS_LAPIS",
        "DASHER_REPORTING",
        "GCONNECT_PICARD",
        "GOOGLE_JACQUARD",
        "GOOGLE_GO",
        "BUGANIZER",
        "DOCOS_MENTIONS",
        "TRIX_WAFFLE",
        "SHARE_SERVICE",
        "ANDROID_SAFETY",
        "CLOUDCAST_TEXTCHAT_TAKEOUT",
        "ASSISTANT_GO",
        "FLOURISH",
        "ALECS",
        "NANDHI",
        "GOOGLE_RECORDER",
        "CONTACT_STORE",
        "PROFILE_CARD",
        "ESPRESSO",
        "PEOPLE_COMPANION",
        "PHOTOS_GO",
        "YETI",
        "BLOOM",
        "FIELD_OFFICER",
        "URBAN_MOBILITY",
        "FAMILYCARE",
        "INTUITIVE_PLATFORM",
        "NBU_CRICKET_WORLD_CUP",
        "INTEGRATION_PLATFORM",
        "CROS_SCALING_STAGING",
        "CROS_SCALING_PROD",
        "ASSISTANT_PROACTIVE_SUGGESTIONS",
        "PRIVACY_ONE",
        "PAISA_MERCHANT",
        "ASSISTJS",
        "TRAVEL_HOTELIER",
        "PHOTOS_KINDYGRAM",
        "ANDROID_MESSAGES",
        "TRAVEL_HOTEL_EDITOR",
        "VISTAAR",
        "VISTAAR_DEV",
        "GSUITE_GROWTH",
        "ELDAR",
        "GMB_ANDROID",
        "SHOPPING_LIST",
        "EARTH",
        "PAISA_CREDIT_INSTANT_LOAN",
        "ASSISTANT_GO_WEB",
        "SHOWTIME_EVENTS",
        "KONARK",
        "EXO_REFSERVER",
        "MONITORING_PLATFORM",
        "AUTOCAP",
        "PAYMENTS_ORCHESTRATION",
        "GMB_IOS",
        "ASSISTANT_KAIOS",
        "ADMOB_MOBILE",
        "SCREENERS",
        "MILTON",
        "GHIRE",
        "TRANSLATE_COMMUNITY_UI",
        "ROAD_MAPPER",
        "NEST",
        "ROLLOUTS_UI",
        "SHOPPING_PROPERTY",
        "SHOPPING_PROPERTY_NONPROD",
        "PAYMENTS_MERCHANT_VERTICALS_GAS",
        "PAISA_MOVIES",
        "HUB_CALL",
        "WAYMO_SIMULATION_RESULTS",
        "GSUITE_WORKFLOWS",
        "FINANCE_WORKFLOWS",
        "PAYMENTS_MERCHANT_VERTICALS_PARKING_UI",
        "TRAVEL",
        "GABBLE",
        "APPS_EDU",
        "MYFI",
        "CHOMCHOM",
        "ASSISTANT_TOOLCHAIN",
        "YOUTUBE_ANSIBLE",
        "YOUTUBE_CI_KAPLA",
        "GANTRY",
        "PAYMENTS_MERCHANT_CONSOLE",
        "SPLINTER",
        "KINTARO",
        "MDM_ADMIN_CONSOLE",
        "PAYMENTS_CONSUMER_CORE",
        "INCIDENT_MANAGEMENT",
        "ONEGOOGLE_MOBILE",
        "ANURA",
        "FINANCE_FGC",
        "PODCASTS_MANAGER",
        "FILES",
        "YOUTUBE_POST_API",
        "GSUITE_HUB",
        "TV_LAUNCHER",
        "PAIDTASKS_FRONTEND",
        "ONE_REVIEWER_TOOL",
        "MEET_QUALITY_TOOL",
        "TRAVEL_PLANNING",
        "MEET",
        "PAISA_FOOD",
        "TINYTASK_TASKER",
        "FIELDOFFICER",
        "LENS_WEB",
        "HERALD",
        "PAISA_MICROAPPS_WEB",
        "BUG_OBSERVER",
        "ATLAS",
        "DHARMA",
        "SNIPIT",
        "PREMIUM_ASSISTANT",
        "ONEREVIEWERTOOL",
        "CORONADO",
        "SYSTEM1",
        "PUMICE",
        "BACKLIGHT",
        "GLOSSARY_MANAGER",
        "UPGRADEPARTY",
        "ONEDEV_WORKFLOW",
        "AVALANCHE",
        "KORMO_SEEKER",
        "ASSISTANT_PROFILE_YOURPEOPLE",
        "SMART_DISPLAY_WEB",
        "DESKBOOKING",
        "PAYMENTS_MERCHANT_VERTICALS_FOOD",
        "VALUABLES_MERCHANT_CENTER",
        "OFFSEC",
        "SCHEDULE",
        "PAISA_SOCIAL_CAMPAIGNS",
        "WORDFLOW",
        "HEALTH_PLANFORCARE",
        "DEEPMIND_ALPHASCHEDULE",
        "HOOLICHAT_UI",
        "YOUTUBE_CREATOR_STUDIO",
        "BRICKS",
        "PAYMENTS_MERCHANT_DATA_BUSINESS_INSIGHT",
        "RECALL",
        "NEST_GREENENERGY",
        "FRAP",
        "PAYMENTS_MERCHANT_VERTICALS_GROCERY",
        "REVIEWS_WIDGET_API",
        "INCIDENTFLOW",
        "AREA120_PROMODAY",
        "PINPOINT",
        "TRANSCONSOLE",
        "MARKETPLACE",
        "SPORK",
        "DASHER_SUSTAINABILITY",
    ]
    stateStatus: _list[PeoplestackFlexorgsProtoInternalExternalStateStatus]

@typing.type_check_only
class PeoplestackFlexorgsProtoInternalExternalStateStatus(
    typing_extensions.TypedDict, total=False
):
    contextType: typing_extensions.Literal[
        "INTERNAL_EXTERNAL_CONTEXT_UNSPECIFIED", "AUTOCOMPLETE"
    ]
    state: typing_extensions.Literal[
        "INTERNAL_EXTERNAL_STATE_UNSPECIFIED", "INTERNAL", "EXTERNAL", "NOT_APPLICABLE"
    ]

@typing.type_check_only
class PerDocData(typing_extensions.TypedDict, total=False):
    BlogData: BlogPerDocData
    BookCitationData: BookCitationPerDocData
    DEPRECATEDAuthorObfuscatedGaia: _list[str]
    DEPRECATEDQuarantineWhitelist: bool
    DocLevelSpamScore: int
    Event: _list[PerDocDebugEvent]
    GibberishScore: int
    GroupsData: GroupsPerDocData
    IsAnchorBayesSpam: bool
    KeywordStuffingScore: int
    MobileData: MobilePerDocData
    OriginalContentScore: int
    PremiumData: PremiumPerDocData
    QuarantineInfo: int
    ScaledExptIndyRank: int
    ScaledExptIndyRank2: int
    ScaledExptIndyRank3: int
    ScaledExptSpamScoreEric: int
    ScaledExptSpamScoreYoram: int
    ScaledIndyRank: int
    ScaledLinkAgeSpamScore: int
    ScaledSpamScoreEric: int
    ScaledSpamScoreYoram: int
    SpamWordScore: int
    TagPageScore: int
    ToolBarData: ToolBarPerDocData
    WhirlpoolDiscount: float
    appsLink: QualityCalypsoAppsLink
    asteroidBeltIntents: QualityOrbitAsteroidBeltDocumentIntentScores
    authorObfuscatedGaiaStr: _list[str]
    biasingdata: BiasingPerDocData
    biasingdata2: BiasingPerDocData2
    bodyWordsToTokensRatioBegin: float
    bodyWordsToTokensRatioTotal: float
    brainloc: QualityGeoBrainlocBrainlocAttachment
    commercialScore: float
    compressedQualitySignals: CompressedQualitySignals
    compressedUrl: str
    contentAttributions: ContentAttributions
    countryInfo: CountryCountryAttachment
    crawlPagerank: int
    crawlerIdProto: LogsProtoIndexingCrawlerIdCrawlerIdProto
    crowdingdata: CrowdingPerDocData
    datesInfo: str
    desktopInterstitials: IndexingMobileInterstitialsProtoDesktopInterstitials
    domainAge: int
    eventsDate: _list[str]
    extraData: Proto2BridgeMessageSet
    fireflySiteSignal: QualityCopiaFireflySiteSignal
    freshboxArticleScores: int
    freshnessEncodedSignals: str
    fringeQueryPrior: QualityFringeFringeQueryPriorPerDocData
    geodata: str
    homePageInfo: int
    homepagePagerankNs: int
    hostAge: int
    hostNsr: int
    imagedata: ImagePerDocData
    inNewsstand: bool
    isHotdoc: bool
    kaltixdata: KaltixPerDocData
    knexAnnotation: SocialPersonalizationKnexAnnotation
    languages: _list[int]
    lastSignificantUpdate: str
    lastSignificantUpdateInfo: str
    launchAppInfo: QualityRichsnippetsAppsProtosLaunchAppInfoPerDocData
    liveResultsData: WeboftrustLiveResultsDocAttachments
    localizedCluster: IndexingDupsLocalizedLocalizedCluster
    mediaOrPeopleEntities: ImageQualitySensitiveMediaOrPeopleEntities
    noimageframeoverlayreason: int
    nsrDataProto: QualityNsrNsrData
    nsrIsCovidLocalAuthority: bool
    nsrIsElectionAuthority: bool
    nsrIsVideoFocusedSite: bool
    nsrSitechunk: str
    numUrls: int
    oceandata: OceanPerDocData
    onsiteProminence: int
    origin: int
    originalTitleHardTokenCount: int
    pageTags: _list[int]
    pagerank: float
    pagerank0: float
    pagerank1: float
    pagerank2: float
    pageregions: str
    phildata: PhilPerDocData
    productSitesInfo: QualityProductProductSiteData
    queriesForWhichOfficial: OfficialPagesQuerySet
    rosettaLanguages: _list[str]
    rsApplication: RepositoryAnnotationsRdfaRdfaRichSnippetsApplication
    s3AudioLanguage: S3AudioLanguageS3AudioLanguage
    saftLanguageInt: _list[int]
    scaledSelectionTierRank: int
    scienceDoctype: int
    scienceHoldingsIds: _list[str]
    semanticDate: int
    semanticDateConfidence: int
    semanticDateInfo: int
    servingTimeClusterIds: IndexingDocjoinerServingTimeClusterIds
    shingleInfo: ShingleInfoPerDocData
    smartphoneData: SmartphonePerDocData
    smearingMaxTotalOffdomainAnchors: int
    socialgraphNodeNameFp: str
    spamCookbookAction: SpamCookbookAction
    spamMuppetSignals: SpamMuppetjoinsMuppetSignals
    spambrainData: SpamBrainData
    spambrainTotalDocSpamScore: float
    spamrank: int
    spamtokensContentScore: float
    timeSensitivity: int
    titleHardTokenCountWithoutStopwords: int
    toolbarPagerank: int
    topPetacatTaxId: int
    topPetacatWeight: float
    travelGoodSitesInfo: QualityTravelGoodSitesData
    trendspamScore: int
    tundraClusterId: int
    uacSpamScore: int
    urlAfterRedirectsFp: str
    urlPoisoningData: UrlPoisoningData
    v2KnexAnnotation: QualitySherlockKnexAnnotation
    videoCorpusDocid: str
    videoLanguage: QualityVidyaVideoLanguageVideoLanguage
    videodata: VideoPerDocData
    voltData: IndexingMobileVoltVoltPerDocData
    watchpageLanguageResult: WatchpageLanguageWatchPageLanguageResult
    webmirrorEcnFp: str
    webrefEntities: RepositoryWebrefWebrefMustangAttachment
    ymylHealthScore: int
    ymylNewsScore: int

@typing.type_check_only
class PerDocDebugEvent(typing_extensions.TypedDict, total=False):
    Message: str
    Source: str
    Timestamp: int
    Value: str

@typing.type_check_only
class PersonalizationMapsAliasAliasId(typing_extensions.TypedDict, total=False):
    subId: str
    type: typing_extensions.Literal[
        "UNKNOWN_ALIAS_TYPE", "HOME", "WORK", "CONTACT", "NICKNAME"
    ]

@typing.type_check_only
class PersonalizationMapsAliasIcon(typing_extensions.TypedDict, total=False):
    aliasId: PersonalizationMapsAliasAliasId
    droppedPinS2cellId: str
    featureId: GeostoreFeatureIdProto
    featureName: str
    featureType: typing_extensions.Literal[
        "TYPE_ANY",
        "TYPE_TRANSPORTATION",
        "TYPE_ROUTE",
        "TYPE_DEPRECATED_HIGHWAY_DO_NOT_USE",
        "TYPE_HIGHWAY",
        "TYPE_HIGHWAY_1",
        "TYPE_HIGHWAY_2",
        "TYPE_HIGHWAY_3",
        "TYPE_HIGHWAY_4",
        "TYPE_HIGHWAY_5",
        "TYPE_HIGHWAY_6",
        "TYPE_HIGHWAY_7",
        "TYPE_HIGHWAY_8",
        "TYPE_HIGHWAY_9",
        "TYPE_BICYCLE_ROUTE",
        "TYPE_TRAIL",
        "TYPE_SEGMENT",
        "TYPE_ROAD",
        "TYPE_RAILWAY",
        "TYPE_STANDARD_TRACK",
        "TYPE_JR_TRACK",
        "TYPE_NARROW_TRACK",
        "TYPE_MONORAIL_TRACK",
        "TYPE_SUBWAY_TRACK",
        "TYPE_LIGHT_RAIL_TRACK",
        "TYPE_BROAD_TRACK",
        "TYPE_HIGH_SPEED_RAIL",
        "TYPE_TROLLEY_TRACK",
        "TYPE_FERRY",
        "TYPE_FERRY_BOAT",
        "TYPE_FERRY_TRAIN",
        "TYPE_VIRTUAL_SEGMENT",
        "TYPE_INTERSECTION",
        "TYPE_TRANSIT",
        "TYPE_TRANSIT_STATION",
        "TYPE_BUS_STATION",
        "TYPE_TRAMWAY_STATION",
        "TYPE_TRAIN_STATION",
        "TYPE_SUBWAY_STATION",
        "TYPE_FERRY_TERMINAL",
        "TYPE_AIRPORT",
        "TYPE_AIRPORT_CIVIL",
        "TYPE_AIRPORT_MILITARY",
        "TYPE_AIRPORT_MIXED",
        "TYPE_HELIPORT",
        "TYPE_SEAPLANE_BASE",
        "TYPE_AIRSTRIP",
        "TYPE_CABLE_CAR_STATION",
        "TYPE_GONDOLA_LIFT_STATION",
        "TYPE_FUNICULAR_STATION",
        "TYPE_SPECIAL_STATION",
        "TYPE_HORSE_CARRIAGE_STATION",
        "TYPE_MONORAIL_STATION",
        "TYPE_SEAPORT",
        "TYPE_TRANSIT_STOP",
        "TYPE_TRANSIT_TRIP",
        "TYPE_TRANSIT_DEPARTURE",
        "TYPE_TRANSIT_LEG",
        "TYPE_TRANSIT_LINE",
        "TYPE_TRANSIT_AGENCY_DEPRECATED_VALUE",
        "TYPE_TRANSIT_TRANSFER",
        "TYPE_SEGMENT_PATH",
        "TYPE_ROAD_SIGN",
        "TYPE_INTERSECTION_GROUP",
        "TYPE_PATHWAY",
        "TYPE_RESTRICTION_GROUP",
        "TYPE_TOLL_CLUSTER",
        "TYPE_POLITICAL",
        "TYPE_COUNTRY",
        "TYPE_ADMINISTRATIVE_AREA",
        "TYPE_ADMINISTRATIVE_AREA1",
        "TYPE_US_STATE",
        "TYPE_GB_COUNTRY",
        "TYPE_JP_TODOUFUKEN",
        "TYPE_ADMINISTRATIVE_AREA2",
        "TYPE_GB_FORMER_POSTAL_COUNTY",
        "TYPE_GB_TRADITIONAL_COUNTY",
        "TYPE_ADMINISTRATIVE_AREA3",
        "TYPE_ADMINISTRATIVE_AREA4",
        "TYPE_ADMINISTRATIVE_AREA5",
        "TYPE_ADMINISTRATIVE_AREA6",
        "TYPE_ADMINISTRATIVE_AREA7",
        "TYPE_ADMINISTRATIVE_AREA8",
        "TYPE_ADMINISTRATIVE_AREA9",
        "TYPE_COLLOQUIAL_AREA",
        "TYPE_RESERVATION",
        "TYPE_LOCALITY",
        "TYPE_GB_POST_TOWN",
        "TYPE_JP_GUN",
        "TYPE_JP_SHIKUCHOUSON",
        "TYPE_JP_SUB_SHIKUCHOUSON",
        "TYPE_COLLOQUIAL_CITY",
        "TYPE_SUBLOCALITY",
        "TYPE_US_BOROUGH",
        "TYPE_GB_DEPENDENT_LOCALITY",
        "TYPE_JP_OOAZA",
        "TYPE_JP_KOAZA",
        "TYPE_JP_GAIKU",
        "TYPE_GB_DOUBLE_DEPENDENT_LOCALITY",
        "TYPE_JP_CHIBAN",
        "TYPE_JP_EDABAN",
        "TYPE_SUBLOCALITY1",
        "TYPE_SUBLOCALITY2",
        "TYPE_SUBLOCALITY3",
        "TYPE_SUBLOCALITY4",
        "TYPE_SUBLOCALITY5",
        "TYPE_NEIGHBORHOOD",
        "TYPE_CONSTITUENCY",
        "TYPE_DESIGNATED_MARKET_AREA",
        "TYPE_SCHOOL_DISTRICT",
        "TYPE_LAND_PARCEL",
        "TYPE_DISPUTED_AREA",
        "TYPE_POLICE_JURISDICTION",
        "TYPE_STATISTICAL_AREA",
        "TYPE_CONSTITUENCY_FUTURE",
        "TYPE_PARK",
        "TYPE_GOLF_COURSE",
        "TYPE_LOCAL_PARK",
        "TYPE_NATIONAL_PARK",
        "TYPE_US_NATIONAL_PARK",
        "TYPE_US_NATIONAL_MONUMENT",
        "TYPE_NATIONAL_FOREST",
        "TYPE_PROVINCIAL_PARK",
        "TYPE_PROVINCIAL_FOREST",
        "TYPE_CAMPGROUNDS",
        "TYPE_HIKING_AREA",
        "TYPE_BUSINESS",
        "TYPE_GOVERNMENT",
        "TYPE_BORDER_CROSSING",
        "TYPE_CITY_HALL",
        "TYPE_COURTHOUSE",
        "TYPE_EMBASSY",
        "TYPE_LIBRARY",
        "TYPE_SCHOOL",
        "TYPE_UNIVERSITY",
        "TYPE_EMERGENCY",
        "TYPE_HOSPITAL",
        "TYPE_PHARMACY",
        "TYPE_POLICE",
        "TYPE_FIRE",
        "TYPE_DOCTOR",
        "TYPE_DENTIST",
        "TYPE_VETERINARIAN",
        "TYPE_TRAVEL_SERVICE",
        "TYPE_LODGING",
        "TYPE_RESTAURANT",
        "TYPE_GAS_STATION",
        "TYPE_PARKING",
        "TYPE