import typing

import typing_extensions

_list = list

@typing.type_check_only
class GoogleBytestreamMedia(typing_extensions.TypedDict, total=False):
    resourceName: str

@typing.type_check_only
class Operation(typing_extensions.TypedDict, total=False):
    done: bool
    error: Status
    metadata: dict[str, typing.Any]
    name: str
    response: dict[str, typing.Any]

@typing.type_check_only
class Status(typing_extensions.TypedDict, total=False):
    code: int
    details: _list[dict[str, typing.Any]]
    message: str
