import collections.abc
import typing

import httplib2
import typing_extensions

import googleapiclient.discovery
import googleapiclient.http

from .schemas import *

_list = list

@typing.type_check_only
class CloudTraceResource(googleapiclient.discovery.Resource):
    @typing.type_check_only
    class ProjectsResource(googleapiclient.discovery.Resource):
        @typing.type_check_only
        class TracesResource(googleapiclient.discovery.Resource):
            @typing.type_check_only
            class SpansResource(googleapiclient.discovery.Resource):
                def createSpan(
                    self, *, name: str, body: Span = ..., **kwargs: typing.Any
                ) -> SpanHttpRequest: ...

            def batchWrite(
                self,
                *,
                name: str,
                body: BatchWriteSpansRequest = ...,
                **kwargs: typing.Any
            ) -> EmptyHttpRequest: ...
            def spans(self) -> SpansResource: ...

        def traces(self) -> TracesResource: ...

    def new_batch_http_request(
        self,
        callback: collections.abc.Callable[
            [
                str,
                googleapiclient.http.HttpRequest,
                googleapiclient.errors.HttpError | None,
            ],
            typing.Any,
        ]
        | None = None,
    ) -> googleapiclient.http.BatchHttpRequest: ...
    def projects(self) -> ProjectsResource: ...

@typing.type_check_only
class EmptyHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self,
        http: httplib2.Http | googleapiclient.http.HttpMock | None = None,
        num_retries: int = 0,
    ) -> Empty: ...

@typing.type_check_only
class SpanHttpRequest(googleapiclient.http.HttpRequest):
    def execute(
        self,
        http: httplib2.Http | googleapiclient.http.HttpMock | None = None,
        num_retries: int = 0,
    ) -> Span: ...
