from typing import Any, Optional

class Error(Exception): ...

class HttpError(Error):
    resp: Any = ...
    content: Any = ...
    uri: Any = ...
    error_details: str = ...
    reason: Any = ...
    def __init__(self, resp: Any, content: Any, uri: Optional[Any] = ...) -> None: ...
    @property
    def status_code(self): ...

class InvalidJsonError(Error): ...
class UnknownFileType(Error): ...
class UnknownLinkType(Error): ...
class UnknownApiNameOrVersion(Error): ...
class UnacceptableMimeTypeError(Error): ...
class MediaUploadSizeError(Error): ...
class ResumableUploadError(HttpError): ...
class InvalidChunkSizeError(Error): ...
class InvalidNotificationError(Error): ...

class BatchError(HttpError):
    resp: Any = ...
    content: Any = ...
    reason: Any = ...
    def __init__(
        self, reason: Any, resp: Optional[Any] = ..., content: Optional[Any] = ...
    ) -> None: ...

class UnexpectedMethodError(Error):
    def __init__(self, methodId: Optional[Any] = ...) -> None: ...

class UnexpectedBodyError(Error):
    def __init__(self, expected: Any, provided: Any) -> None: ...
