# gpt-api-python

Python client sdk to access GPT's AI-powered conversational functionality (without OpenAI API key nor VPN).

[![PyPi Package Version](https://img.shields.io/pypi/v/gpt-api-python)](https://pypi.org/project/gpt-api-python)

Details refer to https://github.com/beenotung/gpt-api

## Remarks

The spirit of this library is to enable developers to use the Platform for Open Exploration (Poe) via API. It's designed to empower integration and application development within the terms of service of Poe, which specifically disallow any form of automation that exceeds the set rate limits. Please use this library responsibly and within the provided guidelines.

## Features

- **Intuitive API**: Make conversation with GPT models via simple and developer-friendly API.

- **Programming Language Agnostic**: Designed to work with any programming language. Integrate GPT-powered conversational functionalities into your existing projects with ease.

- **Responsible Usage**: Encourages users to respect the guidelines and rate limits set by Poe.

## Installation

```bash
pip install gpt-api-python
```

## Usage Example

```python
# Import functions from the Python package
from gpt_api import ask
from gpt_api.cli import clear_screen

# ask GPT a question and wait for complete response
task = ask(question='Can I call GPT API from python?')
file_path = f"task-{task['id']}.html"
with open(file_path, 'w') as file:
	file.write(task['html'])
print(task['text'])


# ask GPT a question and process the partial response in realtime
def show_progress(task):
	clear_screen()
	print(task['question'])
	print('=' * 32)
	print(task['text'])

# Use the chat method
task = gpt.chat(prompt='What can I do with GPT?', callback=show_progress)
print(f"text: {len(task['text'])}, html: {len(task['html'])}")
```

Detail example can refer to the demo [cli.py](./client/python/src/gpt_api/cli.py)

## Proper Use

It's important to note that Poe's terms of service disallow any form of automation that exceeds the rate limits set forth by Poe. Please ensure to use this library responsibly and within the limits set by Poe. Improper use may lead to suspension of your access to the services.

## Potential Use Cases

(This section is generated by GPT-4 itself)

GPT (Generative Pre-trained Transformer) models are powerful language models capable of generating human-like text. They can be used to enable a wide range of functionalities:

- **Chatbots and Conversational Agents**: GPT models can be used to create chatbots that can carry on human-like conversations. These chatbots can answer questions, provide recommendations, and even have friendly chats with users.

- **Text Generation and Completion**: Given a prompt, GPT models can generate coherent and contextually relevant text. This can be used for tasks such as writing essays, generating code, creating poetry, and much more.

- **Translation**: While not specifically trained for translation, GPT models have shown reasonable performance in translating text between languages.

- **Summarization**: GPT models can be used to summarize long pieces of text, providing a condensed version while preserving the original meaning.

- **Question Answering**: Given a context and a question, GPT models can provide accurate answers, making them useful for tasks like customer support, tutoring, and knowledge extraction.

- **Sentiment Analysis**: While not a primary use case, GPT models can be used to analyze the sentiment of a piece of text, identifying whether the sentiment is positive, negative, or neutral.

- **Content Moderation**: GPT models can help moderate content, identifying inappropriate or offensive text.

- **Personal Assistants**: GPT models can be used to create personal assistants that can schedule appointments, send messages, set reminders, and more.

- **Tutoring**: GPT can provide detailed explanations on a wide range of topics, making it a useful tool for education and tutoring.

These applications can be integrated into various software applications, websites, and services to provide a more interactive and personalized user experience.

However, it's important to note that while GPT models are powerful, they are not perfect. They can sometimes generate incorrect or inappropriate responses, and should not be relied upon for critical decision-making without human supervision.

## License

This project is licensed with [BSD-2-Clause](./LICENSE)

This is free, libre, and open-source software. It comes down to four essential freedoms [[ref]](https://seirdy.one/2021/01/27/whatsapp-and-the-domestication-of-users.html#fnref:2):

- The freedom to run the program as you wish, for any purpose
- The freedom to study how the program works, and change it so it does your computing as you wish
- The freedom to redistribute copies so you can help others
- The freedom to distribute copies of your modified versions to others
