/*
 * Decompiled with CFR 0.152.
 */
package com.turi.hadoop.yarn.applications;

import com.google.common.annotations.VisibleForTesting;
import com.turi.hadoop.yarn.applications.Log4jPropertyHelper;
import com.turi.hadoop.yarn.applications.TuriExitStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final int commanderMemory = 1024;
    private static final Log LOG = LogFactory.getLog(ApplicationMaster.class);
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private ApplicationAttemptId appAttemptID;
    private String appMasterHostname = "";
    private int appMasterRpcPort = -1;
    private String appMasterTrackingUrl = "";
    private int numTotalContainers = 1;
    private int containerMemory = 10;
    private int containerVirtualCores = 1;
    private int requestPriority;
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    private AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    private AtomicInteger numRequestedContainers = new AtomicInteger();
    private ContainerId commanderId = null;
    private ConcurrentHashMap<ContainerId, Container> containerPool = new ConcurrentHashMap();
    private boolean commanderFail = false;
    private boolean seriousWorkerFail = false;
    private JSONObject seriousFailMsg = null;
    private Map<String, String> shellEnv = new HashMap<String, String>();
    private static final String log4jPath = "log4j.properties";
    private volatile boolean done;
    private volatile boolean success;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList<Thread>();
    private int commanderPortStart;
    private int commanderPortEnd;
    private String jobWorkingDir;
    private int workerPortStart;
    private int workerPortEnd;
    private static final String jsonTag = "$$JSONTAG##";
    private int commanderListenPort = -1;
    private String hdfsJobExecDir = null;
    private String turiDistribInstall = null;
    private String appMasterHDFSDir = null;
    private boolean native_conda = false;
    private String condaDir = null;
    private boolean debug = false;
    private String nodeTmpDir = null;
    private String hdfsTmpDir = null;
    private String requireFile = null;

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info((Object)"Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            result = appMaster.run();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running ApplicationMaster", t);
            System.exit(1);
        }
        if (result) {
            System.out.println("Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            System.out.println("Application Master failed. exiting");
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOutDebugInfo() {
        System.out.println("Dump debug output");
        Map<String, String> envs = System.getenv();
        for (Map.Entry<String, String> env : envs.entrySet()) {
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
        }
        BufferedReader buf = null;
        try {
            String lines = Shell.WINDOWS ? Shell.execCommand((String[])new String[]{"cmd", "/c", "dir"}) : Shell.execCommand((String[])new String[]{"ls", "-al"});
            buf = new BufferedReader(new StringReader(lines));
            String line = "";
            while ((line = buf.readLine()) != null) {
                System.out.println("System CWD content: " + line);
                System.out.println("System CWD content: " + line);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
                throw throwable;
            }
            org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
        }
        org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String[] args) throws ParseException, IOException {
        Map<String, String> envs;
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the workers");
        opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the workers");
        opts.addOption("num_containers", true, "No. of containers");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (this.fileExist(log4jPath)) {
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(ApplicationMaster.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
            this.debug = true;
        }
        if (!(envs = System.getenv()).containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
        } else {
            ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
        }
        if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
            throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
        }
        System.out.println("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId());
        if (envs.containsKey("JOB_WORKING_DIR")) {
            this.jobWorkingDir = envs.get("JOB_WORKING_DIR");
        }
        if (envs.containsKey("GL_JOB_DIR")) {
            this.hdfsJobExecDir = envs.get("GL_JOB_DIR");
        }
        if (envs.containsKey("GL_USER_REQS_FILE")) {
            this.requireFile = envs.get("GL_USER_REQS_FILE");
        }
        if (envs.containsKey("APP_MASTER_DIR")) {
            this.appMasterHDFSDir = envs.get("APP_MASTER_DIR");
        }
        if (envs.containsKey("TURI_DISTRIB_ROOT")) {
            this.turiDistribInstall = envs.get("TURI_DISTRIB_ROOT");
        }
        if (envs.containsKey("NATIVE_CONDA")) {
            this.native_conda = true;
        }
        if (envs.containsKey("CONDA_DIR")) {
            this.condaDir = envs.get("CONDA_DIR");
        }
        if (envs.containsKey("NODE_TMP_DIR")) {
            this.nodeTmpDir = envs.get("NODE_TMP_DIR");
        }
        if (envs.containsKey("HDFS_TMP_DIR")) {
            this.hdfsTmpDir = envs.get("HDFS_TMP_DIR");
        }
        if (envs.containsKey("COMMANDER_PORT_START")) {
            this.commanderPortStart = Integer.parseInt(envs.get("COMMANDER_PORT_START"));
        }
        if (envs.containsKey("COMMANDER_PORT_END")) {
            this.commanderPortEnd = Integer.parseInt(envs.get("COMMANDER_PORT_END"));
        }
        if (envs.containsKey("WORKER_PORT_START")) {
            this.workerPortStart = Integer.parseInt(envs.get("WORKER_PORT_START"));
        }
        if (envs.containsKey("WORKER_PORT_END")) {
            this.workerPortEnd = Integer.parseInt(envs.get("WORKER_PORT_END"));
        }
        System.out.println("\n************************GRAPHLAB VALS****************************");
        System.out.println("turiDistribInstall" + this.turiDistribInstall + "\n jobWorkingDir=" + this.jobWorkingDir);
        System.out.println("\n*****************************************************************");
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "2"));
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "2"));
        ++this.numTotalContainers;
        if (this.numTotalContainers == 0) {
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public boolean run() throws YarnException, IOException {
        System.out.println("Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        this.appMasterHostname = NetUtils.getHostname();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        int maxMem = response.getMaximumResourceCapability().getMemory();
        System.out.println("Max mem capabililty of resources in this cluster " + maxMem);
        int maxVCores = response.getMaximumResourceCapability().getVirtualCores();
        System.out.println("Max vcores capabililty of resources in this cluster " + maxVCores);
        if (this.containerMemory > maxMem) {
            System.out.println("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem);
            this.containerMemory = maxMem;
        }
        if (this.containerVirtualCores > maxVCores) {
            System.out.println("Container virtual cores specified above max threshold of cluster. Using max value., specified=" + this.containerVirtualCores + ", max=" + maxVCores);
            this.containerVirtualCores = maxVCores;
        }
        AMRMClient.ContainerRequest commanderAsk = this.setupCommanderAsk();
        this.amRMClient.addContainerRequest(commanderAsk);
        this.numRequestedContainers.set(1);
        int slowCheck = 0;
        while (!this.done && this.numCompletedContainers.get() != this.numTotalContainers) {
            try {
                Thread.sleep(200L);
                if (slowCheck % 42 == 0) {
                    this.checkForCommanderPort();
                    continue;
                }
                ++slowCheck;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.finish();
        return this.success;
    }

    private AMRMClient.ContainerRequest setupCommanderAsk() {
        System.out.println("requesting commander container");
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.requestPriority);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(1024);
        capability.setVirtualCores(1);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        System.out.println("Requested container ask: " + request.toString());
        return request;
    }

    private void checkForCommanderPort() {
        if (this.commanderListenPort < 0) {
            try {
                FileSystem fs = FileSystem.get((Configuration)new YarnConfiguration());
                Path commanderFile = new Path(this.hdfsJobExecDir + "/" + "commander_init.status");
                if (fs.exists(commanderFile)) {
                    String reading;
                    System.out.println("Commander port file found");
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(commanderFile)));
                    StringBuilder sb = new StringBuilder();
                    while ((reading = br.readLine()) != null) {
                        sb.append(reading);
                    }
                    String s = sb.toString();
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse(s);
                    JSONObject jo = (JSONObject)obj;
                    Long val = (Long)jo.get("port");
                    this.commanderListenPort = val.intValue();
                    LOG.info((Object)("commanderListenPort=" + this.commanderListenPort));
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to read commander port file");
                LOG.debug((Object)e.toString());
            }
        }
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler(this);
    }

    private void finish() {
        FinalApplicationStatus appStatus;
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Exception thrown in thread join: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        LOG.info((Object)"Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info((Object)"Application completed. Signalling finish to RM");
        String appMessage = null;
        this.success = true;
        if (!this.commanderFail && !this.seriousWorkerFail) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
            appMessage = "\nDiagnostics., total=" + this.numTotalContainers + ",\n\t completed=" + this.numCompletedContainers.get() + ",\n\t allocated=" + this.numAllocatedContainers.get() + ",\n\t failed=" + this.numFailedContainers.get() + "\n";
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            this.success = false;
            this.seriousFailMsg.put("numTotalContainers", this.numTotalContainers);
            this.seriousFailMsg.put("numCompletedContainers", this.numCompletedContainers);
            this.seriousFailMsg.put("numFailedContainers", this.numFailedContainers);
            appMessage = this.seriousFailMsg.toJSONString();
            this.writeFatalJobStatus();
            LOG.info((Object)appMessage);
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            System.out.println("Failed to unregister application");
            ex.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Failed to unregister application");
            e.printStackTrace();
        }
        this.amRMClient.stop();
    }

    private void writeFatalJobStatus() {
        LOG.info((Object)"Attempting to update job status due to fatal container errors");
        Map<String, String> envs = System.getenv();
        long startTime = Long.parseLong(envs.get("APP_SUBMIT_TIME_ENV"));
        Timestamp stamp = new Timestamp(startTime);
        this.seriousFailMsg.put("start_time", stamp.getTime() / 1000L);
        this.seriousFailMsg.put("status", "FAILED");
        this.seriousFailMsg.put("end_time", new Date().getTime() / 1000L);
        LOG.info((Object)this.seriousFailMsg);
        try {
            FileSystem fs = FileSystem.get((Configuration)new YarnConfiguration());
            String outFile = this.hdfsJobExecDir + "/status";
            Path pt = new Path(outFile);
            BufferedWriter br = fs.exists(pt) ? new BufferedWriter(new OutputStreamWriter((OutputStream)fs.append(pt))) : new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            br.write(this.seriousFailMsg.toJSONString());
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.requestPriority);
        Resource capability = (Resource)Records.newRecord(Resource.class);
        capability.setMemory(this.containerMemory);
        capability.setVirtualCores(this.containerVirtualCores);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        LOG.info((Object)("Requested container ask: " + request.toString()));
        return request;
    }

    private String getContainerCountersReport() {
        String report = "ContainerCountersReport\n\tnumTotalContainers=" + this.numTotalContainers + "\n\tNumCompletedContainers=" + this.numCompletedContainers + "\n\tNumFailedContainers=" + this.numFailedContainers + "\n\tNumRequestedContainers=" + this.numRequestedContainers + "\n\tcontainerPool.size()=" + this.containerPool.size();
        return report;
    }

    private boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(String filePath) throws IOException {
        String string;
        DataInputStream ds = null;
        try {
            ds = new DataInputStream(new FileInputStream(filePath));
            string = ds.readUTF();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ds);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ds);
        return string;
    }

    private class LaunchContainerRunnable
    implements Runnable {
        Container container;
        NMCallbackHandler containerListener;
        boolean isCommander = false;

        public LaunchContainerRunnable(Container lcontainer, NMCallbackHandler containerListener, boolean isCommander) {
            this.container = lcontainer;
            this.containerListener = containerListener;
            this.isCommander = isCommander;
        }

        @Override
        public void run() {
            String glUserPythonScript;
            LOG.info((Object)("Setting up container launch container for containerid=" + this.container.getId()));
            ContainerLaunchContext ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
            ctx.setEnvironment(ApplicationMaster.this.shellEnv);
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            LocalResource reqsFile = (LocalResource)Records.newRecord(LocalResource.class);
            try {
                FileSystem fs = FileSystem.get((Configuration)new YarnConfiguration());
                LOG.info((Object)"adding turiDistribInstall to local resources");
                this.addHDFSDirToLocalResources(localResources, fs, ApplicationMaster.this.turiDistribInstall + "/turi", "turi");
                if (ApplicationMaster.this.requireFile != null) {
                    FileStatus reqStat = fs.getFileStatus(new Path(ApplicationMaster.this.appMasterHDFSDir + "/" + ApplicationMaster.this.requireFile));
                    reqsFile.setSize(reqStat.getLen());
                    reqsFile.setType(LocalResourceType.FILE);
                    reqsFile.setVisibility(LocalResourceVisibility.APPLICATION);
                    reqsFile.setTimestamp(reqStat.getModificationTime());
                    reqsFile.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(reqStat.getPath().toString())));
                    localResources.put("requirements.txt", reqsFile);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                ApplicationMaster.this.numFailedContainers.incrementAndGet();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ctx.setLocalResources(localResources);
            StringBuffer giantCommand = new StringBuffer();
            String glExec = "/bin/bash turi/bins/pipeline/gl_exec.sh -l <LOG_DIR>";
            giantCommand.append(glExec);
            giantCommand.append(" -m " + ApplicationMaster.this.containerMemory + " ");
            giantCommand.append(" -p " + ApplicationMaster.this.containerVirtualCores + " ");
            if (ApplicationMaster.this.native_conda) {
                giantCommand.append(" -n ");
            }
            if (ApplicationMaster.this.condaDir != null) {
                giantCommand.append(" -c " + ApplicationMaster.this.condaDir + " ");
            }
            if (ApplicationMaster.this.debug) {
                giantCommand.append(" -b ");
            }
            if (ApplicationMaster.this.nodeTmpDir != null) {
                giantCommand.append(" -t " + ApplicationMaster.this.nodeTmpDir);
            }
            if (ApplicationMaster.this.hdfsTmpDir != null) {
                giantCommand.append(" -h " + ApplicationMaster.this.hdfsTmpDir);
            }
            if (ApplicationMaster.this.requireFile != null) {
                giantCommand.append(" -r requirements.txt");
            }
            String commanderHost = ((Container)ApplicationMaster.this.containerPool.get(ApplicationMaster.this.commanderId)).getNodeId().getHost();
            String workerHost = this.container.getNodeId().getHost();
            if (this.isCommander) {
                glUserPythonScript = "turi/bins/pipeline/commander_app.py";
                giantCommand.append(" -s " + glUserPythonScript);
                giantCommand.append(" -x '");
                giantCommand.append(" --commander_host_name " + commanderHost);
                giantCommand.append(" --hdfs_job_exec_dir " + ApplicationMaster.this.hdfsJobExecDir);
                giantCommand.append(" --port_start " + ApplicationMaster.this.commanderPortStart);
                giantCommand.append(" --port_end " + ApplicationMaster.this.commanderPortEnd);
                giantCommand.append(" --job_working_dir " + ApplicationMaster.this.jobWorkingDir);
                giantCommand.append(" --req_num_workers " + (ApplicationMaster.this.numTotalContainers - 1));
                giantCommand.append(" '");
                giantCommand.append(" &><LOG_DIR>/gl_commander.stdout");
            } else {
                glUserPythonScript = "turi/bins/pipeline/worker_app.py";
                giantCommand.append(" -s " + glUserPythonScript);
                giantCommand.append(" -x '");
                giantCommand.append(" --worker_identifier " + this.container.getId().toString());
                giantCommand.append(" --worker_host_name " + workerHost);
                giantCommand.append(" --commander_host_name " + commanderHost);
                giantCommand.append(" --port_start " + ApplicationMaster.this.workerPortStart);
                giantCommand.append(" --port_end " + ApplicationMaster.this.workerPortEnd);
                giantCommand.append(" --job_working_dir " + ApplicationMaster.this.jobWorkingDir);
                giantCommand.append(" '");
                giantCommand.append(" &><LOG_DIR>/gl_worker.stdout");
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(giantCommand.toString());
            ctx.setCommands(commands);
            for (String cmd : ctx.getCommands()) {
                LOG.info((Object)("ctx.commands=" + cmd));
            }
            ctx.setTokens(ApplicationMaster.this.allTokens.duplicate());
            this.containerListener.addContainer(this.container.getId(), this.container);
            ApplicationMaster.this.nmClientAsync.startContainerAsync(this.container, ctx);
        }

        private void addHDFSDirToLocalResources(Map<String, LocalResource> localResources, FileSystem fs, String hdfsDir, String newDir) {
            LOG.info((Object)"adding hdfsDir to localresources");
            LOG.info((Object)("hdfsDir=" + hdfsDir + " newDir=" + newDir));
            FileStatus[] fsStatusList = null;
            try {
                fsStatusList = fs.listStatus(new Path(hdfsDir));
            }
            catch (IOException e) {
                LOG.error((Object)("Error when getting directory " + hdfsDir));
                e.printStackTrace();
                ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                ApplicationMaster.this.numFailedContainers.incrementAndGet();
                return;
            }
            if (fsStatusList != null && fsStatusList.length != 0) {
                for (FileStatus fsStatus : fsStatusList) {
                    String path = fsStatus.getPath().toString();
                    String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
                    LocalResource fileRsrc = (LocalResource)Records.newRecord(LocalResource.class);
                    fileRsrc.setType(LocalResourceType.FILE);
                    fileRsrc.setVisibility(LocalResourceVisibility.APPLICATION);
                    fileRsrc.setSize(fsStatus.getLen());
                    fileRsrc.setTimestamp(fsStatus.getModificationTime());
                    try {
                        fileRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(path)));
                    }
                    catch (URISyntaxException e) {
                        LOG.error((Object)("Error when trying to use file path specified in env, path=" + path));
                        e.printStackTrace();
                        ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                        ApplicationMaster.this.numFailedContainers.incrementAndGet();
                        return;
                    }
                    localResources.put(newDir + "/" + fileName, fileRsrc);
                }
            }
        }
    }

    @VisibleForTesting
    static class NMCallbackHandler
    implements NMClientAsync.CallbackHandler {
        private ConcurrentMap<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();
        private final ApplicationMaster applicationMaster;

        public NMCallbackHandler(ApplicationMaster applicationMaster) {
            this.applicationMaster = applicationMaster;
        }

        public void addContainer(ContainerId containerId, Container container) {
            this.containers.putIfAbsent(containerId, container);
        }

        public void onContainerStopped(ContainerId containerId) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Succeeded to stop Container " + containerId));
            }
            this.containers.remove(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Container Status: id=" + containerId + ", status=" + containerStatus));
            }
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            Container container;
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)("Succeeded to start Container " + containerId));
            }
            if ((container = (Container)this.containers.get(containerId)) != null) {
                this.applicationMaster.nmClientAsync.getContainerStatusAsync(containerId, container.getNodeId());
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.info((Object)("Failed to start Container " + containerId));
            this.containers.remove(containerId);
            this.applicationMaster.numCompletedContainers.incrementAndGet();
            this.applicationMaster.numFailedContainers.incrementAndGet();
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.info((Object)("Failed to query the status of Container " + containerId));
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.info((Object)("Failed to stop Container " + containerId));
            this.containers.remove(containerId);
        }
    }

    private class RMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        private RMCallbackHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            System.out.println("Got response from RM for container ask, completedCnt=" + completedContainers.size());
            for (ContainerStatus containerStatus : completedContainers) {
                block17: {
                    block18: {
                        ContainerId containerId = containerStatus.getContainerId();
                        LOG.info((Object)("Got container status for containerID=" + containerId + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics()));
                        assert (containerStatus.getState() == ContainerState.COMPLETE);
                        ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                        if (ApplicationMaster.this.seriousFailMsg != null) {
                            return;
                        }
                        int exitStatus = containerStatus.getExitStatus();
                        TuriExitStatus turiExitStatus = TuriExitStatus.fromInteger(exitStatus);
                        boolean amCommander = containerStatus.getContainerId().equals((Object)ApplicationMaster.this.commanderId);
                        if (amCommander) {
                            if (turiExitStatus != null) {
                                LOG.info((Object)("Commander finished with status " + exitStatus + ": " + turiExitStatus.getErrorString()));
                            }
                            ApplicationMaster.this.commanderFail = turiExitStatus != TuriExitStatus.SUCCESS;
                            if (ApplicationMaster.this.commanderFail) {
                                ApplicationMaster.this.numFailedContainers.incrementAndGet();
                                if (turiExitStatus != null) {
                                    ApplicationMaster.this.seriousFailMsg = this.createJobStatus(containerStatus.getExitStatus(), turiExitStatus.getErrorString());
                                } else {
                                    ApplicationMaster.this.seriousFailMsg = this.createJobStatus(containerStatus.getExitStatus(), "commander: " + containerStatus.getDiagnostics());
                                }
                            }
                            ApplicationMaster.this.done = true;
                            return;
                        }
                        if (turiExitStatus == TuriExitStatus.SUCCESS) break block18;
                        ApplicationMaster.this.numFailedContainers.incrementAndGet();
                        if (turiExitStatus != null) {
                            LOG.info((Object)("Worker finished with status " + exitStatus + ": " + turiExitStatus.getErrorString()));
                            if (turiExitStatus.isFatal()) {
                                ApplicationMaster.this.seriousFailMsg = this.createJobStatus(containerStatus.getExitStatus(), turiExitStatus.getErrorString());
                                ApplicationMaster.this.seriousFailMsg.put("status", "FAILED");
                                LOG.error((Object)ApplicationMaster.this.seriousFailMsg);
                                ApplicationMaster.this.seriousWorkerFail = true;
                                ApplicationMaster.this.done = true;
                                return;
                            }
                            LOG.info((Object)"Failed for a non-fatal reason");
                            LOG.info((Object)(containerId + " turiExitMsg: " + turiExitStatus.getErrorString()));
                            break block17;
                        } else {
                            if (exitStatus != -100 && exitStatus != -102) {
                                System.out.println("a worker container failed for an unrecoverable reason, marking failure and exiting");
                                ApplicationMaster.this.seriousFailMsg = this.createJobStatus(containerStatus.getExitStatus(), containerStatus.getDiagnostics());
                                ApplicationMaster.this.seriousFailMsg.put("status", "FAILED");
                                LOG.error((Object)ApplicationMaster.this.seriousFailMsg);
                                this.notifyCommanderOfFailure(containerStatus);
                                ApplicationMaster.this.done = true;
                                ApplicationMaster.this.seriousWorkerFail = true;
                                return;
                            }
                            System.out.println("a worker container was aborted or preempted, requesting a new one");
                            ApplicationMaster.this.numAllocatedContainers.decrementAndGet();
                            ApplicationMaster.this.numRequestedContainers.decrementAndGet();
                            if (ApplicationMaster.this.commanderListenPort > 0 && !ApplicationMaster.this.done) {
                                this.notifyCommanderOfFailure(containerStatus);
                                break block17;
                            } else {
                                LOG.warn((Object)("A container exited in error but the commander has not started yet or the application is marked completed.  No notification will be sent.\n commanderListenPort=" + ApplicationMaster.this.commanderListenPort + " done=" + ApplicationMaster.this.done));
                            }
                        }
                        break block17;
                    }
                    LOG.info((Object)("Container completed successfully., containerId=" + containerStatus.getContainerId()));
                }
                ApplicationMaster.this.containerPool.remove(containerStatus.getContainerId());
            }
            int askCount = ApplicationMaster.this.numTotalContainers - ApplicationMaster.this.numRequestedContainers.get();
            ApplicationMaster.this.numRequestedContainers.addAndGet(askCount);
            LOG.info((Object)(ApplicationMaster.this.getContainerCountersReport() + "\naskCount=" + askCount + "\n done =" + ApplicationMaster.this.done));
            if (askCount > 0 && !ApplicationMaster.this.done) {
                for (int i = 0; i < askCount; ++i) {
                    AMRMClient.ContainerRequest containerAsk = ApplicationMaster.this.setupContainerAskForRM();
                    ApplicationMaster.this.amRMClient.addContainerRequest(containerAsk);
                }
            }
            if (ApplicationMaster.this.numCompletedContainers.get() == ApplicationMaster.this.numTotalContainers) {
                LOG.info((Object)"numCompleted = numTotal, exiting");
                ApplicationMaster.this.done = true;
            }
        }

        private JSONObject createJobStatus(int status_code, String status_msg) {
            JSONObject status = new JSONObject();
            status.put("exit_status", status_code);
            status.put("error", status_msg);
            return status;
        }

        private void notifyCommanderOfFailure(ContainerStatus containerStatus) {
            try {
                LOG.info((Object)"Contacting commander in failure event");
                HttpClient httpClient = new HttpClient();
                JSONObject jo = new JSONObject();
                jo.put("worker_identifier", containerStatus.getContainerId().toString());
                StringRequestEntity sre = new StringRequestEntity(jo.toString(), "application/json", "UTF-8");
                jo.put("message", containerStatus.getState() + " " + containerStatus.getDiagnostics());
                jo.put("exit_status", containerStatus.getExitStatus());
                String commanderHost = ((Container)ApplicationMaster.this.containerPool.get(ApplicationMaster.this.commanderId)).getNodeId().getHost();
                PostMethod pm = new PostMethod("http://" + commanderHost + ":" + ApplicationMaster.this.commanderListenPort + "/worker_failed");
                pm.setRequestEntity((RequestEntity)sre);
                int httpCode = httpClient.executeMethod((HttpMethod)pm);
                if (httpCode != 200) {
                    System.out.println("Error contacting commander: " + httpCode);
                }
            }
            catch (HttpException he) {
                LOG.error((Object)"unable to reach commander, terminating application");
                ApplicationMaster.this.done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info((Object)("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size()));
            RMCallbackHandler rMCallbackHandler = this;
            synchronized (rMCallbackHandler) {
                if (ApplicationMaster.this.commanderId == null) {
                    Container commander = allocatedContainers.get(0);
                    ApplicationMaster.this.commanderId = commander.getId();
                    LOG.info((Object)("Set commander = " + ApplicationMaster.this.commanderId));
                    LOG.info((Object)("commander resource size=" + commander.getResource().getMemory()));
                    for (int i = 1; i < ApplicationMaster.this.numTotalContainers; ++i) {
                        AMRMClient.ContainerRequest containerAsk = ApplicationMaster.this.setupContainerAskForRM();
                        ApplicationMaster.this.amRMClient.addContainerRequest(containerAsk);
                    }
                    ApplicationMaster.this.numRequestedContainers.set(ApplicationMaster.this.numTotalContainers);
                }
            }
            for (Container allocatedContainer : allocatedContainers) {
                if (ApplicationMaster.this.containerPool.size() >= ApplicationMaster.this.numTotalContainers) {
                    LOG.info((Object)("Releasing unrequired container " + allocatedContainer.getId().toString()));
                    ApplicationMaster.this.amRMClient.releaseAssignedContainer(allocatedContainer.getId());
                    continue;
                }
                if (!ApplicationMaster.this.containerPool.containsKey(allocatedContainer.getId())) {
                    LOG.info((Object)("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemory() + ", containerResourceVirtualCores" + allocatedContainer.getResource().getVirtualCores()));
                    ApplicationMaster.this.containerPool.put(allocatedContainer.getId(), allocatedContainer);
                    boolean amCommander = allocatedContainer.getId().equals((Object)ApplicationMaster.this.commanderId);
                    LOG.info((Object)("amCommander =" + amCommander));
                    LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(allocatedContainer, ApplicationMaster.this.containerListener, amCommander);
                    Thread launchThread = new Thread(runnableLaunchContainer);
                    ApplicationMaster.this.launchThreads.add(launchThread);
                    launchThread.start();
                    continue;
                }
                LOG.info((Object)("already worked with " + allocatedContainer.getId().toString()));
            }
            LOG.info((Object)("containerPool size including commander= " + ApplicationMaster.this.containerPool.size()));
        }

        public void onShutdownRequest() {
            LOG.info((Object)"Shutdown request received");
            ApplicationMaster.this.done = true;
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
        }

        public float getProgress() {
            float progress = (float)ApplicationMaster.this.numCompletedContainers.get() / (float)ApplicationMaster.this.numTotalContainers;
            return progress;
        }

        public void onError(Throwable e) {
            LOG.error((Object)"RMCallback.onError, done = true and stopping");
            ApplicationMaster.this.done = true;
            ApplicationMaster.this.amRMClient.stop();
        }
    }
}

