/*
 * Decompiled with CFR 0.152.
 */
package com.turi.hadoop.yarn.applications;

import com.google.common.io.Files;
import com.turi.hadoop.yarn.applications.Log4jPropertyHelper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client {
    private static final Log LOG = LogFactory.getLog(Client.class);
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private int amMemory = 1024;
    private int amVCores = 1;
    private String appMasterJar = "";
    private final String appMasterMainClass;
    private int containerMemory = 10;
    private int containerVirtualCores = 1;
    private int numContainers = 1;
    private String log4jPropFile = "";
    private final long clientStartTime = System.currentTimeMillis();
    private long clientTimeout = 600000L;
    boolean debugFlag = false;
    private Options opts;
    private static final String appMasterJarPath = "AppMaster.jar";
    private static final String log4jPath = "log4j.properties";
    private static final String jsonTag = "$$JSONTAG##";
    private String checkAppId = "";
    private Long applicationTimeStamp;
    private int applicationId;
    private boolean monitor = false;
    private boolean isJson = false;
    private MonitorTypes monitorType;
    private int commanderPortStart = -2;
    private int commanderPortEnd = -1;
    private int workerPortStart = -2;
    private int workerPortEnd = -1;
    private File downloadTmpDir;
    private String hdfsJobExecDir = null;
    private String turiDistPath = null;
    private String jobWorkingDir = null;
    private String nodeTmpDir = null;
    private String hdfsTmpDir = null;
    private String condaLocation = null;
    private boolean native_conda = false;
    private String reqsFile = null;

    public static void main(String[] args) {
        ExitStatus result = ExitStatus.RUNNING;
        try {
            Client client = new Client();
            LOG.info((Object)"Initializing Client");
            try {
                boolean doRun = client.init(args);
                if (!doRun) {
                    System.exit(0);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
                client.printUsage();
                System.exit(-1);
            }
            result = client.run();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running CLient", t);
            System.exit(1);
        }
        if (result == ExitStatus.FINISH_SUCCESS) {
            LOG.info((Object)"Application completed successfully");
            System.exit(0);
        } else if (result == ExitStatus.RUNNING) {
            LOG.info((Object)"Application is/are still running.");
            System.exit(0);
        } else if (result == ExitStatus.MONITOR) {
            System.exit(0);
        }
        LOG.error((Object)"Application failed to complete successfully");
        System.exit(2);
    }

    public Client(Configuration conf) throws Exception {
        this("com.turi.hadoop.yarn.applications.ApplicationMaster", conf);
    }

    Client(String appMasterMainClass, Configuration conf) {
        this.conf = conf;
        this.appMasterMainClass = appMasterMainClass;
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(conf);
        this.opts = new Options();
        this.opts.addOption("appname", true, "Application Name. Default value - Turi");
        this.opts.addOption("priority", true, "Application Priority. Default 0");
        this.opts.addOption("jar", true, "Jar file containing the application master");
        this.opts.addOption("python_args", true, "Command line args for the python script.Multiple args can be separated by empty space.");
        this.opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the GraphLab job");
        this.opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the GraphLab job");
        this.opts.addOption("num_containers", true, "No. of containers on which the GraphLab job needs to be executed");
        this.opts.addOption("log_properties", true, "log4j.properties file");
        this.opts.addOption("debug", false, "Dump out debug information");
        this.opts.addOption("help", false, "Print usage");
        this.opts.addOption("checkAppId", true, "The applicationId that the client needs to check");
        this.opts.addOption("monitor", true, "Monitors the application status for all GraphLab applications. \n-monitor all : to monitor all applications\n-monitor running : only monitor running applications\n-monitor finished : only monitor finished applications");
        this.opts.addOption("json", false, "Outputs the application status in json");
        this.opts.addOption("commander_port_start", true, "turiDistrib-pipeline commander port start");
        this.opts.addOption("commander_port_end", true, "turiDistrib-pipeline commander end");
        this.opts.addOption("job_working_dir", true, "turiDistrib-pipeline working directory for the job/status/metrics");
        this.opts.addOption("worker_port_start", true, "turiDistrib-pipeline worker port start");
        this.opts.addOption("worker_port_end", true, "turiDistrib-pipeline worker end");
        this.opts.addOption("turi_distrib_path", true, "Installation location of Turi Distributed");
        this.opts.addOption("native_conda", false, "use native conda");
        this.opts.addOption("node_tmp_dir", true, "node local tmp dir");
        this.opts.addOption("hdfs_tmp_dir", true, "hdfs tmp directory for glc data structs");
        this.opts.addOption("reqs_file", true, "python requirements file for packages to install");
        this.opts.addOption("conda_installed_dir", true, "directory for conda installation if preinstalled on nodes");
    }

    public Client() throws Exception {
        this((Configuration)new YarnConfiguration());
    }

    private void printUsage() {
        new HelpFormatter().printHelp(85, "Client", "", this.opts, "");
    }

    public boolean init(String[] args) throws ParseException {
        CommandLine cliParser = new GnuParser().parse(this.opts, args);
        if (args.length == 0) {
            throw new IllegalArgumentException("No args specified for client to initialize");
        }
        if (cliParser.hasOption("log_properties")) {
            String log4jPath = cliParser.getOptionValue("log_properties");
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(Client.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.debugFlag = true;
        }
        this.appName = cliParser.getOptionValue("appname", "Turi");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        if (!(cliParser.hasOption("jar") || cliParser.hasOption("monitor") || cliParser.hasOption("checkAppId"))) {
            throw new IllegalArgumentException("No jar file specified for application master");
        }
        this.appMasterJar = cliParser.getOptionValue("jar");
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.containerMemory < 0 || this.containerVirtualCores < 0 || this.numContainers < 1) {
            throw new IllegalArgumentException("Invalid no. of containers or container memory/vcores specified, exiting. Specified containerMemory=" + this.containerMemory + ", containerVirtualCores=" + this.containerVirtualCores + ", numContainer=" + this.numContainers);
        }
        this.clientTimeout = Integer.parseInt(cliParser.getOptionValue("timeout", "800000"));
        this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
        if (cliParser.hasOption("monitor")) {
            this.monitor = true;
            String monitorInput = cliParser.getOptionValue("monitor");
            if (monitorInput == null || monitorInput.equals("all")) {
                this.monitorType = MonitorTypes.ALL;
            } else if ("running".equals(monitorInput.toLowerCase())) {
                this.monitorType = MonitorTypes.RUNNING;
            } else if ("finished".equals(monitorInput.toLowerCase())) {
                this.monitorType = MonitorTypes.FINISHED;
            }
        }
        if (cliParser.hasOption("json")) {
            this.isJson = true;
        }
        if (cliParser.hasOption("checkAppId") && !this.monitor) {
            this.checkAppId = cliParser.getOptionValue("checkAppId");
            String[] split_id = this.checkAppId.split("_");
            if (split_id.length != 3) {
                throw new IllegalArgumentException("Invalid ApplicationId specified: " + this.checkAppId);
            }
            this.applicationTimeStamp = Long.valueOf(split_id[1]);
            this.applicationId = Integer.valueOf(split_id[2]);
        }
        if (cliParser.hasOption("native_conda")) {
            this.native_conda = true;
        }
        if (cliParser.hasOption("hdfs_tmp_dir")) {
            this.hdfsTmpDir = cliParser.getOptionValue("hdfs_tmp_dir");
        }
        if (cliParser.hasOption("node_tmp_dir")) {
            this.nodeTmpDir = cliParser.getOptionValue("node_tmp_dir");
        }
        if (cliParser.hasOption("commander_port_start")) {
            try {
                this.commanderPortStart = Integer.parseInt(cliParser.getOptionValue("commander_port_start"));
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException("commander_port_start must be a number");
            }
        }
        if (cliParser.hasOption("commander_port_end")) {
            try {
                this.commanderPortEnd = Integer.parseInt(cliParser.getOptionValue("commander_port_end"));
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException("commander_port_end must be a number");
            }
        }
        if (this.commanderPortEnd - this.commanderPortStart < 0) {
            throw new IllegalArgumentException("commander_port range error");
        }
        if (cliParser.hasOption("worker_port_start")) {
            try {
                this.workerPortStart = Integer.parseInt(cliParser.getOptionValue("worker_port_start"));
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException("worker_port_start must be a number");
            }
        }
        if (cliParser.hasOption("worker_port_end")) {
            try {
                this.workerPortEnd = Integer.parseInt(cliParser.getOptionValue("worker_port_end"));
            }
            catch (NumberFormatException ne) {
                throw new IllegalArgumentException("worker_port_end must be a number");
            }
        }
        if (this.workerPortEnd - this.workerPortStart < 0) {
            throw new IllegalArgumentException("worker_port range error");
        }
        if (this.workerPortEnd - this.workerPortStart < this.numContainers) {
            throw new IllegalArgumentException("Port range for workers less than the number of workers requested");
        }
        if (cliParser.hasOption("job_working_dir")) {
            this.jobWorkingDir = cliParser.getOptionValue("job_working_dir");
        }
        if (cliParser.hasOption("turi_distrib_path")) {
            this.turiDistPath = cliParser.getOptionValue("turi_distrib_path");
        } else if (!cliParser.hasOption("checkAppId")) {
            throw new IllegalArgumentException("turi_distrib_path is required. Please provide the hdfslocation where Turi Distributed can be found");
        }
        if (cliParser.hasOption("reqs_file")) {
            this.reqsFile = cliParser.getOptionValue("reqs_file");
        }
        if (cliParser.hasOption("conda_installed_dir")) {
            this.condaLocation = cliParser.getOptionValue("conda_installed_dir");
        }
        return true;
    }

    public ExitStatus run() throws Exception {
        LOG.info((Object)"Running Client...");
        this.yarnClient.start();
        if (this.monitor) {
            return this.monitorGraphlabApplications();
        }
        if (!this.checkAppId.isEmpty()) {
            ApplicationId checkId = ApplicationId.newInstance((long)this.applicationTimeStamp, (int)this.applicationId);
            return this.monitorApplication(checkId);
        }
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        List yrn = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        int sumClusterCapacity = 0;
        for (NodeReport n : yrn) {
            LOG.info((Object)("node " + n.getNodeId() + " capability=" + n.getCapability()));
            sumClusterCapacity += n.getCapability().getMemory();
        }
        int maxMem = appResponse.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        if (this.amMemory > maxMem) {
            LOG.info((Object)("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem));
            this.amMemory = maxMem;
        }
        LOG.info((Object)("numContainers*containerMemory = " + this.numContainers * this.containerMemory + " and sumClusterCapacity=" + sumClusterCapacity));
        int totalAsk = this.numContainers * this.containerMemory;
        if (totalAsk > sumClusterCapacity) {
            LOG.warn((Object)("The request for " + this.numContainers + " of size " + this.containerMemory + " is beyond the max capacity of the cluster" + " reported " + sumClusterCapacity));
        }
        int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
        LOG.info((Object)("Max virtual cores capabililty of resources in this cluster " + maxVCores));
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        appContext.setApplicationName(this.appName);
        appContext.setApplicationType("TuriDistributed");
        ApplicationId appId = appContext.getApplicationId();
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        LOG.info((Object)"Copy App Master jar from local filesystem and add to local environment");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.addToLocalResources(fs, this.appMasterJar, appMasterJarPath, appId.toString(), localResources, null, null);
        if (!this.log4jPropFile.isEmpty()) {
            this.addToLocalResources(fs, this.log4jPropFile, log4jPath, appId.toString(), localResources, null, null);
        }
        String cmdExecDir = this.appName + "/" + appId.toString() + "/cmd_exec_dir";
        Path dst = new Path(fs.getHomeDirectory(), cmdExecDir);
        this.hdfsJobExecDir = dst.toString();
        LOG.info((Object)("hdfs_job_exec_dir=" + this.hdfsJobExecDir));
        if (!fs.exists(dst)) {
            fs.mkdirs(dst, FsPermission.valueOf((String)"drwxrwxrwx"));
        }
        FsShell shell = new FsShell(this.conf);
        try {
            Object[] argv = new String[]{"-chmod", "-R", "777", cmdExecDir};
            LOG.info((Object)Arrays.toString(argv));
            shell.run((String[])argv);
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't change the file permissions ", (Throwable)e);
            throw new IOException(e);
        }
        LOG.info((Object)"Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        this.downloadTmpDir = Files.createTempDir();
        LOG.info((Object)("Using " + this.downloadTmpDir.getAbsolutePath() + " as a temporary working directory"));
        env.put("GL_JOB_DIR", this.hdfsJobExecDir);
        String appMasterDir = fs.getHomeDirectory() + "/" + this.appName + "/" + appId.toString();
        env.put("APP_MASTER_DIR", appMasterDir);
        env.put("JOB_WORKING_DIR", this.jobWorkingDir);
        env.put("TURI_DISTRIB_ROOT", this.turiDistPath);
        env.put("COMMANDER_PORT_START", Integer.toString(this.commanderPortStart));
        env.put("COMMANDER_PORT_END", Integer.toString(this.commanderPortEnd));
        env.put("WORKER_PORT_START", Integer.toString(this.workerPortStart));
        env.put("WORKER_PORT_END", Integer.toString(this.workerPortEnd));
        if (this.native_conda) {
            env.put("NATIVE_CONDA", "true");
        }
        if (this.nodeTmpDir != null) {
            env.put("NODE_TMP_DIR", this.nodeTmpDir);
        }
        if (this.hdfsTmpDir != null) {
            env.put("HDFS_TMP_DIR", this.hdfsTmpDir);
        }
        if (this.condaLocation != null) {
            env.put("CONDA_DIR", this.condaLocation);
        }
        if (this.reqsFile != null) {
            this.addToLocalResources(fs, this.reqsFile, "requirements.txt", appId.toString(), localResources, null, null);
            env.put("GL_USER_REQS_FILE", "requirements.txt");
        }
        amContainer.setLocalResources(localResources);
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$()).append(File.pathSeparatorChar).append("./*");
        for (String string : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            classPathEnv.append(File.pathSeparatorChar);
            classPathEnv.append(string.trim());
        }
        classPathEnv.append(File.pathSeparatorChar).append("./log4j.properties");
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        env.put("CLASSPATH", classPathEnv.toString());
        amContainer.setEnvironment(env);
        Vector<String> vargs = new Vector<String>(30);
        LOG.info((Object)"Setting up app master command");
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        vargs.add("-Xmx" + this.amMemory + "m");
        vargs.add(this.appMasterMainClass);
        vargs.add("--container_memory " + String.valueOf(this.containerMemory));
        vargs.add("--container_vcores " + String.valueOf(this.containerVirtualCores));
        vargs.add("--num_containers " + String.valueOf(this.numContainers));
        if (this.debugFlag) {
            vargs.add("--debug");
        }
        vargs.add("&><LOG_DIR>/gl_AppMaster.stdout");
        StringBuilder command = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            command.append(charSequence).append(" ");
        }
        LOG.info((Object)("Completed setting up app master command " + command.toString()));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command.toString());
        amContainer.setCommands(commands);
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(this.amMemory);
        resource.setVirtualCores(this.amVCores);
        appContext.setResource(resource);
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = this.conf.get("yarn.resourcemanager.principal");
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            if (tokens != null) {
                for (Token token : tokens) {
                    LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
                }
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(fsTokens);
        }
        appContext.setAMContainerSpec(amContainer);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.amPriority);
        appContext.setPriority(pri);
        appContext.setQueue(this.amQueue);
        LOG.info((Object)"Submitting application to ASM");
        this.yarnClient.submitApplication(appContext);
        if (this.debugFlag) {
            for (String key : env.keySet()) {
                LOG.info((Object)("client env key=" + key + " value=" + (String)env.get(key)));
            }
        } else {
            LOG.info((Object)"Deleting temporary directory...");
            FileUtils.deleteDirectory((File)this.downloadTmpDir);
        }
        return this.monitorApplication(appId);
    }

    private String convertLongToTime(long time) {
        if (Long.valueOf(0L).equals(time)) {
            return "--------";
        }
        Date date = new Date(time);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss MM/dd");
        return format.format((Object)date).toString();
    }

    private ExitStatus monitorGraphlabApplications() throws YarnException, IOException {
        HashSet<String> applicationTypes = new HashSet<String>();
        applicationTypes.add("Graphlab");
        List reports = this.yarnClient.getApplications(applicationTypes);
        ArrayList<ApplicationReport> filteredReports = new ArrayList<ApplicationReport>();
        for (ApplicationReport report : reports) {
            if (this.monitorType == MonitorTypes.RUNNING && !report.getYarnApplicationState().equals((Object)YarnApplicationState.FINISHED)) {
                filteredReports.add(report);
                continue;
            }
            if (this.monitorType == MonitorTypes.FINISHED && report.getYarnApplicationState().equals((Object)YarnApplicationState.FINISHED)) {
                filteredReports.add(report);
                continue;
            }
            if (this.monitorType != MonitorTypes.ALL) continue;
            filteredReports.add(report);
        }
        Collections.sort(filteredReports, new Comparator<ApplicationReport>(){

            @Override
            public int compare(ApplicationReport a, ApplicationReport b) {
                return Long.valueOf(b.getStartTime()).compareTo(a.getStartTime());
            }
        });
        JSONArray appStatus_list = new JSONArray();
        System.out.println("List of Graphlab Applications: ");
        if (!this.isJson) {
            System.out.printf("%-35s %-20s %-20s %-15s %-25s %-25s %-25s %-20s\n", "AppId", "AppUser", "StartTime", "AppState", "DistributedFinalState", "numReservedContainers", "numUsedContainers", "FinishTime");
        }
        for (ApplicationReport report : filteredReports) {
            JSONObject appStatus = new JSONObject();
            appStatus.put("AppId", report.getApplicationId().toString());
            appStatus.put("AppUser", report.getUser());
            appStatus.put("StartTime", this.convertLongToTime(report.getStartTime()));
            appStatus.put("AppState", report.getYarnApplicationState().toString());
            appStatus.put("DistributedFinalState", report.getFinalApplicationStatus().toString());
            appStatus.put("numReservedContainers", report.getApplicationResourceUsageReport().getNumReservedContainers());
            appStatus.put("numUsedContainers", report.getApplicationResourceUsageReport().getNumUsedContainers());
            appStatus.put("FinishTime", this.convertLongToTime(report.getFinishTime()));
            appStatus_list.add(appStatus);
            if (this.isJson) continue;
            System.out.printf("%-35s %-20s %-20s %-15s %-25s %-25s %-25s %-20s\n", report.getApplicationId().toString(), report.getUser(), this.convertLongToTime(report.getStartTime()), report.getYarnApplicationState().toString(), report.getFinalApplicationStatus().toString(), report.getApplicationResourceUsageReport().getNumReservedContainers(), report.getApplicationResourceUsageReport().getNumUsedContainers(), this.convertLongToTime(report.getFinishTime()));
        }
        if (this.isJson) {
            System.out.println(jsonTag + appStatus_list.toString() + jsonTag);
        }
        return ExitStatus.MONITOR;
    }

    private ExitStatus monitorApplication(ApplicationId appId) throws YarnException, IOException {
        LOG.info((Object)"Retrieving application report...");
        ApplicationReport report = this.yarnClient.getApplicationReport(appId);
        LOG.info((Object)("Got application report from ASM for,\n\t appId=" + appId.getId() + ",\n\t appUser=" + report.getUser() + ",\n\t appMasterHost=" + report.getHost() + ",\n\t appStartTime=" + this.convertLongToTime(report.getStartTime()) + ",\n\t yarnAppState=" + report.getYarnApplicationState().toString() + ",\n\t distributedFinalState=" + report.getFinalApplicationStatus().toString() + ",\n\t numReservedContainers=" + report.getApplicationResourceUsageReport().getNumReservedContainers() + ",\n\t numUsedContainers=" + report.getApplicationResourceUsageReport().getNumUsedContainers()));
        if (this.isJson) {
            System.out.println("Graphlab Application Status for Application ID " + appId.toString());
            JSONObject appStatus = new JSONObject();
            appStatus.put("AppId", report.getApplicationId().toString());
            appStatus.put("AppUser", report.getUser());
            appStatus.put("StartTime", this.convertLongToTime(report.getStartTime()));
            appStatus.put("AppState", report.getYarnApplicationState().toString());
            appStatus.put("DistributedFinalState", report.getFinalApplicationStatus().toString());
            appStatus.put("numReservedContainers", report.getApplicationResourceUsageReport().getNumReservedContainers());
            appStatus.put("numUsedContainers", report.getApplicationResourceUsageReport().getNumUsedContainers());
            appStatus.put("FinishTime", this.convertLongToTime(report.getFinishTime()));
            appStatus.put("Diagnostics", report.getDiagnostics());
            System.out.println(jsonTag + appStatus.toString() + jsonTag);
        }
        YarnApplicationState state = report.getYarnApplicationState();
        FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
        if (YarnApplicationState.FINISHED == state) {
            if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                LOG.info((Object)"Application has completed successfully. Breaking monitoring loop");
                return ExitStatus.FINISH_SUCCESS;
            }
            LOG.info((Object)("Application finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
            return ExitStatus.FINISH_FAIL;
        }
        if (YarnApplicationState.KILLED == state || YarnApplicationState.FAILED == state) {
            LOG.info((Object)("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
            return ExitStatus.KILLED;
        }
        if (System.currentTimeMillis() > this.clientStartTime + this.clientTimeout) {
            LOG.info((Object)"Reached client specified timeout for application. Killing application");
            this.forceKillApplication(appId);
            return ExitStatus.TIMEDOUT;
        }
        LOG.info((Object)"Application is still running...");
        return ExitStatus.RUNNING;
    }

    private void forceKillApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalResources(FileSystem fs, String fileSrcPath, String fileDstPath, String appId, Map<String, LocalResource> localResources, String resources, LocalResourceType type) throws IOException {
        Path dst;
        block4: {
            block3: {
                String suffix = this.appName + "/" + appId + "/" + fileDstPath;
                dst = new Path(fs.getHomeDirectory(), suffix);
                if (fileSrcPath != null) break block3;
                FSDataOutputStream ostream = null;
                try {
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    ostream.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ostream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)ostream);
                break block4;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        if (type == null) {
            type = LocalResourceType.FILE;
        }
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)type, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, scRsrc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalSharedResources(FileSystem fs, String fileSrcPath, String sharePath, String fileDstPath, String appId, Map<String, LocalResource> localResources, String resources) throws IOException {
        Path dst;
        block3: {
            block2: {
                String suffix = this.appName + "/" + sharePath + "/" + fileDstPath;
                dst = new Path(fs.getHomeDirectory(), suffix);
                if (fileSrcPath != null) break block2;
                FSDataOutputStream ostream = null;
                try {
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    ostream.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ostream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)ostream);
                break block3;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, scRsrc);
    }

    private static enum ExitStatus {
        FINISH_SUCCESS,
        FINISH_FAIL,
        RUNNING,
        KILLED,
        TIMEDOUT,
        MONITOR;

    }

    private static enum MonitorTypes {
        ALL,
        RUNNING,
        FINISHED;

    }
}

