/*
 * Decompiled with CFR 0.152.
 */
package com.turi.hadoop.yarn.applications;

public enum TuriExitStatus {
    SUCCESS(0),
    UNABLE_TO_SECURE_PORT(13),
    UNABLE_TO_REACH_COMMANDER(14),
    FLASK_APP_ERROR(15),
    CANNOT_WRITE_COMMANDER_PORT(16),
    CANNOT_READ_COMMANDER_PORT(17),
    CANNOT_READ_METADATA(18),
    CANNOT_INSTALL_DATO_REQ_PACKAGE(19),
    CANNOT_INSTALL_USER_PACKAGE(20),
    TASK_ERROR(21),
    CANNOT_FIND_NODE_TMP(22),
    ERROR_USING_TMP_DIR(23),
    ERROR_CREATING_EXECUTION_ENVIRONMENT(24);

    private int exitStatus;

    public int getExitStatus() {
        return this.exitStatus;
    }

    private TuriExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getErrorString() {
        switch (this) {
            case SUCCESS: {
                return "Container finished successfully!";
            }
            case UNABLE_TO_SECURE_PORT: {
                return "Cannot find available port!";
            }
            case FLASK_APP_ERROR: {
                return "Cannot successfully start a Flask application.";
            }
            case UNABLE_TO_REACH_COMMANDER: {
                return "Cannot talk to commander to register itself, commander may already exited";
            }
            case CANNOT_WRITE_COMMANDER_PORT: {
                return "Commander failed to write commander port.";
            }
            case CANNOT_READ_COMMANDER_PORT: {
                return "Worker failed to read commander port file.";
            }
            case CANNOT_READ_METADATA: {
                return "Commander failed to read job metadata.";
            }
            case CANNOT_INSTALL_DATO_REQ_PACKAGE: {
                return "Failed to install Dato Distributed requirements";
            }
            case CANNOT_INSTALL_USER_PACKAGE: {
                return "Failed to install user-specified package.";
            }
            case TASK_ERROR: {
                return "Execution script exited in error";
            }
            case CANNOT_FIND_NODE_TMP: {
                return "Specified node tmp directory does not exist or is not accessible";
            }
            case ERROR_USING_TMP_DIR: {
                return "Error creating directory in the tmp location (system tmp or node_tmp_dir)";
            }
            case ERROR_CREATING_EXECUTION_ENVIRONMENT: {
                return "Error encountered creating python execution environment";
            }
        }
        return "";
    }

    public boolean isFatal() {
        return this != UNABLE_TO_REACH_COMMANDER;
    }

    public static TuriExitStatus fromInteger(int x) {
        switch (x) {
            case 0: {
                return SUCCESS;
            }
            case 13: {
                return UNABLE_TO_SECURE_PORT;
            }
            case 14: {
                return UNABLE_TO_REACH_COMMANDER;
            }
            case 15: {
                return FLASK_APP_ERROR;
            }
            case 16: {
                return CANNOT_WRITE_COMMANDER_PORT;
            }
            case 17: {
                return CANNOT_READ_COMMANDER_PORT;
            }
            case 18: {
                return CANNOT_READ_METADATA;
            }
            case 19: {
                return CANNOT_INSTALL_DATO_REQ_PACKAGE;
            }
            case 20: {
                return CANNOT_INSTALL_USER_PACKAGE;
            }
            case 21: {
                return TASK_ERROR;
            }
            case 22: {
                return CANNOT_FIND_NODE_TMP;
            }
            case 23: {
                return ERROR_USING_TMP_DIR;
            }
            case 24: {
                return ERROR_CREATING_EXECUTION_ENVIRONMENT;
            }
        }
        return null;
    }
}

