/*
 * Decompiled with CFR 0.152.
 */
package org.graphlab.create;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.razorvine.pickle.Unpickler;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFiles$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.dato.AutoBatchedPickler;
import org.apache.spark.dato.DatoSparkHelper$;
import org.apache.spark.dato.EvaluatePython$;
import org.apache.spark.dato.EvaluateRDD$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.graphlab.create.GraphLabUtil$;
import org.graphlab.create.GraphLabUtil$UnityMode$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class GraphLabUtil$ {
    public static final GraphLabUtil$ MODULE$;

    static {
        new GraphLabUtil$();
    }

    public GraphLabUtil$ getUtil() {
        return this;
    }

    public String testRDD() {
        return "fsfs";
    }

    public String makeDir(String outputDir, String subDir, SparkContext sc) {
        String string;
        if (outputDir.startsWith("hdfs://") || outputDir.startsWith("wasb://")) {
            String path = outputDir.endsWith("/") ? new StringBuilder().append((Object)outputDir).append((Object)subDir).toString() : new StringBuilder().append((Object)outputDir).append((Object)"/").append((Object)subDir).toString();
            this.mkdirs(path);
            this.changePermissions(path);
            string = path;
        } else {
            File dir = new File(outputDir, subDir);
            dir.mkdirs();
            string = dir.getAbsolutePath();
        }
        return string;
    }

    public int mkdirs(String path) {
        ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hadoop", "fs", "-mkdir", "-p", path}))));
        Process proc = pb.start();
        int exitstatus = proc.waitFor();
        if (exitstatus != 0) {
            throw new Exception(new StringBuilder().append((Object)"Cannot create directory for ").append((Object)path).append((Object)" exitStatus:").append((Object)BoxesRunTime.boxToInteger((int)exitstatus)).toString());
        }
        return exitstatus;
    }

    public int changePermissions(String outputDir) {
        ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hadoop", "fs", "-chmod", "777", outputDir}))));
        Process proc = pb.start();
        int exitstatus = proc.waitFor();
        if (exitstatus != 0) {
            throw new Exception(new StringBuilder().append((Object)"Cannot change the permission for ").append((Object)outputDir).append((Object)" exitStatus:").append((Object)BoxesRunTime.boxToInteger((int)exitstatus)).toString());
        }
        return exitstatus;
    }

    public String mergePaths(Seq<String> paths) {
        return ((TraversableOnce)paths.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                String string = x$1;
                return string != null ? !string.equals("") : "" != null;
            }
        })).mkString(File.pathSeparator);
    }

    public void writeInt(OutputStream out, int x) {
        out.write((byte)x);
        out.write((byte)(x >> 8));
        out.write((byte)(x >> 16));
        out.write((byte)(x >> 24));
    }

    public int readInt(InputStream in) {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public String[] expandPath(String inputPath, boolean recursive) {
        String[] paths = inputPath.split(File.pathSeparator);
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])paths).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return !s.isEmpty();
            }
        })).flatMap((Function1)new Serializable(recursive){
            public static final long serialVersionUID = 0L;
            public final boolean recursive$1;

            public final TraversableOnce<String> apply(String pathStr) {
                List list;
                File f = new File(pathStr);
                if (f.isDirectory()) {
                    String sep;
                    Predef$ predef$ = Predef$.MODULE$;
                    String string = new StringOps(pathStr).last().toString();
                    String string2 = File.separator;
                    String string3 = !(string != null ? !string.equals(string2) : string2 != null) ? "" : (sep = File.separator);
                    list = this.recursive$1 ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])f.list()).flatMap((Function1)new Serializable(this, pathStr, sep){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.expandPath.2 $outer;
                        private final String pathStr$1;
                        private final String sep$1;

                        public final ArrayOps<String> apply(String x) {
                            String newPath = new StringBuilder().append((Object)this.pathStr$1).append((Object)this.sep$1).append((Object)x).toString();
                            return Predef$.MODULE$.refArrayOps((Object[])GraphLabUtil$.MODULE$.expandPath(newPath, this.$outer.recursive$1));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.pathStr$1 = pathStr$1;
                            this.sep$1 = sep$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])f.list()).map((Function1)new Serializable(this, pathStr, sep){
                        public static final long serialVersionUID = 0L;
                        private final String pathStr$1;
                        private final String sep$1;

                        public final String apply(String x) {
                            return new StringBuilder().append((Object)this.pathStr$1).append((Object)this.sep$1).append((Object)x).toString();
                        }
                        {
                            this.pathStr$1 = pathStr$1;
                            this.sep$1 = sep$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                } else {
                    list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pathStr}));
                }
                return list;
            }
            {
                this.recursive$1 = recursive$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public boolean expandPath$default$2() {
        return false;
    }

    public void installBinary(String binName, String as) {
        String rootDirectory = SparkFiles$.MODULE$.getRootDirectory();
        Path outputPath = Paths.get(rootDirectory, as);
        GraphLabUtil$ graphLabUtil$ = this;
        synchronized (graphLabUtil$) {
            if (!outputPath.toFile().exists()) {
                InputStream in = this.getClass().getResourceAsStream(binName);
                Files.copy(in, outputPath, new CopyOption[0]);
                outputPath.toFile().setExecutable(true);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    public void installBinary(String name) {
        this.installBinary(name, name);
    }

    public String getHadoopVersion() {
        Configuration conf = new Configuration();
        return conf.get("hadoop.common.configuration.version");
    }

    public String getLibHDFSName() {
        String string;
        String platform;
        String string2 = platform = this.getPlatform();
        if (!(string2 != null ? !string2.equals("mac") : "mac" != null)) {
            string = "libhdfs.dylib";
        } else {
            String string3 = platform;
            string = !(string3 != null ? !string3.equals("linux") : "linux" != null) ? "libhdfs.so" : "hdfs.dll";
        }
        return string;
    }

    public String getLibJVMName() {
        String string;
        String platform;
        String string2 = platform = this.getPlatform();
        if (!(string2 != null ? !string2.equals("mac") : "mac" != null)) {
            string = "libjvm.dylib";
        } else {
            String string3 = platform;
            string = !(string3 != null ? !string3.equals("linux") : "linux" != null) ? "libjvm.so" : "jvm.dll";
        }
        return string;
    }

    public void installSharedLibs() {
        String platform;
        String string = platform = this.getPlatform();
        if (!(string != null ? !string.equals("mac") : "mac" != null)) {
            this.installBinary("libhdfs.dylib", "libhdfs.so");
            this.installBinary("cy_callback.dylib", "cy_callback.so");
            this.installBinary("cy_cpp_utils.dylib", "cy_cpp_utils.so");
            this.installBinary("cy_flexible_type.dylib", "cy_flexible_type.so");
            this.installBinary("cy_spark_unity.dylib", "cy_spark_unity.so");
        } else {
            String string2 = platform;
            if (!(string2 != null ? !string2.equals("linux") : "linux" != null)) {
                this.installBinary("cy_callback.so");
                this.installBinary("cy_cpp_utils.so");
                this.installBinary("cy_flexible_type.so");
                this.installBinary("cy_spark_unity.so");
                this.installBinary("libhdfs.so");
            } else {
                this.installBinary("hdfs.dll", "hdfs.dll");
            }
        }
    }

    public String getLibSearchPath() {
        Properties sys = System.getProperties();
        return this.mergePaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)JavaConversions$.MODULE$.propertiesAsScalaMap(sys).getOrElse((Object)"sun.boot.library.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (String)JavaConversions$.MODULE$.propertiesAsScalaMap(sys).getOrElse((Object)"sun.boot.library.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), (String)JavaConversions$.MODULE$.propertiesAsScalaMap(sys).getOrElse((Object)"java.library.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), new StringBuilder().append((Object)((String)JavaConversions$.MODULE$.propertiesAsScalaMap(sys).getOrElse((Object)"sun.boot.library.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).append((Object)File.separator).append((Object)"server").toString()}));
    }

    public String getLibPath(String libName) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.expandPath(this.getLibSearchPath(), false)).filter((Function1)new Serializable(libName){
            public static final long serialVersionUID = 0L;
            private final String libName$1;

            public final boolean apply(String x$2) {
                return x$2.contains(this.libName$1);
            }
            {
                this.libName$1 = libName$1;
            }
        })).mkString(File.pathSeparator);
    }

    public String getUnityLibPath() {
        return this.getLibSearchPath();
    }

    public String getHadoopClasspath() {
        String string;
        Map<String, String> parentEnv = System.getenv();
        String hadoopHomePath = JavaConversions$.MODULE$.mapAsScalaMap(parentEnv).contains((Object)"HADOOP_HOME") ? new StringBuilder().append((Object)parentEnv.get("HADOOP_HOME")).append((Object)File.separator).append((Object)"bin").toString() : "";
        String hadoopConfPath = JavaConversions$.MODULE$.mapAsScalaMap(parentEnv).contains((Object)"HADOOP_CONF_DIR") ? new StringBuilder().append((Object)parentEnv.get("HADOOP_CONF_DIR")).append((Object)File.separator).append((Object)"..").append((Object)File.separator).append((Object)"bin").toString() : "";
        String extendedPath = new StringBuilder().append((Object)((String)JavaConversions$.MODULE$.mapAsScalaMap(parentEnv).getOrElse((Object)"PATH", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).append((Object)File.pathSeparator).append((Object)hadoopHomePath).append((Object)File.pathSeparator).append((Object)hadoopConfPath).toString();
        File[] candidates = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])extendedPath.split(File.pathSeparator)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(x$4).nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String p) {
                return new File(p, "hadoop");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$5) {
                return x$5.exists();
            }
        });
        if (Predef$.MODULE$.refArrayOps((Object[])candidates).nonEmpty()) {
            ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{candidates[0].toString(), "classpath"}))));
            Map<String, String> childEnv = pb.environment();
            JavaConversions$.MODULE$.mapAsScalaMap(parentEnv).foreach((Function1)new Serializable(childEnv){
                public static final long serialVersionUID = 0L;
                private final Map childEnv$1;

                public final String apply(Tuple2<String, String> x0$1) {
                    if (x0$1 != null) {
                        return (String)this.childEnv$1.put(x0$1._1(), x0$1._2());
                    }
                    throw new MatchError(x0$1);
                }
                {
                    this.childEnv$1 = childEnv$1;
                }
            });
            Process proc = pb.start();
            String[] pathNames = (String[])Source$.MODULE$.fromInputStream(proc.getInputStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toArray(ClassTag$.MODULE$.apply(String.class));
            string = Predef$.MODULE$.refArrayOps((Object[])pathNames).mkString(File.pathSeparator);
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getClasspath() {
        void var2_2;
        Properties sys = System.getProperties();
        String classPath = new StringBuilder().append((Object)((String)JavaConversions$.MODULE$.propertiesAsScalaMap(sys).getOrElse((Object)"java.class.path", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }))).append((Object)File.pathSeparator).append((Object)this.getHadoopClasspath()).toString();
        return var2_2;
    }

    public String getPlatform() {
        block5: {
            String string;
            block3: {
                String osName;
                block4: {
                    block2: {
                        String string2 = osName = System.getProperty("os.name");
                        if (string2 != null ? !string2.equals("Mac OS X") : "Mac OS X" != null) break block2;
                        string = "mac";
                        break block3;
                    }
                    if (!osName.toLowerCase().contains("windows")) break block4;
                    string = "windows";
                    break block3;
                }
                String string3 = osName;
                if (string3 != null ? !string3.equals("Linux") : "Linux" != null) break block5;
                string = "linux";
            }
            return string;
        }
        throw new Exception("Unsupported platform for Spark Integration.");
    }

    public String getBinaryName() {
        return "pyspark_unity.py";
    }

    public void installPlatformBinaries() {
        this.installBinary(this.getBinaryName());
    }

    public String getHadoopNameNode() {
        Configuration conf = new Configuration();
        return conf.get("fs.defaultFS");
    }

    public String getHadoopNameService() {
        Configuration conf = new Configuration();
        return conf.get("dfs.nameservices");
    }

    /*
     * WARNING - void declaration
     */
    public String getHadoopNameNode(SparkContext sc) {
        void var3_3;
        Configuration conf = new Configuration();
        String hadoopNameNode = conf.get("fs.defaultFS");
        return var3_3;
    }

    public String getPlatformLinkVar() {
        String string;
        String platform;
        String string2 = platform = this.getPlatform();
        if (!(string2 != null ? !string2.equals("mac") : "mac" != null)) {
            string = "DYLD_FALLBACK_LIBRARY_PATH";
        } else {
            String string3 = platform;
            string = !(string3 != null ? !string3.equals("linux") : "linux" != null) ? "LD_LIBRARY_PATH" : "PATH";
        }
        return string;
    }

    public Process launchProcess(Enumeration.Value mode, String args) {
        this.installPlatformBinaries();
        String launchName = new StringBuilder().append((Object)".").append((Object)File.separator).append((Object)this.getBinaryName().trim()).toString();
        List fullArgList = (List)((TraversableLike)((TraversableLike)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"python", launchName, mode.toString()})).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])args.split(" ")), List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$6) {
                return x$6.trim();
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                Predef$ predef$ = Predef$.MODULE$;
                return new StringOps(x$7).nonEmpty();
            }
        });
        ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)fullArgList));
        Map<String, String> env = pb.environment();
        String pythonPath = this.mergePaths((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)JavaConversions$.MODULE$.mapAsScalaMap(env).getOrElse((Object)"PYTHONPATH", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), DatoSparkHelper$.MODULE$.sparkPythonPath()}));
        env.put("PYTHONPATH", pythonPath);
        env.put(this.getPlatformLinkVar(), this.getUnityLibPath());
        try {
            this.installSharedLibs();
        }
        catch (Exception exception) {
            System.err.println("Error installing native libhdfs relying on environment.");
        }
        String classpath = this.getClasspath();
        env.put("CLASSPATH", classpath);
        pb.directory(new File(SparkFiles$.MODULE$.getRootDirectory()));
        Process proc = pb.start();
        new Thread(proc){
            private final Process proc$1;

            public void run() {
                Source$.MODULE$.fromInputStream(this.proc$1.getErrorStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String line) {
                        System.err.println(new StringBuilder().append((Object)"UNITY MSG: \t").append((Object)line).toString());
                    }
                });
            }
            {
                this.proc$1 = proc$1;
                super("GraphLab Unity Standard Error Reader");
            }
        }.start();
        return proc;
    }

    public void writeMessage(OutputStream out, byte[] bytes) {
        this.writeInt(out, bytes.length);
        out.write(bytes);
    }

    public void writeEndOfFileMessage(OutputStream out) {
        this.writeInt(out, -1);
    }

    public Iterator<String> toSFrameIterator(String args, Iterator<byte[]> iter) {
        Process proc = this.launchProcess(GraphLabUtil$UnityMode$.MODULE$.ToSFrame(), args);
        new Thread(iter, proc){
            private final Iterator iter$1;
            private final Process proc$2;

            public void run() {
                BufferedOutputStream out = new BufferedOutputStream(this.proc$2.getOutputStream(), 0x1000000);
                this.iter$1.foreach((Function1)new Serializable(this, out){
                    public static final long serialVersionUID = 0L;
                    private final BufferedOutputStream out$1;

                    public final void apply(byte[] bytes) {
                        GraphLabUtil$.MODULE$.writeMessage(this.out$1, bytes);
                    }
                    {
                        this.out$1 = out$1;
                    }
                });
                GraphLabUtil$.MODULE$.writeEndOfFileMessage(out);
                out.close();
            }
            {
                this.iter$1 = iter$1;
                this.proc$2 = proc$2;
                super("GraphLab Unity toSFrame writer");
            }
        }.start();
        Iterator pathNames = Source$.MODULE$.fromInputStream(proc.getInputStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines();
        return new Iterator<String>(proc, pathNames){
            private final Process proc$2;
            private final Iterator pathNames$1;

            public Iterator<String> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> String min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> String max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> String maxBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> String minBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            public String next() {
                return (String)this.pathNames$1.next();
            }

            public boolean hasNext() {
                boolean bl;
                if (this.pathNames$1.hasNext()) {
                    bl = true;
                } else {
                    int exitStatus = this.proc$2.waitFor();
                    if (exitStatus != 0) {
                        throw new Exception(new StringBuilder().append((Object)"GraphLab Unity toSFrame processes exit status ").append((Object)BoxesRunTime.boxToInteger((int)exitStatus)).toString());
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.proc$2 = proc$2;
                this.pathNames$1 = pathNames$1;
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
            }
        };
    }

    public Iterator<byte[]> toRDDIterator(int partId, int numPart, String args) {
        String finalArgs = new StringBuilder().append((Object)args).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" --numPartitions=", " --partId=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPart), BoxesRunTime.boxToInteger((int)partId)}))).toString();
        Process proc = this.launchProcess(GraphLabUtil$UnityMode$.MODULE$.ToRDD(), finalArgs);
        return new Iterator<byte[]>(proc){
            private final BufferedInputStream in;
            private int nextBytes;

            public Iterator<byte[]> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> byte[] min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> byte[] max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> byte[] maxBy(Function1<byte[], B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> byte[] minBy(Function1<byte[], B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef$.less.colon.less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            private BufferedInputStream in() {
                return this.in;
            }

            private int nextBytes() {
                return this.nextBytes;
            }

            private void nextBytes_$eq(int x$1) {
                this.nextBytes = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public byte[] next() {
                void var3_1;
                int bytesRead;
                int bytesJustRead;
                if (this.nextBytes() < 0) {
                    throw new Exception("Reading past end of SFrame");
                }
                byte[] buffer = new byte[this.nextBytes()];
                for (bytesRead = 0; bytesRead < this.nextBytes(); bytesRead += bytesJustRead) {
                    bytesJustRead = this.in().read(buffer, bytesRead, this.nextBytes() - bytesRead);
                    if (bytesJustRead >= 0) continue;
                    throw new Exception("Negative bytes read, error in reading SFrame");
                }
                if (bytesRead != this.nextBytes()) {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error in reading SFrame: bytes read ", " not equal to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)bytesRead), BoxesRunTime.boxToInteger((int)this.nextBytes())})));
                }
                this.nextBytes_$eq(GraphLabUtil$.MODULE$.readInt(this.in()));
                return var3_1;
            }

            public boolean hasNext() {
                return this.nextBytes() >= 0;
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.in = new BufferedInputStream(proc$3.getInputStream(), 0x1000000);
                this.nextBytes = GraphLabUtil$.MODULE$.readInt(this.in());
            }
        };
    }

    public String concat(String[] sframesIn, String args) {
        String[] sframes = (String[])Predef$.MODULE$.refArrayOps((Object[])sframesIn).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String path) {
                return path.startsWith("hdfs://") || path.startsWith("/") || path.startsWith("file://");
            }
        });
        Process proc = this.launchProcess(GraphLabUtil$UnityMode$.MODULE$.Concat(), args);
        PrintWriter out = new PrintWriter(proc.getOutputStream());
        Predef$.MODULE$.refArrayOps((Object[])sframes).foreach((Function1)new Serializable(out){
            public static final long serialVersionUID = 0L;
            private final PrintWriter out$2;

            public final void apply(String x$1) {
                this.out$2.println(x$1);
            }
            {
                this.out$2 = out$2;
            }
        });
        out.close();
        int exitStatus = proc.waitFor();
        if (exitStatus != 0) {
            throw new Exception(new StringBuilder().append((Object)"Subprocess exited with status ").append((Object)BoxesRunTime.boxToInteger((int)exitStatus)).toString());
        }
        Iterator outputIter = Source$.MODULE$.fromInputStream(proc.getInputStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines();
        String finalSFrameName = "";
        while (outputIter.hasNext()) {
            finalSFrameName = (String)outputIter.next();
        }
        return finalSFrameName;
    }

    public String pySparkToSFrame(JavaRDD<byte[]> jrdd, String outputDir, String prefix, String additionalArgs) {
        String internalOutput;
        String hostNameNode = this.getHadoopNameNode();
        String outputDirMod = outputDir;
        if (hostNameNode.startsWith("wasb://")) {
            internalOutput = this.makeDir(outputDir.replace("hdfs://", hostNameNode), "internal", JavaRDD$.MODULE$.toRDD(jrdd).sparkContext()).replace(hostNameNode, "hdfs://");
            outputDirMod = outputDir.replace(hostNameNode, "hdfs://");
        } else {
            internalOutput = this.makeDir(outputDir, "internal", JavaRDD$.MODULE$.toRDD(jrdd).sparkContext());
        }
        String argsTooSFrame = new StringBuilder().append((Object)additionalArgs).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" --outputDir=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{internalOutput}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" --prefix=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix}))).toString();
        String[] fnames = (String[])jrdd.rdd().mapPartitions((Function1)new Serializable(argsTooSFrame){
            public static final long serialVersionUID = 0L;
            private final String argsTooSFrame$1;

            public final Iterator<String> apply(Iterator<byte[]> iter) {
                return GraphLabUtil$.MODULE$.toSFrameIterator(this.argsTooSFrame$1, iter);
            }
            {
                this.argsTooSFrame$1 = argsTooSFrame$1;
            }
        }, jrdd.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class)).collect();
        String argsConcat = new StringBuilder().append((Object)additionalArgs).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" --outputDir=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputDirMod}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" --prefix=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix}))).toString();
        String sframe_name = this.concat(fnames, argsConcat);
        if (sframe_name.startsWith("hdfs://")) {
            if (hostNameNode.startsWith("wasb://")) {
                this.changePermissions(sframe_name.replace("hdfs://", this.getHadoopNameNode()));
            } else {
                this.changePermissions(sframe_name);
            }
        }
        return sframe_name;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDebugPickles(DataFrame df, String prefix) {
        RDD qual$1 = this.pickleDataFrame(df).rdd();
        Serializable x$11 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<byte[][]> apply(Iterator<byte[]> iter) {
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][][]{(byte[][])iter.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))}));
            }
        };
        boolean x$12 = qual$1.mapPartitions$default$2();
        byte[][][] blocks = (byte[][][])qual$1.mapPartitions((Function1)x$11, x$12, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))).collect();
        Object[] objectArray = (Object[])blocks;
        Predef$ predef$ = Predef$.MODULE$;
        Serializable serializable = new Serializable(prefix, blocks){
            public static final long serialVersionUID = 0L;
            public final String prefix$1;
            public final byte[][][] blocks$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                FileOutputStream f = new FileOutputStream(new StringBuilder().append((Object)this.prefix$1).append((Object)"_").append((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString()).toString());
                Predef$.MODULE$.refArrayOps((Object[])this.blocks$1[i]).foreach((Function1)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final FileOutputStream f$1;

                    public final void apply(byte[] m) {
                        GraphLabUtil$.MODULE$.writeMessage(this.f$1, m);
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                GraphLabUtil$.MODULE$.writeEndOfFileMessage(f);
                f.close();
            }
            {
                this.prefix$1 = prefix$1;
                this.blocks$1 = blocks$1;
            }
        };
        Range range = new ArrayOps.ofRef(objectArray).indices();
        if (!range.validateRangeBoundaries((Function1)serializable)) return;
        int n = range.start();
        int n2 = range.terminalElement();
        int n3 = range.step();
        while (n != n2) {
            void var10_6;
            FileOutputStream f1 = new FileOutputStream(new StringBuilder().append((Object)prefix).append((Object)"_").append((Object)((Object)BoxesRunTime.boxToInteger((int)n)).toString()).toString());
            Object[] objectArray2 = (Object[])var10_6[n];
            Predef$ predef$2 = Predef$.MODULE$;
            new ArrayOps.ofRef(objectArray2).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            MODULE$.writeInt(f1, -1);
            f1.close();
            n += n3;
        }
        return;
    }

    public JavaRDD<byte[]> pickleDataFrame(DataFrame df) {
        DataType[] fieldTypes = (DataType[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$8) {
                return x$8.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeInt(bos, fieldTypes.length);
        Charset utf8 = Charset.forName("UTF-8");
        Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).foreach((Function1)new Serializable(bos, utf8){
            public static final long serialVersionUID = 0L;
            private final ByteArrayOutputStream bos$1;
            private final Charset utf8$1;

            public final void apply(StructField f) {
                byte[] nameBytes = f.name().getBytes(this.utf8$1);
                byte[] typeBytes = f.dataType().simpleString().getBytes(this.utf8$1);
                GraphLabUtil$.MODULE$.writeMessage(this.bos$1, nameBytes);
                GraphLabUtil$.MODULE$.writeMessage(this.bos$1, typeBytes);
            }
            {
                this.bos$1 = bos$1;
                this.utf8$1 = utf8$1;
            }
        });
        bos.flush();
        byte[] headerBytes = bos.toByteArray();
        return df.rdd().mapPartitions((Function1)new Serializable(fieldTypes, headerBytes){
            public static final long serialVersionUID = 0L;
            private final DataType[] fieldTypes$1;
            private final byte[] headerBytes$1;

            public final Iterator<byte[]> apply(Iterator<Row> x$9) {
                return GraphLabUtil$.MODULE$.rowIteratorUtil(x$9, this.fieldTypes$1, this.headerBytes$1);
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
                this.headerBytes$1 = headerBytes$1;
            }
        }, df.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))).toJavaRDD();
    }

    public Iterator<byte[]> rowIteratorUtil(Iterator<Row> riter, DataType[] fieldTypes, byte[] header) {
        Iterator arrayIterator = riter.map((Function1)new Serializable(fieldTypes){
            public static final long serialVersionUID = 0L;
            private final DataType[] fieldTypes$2;

            public final Object[] apply(Row row) {
                return (Object[])((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.fieldTypes$2), Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(Tuple2<Object, DataType> entry) {
                        Object field = entry._1();
                        DataType fieldType = (DataType)entry._2();
                        Object value = EvaluatePython$.MODULE$.toJava(field, fieldType);
                        return value;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            }
            {
                this.fieldTypes$2 = fieldTypes$2;
            }
        });
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header})).$plus$plus((Function0)new Serializable(arrayIterator){
            public static final long serialVersionUID = 0L;
            private final Iterator arrayIterator$1;

            public final AutoBatchedPickler apply() {
                return new AutoBatchedPickler((Iterator<Object>)this.arrayIterator$1);
            }
            {
                this.arrayIterator$1 = arrayIterator$1;
            }
        });
    }

    public String toSFrame(DataFrame df, String outputDir, String prefix) {
        JavaRDD<byte[]> javaRDDofPickles = this.pickleDataFrame(df);
        String path = outputDir;
        if (outputDir.endsWith("/")) {
            Predef$ predef$ = Predef$.MODULE$;
            path = StringOps$.MODULE$.slice$extension(outputDir, 0, outputDir.length() - 1);
        }
        return this.pySparkToSFrame(javaRDDofPickles, path, prefix, " --encoding=batch --type=dataframe ");
    }

    public String toSFrame(RDD<String> rdd, String outputDir, String prefix) {
        RDD javaRDDofUTF8Strings = rdd.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<byte[]> apply(Iterator<String> iter) {
                Charset cs = Charset.forName("UTF-8");
                return iter.map((Function1)new Serializable(this, cs){
                    public static final long serialVersionUID = 0L;
                    private final Charset cs$1;

                    public final byte[] apply(String s) {
                        return s.getBytes(this.cs$1);
                    }
                    {
                        this.cs$1 = cs$1;
                    }
                });
            }
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        String path = outputDir;
        if (outputDir.endsWith("/")) {
            Predef$ predef$ = Predef$.MODULE$;
            path = StringOps$.MODULE$.slice$extension(outputDir, 0, outputDir.length() - 1);
        }
        return this.pySparkToSFrame((JavaRDD<byte[]>)JavaRDD$.MODULE$.fromRDD(javaRDDofUTF8Strings, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), path, prefix, " --encoding=utf8 --type=rdd ");
    }

    public JavaRDD<byte[]> pySparkToRDD(SparkContext sc, String sframePath, int numPartitions, String additionalArgs) {
        String hostNameNode = this.getHadoopNameNode();
        ObjectRef sframePathMod = new ObjectRef((Object)sframePath);
        if (hostNameNode.startsWith("wasb://") && !sframePath.endsWith("frame_idx")) {
            ProcessBuilder pb = new ProcessBuilder(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hadoop", "fs", "-ls", sframePath.replace("hdfs://", hostNameNode)}))));
            Process proc = pb.start();
            String[] pathNames = (String[])Source$.MODULE$.fromInputStream(proc.getInputStream(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toArray(ClassTag$.MODULE$.apply(String.class));
            Predef$.MODULE$.refArrayOps((Object[])pathNames).foreach((Function1)new Serializable(sframePathMod){
                public static final long serialVersionUID = 0L;
                private final ObjectRef sframePathMod$1;

                public final void apply(String x) {
                    if (x.endsWith("frame_idx")) {
                        int startIndex = x.indexOf("wasb://");
                        int endIndex = x.indexOf("frame_idx");
                        this.sframePathMod$1.elem = x.substring(startIndex, endIndex + "frame_idx".length());
                    }
                }
                {
                    this.sframePathMod$1 = sframePathMod$1;
                }
            });
            sframePathMod.elem = ((String)sframePathMod.elem).replace(hostNameNode, "hdfs://");
        }
        String args = new StringBuilder().append((Object)additionalArgs).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--outputDir=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)sframePathMod.elem}))).toString();
        Predef$ predef$ = Predef$.MODULE$;
        RDD qual$2 = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(0, numPartitions), numPartitions, ClassTag$.MODULE$.Int());
        Serializable x$13 = new Serializable(numPartitions, args){
            public static final long serialVersionUID = 0L;
            private final int numPartitions$1;
            private final String args$1;

            public final Iterator<byte[]> apply(int partId, Iterator<Object> iter) {
                return GraphLabUtil$.MODULE$.toRDDIterator(partId, this.numPartitions$1, this.args$1);
            }
            {
                this.numPartitions$1 = numPartitions$1;
                this.args$1 = args$1;
            }
        };
        boolean x$14 = qual$2.mapPartitionsWithIndex$default$2();
        RDD pickledRDD = qual$2.mapPartitionsWithIndex((Function2)x$13, x$14, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        return pickledRDD.toJavaRDD();
    }

    public RDD<HashMap<String, ?>> toRDD(SparkContext sc, String sframePath, int numPartitions) {
        RDD pickledRDD = this.pySparkToRDD(sc, sframePath, numPartitions, "").rdd();
        return pickledRDD.mapPartitions((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<HashMap<String, ?>> apply(Iterator<byte[]> iter) {
                Unpickler unpickle = new Unpickler();
                return iter.map((Function1)new Serializable(this, unpickle){
                    public static final long serialVersionUID = 0L;
                    private final Unpickler unpickle$1;

                    public final HashMap<String, ?> apply(byte[] x$10) {
                        return (HashMap)this.unpickle$1.loads(x$10);
                    }
                    {
                        this.unpickle$1 = unpickle$1;
                    }
                });
            }
        }, pickledRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(HashMap.class));
    }

    public RDD<HashMap<String, ?>> toRDD(SparkContext sc, String sframePath) {
        return this.toRDD(sc, sframePath, sc.defaultParallelism());
    }

    public DataFrame toSparkDataFrame(SparkContext sc, SQLContext sql, String sframePath, int numPartitions) {
        RDD<HashMap<String, ?>> rdd = this.toRDD(sc, sframePath, numPartitions);
        return EvaluateRDD$.MODULE$.toSparkDataFrame(sql, rdd);
    }

    public DataFrame toSparkDataFrame(SparkContext sc, SQLContext sql, String sframePath) {
        RDD<HashMap<String, ?>> rdd = this.toRDD(sc, sframePath);
        return EvaluateRDD$.MODULE$.toSparkDataFrame(sql, rdd);
    }

    private GraphLabUtil$() {
        MODULE$ = this;
    }
}

