/*
 * Decompiled with CFR 0.152.
 */
package com.dato.hadoop.yarn.applications;

import com.dato.hadoop.yarn.applications.Log4jPropertyHelper;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client {
    private static final Log LOG = LogFactory.getLog(Client.class);
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName = "";
    private int amPriority = 0;
    private String amQueue = "";
    private int amMemory = 10;
    private int amVCores = 1;
    private String appMasterJar = "";
    private final String appMasterMainClass;
    private String shellCommand = "";
    private String shellScriptPath = "";
    private String[] shellArgs = new String[0];
    private Map<String, String> shellEnv = new HashMap<String, String>();
    private int shellCmdPriority = 0;
    private int containerMemory = 10;
    private int containerVirtualCores = 1;
    private int numContainers = 1;
    private String log4jPropFile = "";
    private final long clientStartTime = System.currentTimeMillis();
    private long clientTimeout = 0L;
    boolean debugFlag = false;
    private Options opts;
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private static final String appMasterJarPath = "AppMaster.jar";
    private static final String log4jPath = "log4j.properties";
    private static final String linuxShellPath = "ExecShellScript.sh";
    private static final String windowBatPath = "ExecBatScript.bat";

    public static void main(String[] args) {
        boolean result = false;
        try {
            Client client = new Client();
            LOG.info((Object)"Initializing Client");
            try {
                boolean doRun = client.init(args);
                if (!doRun) {
                    System.exit(0);
                }
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getLocalizedMessage());
                client.printUsage();
                System.exit(-1);
            }
            result = client.run();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running CLient", t);
            System.exit(1);
        }
        if (result) {
            LOG.info((Object)"Application completed successfully");
            System.exit(0);
        }
        LOG.error((Object)"Application failed to complete successfully");
        System.exit(2);
    }

    public Client(Configuration conf) throws Exception {
        this("com.dato.hadoop.yarn.applications.ApplicationMaster", conf);
    }

    Client(String appMasterMainClass, Configuration conf) {
        this.conf = conf;
        this.appMasterMainClass = appMasterMainClass;
        this.yarnClient = YarnClient.createYarnClient();
        this.yarnClient.init(conf);
        this.opts = new Options();
        this.opts.addOption("appname", true, "Application Name. Default value - DistributedShell");
        this.opts.addOption("priority", true, "Application Priority. Default 0");
        this.opts.addOption("queue", true, "RM Queue in which this application is to be submitted");
        this.opts.addOption("timeout", true, "Application timeout in milliseconds");
        this.opts.addOption("master_memory", true, "Amount of memory in MB to be requested to run the application master");
        this.opts.addOption("master_vcores", true, "Amount of virtual cores to be requested to run the application master");
        this.opts.addOption("jar", true, "Jar file containing the application master");
        this.opts.addOption("shell_command", true, "Shell command to be executed by the Application Master. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_script", true, "Location of the shell script to be executed. Can only specify either --shell_command or --shell_script");
        this.opts.addOption("shell_args", true, "Command line args for the shell script.Multiple args can be separated by empty space.");
        this.opts.getOption("shell_args").setArgs(-2);
        this.opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        this.opts.addOption("shell_cmd_priority", true, "Priority for the shell command containers");
        this.opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        this.opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        this.opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        this.opts.addOption("log_properties", true, "log4j.properties file");
        this.opts.addOption("debug", false, "Dump out debug information");
        this.opts.addOption("help", false, "Print usage");
    }

    public Client() throws Exception {
        this((Configuration)new YarnConfiguration());
    }

    private void printUsage() {
        new HelpFormatter().printHelp("Client", this.opts);
    }

    public boolean init(String[] args) throws ParseException {
        CommandLine cliParser = new GnuParser().parse(this.opts, args);
        if (args.length == 0) {
            throw new IllegalArgumentException("No args specified for client to initialize");
        }
        if (cliParser.hasOption("log_properties")) {
            String log4jPath = cliParser.getOptionValue("log_properties");
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(Client.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage();
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.debugFlag = true;
        }
        this.appName = cliParser.getOptionValue("appname", "DistributedShell");
        this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        this.amQueue = cliParser.getOptionValue("queue", "default");
        this.amMemory = Integer.parseInt(cliParser.getOptionValue("master_memory", "10"));
        this.amVCores = Integer.parseInt(cliParser.getOptionValue("master_vcores", "1"));
        if (this.amMemory < 0) {
            throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
        }
        if (this.amVCores < 0) {
            throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
        }
        if (!cliParser.hasOption("jar")) {
            throw new IllegalArgumentException("No jar file specified for application master");
        }
        this.appMasterJar = cliParser.getOptionValue("jar");
        if (!cliParser.hasOption("shell_command") && !cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (cliParser.hasOption("shell_command") && cliParser.hasOption("shell_script")) {
            throw new IllegalArgumentException("Can not specify shell_command option and shell_script option at the same time");
        }
        if (cliParser.hasOption("shell_command")) {
            this.shellCommand = cliParser.getOptionValue("shell_command");
        } else {
            this.shellScriptPath = cliParser.getOptionValue("shell_script");
        }
        if (cliParser.hasOption("shell_args")) {
            this.shellArgs = cliParser.getOptionValues("shell_args");
        }
        if (cliParser.hasOption("shell_env")) {
            String[] envs;
            for (String env : envs = cliParser.getOptionValues("shell_env")) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        this.shellCmdPriority = Integer.parseInt(cliParser.getOptionValue("shell_cmd_priority", "0"));
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.containerMemory < 0 || this.containerVirtualCores < 0 || this.numContainers < 1) {
            throw new IllegalArgumentException("Invalid no. of containers or container memory/vcores specified, exiting. Specified containerMemory=" + this.containerMemory + ", containerVirtualCores=" + this.containerVirtualCores + ", numContainer=" + this.numContainers);
        }
        this.clientTimeout = Integer.parseInt(cliParser.getOptionValue("timeout", "0"));
        this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
        return true;
    }

    public boolean run() throws IOException, YarnException {
        LOG.info((Object)"Running Client");
        this.yarnClient.start();
        YarnClientApplication app = this.yarnClient.createApplication();
        GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
        int maxMem = appResponse.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        if (this.amMemory > maxMem) {
            LOG.info((Object)("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem));
            this.amMemory = maxMem;
        }
        int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
        LOG.info((Object)("Max virtual cores capabililty of resources in this cluster " + maxVCores));
        if (this.amVCores > maxVCores) {
            LOG.info((Object)("AM virtual cores specified above max threshold of cluster. Using max value., specified=" + this.amVCores + ", max=" + maxVCores));
            this.amVCores = maxVCores;
        }
        ApplicationSubmissionContext appContext = app.getApplicationSubmissionContext();
        ApplicationId appId = appContext.getApplicationId();
        appContext.setApplicationName(this.appName);
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
        LOG.info((Object)"Copy App Master jar from local filesystem and add to local environment");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.addToLocalResources(fs, this.appMasterJar, appMasterJarPath, appId.getId(), localResources, null);
        if (!this.log4jPropFile.isEmpty()) {
            this.addToLocalResources(fs, this.log4jPropFile, log4jPath, appId.getId(), localResources, null);
        }
        String hdfsShellScriptLocation = "";
        long hdfsShellScriptLen = 0L;
        long hdfsShellScriptTimestamp = 0L;
        if (!this.shellScriptPath.isEmpty()) {
            Path shellSrc = new Path(this.shellScriptPath);
            String shellPathSuffix = this.appName + "/" + appId.getId() + "/" + (Shell.WINDOWS ? windowBatPath : linuxShellPath);
            String[] shellDst = new Path(fs.getHomeDirectory(), shellPathSuffix);
            fs.copyFromLocalFile(false, true, shellSrc, (Path)shellDst);
            hdfsShellScriptLocation = shellDst.toUri().toString();
            FileStatus shellFileStatus = fs.getFileStatus((Path)shellDst);
            hdfsShellScriptLen = shellFileStatus.getLen();
            hdfsShellScriptTimestamp = shellFileStatus.getModificationTime();
        }
        if (!this.shellCommand.isEmpty()) {
            this.addToLocalResources(fs, null, shellCommandPath, appId.getId(), localResources, this.shellCommand);
        }
        if (this.shellArgs.length > 0) {
            this.addToLocalResources(fs, null, shellArgsPath, appId.getId(), localResources, StringUtils.join((Object[])this.shellArgs, (String)" "));
        }
        amContainer.setLocalResources(localResources);
        LOG.info((Object)"Set the environment for the application master");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("DISTRIBUTEDSHELLSCRIPTLOCATION", hdfsShellScriptLocation);
        env.put("DISTRIBUTEDSHELLSCRIPTTIMESTAMP", Long.toString(hdfsShellScriptTimestamp));
        env.put("DISTRIBUTEDSHELLSCRIPTLEN", Long.toString(hdfsShellScriptLen));
        StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$()).append(File.pathSeparatorChar).append("./*");
        for (String string : this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH)) {
            classPathEnv.append(File.pathSeparatorChar);
            classPathEnv.append(string.trim());
        }
        classPathEnv.append(File.pathSeparatorChar).append("./log4j.properties");
        if (this.conf.getBoolean("yarn.is.minicluster", false)) {
            classPathEnv.append(':');
            classPathEnv.append(System.getProperty("java.class.path"));
        }
        env.put("CLASSPATH", classPathEnv.toString());
        amContainer.setEnvironment(env);
        Vector<String> vargs = new Vector<String>(30);
        LOG.info((Object)"Setting up app master command");
        vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
        vargs.add("-Xmx" + this.amMemory + "m");
        vargs.add(this.appMasterMainClass);
        vargs.add("--container_memory " + String.valueOf(this.containerMemory));
        vargs.add("--container_vcores " + String.valueOf(this.containerVirtualCores));
        vargs.add("--num_containers " + String.valueOf(this.numContainers));
        vargs.add("--priority " + String.valueOf(this.shellCmdPriority));
        for (Map.Entry<String, String> entry : this.shellEnv.entrySet()) {
            vargs.add("--shell_env " + entry.getKey() + "=" + entry.getValue());
        }
        if (this.debugFlag) {
            vargs.add("--debug");
        }
        vargs.add("1><LOG_DIR>/AppMaster.stdout");
        vargs.add("2><LOG_DIR>/AppMaster.stderr");
        StringBuilder command = new StringBuilder();
        for (CharSequence charSequence : vargs) {
            command.append(charSequence).append(" ");
        }
        LOG.info((Object)("Completed setting up app master command " + command.toString()));
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(command.toString());
        amContainer.setCommands(commands);
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemory(this.amMemory);
        resource.setVirtualCores(this.amVCores);
        appContext.setResource(resource);
        if (UserGroupInformation.isSecurityEnabled()) {
            Credentials credentials = new Credentials();
            String tokenRenewer = this.conf.get("yarn.resourcemanager.principal");
            if (tokenRenewer == null || tokenRenewer.length() == 0) {
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            if (tokens != null) {
                for (Token token : tokens) {
                    LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
                }
            }
            DataOutputBuffer dob = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            amContainer.setTokens(fsTokens);
        }
        appContext.setAMContainerSpec(amContainer);
        Priority pri = (Priority)Records.newRecord(Priority.class);
        pri.setPriority(this.amPriority);
        appContext.setPriority(pri);
        appContext.setQueue(this.amQueue);
        LOG.info((Object)"Submitting application to ASM");
        this.yarnClient.submitApplication(appContext);
        return this.monitorApplication(appId);
    }

    private boolean monitorApplication(ApplicationId appId) throws YarnException, IOException {
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)"Thread sleep in monitoring loop interrupted");
            }
            ApplicationReport report = this.yarnClient.getApplicationReport(appId);
            LOG.info((Object)("Got application report from ASM for, appId=" + appId.getId() + ", clientToAMToken=" + report.getClientToAMToken() + ", appDiagnostics=" + report.getDiagnostics() + ", appMasterHost=" + report.getHost() + ", appQueue=" + report.getQueue() + ", appMasterRpcPort=" + report.getRpcPort() + ", appStartTime=" + report.getStartTime() + ", yarnAppState=" + report.getYarnApplicationState().toString() + ", distributedFinalState=" + report.getFinalApplicationStatus().toString() + ", appTrackingUrl=" + report.getTrackingUrl() + ", appUser=" + report.getUser()));
            YarnApplicationState state = report.getYarnApplicationState();
            FinalApplicationStatus dsStatus = report.getFinalApplicationStatus();
            if (YarnApplicationState.FINISHED == state) {
                if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                    LOG.info((Object)"Application has completed successfully. Breaking monitoring loop");
                    return true;
                }
                LOG.info((Object)("Application did finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
                return false;
            }
            if (YarnApplicationState.KILLED != state && YarnApplicationState.FAILED != state) continue;
            LOG.info((Object)("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
            return false;
        } while (this.clientTimeout <= 0L || System.currentTimeMillis() <= this.clientStartTime + this.clientTimeout);
        LOG.info((Object)"Reached client specified timeout for application. Killing application");
        this.forceKillApplication(appId);
        return false;
    }

    private void forceKillApplication(ApplicationId appId) throws YarnException, IOException {
        this.yarnClient.killApplication(appId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLocalResources(FileSystem fs, String fileSrcPath, String fileDstPath, int appId, Map<String, LocalResource> localResources, String resources) throws IOException {
        Path dst;
        block3: {
            block2: {
                String suffix = this.appName + "/" + appId + "/" + fileDstPath;
                dst = new Path(fs.getHomeDirectory(), suffix);
                if (fileSrcPath != null) break block2;
                FSDataOutputStream ostream = null;
                try {
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    ostream.writeUTF(resources);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ostream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)ostream);
                break block3;
            }
            fs.copyFromLocalFile(new Path(fileSrcPath), dst);
        }
        FileStatus scFileStatus = fs.getFileStatus(dst);
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        localResources.put(fileDstPath, scRsrc);
    }
}

