class PartOfSpeech(object):
    '''
    Enumeration class of parts of speech for PartOfSpeechExtractor.
    Available parts of speech are as follows:

    PartOfSpeech.ADJ: adjective
    PartOfSpeech.ADP: adposition
    PartOfSpeech.ADV: adverb
    PartOfSpeech.AUX: auxiliary verb
    PartOfSpeech.CONJ: coordinating conjunction
    PartOfSpeech.DET: determiner
    PartOfSpeech.INTJ: interjection
    PartOfSpeech.NOUN: noun
    PartOfSpeech.NUM: numeral
    PartOfSpeech.PART: particle
    PartOfSpeech.PRON: pronoun
    PartOfSpeech.PROPN: proper noun
    PartOfSpeech.PUNCT: punctuation
    PartOfSpeech.SCONJ: subordinating conjunction
    PartOfSpeech.SYM: symbol
    PartOfSpeech.VERB: verb
    PartOfSpeech.X: other
    PartOfSpeech.EOL: end of line
    PartOfSpeech.SPACE: space

    See http://universaldependencies.org/docs/en/pos/all.html for more
    information.
    '''
    ADJ = ('ADJ', 82)
    ADP = ('ADP', 83)
    ADV = ('ADV', 84)
    AUX = ('AUX', 85)
    CONJ = ('CONJ', 86)
    DET = ('DET', 87)
    INTJ = ('INTJ', 88)
    NOUN = ('NOUN', 89)
    NUM = ('NUM', 90)
    PART = ('PART', 91)
    PRON = ('PRON', 92)
    PROPN = ('PROPN', 93)
    PUNCT = ('PUNCT', 94)
    SCONJ = ('SCONJ', 95)
    SYM = ('SYM', 96)
    VERB = ('VERB', 97)
    X = ('X', 98)
    EOL = ('EOL', 99)
    SPACE = ('SPACE', 100)


