# coding: utf-8

"""
    GraphScope FLEX HTTP SERVICE API

    This is a specification for GraphScope FLEX HTTP service based on the OpenAPI 3.0 specification. You can find out more details about specification at [doc](https://swagger.io/specification/v3/).

    The version of the OpenAPI document: 1.0.0
    Contact: graphscope@alibaba-inc.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from graphscope.flex.rest.models.base_edge_type_vertex_type_pair_relations_inner_x_csr_params import BaseEdgeTypeVertexTypePairRelationsInnerXCsrParams
from typing import Optional, Set
from typing_extensions import Self

class BaseEdgeTypeVertexTypePairRelationsInner(BaseModel):
    """
    BaseEdgeTypeVertexTypePairRelationsInner
    """ # noqa: E501
    source_vertex: StrictStr
    destination_vertex: StrictStr
    relation: Optional[StrictStr] = None
    x_csr_params: Optional[BaseEdgeTypeVertexTypePairRelationsInnerXCsrParams] = None
    __properties: ClassVar[List[str]] = ["source_vertex", "destination_vertex", "relation", "x_csr_params"]

    @field_validator('relation')
    def relation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['MANY_TO_MANY', 'ONE_TO_MANY', 'MANY_TO_ONE', 'ONE_TO_ONE']):
            raise ValueError("must be one of enum values ('MANY_TO_MANY', 'ONE_TO_MANY', 'MANY_TO_ONE', 'ONE_TO_ONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BaseEdgeTypeVertexTypePairRelationsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of x_csr_params
        if self.x_csr_params:
            _dict['x_csr_params'] = self.x_csr_params.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BaseEdgeTypeVertexTypePairRelationsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source_vertex": obj.get("source_vertex"),
            "destination_vertex": obj.get("destination_vertex"),
            "relation": obj.get("relation"),
            "x_csr_params": BaseEdgeTypeVertexTypePairRelationsInnerXCsrParams.from_dict(obj["x_csr_params"]) if obj.get("x_csr_params") is not None else None
        })
        return _obj


