"""
    GraphSense API

    GraphSense API provides programmatic access to various ledgers' addresses, entities, blocks, transactions and tags for automated and highly efficient forensics tasks.  # noqa: E501

    The version of the OpenAPI document: 1.14.0
    Contact: contact@ikna.io
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from graphsense.api_client import ApiClient, Endpoint as _Endpoint
from graphsense.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from graphsense.model.address_tags import AddressTags
from graphsense.model.address_txs import AddressTxs
from graphsense.model.entity import Entity
from graphsense.model.entity_addresses import EntityAddresses
from graphsense.model.height import Height
from graphsense.model.links import Links
from graphsense.model.neighbor_entities import NeighborEntities
from graphsense.model.search_result_level1 import SearchResultLevel1


class EntitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __get_entity(
            self,
            currency,
            entity,
            **kwargs
        ):
            """Get an entity  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_entity(currency, entity, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID

            Keyword Args:
                exclude_best_address_tag (bool): Whether to exclude the best address tag. [optional] if omitted the server will use the default value of False
                include_actors (bool): Whether to include information about the actor behind the address. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Entity
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            return self.call_with_http_info(**kwargs)

        self.get_entity = _Endpoint(
            settings={
                'response_type': (Entity,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}',
                'operation_id': 'get_entity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'exclude_best_address_tag',
                    'include_actors',
                ],
                'required': [
                    'currency',
                    'entity',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'exclude_best_address_tag':
                        (bool,),
                    'include_actors':
                        (bool,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'exclude_best_address_tag': 'exclude_best_address_tag',
                    'include_actors': 'include_actors',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'exclude_best_address_tag': 'query',
                    'include_actors': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_entity
        )

        def __list_address_tags_by_entity(
            self,
            currency,
            entity,
            **kwargs
        ):
            """Get address tags for a given entity  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_address_tags_by_entity(currency, entity, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID

            Keyword Args:
                page (str): Resumption token for retrieving the next page. [optional]
                pagesize (int): Number of items returned in a single page. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddressTags
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            return self.call_with_http_info(**kwargs)

        self.list_address_tags_by_entity = _Endpoint(
            settings={
                'response_type': (AddressTags,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/tags',
                'operation_id': 'list_address_tags_by_entity',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'page',
                    'pagesize',
                ],
                'required': [
                    'currency',
                    'entity',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'pagesize',
                ]
            },
            root_map={
                'validations': {
                    ('pagesize',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'page':
                        (str,),
                    'pagesize':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'page': 'page',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'page': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_address_tags_by_entity
        )

        def __list_entity_addresses(
            self,
            currency,
            entity,
            **kwargs
        ):
            """Get an entity's addresses  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_entity_addresses(currency, entity, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID

            Keyword Args:
                page (str): Resumption token for retrieving the next page. [optional]
                pagesize (int): Number of items returned in a single page. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EntityAddresses
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            return self.call_with_http_info(**kwargs)

        self.list_entity_addresses = _Endpoint(
            settings={
                'response_type': (EntityAddresses,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/addresses',
                'operation_id': 'list_entity_addresses',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'page',
                    'pagesize',
                ],
                'required': [
                    'currency',
                    'entity',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'pagesize',
                ]
            },
            root_map={
                'validations': {
                    ('pagesize',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'page':
                        (str,),
                    'pagesize':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'page': 'page',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'page': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_entity_addresses
        )

        def __list_entity_links(
            self,
            currency,
            entity,
            neighbor,
            **kwargs
        ):
            """Get transactions between two entities  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_entity_links(currency, entity, neighbor, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID
                neighbor (int): Neighbor entity

            Keyword Args:
                min_height (Height): Return transactions starting from given height. [optional]
                max_height (Height): Return transactions up to (including) given height. [optional]
                min_date (datetime): min date of txs. [optional]
                max_date (datetime): max date of txs. [optional]
                order (str): Sorting order. [optional] if omitted the server will use the default value of "desc"
                token_currency (str): Return transactions of given token or base currency. [optional]
                page (str): Resumption token for retrieving the next page. [optional]
                pagesize (int): Number of items returned in a single page. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Links
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            kwargs['neighbor'] = \
                neighbor
            return self.call_with_http_info(**kwargs)

        self.list_entity_links = _Endpoint(
            settings={
                'response_type': (Links,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/links',
                'operation_id': 'list_entity_links',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'neighbor',
                    'min_height',
                    'max_height',
                    'min_date',
                    'max_date',
                    'order',
                    'token_currency',
                    'page',
                    'pagesize',
                ],
                'required': [
                    'currency',
                    'entity',
                    'neighbor',
                ],
                'nullable': [
                ],
                'enum': [
                    'order',
                ],
                'validation': [
                    'pagesize',
                ]
            },
            root_map={
                'validations': {
                    ('pagesize',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'neighbor':
                        (int,),
                    'min_height':
                        (Height,),
                    'max_height':
                        (Height,),
                    'min_date':
                        (datetime,),
                    'max_date':
                        (datetime,),
                    'order':
                        (str,),
                    'token_currency':
                        (str,),
                    'page':
                        (str,),
                    'pagesize':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'neighbor': 'neighbor',
                    'min_height': 'min_height',
                    'max_height': 'max_height',
                    'min_date': 'min_date',
                    'max_date': 'max_date',
                    'order': 'order',
                    'token_currency': 'token_currency',
                    'page': 'page',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'neighbor': 'query',
                    'min_height': 'query',
                    'max_height': 'query',
                    'min_date': 'query',
                    'max_date': 'query',
                    'order': 'query',
                    'token_currency': 'query',
                    'page': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_entity_links
        )

        def __list_entity_neighbors(
            self,
            currency,
            entity,
            direction,
            **kwargs
        ):
            """Get an entity's direct neighbors  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_entity_neighbors(currency, entity, direction, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID
                direction (str): Incoming or outgoing neighbors

            Keyword Args:
                only_ids ([int]): Restrict result to given set of comma separated IDs. [optional]
                include_labels (bool): Whether to include labels of first page of address tags. [optional] if omitted the server will use the default value of False
                exclude_best_address_tag (bool): Whether to exclude the best address tag. [optional] if omitted the server will use the default value of False
                include_actors (bool): Whether to include information about the actor behind the address. [optional] if omitted the server will use the default value of False
                page (str): Resumption token for retrieving the next page. [optional]
                pagesize (int): Number of items returned in a single page. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                NeighborEntities
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            kwargs['direction'] = \
                direction
            return self.call_with_http_info(**kwargs)

        self.list_entity_neighbors = _Endpoint(
            settings={
                'response_type': (NeighborEntities,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/neighbors',
                'operation_id': 'list_entity_neighbors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'direction',
                    'only_ids',
                    'include_labels',
                    'exclude_best_address_tag',
                    'include_actors',
                    'page',
                    'pagesize',
                ],
                'required': [
                    'currency',
                    'entity',
                    'direction',
                ],
                'nullable': [
                ],
                'enum': [
                    'direction',
                ],
                'validation': [
                    'pagesize',
                ]
            },
            root_map={
                'validations': {
                    ('pagesize',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('direction',): {

                        "IN": "in",
                        "OUT": "out"
                    },
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'direction':
                        (str,),
                    'only_ids':
                        ([int],),
                    'include_labels':
                        (bool,),
                    'exclude_best_address_tag':
                        (bool,),
                    'include_actors':
                        (bool,),
                    'page':
                        (str,),
                    'pagesize':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'direction': 'direction',
                    'only_ids': 'only_ids',
                    'include_labels': 'include_labels',
                    'exclude_best_address_tag': 'exclude_best_address_tag',
                    'include_actors': 'include_actors',
                    'page': 'page',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'direction': 'query',
                    'only_ids': 'query',
                    'include_labels': 'query',
                    'exclude_best_address_tag': 'query',
                    'include_actors': 'query',
                    'page': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                    'only_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_entity_neighbors
        )

        def __list_entity_txs(
            self,
            currency,
            entity,
            **kwargs
        ):
            """Get all transactions an entity has been involved in  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_entity_txs(currency, entity, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID

            Keyword Args:
                direction (str): Incoming or outgoing transactions. [optional]
                min_height (Height): Return transactions starting from given height. [optional]
                max_height (Height): Return transactions up to (including) given height. [optional]
                min_date (datetime): min date of txs. [optional]
                max_date (datetime): max date of txs. [optional]
                order (str): Sorting order. [optional] if omitted the server will use the default value of "desc"
                token_currency (str): Return transactions of given token or base currency. [optional]
                page (str): Resumption token for retrieving the next page. [optional]
                pagesize (int): Number of items returned in a single page. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                AddressTxs
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            return self.call_with_http_info(**kwargs)

        self.list_entity_txs = _Endpoint(
            settings={
                'response_type': (AddressTxs,),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/txs',
                'operation_id': 'list_entity_txs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'direction',
                    'min_height',
                    'max_height',
                    'min_date',
                    'max_date',
                    'order',
                    'token_currency',
                    'page',
                    'pagesize',
                ],
                'required': [
                    'currency',
                    'entity',
                ],
                'nullable': [
                ],
                'enum': [
                    'direction',
                    'order',
                ],
                'validation': [
                    'pagesize',
                ]
            },
            root_map={
                'validations': {
                    ('pagesize',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('direction',): {

                        "IN": "in",
                        "OUT": "out"
                    },
                    ('order',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'direction':
                        (str,),
                    'min_height':
                        (Height,),
                    'max_height':
                        (Height,),
                    'min_date':
                        (datetime,),
                    'max_date':
                        (datetime,),
                    'order':
                        (str,),
                    'token_currency':
                        (str,),
                    'page':
                        (str,),
                    'pagesize':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'direction': 'direction',
                    'min_height': 'min_height',
                    'max_height': 'max_height',
                    'min_date': 'min_date',
                    'max_date': 'max_date',
                    'order': 'order',
                    'token_currency': 'token_currency',
                    'page': 'page',
                    'pagesize': 'pagesize',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'direction': 'query',
                    'min_height': 'query',
                    'max_height': 'query',
                    'min_date': 'query',
                    'max_date': 'query',
                    'order': 'query',
                    'token_currency': 'query',
                    'page': 'query',
                    'pagesize': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_entity_txs
        )

        def __search_entity_neighbors(
            self,
            currency,
            entity,
            direction,
            key,
            value,
            depth,
            **kwargs
        ):
            """Search deeply for matching neighbors  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.search_entity_neighbors(currency, entity, direction, key, value, depth, async_req=True)
            >>> result = thread.get()

            Args:
                currency (str): The cryptocurrency code (e.g., btc)
                entity (int): The entity ID
                direction (str): Incoming or outgoing neighbors
                key (str): Match neighbors against one and only one of these properties: - the category the entity belongs to - addresses the entity contains - entity ids - total_received: amount the entity received in total - balance: amount the entity holds finally
                value ([str]): If key is - category: comma separated list of category names - addresses: comma separated list of address IDs - entities: comma separated list of entity IDs - total_received/balance: comma separated tuple of (currency, min, max) where currency is 'value' for the cryptocurrency value or an ISO currency code
                depth (int): How many hops should the transaction graph be searched

            Keyword Args:
                breadth (int): How many siblings of each neighbor should be tried. [optional] if omitted the server will use the default value of 16
                skip_num_addresses (int): Skip entities containing more addresses. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [SearchResultLevel1]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['currency'] = \
                currency
            kwargs['entity'] = \
                entity
            kwargs['direction'] = \
                direction
            kwargs['key'] = \
                key
            kwargs['value'] = \
                value
            kwargs['depth'] = \
                depth
            return self.call_with_http_info(**kwargs)

        self.search_entity_neighbors = _Endpoint(
            settings={
                'response_type': ([SearchResultLevel1],),
                'auth': [
                    'api_key'
                ],
                'endpoint_path': '/{currency}/entities/{entity}/search',
                'operation_id': 'search_entity_neighbors',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'currency',
                    'entity',
                    'direction',
                    'key',
                    'value',
                    'depth',
                    'breadth',
                    'skip_num_addresses',
                ],
                'required': [
                    'currency',
                    'entity',
                    'direction',
                    'key',
                    'value',
                    'depth',
                ],
                'nullable': [
                ],
                'enum': [
                    'direction',
                    'key',
                ],
                'validation': [
                    'depth',
                ]
            },
            root_map={
                'validations': {
                    ('depth',): {

                        'inclusive_maximum': 7,
                    },
                },
                'allowed_values': {
                    ('direction',): {

                        "IN": "in",
                        "OUT": "out"
                    },
                    ('key',): {

                        "CATEGORY": "category",
                        "ADDRESSES": "addresses",
                        "ENTITIES": "entities",
                        "TOTAL_RECEIVED": "total_received",
                        "BALANCE": "balance"
                    },
                },
                'openapi_types': {
                    'currency':
                        (str,),
                    'entity':
                        (int,),
                    'direction':
                        (str,),
                    'key':
                        (str,),
                    'value':
                        ([str],),
                    'depth':
                        (int,),
                    'breadth':
                        (int,),
                    'skip_num_addresses':
                        (int,),
                },
                'attribute_map': {
                    'currency': 'currency',
                    'entity': 'entity',
                    'direction': 'direction',
                    'key': 'key',
                    'value': 'value',
                    'depth': 'depth',
                    'breadth': 'breadth',
                    'skip_num_addresses': 'skip_num_addresses',
                },
                'location_map': {
                    'currency': 'path',
                    'entity': 'path',
                    'direction': 'query',
                    'key': 'query',
                    'value': 'query',
                    'depth': 'query',
                    'breadth': 'query',
                    'skip_num_addresses': 'query',
                },
                'collection_format_map': {
                    'value': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__search_entity_neighbors
        )
