<div align="center">

[![Visit Groundx](https://raw.githubusercontent.com/groundxai/groundx-sdks/HEAD/sdks/python/header.png)](https://www.groundx.ai)

# Groundx

Ground Your RAG Apps in Fact not Fiction


[![PyPI](https://img.shields.io/badge/PyPI-v1.3.1-blue)](https://pypi.org/project/groundx-python-sdk/1.3.1)
[![More Info](https://img.shields.io/badge/More%20Info-Click%20Here-orange)](https://www.groundx.ai/)

</div>

## Requirements

Python >=3.7

## Installing

```sh
pip install groundx-python-sdk==1.3.1
```

## Getting Started

```python
from pprint import pprint
from groundx import Groundx, ApiException

groundx = Groundx(
    api_key="YOUR_API_KEY",
)

try:
    # Get API keys
    list_response = groundx.api_keys.list()
    pprint(list_response.body)
    pprint(list_response.body["api_keys"])
    pprint(list_response.headers)
    pprint(list_response.status)
    pprint(list_response.round_trip_time)
except ApiException as e:
    print("Exception when calling APIKeysApi.list: %s\n" % e)
    pprint(e.body)
    if e.status == 405:
        pprint(e.body["message"])
    pprint(e.headers)
    pprint(e.status)
    pprint(e.reason)
    pprint(e.round_trip_time)
```

## Async

`async` support is available by prepending `a` to any method.

```python
import asyncio
from pprint import pprint
from groundx import Groundx, ApiException

groundx = Groundx(
    api_key="YOUR_API_KEY",
)


async def main():
    try:
        # Get API keys
        list_response = await groundx.api_keys.alist()
        pprint(list_response.body)
        pprint(list_response.body["api_keys"])
        pprint(list_response.headers)
        pprint(list_response.status)
        pprint(list_response.round_trip_time)
    except ApiException as e:
        print("Exception when calling APIKeysApi.list: %s\n" % e)
        pprint(e.body)
        if e.status == 405:
            pprint(e.body["message"])
        pprint(e.headers)
        pprint(e.status)
        pprint(e.reason)
        pprint(e.round_trip_time)


asyncio.run(main())
```


## Documentation for API Endpoints

All URIs are relative to *https://api.groundx.ai/api*

Tag | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*API Keys* | [**list**](docs/apis/tags/APIKeysApi.md#list) | **GET** /v1/apikey | Get API keys
*Buckets* | [**get**](docs/apis/tags/BucketsApi.md#get) | **GET** /v1/bucket/{bucketId} | Look up an existing bucket by its ID
*Buckets* | [**list**](docs/apis/tags/BucketsApi.md#list) | **GET** /v1/bucket | Look up existing buckets
*Buckets* | [**update**](docs/apis/tags/BucketsApi.md#update) | **PUT** /v1/bucket/{bucketId} | Update an existing bucket
*Documents* | [**delete**](docs/apis/tags/DocumentsApi.md#delete) | **DELETE** /v1/ingest/document/{documentId} | Delete a document
*Documents* | [**get**](docs/apis/tags/DocumentsApi.md#get) | **GET** /v1/ingest/document/{documentId} | Look up an existing document by its ID
*Documents* | [**get_processing_status_by_id**](docs/apis/tags/DocumentsApi.md#get_processing_status_by_id) | **GET** /v1/ingest/{processId} | Look up the processing status of documents for a given processId
*Documents* | [**list**](docs/apis/tags/DocumentsApi.md#list) | **GET** /v1/ingest/documents | Look up all existing documents
*Documents* | [**lookup**](docs/apis/tags/DocumentsApi.md#lookup) | **GET** /v1/ingest/documents/{id} | Look up existing documents by processId, bucketId, or projectId
*Documents* | [**upload_local**](docs/apis/tags/DocumentsApi.md#upload_local) | **POST** /v1/ingest/documents/local | Upload local documents to GroundX
*Documents* | [**upload_remote**](docs/apis/tags/DocumentsApi.md#upload_remote) | **POST** /v1/ingest/documents/remote | Upload hosted documents to GroundX
*Projects* | [**get**](docs/apis/tags/ProjectsApi.md#get) | **GET** /v1/project/{projectId} | Look up an existing project by its ID
*Projects* | [**list**](docs/apis/tags/ProjectsApi.md#list) | **GET** /v1/project | Look up existing projects
*Projects* | [**update**](docs/apis/tags/ProjectsApi.md#update) | **PUT** /v1/project/{projectId} | Update an existing project
*Search* | [**content**](docs/apis/tags/SearchApi.md#content) | **POST** /v1/search/{id} | Perform a search query of your content


## Author
This Python package is automatically generated by [Konfig](https://konfigthis.com)
