#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class AsyncApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def GetJob(self, userId, jobId, **kwargs):
        """Get job

        Args:
            userId, str: User GUID (required)
            jobId, str: Job Id or Guid (required)
            
        Returns: GetJobResponse
        """

        allParams = ['userId', 'jobId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetJob" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}?format=xml'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetJobResponse')
        return responseObject
        
        
    def GetJobJson(self, userId, jobId, **kwargs):
        """Get job json

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id (required)
            
        Returns: GetJobResponse
        """

        allParams = ['userId', 'jobId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetJobJson" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}?format=json'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetJobResponse')
        return responseObject
        
        
    def GetJobDocuments(self, userId, jobId, format, **kwargs):
        """Get job documents

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id or guid (required)
            format, str: Format (optional)
            
        Returns: GetJobDocumentsResponse
        """

        allParams = ['userId', 'jobId', 'format']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetJobDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}/documents?format={format}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('format' in params):
            replacement = str(self.apiClient.toPathValue(params['format']))
            resourcePath = resourcePath.replace('{' + 'format' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetJobDocumentsResponse')
        return responseObject
        
        
    def CreateJob(self, userId, body, **kwargs):
        """Create job

        Args:
            userId, str: User GUID (required)
            body, JobInfo: Job (required)
            
        Returns: CreateJobResponse
        """

        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateJob" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreateJobResponse')
        return responseObject
        
        
    def DeleteJob(self, userId, jobGuid, **kwargs):
        """Delete draft job

        Args:
            userId, str: User GUID (required)
            jobGuid, str: Job Guid (required)
            
        Returns: DeleteResult
        """

        allParams = ['userId', 'jobGuid']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteJob" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobGuid}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['jobGuid']))
            resourcePath = resourcePath.replace('{' + 'jobGuid' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteResult')
        return responseObject
        
        
    def AddJobDocument(self, userId, jobId, fileId, checkOwnership, formats, **kwargs):
        """Add job document

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id or guid (required)
            fileId, str: File GUID (required)
            checkOwnership, bool: Check Document Ownership (required)
            formats, str: Formats (optional)
            
        Returns: AddJobDocumentResponse
        """

        allParams = ['userId', 'jobId', 'fileId', 'checkOwnership', 'formats']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}/files/{fileId}?check_ownership={checkOwnership}&amp;out_formats={formats}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('checkOwnership' in params):
            replacement = str(self.apiClient.toPathValue(params['checkOwnership']))
            resourcePath = resourcePath.replace('{' + 'checkOwnership' + '}',
                                                replacement)
        if ('formats' in params):
            replacement = str(self.apiClient.toPathValue(params['formats']))
            resourcePath = resourcePath.replace('{' + 'formats' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddJobDocumentResponse')
        return responseObject
        
        
    def DeleteJobDocument(self, userId, jobGuid, documentId, **kwargs):
        """Delete document from job

        Args:
            userId, str: User GUID (required)
            jobGuid, str: Job Guid (required)
            documentId, str: Document GUID (required)
            
        Returns: DeleteResponse
        """

        allParams = ['userId', 'jobGuid', 'documentId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteJobDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobGuid}/documents/{documentId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobGuid' in params):
            replacement = str(self.apiClient.toPathValue(params['jobGuid']))
            resourcePath = resourcePath.replace('{' + 'jobGuid' + '}',
                                                replacement)
        if ('documentId' in params):
            replacement = str(self.apiClient.toPathValue(params['documentId']))
            resourcePath = resourcePath.replace('{' + 'documentId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteResponse')
        return responseObject
        
        
    def AddJobDocumentUrl(self, userId, jobId, absoluteUrl, formats, **kwargs):
        """Add job document url

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id (required)
            absoluteUrl, str: Absolute Url (required)
            formats, str: Formats (optional)
            
        Returns: AddJobDocumentResponse
        """

        allParams = ['userId', 'jobId', 'absoluteUrl', 'formats']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocumentUrl" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}/urls?absolute_url={absoluteUrl}&amp;out_formats={formats}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('absoluteUrl' in params):
            replacement = str(self.apiClient.toPathValue(params['absoluteUrl']))
            resourcePath = resourcePath.replace('{' + 'absoluteUrl' + '}',
                                                replacement)
        if ('formats' in params):
            replacement = str(self.apiClient.toPathValue(params['formats']))
            resourcePath = resourcePath.replace('{' + 'formats' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddJobDocumentResponse')
        return responseObject
        
        
    def UpdateJob(self, userId, jobId, body, **kwargs):
        """Update job

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id or Guid (required)
            body, JobInfo: Job (required)
            
        Returns: UpdateJobResponse
        """

        allParams = ['userId', 'jobId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateJob" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/{jobId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateJobResponse')
        return responseObject
        
        
    def GetJobs(self, userId, pageIndex, pageSize, datetime, status, actions, excludedActions, **kwargs):
        """Get jobs

        Args:
            userId, str: User GUID (required)
            pageIndex, str: Page Index (optional)
            pageSize, str: Page Size (optional)
            datetime, str: Date (optional)
            status, str: Status (optional)
            actions, str: Actions (optional)
            excludedActions, str: Excluded actions (optional)
            
        Returns: GetJobsResponse
        """

        allParams = ['userId', 'pageIndex', 'pageSize', 'datetime', 'status', 'actions', 'excludedActions']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetJobs" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs?page={pageIndex}&amp;count={pageSize}&amp;date={date}&amp;status={status}&amp;actions={actions}&amp;excluded_actions={excludedActions}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('pageIndex' in params):
            replacement = str(self.apiClient.toPathValue(params['pageIndex']))
            resourcePath = resourcePath.replace('{' + 'pageIndex' + '}',
                                                replacement)
        if ('pageSize' in params):
            replacement = str(self.apiClient.toPathValue(params['pageSize']))
            resourcePath = resourcePath.replace('{' + 'pageSize' + '}',
                                                replacement)
        if ('datetime' in params):
            replacement = str(self.apiClient.toPathValue(params['datetime']))
            resourcePath = resourcePath.replace('{' + 'date' + '}',
                                                replacement)
        if ('status' in params):
            replacement = str(self.apiClient.toPathValue(params['status']))
            resourcePath = resourcePath.replace('{' + 'status' + '}',
                                                replacement)
        if ('actions' in params):
            replacement = str(self.apiClient.toPathValue(params['actions']))
            resourcePath = resourcePath.replace('{' + 'actions' + '}',
                                                replacement)
        if ('excludedActions' in params):
            replacement = str(self.apiClient.toPathValue(params['excludedActions']))
            resourcePath = resourcePath.replace('{' + 'excludedActions' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetJobsResponse')
        return responseObject
        
        
    def GetJobsDocuments(self, userId, pageIndex, pageSize, actions, excludedActions, orderBy, orderAsc, **kwargs):
        """Get jobs documents

        Args:
            userId, str: User GUID (required)
            pageIndex, str: Page Index (optional)
            pageSize, str: Page Size (optional)
            actions, str: Actions (optional)
            excludedActions, str: Excluded actions (optional)
            orderBy, str: Order by (optional)
            orderAsc, bool: Order asc (optional)
            
        Returns: GetJobsDocumentsResponse
        """

        allParams = ['userId', 'pageIndex', 'pageSize', 'actions', 'excludedActions', 'orderBy', 'orderAsc']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetJobsDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/jobs/documents?page={pageIndex}&amp;count={pageSize}&amp;actions={actions}&amp;excluded_actions={excludedActions}&amp;order_by={orderBy}&amp;order_asc={orderAsc}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('pageIndex' in params):
            replacement = str(self.apiClient.toPathValue(params['pageIndex']))
            resourcePath = resourcePath.replace('{' + 'pageIndex' + '}',
                                                replacement)
        if ('pageSize' in params):
            replacement = str(self.apiClient.toPathValue(params['pageSize']))
            resourcePath = resourcePath.replace('{' + 'pageSize' + '}',
                                                replacement)
        if ('actions' in params):
            replacement = str(self.apiClient.toPathValue(params['actions']))
            resourcePath = resourcePath.replace('{' + 'actions' + '}',
                                                replacement)
        if ('excludedActions' in params):
            replacement = str(self.apiClient.toPathValue(params['excludedActions']))
            resourcePath = resourcePath.replace('{' + 'excludedActions' + '}',
                                                replacement)
        if ('orderBy' in params):
            replacement = str(self.apiClient.toPathValue(params['orderBy']))
            resourcePath = resourcePath.replace('{' + 'orderBy' + '}',
                                                replacement)
        if ('orderAsc' in params):
            replacement = str(self.apiClient.toPathValue(params['orderAsc']))
            resourcePath = resourcePath.replace('{' + 'orderAsc' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetJobsDocumentsResponse')
        return responseObject
        
        
    def Convert(self, userId, fileId, targetType, emailResults, description, printScript, callbackUrl, **kwargs):
        """Convert

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            targetType, str: Target type (optional)
            emailResults, str: Email results (optional)
            description, str: Description (optional)
            printScript, bool: Print (optional)
            callbackUrl, str: Callback url (optional)
            
        Returns: ConvertResponse
        """

        allParams = ['userId', 'fileId', 'targetType', 'emailResults', 'description', 'printScript', 'callbackUrl']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method Convert" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/async/{userId}/files/{fileId}?new_type={targetType}&amp;email_results={emailResults}&amp;new_description={description}&amp;print_script={printScript}&amp;callback={callbackUrl}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('targetType' in params):
            replacement = str(self.apiClient.toPathValue(params['targetType']))
            resourcePath = resourcePath.replace('{' + 'targetType' + '}',
                                                replacement)
        if ('emailResults' in params):
            replacement = str(self.apiClient.toPathValue(params['emailResults']))
            resourcePath = resourcePath.replace('{' + 'emailResults' + '}',
                                                replacement)
        if ('description' in params):
            replacement = str(self.apiClient.toPathValue(params['description']))
            resourcePath = resourcePath.replace('{' + 'description' + '}',
                                                replacement)
        if ('printScript' in params):
            replacement = str(self.apiClient.toPathValue(params['printScript']))
            resourcePath = resourcePath.replace('{' + 'printScript' + '}',
                                                replacement)
        if ('callbackUrl' in params):
            replacement = str(self.apiClient.toPathValue(params['callbackUrl']))
            resourcePath = resourcePath.replace('{' + 'callbackUrl' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ConvertResponse')
        return responseObject
        
        
    


