#!/usr/bin/env python
"""
WordAPI.py
Copyright 2012 Wordnik, Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *


class MergeApi(object):

    def __init__(self, apiClient):
      self.apiClient = apiClient

    
    def AddJobDocumentDataSource(self, userId, jobId, fileId, datasourceId, **kwargs):
        """Add job document datasource

        Args:
            userId, str: User GUID (required)
            jobId, str: Job indetifier (required)
            fileId, str: File indetifier (required)
            datasourceId, str: Datasource indetifier (required)
            
        Returns: AddDocumentDataSourceResponse
        """

        allParams = ['userId', 'jobId', 'fileId', 'datasourceId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocumentDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentDataSourceResponse')
        return responseObject
        
        
    def AddJobDocumentDataSourceFields(self, userId, jobId, fileId, body, **kwargs):
        """Add job document datasource fields

        Args:
            userId, str: User GUID (required)
            jobId, str: Job id (required)
            fileId, str: File GUID (required)
            body, List[DatasourceField]: Fields (required)
            
        Returns: AddDocumentDataSourceResponse
        """

        allParams = ['userId', 'jobId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddJobDocumentDataSourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('jobId' in params):
            replacement = str(self.apiClient.toPathValue(params['jobId']))
            resourcePath = resourcePath.replace('{' + 'jobId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentDataSourceResponse')
        return responseObject
        
        
    def FillQuestionnaire(self, userId, collectorId, datasourceId, targetType, emailResults, **kwargs):
        """Merge datasource

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Collector global unique identifier to fill (required)
            datasourceId, str: Datasource identifier (required)
            targetType, str: Filled document type (optional)
            emailResults, str: Email results (optional)
            
        Returns: MergeTemplateResponse
        """

        allParams = ['userId', 'collectorId', 'datasourceId', 'targetType', 'emailResults']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method FillQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}/datasources/{datasourceId}?new_type={targetType}&amp;email_results={emailResults}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        if ('targetType' in params):
            replacement = str(self.apiClient.toPathValue(params['targetType']))
            resourcePath = resourcePath.replace('{' + 'targetType' + '}',
                                                replacement)
        if ('emailResults' in params):
            replacement = str(self.apiClient.toPathValue(params['emailResults']))
            resourcePath = resourcePath.replace('{' + 'emailResults' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def MergeDatasource(self, userId, fileId, datasourceId, targetType, emailResults, **kwargs):
        """Merge datasource

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            datasourceId, str: Datasource id (required)
            targetType, str: Target type (optional)
            emailResults, str: Email results (optional)
            
        Returns: MergeTemplateResponse
        """

        allParams = ['userId', 'fileId', 'datasourceId', 'targetType', 'emailResults']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MergeDatasource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/datasources/{datasourceId}?new_type={targetType}&amp;email_results={emailResults}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        if ('targetType' in params):
            replacement = str(self.apiClient.toPathValue(params['targetType']))
            resourcePath = resourcePath.replace('{' + 'targetType' + '}',
                                                replacement)
        if ('emailResults' in params):
            replacement = str(self.apiClient.toPathValue(params['emailResults']))
            resourcePath = resourcePath.replace('{' + 'emailResults' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def MergeDatasourceFields(self, userId, fileId, targetType, emailResults, assemblyName, body, **kwargs):
        """Merge datasource fields

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            targetType, str: Target type (optional)
            emailResults, str: Email results (optional)
            assemblyName, str: Assembly name (optional)
            body, List[DatasourceField]: Fields (required)
            
        Returns: MergeTemplateResponse
        """

        allParams = ['userId', 'fileId', 'targetType', 'emailResults', 'assemblyName', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method MergeDatasourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/datasources?new_type={targetType}&amp;email_results={emailResults}&amp;assembly_name={assemblyName}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('targetType' in params):
            replacement = str(self.apiClient.toPathValue(params['targetType']))
            resourcePath = resourcePath.replace('{' + 'targetType' + '}',
                                                replacement)
        if ('emailResults' in params):
            replacement = str(self.apiClient.toPathValue(params['emailResults']))
            resourcePath = resourcePath.replace('{' + 'emailResults' + '}',
                                                replacement)
        if ('assemblyName' in params):
            replacement = str(self.apiClient.toPathValue(params['assemblyName']))
            resourcePath = resourcePath.replace('{' + 'assemblyName' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'MergeTemplateResponse')
        return responseObject
        
        
    def GetQuestionnaire(self, userId, questionnaireId, **kwargs):
        """Get questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: GetQuestionnaireResponse
        """

        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireResponse')
        return responseObject
        
        
    def GetQuestionnaires(self, userId, **kwargs):
        """Get questionnaires

        Args:
            userId, str: User GUID (required)
            status, str: Questionnaire status to filter by (optional)
            pageNumber, int: Page number to return questionnaires on (optional)
            pageSize, int: Number of questionnaires to return (optional)
            
        Returns: GetQuestionnairesResponse
        """

        allParams = ['userId', 'status', 'pageNumber', 'pageSize']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaires" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires?status={status}&amp;page_number={pageNumber}&amp;page_size={pageSize}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('status' in params):
            queryParams['status'] = self.apiClient.toPathValue(params['status'])
        if ('pageNumber' in params):
            queryParams['pageNumber'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageSize' in params):
            queryParams['pageSize'] = self.apiClient.toPathValue(params['pageSize'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnairesResponse')
        return responseObject
        
        
    def CreateQuestionnaire(self, userId, body, **kwargs):
        """Create questionnaire

        Args:
            userId, str: User GUID (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: CreateQuestionnaireResponse
        """

        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'CreateQuestionnaireResponse')
        return responseObject
        
        
    def UpdateQuestionnaire(self, userId, questionnaireId, body, **kwargs):
        """Update questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: UpdateQuestionnaireResponse
        """

        allParams = ['userId', 'questionnaireId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireResponse')
        return responseObject
        
        
    def DeleteQuestionnaire(self, userId, questionnaireId, **kwargs):
        """Delete questionnaire

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: DeleteQuestionnaireResponse
        """

        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireResponse')
        return responseObject
        
        
    def GetDocumentQuestionnaires(self, userId, fileId, **kwargs):
        """Get document questionnaires

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentQuestionnairesResponse
        """

        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentQuestionnaires" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentQuestionnairesResponse')
        return responseObject
        
        
    def CreateDocumentQuestionnaire(self, userId, fileId, body, **kwargs):
        """Create document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            body, QuestionnaireInfo: Questionnaire (required)
            
        Returns: AddDocumentQuestionnaireResponse
        """

        allParams = ['userId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method CreateDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentQuestionnaireResponse')
        return responseObject
        
        
    def AddDocumentQuestionnaire(self, userId, fileId, questionnaireId, **kwargs):
        """Add document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: AddDocumentQuestionnaireResponse
        """

        allParams = ['userId', 'fileId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDocumentQuestionnaireResponse')
        return responseObject
        
        
    def DeleteDocumentQuestionnaire(self, userId, fileId, questionnaireId, **kwargs):
        """Delete document questionnaire

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            questionnaireId, str: Questionnaire id (required)
            
        Returns: DeleteDocumentQuestionnaireResponse
        """

        allParams = ['userId', 'fileId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteDocumentQuestionnaire" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteDocumentQuestionnaireResponse')
        return responseObject
        
        
    def AddDataSource(self, userId, body, **kwargs):
        """Add datasource

        Args:
            userId, str: User GUID (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """

        allParams = ['userId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def UpdateDataSource(self, userId, datasourceId, body, **kwargs):
        """Update datasource

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """

        allParams = ['userId', 'datasourceId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def UpdateDataSourceFields(self, userId, datasourceId, body, **kwargs):
        """Update datasource fields

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            body, Datasource: Datasource (required)
            
        Returns: AddDatasourceResponse
        """

        allParams = ['userId', 'datasourceId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateDataSourceFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}/fields'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddDatasourceResponse')
        return responseObject
        
        
    def DeleteDataSource(self, userId, datasourceId, **kwargs):
        """Delete datasource fields

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            
        Returns: DeleteDatasourceResponse
        """

        allParams = ['userId', 'datasourceId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteDatasourceResponse')
        return responseObject
        
        
    def GetDataSource(self, userId, datasourceId, fields, **kwargs):
        """Get datasource

        Args:
            userId, str: User GUID (required)
            datasourceId, str: Datasource id (required)
            fields, str: Fields (optional)
            
        Returns: GetDatasourceResponse
        """

        allParams = ['userId', 'datasourceId', 'fields']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDataSource" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/datasources/{datasourceId}?field={fields}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('datasourceId' in params):
            replacement = str(self.apiClient.toPathValue(params['datasourceId']))
            resourcePath = resourcePath.replace('{' + 'datasourceId' + '}',
                                                replacement)
        if ('fields' in params):
            replacement = str(self.apiClient.toPathValue(params['fields']))
            resourcePath = resourcePath.replace('{' + 'fields' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDatasourceResponse')
        return responseObject
        
        
    def GetQuestionnaireDataSources(self, userId, questionnaireId, includeFields, **kwargs):
        """Get questionnaire datasources

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: QuestionnaireId id (required)
            includeFields, bool: Include fields (optional)
            
        Returns: GetDatasourcesResponse
        """

        allParams = ['userId', 'questionnaireId', 'includeFields']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireDataSources" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/datasources?include_fields={includeFields}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        if ('includeFields' in params):
            replacement = str(self.apiClient.toPathValue(params['includeFields']))
            resourcePath = resourcePath.replace('{' + 'includeFields' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDatasourcesResponse')
        return responseObject
        
        
    def AddQuestionnaireExecution(self, userId, collectorId, body, **kwargs):
        """Add questionnaire execution

        Args:
            userId, str: User GUID (required)
            collectorId, str: Questionnaire collector id (required)
            body, QuestionnaireExecutionInfo: Execution (required)
            
        Returns: AddQuestionnaireExecutionResponse
        """

        allParams = ['userId', 'collectorId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}/executions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddQuestionnaireExecutionResponse')
        return responseObject
        
        
    def GetQuestionnaireExecutions(self, userId, questionnaireId, **kwargs):
        """Get questionnaire executions

        Args:
            userId, str: User GUID (required)
            questionnaireId, str: QuestionnaireId global unique identifier (required)
            
        Returns: GetQuestionnaireExecutionsResponse
        """

        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireExecutions" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/executions'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireExecutionsResponse')
        return responseObject
        
        
    def DeleteQuestionnaireExecution(self, userId, executionId, **kwargs):
        """Removes questionnaire execution

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            
        Returns: DeleteQuestionnaireExecutionResponse
        """

        allParams = ['userId', 'executionId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireExecutionResponse')
        return responseObject
        
        
    def UpdateQuestionnaireExecution(self, userId, executionId, body, **kwargs):
        """Update questionnaire execution

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            body, QuestionnaireExecutionInfo: Execution (required)
            
        Returns: UpdateQuestionnaireExecutionResponse
        """

        allParams = ['userId', 'executionId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireExecution" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireExecutionResponse')
        return responseObject
        
        
    def UpdateQuestionnaireExecutionStatus(self, userId, executionId, body, **kwargs):
        """Update questionnaire execution status

        Args:
            userId, str: User GUID (required)
            executionId, str: Execution id (required)
            body, str: Status (required)
            
        Returns: UpdateQuestionnaireExecutionResponse
        """

        allParams = ['userId', 'executionId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireExecutionStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/executions/{executionId}/status'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('executionId' in params):
            replacement = str(self.apiClient.toPathValue(params['executionId']))
            resourcePath = resourcePath.replace('{' + 'executionId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireExecutionResponse')
        return responseObject
        
        
    def GetQuestionnaireCollectors(self, userId, questionnaireId, **kwargs):
        """Get questionnaire collectors

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire identifier (required)
            
        Returns: GetQuestionnaireCollectorsResponse
        """

        allParams = ['userId', 'questionnaireId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireCollectors" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/collectors'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireCollectorsResponse')
        return responseObject
        
        
    def GetQuestionnaireCollector(self, userId, collectorId, **kwargs):
        """Returns questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            
        Returns: GetQuestionnaireCollectorResponse
        """

        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetQuestionnaireCollectorResponse')
        return responseObject
        
        
    def AddQuestionnaireCollector(self, userId, questionnaireId, body, **kwargs):
        """Add questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire identifier (required)
            body, QuestionnaireCollectorInfo: Questionnaire collector to be added (required)
            
        Returns: AddQuestionnaireCollectorResponse
        """

        allParams = ['userId', 'questionnaireId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method AddQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/collectors'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'AddQuestionnaireCollectorResponse')
        return responseObject
        
        
    def UpdateQuestionnaireCollector(self, userId, collectorId, body, **kwargs):
        """Update questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            body, QuestionnaireCollectorInfo: Questionnaire collector data (required)
            
        Returns: UpdateQuestionnaireCollectorResponse
        """

        allParams = ['userId', 'collectorId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UpdateQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'UpdateQuestionnaireCollectorResponse')
        return responseObject
        
        
    def DeleteQuestionnaireCollector(self, userId, collectorId, **kwargs):
        """Removes questionnaire collector

        Args:
            userId, str: User global unique identifier (required)
            collectorId, str: Questionnaire collector global unique identifier (required)
            
        Returns: DeleteQuestionnaireCollectorResponse
        """

        allParams = ['userId', 'collectorId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method DeleteQuestionnaireCollector" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/collectors/{collectorId}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('collectorId' in params):
            replacement = str(self.apiClient.toPathValue(params['collectorId']))
            resourcePath = resourcePath.replace('{' + 'collectorId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DeleteQuestionnaireCollectorResponse')
        return responseObject
        
        
    def GetTemplates(self, userId, **kwargs):
        """Get template documents information

        Args:
            userId, str: User global unique identifier (required)
            
        Returns: GetTemplatesResponse
        """

        allParams = ['userId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetTemplates" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/templates'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetTemplatesResponse')
        return responseObject
        
        
    def GetQuestionnaireFields(self, userId, questionnaireId, includeGeometry, **kwargs):
        """Get questionnaire fields

        Args:
            userId, str: User global unique identifier (required)
            questionnaireId, str: Questionnaire global unique identifier (required)
            includeGeometry, bool: A flag indicating whether fields coordinates and size should be included into the response. (optional)
            
        Returns: TemplateFieldsResponse
        """

        allParams = ['userId', 'questionnaireId', 'includeGeometry']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetQuestionnaireFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/merge/{userId}/questionnaires/{questionnaireId}/fields?include_geometry={includeGeometry}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('questionnaireId' in params):
            replacement = str(self.apiClient.toPathValue(params['questionnaireId']))
            resourcePath = resourcePath.replace('{' + 'questionnaireId' + '}',
                                                replacement)
        if ('includeGeometry' in params):
            replacement = str(self.apiClient.toPathValue(params['includeGeometry']))
            resourcePath = resourcePath.replace('{' + 'includeGeometry' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)

        response = self.apiClient.callAPI(resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TemplateFieldsResponse')
        return responseObject
        
        
    


