#!/usr/bin/env python
"""
Copyright 2012 GroupDocs.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
"""
import sys
import os

from models import *
from groupdocs.FileStream import FileStream
from groupdocs.ApiClient import ApiException

class DocApi(object):

    def __init__(self, apiClient):
        self.apiClient = apiClient
        self.__basePath = "https://api.groupdocs.com/v2.0"

    @property
    def basePath(self):
        return self.__basePath
    
    @basePath.setter
    def basePath(self, value):
        self.__basePath = value

    
    def ViewDocument(self, userId, fileId, **kwargs):
        """View Document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            pageNumber, str: Page Number (optional)
            pageCount, str: Page Count (optional)
            width, str: Width (optional)
            quality, str: Quality (optional)
            usePdf, str: Use Pdf (optional)
            
        Returns: ViewDocumentResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'pageNumber', 'pageCount', 'width', 'quality', 'usePdf']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ViewDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/thumbnails?page_number={pageNumber}&page_count={pageCount}&width={width}&quality={quality}&use_pdf={usePdf}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('pageNumber' in params):
            queryParams['page_number'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageCount' in params):
            queryParams['page_count'] = self.apiClient.toPathValue(params['pageCount'])
        if ('width' in params):
            queryParams['width'] = self.apiClient.toPathValue(params['width'])
        if ('quality' in params):
            queryParams['quality'] = self.apiClient.toPathValue(params['quality'])
        if ('usePdf' in params):
            queryParams['use_pdf'] = self.apiClient.toPathValue(params['usePdf'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ViewDocumentResponse')
        return responseObject
        
        
    def ViewDocumentAsHtml(self, userId, fileId, **kwargs):
        """View Document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            pageNumber, str: Page Number (optional)
            pageCount, str: Page Count (optional)
            
        Returns: ViewDocumentResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'pageNumber', 'pageCount']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ViewDocumentAsHtml" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/htmlRepresentations?page_number={pageNumber}&page_count={pageCount}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'POST'

        queryParams = {}
        headerParams = {}

        if ('pageNumber' in params):
            queryParams['page_number'] = self.apiClient.toPathValue(params['pageNumber'])
        if ('pageCount' in params):
            queryParams['page_count'] = self.apiClient.toPathValue(params['pageCount'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'ViewDocumentResponse')
        return responseObject
        
        
    def GetDocumentViews(self, userId, **kwargs):
        """Get Document Views

        Args:
            userId, str: User GUID (required)
            startIndex, str: A historical view entry to start from. Historical entries are sorted from the recent to old ones (optional)
            pageSize, str: The total number of requested entries. If pageSize is equal to -1, all available entries will be returned (optional)
            
        Returns: DocumentViewsResponse
        """
        if( userId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'startIndex', 'pageSize']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentViews" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/views?page_index={startIndex}&page_size={pageSize}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('startIndex' in params):
            queryParams['page_index'] = self.apiClient.toPathValue(params['startIndex'])
        if ('pageSize' in params):
            queryParams['page_size'] = self.apiClient.toPathValue(params['pageSize'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentViewsResponse')
        return responseObject
        
        
    def ShareDocument(self, userId, fileId, body, **kwargs):
        """Share document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            body, List[str]: Sharers (required)
            
        Returns: SharedUsersResponse
        """
        if( userId == None or fileId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ShareDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def UnshareDocument(self, userId, fileId, **kwargs):
        """Unshare document

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: SharedUsersResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UnshareDocument" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def GetFolderSharers(self, userId, folderId, **kwargs):
        """Get folder sharers

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            
        Returns: SharedUsersResponse
        """
        if( userId == None or folderId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'folderId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetFolderSharers" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def ShareFolder(self, userId, folderId, body, **kwargs):
        """Share folder

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            body, List[str]: Sharers (required)
            
        Returns: SharedUsersResponse
        """
        if( userId == None or folderId == None or body == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'folderId', 'body']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method ShareFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def UnshareFolder(self, userId, folderId, **kwargs):
        """Unshare folder

        Args:
            userId, str: User GUID (required)
            folderId, str: Folder Id (required)
            
        Returns: SharedUsersResponse
        """
        if( userId == None or folderId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'folderId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method UnshareFolder" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/folders/{folderId}/sharers'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('folderId' in params):
            replacement = str(self.apiClient.toPathValue(params['folderId']))
            resourcePath = resourcePath.replace('{' + 'folderId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedUsersResponse')
        return responseObject
        
        
    def SetDocumentAccessMode(self, userId, fileId, **kwargs):
        """Set document access mode

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            mode, str: Mode (optional)
            
        Returns: DocumentAccessInfoResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'mode']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetDocumentAccessMode" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/accessinfo?mode={mode}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('mode' in params):
            queryParams['mode'] = self.apiClient.toPathValue(params['mode'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentAccessInfoResponse')
        return responseObject
        
        
    def GetDocumentAccessInfo(self, userId, fileId, **kwargs):
        """Get document access info

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: DocumentAccessInfoResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentAccessInfo" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/accessinfo'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentAccessInfoResponse')
        return responseObject
        
        
    def GetDocumentMetadata(self, userId, fileId, **kwargs):
        """Get document metadata

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentInfoResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentMetadata" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/metadata'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentInfoResponse')
        return responseObject
        
        
    def GetDocumentMetadataByPath(self, userId, path, **kwargs):
        """Returns document metadata

        Args:
            userId, str: User GUID (required)
            path, str: File path to return metadata for (required)
            
        Returns: GetDocumentInfoResponse
        """
        if( userId == None or path == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'path']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentMetadataByPath" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{*path}'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('path' in params):
            replacement = str(self.apiClient.toPathValue(params['path']))
            resourcePath = resourcePath.replace('{' + 'path' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentInfoResponse')
        return responseObject
        
        
    def SetDocumentUserStatus(self, userId, fileId, status, **kwargs):
        """Set document user status

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            status, str: Status (required)
            
        Returns: DocumentUserStatusResponse
        """
        if( userId == None or fileId == None or status == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'status']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetDocumentUserStatus" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/sharer'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('status' in params):
            queryParams['status'] = self.apiClient.toPathValue(params['status'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'DocumentUserStatusResponse')
        return responseObject
        
        
    def GetSharedDocuments(self, userId, sharesTypes, **kwargs):
        """Get shared documents

        Args:
            userId, str: User GUID (required)
            sharesTypes, str: Shares types (optional)
            pageIndex, str: Page index (optional)
            pageSize, str: Page size (optional)
            orderBy, str: Order by (optional)
            orderAsc, bool: Order asc (optional)
            
        Returns: SharedDocumentsResponse
        """
        if( userId == None or sharesTypes == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'sharesTypes', 'pageIndex', 'pageSize', 'orderBy', 'orderAsc']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetSharedDocuments" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/shares/{sharesTypes}?page_index={pageIndex}&page_size={pageSize}&order_by={orderBy}&order_asc={orderAsc}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('pageIndex' in params):
            queryParams['page_index'] = self.apiClient.toPathValue(params['pageIndex'])
        if ('pageSize' in params):
            queryParams['page_size'] = self.apiClient.toPathValue(params['pageSize'])
        if ('orderBy' in params):
            queryParams['order_by'] = self.apiClient.toPathValue(params['orderBy'])
        if ('orderAsc' in params):
            queryParams['order_asc'] = self.apiClient.toPathValue(params['orderAsc'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('sharesTypes' in params):
            replacement = str(self.apiClient.toPathValue(params['sharesTypes']))
            resourcePath = resourcePath.replace('{' + 'sharesTypes' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SharedDocumentsResponse')
        return responseObject
        
        
    def GetTemplateFields(self, userId, fileId, **kwargs):
        """Get template fields

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            includeGeometry, bool: Include geometry (optional)
            
        Returns: TemplateFieldsResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'includeGeometry']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetTemplateFields" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/fields?include_geometry={includeGeometry}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('includeGeometry' in params):
            queryParams['include_geometry'] = self.apiClient.toPathValue(params['includeGeometry'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'TemplateFieldsResponse')
        return responseObject
        
        
    def GetDocumentFormats(self, userId, fileId, **kwargs):
        """Get document formats

        Args:
            userId, str: User GUID (required)
            fileId, str: File GUID (required)
            
        Returns: GetDocumentForeignTypesResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentFormats" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/formats'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetDocumentForeignTypesResponse')
        return responseObject
        
        
    def GetDocumentPageImage(self, userId, fileId, pageNumber, dimension, **kwargs):
        """Returns a stream of bytes representing a particular document page image.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            pageNumber, int: Document page number to get image for. (required)
            dimension, str: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
            quality, int: Image qualiry in range 1-100. (optional)
            usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
            expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
            
        Returns: stream
        """
        if( userId == None or fileId == None or pageNumber == None or dimension == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'pageNumber', 'dimension', 'quality', 'usePdf', 'expiresOn']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPageImage" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/{pageNumber}/images/{dimension}?quality={quality}&use_pdf={usePdf}&expires={expiresOn}&v={version}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('quality' in params):
            queryParams['quality'] = self.apiClient.toPathValue(params['quality'])
        if ('usePdf' in params):
            queryParams['use_pdf'] = self.apiClient.toPathValue(params['usePdf'])
        if ('expiresOn' in params):
            queryParams['expires'] = self.apiClient.toPathValue(params['expiresOn'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('pageNumber' in params):
            replacement = str(self.apiClient.toPathValue(params['pageNumber']))
            resourcePath = resourcePath.replace('{' + 'pageNumber' + '}',
                                                replacement)
        if ('dimension' in params):
            replacement = str(self.apiClient.toPathValue(params['dimension']))
            resourcePath = resourcePath.replace('{' + 'dimension' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def GetDocumentPageHtml(self, userId, fileId, pageNumber, **kwargs):
        """Returns an HTML representantion of a particular document page.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            pageNumber, int: Document page number to get image for. (required)
            expiresOn, bool: The date and time in milliseconds since epoch the URL expires. (optional)
            
        Returns: stream
        """
        if( userId == None or fileId == None or pageNumber == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'pageNumber', 'expiresOn']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPageHtml" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/{pageNumber}/htmlRepresentations?expires={expiresOn}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('expiresOn' in params):
            queryParams['expires'] = self.apiClient.toPathValue(params['expiresOn'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('pageNumber' in params):
            replacement = str(self.apiClient.toPathValue(params['pageNumber']))
            resourcePath = resourcePath.replace('{' + 'pageNumber' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        return self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams, FileStream)
        
    def GetDocumentPagesImageUrls(self, userId, fileId, dimension, **kwargs):
        """Returns a list of URLs pointing to document page images.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            firstPage, int: Document page number to start from. (optional)
            pageCount, int: Page count to return URLs for. (optional)
            dimension, str: Image dimension in format '&lt;width&gt;x&lt;height&gt;' (one or both values can be omitted). (required)
            quality, int: Image qualiry in range 1-100. (optional)
            usePdf, bool: A flag indicating whether a document should be converted to PDF format before generating the image. (optional)
            token, str: A document viewer session token returned by the View Document request. (optional)
            
        Returns: GetImageUrlsResponse
        """
        if( userId == None or fileId == None or dimension == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'firstPage', 'pageCount', 'dimension', 'quality', 'usePdf', 'token']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPagesImageUrls" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/images/{dimension}/urls?first_page={firstPage}&page_count={pageCount}&quality={quality}&use_pdf={usePdf}&token={token}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('firstPage' in params):
            queryParams['first_page'] = self.apiClient.toPathValue(params['firstPage'])
        if ('pageCount' in params):
            queryParams['page_count'] = self.apiClient.toPathValue(params['pageCount'])
        if ('quality' in params):
            queryParams['quality'] = self.apiClient.toPathValue(params['quality'])
        if ('usePdf' in params):
            queryParams['use_pdf'] = self.apiClient.toPathValue(params['usePdf'])
        if ('token' in params):
            queryParams['token'] = self.apiClient.toPathValue(params['token'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        if ('dimension' in params):
            replacement = str(self.apiClient.toPathValue(params['dimension']))
            resourcePath = resourcePath.replace('{' + 'dimension' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetImageUrlsResponse')
        return responseObject
        
        
    def GetDocumentPagesHtmlUrls(self, userId, fileId, **kwargs):
        """Returns a list of URLs pointing to document page HTML representations.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            firstPage, int: Document page number to start from. (optional)
            pageCount, int: Page count to return URLs for. (optional)
            
        Returns: GetImageUrlsResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'firstPage', 'pageCount']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentPagesHtmlUrls" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/pages/htmlRepresentationUrls?first_page={firstPage}&page_count={pageCount}'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('firstPage' in params):
            queryParams['first_page'] = self.apiClient.toPathValue(params['firstPage'])
        if ('pageCount' in params):
            queryParams['page_count'] = self.apiClient.toPathValue(params['pageCount'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetImageUrlsResponse')
        return responseObject
        
        
    def GetEditLock(self, userId, fileId, **kwargs):
        """Locks a document for editing and returns editing metadata.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: GetEditLockResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetEditLock" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/editlock'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetEditLockResponse')
        return responseObject
        
        
    def RemoveEditLock(self, userId, fileId, lockId, **kwargs):
        """Removes edit lock for a document and replaces the document with its edited copy.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            lockId, str: Lock Id. (required)
            
        Returns: RemoveEditLockResponse
        """
        if( userId == None or fileId == None or lockId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId', 'lockId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RemoveEditLock" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/editlock'.replace('*', '')
        pos = resourcePath.find("?")
        if pos != -1:
            resourcePath = resourcePath[0:pos]
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('lockId' in params):
            queryParams['lockId'] = self.apiClient.toPathValue(params['lockId'])
        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'RemoveEditLockResponse')
        return responseObject
        
        
    def GetDocumentTags(self, userId, fileId, **kwargs):
        """Returns tags assigned to the document.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: GetTagsResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method GetDocumentTags" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/tags'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'GET'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'GetTagsResponse')
        return responseObject
        
        
    def SetDocumentTags(self, userId, fileId, **kwargs):
        """Assign tags to the document.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: SetTagsResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method SetDocumentTags" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/tags'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'PUT'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'SetTagsResponse')
        return responseObject
        
        
    def RemoveDocumentTags(self, userId, fileId, **kwargs):
        """Removes tags assigned to the document.

        Args:
            userId, str: GroupDocs user global unique identifier. (required)
            fileId, str: Document global unique identifier. (required)
            
        Returns: RemoveTagsResponse
        """
        if( userId == None or fileId == None ):
            raise ApiException(400, "missing required parameters")
        allParams = ['userId', 'fileId']

        params = locals()
        for (key, val) in params['kwargs'].iteritems():
            if key not in allParams:
                raise TypeError("Got an unexpected keyword argument '%s' to method RemoveDocumentTags" % key)
            params[key] = val
        del params['kwargs']

        resourcePath = '/doc/{userId}/files/{fileId}/tags'.replace('*', '')
        resourcePath = resourcePath.replace('{format}', 'json')
        method = 'DELETE'

        queryParams = {}
        headerParams = {}

        if ('userId' in params):
            replacement = str(self.apiClient.toPathValue(params['userId']))
            resourcePath = resourcePath.replace('{' + 'userId' + '}',
                                                replacement)
        if ('fileId' in params):
            replacement = str(self.apiClient.toPathValue(params['fileId']))
            resourcePath = resourcePath.replace('{' + 'fileId' + '}',
                                                replacement)
        postData = (params['body'] if 'body' in params else None)
        response = self.apiClient.callAPI(self.basePath, resourcePath, method, queryParams,
                                          postData, headerParams)

        if not response:
            return None

        responseObject = self.apiClient.deserialize(response, 'RemoveTagsResponse')
        return responseObject
        
        
    


