# coding: utf-8

"""
    Golem unlimited low level hub API

    API description in Markdown.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gu_rest_api.api_client import ApiClient


class SessionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_session_peers(self, session_id, peer_set, **kwargs):  # noqa: E501
        """Manually adds peers to hub session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_session_peers(session_id, peer_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param list[str] peer_set: (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_session_peers_with_http_info(session_id, peer_set, **kwargs)  # noqa: E501
        else:
            (data) = self.add_session_peers_with_http_info(session_id, peer_set, **kwargs)  # noqa: E501
            return data

    def add_session_peers_with_http_info(self, session_id, peer_set, **kwargs):  # noqa: E501
        """Manually adds peers to hub session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_session_peers_with_http_info(session_id, peer_set, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param list[str] peer_set: (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'peer_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_session_peers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `add_session_peers`")  # noqa: E501
        # verify the required parameter 'peer_set' is set
        if ('peer_set' not in local_var_params or
                local_var_params['peer_set'] is None):
            raise ValueError("Missing the required parameter `peer_set` when calling `add_session_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'peer_set' in local_var_params:
            body_params = local_var_params['peer_set']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/peers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_blob(self, session_id, **kwargs):  # noqa: E501
        """Creates new lob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blob(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param file body:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_blob_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_blob_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def create_blob_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """Creates new lob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_blob_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param file body:
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_blob" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `create_blob`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'body' in local_var_params:
            local_var_files['body'] = local_var_params['body']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/blobs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_deployment(self, session_id, node_id, deployment_spec, **kwargs):  # noqa: E501
        """Creates new deployment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_deployment(session_id, node_id, deployment_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param DeploymentSpec deployment_spec: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_deployment_with_http_info(session_id, node_id, deployment_spec, **kwargs)  # noqa: E501
        else:
            (data) = self.create_deployment_with_http_info(session_id, node_id, deployment_spec, **kwargs)  # noqa: E501
            return data

    def create_deployment_with_http_info(self, session_id, node_id, deployment_spec, **kwargs):  # noqa: E501
        """Creates new deployment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_deployment_with_http_info(session_id, node_id, deployment_spec, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param DeploymentSpec deployment_spec: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'node_id', 'deployment_spec']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_deployment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `create_deployment`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in local_var_params or
                local_var_params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `create_deployment`")  # noqa: E501
        # verify the required parameter 'deployment_spec' is set
        if ('deployment_spec' not in local_var_params or
                local_var_params['deployment_spec'] is None):
            raise ValueError("Missing the required parameter `deployment_spec` when calling `create_deployment`")  # noqa: E501

        if 'node_id' in local_var_params and not re.search(r'0x[0-9a-f]{40}', local_var_params['node_id']):  # noqa: E501
            raise ValueError("Invalid value for parameter `node_id` when calling `create_deployment`, must conform to the pattern `/0x[0-9a-f]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'node_id' in local_var_params:
            path_params['nodeId'] = local_var_params['node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'deployment_spec' in local_var_params:
            body_params = local_var_params['deployment_spec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/peers/{nodeId}/deployments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_session(self, body, **kwargs):  # noqa: E501
        """Creates new hub session.  # noqa: E501

        Allowed fileds:  * name        - human readable session name * expires     - session expiration timestamp * allocation  - resource allocation mode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_session(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HubSession body: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_session_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_session_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_session_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates new hub session.  # noqa: E501

        Allowed fileds:  * name        - human readable session name * expires     - session expiration timestamp * allocation  - resource allocation mode.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_session_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param HubSession body: (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_session" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in local_var_params or
                local_var_params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_blob(self, session_id, blob_id, **kwargs):  # noqa: E501
        """delete_blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_blob(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
            return data

    def delete_blob_with_http_info(self, session_id, blob_id, **kwargs):  # noqa: E501
        """delete_blob  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_blob_with_http_info(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_blob" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `delete_blob`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if ('blob_id' not in local_var_params or
                local_var_params['blob_id'] is None):
            raise ValueError("Missing the required parameter `blob_id` when calling `delete_blob`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blobId'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/blobs/{blobId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_deployment(self, session_id, node_id, deployment_id, **kwargs):  # noqa: E501
        """delete_deployment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_deployment(session_id, node_id, deployment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param str deployment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_deployment_with_http_info(session_id, node_id, deployment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_deployment_with_http_info(session_id, node_id, deployment_id, **kwargs)  # noqa: E501
            return data

    def delete_deployment_with_http_info(self, session_id, node_id, deployment_id, **kwargs):  # noqa: E501
        """delete_deployment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_deployment_with_http_info(session_id, node_id, deployment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param str deployment_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'node_id', 'deployment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_deployment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `delete_deployment`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in local_var_params or
                local_var_params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `delete_deployment`")  # noqa: E501
        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in local_var_params or
                local_var_params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `delete_deployment`")  # noqa: E501

        if 'node_id' in local_var_params and not re.search(r'0x[0-9a-f]{40}', local_var_params['node_id']):  # noqa: E501
            raise ValueError("Invalid value for parameter `node_id` when calling `delete_deployment`, must conform to the pattern `/0x[0-9a-f]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'node_id' in local_var_params:
            path_params['nodeId'] = local_var_params['node_id']  # noqa: E501
        if 'deployment_id' in local_var_params:
            path_params['deploymentId'] = local_var_params['deployment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/peers/{nodeId}/deployments/{deploymentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_session(self, session_id, **kwargs):  # noqa: E501
        """delete_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_session(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_session_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_session_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def delete_session_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """delete_session  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_session_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_session" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `delete_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_blob(self, session_id, blob_id, **kwargs):  # noqa: E501
        """Downloads binary content from the hub  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_blob(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
            return data

    def download_blob_with_http_info(self, session_id, blob_id, **kwargs):  # noqa: E501
        """Downloads binary content from the hub  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_blob_with_http_info(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'blob_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_blob" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `download_blob`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if ('blob_id' not in local_var_params or
                local_var_params['blob_id'] is None):
            raise ValueError("Missing the required parameter `blob_id` when calling `download_blob`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blobId'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/blobs/{blobId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_config(self, session_id, **kwargs):  # noqa: E501
        """Gets configuration from stash  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_config_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_config_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def get_config_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """Gets configuration from stash  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_config_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_hub_info(self, **kwargs):  # noqa: E501
        """get_hub_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hub_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HubInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_hub_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_hub_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_hub_info_with_http_info(self, **kwargs):  # noqa: E501
        """get_hub_info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_hub_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: HubInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_hub_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_session(self, session_id, **kwargs):  # noqa: E501
        """Gets hub session info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_session(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: HubSession
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_session_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_session_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def get_session_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """Gets hub session info  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_session_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: HubSession
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_session" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HubSession',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_blobs(self, session_id, **kwargs):  # noqa: E501
        """Lists currently allocated lobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_blobs(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: list[BlobInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_blobs_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_blobs_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def list_blobs_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """Lists currently allocated lobs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_blobs_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: list[BlobInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_blobs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `list_blobs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/blobs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BlobInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_session_peers(self, session_id, **kwargs):  # noqa: E501
        """List session peers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_session_peers(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: list[PeerInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_session_peers_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_session_peers_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def list_session_peers_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """List session peers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_session_peers_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :return: list[PeerInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_session_peers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `list_session_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/peers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PeerInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sessions(self, **kwargs):  # noqa: E501
        """Lists current hub sessions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sessions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit:
        :param int offset:
        :return: list[HubSession]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_sessions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_sessions_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_sessions_with_http_info(self, **kwargs):  # noqa: E501
        """Lists current hub sessions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sessions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit:
        :param int offset:
        :return: list[HubSession]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sessions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HubSession]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_config(self, session_id, config, **kwargs):  # noqa: E501
        """Sets configuration stash  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_config(session_id, config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param dict(str, object) config: New config stash value (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_config_with_http_info(session_id, config, **kwargs)  # noqa: E501
        else:
            (data) = self.set_config_with_http_info(session_id, config, **kwargs)  # noqa: E501
            return data

    def set_config_with_http_info(self, session_id, config, **kwargs):  # noqa: E501
        """Sets configuration stash  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_config_with_http_info(session_id, config, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param dict(str, object) config: New config stash value (required)
        :return: int
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `set_config`")  # noqa: E501
        # verify the required parameter 'config' is set
        if ('config' not in local_var_params or
                local_var_params['config'] is None):
            raise ValueError("Missing the required parameter `config` when calling `set_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'config' in local_var_params:
            body_params = local_var_params['config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/config', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='int',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_deployment(self, session_id, node_id, deployment_id, commands, **kwargs):  # noqa: E501
        """Sends multiple commands for peer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_deployment(session_id, node_id, deployment_id, commands, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param str deployment_id: (required)
        :param list[Command] commands: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_deployment_with_http_info(session_id, node_id, deployment_id, commands, **kwargs)  # noqa: E501
        else:
            (data) = self.update_deployment_with_http_info(session_id, node_id, deployment_id, commands, **kwargs)  # noqa: E501
            return data

    def update_deployment_with_http_info(self, session_id, node_id, deployment_id, commands, **kwargs):  # noqa: E501
        """Sends multiple commands for peer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_deployment_with_http_info(session_id, node_id, deployment_id, commands, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param str node_id: GU Network node identifier (required)
        :param str deployment_id: (required)
        :param list[Command] commands: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'node_id', 'deployment_id', 'commands']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_deployment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `update_deployment`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in local_var_params or
                local_var_params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `update_deployment`")  # noqa: E501
        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in local_var_params or
                local_var_params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `update_deployment`")  # noqa: E501
        # verify the required parameter 'commands' is set
        if ('commands' not in local_var_params or
                local_var_params['commands'] is None):
            raise ValueError("Missing the required parameter `commands` when calling `update_deployment`")  # noqa: E501

        if 'node_id' in local_var_params and not re.search(r'0x[0-9a-f]{40}', local_var_params['node_id']):  # noqa: E501
            raise ValueError("Invalid value for parameter `node_id` when calling `update_deployment`, must conform to the pattern `/0x[0-9a-f]{40}/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'node_id' in local_var_params:
            path_params['nodeId'] = local_var_params['node_id']  # noqa: E501
        if 'deployment_id' in local_var_params:
            path_params['deploymentId'] = local_var_params['deployment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'commands' in local_var_params:
            body_params = local_var_params['commands']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/peers/{nodeId}/deployments/{deploymentId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_session(self, session_id, **kwargs):  # noqa: E501
        """Hub session update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_session(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param HubSessionCommand changes:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_session_with_http_info(session_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_session_with_http_info(session_id, **kwargs)  # noqa: E501
            return data

    def update_session_with_http_info(self, session_id, **kwargs):  # noqa: E501
        """Hub session update  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_session_with_http_info(session_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param HubSessionCommand changes:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'changes']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_session" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `update_session`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'changes' in local_var_params:
            body_params = local_var_params['changes']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_blob(self, session_id, blob_id, **kwargs):  # noqa: E501
        """Uploads a binary content to the hub.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_blob(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :param file body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upload_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_blob_with_http_info(session_id, blob_id, **kwargs)  # noqa: E501
            return data

    def upload_blob_with_http_info(self, session_id, blob_id, **kwargs):  # noqa: E501
        """Uploads a binary content to the hub.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_blob_with_http_info(session_id, blob_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int session_id: HUB session id (required)
        :param int blob_id: Blob identifier (required)
        :param file body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['session_id', 'blob_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_blob" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'session_id' is set
        if ('session_id' not in local_var_params or
                local_var_params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `upload_blob`")  # noqa: E501
        # verify the required parameter 'blob_id' is set
        if ('blob_id' not in local_var_params or
                local_var_params['blob_id'] is None):
            raise ValueError("Missing the required parameter `blob_id` when calling `upload_blob`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'session_id' in local_var_params:
            path_params['sessionId'] = local_var_params['session_id']  # noqa: E501
        if 'blob_id' in local_var_params:
            path_params['blobId'] = local_var_params['blob_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['serviceToken', 'systemName']  # noqa: E501

        return self.api_client.call_api(
            '/sessions/{sessionId}/blobs/{blobId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
