# ગુજરાતી પાઈથન રક્ષકો (Gujarati Python Agents)

આ પ્રોજેક્ટમાં કોડની ગુણવત્તા જાળવવા માટે ત્રણ મુખ્ય "રક્ષકો" (Agents) બનાવવામાં આવ્યા છે. આ રક્ષકો તમારા કોડને તપાસે છે અને ભૂલો સુધારવા માટે સૂચનો આપે છે.

## 🛡️ રક્ષકોની યાદી (List of Agents)

### 1. વ્યાકરણ રક્ષક (Vyakaran Rakshak - Grammar Agent)
*   **ફાઈલ**: `agents/vyakarana_rakshak.py`
*   **કાર્ય**: આ રક્ષક ગુજરાતી કીવર્ડ્સની જોડણી (spelling) તપાસે છે.
*   **ઉદાહરણ**: જો તમે `છાપો` ની જગ્યાએ `પ્રિન્ટ` લખ્યું હોય, તો આ રક્ષક તમને ચેતવણી આપશે.

### 2. બંધારણ રક્ષક (Bandharan Rakshak - Syntax Agent)
*   **ફાઈલ**: `agents/bandharan_rakshak.py`
*   **કાર્ય**: આ રક્ષક કોડનું બંધારણ (structure) તપાસે છે.
*   **મુખ્ય તપાસ**:
    *   શું તમે અંગ્રેજી અને ગુજરાતી કીવર્ડ્સ મિક્સ કર્યા છે? (દા.ત. `if સાચું:`)
    *   શું તમારું ઈન્ડેન્ટેશન (indentation) યોગ્ય છે (4 સ્પેસ)?

### 3. શૈલી રક્ષક (Shaili Rakshak - Style Agent)
*   **ફાઈલ**: `agents/shaili_rakshak.py`
*   **કાર્ય**: આ રક્ષક કોડ લખવાની શૈલી (style) તપાસે છે.
*   **મુખ્ય તપાસ**:
    *   શું દરેક ફંક્શનમાં સમજૂતી (docstring) છે?
    *   શું કોઈ લાઈન ખૂબ લાંબી છે (>100 અક્ષરો)?

### 4. સુરક્ષા રક્ષક (Suraksha Rakshak - Security Agent)
*   **ફાઈલ**: `agents/suraksha_rakshak.py`
*   **કાર્ય**: કોડમાં રહેલી સંભવિત સુરક્ષા ખામીઓ શોધે છે.
*   **મુખ્ય તપાસ**:
    *   ભયજનક ફંક્શનનો ઉપયોગ (`eval`, `exec`).
    *   હાર્ડકોડેડ પાસવર્ડ કે કી (secret keys).

### 5. કાર્યક્ષમતા રક્ષક (Karyakshamata Rakshak - Performance Agent)
*   **ફાઈલ**: `agents/karyakshamata_rakshak.py`
*   **કાર્ય**: કોડને ધીમો પડતા પરિબળો શોધે છે.
*   **મુખ્ય તપાસ**:
    *   ફંક્શનની અંદર ઈમ્પોર્ટ (imports inside functions).
    *   ગ્લોબલ વેરિએબલનો બિનજરૂરી ઉપયોગ.

### 6. જટિલતા રક્ષક (Jatilata Rakshak - Complexity Agent)
*   **ફાઈલ**: `agents/jatilata_rakshak.py`
*   **કાર્ય**: કોડ કેટલો જટિલ છે તે માપે છે.
*   **મુખ્ય તપાસ**:
    *   બહુ ઊંડું નેસ્ટિંગ (Deep nesting > 4 levels).
    *   ખૂબ લાંબા ફંક્શન્સ (> 50 લાઈનો).

---

## 🚀 કેવી રીતે વાપરવું (How to Use)

તમે `run_agents.py` સ્ક્રિપ્ટ દ્વારા બધા રક્ષકોને એકસાથે ચલાવી શકો છો.

### કમાન્ડ (Command)

```bash
# એક ફાઈલ તપાસવા માટે
python run_agents.py તમારી_ફાઈલ.py

# આખી ડાયરેક્ટરી તપાસવા માટે
python run_agents.py પ્રોજેક્ટ_ફોલ્ડર/
```

### આઉટપુટ ઉદાહરણ (Example Output)

```text
ચકાસણી ચાલુ છે: main_code.py
--------------------------------------------------
⚠️  Line 10: શબ્દ 'પ્રિન્ટ' ને બદલે 'છાપો' વાપરો.
ℹ️  Line 12: ઈન્ડેન્ટેશન 4 સ્પેસના ગુણાંકમાં હોવું જોઈએ (વર્તમાન: 3).
⚠️  Line 15: ફંક્શન માટે ડોક્યુમેન્ટેશન (docstring) ખૂટે છે.
✅ કોઈ સમસ્યા મળી નથી. કોડ ઉત્તમ છે! (જો કોઈ ભૂલ ન હોય તો)
```

## 🛠️ ડેવલપર્સ માટે (For Developers)

નવા રક્ષક ઉમેરવા માટે:
1. `agents/` ફોલ્ડરમાં નવી ફાઈલ બનાવો (દા.ત. `new_rakshak.py`).
2. તેમાં `check_file(content)` મેથડ સાથેનો ક્લાસ બનાવો.
3. `run_agents.py` માં નવા રક્ષકને ઈમ્પોર્ટ કરો અને લિસ્ટમાં ઉમેરો.
