# ગુજરાતી પાઈથન (Gujarati Python)

ગુજરાતી ભાષામાં પાઈથન પ્રોગ્રામિંગ - સંપૂર્ણ ગુજરાતી સિન્ટેક્સ અને કીવર્ડ્સ સાથે.

## 📖 પરિચય (Introduction)

આ પ્રોજેક્ટ પાઈથન પ્રોગ્રામિંગ લેંગ્વેજને સંપૂર્ણ ગુજરાતી ભાષામાં ઉપલબ્ધ બનાવે છે. બધા કીવર્ડ્સ, ફંક્શન નામો, વેરિએબલ નામો અને ડોક્યુમેન્ટેશન ગુજરાતી ભાષામાં લખવામાં આવે છે.

## 🚀 સ્થાપન (Installation)

### આવશ્યકતાઓ (Requirements)
- Python 3.6 અથવા તેનાં કરતાં વધુ વર્ઝન
- pip પેકેજ મેનેજર

### સ્થાપન પગલાં (Installation Steps)

```bash
# pip દ્વારા સ્થાપિત કરો (Recommended)
pip install gujarati-python
```

અથવા જો તમે લેટેસ્ટ ડેવલપમેન્ટ વર્ઝન ઇચ્છતા હોવ તો:

```bash
git clone https://github.com/ambicuity/gujarati-python.git
cd gujarati-python
pip install .
```

### ઉપયોગ (Usage)

```bash
# ગુજરાતી ફાઈલ ચલાવો
gujarati-python your_file.py

# ઇન્ટરએક્ટિવ મોડ (REPL) શરૂ કરો
gujarati-python
```

## 💡 ઉપયોગ (Usage)

### મૂળભૂત ઉદાહરણ (Basic Example)

```python
ઈમ્પોર્ટ ગણિત

# આ ફંક્શન બે નંબરોનો ઉમેરો કરે છે
ડેફ ઉમેરો(અ, બ):
    """
    બે નંબરોનો ઉમેરો કરવા માટેનું ફંક્શન
    
    પેરામીટર:
        અ: પહેલો નંબર
        બ: બીજો નંબર
    
    પરત આપે: બંને નંબરોનો ઉમેરો
    """
    પરત આપો અ + બ

# મુખ્ય કોડ
જો __name__ == "__main__":
    સંખ્યા1 = 10
    સંખ્યા2 = 20
    પરિણામ = ઉમેરો(સંખ્યા1, સંખ્યા2)
    છાપો(f"પરિણામ છે: {પરિણામ}")
```

## 🔤 કીવર્ડ ટ્રાન્સલેશન (Keyword Translation)

| અંગ્રેજી કીવર્ડ | ગુજરાતી કીવર્ડ | ઉદાહરણ |
|------------|------------|------|
| import | ઈમ્પોર્ટ | `ઈમ્પોર્ટ ગણિત` |
| def | ડેફ | `ડેફ મારું_ફંક્શન():` |
| class | ક્લાસ | `ક્લાસ મારો_ક્લાસ:` |
| for | ફોર | `ફોર i ઇન રેંજ(10):` |
| while | વ્હાઈલ | `વ્હાઈલ શરત:` |
| if | જો | `જો શરત:` |
| else | નહીં તો | `નહીં તો:` |
| elif | અથવા જો | `અથવા જો શરત:` |
| return | પરત આપો | `પરત આપો પરિણામ` |
| print | છાપો | `છાપો("હેલો વર્લ્ડ")` |
| True | સાચું | `જો સાચું:` |
| False | ખોટું | `જો ખોટું:` |
| None | કંઈ નહીં | `પરત આપો કંઈ નહીં` |
| and | અને | `જો અ અને બ:` |
| or | અથવા | `જો અ અથવા બ:` |
| not | નહીં | `જો નહીં શરત:` |
| in | ઇન | `ફોર આઇટમ ઇન લિસ્ટ:` |
| is | છે | `જો વેરિએબલ છે કંઈ નહીં:` |
| with | સાથે | `સાથે ફાઈલ આસ f:` |
| as | આસ | `ઈમ્પોર્ટ numpy આસ np` |
| from | માંથી | `માંથી math ઈમ્પોર્ટ sqrt` |
| try | પ્રયત્ન કરો | `પ્રયત્ન કરો:` |
| except | સિવાય | `સિવાય Exception આસ e:` |
| finally | અંતે | `અંતે:` |
| raise | ઊઠાવો | `ઊઠાવો ValueError()` |
| lambda | લેમ્બડા | `લેમ્બડા x: x * 2` |
| global | વૈશ્વિક | `વૈશ્વિક વેરિએબલ` |
| nonlocal | બિન સ્થાનિક | `બિન સ્થાનિક વેરિએબલ` |
| assert | ખાતરી કરો | `ખાતરી કરો શરત` |
| break | બ્રેક | `બ્રેક` |
| continue | ચાલુ રાખો | `ચાલુ રાખો` |
| pass | પાસ | `પાસ` |
| del | ડિલીટ કરો | `ડિલીટ કરો વેરિએબલ` |
| yield | પ્રદાન કરો | `પ્રદાન કરો પરિણામ` |
| async | અસિન્ક | `અસિન્ક ડેફ ફંક્શન():` |
| await | રાહ જુઓ | `રાહ જુઓ પરિણામ` |

## 📂 પ્રોજેક્ટ સ્ટ્રક્ચર (Project Structure)

```
gujarati-python/
├── README.md                    # મુખ્ય ડોક્યુમેન્ટેશન
├── requirements.txt             # આવશ્યક પેકેજોની યાદી
├── ગુજરાતી_પાઈથન/              # મુખ્ય મોડ્યુલ
│   ├── __init__.py
│   ├── અનુવાદક.py              # કીવર્ડ ટ્રાન્સલેટર
│   ├── પ્રોસેસર.py              # કોડ પ્રોસેસર
│   └── સહાયકો.py               # હેલ્પર ફંક્શન્સ
├── ઉદાહરણો/                   # ઉદાહરણ કોડ ફાઈલો
│   ├── મૂળભૂત_ઉદાહરણ.py       # બેઝિક એક્ઝેમ્પલ
│   ├── ક્લાસ_ઉદાહરણ.py        # ક્લાસ એક્ઝેમ્પલ
│   └── અડવાન્સ_ઉદાહરણ.py      # એડવાન્સ એક્ઝેમ્પલ
├── ટેસ્ટ/                      # ટેસ્ટ ફાઈલો
│   └── ટેસ્ટ_અનુવાદક.py       # ટ્રાન્સલેટર ટેસ્ટ
└── ડોક્સ/                      # ડોક્યુમેન્ટેશન
    ├── સ્થાપન.md               # ઇન્સ્ટોલેશન ગાઇડ
    ├── વિકાસ.md                # ડેવલપમેન્ટ ગાઇડ
    └── ઉત્પાદન.md              # પ્રોડક્શન ગાઇડ
```

## 🛠️ વિકાસ (Development)

### ડેવલપમેન્ટ એનવાયરોન્મેન્ટ સેટઅપ કરો

```bash
# વર્ચ્યુઅલ એનવાયરોન્મેન્ટ બનાવો
python -m venv ગુજરાતી_વાતાવરણ

# એનવાયરોન્મેન્ટ એક્ટિવેટ કરો
source ગુજરાતી_વાતાવરણ/bin/activate  # Linux/Mac
# અથવા
ગુજરાતી_વાતાવરણ\Scripts\activate     # Windows

# ડેવલપમેન્ટ ડિપેન્ડન્સીઝ સ્થાપિત કરો
pip install -r requirements-dev.txt
```

### ટેસ્ટ ચલાવો

```bash
# બધા ટેસ્ટ ચલાવો (unittest સાથે)
python -m unittest ટેસ્ટ.ટેસ્ટ_અનુવાદક -v

# અથવા pytest સાથે (જો ઇન્સ્ટોલ કર્યું હોય)  
python -m pytest ટેસ્ટ/ -v

# કવરેજ રીપોર્ટ સાથે (pytest + pytest-cov સાથે)
python -m pytest --cov=ગુજરાતી_પાઈથન ટેસ્ટ/
```

## 🚀 પ્રોડક્શન (Production)

### સર્વર પર ડિપ્લોય કરવા માટે

```bash
# પ્રોડક્શન સર્વર પર કોડ કોપી કરો
scp -r gujarati-python/ user@server:/path/to/deployment/

# સર્વર પર કનેક્ટ કરો
ssh user@server

# પ્રોડક્શન એનવાયરોન્મેન્ટ સેટઅપ કરો
cd /path/to/deployment/gujarati-python/
python -m venv ઉત્પાદન_વાતાવરણ
source ઉત્પાદન_વાતાવરણ/bin/activate
pip install -r requirements.txt

# એપ્લિકેશન શરૂ કરો
python મુખ્ય.py
```

### Docker સાથે

```dockerfile
FROM python:3.9-slim

WORKDIR /app
COPY . /app

RUN pip install -r requirements.txt

CMD ["python", "મુખ્ય.py"]
```

## 📚 વધુ ઉદાહરણો (More Examples)

### 1. લિસ્ટ અને લૂપ્સ

```python
# ફળોની યાદી
ફળો = ["આમ", "કેળું", "સફરજન", "નારંગી"]

છાપો("બધા ફળો:")
ફોર ફળ ઇન ફળો:
    છાપો(f"- {ફળ}")
```

### 2. ક્લાસ ડેફિનેશન

```python
ક્લાસ વ્યક્તિ:
    """
    વ્યક્તિની માહિતી રાખવા માટેનો ક્લાસ
    """
    
    ડેફ __init__(સ્વ, નામ, ઉંમર):
        સ્વ.નામ = નામ
        સ્વ.ઉંમર = ઉંમર
    
    ડેફ પરિચય_આપો(સ્વ):
        પરત આપો f"હું {સ્વ.નામ} છું અને મારી ઉંમર {સ્વ.ઉંમર} વર્ષ છે."

# ઓબ્જેક્ટ બનાવો
વ્યક્તિ1 = વ્યક્તિ("રામ", 25)
છાપો(વ્યક્તિ1.પરિચય_આપો())
```

### 3. એરર હેન્ડલિંગ

```python
ડેફ ભાગાકાર(અ, બ):
    પ્રયત્ન કરો:
        પરિણામ = અ / બ
        પરત આપો પરિણામ
    સિવાય ZeroDivisionError:
        છાપો("શૂન્ય વડે ભાગાકાર શક્ય નથી!")
        પરત આપો કંઈ નહીં
    અંતે:
        છાપો("ભાગાકારની પ્રક્રિયા પૂર્ણ થઈ.")

પરિણામ = ભાગાકાર(10, 2)
છાપો(f"પરિણામ: {પરિણામ}")
```

## 🤝 યોગદાન (Contributing)

અમે સમુદાયના યોગદાનનું સ્વાગત કરીએ છીએ! કૃપા કરીને યોગદાન આપવા માટે આ પગલાં અનુસરો:

1. આ રીપોઝિટરીને ફોર્ક કરો
2. નવી ફીચર બ્રાન્ચ બનાવો (`git checkout -b નવું-ફીચર`)
3. તમારા ફેરફારો કમિટ કરો (`git commit -am 'નવું ફીચર ઉમેરો'`)
4. બ્રાન્ચને પુશ કરો (`git push origin નવું-ફીચર`)
5. પુલ રિક્વેસ્ટ બનાવો

## 📄 લાઈસેન્સ (License)

આ પ્રોજેક્ટ Apache License 2.0 હેઠળ લાઈસેન્સ પ્રાપ્ત છે. વધુ વિગતો માટે [LICENSE](LICENSE) ફાઈલ જુઓ.

## 📞 સંપર્ક (Contact)

પ્રશ્નો અથવા સૂચનો માટે, કૃપા કરીને GitHub Issues દ્વારા અમારો સંપર્ક કરો.

---

**સ્વાગત છે ગુજરાતી પાઈથનની દુનિયામાં! 🚀**