"""
પ્રોસેસર મોડ્યુલ - ગુજરાતી કોડ પ્રોસેસિંગ અને એક્ઝિક્યુશન

આ મોડ્યુલ ગુજરાતી પાઈથન કોડને પ્રોસેસ કરે છે અને ચલાવે છે.
"""

import sys
import traceback
from typing import Any, Dict, Optional
from io import StringIO

from .અનુવાદક import કોડ_અનુવાદ_કરો, વેલિડેશન_કરો
from .ભૂલ_અનુવાદક import ભૂલ_અનુવાદક


class ગુજરાતી_પ્રોસેસર:
    """
    ગુજરાતી પાઈથન કોડ પ્રોસેસ કરવા માટેનો ક્લાસ
    """
    
    def __init__(self):
        self.નેમસ્પેસ = {
            '__name__': '__main__',
            '__builtins__': __builtins__,
        }
        self.અનુવાદક = ભૂલ_અનુવાદક()
    
    def કોડ_ચલાવો(self, ગુજરાતી_કોડ: str, વેરિએબલ્સ: Optional[Dict[str, Any]] = None) -> Dict[str, Any]:
        """
        ગુજરાતી કોડ ચલાવે છે અને પરિણામ પરત કરે છે
        
        પેરામીટર:
            ગુજરાતી_કોડ (str): ચલાવવાનો ગુજરાતી કોડ
            વેરિએબલ્સ (dict): વધારાના વેરિએબલ્સ (વૈકલ્પિક)
            
        પરત આપે:
            dict: પરિણામ અને એરર્સ સાથેનો ડેટા
        """
        પરિણામ = {
            'સફળતા': False,
            'આઉટપુટ': '',
            'એરર': '',
            'વેરિએબલ્સ': {}
        }
        
        try:
            # વેલિડેશન કરો
            વેલિડેશન_એરર્સ = વેલિડેશન_કરો(ગુજરાતી_કોડ)
            if વેલિડેશન_એરર્સ:
                પરિણામ['એરર'] = '\n'.join(વેલિડેશન_એરર્સ)
                return પરિણામ
            
            # કોડ અનુવાદ કરો
            અંગ્રેજી_કોડ = કોડ_અનુવાદ_કરો(ગુજરાતી_કોડ)
            
            # નેમસ્પેસ તૈયાર કરો
            એક્ઝિક્યુશન_નેમસ્પેસ = self.નેમસ્પેસ.copy()
            if વેરિએબલ્સ:
                એક્ઝિક્યુશન_નેમસ્પેસ.update(વેરિએબલ્સ)
            
            # આઉટપુટ કેપ્ચર કરવા માટે StringIO
            આઉટપુટ_બફર = StringIO()
            જૂના_સ્ટડઆઉટ = sys.stdout
            sys.stdout = આઉટપુટ_બફર
            
            try:
                # કોડ એક્ઝિક્યુટ કરો
                exec(અંગ્રેજી_કોડ, એક્ઝિક્યુશન_નેમસ્પેસ)
                
                પરિણામ['સફળતા'] = True
                પરિણામ['આઉટપુટ'] = આઉટપુટ_બફર.getvalue()
                
                # વેરિએબલ્સ કાઢો (બિલ્ટ-ઇન્સ સિવાય)
                બિલ્ટ_ઇન_નામો = set(dir(__builtins__)) | {'__name__', '__builtins__'}
                પરિણામ['વેરિએબલ્સ'] = {
                    k: v for k, v in એક્ઝિક્યુશન_નેમસ્પેસ.items() 
                    if k not in બિલ્ટ_ઇન_નામો
                }
                
            finally:
                sys.stdout = જૂના_સ્ટડઆઉટ
                
        except Exception as e:
            # એરરનું ગુજરાતીમાં અનુવાદ કરો
            exc_type, exc_value, exc_traceback = sys.exc_info()
            ગુજરાતી_એરર = self.અનુવાદક.ગુજરાતી_એરર_મેળવો(exc_type, exc_value, exc_traceback)
            
            # ટ્રેસબેક ફોર્મેટ કરો (ફક્ત છેલ્લી લાઇન નહીં, પરંતુ વિગતવાર)
            tb_list = traceback.extract_tb(exc_traceback)
            એરર_વિગત = ""
            for frame in tb_list:
                # <string> વાળી ફાઈલ મતલબ આપણો એક્ઝિક્યુટ થયેલો કોડ
                if frame.filename == "<string>":
                    એરર_વિગત += f"  લાઈન {frame.lineno} માં:\n    {frame.line}\n"
            
            if એરર_વિગત:
                પરિણામ['એરર'] = f"{એરર_વિગત}\n{ગુજરાતી_એરર}"
            else:
                પરિણામ['એરર'] = f"{ગુજરાતી_એરર}\n\n(મૂળ એરર: {str(e)})"
        
        return પરિણામ
    
    def ફાઈલ_ચલાવો(self, ફાઈલ_પાથ: str) -> Dict[str, Any]:
        """
        ગુજરાતી પાઈથન ફાઈલ ચલાવે છે
        
        પેરામીટર:
            ફાઈલ_પાથ (str): ફાઈલનો પાથ
            
        પરત આપે:
            dict: પરિણામ
        """
        try:
            with open(ફાઈલ_પાથ, 'r', encoding='utf-8') as f:
                ગુજરાતી_કોડ = f.read()
            
            return self.કોડ_ચલાવો(ગુજરાતી_કોડ)
            
        except FileNotFoundError:
            return {
                'સફળતા': False,
                'આઉટપુટ': '',
                'એરર': f"ફાઈલ મળી નથી: {ફાઈલ_પાથ}",
                'વેરિએબલ્સ': {}
            }
        except Exception as e:
            return {
                'સફળતા': False,
                'આઉટપુટ': '',
                'એરર': f"ફાઈલ વાંચવામાં એરર: {str(e)}",
                'વેરિએબલ્સ': {}
            }


# ગ્લોબલ પ્રોસેસર ઇન્સ્ટન્સ
_પ્રોસેસર = ગુજરાતી_પ્રોસેસર()


def ગુજરાતી_કોડ_ચલાવો(કોડ: str, વેરિએબલ્સ: Optional[Dict[str, Any]] = None) -> Dict[str, Any]:
    """
    ગુજરાતી કોડ ચલાવવા માટેનું સરળ ફંક્શન
    
    પેરામીટર:
        કોડ (str): ગુજરાતી પાઈથન કોડ
        વેરિએબલ્સ (dict): વધારાના વેરિએબલ્સ
        
    પરત આપે:
        dict: પરિણામ
    """
    return _પ્રોસેસર.કોડ_ચલાવો(કોડ, વેરિએબલ્સ)


def ગુજરાતી_ફાઈલ_ચલાવો(ફાઈલ_પાથ: str) -> Dict[str, Any]:
    """
    ગુજરાતી પાઈથન ફાઈલ ચલાવવા માટેનું સરળ ફંક્શન
    
    પેરામીટર:
        ફાઈલ_પાથ (str): ફાઈલનો પાથ
        
    પરત આપે:
        dict: પરિણામ
    """
    return _પ્રોસેસર.ફાઈલ_ચલાવો(ફાઈલ_પાથ)