"""
સહાયકો મોડ્યુલ - ગુજરાતી પાઈથન માટે હેલ્પર ફંક્શન્સ

આ મોડ્યુલમાં ગુજરાતી પાઈથન ડેવલપમેન્ટ માટે ઉપયોગી ફંક્શન્સ છે.
"""

from typing import List, Dict, Any
from .અનુવાદક import કીવર્ડ_અનુવાદક


class ગુજરાતી_હેલ્પર:
    """
    ગુજરાતી પાઈથન માટે હેલ્પર ફંક્શન્સનો ક્લાસ
    """
    
    def __init__(self):
        self.અનુવાદક = કીવર્ડ_અનુવાદક()
    
    def કીવર્ડ_યાદી(self) -> Dict[str, str]:
        """
        બધા ગુજરાતી કીવર્ડ્સની યાદી પરત કરે છે
        
        પરત આપે:
            dict: ગુજરાતી કીવર્ડ્સ અને તેમના અંગ્રેજી ટ્રાન્સલેશન
        """
        return self.અનુવાદક.કીવર્ડ_મેપ.copy()
    
    def કીવર્ડ_શોધો(self, શોધ_ટર્મ: str) -> List[Dict[str, str]]:
        """
        કીવર્ડ શોધે છે
        
        પેરામીટર:
            શોધ_ટર્મ (str): શોધવાનો ટર્મ
            
        પરત આપે:
            list: મેચ થતા કીવર્ડ્સની યાદી
        """
        પરિણામો = []
        શોધ_ટર્મ = શોધ_ટર્મ.lower()
        
        for ગુજરાતી, અંગ્રેજી in self.અનુવાદક.કીવર્ડ_મેપ.items():
            if (શોધ_ટર્મ in ગુજરાતી.lower() or 
                શોધ_ટર્મ in અંગ્રેજી.lower()):
                પરિણામો.append({
                    'ગુજરાતી': ગુજરાતી,
                    'અંગ્રેજી': અંગ્રેજી
                })
        
        return પરિણામો
    
    def સિન્ટેક્સ_હેલ્પ(self, વિષય: str = "") -> str:
        """
        ગુજરાતી પાઈથન સિન્ટેક્સની મદદ આપે છે
        
        પેરામીટર:
            વિષય (str): મદદ માટેનો વિષય
            
        પરત આપે:
            str: મદદનો ટેક્સટ
        """
        મદદ_ટેક્સટ = {
            "ફંક્શન": """
ફંક્શન બનાવવાનો સિન્ટેક્સ:

ડેફ ફંક્શન_નામ(પેરામીટર1, પેરામીટર2):
    '''ડોક્સટ્રિંગ અહીં લખો'''
    # કોડ અહીં લખો
    પરત આપો પરિણામ

ઉદાહરણ:
ડેફ ઉમેરો(અ, બ):
    '''બે નંબરોનો ઉમેરો કરે છે'''
    પરત આપો અ + બ
            """,
            
            "ક્લાસ": """
ક્લાસ બનાવવાનો સિન્ટેક્સ:

ક્લાસ ક્લાસ_નામ:
    '''ક્લાસ વર્ણન'''
    
    ડેફ __init__(સ્વ, પેરામીટર):
        સ્વ.એટ્રિબ્યુટ = પેરામીટર
    
    ડેફ મેથડ_નામ(સ્વ):
        પરત આપો સ્વ.એટ્રિબ્યુટ

ઉદાહરણ:
ક્લાસ વ્યક્તિ:
    ડેફ __init__(સ્વ, નામ):
        સ્વ.નામ = નામ
    
    ડેફ પરિચય(સ્વ):
        પરત આપો f"હું {સ્વ.નામ} છું"
            """,
            
            "લૂપ": """
ફોર લૂપ:
ફોર આઇટમ ઇન યાદી:
    છાપો(આઇટમ)

વ્હાઈલ લૂપ:
વ્હાઈલ શરત:
    # કોડ
    જો કોઈ_શરત:
        બ્રેક
    
    જો બીજી_શરત:
        ચાલુ રાખો

ઉદાહરણ:
ફોર i ઇન રેંજ(5):
    છાપો(f"નંબર: {i}")
            """,
            
            "કન્ડીશન": """
જો-નહીં તો સ્ટેટમેન્ટ:

જો શરત1:
    # કોડ
અથવા જો શરત2:
    # બીજો કોડ  
નહીં તો:
    # છેવટનો કોડ

ઉદાહરણ:
ઉંમર = 18
જો ઉંમર >= 18:
    છાપો("તમે મોટા છો")
નહીં તો:
    છાપો("તમે નાના છો")
            """,
            
            "એરર": """
એરર હેન્ડલિંગ:

પ્રયત્ન કરો:
    # જોખમી કોડ
    પરિણામ = 10 / 0
સિવાય ZeroDivisionError આસ e:
    છાપો("શૂન્ય વડે ભાગ ન આપી શકાય!")
સિવાય Exception આસ e:
    છાપો(f"એરર: {e}")
અંતે:
    છાપો("હંમેશાં ચાલે છે")
            """
        }
        
        if વિષય in મદદ_ટેક્સટ:
            return મદદ_ટેક્સટ[વિષય]
        
        # સામાન્ય મદદ
        return """
ગુજરાતી પાઈથન સિન્ટેક્સ મદદ:

ઉપલબ્ધ વિષયો:
- ફંક્શન: ફંક્શન બનાવવાની મદદ
- ક્લાસ: ક્લાસ બનાવવાની મદદ  
- લૂપ: ફોર અને વ્હાઈલ લૂપની મદદ
- કન્ડીશન: જો-નહીં તો સ્ટેટમેન્ટની મદદ
- એરર: એરર હેન્ડલિંગની મદદ

ઉપયોગ: મદદ("વિષય_નામ")

મૂળભૂત ઉદાહરણ:
ડેફ મુખ્ય():
    છાપો("નમસ્તે, ગુજરાતી પાઈથન!")
    
મુખ્ય()
        """
    
    def કોડ_ફોર્મેટ_કરો(self, કોડ: str) -> str:
        """
        ગુજરાતી કોડને ફોર્મેટ કરે છે
        
        પેરામીટર:
            કોડ (str): ફોર્મેટ કરવાનો કોડ
            
        પરત આપે:
            str: ફોર્મેટ કરેલો કોડ
        """
        લીટીઓ = કોડ.split('\n')
        ફોર્મેટ_લીટીઓ = []
        ઇન્ડેન્ટ_લેવલ = 0
        
        for લીટી in લીટીઓ:
            ક્લીન_લીટી = લીટી.strip()
            
            if not ક્લીન_લીટી or ક્લીન_લીટી.startswith('#'):
                ફોર્મેટ_લીટીઓ.append(લીટી)
                continue
            
            # ઇન્ડેન્ટેશન ઘટાડવાના કીવર્ડ્સ
            if any(ક્લીન_લીટી.startswith(kw) for kw in ['નહીં તો:', 'અથવા જો', 'સિવાય', 'અંતે:']):
                ઇન્ડેન્ટ_લેવલ = max(0, ઇન્ડેન્ટ_લેવલ - 1)
            
            # લીટી ફોર્મેટ કરો
            ફોર્મેટ_લીટી = '    ' * ઇન્ડેન્ટ_લેવલ + ક્લીન_લીટી
            ફોર્મેટ_લીટીઓ.append(ફોર્મેટ_લીટી)
            
            # ઇન્ડેન્ટેશન વધારવાના કીવર્ડ્સ
            if ક્લીન_લીટી.endswith(':') and any(kw in ક્લીન_લીટી for kw in [
                'ડેફ ', 'ક્લાસ ', 'જો ', 'અથવા જો ', 'નહીં તો:', 'ફોર ', 'વ્હાઈલ ', 
                'પ્રયત્ન કરો:', 'સિવાય', 'અંતે:', 'સાથે '
            ]):
                ઇન્ડેન્ટ_લેવલ += 1
        
        return '\n'.join(ફોર્મેટ_લીટીઓ)


# ગ્લોબલ હેલ્પર ઇન્સ્ટન્સ
_હેલ્પર = ગુજરાતી_હેલ્પર()


def ગુજરાતી_હેલ્પ(વિષય: str = "") -> str:
    """
    ગુજરાતી પાઈથન મદદ આપે છે
    
    પેરામીટર:
        વિષય (str): મદદ માટેનો વિષય
        
    પરત આપે:
        str: મદદનો ટેક્સટ
    """
    return _હેલ્પર.સિન્ટેક્સ_હેલ્પ(વિષય)


def કીવર્ડ_લિસ્ટ() -> Dict[str, str]:
    """
    બધા ગુજરાતી કીવર્ડ્સની યાદી
    
    પરત આપે:
        dict: કીવર્ડ્સની યાદી
    """
    return _હેલ્પર.કીવર્ડ_યાદી()


def કીવર્ડ_સર્ચ(શોધ_ટર્મ: str) -> List[Dict[str, str]]:
    """
    કીવર્ડ શોધવા માટે
    
    પેરામીટર:
        શોધ_ટર્મ (str): શોધવાનો ટર્મ
        
    પરત આપે:
        list: મેચ થતા કીવર્ડ્સ
    """
    return _હેલ્પર.કીવર્ડ_શોધો(શોધ_ટર્મ)