# ઉત્પાદન ગાઇડ - ગુજરાતી પાઈથન

## 🏭 પ્રોડક્શન ડિપ્લોયમેન્ટ

### સર્વર આવશ્યકતાઓ

**મિનિમમ હાર્ડવેર:**
- CPU: 1 કોર (2+ ભલામણ)
- RAM: 512MB (1GB+ ભલામણ) 
- સ્ટોરેજ: 100MB ફ્રી સ્પેસ
- નેટવર્ક: ઇન્ટરનેટ કનેક્શન

**ઓપરેટિંગ સિસ્ટમ:**
- Ubuntu 18.04+ LTS (ભલામણ)
- CentOS 7+
- Debian 9+
- Amazon Linux 2
- Red Hat Enterprise Linux 8+

**સોફ્ટવેર:**
- Python 3.6+ 
- Git
- systemd (સર્વિસ મેનેજમેન્ટ માટે)
- nginx (વેબ સર્વર માટે - વૈકલ્પિક)

## 🚀 સર્વર સેટઅપ

### 1. સર્વર અપડેટ અને પેકેજ ઇન્સ્ટોલેશન

**Ubuntu/Debian:**
```bash
# સિસ્ટમ અપડેટ
sudo apt update && sudo apt upgrade -y

# આવશ્યક પેકેજો ઇન્સ્ટોલ કરો
sudo apt install -y python3 python3-pip python3-venv git curl wget
sudo apt install -y build-essential software-properties-common
sudo apt install -y nginx supervisor  # વૈકલ્પિક
```

**CentOS/RHEL:**
```bash
# સિસ્ટમ અપડેટ
sudo yum update -y

# EPEL રીપો ઉમેરો
sudo yum install -y epel-release

# આવશ્યક પેકેજો
sudo yum install -y python3 python3-pip git curl wget
sudo yum install -y gcc gcc-c++ make
sudo yum install -y nginx supervisor  # વૈકલ્પિક
```

### 2. યુઝર અને ડાયરેક્ટરી સેટઅપ

```bash
# નવો યુઝર બનાવો (વૈકલ્પિક - સિક્યુરિટી માટે)
sudo useradd -m -s /bin/bash gujarati-python
sudo usermod -aG sudo gujarati-python

# એપ્લિકેશન ડાયરેક્ટરી બનાવો
sudo mkdir -p /opt/gujarati-python
sudo chown gujarati-python:gujarati-python /opt/gujarati-python

# યુઝર સ્વિચ કરો
sudo su - gujarati-python
```

### 3. એપ્લિકેશન ઇન્સ્ટોલેશન

```bash
# એપ્લિકેશન ડાયરેક્ટરીમાં જાઓ
cd /opt/gujarati-python

# રીપોઝિટરી ક્લોન કરો
git clone https://github.com/ambicuity/gujarati-python.git .

# વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ બનાવો
python3 -m venv venv

# એન્વાયરોન્મેન્ટ એક્ટિવેટ કરો
source venv/bin/activate

# આવશ્યકતાઓ ઇન્સ્ટોલ કરો
pip install -r requirements.txt

# પરમિશન સેટ કરો
chmod +x મુખ્ય.py
```

## ⚙️ સિસ્ટમ સર્વિસ કન્ફિગરેશન

### systemd સર્વિસ ફાઇલ બનાવો

```bash
# સર્વિસ ફાઇલ બનાવો
sudo nano /etc/systemd/system/gujarati-python.service
```

સર્વિસ ફાઇલનું કન્ટેન્ટ:
```ini
[Unit]
Description=ગુજરાતી પાઈથન સર્વિસ
After=network.target

[Service]
Type=simple
User=gujarati-python
Group=gujarati-python
WorkingDirectory=/opt/gujarati-python
Environment=PATH=/opt/gujarati-python/venv/bin
Environment=PYTHONPATH=/opt/gujarati-python
ExecStart=/opt/gujarati-python/venv/bin/python મુખ્ય.py --daemon
ExecReload=/bin/kill -HUP $MAINPID
KillMode=mixed
Restart=always
RestartSec=5
StandardOutput=journal
StandardError=journal

[Install]
WantedBy=multi-user.target
```

### સર્વિસ એનેબલ અને સ્ટાર્ટ કરો

```bash
# systemd રીલોડ કરો
sudo systemctl daemon-reload

# સર્વિસ એનેબલ કરો
sudo systemctl enable gujarati-python.service

# સર્વિસ સ્ટાર્ટ કરો
sudo systemctl start gujarati-python.service

# સર્વિસ સ્ટેટસ ચેક કરો
sudo systemctl status gujarati-python.service
```

## 🔒 સિક્યુરિટી કન્ફિગરેશન

### ફાયરવોલ સેટઅપ

**Ubuntu (ufw):**
```bash
# UFW એનેબલ કરો
sudo ufw --force enable

# SSH પોર્ટ ઓપન કરો
sudo ufw allow 22/tcp

# HTTP/HTTPS (જો વેબ ઈન્ટરફેસ વાપરો તો)
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp

# સ્ટેટસ ચેક કરો
sudo ufw status
```

**CentOS (firewalld):**
```bash
# Firewalld સ્ટાર્ટ કરો
sudo systemctl start firewalld
sudo systemctl enable firewalld

# SSH પોર્ટ ઓપન કરો
sudo firewall-cmd --permanent --add-service=ssh

# HTTP/HTTPS (જો જરૂર હોય)
sudo firewall-cmd --permanent --add-service=http
sudo firewall-cmd --permanent --add-service=https

# રીલોડ કરો
sudo firewall-cmd --reload
```

### SSL/TLS સર્ટિફિકેટ (વેબ ઈન્ટરફેસ માટે)

```bash
# Let's Encrypt ઇન્સ્ટોલ કરો
sudo apt install certbot python3-certbot-nginx

# SSL સર્ટિફિકેટ મેળવો
sudo certbot --nginx -d your-domain.com

# ઓટો રીન્યુઅલ સેટઅપ કરો
sudo crontab -e
```

Crontab માં ઉમેરો:
```bash
0 12 * * * /usr/bin/certbot renew --quiet
```

## 📊 મોનિટરિંગ અને લોગિંગ

### લોગ કન્ફિગરેશન

સર્વિસ લોગ જોવા માટે:
```bash
# લાઇવ લોગ
sudo journalctl -u gujarati-python.service -f

# છેલ્લા 100 લાઇન
sudo journalctl -u gujarati-python.service -n 100

# ડેટ મુજબ લોગ
sudo journalctl -u gujarati-python.service --since "2023-01-01"
```

### લોગ રોટેશન સેટઅપ

```bash
# લોગરોટેટ કન્ફિગ બનાવો
sudo nano /etc/logrotate.d/gujarati-python
```

કન્ફિગ કન્ટેન્ટ:
```
/var/log/gujarati-python/*.log {
    daily
    rotate 30
    compress
    delaycompress
    missingok
    notifempty
    sharedscripts
    postrotate
        systemctl reload gujarati-python.service
    endscript
}
```

### સિસ્ટમ મોનિટરિંગ

```bash
# CPU અને મેમોરી વપરાશ
top
htop  # જો ઇન્સ્ટોલ કર્યું હોય

# ડિસ્ક સ્પેસ
df -h

# સર્વિસ સ્ટેટસ
sudo systemctl is-active gujarati-python.service
sudo systemctl is-enabled gujarati-python.service
```

## 🔄 અપડેટ અને મેઇન્ટેનન્સ

### એપ્લિકેશન અપડેટ

```bash
# સર્વિસ સ્ટોપ કરો
sudo systemctl stop gujarati-python.service

# એપ્લિકેશન ડાયરેક્ટરીમાં જાઓ
cd /opt/gujarati-python

# બેકઅપ લો (વૈકલ્પિક)
cp -r /opt/gujarati-python /opt/gujarati-python-backup-$(date +%Y%m%d)

# નવો કોડ પુલ કરો
git pull origin main

# વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ એક્ટિવેટ કરો
source venv/bin/activate

# ડિપેન્ડન્સીઝ અપડેટ કરો
pip install -r requirements.txt

# સર્વિસ સ્ટાર્ટ કરો
sudo systemctl start gujarati-python.service

# સ્ટેટસ ચેક કરો
sudo systemctl status gujarati-python.service
```

### ઓટોમેટિક અપડેટ સ્ક્રિપ્ટ

```bash
# અપડેટ સ્ક્રિપ્ટ બનાવો
sudo nano /usr/local/bin/update-gujarati-python.sh
```

સ્ક્રિપ્ટ કન્ટેન્ટ:
```bash
#!/bin/bash
set -e

echo "ગુજરાતી પાઈથન અપડેટ કરી રહ્યા છીએ..."

# સર્વિસ સ્ટોપ કરો
sudo systemctl stop gujarati-python.service

# ડાયરેક્ટરીમાં જાઓ
cd /opt/gujarati-python

# કોડ અપડેટ કરો
sudo -u gujarati-python git pull origin main

# ડિપેન્ડન્સીઝ અપડેટ કરો
sudo -u gujarati-python /opt/gujarati-python/venv/bin/pip install -r requirements.txt

# સર્વિસ સ્ટાર્ટ કરો
sudo systemctl start gujarati-python.service

echo "અપડેટ પૂર્ણ!"
```

પરમિશન આપો:
```bash
sudo chmod +x /usr/local/bin/update-gujarati-python.sh
```

### બેકઅપ સ્ટ્રેટેજી

```bash
# દેનિક બેકઅપ સ્ક્રિપ્ટ
sudo nano /usr/local/bin/backup-gujarati-python.sh
```

સ્ક્રિપ્ટ કન્ટેન્ટ:
```bash
#!/bin/bash
BACKUP_DIR="/backups/gujarati-python"
DATE=$(date +%Y%m%d_%H%M%S)

mkdir -p $BACKUP_DIR

# કોડ બેકઅપ
tar -czf "$BACKUP_DIR/app_$DATE.tar.gz" -C /opt gujarati-python

# જૂના બેકઅપ ડિલીટ કરો (30 દિવસ કરતાં જૂના)
find $BACKUP_DIR -name "app_*.tar.gz" -mtime +30 -delete

echo "બેકઅપ પૂર્ણ: $BACKUP_DIR/app_$DATE.tar.gz"
```

કૉનટેબ માં ઉમેરો:
```bash
sudo crontab -e
```

ઉમેરો:
```bash
0 2 * * * /usr/local/bin/backup-gujarati-python.sh
```

## 🐛 ટ્રબલશૂટિંગ

### સામાન્ય સમસ્યાઓ

**સર્વિસ સ્ટાર્ટ નથી થતી:**
```bash
# લોગ ચેક કરો
sudo journalctl -u gujarati-python.service -n 50

# કન્ફિગ ફાઇલ ચેક કરો
sudo systemctl cat gujarati-python.service

# પરમિશન ચેક કરો
ls -la /opt/gujarati-python/
```

**મેમોરી લીક:**
```bash
# મેમોરી વપરાશ મોનિટર કરો
ps aux | grep gujarati-python

# મેમોરી ડમ્પ લો
sudo kill -USR1 `pidof python`
```

**પર્ફોર્મન્સ ઇશ્યુઝ:**
```bash
# CPU વપરાશ ચેક કરો
top -p `pidof python`

# I/O વેઇટ ચેક કરો
iostat -x 1

# નેટવર્ક કનેક્શન
ss -tuln
```

## 📈 પર્ફોર્મન્સ ઓપ્ટિમાઇઝેશન

### સિસ્ટમ લિમિટ્સ વધારવી

```bash
# લિમિટ્સ ફાઇલ એડિટ કરો
sudo nano /etc/security/limits.conf
```

ઉમેરો:
```
gujarati-python soft nofile 65536
gujarati-python hard nofile 65536
gujarati-python soft nproc 32768
gujarati-python hard nproc 32768
```

### Python ઓપ્ટિમાઇઝેશન

```bash
# Python bytecode જનરેટ કરો
python -m compileall /opt/gujarati-python/

# PYTHONOPTIMIZE સેટ કરો સર્વિસ ફાઇલમાં
Environment=PYTHONOPTIMIZE=1
```

## 🌐 લોડ બેલેન્સિંગ (ઉચ્ચ ટ્રાફિક માટે)

### Nginx કન્ફિગરેશન

```bash
sudo nano /etc/nginx/sites-available/gujarati-python
```

કન્ફિગ કન્ટેન્ટ:
```nginx
upstream gujarati_python {
    server 127.0.0.1:8001;
    server 127.0.0.1:8002;
    server 127.0.0.1:8003;
}

server {
    listen 80;
    server_name your-domain.com;

    location / {
        proxy_pass http://gujarati_python;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

## 📞 સહાયતા અને સપોર્ટ

**લોગ ફાઇલની લોકેશન:**
- System logs: `/var/log/syslog`
- Service logs: `journalctl -u gujarati-python.service`
- Application logs: `/opt/gujarati-python/logs/` (જો કન્ફિગર કર્યું હોય)

**કોમ્યુનિટી સપોર્ટ:**
- GitHub Issues: [Repository Issues](https://github.com/ambicuity/gujarati-python/issues)
- Documentation: `/opt/gujarati-python/ડોક્સ/`

---

**ગુજરાતી પાઈથન પ્રોડક્શનમાં સફળતાપૂર્વક ચલાવવા બદલ અભિનંદન! 🎉**