# વિકાસ ગાઈડ - ગુજરાતી પાઈથન

## 🛠️ ડેવલપમેન્ટ એન્વાયરોન્મેન્ટ સેટઅપ

### આવશ્યકતાઓ
- Python 3.6+
- Git 
- ટેક્સ્ટ એડિટર (VS Code, PyCharm, Vim વગેરે)
- UTF-8 સપોર્ટ સાથે ટર્મિનલ

### લોકલ ડેવલપમેન્ટ સેટઅપ

1. **રીપોઝિટરી ફોર્ક અને ક્લોન કરો:**
```bash
# તમારા GitHub એકાઉન્ટ પર રીપોઝિટરી ફોર્ક કરો
git clone https://github.com/your-username/gujarati-python.git
cd gujarati-python

# અપસ્ટ્રીમ રીમોટ ઉમેરો
git remote add upstream https://github.com/ambicuity/gujarati-python.git
```

2. **વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ બનાવો:**
```bash
python3 -m venv દેવ_વાતાવરણ

# એન્વાયરોન્મેન્ટ એક્ટિવેટ કરો
source દેવ_વાતાવરણ/bin/activate  # Linux/macOS
દેવ_વાતાવરણ\Scripts\activate     # Windows
```

3. **ડેવલપમેન્ટ ડિપેન્ડન્સીઝ ઇન્સ્ટોલ કરો:**
```bash
# મૂળભૂત આવશ્યકતાઓ
pip install -r requirements.txt

# ડેવલપમેન્ટ માટેના ટૂલ્સ (વૈકલ્પિક)
pip install pytest pytest-cov flake8 black
```

## 📁 પ્રોજેક્ટ સ્ટ્રક્ચર

```
gujarati-python/
├── README.md                    # મુખ્ય ડોક્યુમેન્ટેશન
├── requirements.txt             # આવશ્યક પેકેજો
├── મુખ્ય.py                      # મેઇન CLI સ્ક્રિપ્ટ
├── ગુજરાતી_પાઈથન/              # મુખ્ય મોડ્યુલ
│   ├── __init__.py             # મોડ્યુલ ઇનિશિયલાઇઝેશન
│   ├── અનુવાદક.py              # કીવર્ડ ટ્રાન્સલેટર
│   ├── પ્રોસેસર.py              # કોડ પ્રોસેસિંગ
│   └── સહાયકો.py               # હેલ્પર ફંક્શન્સ
├── ઉદાહરણો/                   # ઉદાહરણ કોડ ફાઈલો
│   ├── મૂળભૂત_ઉદાહરણ.py       # બેસિક એક્ઝેમ્પલ
│   └── ક્લાસ_ઉદાહરણ.py        # ક્લાસ એક્ઝેમ્પલ
├── ટેસ્ટ/                      # ટેસ્ટ ફાઈલો
│   └── ટેસ્ટ_અનુવાદક.py       # યુનિટ ટેસ્ટ
└── ડોક્સ/                      # ડોક્યુમેન્ટેશન
    ├── સ્થાપન.md               # ઇન્સ્ટોલેશન ગાઈડ
    ├── વિકાસ.md                # ડેવલપમેન્ટ ગાઈડ
    └── ઉત્પાદન.md              # પ્રોડક્શન ગાઈડ
```

## 🧪 ટેસ્ટિંગ

### યુનિટ ટેસ્ટ્સ ચલાવો
```bash
# બધા ટેસ્ટ્સ ચલાવો
python -m pytest ટેસ્ટ/ -v

# કવરેજ સાથે
python -m pytest ટેસ્ટ/ --cov=ગુજરાતી_પાઈથન --cov-report=html

# ચોક્કસ ટેસ્ટ ચલાવો
python ટેસ્ટ/ટેસ્ટ_અનુવાદક.py
```

### મેન્યુઅલ ટેસ્ટિંગ
```bash
# ઇન્ટરએક્ટિવ ટેસ્ટ
python મુખ્ય.py

# ઉદાહરણ ફાઇલ ટેસ્ટ
python મુખ્ય.py ઉદાહરણો/મૂળભૂત_ઉદાહરણ.py

# ટ્રાન્સલેશન ટેસ્ટ
python મુખ્ય.py --translate ઉદાહરણો/મૂળભૂત_ઉદાહરણ.py
```

## 🔧 કોડ ક્વોલિટી

### કોડ ફોર્મેટિંગ
```bash
# Black વાપરીને ફોર્મેટ કરો (જો ઇન્સ્ટોલ કર્યું હોય)
black ગુજરાતી_પાઈથન/ ટેસ્ટ/ મુખ્ય.py

# ફોર્મેટિંગ ચેક કરો
black --check ગુજરાતી_પાઈથન/ ટેસ્ટ/ મુખ્ય.py
```

### લિંટિંગ
```bash
# Flake8 વાપરીને લિંટ કરો (જો ઇન્સ્ટોલ કર્યું હોય)
flake8 ગુજરાતી_પાઈથન/ ટેસ્ટ/ મુખ્ય.py

# ચોક્કસ એરર્સ ઇગ્નોર કરો
flake8 --ignore=E501,W503 ગુજરાતી_પાઈથન/
```

## 🆕 નવા ફીચર્સ ઉમેરવા

### કીવર્ડ ઉમેરવું
1. `ગુજરાતી_પાઈથન/અનુવાદક.py` ખોલો
2. `કીવર્ડ_મેપ` ડિક્શનરીમાં નવો કીવર્ડ ઉમેરો:
```python
self.કીવર્ડ_મેપ = {
    # અસ્તિત્વમાં રહેલા કીવર્ડ્સ...
    'તમારો_નવો_કીવર્ડ': 'your_new_keyword',
}
```

3. ટેસ્ટ લખો:
```python
def test_નવો_કીવર્ડ(self):
    ગુજરાતી_કોડ = "તમારો_નવો_કીવર્ડ કંઈક"
    અપેક્ષિત = "your_new_keyword કંઈક"
    પરિણામ = self.અનુવાદક.ગુજરાતીથી_અંગ્રેજી(ગુજરાતી_કોડ)
    self.assertEqual(પરિણામ.strip(), અપેક્ષિત.strip())
```

### નવા ફંક્શન્સ ઉમેરવા
1. યોગ્ય મોડ્યુલમાં ફંક્શન ઉમેરો
2. `__init__.py`માં એક્સપોર્ટ કરો
3. ડોક્યુમેન્ટેશન લખો
4. ટેસ્ટ લખો

### ઉદાહરણો ઉમેરવા
1. `ઉદાહરણો/` ફોલ્ડરમાં નવી ફાઇલ બનાવો
2. ગુજરાતી કમેન્ટ્સ અને ડોક્સટ્રિંગ્સ સાથે કોડ લખો
3. README.md માં ઉદાહરણનો ઉલ્લેખ કરો

## 📝 કોડિંગ સ્ટાન્ડર્ડ્સ

### ફાઇલ નામકરણ
- બધી ફાઇલ નામો ગુજરાતીમાં
- અંડરસ્કોર વાપરો સ્પેસ માટે: `મૂળભૂત_ઉદાહરણ.py`
- ફોલ્ડર નામો પણ ગુજરાતીમાં

### વેરિએબલ અને ફંક્શન નામકરણ
```python
# યોગ્ય
ડેફ ગણતરી_કરો(અ, બ):
    પરિણામ = અ + બ
    પરત આપો પરિણામ

# ખોટું
def calculation(a, b):
    result = a + b
    return result
```

### કમેન્ટ્સ અને ડોક્સટ્રિંગ્સ
```python
"""
આ ફંક્શનનું વર્ણન ગુજરાતીમાં

પેરામીટર:
    અ (int): પહેલો નંબર
    બ (int): બીજો નંબર

પરત આપે:
    int: બંને નંબરોનો સરવાળો
"""
```

### એરર હેન્ડલિંગ
```python
try:
    # કોડ અહીં
    પાસ
except Exception as e:
    print(f"એરર: {e}")
```

## 🔄 Git વર્કફ્લો

### બ્રાંચ બનાવવી
```bash
# મુખ્ય બ્રાંચ અપડેટ કરો
git checkout main
git pull upstream main

# નવી ફીચર બ્રાંચ બનાવો
git checkout -b નવું-ફીચર

# કામ કરો અને કમિટ કરો
git add .
git commit -m "નવું ફીચર ઉમેર્યું"

# પુશ કરો અને પુલ રિક્વેસ્ટ બનાવો
git push origin નવું-ફીચર
```

### કમિટ મેસેજ ગાઇડલાઇન્સ
```bash
# યોગ્ય કમિટ મેસેજ
git commit -m "અનુવાદકમાં async/await કીવર્ડ્સ ઉમેર્યા"
git commit -m "બગ ફિક્સ: લૂપમાં ઇન્ડેક્સ એરર"
git commit -m "ડોક્યુમેન્ટેશન: ઉદાહરણો અપડેટ કર્યા"

# ઊંચાઈ અને વિગતવાર મેસેજ
git commit -m "નવું ફીચર: ક્લાસ વારસાગત સપોર્ટ

- super() ફંક્શનનો સપોર્ટ ઉમેર્યો
- મલ્ટિપલ ઇન્હેરિટન્સ હેન્ડલિંગ  
- ટેસ્ટ કેસ ઉમેર્યા"
```

## 🐛 ડીબગિંગ

### લોગિંગ ઉમેરવું
```python
import logging

# લોગિંગ સેટઅપ
logging.basicConfig(level=logging.DEBUG, format='%(levelname)s: %(message)s')
logger = logging.getLogger(__name__)

# લોગ મેસેજ
logger.debug(f"કોડ અનુવાદ: {કોડ}")
logger.info("અનુવાદ પૂર્ણ")
logger.error(f"એરર થયો: {error}")
```

### ડીબગિંગ ટૂલ્સ
```python
# pdb ડીબગર વાપરો
import pdb
pdb.set_trace()  # બ્રેકપોઇન્ટ

# Print debugging
print(f"DEBUG: વેરિએબલ = {વેરિએબલ}")
```

## 📈 પરફોર્મન્સ

### પ્રોફાઇલિંગ
```bash
# ટાઇમ મેઝરમેન્ટ
python -m timeit -s "from ગુજરાતી_પાઈથન import કોડ_અનુવાદ_કરો" "કોડ_અનુવાદ_કરો('છાપો(\"હેલો\")')"

# મેમોરી પ્રોફાઇલિંગ
python -m memory_profiler મુખ્ય.py
```

### કોડ ઓપ્ટિમાઇઝેશન
- રેગેક્સ કોમ્પાઇલ કરીને કેશ કરો
- લૂપ્સમાં બિનજરૂરી ઓપરેશન્સ ટાળો
- ડેટા સ્ટ્રક્ચર્સ યોગ્ય પસંદ કરો

## 🚀 પ્રોડક્શન તૈયારી

### ફાઇનલ ચેકલિસ્ટ
- [ ] બધા ટેસ્ટ્સ પાસ થાય છે
- [ ] કોડ લિન્ટેડ છે
- [ ] ડોક્યુમેન્ટેશન અપડેટ છે
- [ ] કમિટ મેસેજ સાફ છે
- [ ] README.md અપડેટ છે

### રિલીઝ પ્રોસેસ
1. વર્ઝન નંબર અપડેટ કરો
2. ચેન્જલોગ લખો
3. ટેગ બનાવો: `git tag v1.0.0`
4. GitHub રિલીઝ બનાવો

---

**ખુશ કોડિંગ! ગુજરાતી પાઈથનને બેહતર બનાવવા બદલ આભાર! 🙏**