# સ્થાપન ગાઈડ - ગુજરાતી પાઈથન

## 📋 સિસ્ટમ આવશ્યકતાઓ

### ઓપરેટિંગ સિસ્ટમ
- Windows 10/11
- macOS 10.14+  
- Linux (Ubuntu, Debian, CentOS, Fedora, Arch Linux)

### Python આવશ્યકતાઓ
- Python 3.6 અથવા નવું વર્ઝન
- pip પેકેજ મેનેજર (Python સાથે આવે છે)

## 🔧 Python સ્થાપન

### Windows માટે
1. [Python.org](https://python.org/downloads/) પરથી Python ડાઉનલોડ કરો
2. ઇન્સ્ટોલર ચલાવો અને "Add Python to PATH" ચેક કરો
3. ઇન્સ્ટોલેશન પૂર્ણ કરો

આદેશ લાઈનમાં ચકાસો:
```bash
python --version
pip --version
```

### macOS માટે
Python ઇન્સ્ટોલ કરવાના બે તરીકા:

**વિકલ્પ 1: અધિકૃત ઇન્સ્ટોલર**
```bash
# Python.org પરથી ડાઉનલોડ કરો અને ઇન્સ્ટોલ કરો
```

**વિકલ્પ 2: Homebrew (આપેલ હશે તો)**
```bash
# Homebrew ઇન્સ્ટોલ કરો (જો અગાઉથી નથી)
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"

# Python ઇન્સ્ટોલ કરો
brew install python3
```

### Linux માટે

**Ubuntu/Debian:**
```bash
# સિસ્ટમ અપડેટ કરો
sudo apt update
sudo apt upgrade -y

# Python અને pip ઇન્સ્ટોલ કરો
sudo apt install python3 python3-pip python3-venv -y
```

**CentOS/RHEL/Fedora:**
```bash
# CentOS/RHEL માટે
sudo yum install python3 python3-pip -y

# Fedora માટે
sudo dnf install python3 python3-pip -y
```

**Arch Linux:**
```bash
sudo pacman -S python python-pip
```

## 📁 ગુજરાતી પાઈથન સ્થાપન

### ગિટ રીપોઝિટરીથી ઇન્સ્ટોલેશન

1. **રીપોઝિટરી ક્લોન કરો:**
```bash
git clone https://github.com/ambicuity/gujarati-python.git
cd gujarati-python
```

2. **વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ બનાવો (વૈકલ્પિક પણ ભલામણ):**
```bash
# વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ બનાવો
python3 -m venv ગુજરાતી_વાતાવરણ

# એન્વાયરોન્મેન્ટ એક્ટિવેટ કરો
# Linux/macOS માટે:
source ગુજરાતી_વાતાવરણ/bin/activate

# Windows માટે:
ગુજરાતી_વાતાવરણ\Scripts\activate
```

3. **આવશ્યક પેકેજો ઇન્સ્ટોલ કરો:**
```bash
pip install -r requirements.txt
```

### ZIP ફાઇલથી ઇન્સ્ટોલેશન

1. ગિટહબ પરથી ZIP ફાઇલ ડાઉનલોડ કરો
2. ZIP ફાઇલ એક્સટ્રેક્ટ કરો
3. ટર્મિનલ/કમાંડ પ્રોમ્પ્ટમાં ફોલ્ડરમાં જાઓ
4. ઉપરના સ્ટેપ 2-3 અનુસરો

## ✅ ઇન્સ્ટોલેશન વેરિફિકેશન

### મૂળભૂત ટેસ્ટ
```bash
# ગુજરાતી પાઈથન ડાઇરેક્ટરીમાં જાઓ
cd gujarati-python

# મુખ્ય સ્ક્રિપ્ટ ચલાવો  
# નોંધ: Windows પર 'python', Linux/macOS પર 'python3' વાપરો
python મુખ્ય.py       # Windows
python3 મુખ્ય.py      # Linux/macOS

# કીવર્ડ્સ જુઓ
python મુખ્ય.py --keywords

# ઉદાહરણ ફાઇલ ચલાવો
python મુખ્ય.py ઉદાહરણો/મૂળભૂત_ઉદાહરણ.py
```

### ઇન્ટરએક્ટિવ ટેસ્ટ
```bash
# ઇન્ટરએક્ટિવ મોડ શરૂ કરો
python મુખ્ય.py

# ઇન્ટરએક્ટિવ પ્રોમ્પ્ટમાં ટાઇપ કરો:
ગુજરાતી>>> છાપો("નમસ્તે, ગુજરાતી પાઈથન!")
ગુજરાતી>>> મદદ()
```

## 🐛 સમસ્યાઓ અને સમાધાન

### સામાન્ય સમસ્યાઓ

**1. "python આદેશ મળ્યો નથી"**
```bash
# Python ઇન્સ્ટોલ ચકાસો
which python3  # Linux/macOS
where python   # Windows

# જો ઇન્સ્ટોલ નથી તો ઉપરના સ્ટેપ્સ અનુસરો
```

**2. "ગુજરાતી ટેક્સ્ટ બતાવતું નથી"**
```bash
# ટર્મિનલ UTF-8 સપોર્ટ ચકાસો
echo $LANG  # Linux/macOS

# Windows માટે PowerShell વાપરો કે Windows Terminal
```

**3. "મોડ્યુલ મળ્યું નથી" એરર**
```bash
# કરેક્ટ ડાઇરેક્ટરીમાં છો કે કેમ ચકાસો
pwd
ls -la  # gujarati-python ફોલ્ડર દેખાવું જોઈએ

# Python પાથ ચકાસો
python -c "import sys; print('\n'.join(sys.path))"
```

**4. "એન્કોડિંગ એરર"**
```bash
# UTF-8 એન્કોડિંગ સેટ કરો
export PYTHONIOENCODING=utf-8  # Linux/macOS

# Windows માટે
chcp 65001
set PYTHONIOENCODING=utf-8
```

### પરફોર્મન્સ ઓપ્ટિમાઇઝેશન

**મેમોરી વપરાશ ઓપ્ટિમાઇઝ કરવા:**
```bash
# Python ઓપ્ટિમાઇઝેશન ફ્લેગ વાપરો
python -O મુખ્ય.py

# મેમોરી વપરાશ મોનિટર કરો
python -c "import tracemalloc; tracemalloc.start(); exec(open('મુખ્ય.py').read())"
```

## 🔄 અપડેટ

### Git વાપરીને
```bash
cd gujarati-python
git pull origin main
```

### મેન્યુઅલ અપડેટ
1. નવું વર્ઝન ડાઉનલોડ કરો
2. જૂના ફાઇલો બેકઅપ લો
3. નવી ફાઇલો રિપ્લેસ કરો

## 🗑️ અનઇન્સ્ટોલ

### વર્ચ્યુઅલ એન્વાયરોન્મેન્ટ સાથે
```bash
# એન્વાયરોન્મેન્ટ ડીએક્ટિવેટ કરો
deactivate

# ફોલ્ડર ડિલીટ કરો
rm -rf gujarati-python/  # Linux/macOS
rmdir /s gujarati-python  # Windows
```

### સિસ્ટમ-વાઇડ ઇન્સ્ટોલેશન
```bash
# ફક્ત ફોલ્ડર ડિલીટ કરો
rm -rf gujarati-python/  # Linux/macOS
rmdir /s gujarati-python  # Windows
```

## 📞 મદદ અને સહાયતા

જો કોઈ સમસ્યા આવે તો:

1. **ડોક્યુમેન્ટેશન વાંચો:** [README.md](../README.md)
2. **ઉદાહરણો જુઓ:** `ઉદાહરણો/` ફોલ્ડર
3. **ટેસ્ટ ચલાવો:** `python ટેસ્ટ/ટેસ્ટ_અનુવાદક.py`
4. **GitHub Issues:** [Issues Page](https://github.com/ambicuity/gujarati-python/issues)

**સામાન્ય મદદ આદેશો:**
```bash
python મુખ્ય.py --help        # કમાંડ લાઇન મદદ
python મુખ્ય.py              # ઇન્ટરએક્ટિવ મોડમાં મદદ() ટાઇપ કરો
```

---

**આનંદથી કોડિંગ કરો! 🚀**