# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from gunbot_sdk.api_client import ApiClient


class GunbotApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assets_total(self, body, **kwargs):  # noqa: E501
        """assetsTotal — Get Historical Total Asset Value  # noqa: E501

        Retrieve historical total asset value in a base currency over a time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assets_total(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetsTotalRequest body: (required)
        :return: AssetsTotalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assets_total_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.assets_total_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def assets_total_with_http_info(self, body, **kwargs):  # noqa: E501
        """assetsTotal — Get Historical Total Asset Value  # noqa: E501

        Retrieve historical total asset value in a base currency over a time range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assets_total_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetsTotalRequest body: (required)
        :return: AssetsTotalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assets_total" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `assets_total`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/assets/total', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetsTotalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_login(self, body, **kwargs):  # noqa: E501
        """authLogin — Login User  # noqa: E501

        Authenticate a user and obtain a JSON Web Token (JWT).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_login(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginRequest body: (required)
        :return: LoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.auth_login_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.auth_login_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def auth_login_with_http_info(self, body, **kwargs):  # noqa: E501
        """authLogin — Login User  # noqa: E501

        Authenticate a user and obtain a JSON Web Token (JWT).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_login_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LoginRequest body: (required)
        :return: LoginResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_login" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `auth_login`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/login', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LoginResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def auth_status(self, **kwargs):  # noqa: E501
        """authStatus — Get Authentication Status  # noqa: E501

        Validate the current session's authentication status using the provided token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_status(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.auth_status_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.auth_status_with_http_info(**kwargs)  # noqa: E501
            return data

    def auth_status_with_http_info(self, **kwargs):  # noqa: E501
        """authStatus — Get Authentication Status  # noqa: E501

        Validate the current session's authentication status using the provided token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.auth_status_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AuthStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method auth_status" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/auth/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def balances(self, **kwargs):  # noqa: E501
        """balances — Get Asset Balances  # noqa: E501

        Retrieve asset balances across exchanges for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.balances(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BalancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.balances_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.balances_with_http_info(**kwargs)  # noqa: E501
            return data

    def balances_with_http_info(self, **kwargs):  # noqa: E501
        """balances — Get Asset Balances  # noqa: E501

        Retrieve asset balances across exchanges for the authenticated user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.balances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: BalancesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method balances" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/balances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BalancesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chart_data(self, body, **kwargs):  # noqa: E501
        """chartData — Get Chart Data (Candles and Indicators)  # noqa: E501

        Retrieve chart data, including candles and indicators, for a specific trading pair.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chart_data(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChartDataRequest body: (required)
        :return: ChartDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chart_data_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.chart_data_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def chart_data_with_http_info(self, body, **kwargs):  # noqa: E501
        """chartData — Get Chart Data (Candles and Indicators)  # noqa: E501

        Retrieve chart data, including candles and indicators, for a specific trading pair.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chart_data_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ChartDataRequest body: (required)
        :return: ChartDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chart_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `chart_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/chart/data', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChartDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def chart_marks(self, exchange, pair, interval, start_time, end_time, **kwargs):  # noqa: E501
        """chartMarks — Get Chart Timescale Marks  # noqa: E501

        Retrieve chart timescale marks (annotations like buy/sell triggers) for a pair and interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chart_marks(exchange, pair, interval, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: (required)
        :param str pair: (required)
        :param str interval: Time interval in minutes. (required)
        :param str start_time: Start time (UNIX timestamp seconds). (required)
        :param str end_time: End time (UNIX timestamp seconds). (required)
        :return: ChartMarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.chart_marks_with_http_info(exchange, pair, interval, start_time, end_time, **kwargs)  # noqa: E501
        else:
            (data) = self.chart_marks_with_http_info(exchange, pair, interval, start_time, end_time, **kwargs)  # noqa: E501
            return data

    def chart_marks_with_http_info(self, exchange, pair, interval, start_time, end_time, **kwargs):  # noqa: E501
        """chartMarks — Get Chart Timescale Marks  # noqa: E501

        Retrieve chart timescale marks (annotations like buy/sell triggers) for a pair and interval.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.chart_marks_with_http_info(exchange, pair, interval, start_time, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: (required)
        :param str pair: (required)
        :param str interval: Time interval in minutes. (required)
        :param str start_time: Start time (UNIX timestamp seconds). (required)
        :param str end_time: End time (UNIX timestamp seconds). (required)
        :return: ChartMarksResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange', 'pair', 'interval', 'start_time', 'end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method chart_marks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `chart_marks`")  # noqa: E501
        # verify the required parameter 'pair' is set
        if ('pair' not in params or
                params['pair'] is None):
            raise ValueError("Missing the required parameter `pair` when calling `chart_marks`")  # noqa: E501
        # verify the required parameter 'interval' is set
        if ('interval' not in params or
                params['interval'] is None):
            raise ValueError("Missing the required parameter `interval` when calling `chart_marks`")  # noqa: E501
        # verify the required parameter 'start_time' is set
        if ('start_time' not in params or
                params['start_time'] is None):
            raise ValueError("Missing the required parameter `start_time` when calling `chart_marks`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if ('end_time' not in params or
                params['end_time'] is None):
            raise ValueError("Missing the required parameter `end_time` when calling `chart_marks`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501
        if 'pair' in params:
            query_params.append(('pair', params['pair']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'start_time' in params:
            query_params.append(('startTime', params['start_time']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/chart/marks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ChartMarksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_full(self, **kwargs):  # noqa: E501
        """configFull — Get Full Configuration  # noqa: E501

        Retrieve the entire application configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_full(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigFullResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_full_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.config_full_with_http_info(**kwargs)  # noqa: E501
            return data

    def config_full_with_http_info(self, **kwargs):  # noqa: E501
        """configFull — Get Full Configuration  # noqa: E501

        Retrieve the entire application configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_full_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigFullResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_full" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/full', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigFullResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_pair_add(self, body, **kwargs):  # noqa: E501
        """configPairAdd — Add Trading Pair to Configuration  # noqa: E501

        Add a new trading pair to the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_pair_add(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigPairAddRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_pair_add_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.config_pair_add_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def config_pair_add_with_http_info(self, body, **kwargs):  # noqa: E501
        """configPairAdd — Add Trading Pair to Configuration  # noqa: E501

        Add a new trading pair to the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_pair_add_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigPairAddRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_pair_add" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `config_pair_add`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/pair/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_pair_remove(self, body, **kwargs):  # noqa: E501
        """configPairRemove — Remove Trading Pair from Configuration  # noqa: E501

        Remove a trading pair from the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_pair_remove(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigPairRemoveRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_pair_remove_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.config_pair_remove_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def config_pair_remove_with_http_info(self, body, **kwargs):  # noqa: E501
        """configPairRemove — Remove Trading Pair from Configuration  # noqa: E501

        Remove a trading pair from the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_pair_remove_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigPairRemoveRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_pair_remove" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `config_pair_remove`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/pair/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_strategy_add(self, body, **kwargs):  # noqa: E501
        """configStrategyAdd — Add Trading Strategy to Configuration  # noqa: E501

        Add a new trading strategy to the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_strategy_add(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigStrategyAddRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_strategy_add_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.config_strategy_add_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def config_strategy_add_with_http_info(self, body, **kwargs):  # noqa: E501
        """configStrategyAdd — Add Trading Strategy to Configuration  # noqa: E501

        Add a new trading strategy to the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_strategy_add_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigStrategyAddRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_strategy_add" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `config_strategy_add`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/strategy/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_strategy_remove(self, body, **kwargs):  # noqa: E501
        """configStrategyRemove — Remove Trading Strategy from Configuration  # noqa: E501

        Remove a trading strategy from the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_strategy_remove(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigStrategyRemoveRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_strategy_remove_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.config_strategy_remove_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def config_strategy_remove_with_http_info(self, body, **kwargs):  # noqa: E501
        """configStrategyRemove — Remove Trading Strategy from Configuration  # noqa: E501

        Remove a trading strategy from the configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_strategy_remove_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigStrategyRemoveRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_strategy_remove" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `config_strategy_remove`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/strategy/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def config_update(self, body, **kwargs):  # noqa: E501
        """configUpdate — Update Full Configuration  # noqa: E501

        Update the entire configuration with a new object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_update(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigUpdateRequest body: (required)
        :return: ConfigUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_update_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.config_update_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def config_update_with_http_info(self, body, **kwargs):  # noqa: E501
        """configUpdate — Update Full Configuration  # noqa: E501

        Update the entire configuration with a new object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_update_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConfigUpdateRequest body: (required)
        :return: ConfigUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `config_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/config/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def coremem(self, **kwargs):  # noqa: E501
        """coremem — Get Core Memory Snapshot (All Pairs)  # noqa: E501

        Retrieve a snapshot of relevant core memory data for all active trading pairs. Data is slightly delayed and transformed for frontend use.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CoreMemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.coremem_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.coremem_with_http_info(**kwargs)  # noqa: E501
            return data

    def coremem_with_http_info(self, **kwargs):  # noqa: E501
        """coremem — Get Core Memory Snapshot (All Pairs)  # noqa: E501

        Retrieve a snapshot of relevant core memory data for all active trading pairs. Data is slightly delayed and transformed for frontend use.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CoreMemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method coremem" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/coremem', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoreMemSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def coremem_request(self, body, **kwargs):  # noqa: E501
        """corememRequest — Get Raw Core Memory Data for a Pair  # noqa: E501

        Retrieve raw core memory data for a specific trading pair, optionally filtered by elements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem_request(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CoreMemRawRequest body: (required)
        :return: CoreMemRawResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.coremem_request_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.coremem_request_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def coremem_request_with_http_info(self, body, **kwargs):  # noqa: E501
        """corememRequest — Get Raw Core Memory Data for a Pair  # noqa: E501

        Retrieve raw core memory data for a specific trading pair, optionally filtered by elements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem_request_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CoreMemRawRequest body: (required)
        :return: CoreMemRawResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method coremem_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `coremem_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/coremem/raw', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoreMemRawResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def coremem_single(self, body, **kwargs):  # noqa: E501
        """corememSingle — Get Core Memory Snapshot (Single Pair)  # noqa: E501

        Retrieve a snapshot of relevant core memory data for a single active trading pair. Data is slightly delayed and transformed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem_single(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CoreMemSingleRequest body: (required)
        :return: CoreMemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.coremem_single_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.coremem_single_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def coremem_single_with_http_info(self, body, **kwargs):  # noqa: E501
        """corememSingle — Get Core Memory Snapshot (Single Pair)  # noqa: E501

        Retrieve a snapshot of relevant core memory data for a single active trading pair. Data is slightly delayed and transformed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.coremem_single_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CoreMemSingleRequest body: (required)
        :return: CoreMemSnapshotResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method coremem_single" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `coremem_single`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/coremem/single', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CoreMemSnapshotResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_acvar(self, **kwargs):  # noqa: E501
        """filesAcvar — List AutoConfig Variable Files  # noqa: E501

        List filenames of available AutoConfig variable files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_acvar(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_acvar_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_acvar_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_acvar_with_http_info(self, **kwargs):  # noqa: E501
        """filesAcvar — List AutoConfig Variable Files  # noqa: E501

        List filenames of available AutoConfig variable files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_acvar_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_acvar" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/acvar', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_acvar_get(self, **kwargs):  # noqa: E501
        """filesAcvarGet — Get AutoConfig Variable File Content  # noqa: E501

        Retrieve the content of a specified AutoConfig variable file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_acvar_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body:
        :return: FileAclarContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_acvar_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_acvar_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_acvar_get_with_http_info(self, **kwargs):  # noqa: E501
        """filesAcvarGet — Get AutoConfig Variable File Content  # noqa: E501

        Retrieve the content of a specified AutoConfig variable file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_acvar_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body:
        :return: FileAclarContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_acvar_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/acvar/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileAclarContentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_autoconfig_write(self, body, **kwargs):  # noqa: E501
        """filesAutoconfigWrite — Write to autoconfig.json File  # noqa: E501

        Write content to the `autoconfig.json` file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_autoconfig_write(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_autoconfig_write_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_autoconfig_write_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_autoconfig_write_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesAutoconfigWrite — Write to autoconfig.json File  # noqa: E501

        Write content to the `autoconfig.json` file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_autoconfig_write_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_autoconfig_write" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_autoconfig_write`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/autoconfig/write', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_backup(self, **kwargs):  # noqa: E501
        """filesBackup — List Backup Files  # noqa: E501

        List available backup files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_backup(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_backup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_backup_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_backup_with_http_info(self, **kwargs):  # noqa: E501
        """filesBackup — List Backup Files  # noqa: E501

        List available backup files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_backup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_backup" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/backup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_backup_get(self, body, **kwargs):  # noqa: E501
        """filesBackupGet — Get Backup File Content  # noqa: E501

        Retrieve the content of a specified backup config file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_backup_get(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: FileContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_backup_get_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_backup_get_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_backup_get_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesBackupGet — Get Backup File Content  # noqa: E501

        Retrieve the content of a specified backup config file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_backup_get_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: FileContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_backup_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_backup_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/backup/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileContentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_custom_editor_get(self, **kwargs):  # noqa: E501
        """filesCustomEditorGet — Get Custom Strategy Editor File Content  # noqa: E501

        Retrieve the content of the custom strategy editor file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_custom_editor_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_custom_editor_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_custom_editor_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_custom_editor_get_with_http_info(self, **kwargs):  # noqa: E501
        """filesCustomEditorGet — Get Custom Strategy Editor File Content  # noqa: E501

        Retrieve the content of the custom strategy editor file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_custom_editor_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_custom_editor_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/custom-editor/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_custom_editor_write(self, body, **kwargs):  # noqa: E501
        """filesCustomEditorWrite — Write to Custom Strategy Editor File  # noqa: E501

        Write content to the custom strategy editor file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_custom_editor_write(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_custom_editor_write_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_custom_editor_write_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_custom_editor_write_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesCustomEditorWrite — Write to Custom Strategy Editor File  # noqa: E501

        Write content to the custom strategy editor file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_custom_editor_write_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_custom_editor_write" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_custom_editor_write`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/custom-editor/write', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_state(self, **kwargs):  # noqa: E501
        """filesState — List State Files  # noqa: E501

        List filenames of available state files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_state(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_state_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_state_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_state_with_http_info(self, **kwargs):  # noqa: E501
        """filesState — List State Files  # noqa: E501

        List filenames of available state files.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_state_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_state" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/state', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_state_get(self, body, **kwargs):  # noqa: E501
        """filesStateGet — Get State File Content  # noqa: E501

        Retrieve the content of a specific state file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_state_get(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: FileStateContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_state_get_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_state_get_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_state_get_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesStateGet — Get State File Content  # noqa: E501

        Retrieve the content of a specific state file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_state_get_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: FileStateContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_state_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_state_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/state/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileStateContentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_strategy(self, **kwargs):  # noqa: E501
        """filesStrategy — List Custom Strategy Files  # noqa: E501

        List filenames of available custom strategy files (JavaScript files).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_strategy_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.files_strategy_with_http_info(**kwargs)  # noqa: E501
            return data

    def files_strategy_with_http_info(self, **kwargs):  # noqa: E501
        """filesStrategy — List Custom Strategy Files  # noqa: E501

        List filenames of available custom strategy files (JavaScript files).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: FileListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_strategy" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/strategy', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_strategy_delete(self, body, **kwargs):  # noqa: E501
        """filesStrategyDelete — Delete Custom Strategy File  # noqa: E501

        Delete a specific custom strategy file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_delete(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_strategy_delete_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_strategy_delete_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_strategy_delete_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesStrategyDelete — Delete Custom Strategy File  # noqa: E501

        Delete a specific custom strategy file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_delete_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_strategy_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_strategy_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/strategy/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_strategy_get(self, body, **kwargs):  # noqa: E501
        """filesStrategyGet — Get Custom Strategy File Content  # noqa: E501

        Retrieve the content of a specific custom strategy file. The response is the raw content of the file, likely JavaScript code, wrapped in a JSON object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_get(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_strategy_get_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_strategy_get_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_strategy_get_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesStrategyGet — Get Custom Strategy File Content  # noqa: E501

        Retrieve the content of a specific custom strategy file. The response is the raw content of the file, likely JavaScript code, wrapped in a JSON object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_get_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileGetRequest body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_strategy_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_strategy_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/strategy/get', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_strategy_write(self, body, **kwargs):  # noqa: E501
        """filesStrategyWrite — Write to Custom Strategy File  # noqa: E501

        Write JavaScript code content to a specific custom strategy file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_write(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileStrategyWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_strategy_write_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.files_strategy_write_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def files_strategy_write_with_http_info(self, body, **kwargs):  # noqa: E501
        """filesStrategyWrite — Write to Custom Strategy File  # noqa: E501

        Write JavaScript code content to a specific custom strategy file.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_strategy_write_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param FileStrategyWriteRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_strategy_write" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `files_strategy_write`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/files/strategy/write', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def license_keys_edit(self, body, **kwargs):  # noqa: E501
        """licenseKeysEdit — Edit License Keys  # noqa: E501

        Edit license keys for a wallet, optionally verifying with an exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.license_keys_edit(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseKeysEditRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.license_keys_edit_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.license_keys_edit_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def license_keys_edit_with_http_info(self, body, **kwargs):  # noqa: E501
        """licenseKeysEdit — Edit License Keys  # noqa: E501

        Edit license keys for a wallet, optionally verifying with an exchange.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.license_keys_edit_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LicenseKeysEditRequest body: (required)
        :return: SuccessStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method license_keys_edit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `license_keys_edit`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/license/keys/edit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def market_candles(self, key, **kwargs):  # noqa: E501
        """marketCandles — Get Market Candles (OHLCV)  # noqa: E501

        Retrieve historical OHLCV candle data for a trading pair. The `key` parameter (exchange/pair) must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.market_candles(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading pair key (e.g., `binance%2FUSDT-PEPE`). (required)
        :return: MarketCandlesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.market_candles_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.market_candles_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def market_candles_with_http_info(self, key, **kwargs):  # noqa: E501
        """marketCandles — Get Market Candles (OHLCV)  # noqa: E501

        Retrieve historical OHLCV candle data for a trading pair. The `key` parameter (exchange/pair) must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.market_candles_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading pair key (e.g., `binance%2FUSDT-PEPE`). (required)
        :return: MarketCandlesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method market_candles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `market_candles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/market/candles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarketCandlesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def market_orderbook(self, key, **kwargs):  # noqa: E501
        """marketOrderbook — Get Market Orderbook  # noqa: E501

        Retrieve current order book (bids and asks) for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.market_orderbook(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading pair key (e.g., `binance%2FUSDT-PEPE`). (required)
        :return: MarketOrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.market_orderbook_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.market_orderbook_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def market_orderbook_with_http_info(self, key, **kwargs):  # noqa: E501
        """marketOrderbook — Get Market Orderbook  # noqa: E501

        Retrieve current order book (bids and asks) for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.market_orderbook_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading pair key (e.g., `binance%2FUSDT-PEPE`). (required)
        :return: MarketOrderbookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method market_orderbook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `market_orderbook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/market/orderbook', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MarketOrderbookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orders(self, key, **kwargs):  # noqa: E501
        """orders — Get Order History for a Pair  # noqa: E501

        Retrieve locally stored order history for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded exchange/pair key (e.g., `binance%2FUSDT-XRP`). (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orders_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.orders_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def orders_with_http_info(self, key, **kwargs):  # noqa: E501
        """orders — Get Order History for a Pair  # noqa: E501

        Retrieve locally stored order history for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded exchange/pair key (e.g., `binance%2FUSDT-XRP`). (required)
        :return: OrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orders_day(self, timezone, keys, **kwargs):  # noqa: E501
        """ordersDay — Get Orders for Current Day (Multiple Pairs)  # noqa: E501

        Retrieve orders from the current day for multiple trading pairs. Individual keys in `keys[]` array must be URL-encoded if they contain special characters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_day(timezone, keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str timezone: IANA timezone (e.g., `America/New_York`). (required)
        :param list[str] keys: Array of exchange/pair keys. Each key should be URL-encoded if needed. (required)
        :return: OrdersDayResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orders_day_with_http_info(timezone, keys, **kwargs)  # noqa: E501
        else:
            (data) = self.orders_day_with_http_info(timezone, keys, **kwargs)  # noqa: E501
            return data

    def orders_day_with_http_info(self, timezone, keys, **kwargs):  # noqa: E501
        """ordersDay — Get Orders for Current Day (Multiple Pairs)  # noqa: E501

        Retrieve orders from the current day for multiple trading pairs. Individual keys in `keys[]` array must be URL-encoded if they contain special characters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_day_with_http_info(timezone, keys, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str timezone: IANA timezone (e.g., `America/New_York`). (required)
        :param list[str] keys: Array of exchange/pair keys. Each key should be URL-encoded if needed. (required)
        :return: OrdersDayResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timezone', 'keys']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orders_day" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'timezone' is set
        if ('timezone' not in params or
                params['timezone'] is None):
            raise ValueError("Missing the required parameter `timezone` when calling `orders_day`")  # noqa: E501
        # verify the required parameter 'keys' is set
        if ('keys' not in params or
                params['keys'] is None):
            raise ValueError("Missing the required parameter `keys` when calling `orders_day`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timezone' in params:
            query_params.append(('timezone', params['timezone']))  # noqa: E501
        if 'keys' in params:
            query_params.append(('keys[]', params['keys']))  # noqa: E501
            collection_formats['keys[]'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orders/day', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersDayResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orders_page(self, key, page, page_size, **kwargs):  # noqa: E501
        """ordersPage — Get Paginated Orders for a Pair  # noqa: E501

        Retrieve paginated orders for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_page(key, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded exchange/pair key. (required)
        :param int page: Page number (0-indexed). (required)
        :param int page_size: Records per page. (required)
        :return: OrdersPageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orders_page_with_http_info(key, page, page_size, **kwargs)  # noqa: E501
        else:
            (data) = self.orders_page_with_http_info(key, page, page_size, **kwargs)  # noqa: E501
            return data

    def orders_page_with_http_info(self, key, page, page_size, **kwargs):  # noqa: E501
        """ordersPage — Get Paginated Orders for a Pair  # noqa: E501

        Retrieve paginated orders for a trading pair. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_page_with_http_info(key, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded exchange/pair key. (required)
        :param int page: Page number (0-indexed). (required)
        :param int page_size: Records per page. (required)
        :return: OrdersPageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orders_page" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `orders_page`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `orders_page`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `orders_page`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orders/page', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersPageResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def orders_page_multi(self, keys, page, page_size, **kwargs):  # noqa: E501
        """ordersPageMulti — Get Paginated Orders (Multiple Pairs)  # noqa: E501

        Retrieve paginated orders for multiple trading pairs. Individual keys in `keys[]` array must be URL-encoded if needed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_page_multi(keys, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] keys: Array of exchange/pair keys. Each key should be URL-encoded if needed. (required)
        :param int page: Page number (0-indexed). (required)
        :param int page_size: Records per page. (required)
        :return: OrdersPageMultiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.orders_page_multi_with_http_info(keys, page, page_size, **kwargs)  # noqa: E501
        else:
            (data) = self.orders_page_multi_with_http_info(keys, page, page_size, **kwargs)  # noqa: E501
            return data

    def orders_page_multi_with_http_info(self, keys, page, page_size, **kwargs):  # noqa: E501
        """ordersPageMulti — Get Paginated Orders (Multiple Pairs)  # noqa: E501

        Retrieve paginated orders for multiple trading pairs. Individual keys in `keys[]` array must be URL-encoded if needed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.orders_page_multi_with_http_info(keys, page, page_size, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] keys: Array of exchange/pair keys. Each key should be URL-encoded if needed. (required)
        :param int page: Page number (0-indexed). (required)
        :param int page_size: Records per page. (required)
        :return: OrdersPageMultiResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keys', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method orders_page_multi" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'keys' is set
        if ('keys' not in params or
                params['keys'] is None):
            raise ValueError("Missing the required parameter `keys` when calling `orders_page_multi`")  # noqa: E501
        # verify the required parameter 'page' is set
        if ('page' not in params or
                params['page'] is None):
            raise ValueError("Missing the required parameter `page` when calling `orders_page_multi`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `orders_page_multi`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'keys' in params:
            query_params.append(('keys[]', params['keys']))  # noqa: E501
            collection_formats['keys[]'] = 'multi'  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orders/page/multi', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrdersPageMultiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pairs(self, exchange, **kwargs):  # noqa: E501
        """pairs — Get Trading Pairs  # noqa: E501

        Retrieve a list of trading pairs for a specified exchange. The `exchange` parameter should be URL-encoded if it contains special characters (e.g., `#` as `%23`).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pairs(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: Exchange name (e.g., `binance%233`). (required)
        :return: PairsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pairs_with_http_info(exchange, **kwargs)  # noqa: E501
        else:
            (data) = self.pairs_with_http_info(exchange, **kwargs)  # noqa: E501
            return data

    def pairs_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """pairs — Get Trading Pairs  # noqa: E501

        Retrieve a list of trading pairs for a specified exchange. The `exchange` parameter should be URL-encoded if it contains special characters (e.g., `#` as `%23`).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pairs_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: Exchange name (e.g., `binance%233`). (required)
        :return: PairsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pairs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `pairs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pairs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PairsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pairs_detailed(self, exchange, **kwargs):  # noqa: E501
        """pairsDetailed — Get Detailed Trading Pairs  # noqa: E501

        Retrieve detailed trading pair information for a specified exchange. The `exchange` parameter should be URL-encoded if it contains special characters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pairs_detailed(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: Exchange name (e.g., `binance%233`). (required)
        :return: PairsDetailedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pairs_detailed_with_http_info(exchange, **kwargs)  # noqa: E501
        else:
            (data) = self.pairs_detailed_with_http_info(exchange, **kwargs)  # noqa: E501
            return data

    def pairs_detailed_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """pairsDetailed — Get Detailed Trading Pairs  # noqa: E501

        Retrieve detailed trading pair information for a specified exchange. The `exchange` parameter should be URL-encoded if it contains special characters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pairs_detailed_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: Exchange name (e.g., `binance%233`). (required)
        :return: PairsDetailedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pairs_detailed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `pairs_detailed`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pairs/detailed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PairsDetailedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pnl_daily(self, key, start_timestamp, end_timestamp, **kwargs):  # noqa: E501
        """pnlDaily — Get Daily PNL for a Trading Key  # noqa: E501

        Retrieve daily PNL data for a specific trading key within a time range. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_daily(key, start_timestamp, end_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key (e.g. `binance%2FUSDT-XRP`). (required)
        :param int start_timestamp: Start timestamp (ms). (required)
        :param int end_timestamp: End timestamp (ms). (required)
        :return: PnlDailyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pnl_daily_with_http_info(key, start_timestamp, end_timestamp, **kwargs)  # noqa: E501
        else:
            (data) = self.pnl_daily_with_http_info(key, start_timestamp, end_timestamp, **kwargs)  # noqa: E501
            return data

    def pnl_daily_with_http_info(self, key, start_timestamp, end_timestamp, **kwargs):  # noqa: E501
        """pnlDaily — Get Daily PNL for a Trading Key  # noqa: E501

        Retrieve daily PNL data for a specific trading key within a time range. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_daily_with_http_info(key, start_timestamp, end_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key (e.g. `binance%2FUSDT-XRP`). (required)
        :param int start_timestamp: Start timestamp (ms). (required)
        :param int end_timestamp: End timestamp (ms). (required)
        :return: PnlDailyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'start_timestamp', 'end_timestamp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pnl_daily" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `pnl_daily`")  # noqa: E501
        # verify the required parameter 'start_timestamp' is set
        if ('start_timestamp' not in params or
                params['start_timestamp'] is None):
            raise ValueError("Missing the required parameter `start_timestamp` when calling `pnl_daily`")  # noqa: E501
        # verify the required parameter 'end_timestamp' is set
        if ('end_timestamp' not in params or
                params['end_timestamp'] is None):
            raise ValueError("Missing the required parameter `end_timestamp` when calling `pnl_daily`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'start_timestamp' in params:
            query_params.append(('startTimestamp', params['start_timestamp']))  # noqa: E501
        if 'end_timestamp' in params:
            query_params.append(('endTimestamp', params['end_timestamp']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pnl/daily', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PnlDailyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pnl_daily_paginated(self, key, page_num, page_size, end_time, **kwargs):  # noqa: E501
        """pnlDailyPaginated — Get Paginated Daily PNL for a Trading Key  # noqa: E501

        Retrieve paginated daily PNL data for a specific trading key. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_daily_paginated(key, page_num, page_size, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key. (required)
        :param int page_num: Page number. (required)
        :param int page_size: Records per page. (required)
        :param int end_time: End timestamp (ms). (required)
        :return: PnlDailyPaginatedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pnl_daily_paginated_with_http_info(key, page_num, page_size, end_time, **kwargs)  # noqa: E501
        else:
            (data) = self.pnl_daily_paginated_with_http_info(key, page_num, page_size, end_time, **kwargs)  # noqa: E501
            return data

    def pnl_daily_paginated_with_http_info(self, key, page_num, page_size, end_time, **kwargs):  # noqa: E501
        """pnlDailyPaginated — Get Paginated Daily PNL for a Trading Key  # noqa: E501

        Retrieve paginated daily PNL data for a specific trading key. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_daily_paginated_with_http_info(key, page_num, page_size, end_time, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key. (required)
        :param int page_num: Page number. (required)
        :param int page_size: Records per page. (required)
        :param int end_time: End timestamp (ms). (required)
        :return: PnlDailyPaginatedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'page_num', 'page_size', 'end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pnl_daily_paginated" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `pnl_daily_paginated`")  # noqa: E501
        # verify the required parameter 'page_num' is set
        if ('page_num' not in params or
                params['page_num'] is None):
            raise ValueError("Missing the required parameter `page_num` when calling `pnl_daily_paginated`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `pnl_daily_paginated`")  # noqa: E501
        # verify the required parameter 'end_time' is set
        if ('end_time' not in params or
                params['end_time'] is None):
            raise ValueError("Missing the required parameter `end_time` when calling `pnl_daily_paginated`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'page_num' in params:
            query_params.append(('pageNum', params['page_num']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'end_time' in params:
            query_params.append(('endTime', params['end_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pnl/daily/paginated', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PnlDailyPaginatedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pnl_overview(self, body, **kwargs):  # noqa: E501
        """pnlOverview — Get PNL Overview  # noqa: E501

        Retrieve an overview of PNL data, summarized over time periods and trading pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_overview(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PnlOverviewRequest body: (required)
        :return: PnlOverviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pnl_overview_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.pnl_overview_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def pnl_overview_with_http_info(self, body, **kwargs):  # noqa: E501
        """pnlOverview — Get PNL Overview  # noqa: E501

        Retrieve an overview of PNL data, summarized over time periods and trading pairs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_overview_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PnlOverviewRequest body: (required)
        :return: PnlOverviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pnl_overview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `pnl_overview`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pnl/overview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PnlOverviewResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pnl_sum(self, exchange, start_timestamp, end_timestamp, **kwargs):  # noqa: E501
        """pnlSum — Get PNL Sum for an Exchange Key  # noqa: E501

        Retrieve total PNL sum and investment for an exchange key over a time range. The `exchange` parameter (exchange key) must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_sum(exchange, start_timestamp, end_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: URL-encoded exchange key (e.g. `binance%2FUSDT-XRP`). (required)
        :param int start_timestamp: Start timestamp (ms). (required)
        :param int end_timestamp: End timestamp (ms). (required)
        :return: PnlSumResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pnl_sum_with_http_info(exchange, start_timestamp, end_timestamp, **kwargs)  # noqa: E501
        else:
            (data) = self.pnl_sum_with_http_info(exchange, start_timestamp, end_timestamp, **kwargs)  # noqa: E501
            return data

    def pnl_sum_with_http_info(self, exchange, start_timestamp, end_timestamp, **kwargs):  # noqa: E501
        """pnlSum — Get PNL Sum for an Exchange Key  # noqa: E501

        Retrieve total PNL sum and investment for an exchange key over a time range. The `exchange` parameter (exchange key) must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_sum_with_http_info(exchange, start_timestamp, end_timestamp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str exchange: URL-encoded exchange key (e.g. `binance%2FUSDT-XRP`). (required)
        :param int start_timestamp: Start timestamp (ms). (required)
        :param int end_timestamp: End timestamp (ms). (required)
        :return: PnlSumResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['exchange', 'start_timestamp', 'end_timestamp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pnl_sum" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'exchange' is set
        if ('exchange' not in params or
                params['exchange'] is None):
            raise ValueError("Missing the required parameter `exchange` when calling `pnl_sum`")  # noqa: E501
        # verify the required parameter 'start_timestamp' is set
        if ('start_timestamp' not in params or
                params['start_timestamp'] is None):
            raise ValueError("Missing the required parameter `start_timestamp` when calling `pnl_sum`")  # noqa: E501
        # verify the required parameter 'end_timestamp' is set
        if ('end_timestamp' not in params or
                params['end_timestamp'] is None):
            raise ValueError("Missing the required parameter `end_timestamp` when calling `pnl_sum`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in params:
            query_params.append(('exchange', params['exchange']))  # noqa: E501
        if 'start_timestamp' in params:
            query_params.append(('startTimestamp', params['start_timestamp']))  # noqa: E501
        if 'end_timestamp' in params:
            query_params.append(('endTimestamp', params['end_timestamp']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pnl/sum', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PnlSumResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pnl_total(self, key, **kwargs):  # noqa: E501
        """pnlTotal — Get Total PNL for a Trading Key  # noqa: E501

        Retrieve total PNL for a specific trading key. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_total(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key. (required)
        :return: PnlTotalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.pnl_total_with_http_info(key, **kwargs)  # noqa: E501
        else:
            (data) = self.pnl_total_with_http_info(key, **kwargs)  # noqa: E501
            return data

    def pnl_total_with_http_info(self, key, **kwargs):  # noqa: E501
        """pnlTotal — Get Total PNL for a Trading Key  # noqa: E501

        Retrieve total PNL for a specific trading key. The `key` parameter must be URL-encoded.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pnl_total_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: URL-encoded trading key. (required)
        :return: PnlTotalResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pnl_total" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `pnl_total`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pnl/total', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PnlTotalResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_start(self, **kwargs):  # noqa: E501
        """systemStart — Start System  # noqa: E501

        Start the Gunbot system. Returns current configuration without private keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_start(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_start_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_start_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_start_with_http_info(self, **kwargs):  # noqa: E501
        """systemStart — Start System  # noqa: E501

        Start the Gunbot system. Returns current configuration without private keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_start_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_start" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemActionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def system_stop(self, **kwargs):  # noqa: E501
        """systemStop — Stop System  # noqa: E501

        Stop the Gunbot system. Returns current configuration without private keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_stop(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.system_stop_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.system_stop_with_http_info(**kwargs)  # noqa: E501
            return data

    def system_stop_with_http_info(self, **kwargs):  # noqa: E501
        """systemStop — Stop System  # noqa: E501

        Stop the Gunbot system. Returns current configuration without private keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.system_stop_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SystemActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method system_stop" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/system/stop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SystemActionResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def time(self, **kwargs):  # noqa: E501
        """time — Get Server Time  # noqa: E501

        Retrieve the current server time in milliseconds since Unix epoch.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.time(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TimeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.time_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.time_with_http_info(**kwargs)  # noqa: E501
            return data

    def time_with_http_info(self, **kwargs):  # noqa: E501
        """time — Get Server Time  # noqa: E501

        Retrieve the current server time in milliseconds since Unix epoch.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.time_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: TimeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method time" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/time', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TimeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_buy(self, body, **kwargs):  # noqa: E501
        """tradeBuy — Place Limit Buy Order  # noqa: E501

        Place a limit buy order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeLimitOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_buy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_buy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_buy_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeBuy — Place Limit Buy Order  # noqa: E501

        Place a limit buy order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeLimitOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_buy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_buy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/buy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_buy_market(self, body, **kwargs):  # noqa: E501
        """tradeBuyMarket — Place Market Buy Order  # noqa: E501

        Place a market buy order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_market(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeMarketOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_buy_market_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_buy_market_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_buy_market_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeBuyMarket — Place Market Buy Order  # noqa: E501

        Place a market buy order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_market_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeMarketOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_buy_market" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_buy_market`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/buy/market', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_buy_oco(self, body, **kwargs):  # noqa: E501
        """tradeBuyOco — Place OCO Buy Order (Binance)  # noqa: E501

        Place an OCO (One-Cancels-the-Other) buy order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_oco(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeOcoRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_buy_oco_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_buy_oco_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_buy_oco_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeBuyOco — Place OCO Buy Order (Binance)  # noqa: E501

        Place an OCO (One-Cancels-the-Other) buy order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_oco_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeOcoRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_buy_oco" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_buy_oco`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/buy/oco', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_buy_stoplimit(self, body, **kwargs):  # noqa: E501
        """tradeBuyStoplimit — Place Stop-Limit Buy Order (Binance)  # noqa: E501

        Place a stop-limit buy order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_stoplimit(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeStopLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_buy_stoplimit_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_buy_stoplimit_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_buy_stoplimit_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeBuyStoplimit — Place Stop-Limit Buy Order (Binance)  # noqa: E501

        Place a stop-limit buy order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_stoplimit_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeStopLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_buy_stoplimit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_buy_stoplimit`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/buy/stoplimit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_buy_trailingstop(self, body, **kwargs):  # noqa: E501
        """tradeBuyTrailingstop — Place Trailing Stop Buy Order (Binance)  # noqa: E501

        Place a trailing stop buy order on Binance. `price` is the reference price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_trailingstop(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeTrailingStopRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_buy_trailingstop_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_buy_trailingstop_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_buy_trailingstop_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeBuyTrailingstop — Place Trailing Stop Buy Order (Binance)  # noqa: E501

        Place a trailing stop buy order on Binance. `price` is the reference price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_buy_trailingstop_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeTrailingStopRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_buy_trailingstop" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_buy_trailingstop`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/buy/trailingstop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_cancel(self, body, **kwargs):  # noqa: E501
        """tradeCancel — Cancel Order  # noqa: E501

        Cancel an existing order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_cancel(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCancelRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_cancel_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_cancel_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_cancel_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeCancel — Cancel Order  # noqa: E501

        Cancel an existing order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_cancel_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCancelRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_cancel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_cancel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_close(self, body, **kwargs):  # noqa: E501
        """tradeClose — Close Position with Limit Price (Bybit Futures)  # noqa: E501

        Close an open position at a specified limit price on Bybit (futures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_close(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCloseLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_close_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_close_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_close_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeClose — Close Position with Limit Price (Bybit Futures)  # noqa: E501

        Close an open position at a specified limit price on Bybit (futures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_close_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCloseLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_close" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_close`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/close', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_close_market(self, body, **kwargs):  # noqa: E501
        """tradeCloseMarket — Close Position at Market Price (Bybit Futures)  # noqa: E501

        Close an open position at the current market price on Bybit (futures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_close_market(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCloseMarketRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_close_market_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_close_market_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_close_market_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeCloseMarket — Close Position at Market Price (Bybit Futures)  # noqa: E501

        Close an open position at the current market price on Bybit (futures).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_close_market_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeCloseMarketRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_close_market" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_close_market`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/close/market', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_sell(self, body, **kwargs):  # noqa: E501
        """tradeSell — Place Limit Sell Order  # noqa: E501

        Place a limit sell order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeLimitOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_sell_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_sell_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_sell_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeSell — Place Limit Sell Order  # noqa: E501

        Place a limit sell order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeLimitOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_sell" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_sell`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/sell', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_sell_market(self, body, **kwargs):  # noqa: E501
        """tradeSellMarket — Place Market Sell Order  # noqa: E501

        Place a market sell order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_market(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeMarketOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_sell_market_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_sell_market_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_sell_market_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeSellMarket — Place Market Sell Order  # noqa: E501

        Place a market sell order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_market_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeMarketOrderRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_sell_market" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_sell_market`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/sell/market', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_sell_oco(self, body, **kwargs):  # noqa: E501
        """tradeSellOco — Place OCO Sell Order (Binance)  # noqa: E501

        Place an OCO (One-Cancels-the-Other) sell order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_oco(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeOcoRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_sell_oco_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_sell_oco_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_sell_oco_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeSellOco — Place OCO Sell Order (Binance)  # noqa: E501

        Place an OCO (One-Cancels-the-Other) sell order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_oco_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeOcoRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_sell_oco" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_sell_oco`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/sell/oco', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_sell_stoplimit(self, body, **kwargs):  # noqa: E501
        """tradeSellStoplimit — Place Stop-Limit Sell Order (Binance)  # noqa: E501

        Place a stop-limit sell order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_stoplimit(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeStopLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_sell_stoplimit_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_sell_stoplimit_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_sell_stoplimit_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeSellStoplimit — Place Stop-Limit Sell Order (Binance)  # noqa: E501

        Place a stop-limit sell order on Binance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_stoplimit_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeStopLimitRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_sell_stoplimit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_sell_stoplimit`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/sell/stoplimit', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trade_sell_trailingstop(self, body, **kwargs):  # noqa: E501
        """tradeSellTrailingstop — Place Trailing Stop Sell Order (Binance)  # noqa: E501

        Place a trailing stop sell order on Binance. `price` is the reference price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_trailingstop(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeTrailingStopRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trade_sell_trailingstop_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.trade_sell_trailingstop_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def trade_sell_trailingstop_with_http_info(self, body, **kwargs):  # noqa: E501
        """tradeSellTrailingstop — Place Trailing Stop Sell Order (Binance)  # noqa: E501

        Place a trailing stop sell order on Binance. `price` is the reference price.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trade_sell_trailingstop_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TradeTrailingStopRequest body: (required)
        :return: TradeResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trade_sell_trailingstop" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `trade_sell_trailingstop`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/trade/sell/trailingstop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TradeResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
