# coding: utf-8

# flake8: noqa
"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from gunbot_sdk.models.asset_total_item import AssetTotalItem
from gunbot_sdk.models.assets_total_request import AssetsTotalRequest
from gunbot_sdk.models.assets_total_response import AssetsTotalResponse
from gunbot_sdk.models.auth_status_response import AuthStatusResponse
from gunbot_sdk.models.balance_item import BalanceItem
from gunbot_sdk.models.balances_response import BalancesResponse
from gunbot_sdk.models.chart_data_request import ChartDataRequest
from gunbot_sdk.models.chart_data_response import ChartDataResponse
from gunbot_sdk.models.chart_mark_item import ChartMarkItem
from gunbot_sdk.models.chart_marks_response import ChartMarksResponse
from gunbot_sdk.models.config_full_response import ConfigFullResponse
from gunbot_sdk.models.config_pair_add_request import ConfigPairAddRequest
from gunbot_sdk.models.config_pair_remove_request import ConfigPairRemoveRequest
from gunbot_sdk.models.config_strategy_add_request import ConfigStrategyAddRequest
from gunbot_sdk.models.config_strategy_remove_request import ConfigStrategyRemoveRequest
from gunbot_sdk.models.config_update_request import ConfigUpdateRequest
from gunbot_sdk.models.config_update_response import ConfigUpdateResponse
from gunbot_sdk.models.core_mem_raw_request import CoreMemRawRequest
from gunbot_sdk.models.core_mem_raw_response import CoreMemRawResponse
from gunbot_sdk.models.core_mem_single_request import CoreMemSingleRequest
from gunbot_sdk.models.core_mem_snapshot_response import CoreMemSnapshotResponse
from gunbot_sdk.models.error_response import ErrorResponse
from gunbot_sdk.models.file_aclar_content_response import FileAclarContentResponse
from gunbot_sdk.models.file_content_response import FileContentResponse
from gunbot_sdk.models.file_get_request import FileGetRequest
from gunbot_sdk.models.file_list_response import FileListResponse
from gunbot_sdk.models.file_state_content_response import FileStateContentResponse
from gunbot_sdk.models.file_strategy_write_request import FileStrategyWriteRequest
from gunbot_sdk.models.file_write_request import FileWriteRequest
from gunbot_sdk.models.gunbot_config import GunbotConfig
from gunbot_sdk.models.license_keys_edit_request import LicenseKeysEditRequest
from gunbot_sdk.models.login_request import LoginRequest
from gunbot_sdk.models.login_response import LoginResponse
from gunbot_sdk.models.market_candles_response import MarketCandlesResponse
from gunbot_sdk.models.market_orderbook_data import MarketOrderbookData
from gunbot_sdk.models.market_orderbook_response import MarketOrderbookResponse
from gunbot_sdk.models.ohlcv_data import OHLCVData
from gunbot_sdk.models.one_of_file_write_request_document import OneOfFileWriteRequestDocument
from gunbot_sdk.models.one_of_order_item_id import OneOfOrderItemId
from gunbot_sdk.models.order_item import OrderItem
from gunbot_sdk.models.orderbook_level import OrderbookLevel
from gunbot_sdk.models.orders_day_response import OrdersDayResponse
from gunbot_sdk.models.orders_page_multi_response import OrdersPageMultiResponse
from gunbot_sdk.models.orders_page_response import OrdersPageResponse
from gunbot_sdk.models.orders_response import OrdersResponse
from gunbot_sdk.models.pair_detail_item import PairDetailItem
from gunbot_sdk.models.pairs_detailed_response import PairsDetailedResponse
from gunbot_sdk.models.pairs_response import PairsResponse
from gunbot_sdk.models.pnl_daily_paginated_response import PnlDailyPaginatedResponse
from gunbot_sdk.models.pnl_daily_response import PnlDailyResponse
from gunbot_sdk.models.pnl_overview_request import PnlOverviewRequest
from gunbot_sdk.models.pnl_overview_request_date_range import PnlOverviewRequestDateRange
from gunbot_sdk.models.pnl_overview_response import PnlOverviewResponse
from gunbot_sdk.models.pnl_sum_response import PnlSumResponse
from gunbot_sdk.models.pnl_sum_response_tournament_data import PnlSumResponseTournamentData
from gunbot_sdk.models.pnl_total_response import PnlTotalResponse
from gunbot_sdk.models.success_status_response import SuccessStatusResponse
from gunbot_sdk.models.system_action_response import SystemActionResponse
from gunbot_sdk.models.time_response import TimeResponse
from gunbot_sdk.models.trade_cancel_data import TradeCancelData
from gunbot_sdk.models.trade_cancel_request import TradeCancelRequest
from gunbot_sdk.models.trade_close_limit_data import TradeCloseLimitData
from gunbot_sdk.models.trade_close_limit_request import TradeCloseLimitRequest
from gunbot_sdk.models.trade_close_market_data import TradeCloseMarketData
from gunbot_sdk.models.trade_close_market_request import TradeCloseMarketRequest
from gunbot_sdk.models.trade_limit_order_data import TradeLimitOrderData
from gunbot_sdk.models.trade_limit_order_request import TradeLimitOrderRequest
from gunbot_sdk.models.trade_market_order_data import TradeMarketOrderData
from gunbot_sdk.models.trade_market_order_request import TradeMarketOrderRequest
from gunbot_sdk.models.trade_oco_data import TradeOcoData
from gunbot_sdk.models.trade_oco_request import TradeOcoRequest
from gunbot_sdk.models.trade_response import TradeResponse
from gunbot_sdk.models.trade_stop_limit_data import TradeStopLimitData
from gunbot_sdk.models.trade_stop_limit_request import TradeStopLimitRequest
from gunbot_sdk.models.trade_trailing_stop_data import TradeTrailingStopData
from gunbot_sdk.models.trade_trailing_stop_request import TradeTrailingStopRequest
