# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AuthStatusResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'code': 'int',
        'is_demo': 'bool',
        'is_registered': 'bool',
        'is_two_fa': 'bool',
        'metamask': 'bool',
        'status': 'str',
        'message': 'str'
    }

    attribute_map = {
        'code': 'code',
        'is_demo': 'isDemo',
        'is_registered': 'isRegistered',
        'is_two_fa': 'isTwoFA',
        'metamask': 'metamask',
        'status': 'status',
        'message': 'message'
    }

    def __init__(self, code=None, is_demo=None, is_registered=None, is_two_fa=None, metamask=None, status=None, message=None):  # noqa: E501
        """AuthStatusResponse - a model defined in Swagger"""  # noqa: E501
        self._code = None
        self._is_demo = None
        self._is_registered = None
        self._is_two_fa = None
        self._metamask = None
        self._status = None
        self._message = None
        self.discriminator = None
        if code is not None:
            self.code = code
        if is_demo is not None:
            self.is_demo = is_demo
        if is_registered is not None:
            self.is_registered = is_registered
        if is_two_fa is not None:
            self.is_two_fa = is_two_fa
        if metamask is not None:
            self.metamask = metamask
        if status is not None:
            self.status = status
        if message is not None:
            self.message = message

    @property
    def code(self):
        """Gets the code of this AuthStatusResponse.  # noqa: E501


        :return: The code of this AuthStatusResponse.  # noqa: E501
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this AuthStatusResponse.


        :param code: The code of this AuthStatusResponse.  # noqa: E501
        :type: int
        """

        self._code = code

    @property
    def is_demo(self):
        """Gets the is_demo of this AuthStatusResponse.  # noqa: E501


        :return: The is_demo of this AuthStatusResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_demo

    @is_demo.setter
    def is_demo(self, is_demo):
        """Sets the is_demo of this AuthStatusResponse.


        :param is_demo: The is_demo of this AuthStatusResponse.  # noqa: E501
        :type: bool
        """

        self._is_demo = is_demo

    @property
    def is_registered(self):
        """Gets the is_registered of this AuthStatusResponse.  # noqa: E501


        :return: The is_registered of this AuthStatusResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_registered

    @is_registered.setter
    def is_registered(self, is_registered):
        """Sets the is_registered of this AuthStatusResponse.


        :param is_registered: The is_registered of this AuthStatusResponse.  # noqa: E501
        :type: bool
        """

        self._is_registered = is_registered

    @property
    def is_two_fa(self):
        """Gets the is_two_fa of this AuthStatusResponse.  # noqa: E501


        :return: The is_two_fa of this AuthStatusResponse.  # noqa: E501
        :rtype: bool
        """
        return self._is_two_fa

    @is_two_fa.setter
    def is_two_fa(self, is_two_fa):
        """Sets the is_two_fa of this AuthStatusResponse.


        :param is_two_fa: The is_two_fa of this AuthStatusResponse.  # noqa: E501
        :type: bool
        """

        self._is_two_fa = is_two_fa

    @property
    def metamask(self):
        """Gets the metamask of this AuthStatusResponse.  # noqa: E501


        :return: The metamask of this AuthStatusResponse.  # noqa: E501
        :rtype: bool
        """
        return self._metamask

    @metamask.setter
    def metamask(self, metamask):
        """Sets the metamask of this AuthStatusResponse.


        :param metamask: The metamask of this AuthStatusResponse.  # noqa: E501
        :type: bool
        """

        self._metamask = metamask

    @property
    def status(self):
        """Gets the status of this AuthStatusResponse.  # noqa: E501


        :return: The status of this AuthStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this AuthStatusResponse.


        :param status: The status of this AuthStatusResponse.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def message(self):
        """Gets the message of this AuthStatusResponse.  # noqa: E501


        :return: The message of this AuthStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this AuthStatusResponse.


        :param message: The message of this AuthStatusResponse.  # noqa: E501
        :type: str
        """

        self._message = message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AuthStatusResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuthStatusResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
