# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class BalanceItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'asset': 'str',
        'exchange': 'str',
        'available_qty': 'str',
        'on_order': 'str'
    }

    attribute_map = {
        'asset': 'Asset',
        'exchange': 'Exchange',
        'available_qty': 'Available Qty',
        'on_order': 'On Order'
    }

    def __init__(self, asset=None, exchange=None, available_qty=None, on_order=None):  # noqa: E501
        """BalanceItem - a model defined in Swagger"""  # noqa: E501
        self._asset = None
        self._exchange = None
        self._available_qty = None
        self._on_order = None
        self.discriminator = None
        if asset is not None:
            self.asset = asset
        if exchange is not None:
            self.exchange = exchange
        if available_qty is not None:
            self.available_qty = available_qty
        if on_order is not None:
            self.on_order = on_order

    @property
    def asset(self):
        """Gets the asset of this BalanceItem.  # noqa: E501


        :return: The asset of this BalanceItem.  # noqa: E501
        :rtype: str
        """
        return self._asset

    @asset.setter
    def asset(self, asset):
        """Sets the asset of this BalanceItem.


        :param asset: The asset of this BalanceItem.  # noqa: E501
        :type: str
        """

        self._asset = asset

    @property
    def exchange(self):
        """Gets the exchange of this BalanceItem.  # noqa: E501


        :return: The exchange of this BalanceItem.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this BalanceItem.


        :param exchange: The exchange of this BalanceItem.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def available_qty(self):
        """Gets the available_qty of this BalanceItem.  # noqa: E501

        Available quantity, as a string.  # noqa: E501

        :return: The available_qty of this BalanceItem.  # noqa: E501
        :rtype: str
        """
        return self._available_qty

    @available_qty.setter
    def available_qty(self, available_qty):
        """Sets the available_qty of this BalanceItem.

        Available quantity, as a string.  # noqa: E501

        :param available_qty: The available_qty of this BalanceItem.  # noqa: E501
        :type: str
        """

        self._available_qty = available_qty

    @property
    def on_order(self):
        """Gets the on_order of this BalanceItem.  # noqa: E501

        Quantity on order, as a string.  # noqa: E501

        :return: The on_order of this BalanceItem.  # noqa: E501
        :rtype: str
        """
        return self._on_order

    @on_order.setter
    def on_order(self, on_order):
        """Sets the on_order of this BalanceItem.

        Quantity on order, as a string.  # noqa: E501

        :param on_order: The on_order of this BalanceItem.  # noqa: E501
        :type: str
        """

        self._on_order = on_order

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(BalanceItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BalanceItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
