# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ChartMarkItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exchange': 'str',
        'pair': 'str',
        'id': 'str',
        'time': 'int',
        'color': 'str',
        'label': 'str',
        'tooltip': 'list[str]'
    }

    attribute_map = {
        'exchange': 'exchange',
        'pair': 'pair',
        'id': 'id',
        'time': 'time',
        'color': 'color',
        'label': 'label',
        'tooltip': 'tooltip'
    }

    def __init__(self, exchange=None, pair=None, id=None, time=None, color=None, label=None, tooltip=None):  # noqa: E501
        """ChartMarkItem - a model defined in Swagger"""  # noqa: E501
        self._exchange = None
        self._pair = None
        self._id = None
        self._time = None
        self._color = None
        self._label = None
        self._tooltip = None
        self.discriminator = None
        if exchange is not None:
            self.exchange = exchange
        if pair is not None:
            self.pair = pair
        if id is not None:
            self.id = id
        if time is not None:
            self.time = time
        if color is not None:
            self.color = color
        if label is not None:
            self.label = label
        if tooltip is not None:
            self.tooltip = tooltip

    @property
    def exchange(self):
        """Gets the exchange of this ChartMarkItem.  # noqa: E501


        :return: The exchange of this ChartMarkItem.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this ChartMarkItem.


        :param exchange: The exchange of this ChartMarkItem.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def pair(self):
        """Gets the pair of this ChartMarkItem.  # noqa: E501


        :return: The pair of this ChartMarkItem.  # noqa: E501
        :rtype: str
        """
        return self._pair

    @pair.setter
    def pair(self, pair):
        """Sets the pair of this ChartMarkItem.


        :param pair: The pair of this ChartMarkItem.  # noqa: E501
        :type: str
        """

        self._pair = pair

    @property
    def id(self):
        """Gets the id of this ChartMarkItem.  # noqa: E501


        :return: The id of this ChartMarkItem.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ChartMarkItem.


        :param id: The id of this ChartMarkItem.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def time(self):
        """Gets the time of this ChartMarkItem.  # noqa: E501


        :return: The time of this ChartMarkItem.  # noqa: E501
        :rtype: int
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this ChartMarkItem.


        :param time: The time of this ChartMarkItem.  # noqa: E501
        :type: int
        """

        self._time = time

    @property
    def color(self):
        """Gets the color of this ChartMarkItem.  # noqa: E501


        :return: The color of this ChartMarkItem.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this ChartMarkItem.


        :param color: The color of this ChartMarkItem.  # noqa: E501
        :type: str
        """

        self._color = color

    @property
    def label(self):
        """Gets the label of this ChartMarkItem.  # noqa: E501


        :return: The label of this ChartMarkItem.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this ChartMarkItem.


        :param label: The label of this ChartMarkItem.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def tooltip(self):
        """Gets the tooltip of this ChartMarkItem.  # noqa: E501


        :return: The tooltip of this ChartMarkItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._tooltip

    @tooltip.setter
    def tooltip(self, tooltip):
        """Sets the tooltip of this ChartMarkItem.


        :param tooltip: The tooltip of this ChartMarkItem.  # noqa: E501
        :type: list[str]
        """

        self._tooltip = tooltip

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ChartMarkItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChartMarkItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
