# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class LicenseKeysEditRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'wallet': 'str',
        'new_licenses': 'dict(str, object)',
        'verify_exchange': 'str'
    }

    attribute_map = {
        'wallet': 'wallet',
        'new_licenses': 'newLicenses',
        'verify_exchange': 'verifyExchange'
    }

    def __init__(self, wallet=None, new_licenses=None, verify_exchange=None):  # noqa: E501
        """LicenseKeysEditRequest - a model defined in Swagger"""  # noqa: E501
        self._wallet = None
        self._new_licenses = None
        self._verify_exchange = None
        self.discriminator = None
        self.wallet = wallet
        self.new_licenses = new_licenses
        self.verify_exchange = verify_exchange

    @property
    def wallet(self):
        """Gets the wallet of this LicenseKeysEditRequest.  # noqa: E501


        :return: The wallet of this LicenseKeysEditRequest.  # noqa: E501
        :rtype: str
        """
        return self._wallet

    @wallet.setter
    def wallet(self, wallet):
        """Sets the wallet of this LicenseKeysEditRequest.


        :param wallet: The wallet of this LicenseKeysEditRequest.  # noqa: E501
        :type: str
        """
        if wallet is None:
            raise ValueError("Invalid value for `wallet`, must not be `None`")  # noqa: E501

        self._wallet = wallet

    @property
    def new_licenses(self):
        """Gets the new_licenses of this LicenseKeysEditRequest.  # noqa: E501

        Object containing new license data. Use the entire config.exchanges object. For new keys, set isEncrypted to false.  # noqa: E501

        :return: The new_licenses of this LicenseKeysEditRequest.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._new_licenses

    @new_licenses.setter
    def new_licenses(self, new_licenses):
        """Sets the new_licenses of this LicenseKeysEditRequest.

        Object containing new license data. Use the entire config.exchanges object. For new keys, set isEncrypted to false.  # noqa: E501

        :param new_licenses: The new_licenses of this LicenseKeysEditRequest.  # noqa: E501
        :type: dict(str, object)
        """
        if new_licenses is None:
            raise ValueError("Invalid value for `new_licenses`, must not be `None`")  # noqa: E501

        self._new_licenses = new_licenses

    @property
    def verify_exchange(self):
        """Gets the verify_exchange of this LicenseKeysEditRequest.  # noqa: E501

        Name of an exchange with valid, registered credentials to authenticate the request.  # noqa: E501

        :return: The verify_exchange of this LicenseKeysEditRequest.  # noqa: E501
        :rtype: str
        """
        return self._verify_exchange

    @verify_exchange.setter
    def verify_exchange(self, verify_exchange):
        """Sets the verify_exchange of this LicenseKeysEditRequest.

        Name of an exchange with valid, registered credentials to authenticate the request.  # noqa: E501

        :param verify_exchange: The verify_exchange of this LicenseKeysEditRequest.  # noqa: E501
        :type: str
        """
        if verify_exchange is None:
            raise ValueError("Invalid value for `verify_exchange`, must not be `None`")  # noqa: E501

        self._verify_exchange = verify_exchange

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LicenseKeysEditRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LicenseKeysEditRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
