# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrderItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'time': 'int',
        'pair': 'str',
        'type': 'str',
        'rate': 'float',
        'amount': 'float',
        'id': 'OneOfOrderItemId',
        'cost': 'float',
        'to_cancel': 'bool',
        'fees': 'float',
        'base_value': 'float',
        'cost_proceed': 'float',
        'average_price': 'float',
        'pnl_price': 'float',
        'balance': 'float',
        'base_balance': 'float',
        'inventory_cost': 'float',
        'abp': 'float',
        'pnl': 'float'
    }

    attribute_map = {
        'time': 'time',
        'pair': 'pair',
        'type': 'type',
        'rate': 'rate',
        'amount': 'amount',
        'id': 'id',
        'cost': 'cost',
        'to_cancel': 'toCancel',
        'fees': 'fees',
        'base_value': 'baseValue',
        'cost_proceed': 'costProceed',
        'average_price': 'averagePrice',
        'pnl_price': 'pnlPrice',
        'balance': 'balance',
        'base_balance': 'baseBalance',
        'inventory_cost': 'inventory_cost',
        'abp': 'ABP',
        'pnl': 'pnl'
    }

    def __init__(self, time=None, pair=None, type=None, rate=None, amount=None, id=None, cost=None, to_cancel=None, fees=None, base_value=None, cost_proceed=None, average_price=None, pnl_price=None, balance=None, base_balance=None, inventory_cost=None, abp=None, pnl=None):  # noqa: E501
        """OrderItem - a model defined in Swagger"""  # noqa: E501
        self._time = None
        self._pair = None
        self._type = None
        self._rate = None
        self._amount = None
        self._id = None
        self._cost = None
        self._to_cancel = None
        self._fees = None
        self._base_value = None
        self._cost_proceed = None
        self._average_price = None
        self._pnl_price = None
        self._balance = None
        self._base_balance = None
        self._inventory_cost = None
        self._abp = None
        self._pnl = None
        self.discriminator = None
        if time is not None:
            self.time = time
        if pair is not None:
            self.pair = pair
        if type is not None:
            self.type = type
        if rate is not None:
            self.rate = rate
        if amount is not None:
            self.amount = amount
        if id is not None:
            self.id = id
        if cost is not None:
            self.cost = cost
        if to_cancel is not None:
            self.to_cancel = to_cancel
        if fees is not None:
            self.fees = fees
        if base_value is not None:
            self.base_value = base_value
        if cost_proceed is not None:
            self.cost_proceed = cost_proceed
        if average_price is not None:
            self.average_price = average_price
        if pnl_price is not None:
            self.pnl_price = pnl_price
        if balance is not None:
            self.balance = balance
        if base_balance is not None:
            self.base_balance = base_balance
        if inventory_cost is not None:
            self.inventory_cost = inventory_cost
        if abp is not None:
            self.abp = abp
        if pnl is not None:
            self.pnl = pnl

    @property
    def time(self):
        """Gets the time of this OrderItem.  # noqa: E501


        :return: The time of this OrderItem.  # noqa: E501
        :rtype: int
        """
        return self._time

    @time.setter
    def time(self, time):
        """Sets the time of this OrderItem.


        :param time: The time of this OrderItem.  # noqa: E501
        :type: int
        """

        self._time = time

    @property
    def pair(self):
        """Gets the pair of this OrderItem.  # noqa: E501


        :return: The pair of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._pair

    @pair.setter
    def pair(self, pair):
        """Sets the pair of this OrderItem.


        :param pair: The pair of this OrderItem.  # noqa: E501
        :type: str
        """

        self._pair = pair

    @property
    def type(self):
        """Gets the type of this OrderItem.  # noqa: E501


        :return: The type of this OrderItem.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderItem.


        :param type: The type of this OrderItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["buy", "sell"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def rate(self):
        """Gets the rate of this OrderItem.  # noqa: E501


        :return: The rate of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """Sets the rate of this OrderItem.


        :param rate: The rate of this OrderItem.  # noqa: E501
        :type: float
        """

        self._rate = rate

    @property
    def amount(self):
        """Gets the amount of this OrderItem.  # noqa: E501


        :return: The amount of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this OrderItem.


        :param amount: The amount of this OrderItem.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def id(self):
        """Gets the id of this OrderItem.  # noqa: E501


        :return: The id of this OrderItem.  # noqa: E501
        :rtype: OneOfOrderItemId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OrderItem.


        :param id: The id of this OrderItem.  # noqa: E501
        :type: OneOfOrderItemId
        """

        self._id = id

    @property
    def cost(self):
        """Gets the cost of this OrderItem.  # noqa: E501


        :return: The cost of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._cost

    @cost.setter
    def cost(self, cost):
        """Sets the cost of this OrderItem.


        :param cost: The cost of this OrderItem.  # noqa: E501
        :type: float
        """

        self._cost = cost

    @property
    def to_cancel(self):
        """Gets the to_cancel of this OrderItem.  # noqa: E501


        :return: The to_cancel of this OrderItem.  # noqa: E501
        :rtype: bool
        """
        return self._to_cancel

    @to_cancel.setter
    def to_cancel(self, to_cancel):
        """Sets the to_cancel of this OrderItem.


        :param to_cancel: The to_cancel of this OrderItem.  # noqa: E501
        :type: bool
        """

        self._to_cancel = to_cancel

    @property
    def fees(self):
        """Gets the fees of this OrderItem.  # noqa: E501


        :return: The fees of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._fees

    @fees.setter
    def fees(self, fees):
        """Sets the fees of this OrderItem.


        :param fees: The fees of this OrderItem.  # noqa: E501
        :type: float
        """

        self._fees = fees

    @property
    def base_value(self):
        """Gets the base_value of this OrderItem.  # noqa: E501


        :return: The base_value of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._base_value

    @base_value.setter
    def base_value(self, base_value):
        """Sets the base_value of this OrderItem.


        :param base_value: The base_value of this OrderItem.  # noqa: E501
        :type: float
        """

        self._base_value = base_value

    @property
    def cost_proceed(self):
        """Gets the cost_proceed of this OrderItem.  # noqa: E501


        :return: The cost_proceed of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._cost_proceed

    @cost_proceed.setter
    def cost_proceed(self, cost_proceed):
        """Sets the cost_proceed of this OrderItem.


        :param cost_proceed: The cost_proceed of this OrderItem.  # noqa: E501
        :type: float
        """

        self._cost_proceed = cost_proceed

    @property
    def average_price(self):
        """Gets the average_price of this OrderItem.  # noqa: E501


        :return: The average_price of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._average_price

    @average_price.setter
    def average_price(self, average_price):
        """Sets the average_price of this OrderItem.


        :param average_price: The average_price of this OrderItem.  # noqa: E501
        :type: float
        """

        self._average_price = average_price

    @property
    def pnl_price(self):
        """Gets the pnl_price of this OrderItem.  # noqa: E501


        :return: The pnl_price of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._pnl_price

    @pnl_price.setter
    def pnl_price(self, pnl_price):
        """Sets the pnl_price of this OrderItem.


        :param pnl_price: The pnl_price of this OrderItem.  # noqa: E501
        :type: float
        """

        self._pnl_price = pnl_price

    @property
    def balance(self):
        """Gets the balance of this OrderItem.  # noqa: E501


        :return: The balance of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._balance

    @balance.setter
    def balance(self, balance):
        """Sets the balance of this OrderItem.


        :param balance: The balance of this OrderItem.  # noqa: E501
        :type: float
        """

        self._balance = balance

    @property
    def base_balance(self):
        """Gets the base_balance of this OrderItem.  # noqa: E501


        :return: The base_balance of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._base_balance

    @base_balance.setter
    def base_balance(self, base_balance):
        """Sets the base_balance of this OrderItem.


        :param base_balance: The base_balance of this OrderItem.  # noqa: E501
        :type: float
        """

        self._base_balance = base_balance

    @property
    def inventory_cost(self):
        """Gets the inventory_cost of this OrderItem.  # noqa: E501


        :return: The inventory_cost of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._inventory_cost

    @inventory_cost.setter
    def inventory_cost(self, inventory_cost):
        """Sets the inventory_cost of this OrderItem.


        :param inventory_cost: The inventory_cost of this OrderItem.  # noqa: E501
        :type: float
        """

        self._inventory_cost = inventory_cost

    @property
    def abp(self):
        """Gets the abp of this OrderItem.  # noqa: E501


        :return: The abp of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._abp

    @abp.setter
    def abp(self, abp):
        """Sets the abp of this OrderItem.


        :param abp: The abp of this OrderItem.  # noqa: E501
        :type: float
        """

        self._abp = abp

    @property
    def pnl(self):
        """Gets the pnl of this OrderItem.  # noqa: E501


        :return: The pnl of this OrderItem.  # noqa: E501
        :rtype: float
        """
        return self._pnl

    @pnl.setter
    def pnl(self, pnl):
        """Sets the pnl of this OrderItem.


        :param pnl: The pnl of this OrderItem.  # noqa: E501
        :type: float
        """

        self._pnl = pnl

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
