# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PairDetailItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'pair_name': 'str',
        'volume': 'float',
        'low': 'str',
        'high': 'str',
        'change': 'str'
    }

    attribute_map = {
        'pair_name': 'pairName',
        'volume': 'volume',
        'low': 'low',
        'high': 'high',
        'change': 'change'
    }

    def __init__(self, pair_name=None, volume=None, low=None, high=None, change=None):  # noqa: E501
        """PairDetailItem - a model defined in Swagger"""  # noqa: E501
        self._pair_name = None
        self._volume = None
        self._low = None
        self._high = None
        self._change = None
        self.discriminator = None
        if pair_name is not None:
            self.pair_name = pair_name
        if volume is not None:
            self.volume = volume
        if low is not None:
            self.low = low
        if high is not None:
            self.high = high
        if change is not None:
            self.change = change

    @property
    def pair_name(self):
        """Gets the pair_name of this PairDetailItem.  # noqa: E501


        :return: The pair_name of this PairDetailItem.  # noqa: E501
        :rtype: str
        """
        return self._pair_name

    @pair_name.setter
    def pair_name(self, pair_name):
        """Sets the pair_name of this PairDetailItem.


        :param pair_name: The pair_name of this PairDetailItem.  # noqa: E501
        :type: str
        """

        self._pair_name = pair_name

    @property
    def volume(self):
        """Gets the volume of this PairDetailItem.  # noqa: E501


        :return: The volume of this PairDetailItem.  # noqa: E501
        :rtype: float
        """
        return self._volume

    @volume.setter
    def volume(self, volume):
        """Sets the volume of this PairDetailItem.


        :param volume: The volume of this PairDetailItem.  # noqa: E501
        :type: float
        """

        self._volume = volume

    @property
    def low(self):
        """Gets the low of this PairDetailItem.  # noqa: E501

        Lowest price, as a string.  # noqa: E501

        :return: The low of this PairDetailItem.  # noqa: E501
        :rtype: str
        """
        return self._low

    @low.setter
    def low(self, low):
        """Sets the low of this PairDetailItem.

        Lowest price, as a string.  # noqa: E501

        :param low: The low of this PairDetailItem.  # noqa: E501
        :type: str
        """

        self._low = low

    @property
    def high(self):
        """Gets the high of this PairDetailItem.  # noqa: E501

        Highest price, as a string.  # noqa: E501

        :return: The high of this PairDetailItem.  # noqa: E501
        :rtype: str
        """
        return self._high

    @high.setter
    def high(self, high):
        """Sets the high of this PairDetailItem.

        Highest price, as a string.  # noqa: E501

        :param high: The high of this PairDetailItem.  # noqa: E501
        :type: str
        """

        self._high = high

    @property
    def change(self):
        """Gets the change of this PairDetailItem.  # noqa: E501

        Price change percentage, as a string.  # noqa: E501

        :return: The change of this PairDetailItem.  # noqa: E501
        :rtype: str
        """
        return self._change

    @change.setter
    def change(self, change):
        """Sets the change of this PairDetailItem.

        Price change percentage, as a string.  # noqa: E501

        :param change: The change of this PairDetailItem.  # noqa: E501
        :type: str
        """

        self._change = change

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PairDetailItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PairDetailItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
