# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TradeLimitOrderData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exch': 'str',
        'pair': 'str',
        'amt': 'float',
        'price': 'float'
    }

    attribute_map = {
        'exch': 'exch',
        'pair': 'pair',
        'amt': 'amt',
        'price': 'price'
    }

    def __init__(self, exch=None, pair=None, amt=None, price=None):  # noqa: E501
        """TradeLimitOrderData - a model defined in Swagger"""  # noqa: E501
        self._exch = None
        self._pair = None
        self._amt = None
        self._price = None
        self.discriminator = None
        self.exch = exch
        self.pair = pair
        self.amt = amt
        self.price = price

    @property
    def exch(self):
        """Gets the exch of this TradeLimitOrderData.  # noqa: E501


        :return: The exch of this TradeLimitOrderData.  # noqa: E501
        :rtype: str
        """
        return self._exch

    @exch.setter
    def exch(self, exch):
        """Sets the exch of this TradeLimitOrderData.


        :param exch: The exch of this TradeLimitOrderData.  # noqa: E501
        :type: str
        """
        if exch is None:
            raise ValueError("Invalid value for `exch`, must not be `None`")  # noqa: E501

        self._exch = exch

    @property
    def pair(self):
        """Gets the pair of this TradeLimitOrderData.  # noqa: E501


        :return: The pair of this TradeLimitOrderData.  # noqa: E501
        :rtype: str
        """
        return self._pair

    @pair.setter
    def pair(self, pair):
        """Sets the pair of this TradeLimitOrderData.


        :param pair: The pair of this TradeLimitOrderData.  # noqa: E501
        :type: str
        """
        if pair is None:
            raise ValueError("Invalid value for `pair`, must not be `None`")  # noqa: E501

        self._pair = pair

    @property
    def amt(self):
        """Gets the amt of this TradeLimitOrderData.  # noqa: E501


        :return: The amt of this TradeLimitOrderData.  # noqa: E501
        :rtype: float
        """
        return self._amt

    @amt.setter
    def amt(self, amt):
        """Sets the amt of this TradeLimitOrderData.


        :param amt: The amt of this TradeLimitOrderData.  # noqa: E501
        :type: float
        """
        if amt is None:
            raise ValueError("Invalid value for `amt`, must not be `None`")  # noqa: E501

        self._amt = amt

    @property
    def price(self):
        """Gets the price of this TradeLimitOrderData.  # noqa: E501


        :return: The price of this TradeLimitOrderData.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this TradeLimitOrderData.


        :param price: The price of this TradeLimitOrderData.  # noqa: E501
        :type: float
        """
        if price is None:
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TradeLimitOrderData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TradeLimitOrderData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
