# coding: utf-8

"""
    Gunbot SDK Python

    The Gunbot SDK for Python enables you to programmatically interact with Gunbot, a self-hosted trading bot for crypto, ETFs and stocks.  It's a single API client with which you can control automated trading operations on many exchanges. Gunbot includes unique built-in strategies, it can also run custom strategy code in js. This client lets you orchestrate and monitor trading bots.  The API client accepts and returns data in JSON format.  It uses standard HTTP response codes to indicate request outcomes:  - **200 OK** – The request was successful   - **400 Bad Request** – The request was invalid or cannot be processed   - **401 Unauthorized** – Authentication failed or the user lacks permissions   - **500 Internal Server Error** – A server-side error occurred    **Gunbot Workflow**  1. Add the trading pair to the configuration with a valid strategy.   2. Start the core to activate trading operations.    After completing these steps you can access market-data and trading endpoints. Gunbot will actively monitor and execute strategies for the specified pairs.  **Encryption Helpers**  Gunbot uses password encryption. Refer to the original documentation for helper snippets in JavaScript (Browser/Node.js), Bash and Python.  **Supported Exchanges**  Gunbot ships with native connectors for more than two dozen exchanges, covering spot, futures and on-chain derivatives.   | Exchange | Spot | Futures / Perps | DeFi (on-chain) | Extra notes | | --- | :---: | :---: | :---: | --- | | **Binance** | ✔️ | ✔️ (USD-M & COIN-M) |  | Largest liquidity | | **Binance US** | ✔️ |  |  | US-regulated arm | | **Bitget** | ✔️ | ✔️ (USDT & UM perps) |  |  | | **Bybit** | ✔️ | ✔️ (USDT & inverse perps) |  |  | | **OKX** | ✔️ | ✔️ (Perps & dated futures) |  |  | | **Kraken** | ✔️ | ✔️ (via Kraken Futures) |  |  | | **KuCoin** | ✔️ |  |  |  | | **Gate.io** | ✔️ |  |  |  | | **MEXC** | ✔️ |  |  |  | | **BingX** | ✔️ |  |  |  | | **Crypto.com** | ✔️ |  |  |  | | **Huobi Global** | ✔️ |  |  |  | | **Bitfinex** | ✔️ |  |  |  | | **HitBTC** | ✔️ |  |  |  | | **Coinbase Advanced Trade** | ✔️ |  |  | Former Coinbase Pro | | **CEX.io** | ✔️ |  |  |  | | **Poloniex** | ✔️ |  |  |  | | **Alpaca** (stocks & crypto) | ✔️ |  |  |  | | **dYdX (v3/v4)** |  | ✔️ | ✔️ | Perpetual DEX | | **HyperLiquid** | ✔️ | ✔️ | ✔️ | DeFi perps | | **PancakeSwap** |  | ✔️ | ✔️ | BSC DEX | | **Bitmex / Bitmex Testnet** |  | ✔️ |  |  |  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@gunbot.freshdesk.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest

import gunbot_sdk
from gunbot_sdk.api.gunbot_api import GunbotApi  # noqa: E501
from gunbot_sdk.rest import ApiException


class TestGunbotApi(unittest.TestCase):
    """GunbotApi unit test stubs"""

    def setUp(self):
        self.api = GunbotApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_assets_total(self):
        """Test case for assets_total

        assetsTotal — Get Historical Total Asset Value  # noqa: E501
        """
        pass

    def test_auth_login(self):
        """Test case for auth_login

        authLogin — Login User  # noqa: E501
        """
        pass

    def test_auth_status(self):
        """Test case for auth_status

        authStatus — Get Authentication Status  # noqa: E501
        """
        pass

    def test_balances(self):
        """Test case for balances

        balances — Get Asset Balances  # noqa: E501
        """
        pass

    def test_chart_data(self):
        """Test case for chart_data

        chartData — Get Chart Data (Candles and Indicators)  # noqa: E501
        """
        pass

    def test_chart_marks(self):
        """Test case for chart_marks

        chartMarks — Get Chart Timescale Marks  # noqa: E501
        """
        pass

    def test_config_full(self):
        """Test case for config_full

        configFull — Get Full Configuration  # noqa: E501
        """
        pass

    def test_config_pair_add(self):
        """Test case for config_pair_add

        configPairAdd — Add Trading Pair to Configuration  # noqa: E501
        """
        pass

    def test_config_pair_remove(self):
        """Test case for config_pair_remove

        configPairRemove — Remove Trading Pair from Configuration  # noqa: E501
        """
        pass

    def test_config_strategy_add(self):
        """Test case for config_strategy_add

        configStrategyAdd — Add Trading Strategy to Configuration  # noqa: E501
        """
        pass

    def test_config_strategy_remove(self):
        """Test case for config_strategy_remove

        configStrategyRemove — Remove Trading Strategy from Configuration  # noqa: E501
        """
        pass

    def test_config_update(self):
        """Test case for config_update

        configUpdate — Update Full Configuration  # noqa: E501
        """
        pass

    def test_coremem(self):
        """Test case for coremem

        coremem — Get Core Memory Snapshot (All Pairs)  # noqa: E501
        """
        pass

    def test_coremem_request(self):
        """Test case for coremem_request

        corememRequest — Get Raw Core Memory Data for a Pair  # noqa: E501
        """
        pass

    def test_coremem_single(self):
        """Test case for coremem_single

        corememSingle — Get Core Memory Snapshot (Single Pair)  # noqa: E501
        """
        pass

    def test_files_acvar(self):
        """Test case for files_acvar

        filesAcvar — List AutoConfig Variable Files  # noqa: E501
        """
        pass

    def test_files_acvar_get(self):
        """Test case for files_acvar_get

        filesAcvarGet — Get AutoConfig Variable File Content  # noqa: E501
        """
        pass

    def test_files_autoconfig_write(self):
        """Test case for files_autoconfig_write

        filesAutoconfigWrite — Write to autoconfig.json File  # noqa: E501
        """
        pass

    def test_files_backup(self):
        """Test case for files_backup

        filesBackup — List Backup Files  # noqa: E501
        """
        pass

    def test_files_backup_get(self):
        """Test case for files_backup_get

        filesBackupGet — Get Backup File Content  # noqa: E501
        """
        pass

    def test_files_custom_editor_get(self):
        """Test case for files_custom_editor_get

        filesCustomEditorGet — Get Custom Strategy Editor File Content  # noqa: E501
        """
        pass

    def test_files_custom_editor_write(self):
        """Test case for files_custom_editor_write

        filesCustomEditorWrite — Write to Custom Strategy Editor File  # noqa: E501
        """
        pass

    def test_files_state(self):
        """Test case for files_state

        filesState — List State Files  # noqa: E501
        """
        pass

    def test_files_state_get(self):
        """Test case for files_state_get

        filesStateGet — Get State File Content  # noqa: E501
        """
        pass

    def test_files_strategy(self):
        """Test case for files_strategy

        filesStrategy — List Custom Strategy Files  # noqa: E501
        """
        pass

    def test_files_strategy_delete(self):
        """Test case for files_strategy_delete

        filesStrategyDelete — Delete Custom Strategy File  # noqa: E501
        """
        pass

    def test_files_strategy_get(self):
        """Test case for files_strategy_get

        filesStrategyGet — Get Custom Strategy File Content  # noqa: E501
        """
        pass

    def test_files_strategy_write(self):
        """Test case for files_strategy_write

        filesStrategyWrite — Write to Custom Strategy File  # noqa: E501
        """
        pass

    def test_license_keys_edit(self):
        """Test case for license_keys_edit

        licenseKeysEdit — Edit License Keys  # noqa: E501
        """
        pass

    def test_market_candles(self):
        """Test case for market_candles

        marketCandles — Get Market Candles (OHLCV)  # noqa: E501
        """
        pass

    def test_market_orderbook(self):
        """Test case for market_orderbook

        marketOrderbook — Get Market Orderbook  # noqa: E501
        """
        pass

    def test_orders(self):
        """Test case for orders

        orders — Get Order History for a Pair  # noqa: E501
        """
        pass

    def test_orders_day(self):
        """Test case for orders_day

        ordersDay — Get Orders for Current Day (Multiple Pairs)  # noqa: E501
        """
        pass

    def test_orders_page(self):
        """Test case for orders_page

        ordersPage — Get Paginated Orders for a Pair  # noqa: E501
        """
        pass

    def test_orders_page_multi(self):
        """Test case for orders_page_multi

        ordersPageMulti — Get Paginated Orders (Multiple Pairs)  # noqa: E501
        """
        pass

    def test_pairs(self):
        """Test case for pairs

        pairs — Get Trading Pairs  # noqa: E501
        """
        pass

    def test_pairs_detailed(self):
        """Test case for pairs_detailed

        pairsDetailed — Get Detailed Trading Pairs  # noqa: E501
        """
        pass

    def test_pnl_daily(self):
        """Test case for pnl_daily

        pnlDaily — Get Daily PNL for a Trading Key  # noqa: E501
        """
        pass

    def test_pnl_daily_paginated(self):
        """Test case for pnl_daily_paginated

        pnlDailyPaginated — Get Paginated Daily PNL for a Trading Key  # noqa: E501
        """
        pass

    def test_pnl_overview(self):
        """Test case for pnl_overview

        pnlOverview — Get PNL Overview  # noqa: E501
        """
        pass

    def test_pnl_sum(self):
        """Test case for pnl_sum

        pnlSum — Get PNL Sum for an Exchange Key  # noqa: E501
        """
        pass

    def test_pnl_total(self):
        """Test case for pnl_total

        pnlTotal — Get Total PNL for a Trading Key  # noqa: E501
        """
        pass

    def test_system_start(self):
        """Test case for system_start

        systemStart — Start System  # noqa: E501
        """
        pass

    def test_system_stop(self):
        """Test case for system_stop

        systemStop — Stop System  # noqa: E501
        """
        pass

    def test_time(self):
        """Test case for time

        time — Get Server Time  # noqa: E501
        """
        pass

    def test_trade_buy(self):
        """Test case for trade_buy

        tradeBuy — Place Limit Buy Order  # noqa: E501
        """
        pass

    def test_trade_buy_market(self):
        """Test case for trade_buy_market

        tradeBuyMarket — Place Market Buy Order  # noqa: E501
        """
        pass

    def test_trade_buy_oco(self):
        """Test case for trade_buy_oco

        tradeBuyOco — Place OCO Buy Order (Binance)  # noqa: E501
        """
        pass

    def test_trade_buy_stoplimit(self):
        """Test case for trade_buy_stoplimit

        tradeBuyStoplimit — Place Stop-Limit Buy Order (Binance)  # noqa: E501
        """
        pass

    def test_trade_buy_trailingstop(self):
        """Test case for trade_buy_trailingstop

        tradeBuyTrailingstop — Place Trailing Stop Buy Order (Binance)  # noqa: E501
        """
        pass

    def test_trade_cancel(self):
        """Test case for trade_cancel

        tradeCancel — Cancel Order  # noqa: E501
        """
        pass

    def test_trade_close(self):
        """Test case for trade_close

        tradeClose — Close Position with Limit Price (Bybit Futures)  # noqa: E501
        """
        pass

    def test_trade_close_market(self):
        """Test case for trade_close_market

        tradeCloseMarket — Close Position at Market Price (Bybit Futures)  # noqa: E501
        """
        pass

    def test_trade_sell(self):
        """Test case for trade_sell

        tradeSell — Place Limit Sell Order  # noqa: E501
        """
        pass

    def test_trade_sell_market(self):
        """Test case for trade_sell_market

        tradeSellMarket — Place Market Sell Order  # noqa: E501
        """
        pass

    def test_trade_sell_oco(self):
        """Test case for trade_sell_oco

        tradeSellOco — Place OCO Sell Order (Binance)  # noqa: E501
        """
        pass

    def test_trade_sell_stoplimit(self):
        """Test case for trade_sell_stoplimit

        tradeSellStoplimit — Place Stop-Limit Sell Order (Binance)  # noqa: E501
        """
        pass

    def test_trade_sell_trailingstop(self):
        """Test case for trade_sell_trailingstop

        tradeSellTrailingstop — Place Trailing Stop Sell Order (Binance)  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
