"""Tests for pyhap.hsrp."""

# pylint: disable=line-too-long, pointless-string-statement

import hashlib

from pyhap.hsrp import Server
from pyhap.params import get_srp_context
from pyhap.util import long_to_bytes

DUMMY_A = b"Ve\xce\xd4\x90LExKD\x9d7\x16\\@\xb6\xb8\x9f\x01\x1a]\x86\xa4\x1c"
" \x13\xaa\xc0\x17=\x1f\xafPx\xea/\x01Q\xc8hw\x06\x03\xc8O\x89|\x8d4\xa8\x85"
"\xd2\xfb:\x0e\xb6PT2V\xb2\xa9\xca\x0bL\x97\r\xee\x88\xbc\xef\x8d\xa6|\xeb \xdc"
"\x80.\x92\xe0\xe5s\xf5\xf2;\x89LN\\^\x8c\xd1\x00\x99U]]/^\xe9\x1b\xe2\xf3\x1a|"
"\xc6\x85Q\x95T`b\x8e\x04\xc2\x99\xdd\xdfp\x98\x85\x13\xe5\xaf\xdf\xe0Tm\xa3t\xfe"
"\xc1_V\x04\xab\xb1\x96\xa8\x9cw\xa40\x95\x8d\x9f|\xf7.\x90\xd2{L\xcc*\xcb\xdde"
"\x81\x14\x14\xc97\xe7\xa0177\x1b\xe0\xb0\x19\x0f\xf1\x1e;\xc4\xc9\x07\x05zN\xb3"
"!y\xf2\x9e\xa4N\xbeswxx\x13\x82\x18\xccU\xb4\xec\x7f{\x8eo\x86\x0b\xa6\xff\x9b"
"\xbcY(0\x16\xba$\x9d\xb9\x8d}\xe5f\x0c)\\\x8b\\\xef\xfd\x0coEg\x13\x13\xa2q\xb9"
"\xe5\x8a\xfd\x97\x97\xcb\xb1\x15\xd5\xc2\xd7\x07\x91A\xdf\xd7"


def test_srp_basic():

    ctx = get_srp_context(3072, hashlib.sha512, 16)
    b = 191304991611724068381190663629083136274
    s = long_to_bytes(227710976386754876301088769828140156049)
    verifier = Server(ctx, b"Pair-Setup", b"123-45-543", s=s, b=b)
    verifier.set_A(DUMMY_A)

    assert (
        verifier.k
        == 8891118944006259431156568541843809053371474718154946070525699599564743247786811275097952247025117806925219847643897478119979876683245412022290811230509536
    )
    assert (
        verifier.get_session_key()
        == 7776966363435436003301596680621751479448170893927097125414524508260409807602643597201957531811064094375727460485526402929080964822225092649470633176208468
    )
    assert (
        verifier.M
        == b"\xafnZ\xef\x8e\x84\xbe\xaa\xe2M}5'\x0c\xb8\xb9\x07\x13\xa3t\xbbfOL\x059\xa3T\xaf\x021\x05\xf7*\xdb]\xa3]\x92\xbc\xa7\x0ed\xc1C\x88W\x0b\xe7n\xe6|\x1e\xb4\xf9pUc\xa2\x8d\x05\xd7\xabI"
    )
    assert (
        verifier.S
        == 74327940101639752536537640881643581886247890122995727869092918508085397047960192114187184206420245499227933354038262980545757154896143196917567791395562849790585173129051928488506985432588320936161016609993624725221069849383124728580710793131421162926844621384309691065416908669855286020750380619018007734494245389837285359061649585082978114606737696983003789452193299203880220013003551748645087934186574940836315605161763958706985646740794424371115818479937015467439653789667600114913036877616558029128521276071759153575011083182650027094873442901697309464533625147028860476977419766721379872518101123122550406587162809198793634217353529574423908555799363233330194347012490634061830786590780000201696990820985363093141614397601285773980430681705777477946555312165250133963931282621724675380164859592461132141730419315498467050491890312826221069184134326282895963295397215898192608240385050625017941322853973472354023693355
    )
    assert verifier.get_challenge() == (
        s,
        2149981971605054722971448928513305504744266471818820776094113337432031877014471028912971746321748621185649001880451734094103311676264091997241948096711710461140721738956497494552388614895831596671069609694220554015991913746528757304239759620571367574036184864989138266792823575841594621160010011666017298902208272126405229578664943728094068949021795802799552486045670159066273942547651088762352104942364707580142387716636468281068738042936130578774565386637668610429058884417819388838110075674266297699354845325023954873162742733169560666501210723876454859556564325607870517213063038111644227553599978606540729093082921723443122696487068510228710655880466038292327450357013882323502992655150615829432843408599038481983277372215619348128412279375677793332715557041679298014663382481619951610899087031959653365603032111634191603851554865349816117884573658915813848292512124719015181912892538210471183790840676306564839828444134,
    )
    assert verifier.b == b
    assert (
        verifier.v
        == 1800954445588585461785592179273284825501707649217210015435034845050179016324355419526711292364866248346582448660643272322280999760562622718989053886869428917425675795172391329924178337579968214001782222575897907780437717763112406095878356902641567396545009429496128133564692965499069074320017151157469160990771527712530637370897276672652870613312504255873634362188551282649472569433062597795005057270622772410668342950279555516133010272639201733492626622809480021268951287298118968011031850511105359580984350020671780470982743318615303989055956125558514263378948829479434245711743458681522240763520911255733079164391662778946744155477806679057949726211652108387739564473209550264487697151825509058193841809273482575660658239177704074882302955007248950743262054925817705066654613816236610736311934089570249355454459951577900707115340781119430461780455828980205046091360390327787803271426555681638302650021637121212829077894589
    )
    assert (
        verifier.N
        == 5809605995369958062791915965639201402176612226902900533702900882779736177890990861472094774477339581147373410185646378328043729800750470098210924487866935059164371588168047540943981644516632755067501626434556398193186628990071248660819361205119793693985433297036118232914410171876807536457391277857011849897410207519105333355801121109356897459426271845471397952675959440793493071628394122780510124618488232602464649876850458861245784240929258426287699705312584509625419513463605155428017165714465363094021609290561084025893662561222573202082865797821865270991145082200656978177192827024538990239969175546190770645685893438011714430426409338676314743571154537142031573004276428701433036381801705308659830751190352946025482059931306571004727362479688415574702596946457770284148435989129632853918392117997472632693078113129886487399347796982772784615865232621289656944284216824611318709764535152507354116344703769998514148343807
    )
    assert verifier.g == 5

    assert (
        verifier.verify(verifier.M)
        == b"\xe1\x00\xcf\xe2\x98\xaf\x1e\x02tb\x0b\xfclKF\xee\x1b\x80\xf6\x90\xb7\x8a\x9f\x133y#>\x8d/\xc1\x88\x93\x8eh\tN\x9b\xda\xc2-\x1a(\xe3\xca\x0bf\xf3\xc4\xca\xc4\xec\xfa/\xec\xb7\x16\x81\xdd%\xc9i\xf9\x90"
    )
    assert verifier.verify(b"wrong") is None
