"""
Name: Google ADs & keywords generator
Developer: Gasyd GAGNON
Date: June 23, 2023
Description: Generate a csv file with keywords,headlines, descriptions of the headlines and lenght of hedalines and descriptions related to the prompt given
"""


import openai
import pandas as pd



"""" use this to test

#Your context and prompt must be as precise as possible. Give every details possible.
# To get "wow" result you can tell GPT to consider itself as a 20 or 30 years experienced person in the field you want. 

import googleAds_keywords

context = 'YOUR CONTEXT HERE' 
prompt = 'YOUR PROMPT HERE' 
api_key = "your_API_key"  
temperature = 0.7 #standard used by OPENAI (you can change it)

keywords, headlines, descriptions, headline_counts, description_counts = mymodule.run_model(prompt, context, api_key, temperature)

"""

"""
1. temperature: In the context of a language model, the temperature is a parameter that controls the randomness of the model's output. 
It determines the sharpness of the probability distribution used when sampling the next word to generate in a sentence.
If the temperature is low (e.g., close to 0), the model is more deterministic and more likely to select the most probable word at each step.
If the temperature is high (e.g., closer to 1), the model becomes more random and likely to select less probable words(becomes more creative). 
This parameter can help balance between repetitive but accurate output (low temperature) and diverse but potentially inaccurate output (high temperature).

2. frequency_penalty: This parameter, which is sometimes used in models like GPT-3 and similar architectures, is used to penalize the selection of tokens that have been used more frequently. 
It's a way of controlling the repetitiveness of the output. 
A higher frequency penalty encourages more unique responses, while a lower frequency penalty may result in more repetitive responses.

3. presence_penalty: The presence penalty, another configuration parameter in some language models, penalizes the selection of new tokens (words) that have not appeared in the output so far.
 A higher presence penalty would encourage the model to reuse words that have already appeared in the output, 
 while a lower presence penalty would encourage more varied language usage and the introduction of new words.

Please note that these parameters are very specific to certain language models and might not be used in other types of machine learning models.
"""


def count_characters(headlines, descriptions):
    """Counts number of characters in the headlines and descriptions generated by CHATGPT API (space is taken into account)
    Args:
       headlines (string): headlines generated by openAI CHATGPT API
       descriptions (string): descriptions generated by openAI CHATGPT API
    Returns:
        headlines and descriptions number of characters
    
    """
    headline_char_counts = [len(headline) for headline in headlines]
    description_char_counts = [len(description) for description in descriptions]
    return headline_char_counts, description_char_counts

def run_model(prompt, context, api_key, temperature):
    """ The `run_model` function generates ad headlines and descriptions using OpenAI's "text-davinci-003" model for a given prompt and context. 
    It processes the model's output into keywords, then generates a headline and a French description for each keyword. 
    It also counts the characters in each headline and description, and it prints these alongside the original keywords. 
    The function compiles all the generated data into a pandas DataFrame, which it then writes to a CSV file.
    

     Args:
       prompt (string): your prompt
       context (string): contetxt of your prompt
       api_key: your API key
       temperature (float) : temperature
    Returns:
        Generated keywords, headlines, descriptions, and their character counts in a csv file.

    """
    
    openai.api_key = api_key

    prompt_with_context = f'{context}\n{prompt}'
    response = openai.Completion.create(
        engine="text-davinci-003",
        prompt=prompt_with_context,
        temperature=temperature,
        max_tokens=150, 
        top_p=1,
        frequency_penalty=0,
        presence_penalty=0
    )

    # Extract the keywords from the text
    keywords = response['choices'][0]['text'].split('\n')
    # Remove empty keywords
    keywords = [keyword for keyword in keywords if keyword.strip() != '']
    # Generate a headline for each keyword
    headlines = []
    descriptions = []
    for i, keyword in enumerate(keywords):
        headline_prompt = f'Generate a unique expert ad headline for the keyword "{keyword}"(alternate french and english). The goal is to attract many clients.Limit to 20 characters.'
        headline_response = openai.Completion.create(
            engine="text-davinci-003",
            prompt=headline_prompt,
            temperature=0.7,
            max_tokens=20,
            top_p=1,
            frequency_penalty=0,
            presence_penalty=0
        )
        headline = headline_response['choices'][0]['text'].strip()
        headlines.append(headline)

        # Generate a description in French for each headline, alternate the language
        description_prompt = f"Generate a unique description in French for the title '{headline}'. Limit of 40 characters."
        description_response = openai.Completion.create(
            engine="text-davinci-003",
            prompt=description_prompt,
            temperature=0.7,
            max_tokens=30,
            top_p=1,
            frequency_penalty=0,
            presence_penalty=0
        )
        description = description_response['choices'][0]['text'].strip()
        descriptions.append(description)

    # Calculate character counts for each headline and description
    headline_counts, description_counts = count_characters(headlines, descriptions)

    # Print the keywords, their headlines, descriptions and character counts
    for keyword, headline, description, headline_count, description_count in zip(keywords, headlines, descriptions, headline_counts, description_counts):
        print(f"Keyword: {keyword}\nHeadline: {headline} (Length: {headline_count} characters)\nDescription: {description} (Length: {description_count} characters)\n")

    # Convert the results to a DataFrame
    data = {
        "Keywords": keywords,
        "Headline": headlines,
        "Headline Length": headline_counts,
        "Description": descriptions,
        "Description Length": description_counts
    }

    df = pd.DataFrame(data)

    # Write the DataFrame to a CSV file
    df.to_csv("mdpparis.csv", index=False)

    return keywords, headlines, descriptions, headline_counts, description_counts
