from hazelcast.serialization.bits import *
from hazelcast.protocol.builtin import FixSizedTypesCodec
from hazelcast.protocol.client_message import OutboundMessage, REQUEST_HEADER_SIZE, create_initial_buffer, RESPONSE_HEADER_SIZE, EVENT_HEADER_SIZE
from hazelcast.protocol.builtin import StringCodec
from hazelcast.protocol.builtin import DataCodec
from hazelcast.protocol.builtin import CodecUtil

# hex: 0x011600
_REQUEST_MESSAGE_TYPE = 71168
# hex: 0x011601
_RESPONSE_MESSAGE_TYPE = 71169
# hex: 0x011602
_EVENT_ENTRY_MESSAGE_TYPE = 71170

_REQUEST_INCLUDE_VALUE_OFFSET = REQUEST_HEADER_SIZE
_REQUEST_LISTENER_FLAGS_OFFSET = _REQUEST_INCLUDE_VALUE_OFFSET + BOOLEAN_SIZE_IN_BYTES
_REQUEST_LOCAL_ONLY_OFFSET = _REQUEST_LISTENER_FLAGS_OFFSET + INT_SIZE_IN_BYTES
_REQUEST_INITIAL_FRAME_SIZE = _REQUEST_LOCAL_ONLY_OFFSET + BOOLEAN_SIZE_IN_BYTES
_RESPONSE_RESPONSE_OFFSET = RESPONSE_HEADER_SIZE
_EVENT_ENTRY_EVENT_TYPE_OFFSET = EVENT_HEADER_SIZE
_EVENT_ENTRY_UUID_OFFSET = _EVENT_ENTRY_EVENT_TYPE_OFFSET + INT_SIZE_IN_BYTES
_EVENT_ENTRY_NUMBER_OF_AFFECTED_ENTRIES_OFFSET = _EVENT_ENTRY_UUID_OFFSET + UUID_SIZE_IN_BYTES


def encode_request(name, key, predicate, include_value, listener_flags, local_only):
    buf = create_initial_buffer(_REQUEST_INITIAL_FRAME_SIZE, _REQUEST_MESSAGE_TYPE)
    FixSizedTypesCodec.encode_boolean(buf, _REQUEST_INCLUDE_VALUE_OFFSET, include_value)
    FixSizedTypesCodec.encode_int(buf, _REQUEST_LISTENER_FLAGS_OFFSET, listener_flags)
    FixSizedTypesCodec.encode_boolean(buf, _REQUEST_LOCAL_ONLY_OFFSET, local_only)
    StringCodec.encode(buf, name)
    DataCodec.encode(buf, key)
    DataCodec.encode(buf, predicate, True)
    return OutboundMessage(buf, False, True)


def decode_response(msg):
    initial_frame = msg.next_frame()
    return FixSizedTypesCodec.decode_uuid(initial_frame.buf, _RESPONSE_RESPONSE_OFFSET)


def handle(msg, handle_entry_event=None):
    message_type = msg.get_message_type()
    if message_type == _EVENT_ENTRY_MESSAGE_TYPE and handle_entry_event is not None:
        initial_frame = msg.next_frame()
        event_type = FixSizedTypesCodec.decode_int(initial_frame.buf, _EVENT_ENTRY_EVENT_TYPE_OFFSET)
        uuid = FixSizedTypesCodec.decode_uuid(initial_frame.buf, _EVENT_ENTRY_UUID_OFFSET)
        number_of_affected_entries = FixSizedTypesCodec.decode_int(initial_frame.buf, _EVENT_ENTRY_NUMBER_OF_AFFECTED_ENTRIES_OFFSET)
        key = CodecUtil.decode_nullable(msg, DataCodec.decode)
        value = CodecUtil.decode_nullable(msg, DataCodec.decode)
        old_value = CodecUtil.decode_nullable(msg, DataCodec.decode)
        merging_value = CodecUtil.decode_nullable(msg, DataCodec.decode)
        handle_entry_event(key, value, old_value, merging_value, event_type, uuid, number_of_affected_entries)
        return
