# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from helloasso_python.models.hello_asso_api_v5_models_directory_list_forms_request import HelloAssoApiV5ModelsDirectoryListFormsRequest
from helloasso_python.models.hello_asso_api_v5_models_directory_list_organizations_request import HelloAssoApiV5ModelsDirectoryListOrganizationsRequest
from helloasso_python.models.results_with_pagination_model_synchronizable_form_model import ResultsWithPaginationModelSynchronizableFormModel
from helloasso_python.models.results_with_pagination_model_synchronizable_organization_model import ResultsWithPaginationModelSynchronizableOrganizationModel

from helloasso_python.api_client import ApiClient, RequestSerialized
from helloasso_python.api_response import ApiResponse
from helloasso_python.rest import RESTResponseType


class AnnuaireApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def directory_forms_post(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_forms_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListFormsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResultsWithPaginationModelSynchronizableFormModel:
        """Récupérer les formulaires

        Permet de récupérer une liste de tous les formulaires visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seuls les formulaires avec une date de mise à jour de la visibilité API supérieure à la dernière forme envoyée sont retournés (toujours en utilisant le continuationToken). Cela concerne les nouveaux formulaires à insérer (souhaitant apparaître de l'annuaire) ainsi que les anciens à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> FormOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_forms_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_forms_request: HelloAssoApiV5ModelsDirectoryListFormsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_forms_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_forms_request=hello_asso_api_v5_models_directory_list_forms_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableFormModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def directory_forms_post_with_http_info(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_forms_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListFormsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResultsWithPaginationModelSynchronizableFormModel]:
        """Récupérer les formulaires

        Permet de récupérer une liste de tous les formulaires visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seuls les formulaires avec une date de mise à jour de la visibilité API supérieure à la dernière forme envoyée sont retournés (toujours en utilisant le continuationToken). Cela concerne les nouveaux formulaires à insérer (souhaitant apparaître de l'annuaire) ainsi que les anciens à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> FormOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_forms_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_forms_request: HelloAssoApiV5ModelsDirectoryListFormsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_forms_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_forms_request=hello_asso_api_v5_models_directory_list_forms_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableFormModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def directory_forms_post_without_preload_content(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_forms_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListFormsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Récupérer les formulaires

        Permet de récupérer une liste de tous les formulaires visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seuls les formulaires avec une date de mise à jour de la visibilité API supérieure à la dernière forme envoyée sont retournés (toujours en utilisant le continuationToken). Cela concerne les nouveaux formulaires à insérer (souhaitant apparaître de l'annuaire) ainsi que les anciens à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> FormOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_forms_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_forms_request: HelloAssoApiV5ModelsDirectoryListFormsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_forms_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_forms_request=hello_asso_api_v5_models_directory_list_forms_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableFormModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _directory_forms_post_serialize(
        self,
        page_size,
        continuation_token,
        hello_asso_api_v5_models_directory_list_forms_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if hello_asso_api_v5_models_directory_list_forms_request is not None:
            _body_params = hello_asso_api_v5_models_directory_list_forms_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json', 
                        'application/json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/directory/forms',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def directory_organizations_post(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_organizations_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListOrganizationsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ResultsWithPaginationModelSynchronizableOrganizationModel:
        """Récupérer les organisations

        Permet de récupérer une liste de toutes les organisations visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seules les organisations avec une date de mise à jour de la visibilité API supérieure à la dernière organisation envoyée sont retournées (toujours en utilisant le continuationToken). Cela concerne les nouvelles organisations à insérer (souhaitant apparaître dans l'annuaire) ainsi que les anciennes à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> OrganizationOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_organizations_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_organizations_request: HelloAssoApiV5ModelsDirectoryListOrganizationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_organizations_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_organizations_request=hello_asso_api_v5_models_directory_list_organizations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableOrganizationModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def directory_organizations_post_with_http_info(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_organizations_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListOrganizationsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ResultsWithPaginationModelSynchronizableOrganizationModel]:
        """Récupérer les organisations

        Permet de récupérer une liste de toutes les organisations visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seules les organisations avec une date de mise à jour de la visibilité API supérieure à la dernière organisation envoyée sont retournées (toujours en utilisant le continuationToken). Cela concerne les nouvelles organisations à insérer (souhaitant apparaître dans l'annuaire) ainsi que les anciennes à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> OrganizationOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_organizations_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_organizations_request: HelloAssoApiV5ModelsDirectoryListOrganizationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_organizations_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_organizations_request=hello_asso_api_v5_models_directory_list_organizations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableOrganizationModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def directory_organizations_post_without_preload_content(
        self,
        page_size: Annotated[Optional[StrictInt], Field(description="The number of items per page")] = None,
        continuation_token: Annotated[Optional[StrictStr], Field(description="Continuation Token from which we wish to retrieve results")] = None,
        hello_asso_api_v5_models_directory_list_organizations_request: Annotated[Optional[HelloAssoApiV5ModelsDirectoryListOrganizationsRequest], Field(description="Body which contains the filters to apply")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Récupérer les organisations

        Permet de récupérer une liste de toutes les organisations visibles correspondant à tous les filtres de l'annuaire jusqu'à ce qu'il soit synchronisé (en utilisant le continuationToken). Si aucun filtre n'est spécifié, aucun filtre n'est appliqué. Les résultats sont classés par date de mise à jour de la visibilité API en ordre croissant. Une fois la liste synchronisée, seules les organisations avec une date de mise à jour de la visibilité API supérieure à la dernière organisation envoyée sont retournées (toujours en utilisant le continuationToken). Cela concerne les nouvelles organisations à insérer (souhaitant apparaître dans l'annuaire) ainsi que les anciennes à supprimer (ne souhaitant plus apparaître dans l'annuaire). Le nombre total de résultats (ou de pages) n'est pas récupérable, donc les informations de pagination retournées indiqueront toujours -1.<br/><br/><b>Votre clientId doit être autorisé à tous ces privilèges : </b> <br/> OrganizationOpenDirectory<br/><br/>

        :param page_size: The number of items per page
        :type page_size: int
        :param continuation_token: Continuation Token from which we wish to retrieve results
        :type continuation_token: str
        :param hello_asso_api_v5_models_directory_list_organizations_request: Body which contains the filters to apply
        :type hello_asso_api_v5_models_directory_list_organizations_request: HelloAssoApiV5ModelsDirectoryListOrganizationsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._directory_organizations_post_serialize(
            page_size=page_size,
            continuation_token=continuation_token,
            hello_asso_api_v5_models_directory_list_organizations_request=hello_asso_api_v5_models_directory_list_organizations_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ResultsWithPaginationModelSynchronizableOrganizationModel",
            '401': None,
            '403': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _directory_organizations_post_serialize(
        self,
        page_size,
        continuation_token,
        hello_asso_api_v5_models_directory_list_organizations_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page_size is not None:
            
            _query_params.append(('pageSize', page_size))
            
        if continuation_token is not None:
            
            _query_params.append(('continuationToken', continuation_token))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if hello_asso_api_v5_models_directory_list_organizations_request is not None:
            _body_params = hello_asso_api_v5_models_directory_list_organizations_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain', 
                    'application/json', 
                    'text/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json-patch+json', 
                        'application/json', 
                        'text/json', 
                        'application/*+json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/directory/organizations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


