# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_form_type import HelloAssoApiV5ModelsEnumsFormType
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsDirectoryListFormsRequest(BaseModel):
    """
    HelloAssoApiV5ModelsDirectoryListFormsRequest
    """ # noqa: E501
    form_name: Optional[StrictStr] = Field(default=None, description="Textual search for form name", alias="formName")
    form_description: Optional[StrictStr] = Field(default=None, description="Textual search for form description", alias="formDescription")
    form_zip_codes: Optional[List[StrictStr]] = Field(default=None, description="The zip codes where the forms are located", alias="formZipCodes")
    form_cities: Optional[List[StrictStr]] = Field(default=None, description="The cities where the forms are located", alias="formCities")
    form_regions: Optional[List[StrictStr]] = Field(default=None, description="The regions where the forms are located", alias="formRegions")
    form_departments: Optional[List[StrictStr]] = Field(default=None, description="The departments where the forms are located", alias="formDepartments")
    form_countries: Optional[List[StrictStr]] = Field(default=None, description="The countries where the forms are located", alias="formCountries")
    form_types: Optional[List[HelloAssoApiV5ModelsEnumsFormType]] = Field(default=None, description="The form types : CrowdFunding, Membership, Event, Donation, PaymentForm ...", alias="formTypes")
    form_activity_type: Optional[List[StrictStr]] = Field(default=None, description="The Activity Type of the form", alias="formActivityType")
    form_publication_start_date_min: Optional[datetime] = Field(default=None, description="The minimum publication date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formPublicationStartDateMin")
    form_publication_start_date_max: Optional[datetime] = Field(default=None, description="The maximum publication date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formPublicationStartDateMax")
    form_start_date_min: Optional[datetime] = Field(default=None, description="The minimum start date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formStartDateMin")
    form_start_date_max: Optional[datetime] = Field(default=None, description="The maximum start date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formStartDateMax")
    form_end_date_max: Optional[datetime] = Field(default=None, description="The maximum end date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formEndDateMax")
    form_end_date_min: Optional[datetime] = Field(default=None, description="The minimum end date of the forms, format \"yyyy-MM-ddTHH:mm:ss.fffK\"", alias="formEndDateMin")
    form_is_free: Optional[StrictBool] = Field(default=None, description="Allow only free forms if true", alias="formIsFree")
    form_has_remaining_entries: Optional[StrictBool] = Field(default=None, description="Allow only forms with remaning entries if true", alias="formHasRemainingEntries")
    form_internal_tags: Optional[List[StrictStr]] = Field(default=None, description="Allow only forms with internal tags  this filter is for special operations only", alias="formInternalTags")
    form_public_tags: Optional[List[StrictStr]] = Field(default=None, description="Allow only forms with public tags", alias="formPublicTags")
    organization_name: Optional[StrictStr] = Field(default=None, description="Textual search for organization name", alias="organizationName")
    organization_description: Optional[StrictStr] = Field(default=None, description="Textual search for organization description", alias="organizationDescription")
    organization_categories: Optional[List[StrictStr]] = Field(default=None, description="The categories of the forms", alias="organizationCategories")
    organization_types: Optional[List[StrictStr]] = Field(default=None, description="The organization types", alias="organizationTypes")
    organization_zip_codes: Optional[List[StrictStr]] = Field(default=None, description="The zip codes where the organizations are located", alias="organizationZipCodes")
    organization_cities: Optional[List[StrictStr]] = Field(default=None, description="The cities where the organizations are located", alias="organizationCities")
    organization_regions: Optional[List[StrictStr]] = Field(default=None, description="The regions where the organizations are located", alias="organizationRegions")
    organization_departments: Optional[List[StrictStr]] = Field(default=None, description="The departments where the organizations are located", alias="organizationDepartments")
    organization_fiscal_receipt_eligibility: Optional[StrictBool] = Field(default=None, description="Allow only organization with a fiscal receipt eligibility", alias="organizationFiscalReceiptEligibility")
    organization_linked_partners: Optional[List[StrictStr]] = Field(default=None, description="Organization linked partners", alias="organizationLinkedPartners")
    __properties: ClassVar[List[str]] = ["formName", "formDescription", "formZipCodes", "formCities", "formRegions", "formDepartments", "formCountries", "formTypes", "formActivityType", "formPublicationStartDateMin", "formPublicationStartDateMax", "formStartDateMin", "formStartDateMax", "formEndDateMax", "formEndDateMin", "formIsFree", "formHasRemainingEntries", "formInternalTags", "formPublicTags", "organizationName", "organizationDescription", "organizationCategories", "organizationTypes", "organizationZipCodes", "organizationCities", "organizationRegions", "organizationDepartments", "organizationFiscalReceiptEligibility", "organizationLinkedPartners"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsDirectoryListFormsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if form_name (nullable) is None
        # and model_fields_set contains the field
        if self.form_name is None and "form_name" in self.model_fields_set:
            _dict['formName'] = None

        # set to None if form_description (nullable) is None
        # and model_fields_set contains the field
        if self.form_description is None and "form_description" in self.model_fields_set:
            _dict['formDescription'] = None

        # set to None if form_zip_codes (nullable) is None
        # and model_fields_set contains the field
        if self.form_zip_codes is None and "form_zip_codes" in self.model_fields_set:
            _dict['formZipCodes'] = None

        # set to None if form_cities (nullable) is None
        # and model_fields_set contains the field
        if self.form_cities is None and "form_cities" in self.model_fields_set:
            _dict['formCities'] = None

        # set to None if form_regions (nullable) is None
        # and model_fields_set contains the field
        if self.form_regions is None and "form_regions" in self.model_fields_set:
            _dict['formRegions'] = None

        # set to None if form_departments (nullable) is None
        # and model_fields_set contains the field
        if self.form_departments is None and "form_departments" in self.model_fields_set:
            _dict['formDepartments'] = None

        # set to None if form_countries (nullable) is None
        # and model_fields_set contains the field
        if self.form_countries is None and "form_countries" in self.model_fields_set:
            _dict['formCountries'] = None

        # set to None if form_types (nullable) is None
        # and model_fields_set contains the field
        if self.form_types is None and "form_types" in self.model_fields_set:
            _dict['formTypes'] = None

        # set to None if form_activity_type (nullable) is None
        # and model_fields_set contains the field
        if self.form_activity_type is None and "form_activity_type" in self.model_fields_set:
            _dict['formActivityType'] = None

        # set to None if form_publication_start_date_min (nullable) is None
        # and model_fields_set contains the field
        if self.form_publication_start_date_min is None and "form_publication_start_date_min" in self.model_fields_set:
            _dict['formPublicationStartDateMin'] = None

        # set to None if form_publication_start_date_max (nullable) is None
        # and model_fields_set contains the field
        if self.form_publication_start_date_max is None and "form_publication_start_date_max" in self.model_fields_set:
            _dict['formPublicationStartDateMax'] = None

        # set to None if form_start_date_min (nullable) is None
        # and model_fields_set contains the field
        if self.form_start_date_min is None and "form_start_date_min" in self.model_fields_set:
            _dict['formStartDateMin'] = None

        # set to None if form_start_date_max (nullable) is None
        # and model_fields_set contains the field
        if self.form_start_date_max is None and "form_start_date_max" in self.model_fields_set:
            _dict['formStartDateMax'] = None

        # set to None if form_end_date_max (nullable) is None
        # and model_fields_set contains the field
        if self.form_end_date_max is None and "form_end_date_max" in self.model_fields_set:
            _dict['formEndDateMax'] = None

        # set to None if form_end_date_min (nullable) is None
        # and model_fields_set contains the field
        if self.form_end_date_min is None and "form_end_date_min" in self.model_fields_set:
            _dict['formEndDateMin'] = None

        # set to None if form_is_free (nullable) is None
        # and model_fields_set contains the field
        if self.form_is_free is None and "form_is_free" in self.model_fields_set:
            _dict['formIsFree'] = None

        # set to None if form_has_remaining_entries (nullable) is None
        # and model_fields_set contains the field
        if self.form_has_remaining_entries is None and "form_has_remaining_entries" in self.model_fields_set:
            _dict['formHasRemainingEntries'] = None

        # set to None if form_internal_tags (nullable) is None
        # and model_fields_set contains the field
        if self.form_internal_tags is None and "form_internal_tags" in self.model_fields_set:
            _dict['formInternalTags'] = None

        # set to None if form_public_tags (nullable) is None
        # and model_fields_set contains the field
        if self.form_public_tags is None and "form_public_tags" in self.model_fields_set:
            _dict['formPublicTags'] = None

        # set to None if organization_name (nullable) is None
        # and model_fields_set contains the field
        if self.organization_name is None and "organization_name" in self.model_fields_set:
            _dict['organizationName'] = None

        # set to None if organization_description (nullable) is None
        # and model_fields_set contains the field
        if self.organization_description is None and "organization_description" in self.model_fields_set:
            _dict['organizationDescription'] = None

        # set to None if organization_categories (nullable) is None
        # and model_fields_set contains the field
        if self.organization_categories is None and "organization_categories" in self.model_fields_set:
            _dict['organizationCategories'] = None

        # set to None if organization_types (nullable) is None
        # and model_fields_set contains the field
        if self.organization_types is None and "organization_types" in self.model_fields_set:
            _dict['organizationTypes'] = None

        # set to None if organization_zip_codes (nullable) is None
        # and model_fields_set contains the field
        if self.organization_zip_codes is None and "organization_zip_codes" in self.model_fields_set:
            _dict['organizationZipCodes'] = None

        # set to None if organization_cities (nullable) is None
        # and model_fields_set contains the field
        if self.organization_cities is None and "organization_cities" in self.model_fields_set:
            _dict['organizationCities'] = None

        # set to None if organization_regions (nullable) is None
        # and model_fields_set contains the field
        if self.organization_regions is None and "organization_regions" in self.model_fields_set:
            _dict['organizationRegions'] = None

        # set to None if organization_departments (nullable) is None
        # and model_fields_set contains the field
        if self.organization_departments is None and "organization_departments" in self.model_fields_set:
            _dict['organizationDepartments'] = None

        # set to None if organization_fiscal_receipt_eligibility (nullable) is None
        # and model_fields_set contains the field
        if self.organization_fiscal_receipt_eligibility is None and "organization_fiscal_receipt_eligibility" in self.model_fields_set:
            _dict['organizationFiscalReceiptEligibility'] = None

        # set to None if organization_linked_partners (nullable) is None
        # and model_fields_set contains the field
        if self.organization_linked_partners is None and "organization_linked_partners" in self.model_fields_set:
            _dict['organizationLinkedPartners'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsDirectoryListFormsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "formName": obj.get("formName"),
            "formDescription": obj.get("formDescription"),
            "formZipCodes": obj.get("formZipCodes"),
            "formCities": obj.get("formCities"),
            "formRegions": obj.get("formRegions"),
            "formDepartments": obj.get("formDepartments"),
            "formCountries": obj.get("formCountries"),
            "formTypes": obj.get("formTypes"),
            "formActivityType": obj.get("formActivityType"),
            "formPublicationStartDateMin": obj.get("formPublicationStartDateMin"),
            "formPublicationStartDateMax": obj.get("formPublicationStartDateMax"),
            "formStartDateMin": obj.get("formStartDateMin"),
            "formStartDateMax": obj.get("formStartDateMax"),
            "formEndDateMax": obj.get("formEndDateMax"),
            "formEndDateMin": obj.get("formEndDateMin"),
            "formIsFree": obj.get("formIsFree"),
            "formHasRemainingEntries": obj.get("formHasRemainingEntries"),
            "formInternalTags": obj.get("formInternalTags"),
            "formPublicTags": obj.get("formPublicTags"),
            "organizationName": obj.get("organizationName"),
            "organizationDescription": obj.get("organizationDescription"),
            "organizationCategories": obj.get("organizationCategories"),
            "organizationTypes": obj.get("organizationTypes"),
            "organizationZipCodes": obj.get("organizationZipCodes"),
            "organizationCities": obj.get("organizationCities"),
            "organizationRegions": obj.get("organizationRegions"),
            "organizationDepartments": obj.get("organizationDepartments"),
            "organizationFiscalReceiptEligibility": obj.get("organizationFiscalReceiptEligibility"),
            "organizationLinkedPartners": obj.get("organizationLinkedPartners")
        })
        return _obj


