# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_tag_type import HelloAssoApiV5ModelsEnumsTagType
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsTagsInternalTagModel(BaseModel):
    """
    InternalTagModel class
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Tag Id")
    name: Optional[StrictStr] = Field(default=None, description="Name tag")
    form_count: Optional[StrictInt] = Field(default=None, description="Count of times Tag is used by forms", alias="formCount")
    organization_count: Optional[StrictInt] = Field(default=None, description="Count of times Tag is used by Organizations", alias="organizationCount")
    tag_type: Optional[HelloAssoApiV5ModelsEnumsTagType] = Field(default=None, alias="tagType")
    tag_parent: Optional[HelloAssoApiV5ModelsTagsInternalTagModel] = Field(default=None, alias="tagParent")
    amount_collected: Optional[StrictInt] = Field(default=None, description="Amount collected by all forms linked to this tag (in cents)", alias="amountCollected")
    __properties: ClassVar[List[str]] = ["id", "name", "formCount", "organizationCount", "tagType", "tagParent", "amountCollected"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsTagsInternalTagModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tag_parent
        if self.tag_parent:
            _dict['tagParent'] = self.tag_parent.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if form_count (nullable) is None
        # and model_fields_set contains the field
        if self.form_count is None and "form_count" in self.model_fields_set:
            _dict['formCount'] = None

        # set to None if organization_count (nullable) is None
        # and model_fields_set contains the field
        if self.organization_count is None and "organization_count" in self.model_fields_set:
            _dict['organizationCount'] = None

        # set to None if amount_collected (nullable) is None
        # and model_fields_set contains the field
        if self.amount_collected is None and "amount_collected" in self.model_fields_set:
            _dict['amountCollected'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsTagsInternalTagModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "formCount": obj.get("formCount"),
            "organizationCount": obj.get("organizationCount"),
            "tagType": obj.get("tagType"),
            "tagParent": HelloAssoApiV5ModelsTagsInternalTagModel.from_dict(obj["tagParent"]) if obj.get("tagParent") is not None else None,
            "amountCollected": obj.get("amountCollected")
        })
        return _obj

# TODO: Rewrite to not use raise_errors
HelloAssoApiV5ModelsTagsInternalTagModel.model_rebuild(raise_errors=False)

