# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_common_document_model import HelloAssoApiV5ModelsCommonDocumentModel
from helloasso_python.models.hello_asso_api_v5_models_common_meta_model import HelloAssoApiV5ModelsCommonMetaModel
from helloasso_python.models.hello_asso_api_v5_models_enums_form_state import HelloAssoApiV5ModelsEnumsFormState
from helloasso_python.models.hello_asso_api_v5_models_enums_form_type import HelloAssoApiV5ModelsEnumsFormType
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsFormsFormLightModel(BaseModel):
    """
    FormLightModel class
    """ # noqa: E501
    banner: Optional[HelloAssoApiV5ModelsCommonDocumentModel] = None
    currency: Optional[StrictStr] = Field(default=None, description="Currency")
    description: Optional[StrictStr] = Field(default=None, description="Short description (one line)")
    start_date: Optional[datetime] = Field(default=None, description="The datetime of the activity start", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="The datetime of the activity end", alias="endDate")
    logo: Optional[HelloAssoApiV5ModelsCommonDocumentModel] = None
    meta: Optional[HelloAssoApiV5ModelsCommonMetaModel] = None
    state: Optional[HelloAssoApiV5ModelsEnumsFormState] = None
    title: Optional[StrictStr] = Field(default=None, description="Title")
    private_title: Optional[StrictStr] = Field(default=None, description="Private Title", alias="privateTitle")
    widget_button_url: Optional[StrictStr] = Field(default=None, description="Url of the widget button", alias="widgetButtonUrl")
    widget_full_url: Optional[StrictStr] = Field(default=None, description="Url of the form widget", alias="widgetFullUrl")
    widget_vignette_horizontal_url: Optional[StrictStr] = Field(default=None, description="Url of the horizontal vignette widget", alias="widgetVignetteHorizontalUrl")
    widget_vignette_vertical_url: Optional[StrictStr] = Field(default=None, description="Url of the vertical vignette widget", alias="widgetVignetteVerticalUrl")
    widget_counter_url: Optional[StrictStr] = Field(default=None, description="Url of the counter widget", alias="widgetCounterUrl")
    form_slug: Optional[StrictStr] = Field(default=None, description="The form slug", alias="formSlug")
    form_type: Optional[HelloAssoApiV5ModelsEnumsFormType] = Field(default=None, alias="formType")
    url: Optional[StrictStr] = Field(default=None, description="The form url")
    organization_slug: Optional[StrictStr] = Field(default=None, description="The organization slug", alias="organizationSlug")
    __properties: ClassVar[List[str]] = ["banner", "currency", "description", "startDate", "endDate", "logo", "meta", "state", "title", "privateTitle", "widgetButtonUrl", "widgetFullUrl", "widgetVignetteHorizontalUrl", "widgetVignetteVerticalUrl", "widgetCounterUrl", "formSlug", "formType", "url", "organizationSlug"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsFormLightModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of banner
        if self.banner:
            _dict['banner'] = self.banner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logo
        if self.logo:
            _dict['logo'] = self.logo.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # set to None if currency (nullable) is None
        # and model_fields_set contains the field
        if self.currency is None and "currency" in self.model_fields_set:
            _dict['currency'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if start_date (nullable) is None
        # and model_fields_set contains the field
        if self.start_date is None and "start_date" in self.model_fields_set:
            _dict['startDate'] = None

        # set to None if end_date (nullable) is None
        # and model_fields_set contains the field
        if self.end_date is None and "end_date" in self.model_fields_set:
            _dict['endDate'] = None

        # set to None if title (nullable) is None
        # and model_fields_set contains the field
        if self.title is None and "title" in self.model_fields_set:
            _dict['title'] = None

        # set to None if private_title (nullable) is None
        # and model_fields_set contains the field
        if self.private_title is None and "private_title" in self.model_fields_set:
            _dict['privateTitle'] = None

        # set to None if widget_button_url (nullable) is None
        # and model_fields_set contains the field
        if self.widget_button_url is None and "widget_button_url" in self.model_fields_set:
            _dict['widgetButtonUrl'] = None

        # set to None if widget_full_url (nullable) is None
        # and model_fields_set contains the field
        if self.widget_full_url is None and "widget_full_url" in self.model_fields_set:
            _dict['widgetFullUrl'] = None

        # set to None if widget_vignette_horizontal_url (nullable) is None
        # and model_fields_set contains the field
        if self.widget_vignette_horizontal_url is None and "widget_vignette_horizontal_url" in self.model_fields_set:
            _dict['widgetVignetteHorizontalUrl'] = None

        # set to None if widget_vignette_vertical_url (nullable) is None
        # and model_fields_set contains the field
        if self.widget_vignette_vertical_url is None and "widget_vignette_vertical_url" in self.model_fields_set:
            _dict['widgetVignetteVerticalUrl'] = None

        # set to None if widget_counter_url (nullable) is None
        # and model_fields_set contains the field
        if self.widget_counter_url is None and "widget_counter_url" in self.model_fields_set:
            _dict['widgetCounterUrl'] = None

        # set to None if form_slug (nullable) is None
        # and model_fields_set contains the field
        if self.form_slug is None and "form_slug" in self.model_fields_set:
            _dict['formSlug'] = None

        # set to None if url (nullable) is None
        # and model_fields_set contains the field
        if self.url is None and "url" in self.model_fields_set:
            _dict['url'] = None

        # set to None if organization_slug (nullable) is None
        # and model_fields_set contains the field
        if self.organization_slug is None and "organization_slug" in self.model_fields_set:
            _dict['organizationSlug'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsFormsFormLightModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "banner": HelloAssoApiV5ModelsCommonDocumentModel.from_dict(obj["banner"]) if obj.get("banner") is not None else None,
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "logo": HelloAssoApiV5ModelsCommonDocumentModel.from_dict(obj["logo"]) if obj.get("logo") is not None else None,
            "meta": HelloAssoApiV5ModelsCommonMetaModel.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "state": obj.get("state"),
            "title": obj.get("title"),
            "privateTitle": obj.get("privateTitle"),
            "widgetButtonUrl": obj.get("widgetButtonUrl"),
            "widgetFullUrl": obj.get("widgetFullUrl"),
            "widgetVignetteHorizontalUrl": obj.get("widgetVignetteHorizontalUrl"),
            "widgetVignetteVerticalUrl": obj.get("widgetVignetteVerticalUrl"),
            "widgetCounterUrl": obj.get("widgetCounterUrl"),
            "formSlug": obj.get("formSlug"),
            "formType": obj.get("formType"),
            "url": obj.get("url"),
            "organizationSlug": obj.get("organizationSlug")
        })
        return _obj


