# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsShareItem(BaseModel):
    """
    HelloAssoApiV5ModelsStatisticsShareItem
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Id of the order item")
    share_amount: Optional[StrictInt] = Field(default=None, description="Amount of the payment assigned to the item and its options (in cents)", alias="shareAmount")
    share_item_amount: Optional[StrictInt] = Field(default=None, description="Amount of the item payed on this payment term (in cents)", alias="shareItemAmount")
    share_options_amount: Optional[StrictInt] = Field(default=None, description="Amount of all extra options linked to this item and payed on this payment (in cents)", alias="shareOptionsAmount")
    __properties: ClassVar[List[str]] = ["id", "shareAmount", "shareItemAmount", "shareOptionsAmount"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsShareItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if share_options_amount (nullable) is None
        # and model_fields_set contains the field
        if self.share_options_amount is None and "share_options_amount" in self.model_fields_set:
            _dict['shareOptionsAmount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsShareItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "shareAmount": obj.get("shareAmount"),
            "shareItemAmount": obj.get("shareItemAmount"),
            "shareOptionsAmount": obj.get("shareOptionsAmount")
        })
        return _obj


