# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_common_meta_model import HelloAssoApiV5ModelsCommonMetaModel
from helloasso_python.models.hello_asso_api_v5_models_enums_form_type import HelloAssoApiV5ModelsEnumsFormType
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_cash_out_state import HelloAssoApiV5ModelsEnumsPaymentCashOutState
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_means import HelloAssoApiV5ModelsEnumsPaymentMeans
from helloasso_python.models.hello_asso_api_v5_models_enums_payment_state import HelloAssoApiV5ModelsEnumsPaymentState
from helloasso_python.models.hello_asso_api_v5_models_statistics_refund_operation_light_model import HelloAssoApiV5ModelsStatisticsRefundOperationLightModel
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsPaymentPublicPaymentModel(BaseModel):
    """
    HelloAssoApiV5ModelsPaymentPublicPaymentModel
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The payment id")
    organization_id: Optional[StrictInt] = Field(default=None, description="The Organization id, which the payment was made to", alias="organizationId")
    form_id: Optional[StrictInt] = Field(default=None, description="The form id where the payment was made. Used with FormType", alias="formId")
    form_type: Optional[HelloAssoApiV5ModelsEnumsFormType] = Field(default=None, alias="formType")
    amount: Optional[StrictInt] = Field(default=None, description="Amount")
    means_payment: Optional[HelloAssoApiV5ModelsEnumsPaymentMeans] = Field(default=None, alias="meansPayment")
    cash_out_state: Optional[HelloAssoApiV5ModelsEnumsPaymentCashOutState] = Field(default=None, alias="cashOutState")
    var_date: Optional[datetime] = Field(default=None, description="The payment Date.", alias="date")
    authorization_date: Optional[datetime] = Field(default=None, description="If the payment is authorized, this is the date of authorization", alias="authorizationDate")
    order_date: Optional[datetime] = Field(default=None, description="Date at which the Order was placed.  Important for monthly payments or scheduled payments.", alias="orderDate")
    order_id: Optional[StrictInt] = Field(default=None, description="The id of the order", alias="orderId")
    fiscal_receipt_generated: Optional[StrictBool] = Field(default=None, description="Whether a Fiscal receipt document has been generated for this payment or not.", alias="fiscalReceiptGenerated")
    payer_first_name: Optional[StrictStr] = Field(default=None, description="The inputted payer first name, might differs from User firstname, from linked user Id", alias="payerFirstName")
    payer_last_name: Optional[StrictStr] = Field(default=None, description="The inputted payer last name,  might differs from User lastname, from linked user Id", alias="payerLastName")
    status: Optional[HelloAssoApiV5ModelsEnumsPaymentState] = None
    user_id: Optional[StrictInt] = Field(default=None, description="The user id who initiated the payment", alias="userId")
    user_first_name: Optional[StrictStr] = Field(default=None, description="The name of the user who initiated the payment. May differ from PayerFirstName", alias="userFirstName")
    user_last_name: Optional[StrictStr] = Field(default=None, description="The name of the user who initiated the payment. May differ from PayerLastName", alias="userLastName")
    user_email: Optional[StrictStr] = Field(default=None, description="The email of the user account who initiated the payment.", alias="userEmail")
    provider_title: Optional[StrictStr] = Field(default=None, description="name of the provider", alias="providerTitle")
    installment_number: Optional[StrictInt] = Field(default=None, description="Indicates the payment number (useful in the case of an order comprising payments with installments)  Starting with 1.", alias="installmentNumber")
    meta: Optional[HelloAssoApiV5ModelsCommonMetaModel] = None
    refund_operations: Optional[List[HelloAssoApiV5ModelsStatisticsRefundOperationLightModel]] = Field(default=None, description="The refund operations for the specific payment.", alias="refundOperations")
    __properties: ClassVar[List[str]] = ["id", "organizationId", "formId", "formType", "amount", "meansPayment", "cashOutState", "date", "authorizationDate", "orderDate", "orderId", "fiscalReceiptGenerated", "payerFirstName", "payerLastName", "status", "userId", "userFirstName", "userLastName", "userEmail", "providerTitle", "installmentNumber", "meta", "refundOperations"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPaymentPublicPaymentModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in refund_operations (list)
        _items = []
        if self.refund_operations:
            for _item_refund_operations in self.refund_operations:
                if _item_refund_operations:
                    _items.append(_item_refund_operations.to_dict())
            _dict['refundOperations'] = _items
        # set to None if form_id (nullable) is None
        # and model_fields_set contains the field
        if self.form_id is None and "form_id" in self.model_fields_set:
            _dict['formId'] = None

        # set to None if authorization_date (nullable) is None
        # and model_fields_set contains the field
        if self.authorization_date is None and "authorization_date" in self.model_fields_set:
            _dict['authorizationDate'] = None

        # set to None if payer_first_name (nullable) is None
        # and model_fields_set contains the field
        if self.payer_first_name is None and "payer_first_name" in self.model_fields_set:
            _dict['payerFirstName'] = None

        # set to None if payer_last_name (nullable) is None
        # and model_fields_set contains the field
        if self.payer_last_name is None and "payer_last_name" in self.model_fields_set:
            _dict['payerLastName'] = None

        # set to None if user_id (nullable) is None
        # and model_fields_set contains the field
        if self.user_id is None and "user_id" in self.model_fields_set:
            _dict['userId'] = None

        # set to None if user_first_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_first_name is None and "user_first_name" in self.model_fields_set:
            _dict['userFirstName'] = None

        # set to None if user_last_name (nullable) is None
        # and model_fields_set contains the field
        if self.user_last_name is None and "user_last_name" in self.model_fields_set:
            _dict['userLastName'] = None

        # set to None if user_email (nullable) is None
        # and model_fields_set contains the field
        if self.user_email is None and "user_email" in self.model_fields_set:
            _dict['userEmail'] = None

        # set to None if provider_title (nullable) is None
        # and model_fields_set contains the field
        if self.provider_title is None and "provider_title" in self.model_fields_set:
            _dict['providerTitle'] = None

        # set to None if installment_number (nullable) is None
        # and model_fields_set contains the field
        if self.installment_number is None and "installment_number" in self.model_fields_set:
            _dict['installmentNumber'] = None

        # set to None if refund_operations (nullable) is None
        # and model_fields_set contains the field
        if self.refund_operations is None and "refund_operations" in self.model_fields_set:
            _dict['refundOperations'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsPaymentPublicPaymentModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "formId": obj.get("formId"),
            "formType": obj.get("formType"),
            "amount": obj.get("amount"),
            "meansPayment": obj.get("meansPayment"),
            "cashOutState": obj.get("cashOutState"),
            "date": obj.get("date"),
            "authorizationDate": obj.get("authorizationDate"),
            "orderDate": obj.get("orderDate"),
            "orderId": obj.get("orderId"),
            "fiscalReceiptGenerated": obj.get("fiscalReceiptGenerated"),
            "payerFirstName": obj.get("payerFirstName"),
            "payerLastName": obj.get("payerLastName"),
            "status": obj.get("status"),
            "userId": obj.get("userId"),
            "userFirstName": obj.get("userFirstName"),
            "userLastName": obj.get("userLastName"),
            "userEmail": obj.get("userEmail"),
            "providerTitle": obj.get("providerTitle"),
            "installmentNumber": obj.get("installmentNumber"),
            "meta": HelloAssoApiV5ModelsCommonMetaModel.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "refundOperations": [HelloAssoApiV5ModelsStatisticsRefundOperationLightModel.from_dict(_item) for _item in obj["refundOperations"]] if obj.get("refundOperations") is not None else None
        })
        return _obj


