# coding: utf-8

"""
    HelloAsso API

    HelloAsso auto-generated SDK

    The version of the OpenAPI document: public
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from helloasso_python.models.hello_asso_api_v5_models_enums_item_state import HelloAssoApiV5ModelsEnumsItemState
from helloasso_python.models.hello_asso_api_v5_models_enums_tier_type import HelloAssoApiV5ModelsEnumsTierType
from typing import Optional, Set
from typing_extensions import Self

class HelloAssoApiV5ModelsStatisticsPaymentItem(BaseModel):
    """
    Item linked to a payment
    """ # noqa: E501
    share_amount: Optional[StrictInt] = Field(default=None, description="Amount of the payment assigned to the item and its options (in cents)", alias="shareAmount")
    share_item_amount: Optional[StrictInt] = Field(default=None, description="Amount of the item payed on this payment term (in cents)", alias="shareItemAmount")
    share_options_amount: Optional[StrictInt] = Field(default=None, description="Amount of all extra options linked to this item and payed on this payment (in cents)", alias="shareOptionsAmount")
    id: Optional[StrictInt] = Field(default=None, description="ID of the Item")
    amount: Optional[StrictInt] = Field(default=None, description="Total item Price in cents (after discount without extra options)")
    type: Optional[HelloAssoApiV5ModelsEnumsTierType] = None
    initial_amount: Optional[StrictInt] = Field(default=None, description="The raw amount (without reduction)", alias="initialAmount")
    state: Optional[HelloAssoApiV5ModelsEnumsItemState] = None
    name: Optional[StrictStr] = Field(default=None, description="Name of the item paid (relevant for checkout forms)")
    __properties: ClassVar[List[str]] = ["shareAmount", "shareItemAmount", "shareOptionsAmount", "id", "amount", "type", "initialAmount", "state", "name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsPaymentItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if share_options_amount (nullable) is None
        # and model_fields_set contains the field
        if self.share_options_amount is None and "share_options_amount" in self.model_fields_set:
            _dict['shareOptionsAmount'] = None

        # set to None if initial_amount (nullable) is None
        # and model_fields_set contains the field
        if self.initial_amount is None and "initial_amount" in self.model_fields_set:
            _dict['initialAmount'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HelloAssoApiV5ModelsStatisticsPaymentItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "shareAmount": obj.get("shareAmount"),
            "shareItemAmount": obj.get("shareItemAmount"),
            "shareOptionsAmount": obj.get("shareOptionsAmount"),
            "id": obj.get("id"),
            "amount": obj.get("amount"),
            "type": obj.get("type"),
            "initialAmount": obj.get("initialAmount"),
            "state": obj.get("state"),
            "name": obj.get("name")
        })
        return _obj


